/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.solver.ASolution;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.OccurrenceIndex;
import mb.scopegraph.pepm16.terms.Scope;

public final class Solution
extends ASolution
implements Serializable {
    private final SolverConfig config;
    private final IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties;
    private final IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph;
    private final IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache;
    private final IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties;
    private final Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations;
    private final IUnifier.Immutable unifier;
    private final ISymbolicConstraints symbolic;
    private final IMessages.Immutable messages;
    private final Set.Immutable<IConstraint> constraints;
    private volatile transient long lazyInitBitmap;
    private static final long AST_DECLS_LAZY_INIT_BIT = 1L;
    private transient SetMultimap.Immutable<OccurrenceIndex, Occurrence> astDecls;
    private static final long AST_REFS_LAZY_INIT_BIT = 2L;
    private transient SetMultimap.Immutable<OccurrenceIndex, Occurrence> astRefs;
    private static final long serialVersionUID = 42L;

    private Solution(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties, Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations, IUnifier.Immutable unifier, ISymbolicConstraints symbolic, IMessages.Immutable messages, Set.Immutable<IConstraint> constraints) {
        this.config = Objects.requireNonNull(config, "config");
        this.astProperties = Objects.requireNonNull(astProperties, "astProperties");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.declProperties = Objects.requireNonNull(declProperties, "declProperties");
        this.relations = Objects.requireNonNull(relations, "relations");
        this.unifier = Objects.requireNonNull(unifier, "unifier");
        this.symbolic = Objects.requireNonNull(symbolic, "symbolic");
        this.messages = Objects.requireNonNull(messages, "messages");
        this.constraints = Objects.requireNonNull(constraints, "constraints");
        this.nameResolutionCache = Objects.requireNonNull(super.nameResolutionCache(), "nameResolutionCache");
    }

    private Solution(Builder builder) {
        this.config = builder.config;
        this.astProperties = builder.astProperties;
        this.scopeGraph = builder.scopeGraph;
        this.declProperties = builder.declProperties;
        this.relations = builder.relations;
        this.unifier = builder.unifier;
        this.symbolic = builder.symbolic;
        this.messages = builder.messages;
        this.constraints = builder.constraints;
        this.nameResolutionCache = builder.nameResolutionCache != null ? builder.nameResolutionCache : Objects.requireNonNull(super.nameResolutionCache(), "nameResolutionCache");
    }

    private Solution(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache, IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties, Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations, IUnifier.Immutable unifier, ISymbolicConstraints symbolic, IMessages.Immutable messages, Set.Immutable<IConstraint> constraints) {
        this.config = config;
        this.astProperties = astProperties;
        this.scopeGraph = scopeGraph;
        this.nameResolutionCache = nameResolutionCache;
        this.declProperties = declProperties;
        this.relations = relations;
        this.unifier = unifier;
        this.symbolic = symbolic;
        this.messages = messages;
        this.constraints = constraints;
    }

    @Override
    public SolverConfig config() {
        return this.config;
    }

    @Override
    public IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties() {
        return this.astProperties;
    }

    @Override
    public IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache() {
        return this.nameResolutionCache;
    }

    @Override
    public IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties() {
        return this.declProperties;
    }

    @Override
    public Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations() {
        return this.relations;
    }

    @Override
    public IUnifier.Immutable unifier() {
        return this.unifier;
    }

    @Override
    public ISymbolicConstraints symbolic() {
        return this.symbolic;
    }

    @Override
    public IMessages.Immutable messages() {
        return this.messages;
    }

    @Override
    public Set.Immutable<IConstraint> constraints() {
        return this.constraints;
    }

    public final Solution withConfig(SolverConfig value) {
        if (this.config == value) {
            return this;
        }
        SolverConfig newValue = Objects.requireNonNull(value, "config");
        return new Solution(newValue, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withAstProperties(IProperties.Immutable<TermIndex, ITerm, ITerm> value) {
        if (this.astProperties == value) {
            return this;
        }
        IProperties.Immutable<TermIndex, ITerm, ITerm> newValue = Objects.requireNonNull(value, "astProperties");
        return new Solution(this.config, newValue, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withScopeGraph(IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new Solution(this.config, this.astProperties, newValue, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    public final Solution withNameResolutionCache(IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> value) {
        if (this.nameResolutionCache == value) {
            return this;
        }
        IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> newValue = Objects.requireNonNull(value, "nameResolutionCache");
        return new Solution(this.config, this.astProperties, this.scopeGraph, newValue, this.declProperties, this.relations, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withDeclProperties(IProperties.Immutable<Occurrence, ITerm, ITerm> value) {
        if (this.declProperties == value) {
            return this;
        }
        IProperties.Immutable<Occurrence, ITerm, ITerm> newValue = Objects.requireNonNull(value, "declProperties");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, newValue, this.relations, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withRelations(Map.Immutable<String, IVariantRelation.Immutable<ITerm>> value) {
        if (this.relations == value) {
            return this;
        }
        Map.Immutable<String, IVariantRelation.Immutable<ITerm>> newValue = Objects.requireNonNull(value, "relations");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, newValue, this.unifier, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withUnifier(IUnifier.Immutable value) {
        if (this.unifier == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "unifier");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, newValue, this.symbolic, this.messages, this.constraints);
    }

    @Override
    public final Solution withSymbolic(ISymbolicConstraints value) {
        if (this.symbolic == value) {
            return this;
        }
        ISymbolicConstraints newValue = Objects.requireNonNull(value, "symbolic");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, newValue, this.messages, this.constraints);
    }

    @Override
    public final Solution withMessages(IMessages.Immutable value) {
        if (this.messages == value) {
            return this;
        }
        IMessages.Immutable newValue = Objects.requireNonNull(value, "messages");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, this.symbolic, newValue, this.constraints);
    }

    @Override
    public final Solution withConstraints(Set.Immutable<IConstraint> value) {
        if (this.constraints == value) {
            return this;
        }
        Set.Immutable<IConstraint> newValue = Objects.requireNonNull(value, "constraints");
        return new Solution(this.config, this.astProperties, this.scopeGraph, this.nameResolutionCache, this.declProperties, this.relations, this.unifier, this.symbolic, this.messages, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Solution && this.equalTo(0, (Solution)another);
    }

    private boolean equalTo(int synthetic, Solution another) {
        return this.config.equals(another.config) && this.astProperties.equals(another.astProperties) && this.scopeGraph.equals(another.scopeGraph) && this.nameResolutionCache.equals(another.nameResolutionCache) && this.declProperties.equals(another.declProperties) && this.relations.equals(another.relations) && this.unifier.equals(another.unifier) && this.symbolic.equals(another.symbolic) && this.messages.equals(another.messages) && this.constraints.equals(another.constraints);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.astProperties.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + this.nameResolutionCache.hashCode();
        h += (h << 5) + this.declProperties.hashCode();
        h += (h << 5) + this.relations.hashCode();
        h += (h << 5) + this.unifier.hashCode();
        h += (h << 5) + this.symbolic.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        return h;
    }

    public String toString() {
        return "Solution{config=" + this.config + ", astProperties=" + this.astProperties + ", scopeGraph=" + this.scopeGraph + ", nameResolutionCache=" + this.nameResolutionCache + ", declProperties=" + this.declProperties + ", relations=" + this.relations + ", unifier=" + this.unifier + ", symbolic=" + this.symbolic + ", messages=" + this.messages + ", constraints=" + this.constraints + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetMultimap.Immutable<OccurrenceIndex, Occurrence> astDecls() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Solution solution = this;
            synchronized (solution) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.astDecls = Objects.requireNonNull(super.astDecls(), "astDecls");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.astDecls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetMultimap.Immutable<OccurrenceIndex, Occurrence> astRefs() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Solution solution = this;
            synchronized (solution) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.astRefs = Objects.requireNonNull(super.astRefs(), "astRefs");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.astRefs;
    }

    public static Solution of(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties, Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations, IUnifier.Immutable unifier, ISymbolicConstraints symbolic, IMessages.Immutable messages, Set.Immutable<IConstraint> constraints) {
        return new Solution(config, astProperties, scopeGraph, declProperties, relations, unifier, symbolic, messages, constraints);
    }

    public static Solution copyOf(ASolution instance) {
        if (instance instanceof Solution) {
            return (Solution)instance;
        }
        return Solution.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Solution(Builder builder, Solution solution) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_AST_PROPERTIES = 2L;
        private static final long INIT_BIT_SCOPE_GRAPH = 4L;
        private static final long INIT_BIT_DECL_PROPERTIES = 8L;
        private static final long INIT_BIT_RELATIONS = 16L;
        private static final long INIT_BIT_UNIFIER = 32L;
        private static final long INIT_BIT_SYMBOLIC = 64L;
        private static final long INIT_BIT_MESSAGES = 128L;
        private static final long INIT_BIT_CONSTRAINTS = 256L;
        private long initBits = 511L;
        private SolverConfig config;
        private IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties;
        private IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph;
        private IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache;
        private IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties;
        private Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations;
        private IUnifier.Immutable unifier;
        private ISymbolicConstraints symbolic;
        private IMessages.Immutable messages;
        private Set.Immutable<IConstraint> constraints;

        private Builder() {
        }

        public final Builder from(ISolution instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ASolution instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof ISolution) {
                ISolution instance = (ISolution)object;
                this.symbolic(instance.symbolic());
                this.scopeGraph(instance.scopeGraph());
                this.nameResolutionCache(instance.nameResolutionCache());
                this.unifier(instance.unifier());
                this.astProperties(instance.astProperties());
                this.messages(instance.messages());
                this.relations(instance.relations());
                this.constraints(instance.constraints());
                this.config(instance.config());
                this.declProperties(instance.declProperties());
            }
        }

        public final Builder config(SolverConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder astProperties(IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties) {
            this.astProperties = Objects.requireNonNull(astProperties, "astProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scopeGraph(IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph) {
            this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nameResolutionCache(IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache) {
            this.nameResolutionCache = Objects.requireNonNull(nameResolutionCache, "nameResolutionCache");
            return this;
        }

        public final Builder declProperties(IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties) {
            this.declProperties = Objects.requireNonNull(declProperties, "declProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder relations(Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations) {
            this.relations = Objects.requireNonNull(relations, "relations");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder unifier(IUnifier.Immutable unifier) {
            this.unifier = Objects.requireNonNull(unifier, "unifier");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder symbolic(ISymbolicConstraints symbolic) {
            this.symbolic = Objects.requireNonNull(symbolic, "symbolic");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder messages(IMessages.Immutable messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = Objects.requireNonNull(constraints, "constraints");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public Solution build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Solution(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("astProperties");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scopeGraph");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("declProperties");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("relations");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("unifier");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("symbolic");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("messages");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("constraints");
            }
            return "Cannot build Solution, some of required attributes are not set " + attributes;
        }
    }
}

