/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.ast;

import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.ast.CAstProperty;
import mb.nabl2.constraints.ast.IAstConstraint;
import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ACAstProperty
implements IAstConstraint {
    @Value.Parameter
    public abstract TermIndex getIndex();

    @Value.Parameter
    public abstract ITerm getKey();

    @Value.Parameter
    public abstract ITerm getValue();

    @Override
    @Value.Parameter
    public abstract IMessageInfo getMessageInfo();

    @Value.Check
    public void check() {
        if (!this.getKey().isGround()) {
            throw new IllegalArgumentException("Key is not ground");
        }
    }

    @Override
    public <T> T match(IAstConstraint.Cases<T> cases) {
        return cases.caseProperty((CAstProperty)this);
    }

    @Override
    public <T> T match(IConstraint.Cases<T> cases) {
        return cases.caseAst(this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(IAstConstraint.CheckedCases<T, E> cases) throws E {
        return cases.caseProperty((CAstProperty)this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(IConstraint.CheckedCases<T, E> cases) throws E {
        return cases.caseAst(this);
    }

    @Override
    public IMessageContent pp() {
        return MessageContent.builder().append(this.getIndex()).append(".").append(this.getKey()).append(" := ").append(this.getValue()).build();
    }

    public String toString() {
        return this.pp().toString();
    }
}

