/*
 * Decompiled with CFR 0.152.
 */
package mb.jsglr.shared;

import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokenizer;
import mb.jsglr.shared.LabelInfo;
import mb.jsglr.shared.LineStartOffsetList;
import mb.jsglr.shared.ProductionAttributeReader;
import mb.jsglr.shared.Token;
import mb.jsglr.shared.TokenKindManager;

public abstract class AbstractTokenizer
implements ITokenizer {
    private static final long serialVersionUID = 7697367149430201531L;
    private final TokenKindManager manager = new TokenKindManager();
    private boolean isAmbiguous;
    private final String filename;
    private final String input;
    private LineStartOffsetList lineStartOffsets;
    private boolean isSyntaxCorrect = true;

    public AbstractTokenizer(String input, String filename) {
        this.input = input;
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public boolean isSyntaxCorrect() {
        return this.isSyntaxCorrect;
    }

    @Override
    public void setSyntaxCorrect(boolean isSyntaxCorrect) {
        this.isSyntaxCorrect = isSyntaxCorrect;
    }

    private LineStartOffsetList getLineStartOffsets() {
        if (this.lineStartOffsets == null) {
            this.lineStartOffsets = new LineStartOffsetList(this.getInput());
        }
        return this.lineStartOffsets;
    }

    @Override
    public IToken makeToken(int endOffset, LabelInfo label, boolean allowEmptyToken) {
        return this.makeToken(endOffset, this.manager.getTokenKind(label), allowEmptyToken);
    }

    @Override
    public boolean isAmbiguous() {
        return this.isAmbiguous;
    }

    @Override
    public void setAmbiguous(boolean isAmbiguous) {
        this.isAmbiguous = isAmbiguous;
    }

    @Override
    public int getLineAtOffset(int offset) {
        return this.getTokenAtOffset(offset).getLine();
    }

    @Override
    public void markPossibleSyntaxError(LabelInfo label, IToken prevToken, int endOffset, ProductionAttributeReader prodReader) {
        if (label.isRecover() || label.isReject() || label.getDeprecationMessage() != null || label.isCompletion()) {
            IToken first;
            IToken last;
            if (prodReader.isIgnoredUnspecifiedRecoverySort(label.getSort())) {
                return;
            }
            if (this.isSyntaxCorrect) {
                boolean bl = this.isSyntaxCorrect = label.getDeprecationMessage() != null;
            }
            if (prevToken == this.currentToken()) {
                first = last = this.makeToken(endOffset, IToken.Kind.TK_ERROR, true);
            } else {
                first = prevToken.getTokenAfter();
                if (first != this.currentToken() && first.getKind() == IToken.Kind.TK_LAYOUT) {
                    first = AbstractTokenizer.findRightMostLayoutToken(first);
                }
                if (first != this.currentToken() && first.getKind() == IToken.Kind.TK_LAYOUT) {
                    first = first.getTokenAfter();
                }
                last = this.currentToken();
            }
            if (first.getStartOffset() - 1 == last.getEndOffset() && (first = (last = AbstractTokenizer.findLeftMostLayoutToken(first))).getKind() == IToken.Kind.TK_LAYOUT) {
                first = last = last.getTokenBefore();
            }
            String tokenText = this.makeTokenText(first, last);
            if (label.isCompletion()) {
                if (last.getKind() == IToken.Kind.TK_LAYOUT && (last = AbstractTokenizer.findLeftMostLayoutToken(last)).getKind() == IToken.Kind.TK_LAYOUT) {
                    last = last.getTokenBefore();
                }
                String completionText = this.makeTokenText(first, last);
                this.setErrorMessage(first, last, "Syntax error, incomplete construct: '" + completionText + "'");
            } else if (label.isReject() || prodReader.isWaterConstructor(label.getConstructor())) {
                this.setErrorMessage(first, last, "Syntax error, not expected here: '" + tokenText + "'");
            } else if (prodReader.isInsertEndConstructor(label.getConstructor())) {
                this.setErrorMessage(first, last, "Syntax error, unterminated construct");
            } else if (prodReader.isInsertConstructor(label.getConstructor()) || prodReader.isInsertOpenQuoteSort(label.getSort())) {
                this.setErrorMessage(first, last, "Syntax error, expected: " + prodReader.getSyntaxErrorExpectedInsertion(label));
            } else if (label.getDeprecationMessage() != null) {
                this.setErrorMessage(first, last, "Warning: " + label.getDeprecationMessage());
            } else {
                this.setErrorMessage(first, last, "Syntax error: '" + tokenText + "'");
            }
        }
    }

    private String makeTokenText(IToken first, IToken last) {
        String tokenText = this.toString(first, last);
        if (tokenText.length() > 40) {
            tokenText = String.valueOf(tokenText.substring(0, 40)) + "...";
        }
        return tokenText;
    }

    protected abstract void setErrorMessage(IToken var1, IToken var2, String var3);

    @Override
    public final int getEndLine() {
        return this.getTokenCount() == 0 ? 1 : this.getTokenAt(this.getTokenCount() - 1).getLine();
    }

    @Override
    public final int getEndColumn() {
        return this.getTokenCount() == 0 ? 1 : this.getTokenAt(this.getTokenCount() - 1).getColumn();
    }

    @Override
    public String toString(IToken left, IToken right) {
        int startOffset = left.getStartOffset();
        int endOffset = right.getEndOffset();
        return this.toString(startOffset, endOffset);
    }

    @Override
    public String toString(int startOffset, int endOffset) {
        return this.getInput() == null ? null : this.getInput().substring(startOffset, endOffset + 1);
    }

    public static boolean isErrorInRange(IToken start, IToken end) {
        ITokenizer tokens = (ITokenizer)start.getTokenizer();
        int i = start.getIndex();
        int max2 = end.getIndex();
        while (i <= max2) {
            Token token = tokens.getTokenAt(i);
            if (token.getError() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IToken findLeftMostLayoutToken(IToken token) {
        if (token == null) {
            return null;
        }
        ITokenizer tokens = (ITokenizer)token.getTokenizer();
        int i = token.getIndex() - 1;
        while (i >= 0) {
            Token neighbour = tokens.getTokenAt(i);
            switch (neighbour.getKind()) {
                case TK_LAYOUT: 
                case TK_ERROR: 
                case TK_ERROR_KEYWORD: 
                case TK_ERROR_LAYOUT: {
                    break;
                }
                default: {
                    return token;
                }
            }
            token = neighbour;
            --i;
        }
        return token;
    }

    public static IToken findRightMostLayoutToken(IToken token) {
        if (token == null) {
            return null;
        }
        ITokenizer tokens = (ITokenizer)token.getTokenizer();
        int i = token.getIndex() + 1;
        int count = tokens.getTokenCount();
        while (i < count) {
            Token neighbour = tokens.getTokenAt(i);
            switch (neighbour.getKind()) {
                case TK_LAYOUT: 
                case TK_ERROR: 
                case TK_ERROR_KEYWORD: 
                case TK_ERROR_LAYOUT: {
                    break;
                }
                default: {
                    return token;
                }
            }
            token = neighbour;
            ++i;
        }
        return token;
    }

    public static IToken findLeftMostTokenOnSameLine(IToken token) {
        if (token == null) {
            return null;
        }
        int line = token.getLine();
        ITokenizer tokens = (ITokenizer)token.getTokenizer();
        int i = token.getIndex() - 1;
        while (i >= 0) {
            Token neighbour = tokens.getTokenAt(i);
            if (neighbour.getLine() != line || i == 0) {
                return tokens.getTokenAt(i + 1);
            }
            --i;
        }
        return token;
    }

    public static IToken findRightMostTokenOnSameLine(IToken token) {
        if (token == null) {
            return null;
        }
        int line = token.getLine();
        ITokenizer tokens = (ITokenizer)token.getTokenizer();
        int i = token.getIndex() + 1;
        int count = tokens.getTokenCount();
        while (i < count) {
            Token neighbour = tokens.getTokenAt(i);
            if (neighbour.getLine() != line || i == count - 1) {
                return tokens.getTokenAt(i - 1);
            }
            ++i;
        }
        return token;
    }

    @Override
    public IToken getErrorTokenOrAdjunct(int offset) {
        if (offset < this.getStartOffset()) {
            return AbstractTokenizer.findReportableErrorToken(this.getTokenAtOffset(offset));
        }
        return this.makeErrorAdjunct(offset);
    }

    private IToken makeErrorAdjunct(int offset) {
        if (offset == this.getInput().length()) {
            return this.makeErrorAdjunctBackwards(offset - 1);
        }
        if (offset > this.getInput().length()) {
            return this.makeErrorAdjunctBackwards(this.getInput().length() - 1);
        }
        int endOffset = offset;
        String input = this.getInput();
        boolean onlySeenWhitespace = AbstractTokenizer.isSpace(input.charAt(endOffset));
        while (endOffset + 1 < this.getInput().length()) {
            char next = input.charAt(endOffset + 1);
            if (onlySeenWhitespace) {
                onlySeenWhitespace = AbstractTokenizer.isSpace(next);
                ++offset;
            } else if (!Character.isLetterOrDigit(next)) break;
            ++endOffset;
        }
        return this.makeAdjunct(offset, endOffset, IToken.Kind.TK_ERROR);
    }

    private IToken makeErrorAdjunctBackwards(int offset) {
        int beginOffset = offset;
        boolean onlySeenWhitespace = true;
        while (offset >= this.getInput().length()) {
            --offset;
        }
        String input = this.getInput();
        while (beginOffset > 0) {
            char c = input.charAt(beginOffset - 1);
            boolean isWhitespace = AbstractTokenizer.isSpace(c);
            if (onlySeenWhitespace) {
                onlySeenWhitespace = isWhitespace;
            } else if (isWhitespace) break;
            --beginOffset;
        }
        return this.makeAdjunct(beginOffset, offset, IToken.Kind.TK_ERROR);
    }

    protected final IToken makeAdjunct(int startOffset, int endOffset, IToken.Kind tokenKind) {
        LineStartOffsetList lineStarts = this.getLineStartOffsets();
        int index = lineStarts.getIndex(startOffset);
        int line = lineStarts.getLine(index);
        int column = lineStarts.getColumn(index, startOffset);
        return this.makeAdjunct(startOffset, endOffset, tokenKind, line, column);
    }

    protected IToken makeAdjunct(int startOffset, int endOffset, IToken.Kind tokenKind, int line, int column) {
        IToken nearbyToken = this.getTokenAtOffset(startOffset);
        int fakeIndex = nearbyToken == null ? 0 : nearbyToken.getIndex();
        return new Token(this, this.filename, fakeIndex, line, column, startOffset, endOffset, tokenKind);
    }

    private static IToken findReportableErrorToken(IToken token) {
        ITokenizer tokenizer = (ITokenizer)token.getTokenizer();
        int i = token.getIndex();
        int max2 = tokenizer.getTokenCount();
        while (i < max2) {
            token = tokenizer.getTokenAt(i);
            if (token.getKind() == IToken.Kind.TK_EOF) break;
            if (token.getLength() != 0 && token.getKind() != IToken.Kind.TK_LAYOUT) {
                return token;
            }
            ++i;
        }
        i = token.getIndex();
        while (i > 0) {
            token = tokenizer.getTokenAt(i);
            if (token.getLength() != 0 && token.getKind() != IToken.Kind.TK_LAYOUT) {
                return token;
            }
            --i;
        }
        return token;
    }

    @Override
    public void tryMakeLayoutToken(int endOffset, int lastOffset, LabelInfo label) {
        if (endOffset > lastOffset + 1 && label.isLexLayout()) {
            if (this.getStartOffset() <= lastOffset) {
                this.makeToken(lastOffset, IToken.Kind.TK_LAYOUT, false);
            }
            this.makeToken(endOffset, IToken.Kind.TK_LAYOUT, false);
        } else {
            String sort = label.getSort();
            if ("WATERTOKEN".equals(sort) || "WATERTOKENSEPARATOR".equals(sort)) {
                this.makeWaterToken(endOffset, lastOffset);
            }
        }
    }

    private void makeWaterToken(int endOffset, int lastOffset) {
        if (this.getStartOffset() <= lastOffset) {
            this.makeToken(lastOffset, IToken.Kind.TK_LAYOUT, false);
        }
        String input = this.getInput();
        int wordStart = this.getStartOffset();
        while (wordStart <= endOffset && AbstractTokenizer.isSpace(input.charAt(wordStart))) {
            ++wordStart;
        }
        if (wordStart < endOffset) {
            this.makeToken(wordStart - 1, IToken.Kind.TK_ERROR_LAYOUT, false);
        }
        this.makeToken(endOffset, IToken.Kind.TK_ERROR, false);
    }

    private static boolean isSpace(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\t': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\r': {
                return true;
            }
        }
        return false;
    }
}

