/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.terms;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import mb.flowspec.terms.FSAppl;
import mb.flowspec.terms.FSInt;
import mb.flowspec.terms.FSString;
import mb.flowspec.terms.FSTuple;
import mb.flowspec.terms.TermIndex;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoArrayList;
import org.spoofax.terms.StrategoTerm;

public interface TermIndexed {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$spoofax$interpreter$terms$TermType;

    @Nullable
    public TermIndex termIndex();

    @Nullable
    public static TermIndex filterAnnos(StrategoTerm term) {
        TermIndex termIndex = null;
        IStrategoList annotations = term.getAnnotations();
        if (!annotations.isEmpty()) {
            ArrayList<IStrategoTerm> annos = new ArrayList<IStrategoTerm>(annotations.size());
            for (IStrategoTerm anno : annotations) {
                Optional<TermIndex> index = TermIndex.matchTermIndex(anno);
                if (index.isPresent()) {
                    termIndex = index.get();
                    continue;
                }
                annos.add(anno);
            }
            annotations = new StrategoArrayList(annos.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY));
            term.internalSetAnnotations(annotations);
        }
        return termIndex;
    }

    public static IStrategoTerm addTermIndexToAnnos(ITermFactory tf, IStrategoTerm term) {
        if (!(term instanceof TermIndexed)) {
            return term;
        }
        if (term instanceof TermIndex) {
            return term;
        }
        TermIndex index = ((TermIndexed)((Object)term)).termIndex();
        IStrategoList annotations = term.getAnnotations();
        ArrayList<IStrategoTerm> annos = new ArrayList<IStrategoTerm>(annotations.size() + 1);
        if (index != null) {
            annos.add(index);
        }
        annos.addAll(Arrays.asList(annotations.getAllSubterms()));
        IStrategoTerm[] children = term.getAllSubterms();
        IStrategoList annotations2 = annos.isEmpty() ? AbstractTermFactory.EMPTY_LIST : new StrategoArrayList(annos.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY));
        switch (term.getType()) {
            case APPL: {
                return tf.makeAppl(((IStrategoAppl)term).getConstructor(), TermIndexed.addTermIndexToAnnos(tf, children), annotations2);
            }
            case LIST: {
                return tf.makeList(TermIndexed.addTermIndexToAnnos(tf, children), annotations2);
            }
            case INT: {
                return tf.annotateTerm(tf.makeInt(((IStrategoInt)term).intValue()), annotations2);
            }
            case STRING: {
                return tf.annotateTerm(tf.makeString(((IStrategoString)term).stringValue()), annotations2);
            }
            case TUPLE: {
                return tf.makeTuple(TermIndexed.addTermIndexToAnnos(tf, children), annotations2);
            }
        }
        return term;
    }

    public static IStrategoTerm[] addTermIndexToAnnos(ITermFactory tf, IStrategoTerm[] children) {
        IStrategoTerm[] children2 = new IStrategoTerm[children.length];
        int i = 0;
        while (i < children.length) {
            children2[i] = TermIndexed.addTermIndexToAnnos(tf, children[i]);
            ++i;
        }
        return children2;
    }

    public static IStrategoTerm excludeTermIndexFromEqual(IStrategoTerm term) {
        if (term instanceof TermIndexed) {
            return term;
        }
        switch (term.getType()) {
            case APPL: {
                return new FSAppl(((IStrategoAppl)term).getConstructor(), TermIndexed.excludeTermIndexFromEqual(term.getAllSubterms()), term.getAnnotations());
            }
            case LIST: {
                return new StrategoArrayList(TermIndexed.excludeTermIndexFromEqual(term.getAllSubterms()), term.getAnnotations());
            }
            case INT: {
                return new FSInt(((IStrategoInt)term).intValue(), term.getAnnotations());
            }
            case STRING: {
                return new FSString(((IStrategoString)term).stringValue(), term.getAnnotations());
            }
            case TUPLE: {
                return new FSTuple(TermIndexed.excludeTermIndexFromEqual(term.getAllSubterms()), term.getAnnotations());
            }
        }
        return term;
    }

    public static IStrategoTerm[] excludeTermIndexFromEqual(IStrategoTerm[] children) {
        IStrategoTerm[] children2 = new IStrategoTerm[children.length];
        int i = 0;
        while (i < children.length) {
            children2[i] = TermIndexed.excludeTermIndexFromEqual(children[i]);
            ++i;
        }
        return children2;
    }
}

