/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.solver;

import java.util.Arrays;
import java.util.Objects;
import mb.flowspec.runtime.solver.Type;
import mb.flowspec.runtime.solver.UserType;

public final class ImmutableUserType
extends UserType {
    private final String name;
    private final Type[] params;
    private final transient int hashCode;

    private ImmutableUserType(String name, Type[] params) {
        this.name = Objects.requireNonNull(name, "name");
        this.params = (Type[])params.clone();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableUserType(ImmutableUserType original, String name, Type[] params) {
        this.name = name;
        this.params = params;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type[] params() {
        return (Type[])this.params.clone();
    }

    public final ImmutableUserType withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableUserType(this, newValue, this.params);
    }

    public final ImmutableUserType withParams(Type ... elements) {
        Type[] newValue = (Type[])elements.clone();
        return new ImmutableUserType(this, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserType && this.equalTo(0, (ImmutableUserType)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && Arrays.equals(this.params, another.params);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Arrays.hashCode(this.params);
        return h;
    }

    public String toString() {
        return "UserType{name=" + this.name + ", params=" + Arrays.toString(this.params) + "}";
    }

    public static ImmutableUserType of(String name, Type[] params) {
        return new ImmutableUserType(name, params);
    }

    public static ImmutableUserType copyOf(UserType instance) {
        if (instance instanceof ImmutableUserType) {
            return (ImmutableUserType)instance;
        }
        return ImmutableUserType.of(instance.name(), instance.params());
    }
}

