/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.solver;

import java.util.Objects;
import mb.flowspec.runtime.solver.SetType;
import mb.flowspec.runtime.solver.Type;

public final class ImmutableSetType
extends SetType {
    private final Type key;
    private final transient int hashCode;

    private ImmutableSetType(Type key) {
        this.key = Objects.requireNonNull(key, "key");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableSetType(ImmutableSetType original, Type key) {
        this.key = key;
        this.hashCode = this.computeHashCode();
    }

    @Override
    Type key() {
        return this.key;
    }

    public final ImmutableSetType withKey(Type value) {
        if (this.key == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "key");
        return new ImmutableSetType(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetType && this.equalTo(0, (ImmutableSetType)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals(another.key);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        return h;
    }

    public String toString() {
        return "SetType{key=" + this.key + "}";
    }

    public static ImmutableSetType of(Type key) {
        return new ImmutableSetType(key);
    }

    public static ImmutableSetType copyOf(SetType instance) {
        if (instance instanceof ImmutableSetType) {
            return (ImmutableSetType)instance;
        }
        return ImmutableSetType.of(instance.key());
    }
}

