/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.lattice;

import java.util.Optional;
import java.util.Set;
import mb.flowspec.runtime.lattice.Lattice;

public interface CompleteLattice<E>
extends Lattice<E> {
    public E top();

    public E bottom();

    public E glb(E var1, E var2);

    public E lub(E var1, E var2);

    @Override
    default public Optional<E> partial_glb(E one, E other) {
        return Optional.of(this.glb(one, other));
    }

    @Override
    default public Optional<E> partial_lub(E one, E other) {
        return Optional.of(this.lub(one, other));
    }

    default public E glb(Set<E> elements) {
        return elements.stream().reduce(this.top(), this::glb);
    }

    default public E lub(Set<E> elements) {
        return elements.stream().reduce(this.bottom(), this::lub);
    }

    @Override
    default public boolean leq(E one, E other) {
        return this.lub(one, other).equals(other);
    }

    default public boolean nleq(E one, E other) {
        return !this.leq(one, other);
    }

    @Override
    default public boolean geq(E one, E other) {
        return this.leq(other, one);
    }

    default public CompleteLattice<E> flip() {
        return new Flipped(this);
    }

    public static final class Flipped
    implements CompleteLattice {
        public final CompleteLattice wrapped;

        Flipped(CompleteLattice wrapped) {
            this.wrapped = wrapped;
        }

        public Object top() {
            return this.wrapped.bottom();
        }

        public Object bottom() {
            return this.wrapped.top();
        }

        public Object glb(Object one, Object other) {
            return this.wrapped.lub(one, other);
        }

        public Object lub(Object one, Object other) {
            return this.wrapped.glb(one, other);
        }

        @Override
        public boolean leq(Object one, Object other) {
            return this.wrapped.geq(one, other);
        }

        @Override
        public boolean geq(Object one, Object other) {
            return this.wrapped.leq(other, one);
        }
    }
}

