/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.table;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.graphviz.formatter.Table;
import oracle.pgx.graphviz.formatter.TableException;

public class ResultSetTable
implements Table {
    @Nonnull
    private final ResultSet rs;
    @Nonnull
    private final List<String> header;

    public ResultSetTable(@Nonnull ResultSet rs, @Nonnull List<String> header) {
        this.rs = rs;
        this.header = header;
    }

    @Nonnull
    public List<String> getHeader() {
        return this.header;
    }

    @Nonnull
    public Iterable<List<Object>> getRows() {
        try {
            this.rs.beforeFirst();
        }
        catch (PgqlException e) {
            throw new RuntimeException(e);
        }
        return () -> new Iterator<List<Object>>(){
            @Nullable
            Boolean hasNext = null;
            int numCols = ResultSetTable.this.getHeader().size();

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    try {
                        this.hasNext = ResultSetTable.this.rs.next();
                    }
                    catch (PgqlException e) {
                        this.hasNext = false;
                    }
                }
                return this.hasNext;
            }

            @Override
            @Nonnull
            public List<Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = null;
                return IntStream.range(1, this.numCols + 1).mapToObj(idx -> {
                    try {
                        return ResultSetTable.this.rs.getObject(idx);
                    }
                    catch (PgqlException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            }
        };
    }

    public boolean isResultSetClosed() {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }

    public int getRow() {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }

    public void closeResultSet() throws TableException {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (PgqlException e) {
                throw new TableException((Throwable)e);
            }
        }
    }
}

