# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
import uuid

from .. import models


class ComputeNodeOperations(object):
    """ComputeNodeOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def add_user(
            self, pool_id, node_id, user, compute_node_add_user_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a user account to the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the machine on which you want to create a
         user account.
        :type node_id: str
        :param user: The user account to be created.
        :type user: :class:`ComputeNodeUser
         <azure.batch.models.ComputeNodeUser>`
        :param compute_node_add_user_options: Additional parameters for the
         operation
        :type compute_node_add_user_options:
         :class:`ComputeNodeAddUserOptions <azure.batch.models.ComputeNodeAddUserOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_add_user_options is not None:
            timeout = compute_node_add_user_options.timeout
        client_request_id = None
        if compute_node_add_user_options is not None:
            client_request_id = compute_node_add_user_options.client_request_id
        return_client_request_id = None
        if compute_node_add_user_options is not None:
            return_client_request_id = compute_node_add_user_options.return_client_request_id
        ocp_date = None
        if compute_node_add_user_options is not None:
            ocp_date = compute_node_add_user_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/users'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(user, 'ComputeNodeUser')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def delete_user(
            self, pool_id, node_id, user_name, compute_node_delete_user_options=None, custom_headers=None, raw=False, **operation_config):
        """Deletes a user account from the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the machine on which you want to delete a
         user account.
        :type node_id: str
        :param user_name: The name of the user account to delete.
        :type user_name: str
        :param compute_node_delete_user_options: Additional parameters for
         the operation
        :type compute_node_delete_user_options:
         :class:`ComputeNodeDeleteUserOptions
         <azure.batch.models.ComputeNodeDeleteUserOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_delete_user_options is not None:
            timeout = compute_node_delete_user_options.timeout
        client_request_id = None
        if compute_node_delete_user_options is not None:
            client_request_id = compute_node_delete_user_options.client_request_id
        return_client_request_id = None
        if compute_node_delete_user_options is not None:
            return_client_request_id = compute_node_delete_user_options.return_client_request_id
        ocp_date = None
        if compute_node_delete_user_options is not None:
            ocp_date = compute_node_delete_user_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/users/{userName}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str'),
            'userName': self._serialize.url("user_name", user_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response

    def update_user(
            self, pool_id, node_id, user_name, node_update_user_parameter, compute_node_update_user_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the password or expiration time of a user account on the
        specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the machine on which you want to update a
         user account.
        :type node_id: str
        :param user_name: The name of the user account to update.
        :type user_name: str
        :param node_update_user_parameter: The parameters for the request.
        :type node_update_user_parameter: :class:`NodeUpdateUserParameter
         <azure.batch.models.NodeUpdateUserParameter>`
        :param compute_node_update_user_options: Additional parameters for
         the operation
        :type compute_node_update_user_options:
         :class:`ComputeNodeUpdateUserOptions
         <azure.batch.models.ComputeNodeUpdateUserOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_update_user_options is not None:
            timeout = compute_node_update_user_options.timeout
        client_request_id = None
        if compute_node_update_user_options is not None:
            client_request_id = compute_node_update_user_options.client_request_id
        return_client_request_id = None
        if compute_node_update_user_options is not None:
            return_client_request_id = compute_node_update_user_options.return_client_request_id
        ocp_date = None
        if compute_node_update_user_options is not None:
            ocp_date = compute_node_update_user_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/users/{userName}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str'),
            'userName': self._serialize.url("user_name", user_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(node_update_user_parameter, 'NodeUpdateUserParameter')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def get(
            self, pool_id, node_id, compute_node_get_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets information about the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node that you want to get
         information about.
        :type node_id: str
        :param compute_node_get_options: Additional parameters for the
         operation
        :type compute_node_get_options: :class:`ComputeNodeGetOptions
         <azure.batch.models.ComputeNodeGetOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ComputeNode <azure.batch.models.ComputeNode>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        select = None
        if compute_node_get_options is not None:
            select = compute_node_get_options.select
        timeout = None
        if compute_node_get_options is not None:
            timeout = compute_node_get_options.timeout
        client_request_id = None
        if compute_node_get_options is not None:
            client_request_id = compute_node_get_options.client_request_id
        return_client_request_id = None
        if compute_node_get_options is not None:
            return_client_request_id = compute_node_get_options.return_client_request_id
        ocp_date = None
        if compute_node_get_options is not None:
            ocp_date = compute_node_get_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('ComputeNode', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def reboot(
            self, pool_id, node_id, compute_node_reboot_options=None, node_reboot_option=None, custom_headers=None, raw=False, **operation_config):
        """Restarts the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node that you want to restart.
        :type node_id: str
        :param compute_node_reboot_options: Additional parameters for the
         operation
        :type compute_node_reboot_options: :class:`ComputeNodeRebootOptions
         <azure.batch.models.ComputeNodeRebootOptions>`
        :param node_reboot_option: When to reboot the compute node and what
         to do with currently running tasks. The default value is requeue.
         Possible values include: 'requeue', 'terminate', 'taskcompletion',
         'retaineddata'
        :type node_reboot_option: str or :class:`ComputeNodeRebootOption
         <azure.batch.models.ComputeNodeRebootOption>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_reboot_options is not None:
            timeout = compute_node_reboot_options.timeout
        client_request_id = None
        if compute_node_reboot_options is not None:
            client_request_id = compute_node_reboot_options.client_request_id
        return_client_request_id = None
        if compute_node_reboot_options is not None:
            return_client_request_id = compute_node_reboot_options.return_client_request_id
        ocp_date = None
        if compute_node_reboot_options is not None:
            ocp_date = compute_node_reboot_options.ocp_date
        node_reboot_parameter = None
        if node_reboot_option is not None:
            node_reboot_parameter = models.NodeRebootParameter(node_reboot_option=node_reboot_option)

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/reboot'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        if node_reboot_parameter is not None:
            body_content = self._serialize.body(node_reboot_parameter, 'NodeRebootParameter')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def reimage(
            self, pool_id, node_id, compute_node_reimage_options=None, node_reimage_option=None, custom_headers=None, raw=False, **operation_config):
        """Reinstalls the operating system on the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node that you want to restart.
        :type node_id: str
        :param compute_node_reimage_options: Additional parameters for the
         operation
        :type compute_node_reimage_options: :class:`ComputeNodeReimageOptions
         <azure.batch.models.ComputeNodeReimageOptions>`
        :param node_reimage_option: When to reimage the compute node and what
         to do with currently running tasks. The default value is requeue.
         Possible values include: 'requeue', 'terminate', 'taskcompletion',
         'retaineddata'
        :type node_reimage_option: str or :class:`ComputeNodeReimageOption
         <azure.batch.models.ComputeNodeReimageOption>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_reimage_options is not None:
            timeout = compute_node_reimage_options.timeout
        client_request_id = None
        if compute_node_reimage_options is not None:
            client_request_id = compute_node_reimage_options.client_request_id
        return_client_request_id = None
        if compute_node_reimage_options is not None:
            return_client_request_id = compute_node_reimage_options.return_client_request_id
        ocp_date = None
        if compute_node_reimage_options is not None:
            ocp_date = compute_node_reimage_options.ocp_date
        node_reimage_parameter = None
        if node_reimage_option is not None:
            node_reimage_parameter = models.NodeReimageParameter(node_reimage_option=node_reimage_option)

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/reimage'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        if node_reimage_parameter is not None:
            body_content = self._serialize.body(node_reimage_parameter, 'NodeReimageParameter')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def disable_scheduling(
            self, pool_id, node_id, compute_node_disable_scheduling_options=None, node_disable_scheduling_option=None, custom_headers=None, raw=False, **operation_config):
        """Disables task scheduling on the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node on which you want to
         disable task scheduling.
        :type node_id: str
        :param compute_node_disable_scheduling_options: Additional parameters
         for the operation
        :type compute_node_disable_scheduling_options:
         :class:`ComputeNodeDisableSchedulingOptions
         <azure.batch.models.ComputeNodeDisableSchedulingOptions>`
        :param node_disable_scheduling_option: What to do with currently
         running tasks when disable task scheduling on the compute node. The
         default value is requeue. Possible values include: 'requeue',
         'terminate', 'taskcompletion'
        :type node_disable_scheduling_option: str or
         :class:`DisableComputeNodeSchedulingOption
         <azure.batch.models.DisableComputeNodeSchedulingOption>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_disable_scheduling_options is not None:
            timeout = compute_node_disable_scheduling_options.timeout
        client_request_id = None
        if compute_node_disable_scheduling_options is not None:
            client_request_id = compute_node_disable_scheduling_options.client_request_id
        return_client_request_id = None
        if compute_node_disable_scheduling_options is not None:
            return_client_request_id = compute_node_disable_scheduling_options.return_client_request_id
        ocp_date = None
        if compute_node_disable_scheduling_options is not None:
            ocp_date = compute_node_disable_scheduling_options.ocp_date
        node_disable_scheduling_parameter = None
        if node_disable_scheduling_option is not None:
            node_disable_scheduling_parameter = models.NodeDisableSchedulingParameter(node_disable_scheduling_option=node_disable_scheduling_option)

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/disablescheduling'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        if node_disable_scheduling_parameter is not None:
            body_content = self._serialize.body(node_disable_scheduling_parameter, 'NodeDisableSchedulingParameter')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def enable_scheduling(
            self, pool_id, node_id, compute_node_enable_scheduling_options=None, custom_headers=None, raw=False, **operation_config):
        """Enables task scheduling on the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node on which you want to
         enable task scheduling.
        :type node_id: str
        :param compute_node_enable_scheduling_options: Additional parameters
         for the operation
        :type compute_node_enable_scheduling_options:
         :class:`ComputeNodeEnableSchedulingOptions
         <azure.batch.models.ComputeNodeEnableSchedulingOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_enable_scheduling_options is not None:
            timeout = compute_node_enable_scheduling_options.timeout
        client_request_id = None
        if compute_node_enable_scheduling_options is not None:
            client_request_id = compute_node_enable_scheduling_options.client_request_id
        return_client_request_id = None
        if compute_node_enable_scheduling_options is not None:
            return_client_request_id = compute_node_enable_scheduling_options.return_client_request_id
        ocp_date = None
        if compute_node_enable_scheduling_options is not None:
            ocp_date = compute_node_enable_scheduling_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/enablescheduling'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def get_remote_login_settings(
            self, pool_id, node_id, compute_node_get_remote_login_settings_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets the settings required for remote login to a compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node for which to obtain the
         remote login settings.
        :type node_id: str
        :param compute_node_get_remote_login_settings_options: Additional
         parameters for the operation
        :type compute_node_get_remote_login_settings_options:
         :class:`ComputeNodeGetRemoteLoginSettingsOptions
         <azure.batch.models.ComputeNodeGetRemoteLoginSettingsOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ComputeNodeGetRemoteLoginSettingsResult
         <azure.batch.models.ComputeNodeGetRemoteLoginSettingsResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_get_remote_login_settings_options is not None:
            timeout = compute_node_get_remote_login_settings_options.timeout
        client_request_id = None
        if compute_node_get_remote_login_settings_options is not None:
            client_request_id = compute_node_get_remote_login_settings_options.client_request_id
        return_client_request_id = None
        if compute_node_get_remote_login_settings_options is not None:
            return_client_request_id = compute_node_get_remote_login_settings_options.return_client_request_id
        ocp_date = None
        if compute_node_get_remote_login_settings_options is not None:
            ocp_date = compute_node_get_remote_login_settings_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/remoteloginsettings'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('ComputeNodeGetRemoteLoginSettingsResult', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def get_remote_desktop(
            self, pool_id, node_id, compute_node_get_remote_desktop_options=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Gets the Remote Desktop Protocol file for the specified compute node.

        :param pool_id: The id of the pool that contains the compute node.
        :type pool_id: str
        :param node_id: The id of the compute node for which you want to get
         the Remote Desktop Protocol file.
        :type node_id: str
        :param compute_node_get_remote_desktop_options: Additional parameters
         for the operation
        :type compute_node_get_remote_desktop_options:
         :class:`ComputeNodeGetRemoteDesktopOptions
         <azure.batch.models.ComputeNodeGetRemoteDesktopOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: Generator
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if compute_node_get_remote_desktop_options is not None:
            timeout = compute_node_get_remote_desktop_options.timeout
        client_request_id = None
        if compute_node_get_remote_desktop_options is not None:
            client_request_id = compute_node_get_remote_desktop_options.client_request_id
        return_client_request_id = None
        if compute_node_get_remote_desktop_options is not None:
            return_client_request_id = compute_node_get_remote_desktop_options.return_client_request_id
        ocp_date = None
        if compute_node_get_remote_desktop_options is not None:
            ocp_date = compute_node_get_remote_desktop_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/nodes/{nodeId}/rdp'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._client.stream_download(response, callback)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def list(
            self, pool_id, compute_node_list_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists the compute nodes in the specified pool.

        :param pool_id: The id of the pool from which you want to list nodes.
        :type pool_id: str
        :param compute_node_list_options: Additional parameters for the
         operation
        :type compute_node_list_options: :class:`ComputeNodeListOptions
         <azure.batch.models.ComputeNodeListOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ComputeNodePaged
         <azure.batch.models.ComputeNodePaged>`
        """
        filter = None
        if compute_node_list_options is not None:
            filter = compute_node_list_options.filter
        select = None
        if compute_node_list_options is not None:
            select = compute_node_list_options.select
        max_results = None
        if compute_node_list_options is not None:
            max_results = compute_node_list_options.max_results
        timeout = None
        if compute_node_list_options is not None:
            timeout = compute_node_list_options.timeout
        client_request_id = None
        if compute_node_list_options is not None:
            client_request_id = compute_node_list_options.client_request_id
        return_client_request_id = None
        if compute_node_list_options is not None:
            return_client_request_id = compute_node_list_options.return_client_request_id
        ocp_date = None
        if compute_node_list_options is not None:
            ocp_date = compute_node_list_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/pools/{poolId}/nodes'
                path_format_arguments = {
                    'poolId': self._serialize.url("pool_id", pool_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int')
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.ComputeNodePaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.ComputeNodePaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
