# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AccountSasParameters(Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :param services: Required. The signed services accessible with the account
     SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
     Possible values include: 'b', 'q', 't', 'f'
    :type services: str or ~azure.mgmt.storage.v2019_06_01.models.Services
    :param resource_types: Required. The signed resource types that are
     accessible with the account SAS. Service (s): Access to service-level
     APIs; Container (c): Access to container-level APIs; Object (o): Access to
     object-level APIs for blobs, queue messages, table entities, and files.
     Possible values include: 's', 'c', 'o'
    :type resource_types: str or
     ~azure.mgmt.storage.v2019_06_01.models.SignedResourceTypes
    :param permissions: Required. The signed permissions for the account SAS.
     Possible values include: Read (r), Write (w), Delete (d), List (l), Add
     (a), Create (c), Update (u) and Process (p). Possible values include: 'r',
     'd', 'w', 'l', 'a', 'c', 'u', 'p'
    :type permissions: str or
     ~azure.mgmt.storage.v2019_06_01.models.Permissions
    :param ip_address_or_range: An IP address or a range of IP addresses from
     which to accept requests.
    :type ip_address_or_range: str
    :param protocols: The protocol permitted for a request made with the
     account SAS. Possible values include: 'https,http', 'https'
    :type protocols: str or
     ~azure.mgmt.storage.v2019_06_01.models.HttpProtocol
    :param shared_access_start_time: The time at which the SAS becomes valid.
    :type shared_access_start_time: datetime
    :param shared_access_expiry_time: Required. The time at which the shared
     access signature becomes invalid.
    :type shared_access_expiry_time: datetime
    :param key_to_sign: The key to sign the account SAS token with.
    :type key_to_sign: str
    """

    _validation = {
        'services': {'required': True},
        'resource_types': {'required': True},
        'permissions': {'required': True},
        'shared_access_expiry_time': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'signedServices', 'type': 'str'},
        'resource_types': {'key': 'signedResourceTypes', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'HttpProtocol'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
    }

    def __init__(self, *, services, resource_types, permissions, shared_access_expiry_time, ip_address_or_range: str=None, protocols=None, shared_access_start_time=None, key_to_sign: str=None, **kwargs) -> None:
        super(AccountSasParameters, self).__init__(**kwargs)
        self.services = services
        self.resource_types = resource_types
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.key_to_sign = key_to_sign


class ActiveDirectoryProperties(Model):
    """Settings properties for Active Directory (AD).

    All required parameters must be populated in order to send to Azure.

    :param domain_name: Required. Specifies the primary domain that the AD DNS
     server is authoritative for.
    :type domain_name: str
    :param net_bios_domain_name: Required. Specifies the NetBIOS domain name.
    :type net_bios_domain_name: str
    :param forest_name: Required. Specifies the Active Directory forest to
     get.
    :type forest_name: str
    :param domain_guid: Required. Specifies the domain GUID.
    :type domain_guid: str
    :param domain_sid: Required. Specifies the security identifier (SID).
    :type domain_sid: str
    :param azure_storage_sid: Required. Specifies the security identifier
     (SID) for Azure Storage.
    :type azure_storage_sid: str
    """

    _validation = {
        'domain_name': {'required': True},
        'net_bios_domain_name': {'required': True},
        'forest_name': {'required': True},
        'domain_guid': {'required': True},
        'domain_sid': {'required': True},
        'azure_storage_sid': {'required': True},
    }

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'net_bios_domain_name': {'key': 'netBiosDomainName', 'type': 'str'},
        'forest_name': {'key': 'forestName', 'type': 'str'},
        'domain_guid': {'key': 'domainGuid', 'type': 'str'},
        'domain_sid': {'key': 'domainSid', 'type': 'str'},
        'azure_storage_sid': {'key': 'azureStorageSid', 'type': 'str'},
    }

    def __init__(self, *, domain_name: str, net_bios_domain_name: str, forest_name: str, domain_guid: str, domain_sid: str, azure_storage_sid: str, **kwargs) -> None:
        super(ActiveDirectoryProperties, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.net_bios_domain_name = net_bios_domain_name
        self.forest_name = forest_name
        self.domain_guid = domain_guid
        self.domain_sid = domain_sid
        self.azure_storage_sid = azure_storage_sid


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureFilesIdentityBasedAuthentication(Model):
    """Settings for Azure Files identity based authentication.

    All required parameters must be populated in order to send to Azure.

    :param directory_service_options: Required. Indicates the directory
     service used. Possible values include: 'None', 'AADDS', 'AD'
    :type directory_service_options: str or
     ~azure.mgmt.storage.v2019_06_01.models.DirectoryServiceOptions
    :param active_directory_properties: Required if choose AD.
    :type active_directory_properties:
     ~azure.mgmt.storage.v2019_06_01.models.ActiveDirectoryProperties
    """

    _validation = {
        'directory_service_options': {'required': True},
    }

    _attribute_map = {
        'directory_service_options': {'key': 'directoryServiceOptions', 'type': 'str'},
        'active_directory_properties': {'key': 'activeDirectoryProperties', 'type': 'ActiveDirectoryProperties'},
    }

    def __init__(self, *, directory_service_options, active_directory_properties=None, **kwargs) -> None:
        super(AzureFilesIdentityBasedAuthentication, self).__init__(**kwargs)
        self.directory_service_options = directory_service_options
        self.active_directory_properties = active_directory_properties


class BlobContainer(AzureEntityResource):
    """Properties of the blob container, including Id, resource name, resource
    type, Etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param default_encryption_scope: Default the container to use specified
     encryption scope for all writes.
    :type default_encryption_scope: str
    :param deny_encryption_scope_override: Block override of encryption scope
     from the container default.
    :type deny_encryption_scope_override: bool
    :param public_access: Specifies whether data in the container may be
     accessed publicly and the level of access. Possible values include:
     'Container', 'Blob', 'None'
    :type public_access: str or
     ~azure.mgmt.storage.v2019_06_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last
     modified.
    :vartype last_modified_time: datetime
    :ivar lease_status: The lease status of the container. Possible values
     include: 'Locked', 'Unlocked'
    :vartype lease_status: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include:
     'Available', 'Leased', 'Expired', 'Breaking', 'Broken'
    :vartype lease_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of
     infinite or fixed duration, only when the container is leased. Possible
     values include: 'Infinite', 'Fixed'
    :vartype lease_duration: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseDuration
    :param metadata: A name-value pair to associate with the container as
     metadata.
    :type metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the
     container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2019_06_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold:
     ~azure.mgmt.storage.v2019_06_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by
     SRP if there are at least one existing tag. The hasLegalHold public
     property is set to false by SRP if all existing legal hold tags are
     cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property
     is set to true by SRP if ImmutabilityPolicy has been created for this
     container. The hasImmutabilityPolicy public property is set to false by
     SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'default_encryption_scope': {'key': 'properties.defaultEncryptionScope', 'type': 'str'},
        'deny_encryption_scope_override': {'key': 'properties.denyEncryptionScopeOverride', 'type': 'bool'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'PublicAccess'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
    }

    def __init__(self, *, default_encryption_scope: str=None, deny_encryption_scope_override: bool=None, public_access=None, metadata=None, **kwargs) -> None:
        super(BlobContainer, self).__init__(**kwargs)
        self.default_encryption_scope = default_encryption_scope
        self.deny_encryption_scope_override = deny_encryption_scope_override
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class BlobRestoreParameters(Model):
    """Blob restore parameters.

    All required parameters must be populated in order to send to Azure.

    :param time_to_restore: Required. Restore blob to the specified time.
    :type time_to_restore: datetime
    :param blob_ranges: Required. Blob ranges to restore.
    :type blob_ranges:
     list[~azure.mgmt.storage.v2019_06_01.models.BlobRestoreRange]
    """

    _validation = {
        'time_to_restore': {'required': True},
        'blob_ranges': {'required': True},
    }

    _attribute_map = {
        'time_to_restore': {'key': 'timeToRestore', 'type': 'iso-8601'},
        'blob_ranges': {'key': 'blobRanges', 'type': '[BlobRestoreRange]'},
    }

    def __init__(self, *, time_to_restore, blob_ranges, **kwargs) -> None:
        super(BlobRestoreParameters, self).__init__(**kwargs)
        self.time_to_restore = time_to_restore
        self.blob_ranges = blob_ranges


class BlobRestoreRange(Model):
    """Blob range.

    All required parameters must be populated in order to send to Azure.

    :param start_range: Required. Blob start range. Empty means account start.
    :type start_range: str
    :param end_range: Required. Blob end range. Empty means account end.
    :type end_range: str
    """

    _validation = {
        'start_range': {'required': True},
        'end_range': {'required': True},
    }

    _attribute_map = {
        'start_range': {'key': 'startRange', 'type': 'str'},
        'end_range': {'key': 'endRange', 'type': 'str'},
    }

    def __init__(self, *, start_range: str, end_range: str, **kwargs) -> None:
        super(BlobRestoreRange, self).__init__(**kwargs)
        self.start_range = start_range
        self.end_range = end_range


class BlobRestoreStatus(Model):
    """Blob restore status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The status of blob restore progress. Possible values are: -
     InProgress: Indicates that blob restore is ongoing. - Complete: Indicates
     that blob restore has been completed successfully. - Failed: Indicates
     that blob restore is failed. Possible values include: 'InProgress',
     'Complete', 'Failed'
    :vartype status: str or
     ~azure.mgmt.storage.v2019_06_01.models.BlobRestoreProgressStatus
    :ivar failure_reason: Failure reason when blob restore is failed.
    :vartype failure_reason: str
    :ivar restore_id: Id for tracking blob restore request.
    :vartype restore_id: str
    :ivar parameters: Blob restore request parameters.
    :vartype parameters:
     ~azure.mgmt.storage.v2019_06_01.models.BlobRestoreParameters
    """

    _validation = {
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'restore_id': {'readonly': True},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'restore_id': {'key': 'restoreId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'BlobRestoreParameters'},
    }

    def __init__(self, **kwargs) -> None:
        super(BlobRestoreStatus, self).__init__(**kwargs)
        self.status = None
        self.failure_reason = None
        self.restore_id = None
        self.parameters = None


class BlobServiceProperties(Resource):
    """The properties of a storage account’s Blob service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param cors: Specifies CORS rules for the Blob service. You can include up
     to five CorsRule elements in the request. If no CorsRule elements are
     included in the request body, all CORS rules will be deleted, and CORS
     will be disabled for the Blob service.
    :type cors: ~azure.mgmt.storage.v2019_06_01.models.CorsRules
    :param default_service_version: DefaultServiceVersion indicates the
     default version to use for requests to the Blob service if an incoming
     request’s version is not specified. Possible values include version
     2008-10-27 and all more recent versions.
    :type default_service_version: str
    :param delete_retention_policy: The blob service properties for blob soft
     delete.
    :type delete_retention_policy:
     ~azure.mgmt.storage.v2019_06_01.models.DeleteRetentionPolicy
    :param is_versioning_enabled: Versioning is enabled if set to true.
    :type is_versioning_enabled: bool
    :param automatic_snapshot_policy_enabled: Deprecated in favor of
     isVersioningEnabled property.
    :type automatic_snapshot_policy_enabled: bool
    :param change_feed: The blob service properties for change feed events.
    :type change_feed: ~azure.mgmt.storage.v2019_06_01.models.ChangeFeed
    :param restore_policy: The blob service properties for blob restore
     policy.
    :type restore_policy:
     ~azure.mgmt.storage.v2019_06_01.models.RestorePolicyProperties
    :param container_delete_retention_policy: The blob service properties for
     container soft delete.
    :type container_delete_retention_policy:
     ~azure.mgmt.storage.v2019_06_01.models.DeleteRetentionPolicy
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2019_06_01.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
        'default_service_version': {'key': 'properties.defaultServiceVersion', 'type': 'str'},
        'delete_retention_policy': {'key': 'properties.deleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'is_versioning_enabled': {'key': 'properties.isVersioningEnabled', 'type': 'bool'},
        'automatic_snapshot_policy_enabled': {'key': 'properties.automaticSnapshotPolicyEnabled', 'type': 'bool'},
        'change_feed': {'key': 'properties.changeFeed', 'type': 'ChangeFeed'},
        'restore_policy': {'key': 'properties.restorePolicy', 'type': 'RestorePolicyProperties'},
        'container_delete_retention_policy': {'key': 'properties.containerDeleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, *, cors=None, default_service_version: str=None, delete_retention_policy=None, is_versioning_enabled: bool=None, automatic_snapshot_policy_enabled: bool=None, change_feed=None, restore_policy=None, container_delete_retention_policy=None, **kwargs) -> None:
        super(BlobServiceProperties, self).__init__(**kwargs)
        self.cors = cors
        self.default_service_version = default_service_version
        self.delete_retention_policy = delete_retention_policy
        self.is_versioning_enabled = is_versioning_enabled
        self.automatic_snapshot_policy_enabled = automatic_snapshot_policy_enabled
        self.change_feed = change_feed
        self.restore_policy = restore_policy
        self.container_delete_retention_policy = container_delete_retention_policy
        self.sku = None


class ChangeFeed(Model):
    """The blob service properties for change feed events.

    :param enabled: Indicates whether change feed event logging is enabled for
     the Blob service.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, *, enabled: bool=None, **kwargs) -> None:
        super(ChangeFeed, self).__init__(**kwargs)
        self.enabled = enabled


class CheckNameAvailabilityResult(Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name
     is available for you to use. If true, the name is available. If false, the
     name has already been taken or is invalid and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be
     used. The Reason element is only returned if NameAvailable is false.
     Possible values include: 'AccountNameInvalid', 'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.storage.v2019_06_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more
     detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'Reason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudError(Model):
    """An error response from the Storage service.

    :param error:
    :type error: ~azure.mgmt.storage.v2019_06_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Storage service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.storage.v2019_06_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CorsRule(Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. Required if CorsRule element is present.
     A list of origin domains that will be allowed via CORS, or "*" to allow
     all domains
    :type allowed_origins: list[str]
    :param allowed_methods: Required. Required if CorsRule element is present.
     A list of HTTP methods that are allowed to be executed by the origin.
    :type allowed_methods: list[str]
    :param max_age_in_seconds: Required. Required if CorsRule element is
     present. The number of seconds that the client/browser should cache a
     preflight response.
    :type max_age_in_seconds: int
    :param exposed_headers: Required. Required if CorsRule element is present.
     A list of response headers to expose to CORS clients.
    :type exposed_headers: list[str]
    :param allowed_headers: Required. Required if CorsRule element is present.
     A list of headers allowed to be part of the cross-origin request.
    :type allowed_headers: list[str]
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'max_age_in_seconds': {'required': True},
        'exposed_headers': {'required': True},
        'allowed_headers': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'allowed_methods': {'key': 'allowedMethods', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'int'},
        'exposed_headers': {'key': 'exposedHeaders', 'type': '[str]'},
        'allowed_headers': {'key': 'allowedHeaders', 'type': '[str]'},
    }

    def __init__(self, *, allowed_origins, allowed_methods, max_age_in_seconds: int, exposed_headers, allowed_headers, **kwargs) -> None:
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.max_age_in_seconds = max_age_in_seconds
        self.exposed_headers = exposed_headers
        self.allowed_headers = allowed_headers


class CorsRules(Model):
    """Sets the CORS rules. You can include up to five CorsRule elements in the
    request. .

    :param cors_rules: The List of CORS rules. You can include up to five
     CorsRule elements in the request.
    :type cors_rules: list[~azure.mgmt.storage.v2019_06_01.models.CorsRule]
    """

    _attribute_map = {
        'cors_rules': {'key': 'corsRules', 'type': '[CorsRule]'},
    }

    def __init__(self, *, cors_rules=None, **kwargs) -> None:
        super(CorsRules, self).__init__(**kwargs)
        self.cors_rules = cors_rules


class CustomDomain(Model):
    """The custom domain assigned to this storage account. This can be set via
    Update.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the custom domain name assigned to the
     storage account. Name is the CNAME source.
    :type name: str
    :param use_sub_domain_name: Indicates whether indirect CName validation is
     enabled. Default value is false. This should only be set on updates.
    :type use_sub_domain_name: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'use_sub_domain_name': {'key': 'useSubDomainName', 'type': 'bool'},
    }

    def __init__(self, *, name: str, use_sub_domain_name: bool=None, **kwargs) -> None:
        super(CustomDomain, self).__init__(**kwargs)
        self.name = name
        self.use_sub_domain_name = use_sub_domain_name


class DateAfterCreation(Model):
    """Object to define the number of days after creation.

    All required parameters must be populated in order to send to Azure.

    :param days_after_creation_greater_than: Required. Value indicating the
     age in days after creation
    :type days_after_creation_greater_than: float
    """

    _validation = {
        'days_after_creation_greater_than': {'required': True, 'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_creation_greater_than': {'key': 'daysAfterCreationGreaterThan', 'type': 'float'},
    }

    def __init__(self, *, days_after_creation_greater_than: float, **kwargs) -> None:
        super(DateAfterCreation, self).__init__(**kwargs)
        self.days_after_creation_greater_than = days_after_creation_greater_than


class DateAfterModification(Model):
    """Object to define the number of days after last modification.

    All required parameters must be populated in order to send to Azure.

    :param days_after_modification_greater_than: Required. Value indicating
     the age in days after last modification
    :type days_after_modification_greater_than: float
    """

    _validation = {
        'days_after_modification_greater_than': {'required': True, 'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_modification_greater_than': {'key': 'daysAfterModificationGreaterThan', 'type': 'float'},
    }

    def __init__(self, *, days_after_modification_greater_than: float, **kwargs) -> None:
        super(DateAfterModification, self).__init__(**kwargs)
        self.days_after_modification_greater_than = days_after_modification_greater_than


class DeleteRetentionPolicy(Model):
    """The service properties for soft delete.

    :param enabled: Indicates whether DeleteRetentionPolicy is enabled.
    :type enabled: bool
    :param days: Indicates the number of days that the deleted item should be
     retained. The minimum specified value can be 1 and the maximum value can
     be 365.
    :type days: int
    """

    _validation = {
        'days': {'maximum': 365, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool=None, days: int=None, **kwargs) -> None:
        super(DeleteRetentionPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class Dimension(Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :param name: Display name of dimension.
    :type name: str
    :param display_name: Display name of dimension.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, **kwargs) -> None:
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class Encryption(Model):
    """The encryption settings on the storage account.

    All required parameters must be populated in order to send to Azure.

    :param services: List of services which support encryption.
    :type services: ~azure.mgmt.storage.v2019_06_01.models.EncryptionServices
    :param key_source: Required. The encryption keySource (provider). Possible
     values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault.
     Possible values include: 'Microsoft.Storage', 'Microsoft.Keyvault'.
     Default value: "Microsoft.Storage" .
    :type key_source: str or ~azure.mgmt.storage.v2019_06_01.models.KeySource
    :param key_vault_properties: Properties provided by key vault.
    :type key_vault_properties:
     ~azure.mgmt.storage.v2019_06_01.models.KeyVaultProperties
    """

    _validation = {
        'key_source': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'services', 'type': 'EncryptionServices'},
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyvaultproperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(self, *, services=None, key_source="Microsoft.Storage", key_vault_properties=None, **kwargs) -> None:
        super(Encryption, self).__init__(**kwargs)
        self.services = services
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EncryptionScope(Resource):
    """The Encryption Scope resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param source: The provider for the encryption scope. Possible values
     (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible
     values include: 'Microsoft.Storage', 'Microsoft.KeyVault'
    :type source: str or
     ~azure.mgmt.storage.v2019_06_01.models.EncryptionScopeSource
    :param state: The state of the encryption scope. Possible values
     (case-insensitive):  Enabled, Disabled. Possible values include:
     'Enabled', 'Disabled'
    :type state: str or
     ~azure.mgmt.storage.v2019_06_01.models.EncryptionScopeState
    :ivar creation_time: Gets the creation date and time of the encryption
     scope in UTC.
    :vartype creation_time: datetime
    :ivar last_modified_time: Gets the last modification date and time of the
     encryption scope in UTC.
    :vartype last_modified_time: datetime
    :param key_vault_properties: The key vault properties for the encryption
     scope. This is a required field if encryption scope 'source' attribute is
     set to 'Microsoft.KeyVault'.
    :type key_vault_properties:
     ~azure.mgmt.storage.v2019_06_01.models.EncryptionScopeKeyVaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'EncryptionScopeKeyVaultProperties'},
    }

    def __init__(self, *, source=None, state=None, key_vault_properties=None, **kwargs) -> None:
        super(EncryptionScope, self).__init__(**kwargs)
        self.source = source
        self.state = state
        self.creation_time = None
        self.last_modified_time = None
        self.key_vault_properties = key_vault_properties


class EncryptionScopeKeyVaultProperties(Model):
    """The key vault properties for the encryption scope. This is a required field
    if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.

    :param key_uri: The object identifier for a key vault key object. When
     applied, the encryption scope will use the key referenced by the
     identifier to enable customer-managed key support on this encryption
     scope.
    :type key_uri: str
    """

    _attribute_map = {
        'key_uri': {'key': 'keyUri', 'type': 'str'},
    }

    def __init__(self, *, key_uri: str=None, **kwargs) -> None:
        super(EncryptionScopeKeyVaultProperties, self).__init__(**kwargs)
        self.key_uri = key_uri


class EncryptionService(Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: A boolean indicating whether or not the service encrypts
     the data as it is stored.
    :type enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the
     encryption was last enabled by the user. Only returned when encryption is
     enabled. There might be some unencrypted blobs which were written after
     this time, as it is just a rough estimate.
    :vartype last_enabled_time: datetime
    :param key_type: Encryption key type to be used for the encryption
     service. 'Account' key type implies that an account-scoped encryption key
     will be used. 'Service' key type implies that a default service key is
     used. Possible values include: 'Service', 'Account'
    :type key_type: str or ~azure.mgmt.storage.v2019_06_01.models.KeyType
    """

    _validation = {
        'last_enabled_time': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_enabled_time': {'key': 'lastEnabledTime', 'type': 'iso-8601'},
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool=None, key_type=None, **kwargs) -> None:
        super(EncryptionService, self).__init__(**kwargs)
        self.enabled = enabled
        self.last_enabled_time = None
        self.key_type = key_type


class EncryptionServices(Model):
    """A list of services that support encryption.

    :param blob: The encryption function of the blob storage service.
    :type blob: ~azure.mgmt.storage.v2019_06_01.models.EncryptionService
    :param file: The encryption function of the file storage service.
    :type file: ~azure.mgmt.storage.v2019_06_01.models.EncryptionService
    :param table: The encryption function of the table storage service.
    :type table: ~azure.mgmt.storage.v2019_06_01.models.EncryptionService
    :param queue: The encryption function of the queue storage service.
    :type queue: ~azure.mgmt.storage.v2019_06_01.models.EncryptionService
    """

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'EncryptionService'},
        'file': {'key': 'file', 'type': 'EncryptionService'},
        'table': {'key': 'table', 'type': 'EncryptionService'},
        'queue': {'key': 'queue', 'type': 'EncryptionService'},
    }

    def __init__(self, *, blob=None, file=None, table=None, queue=None, **kwargs) -> None:
        super(EncryptionServices, self).__init__(**kwargs)
        self.blob = blob
        self.file = file
        self.table = table
        self.queue = queue


class Endpoints(Model):
    """The URIs that are used to perform a retrieval of a public blob, queue,
    table, web or dfs object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    :param microsoft_endpoints: Gets the microsoft routing storage endpoints.
    :type microsoft_endpoints:
     ~azure.mgmt.storage.v2019_06_01.models.StorageAccountMicrosoftEndpoints
    :param internet_endpoints: Gets the internet routing storage endpoints
    :type internet_endpoints:
     ~azure.mgmt.storage.v2019_06_01.models.StorageAccountInternetEndpoints
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
        'microsoft_endpoints': {'key': 'microsoftEndpoints', 'type': 'StorageAccountMicrosoftEndpoints'},
        'internet_endpoints': {'key': 'internetEndpoints', 'type': 'StorageAccountInternetEndpoints'},
    }

    def __init__(self, *, microsoft_endpoints=None, internet_endpoints=None, **kwargs) -> None:
        super(Endpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None
        self.microsoft_endpoints = microsoft_endpoints
        self.internet_endpoints = internet_endpoints


class ErrorResponse(Model):
    """An error response from the storage resource provider.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class FileServiceItems(Model):
    """FileServiceItems.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of file services returned.
    :vartype value:
     list[~azure.mgmt.storage.v2019_06_01.models.FileServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FileServiceProperties]'},
    }

    def __init__(self, **kwargs) -> None:
        super(FileServiceItems, self).__init__(**kwargs)
        self.value = None


class FileServiceProperties(Resource):
    """The properties of File services in storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param cors: Specifies CORS rules for the File service. You can include up
     to five CorsRule elements in the request. If no CorsRule elements are
     included in the request body, all CORS rules will be deleted, and CORS
     will be disabled for the File service.
    :type cors: ~azure.mgmt.storage.v2019_06_01.models.CorsRules
    :param share_delete_retention_policy: The file service properties for
     share soft delete.
    :type share_delete_retention_policy:
     ~azure.mgmt.storage.v2019_06_01.models.DeleteRetentionPolicy
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2019_06_01.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
        'share_delete_retention_policy': {'key': 'properties.shareDeleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, *, cors=None, share_delete_retention_policy=None, **kwargs) -> None:
        super(FileServiceProperties, self).__init__(**kwargs)
        self.cors = cors
        self.share_delete_retention_policy = share_delete_retention_policy
        self.sku = None


class FileShare(AzureEntityResource):
    """Properties of the file share, including Id, resource name, resource type,
    Etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last
     modified.
    :vartype last_modified_time: datetime
    :param metadata: A name-value pair to associate with the share as
     metadata.
    :type metadata: dict[str, str]
    :param share_quota: The maximum size of the share, in gigabytes. Must be
     greater than 0, and less than or equal to 5TB (5120). For Large File
     Shares, the maximum size is 102400.
    :type share_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 102400, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
    }

    def __init__(self, *, metadata=None, share_quota: int=None, **kwargs) -> None:
        super(FileShare, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota


class FileShareItem(AzureEntityResource):
    """The file share properties be listed out.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last
     modified.
    :vartype last_modified_time: datetime
    :param metadata: A name-value pair to associate with the share as
     metadata.
    :type metadata: dict[str, str]
    :param share_quota: The maximum size of the share, in gigabytes. Must be
     greater than 0, and less than or equal to 5TB (5120). For Large File
     Shares, the maximum size is 102400.
    :type share_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 102400, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
    }

    def __init__(self, *, metadata=None, share_quota: int=None, **kwargs) -> None:
        super(FileShareItem, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota


class GeoReplicationStats(Model):
    """Statistics related to replication for storage account's Blob, Table, Queue
    and File services. It is only available when geo-redundant replication is
    enabled for the storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The status of the secondary location. Possible values are: -
     Live: Indicates that the secondary location is active and operational. -
     Bootstrap: Indicates initial synchronization from the primary location to
     the secondary location is in progress.This typically occurs when
     replication is first enabled. - Unavailable: Indicates that the secondary
     location is temporarily unavailable. Possible values include: 'Live',
     'Bootstrap', 'Unavailable'
    :vartype status: str or
     ~azure.mgmt.storage.v2019_06_01.models.GeoReplicationStatus
    :ivar last_sync_time: All primary writes preceding this UTC date/time
     value are guaranteed to be available for read operations. Primary writes
     following this point in time may or may not be available for reads.
     Element may be default value if value of LastSyncTime is not available,
     this can happen if secondary is offline or we are in bootstrap.
    :vartype last_sync_time: datetime
    :ivar can_failover: A boolean flag which indicates whether or not account
     failover is supported for the account.
    :vartype can_failover: bool
    """

    _validation = {
        'status': {'readonly': True},
        'last_sync_time': {'readonly': True},
        'can_failover': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'last_sync_time': {'key': 'lastSyncTime', 'type': 'iso-8601'},
        'can_failover': {'key': 'canFailover', 'type': 'bool'},
    }

    def __init__(self, **kwargs) -> None:
        super(GeoReplicationStats, self).__init__(**kwargs)
        self.status = None
        self.last_sync_time = None
        self.can_failover = None


class Identity(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Required. The identity type. Default value: "SystemAssigned" .
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(self, **kwargs) -> None:
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class ImmutabilityPolicy(AzureEntityResource):
    """The ImmutabilityPolicy property of a blob container, including Id, resource
    name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param immutability_period_since_creation_in_days: The immutability period
     for the blobs in the container since the policy creation, in days.
    :type immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible
     values include: Locked and Unlocked. Possible values include: 'Locked',
     'Unlocked'
    :vartype state: str or
     ~azure.mgmt.storage.v2019_06_01.models.ImmutabilityPolicyState
    :param allow_protected_append_writes: This property can only be changed
     for unlocked time-based retention policies. When enabled, new blocks can
     be written to an append blob while maintaining immutability protection and
     compliance. Only new blocks can be added and any existing blocks cannot be
     modified or deleted. This property cannot be changed with
     ExtendImmutabilityPolicy API
    :type allow_protected_append_writes: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_protected_append_writes': {'key': 'properties.allowProtectedAppendWrites', 'type': 'bool'},
    }

    def __init__(self, *, immutability_period_since_creation_in_days: int=None, allow_protected_append_writes: bool=None, **kwargs) -> None:
        super(ImmutabilityPolicy, self).__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None
        self.allow_protected_append_writes = allow_protected_append_writes


class ImmutabilityPolicyProperties(Model):
    """The properties of an ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param immutability_period_since_creation_in_days: The immutability period
     for the blobs in the container since the policy creation, in days.
    :type immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible
     values include: Locked and Unlocked. Possible values include: 'Locked',
     'Unlocked'
    :vartype state: str or
     ~azure.mgmt.storage.v2019_06_01.models.ImmutabilityPolicyState
    :param allow_protected_append_writes: This property can only be changed
     for unlocked time-based retention policies. When enabled, new blocks can
     be written to an append blob while maintaining immutability protection and
     compliance. Only new blocks can be added and any existing blocks cannot be
     modified or deleted. This property cannot be changed with
     ExtendImmutabilityPolicy API
    :type allow_protected_append_writes: bool
    :ivar etag: ImmutabilityPolicy Etag.
    :vartype etag: str
    :ivar update_history: The ImmutabilityPolicy update history of the blob
     container.
    :vartype update_history:
     list[~azure.mgmt.storage.v2019_06_01.models.UpdateHistoryProperty]
    """

    _validation = {
        'state': {'readonly': True},
        'etag': {'readonly': True},
        'update_history': {'readonly': True},
    }

    _attribute_map = {
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_protected_append_writes': {'key': 'properties.allowProtectedAppendWrites', 'type': 'bool'},
        'etag': {'key': 'etag', 'type': 'str'},
        'update_history': {'key': 'updateHistory', 'type': '[UpdateHistoryProperty]'},
    }

    def __init__(self, *, immutability_period_since_creation_in_days: int=None, allow_protected_append_writes: bool=None, **kwargs) -> None:
        super(ImmutabilityPolicyProperties, self).__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None
        self.allow_protected_append_writes = allow_protected_append_writes
        self.etag = None
        self.update_history = None


class IPRule(Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR
     format. Only IPV4 address is allowed.
    :type ip_address_or_range: str
    :param action: The action of IP ACL rule. Possible values include:
     'Allow'. Default value: "Allow" .
    :type action: str or ~azure.mgmt.storage.v2019_06_01.models.Action
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
        'action': {'key': 'action', 'type': 'Action'},
    }

    def __init__(self, *, ip_address_or_range: str, action="Allow", **kwargs) -> None:
        super(IPRule, self).__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range
        self.action = action


class KeyVaultProperties(Model):
    """Properties of key vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param key_name: The name of KeyVault key.
    :type key_name: str
    :param key_version: The version of KeyVault key.
    :type key_version: str
    :param key_vault_uri: The Uri of KeyVault.
    :type key_vault_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the
     current versioned Key Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key
     Vault Key.
    :vartype last_key_rotation_timestamp: datetime
    """

    _validation = {
        'current_versioned_key_identifier': {'readonly': True},
        'last_key_rotation_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyname', 'type': 'str'},
        'key_version': {'key': 'keyversion', 'type': 'str'},
        'key_vault_uri': {'key': 'keyvaulturi', 'type': 'str'},
        'current_versioned_key_identifier': {'key': 'currentVersionedKeyIdentifier', 'type': 'str'},
        'last_key_rotation_timestamp': {'key': 'lastKeyRotationTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, *, key_name: str=None, key_version: str=None, key_vault_uri: str=None, **kwargs) -> None:
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None


class LeaseContainerRequest(Model):
    """Lease Container request schema.

    All required parameters must be populated in order to send to Azure.

    :param action: Required. Specifies the lease action. Can be one of the
     available actions. Possible values include: 'Acquire', 'Renew', 'Change',
     'Release', 'Break'
    :type action: str or ~azure.mgmt.storage.v2019_06_01.models.enum
    :param lease_id: Identifies the lease. Can be specified in any valid GUID
     string format.
    :type lease_id: str
    :param break_period: Optional. For a break action, proposed duration the
     lease should continue before it is broken, in seconds, between 0 and 60.
    :type break_period: int
    :param lease_duration: Required for acquire. Specifies the duration of the
     lease, in seconds, or negative one (-1) for a lease that never expires.
    :type lease_duration: int
    :param proposed_lease_id: Optional for acquire, required for change.
     Proposed lease ID, in a GUID string format.
    :type proposed_lease_id: str
    """

    _validation = {
        'action': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'break_period': {'key': 'breakPeriod', 'type': 'int'},
        'lease_duration': {'key': 'leaseDuration', 'type': 'int'},
        'proposed_lease_id': {'key': 'proposedLeaseId', 'type': 'str'},
    }

    def __init__(self, *, action, lease_id: str=None, break_period: int=None, lease_duration: int=None, proposed_lease_id: str=None, **kwargs) -> None:
        super(LeaseContainerRequest, self).__init__(**kwargs)
        self.action = action
        self.lease_id = lease_id
        self.break_period = break_period
        self.lease_duration = lease_duration
        self.proposed_lease_id = proposed_lease_id


class LeaseContainerResponse(Model):
    """Lease Container response schema.

    :param lease_id: Returned unique lease ID that must be included with any
     request to delete the container, or to renew, change, or release the
     lease.
    :type lease_id: str
    :param lease_time_seconds: Approximate time remaining in the lease period,
     in seconds.
    :type lease_time_seconds: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'lease_time_seconds': {'key': 'leaseTimeSeconds', 'type': 'str'},
    }

    def __init__(self, *, lease_id: str=None, lease_time_seconds: str=None, **kwargs) -> None:
        super(LeaseContainerResponse, self).__init__(**kwargs)
        self.lease_id = lease_id
        self.lease_time_seconds = lease_time_seconds


class LegalHold(Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by
     SRP if there are at least one existing tag. The hasLegalHold public
     property is set to false by SRP if all existing legal hold tags are
     cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :param tags: Required. Each tag should be 3 to 23 alphanumeric characters
     and is normalized to lower case at SRP.
    :type tags: list[str]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
        'tags': {'required': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(self, *, tags, **kwargs) -> None:
        super(LegalHold, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class LegalHoldProperties(Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by
     SRP if there are at least one existing tag. The hasLegalHold public
     property is set to false by SRP if all existing legal hold tags are
     cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :param tags: The list of LegalHold tags of a blob container.
    :type tags: list[~azure.mgmt.storage.v2019_06_01.models.TagProperty]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[TagProperty]'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(LegalHoldProperties, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class ListAccountSasResponse(Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        'account_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'account_sas_token': {'key': 'accountSasToken', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ListAccountSasResponse, self).__init__(**kwargs)
        self.account_sas_token = None


class ListContainerItem(AzureEntityResource):
    """The blob container properties be listed out.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param default_encryption_scope: Default the container to use specified
     encryption scope for all writes.
    :type default_encryption_scope: str
    :param deny_encryption_scope_override: Block override of encryption scope
     from the container default.
    :type deny_encryption_scope_override: bool
    :param public_access: Specifies whether data in the container may be
     accessed publicly and the level of access. Possible values include:
     'Container', 'Blob', 'None'
    :type public_access: str or
     ~azure.mgmt.storage.v2019_06_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last
     modified.
    :vartype last_modified_time: datetime
    :ivar lease_status: The lease status of the container. Possible values
     include: 'Locked', 'Unlocked'
    :vartype lease_status: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include:
     'Available', 'Leased', 'Expired', 'Breaking', 'Broken'
    :vartype lease_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of
     infinite or fixed duration, only when the container is leased. Possible
     values include: 'Infinite', 'Fixed'
    :vartype lease_duration: str or
     ~azure.mgmt.storage.v2019_06_01.models.LeaseDuration
    :param metadata: A name-value pair to associate with the container as
     metadata.
    :type metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the
     container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2019_06_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold:
     ~azure.mgmt.storage.v2019_06_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by
     SRP if there are at least one existing tag. The hasLegalHold public
     property is set to false by SRP if all existing legal hold tags are
     cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property
     is set to true by SRP if ImmutabilityPolicy has been created for this
     container. The hasImmutabilityPolicy public property is set to false by
     SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'default_encryption_scope': {'key': 'properties.defaultEncryptionScope', 'type': 'str'},
        'deny_encryption_scope_override': {'key': 'properties.denyEncryptionScopeOverride', 'type': 'bool'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'PublicAccess'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
    }

    def __init__(self, *, default_encryption_scope: str=None, deny_encryption_scope_override: bool=None, public_access=None, metadata=None, **kwargs) -> None:
        super(ListContainerItem, self).__init__(**kwargs)
        self.default_encryption_scope = default_encryption_scope
        self.deny_encryption_scope_override = deny_encryption_scope_override
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class ListServiceSasResponse(Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar service_sas_token: List service SAS credentials of specific
     resource.
    :vartype service_sas_token: str
    """

    _validation = {
        'service_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'service_sas_token': {'key': 'serviceSasToken', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ListServiceSasResponse, self).__init__(**kwargs)
        self.service_sas_token = None


class ManagementPolicy(Resource):
    """The Get Storage Account ManagementPolicies operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar last_modified_time: Returns the date and time the ManagementPolicies
     was last modified.
    :vartype last_modified_time: datetime
    :param policy: Required. The Storage Account ManagementPolicy, in JSON
     format. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :type policy:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicySchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'policy': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'policy': {'key': 'properties.policy', 'type': 'ManagementPolicySchema'},
    }

    def __init__(self, *, policy, **kwargs) -> None:
        super(ManagementPolicy, self).__init__(**kwargs)
        self.last_modified_time = None
        self.policy = policy


class ManagementPolicyAction(Model):
    """Actions are applied to the filtered blobs when the execution condition is
    met.

    :param base_blob: The management policy action for base blob
    :type base_blob:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicyBaseBlob
    :param snapshot: The management policy action for snapshot
    :type snapshot:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicySnapShot
    """

    _attribute_map = {
        'base_blob': {'key': 'baseBlob', 'type': 'ManagementPolicyBaseBlob'},
        'snapshot': {'key': 'snapshot', 'type': 'ManagementPolicySnapShot'},
    }

    def __init__(self, *, base_blob=None, snapshot=None, **kwargs) -> None:
        super(ManagementPolicyAction, self).__init__(**kwargs)
        self.base_blob = base_blob
        self.snapshot = snapshot


class ManagementPolicyBaseBlob(Model):
    """Management policy action for base blob.

    :param tier_to_cool: The function to tier blobs to cool storage. Support
     blobs currently at Hot tier
    :type tier_to_cool:
     ~azure.mgmt.storage.v2019_06_01.models.DateAfterModification
    :param tier_to_archive: The function to tier blobs to archive storage.
     Support blobs currently at Hot or Cool tier
    :type tier_to_archive:
     ~azure.mgmt.storage.v2019_06_01.models.DateAfterModification
    :param delete: The function to delete the blob
    :type delete: ~azure.mgmt.storage.v2019_06_01.models.DateAfterModification
    """

    _attribute_map = {
        'tier_to_cool': {'key': 'tierToCool', 'type': 'DateAfterModification'},
        'tier_to_archive': {'key': 'tierToArchive', 'type': 'DateAfterModification'},
        'delete': {'key': 'delete', 'type': 'DateAfterModification'},
    }

    def __init__(self, *, tier_to_cool=None, tier_to_archive=None, delete=None, **kwargs) -> None:
        super(ManagementPolicyBaseBlob, self).__init__(**kwargs)
        self.tier_to_cool = tier_to_cool
        self.tier_to_archive = tier_to_archive
        self.delete = delete


class ManagementPolicyDefinition(Model):
    """An object that defines the Lifecycle rule. Each definition is made up with
    a filters set and an actions set.

    All required parameters must be populated in order to send to Azure.

    :param actions: Required. An object that defines the action set.
    :type actions:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicyAction
    :param filters: An object that defines the filter set.
    :type filters:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicyFilter
    """

    _validation = {
        'actions': {'required': True},
    }

    _attribute_map = {
        'actions': {'key': 'actions', 'type': 'ManagementPolicyAction'},
        'filters': {'key': 'filters', 'type': 'ManagementPolicyFilter'},
    }

    def __init__(self, *, actions, filters=None, **kwargs) -> None:
        super(ManagementPolicyDefinition, self).__init__(**kwargs)
        self.actions = actions
        self.filters = filters


class ManagementPolicyFilter(Model):
    """Filters limit rule actions to a subset of blobs within the storage account.
    If multiple filters are defined, a logical AND is performed on all filters.
    .

    All required parameters must be populated in order to send to Azure.

    :param prefix_match: An array of strings for prefixes to be match.
    :type prefix_match: list[str]
    :param blob_types: Required. An array of predefined enum values. Only
     blockBlob is supported.
    :type blob_types: list[str]
    """

    _validation = {
        'blob_types': {'required': True},
    }

    _attribute_map = {
        'prefix_match': {'key': 'prefixMatch', 'type': '[str]'},
        'blob_types': {'key': 'blobTypes', 'type': '[str]'},
    }

    def __init__(self, *, blob_types, prefix_match=None, **kwargs) -> None:
        super(ManagementPolicyFilter, self).__init__(**kwargs)
        self.prefix_match = prefix_match
        self.blob_types = blob_types


class ManagementPolicyRule(Model):
    """An object that wraps the Lifecycle rule. Each rule is uniquely defined by
    name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Rule is enabled if set to true.
    :type enabled: bool
    :param name: Required. A rule name can contain any combination of alpha
     numeric characters. Rule name is case-sensitive. It must be unique within
     a policy.
    :type name: str
    :ivar type: Required. The valid value is Lifecycle. Default value:
     "Lifecycle" .
    :vartype type: str
    :param definition: Required. An object that defines the Lifecycle rule.
    :type definition:
     ~azure.mgmt.storage.v2019_06_01.models.ManagementPolicyDefinition
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'definition': {'key': 'definition', 'type': 'ManagementPolicyDefinition'},
    }

    type = "Lifecycle"

    def __init__(self, *, name: str, definition, enabled: bool=None, **kwargs) -> None:
        super(ManagementPolicyRule, self).__init__(**kwargs)
        self.enabled = enabled
        self.name = name
        self.definition = definition


class ManagementPolicySchema(Model):
    """The Storage Account ManagementPolicies Rules. See more details in:
    https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    All required parameters must be populated in order to send to Azure.

    :param rules: Required. The Storage Account ManagementPolicies Rules. See
     more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :type rules:
     list[~azure.mgmt.storage.v2019_06_01.models.ManagementPolicyRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ManagementPolicyRule]'},
    }

    def __init__(self, *, rules, **kwargs) -> None:
        super(ManagementPolicySchema, self).__init__(**kwargs)
        self.rules = rules


class ManagementPolicySnapShot(Model):
    """Management policy action for snapshot.

    :param delete: The function to delete the blob snapshot
    :type delete: ~azure.mgmt.storage.v2019_06_01.models.DateAfterCreation
    """

    _attribute_map = {
        'delete': {'key': 'delete', 'type': 'DateAfterCreation'},
    }

    def __init__(self, *, delete=None, **kwargs) -> None:
        super(ManagementPolicySnapShot, self).__init__(**kwargs)
        self.delete = delete


class MetricSpecification(Model):
    """Metric specification of operation.

    :param name: Name of metric specification.
    :type name: str
    :param display_name: Display name of metric specification.
    :type display_name: str
    :param display_description: Display description of metric specification.
    :type display_description: str
    :param unit: Unit could be Bytes or Count.
    :type unit: str
    :param dimensions: Dimensions of blobs, including blob type and access
     tier.
    :type dimensions: list[~azure.mgmt.storage.v2019_06_01.models.Dimension]
    :param aggregation_type: Aggregation type could be Average.
    :type aggregation_type: str
    :param fill_gap_with_zero: The property to decide fill gap with zero or
     not.
    :type fill_gap_with_zero: bool
    :param category: The category this metric specification belong to, could
     be Capacity.
    :type category: str
    :param resource_id_dimension_name_override: Account Resource Id.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, dimensions=None, aggregation_type: str=None, fill_gap_with_zero: bool=None, category: str=None, resource_id_dimension_name_override: str=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NetworkRuleSet(Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :param bypass: Specifies whether traffic is bypassed for
     Logging/Metrics/AzureServices. Possible values are any combination of
     Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None
     to bypass none of those traffics. Possible values include: 'None',
     'Logging', 'Metrics', 'AzureServices'. Default value: "AzureServices" .
    :type bypass: str or ~azure.mgmt.storage.v2019_06_01.models.Bypass
    :param virtual_network_rules: Sets the virtual network rules
    :type virtual_network_rules:
     list[~azure.mgmt.storage.v2019_06_01.models.VirtualNetworkRule]
    :param ip_rules: Sets the IP ACL rules
    :type ip_rules: list[~azure.mgmt.storage.v2019_06_01.models.IPRule]
    :param default_action: Required. Specifies the default action of allow or
     deny when no other rules match. Possible values include: 'Allow', 'Deny'.
     Default value: "Allow" .
    :type default_action: str or
     ~azure.mgmt.storage.v2019_06_01.models.DefaultAction
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'default_action': {'key': 'defaultAction', 'type': 'DefaultAction'},
    }

    def __init__(self, *, bypass="AzureServices", virtual_network_rules=None, ip_rules=None, default_action="Allow", **kwargs) -> None:
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action


class Operation(Model):
    """Storage REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.storage.v2019_06_01.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param service_specification: One property of operation, include metric
     specifications.
    :type service_specification:
     ~azure.mgmt.storage.v2019_06_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, service_specification=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Storage.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PrivateEndpoint(Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ARM identifier for Private Endpoint
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint:
     ~azure.mgmt.storage.v2019_06_01.models.PrivateEndpoint
    :param private_link_service_connection_state: Required. A collection of
     information about the state of the connection between service consumer and
     provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.storage.v2019_06_01.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint
     connection resource. Possible values include: 'Succeeded', 'Creating',
     'Deleting', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_link_service_connection_state, private_endpoint=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS
     zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, *, required_zone_names=None, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(Model):
    """A list of private link resources.

    :param value: Array of private link resources
    :type value:
     list[~azure.mgmt.storage.v2019_06_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(Model):
    """A collection of information about the state of the connection between
    service consumer and provider.

    :param status: Indicates whether the connection has been
     Approved/Rejected/Removed by the owner of the service. Possible values
     include: 'Pending', 'Approved', 'Rejected'
    :type status: str or
     ~azure.mgmt.storage.v2019_06_01.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param action_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type action_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, action_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class RestorePolicyProperties(Model):
    """The blob service properties for blob restore policy.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Blob restore is enabled if set to true.
    :type enabled: bool
    :param days: how long this blob can be restored. It should be great than
     zero and less than DeleteRetentionPolicy.days.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'maximum': 365, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool, days: int=None, **kwargs) -> None:
        super(RestorePolicyProperties, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class Restriction(Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of restrictions. As of now only possible value for
     this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to
     location. This would be different locations where the SKU is restricted.
    :vartype values: list[str]
    :param reason_code: The reason for the restriction. As of now this can be
     "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU
     has requiredQuotas parameter as the subscription does not belong to that
     quota. The "NotAvailableForSubscription" is related to capacity at DC.
     Possible values include: 'QuotaId', 'NotAvailableForSubscription'
    :type reason_code: str or
     ~azure.mgmt.storage.v2019_06_01.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(self, *, reason_code=None, **kwargs) -> None:
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class RoutingPreference(Model):
    """Routing preference defines the type of network, either microsoft or
    internet routing to be used to deliver the user data, the default option is
    microsoft routing.

    :param routing_choice: Routing Choice defines the kind of network routing
     opted by the user. Possible values include: 'MicrosoftRouting',
     'InternetRouting'
    :type routing_choice: str or
     ~azure.mgmt.storage.v2019_06_01.models.RoutingChoice
    :param publish_microsoft_endpoints: A boolean flag which indicates whether
     microsoft routing storage endpoints are to be published
    :type publish_microsoft_endpoints: bool
    :param publish_internet_endpoints: A boolean flag which indicates whether
     internet routing storage endpoints are to be published
    :type publish_internet_endpoints: bool
    """

    _attribute_map = {
        'routing_choice': {'key': 'routingChoice', 'type': 'str'},
        'publish_microsoft_endpoints': {'key': 'publishMicrosoftEndpoints', 'type': 'bool'},
        'publish_internet_endpoints': {'key': 'publishInternetEndpoints', 'type': 'bool'},
    }

    def __init__(self, *, routing_choice=None, publish_microsoft_endpoints: bool=None, publish_internet_endpoints: bool=None, **kwargs) -> None:
        super(RoutingPreference, self).__init__(**kwargs)
        self.routing_choice = routing_choice
        self.publish_microsoft_endpoints = publish_microsoft_endpoints
        self.publish_internet_endpoints = publish_internet_endpoints


class ServiceSasParameters(Model):
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :param canonicalized_resource: Required. The canonical path to the signed
     resource.
    :type canonicalized_resource: str
    :param resource: The signed services accessible with the service SAS.
     Possible values include: Blob (b), Container (c), File (f), Share (s).
     Possible values include: 'b', 'c', 'f', 's'
    :type resource: str or
     ~azure.mgmt.storage.v2019_06_01.models.SignedResource
    :param permissions: The signed permissions for the service SAS. Possible
     values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create
     (c), Update (u) and Process (p). Possible values include: 'r', 'd', 'w',
     'l', 'a', 'c', 'u', 'p'
    :type permissions: str or
     ~azure.mgmt.storage.v2019_06_01.models.Permissions
    :param ip_address_or_range: An IP address or a range of IP addresses from
     which to accept requests.
    :type ip_address_or_range: str
    :param protocols: The protocol permitted for a request made with the
     account SAS. Possible values include: 'https,http', 'https'
    :type protocols: str or
     ~azure.mgmt.storage.v2019_06_01.models.HttpProtocol
    :param shared_access_start_time: The time at which the SAS becomes valid.
    :type shared_access_start_time: datetime
    :param shared_access_expiry_time: The time at which the shared access
     signature becomes invalid.
    :type shared_access_expiry_time: datetime
    :param identifier: A unique value up to 64 characters in length that
     correlates to an access policy specified for the container, queue, or
     table.
    :type identifier: str
    :param partition_key_start: The start of partition key.
    :type partition_key_start: str
    :param partition_key_end: The end of partition key.
    :type partition_key_end: str
    :param row_key_start: The start of row key.
    :type row_key_start: str
    :param row_key_end: The end of row key.
    :type row_key_end: str
    :param key_to_sign: The key to sign the account SAS token with.
    :type key_to_sign: str
    :param cache_control: The response header override for cache control.
    :type cache_control: str
    :param content_disposition: The response header override for content
     disposition.
    :type content_disposition: str
    :param content_encoding: The response header override for content
     encoding.
    :type content_encoding: str
    :param content_language: The response header override for content
     language.
    :type content_language: str
    :param content_type: The response header override for content type.
    :type content_type: str
    """

    _validation = {
        'canonicalized_resource': {'required': True},
        'identifier': {'max_length': 64},
    }

    _attribute_map = {
        'canonicalized_resource': {'key': 'canonicalizedResource', 'type': 'str'},
        'resource': {'key': 'signedResource', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'HttpProtocol'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'identifier': {'key': 'signedIdentifier', 'type': 'str'},
        'partition_key_start': {'key': 'startPk', 'type': 'str'},
        'partition_key_end': {'key': 'endPk', 'type': 'str'},
        'row_key_start': {'key': 'startRk', 'type': 'str'},
        'row_key_end': {'key': 'endRk', 'type': 'str'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
        'cache_control': {'key': 'rscc', 'type': 'str'},
        'content_disposition': {'key': 'rscd', 'type': 'str'},
        'content_encoding': {'key': 'rsce', 'type': 'str'},
        'content_language': {'key': 'rscl', 'type': 'str'},
        'content_type': {'key': 'rsct', 'type': 'str'},
    }

    def __init__(self, *, canonicalized_resource: str, resource=None, permissions=None, ip_address_or_range: str=None, protocols=None, shared_access_start_time=None, shared_access_expiry_time=None, identifier: str=None, partition_key_start: str=None, partition_key_end: str=None, row_key_start: str=None, row_key_end: str=None, key_to_sign: str=None, cache_control: str=None, content_disposition: str=None, content_encoding: str=None, content_language: str=None, content_type: str=None, **kwargs) -> None:
        super(ServiceSasParameters, self).__init__(**kwargs)
        self.canonicalized_resource = canonicalized_resource
        self.resource = resource
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.identifier = identifier
        self.partition_key_start = partition_key_start
        self.partition_key_end = partition_key_end
        self.row_key_start = row_key_start
        self.row_key_end = row_key_end
        self.key_to_sign = key_to_sign
        self.cache_control = cache_control
        self.content_disposition = content_disposition
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_type = content_type


class ServiceSpecification(Model):
    """One property of operation, include metric specifications.

    :param metric_specifications: Metric specifications of operation.
    :type metric_specifications:
     list[~azure.mgmt.storage.v2019_06_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Sku(Model):
    """The SKU of the storage account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Possible values include: 'Standard_LRS',
     'Standard_GRS', 'Standard_RAGRS', 'Standard_ZRS', 'Premium_LRS',
     'Premium_ZRS', 'Standard_GZRS', 'Standard_RAGZRS'
    :type name: str or ~azure.mgmt.storage.v2019_06_01.models.SkuName
    :param tier: Possible values include: 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.storage.v2019_06_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'SkuTier'},
    }

    def __init__(self, *, name, tier=None, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class SKUCapability(Model):
    """The capability information in the specified SKU, including file encryption,
    network ACLs, change notification, etc.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of capability, The capability information in the
     specified SKU, including file encryption, network ACLs, change
     notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability.
     Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SKUCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class SkuInformation(Model):
    """Storage SKU and its properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Possible values include: 'Standard_LRS',
     'Standard_GRS', 'Standard_RAGRS', 'Standard_ZRS', 'Premium_LRS',
     'Premium_ZRS', 'Standard_GZRS', 'Standard_RAGZRS'
    :type name: str or ~azure.mgmt.storage.v2019_06_01.models.SkuName
    :param tier: Possible values include: 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.storage.v2019_06_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is
     'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Possible values
     include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage',
     'BlockBlobStorage'
    :vartype kind: str or ~azure.mgmt.storage.v2019_06_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will
     be supported and registered Azure Geo Regions (e.g. West US, East US,
     Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified SKU,
     including file encryption, network ACLs, change notification, etc.
    :vartype capabilities:
     list[~azure.mgmt.storage.v2019_06_01.models.SKUCapability]
    :param restrictions: The restrictions because of which SKU cannot be used.
     This is empty if there are no restrictions.
    :type restrictions:
     list[~azure.mgmt.storage.v2019_06_01.models.Restriction]
    """

    _validation = {
        'name': {'required': True},
        'resource_type': {'readonly': True},
        'kind': {'readonly': True},
        'locations': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'SkuTier'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(self, *, name, tier=None, restrictions=None, **kwargs) -> None:
        super(SkuInformation, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = restrictions


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageAccount(TrackedResource):
    """The storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2019_06_01.models.Sku
    :ivar kind: Gets the Kind. Possible values include: 'Storage',
     'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
    :vartype kind: str or ~azure.mgmt.storage.v2019_06_01.models.Kind
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2019_06_01.models.Identity
    :ivar provisioning_state: Gets the status of the storage account at the
     time the operation was called. Possible values include: 'Creating',
     'ResolvingDNS', 'Succeeded'
    :vartype provisioning_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a
     retrieval of a public blob, queue, or table object. Note that Standard_ZRS
     and Premium_LRS accounts only return the blob endpoint.
    :vartype primary_endpoints:
     ~azure.mgmt.storage.v2019_06_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for
     the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary
     location of the storage account is available or unavailable. Possible
     values include: 'available', 'unavailable'
    :vartype status_of_primary: str or
     ~azure.mgmt.storage.v2019_06_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent
     instance of a failover to the secondary location. Only the most recent
     timestamp is retained. This element is not returned if there has never
     been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: datetime
    :ivar secondary_location: Gets the location of the geo-replicated
     secondary for the storage account. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the
     secondary location of the storage account is available or unavailable.
     Only available if the SKU name is Standard_GRS or Standard_RAGRS. Possible
     values include: 'available', 'unavailable'
    :vartype status_of_secondary: str or
     ~azure.mgmt.storage.v2019_06_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage
     account in UTC.
    :vartype creation_time: datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this
     storage account.
    :vartype custom_domain:
     ~azure.mgmt.storage.v2019_06_01.models.CustomDomain
    :ivar secondary_endpoints: Gets the URLs that are used to perform a
     retrieval of a public blob, queue, or table object from the secondary
     location of the storage account. Only available if the SKU name is
     Standard_RAGRS.
    :vartype secondary_endpoints:
     ~azure.mgmt.storage.v2019_06_01.models.Endpoints
    :ivar encryption: Gets the encryption settings on the account. If
     unspecified, the account is unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2019_06_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage.
     The access tier used for billing. Possible values include: 'Hot', 'Cool'
    :vartype access_tier: str or
     ~azure.mgmt.storage.v2019_06_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity
     based authentication settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_06_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage
     service if sets to true.
    :type enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set
    :vartype network_rule_set:
     ~azure.mgmt.storage.v2019_06_01.models.NetworkRuleSet
    :param is_hns_enabled: Account HierarchicalNamespace enabled if sets to
     true.
    :type is_hns_enabled: bool
    :ivar geo_replication_stats: Geo Replication Stats
    :vartype geo_replication_stats:
     ~azure.mgmt.storage.v2019_06_01.models.GeoReplicationStats
    :ivar failover_in_progress: If the failover is in progress, the value will
     be true, otherwise, it will be null.
    :vartype failover_in_progress: bool
    :param large_file_shares_state: Allow large file shares if sets to
     Enabled. It cannot be disabled once it is enabled. Possible values
     include: 'Disabled', 'Enabled'
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.LargeFileSharesState
    :ivar private_endpoint_connections: List of private endpoint connection
     associated with the specified storage account
    :vartype private_endpoint_connections:
     list[~azure.mgmt.storage.v2019_06_01.models.PrivateEndpointConnection]
    :param routing_preference: Maintains information about the network routing
     choice opted by the user for data transfer
    :type routing_preference:
     ~azure.mgmt.storage.v2019_06_01.models.RoutingPreference
    :ivar blob_restore_status: Blob restore status
    :vartype blob_restore_status:
     ~azure.mgmt.storage.v2019_06_01.models.BlobRestoreStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'readonly': True},
        'kind': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'primary_endpoints': {'readonly': True},
        'primary_location': {'readonly': True},
        'status_of_primary': {'readonly': True},
        'last_geo_failover_time': {'readonly': True},
        'secondary_location': {'readonly': True},
        'status_of_secondary': {'readonly': True},
        'creation_time': {'readonly': True},
        'custom_domain': {'readonly': True},
        'secondary_endpoints': {'readonly': True},
        'encryption': {'readonly': True},
        'access_tier': {'readonly': True},
        'network_rule_set': {'readonly': True},
        'geo_replication_stats': {'readonly': True},
        'failover_in_progress': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'blob_restore_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'primary_endpoints': {'key': 'properties.primaryEndpoints', 'type': 'Endpoints'},
        'primary_location': {'key': 'properties.primaryLocation', 'type': 'str'},
        'status_of_primary': {'key': 'properties.statusOfPrimary', 'type': 'AccountStatus'},
        'last_geo_failover_time': {'key': 'properties.lastGeoFailoverTime', 'type': 'iso-8601'},
        'secondary_location': {'key': 'properties.secondaryLocation', 'type': 'str'},
        'status_of_secondary': {'key': 'properties.statusOfSecondary', 'type': 'AccountStatus'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'secondary_endpoints': {'key': 'properties.secondaryEndpoints', 'type': 'Endpoints'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'AccessTier'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'geo_replication_stats': {'key': 'properties.geoReplicationStats', 'type': 'GeoReplicationStats'},
        'failover_in_progress': {'key': 'properties.failoverInProgress', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
        'blob_restore_status': {'key': 'properties.blobRestoreStatus', 'type': 'BlobRestoreStatus'},
    }

    def __init__(self, *, location: str, tags=None, identity=None, azure_files_identity_based_authentication=None, enable_https_traffic_only: bool=None, is_hns_enabled: bool=None, large_file_shares_state=None, routing_preference=None, **kwargs) -> None:
        super(StorageAccount, self).__init__(tags=tags, location=location, **kwargs)
        self.sku = None
        self.kind = None
        self.identity = identity
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = None
        self.is_hns_enabled = is_hns_enabled
        self.geo_replication_stats = None
        self.failover_in_progress = None
        self.large_file_shares_state = large_file_shares_state
        self.private_endpoint_connections = None
        self.routing_preference = routing_preference
        self.blob_restore_status = None


class StorageAccountCheckNameAvailabilityParameters(Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The storage account name.
    :type name: str
    :ivar type: Required. The type of resource,
     Microsoft.Storage/storageAccounts. Default value:
     "Microsoft.Storage/storageAccounts" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(StorageAccountCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class StorageAccountCreateParameters(Model):
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :param sku: Required. Required. Gets or sets the SKU name.
    :type sku: ~azure.mgmt.storage.v2019_06_01.models.Sku
    :param kind: Required. Required. Indicates the type of storage account.
     Possible values include: 'Storage', 'StorageV2', 'BlobStorage',
     'FileStorage', 'BlockBlobStorage'
    :type kind: str or ~azure.mgmt.storage.v2019_06_01.models.Kind
    :param location: Required. Required. Gets or sets the location of the
     resource. This will be one of the supported and registered Azure Geo
     Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a
     resource cannot be changed once it is created, but if an identical geo
     region is specified on update, the request will succeed.
    :type location: str
    :param tags: Gets or sets a list of key value pairs that describe the
     resource. These tags can be used for viewing and grouping this resource
     (across resource groups). A maximum of 15 tags can be provided for a
     resource. Each tag must have a key with a length no greater than 128
     characters and a value with a length no greater than 256 characters.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2019_06_01.models.Identity
    :param custom_domain: User domain assigned to the storage account. Name is
     the CNAME source. Only one custom domain is supported per storage account
     at this time. To clear the existing custom domain, use an empty string for
     the custom domain name property.
    :type custom_domain: ~azure.mgmt.storage.v2019_06_01.models.CustomDomain
    :param encryption: Not applicable. Azure Storage encryption is enabled for
     all storage accounts and cannot be disabled.
    :type encryption: ~azure.mgmt.storage.v2019_06_01.models.Encryption
    :param network_rule_set: Network rule set
    :type network_rule_set:
     ~azure.mgmt.storage.v2019_06_01.models.NetworkRuleSet
    :param access_tier: Required for storage accounts where kind =
     BlobStorage. The access tier used for billing. Possible values include:
     'Hot', 'Cool'
    :type access_tier: str or
     ~azure.mgmt.storage.v2019_06_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity
     based authentication settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_06_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage
     service if sets to true. The default value is true since API version
     2019-04-01.
    :type enable_https_traffic_only: bool
    :param is_hns_enabled: Account HierarchicalNamespace enabled if sets to
     true.
    :type is_hns_enabled: bool
    :param large_file_shares_state: Allow large file shares if sets to
     Enabled. It cannot be disabled once it is enabled. Possible values
     include: 'Disabled', 'Enabled'
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.LargeFileSharesState
    :param routing_preference: Maintains information about the network routing
     choice opted by the user for data transfer
    :type routing_preference:
     ~azure.mgmt.storage.v2019_06_01.models.RoutingPreference
    """

    _validation = {
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'AccessTier'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
    }

    def __init__(self, *, sku, kind, location: str, tags=None, identity=None, custom_domain=None, encryption=None, network_rule_set=None, access_tier=None, azure_files_identity_based_authentication=None, enable_https_traffic_only: bool=None, is_hns_enabled: bool=None, large_file_shares_state=None, routing_preference=None, **kwargs) -> None:
        super(StorageAccountCreateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.identity = identity
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.network_rule_set = network_rule_set
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.is_hns_enabled = is_hns_enabled
        self.large_file_shares_state = large_file_shares_state
        self.routing_preference = routing_preference


class StorageAccountInternetEndpoints(Model):
    """The URIs that are used to perform a retrieval of a public blob, file, web
    or dfs object via a internet routing endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        'blob': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountInternetEndpoints, self).__init__(**kwargs)
        self.blob = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountKey(Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full
     permissions. Possible values include: 'Read', 'Full'
    :vartype permissions: str or
     ~azure.mgmt.storage.v2019_06_01.models.KeyPermission
    """

    _validation = {
        'key_name': {'readonly': True},
        'value': {'readonly': True},
        'permissions': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'KeyPermission'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountKey, self).__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None


class StorageAccountListKeysResult(Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for
     the specified storage account.
    :vartype keys:
     list[~azure.mgmt.storage.v2019_06_01.models.StorageAccountKey]
    """

    _validation = {
        'keys': {'readonly': True},
    }

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[StorageAccountKey]'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountListKeysResult, self).__init__(**kwargs)
        self.keys = None


class StorageAccountMicrosoftEndpoints(Model):
    """The URIs that are used to perform a retrieval of a public blob, queue,
    table, web or dfs object via a microsoft routing endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountMicrosoftEndpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountRegenerateKeyParameters(Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of storage keys that want to be
     regenerated, possible values are key1, key2, kerb1, kerb2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, *, key_name: str, **kwargs) -> None:
        super(StorageAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(Model):
    """The parameters that can be provided when updating the storage account
    properties.

    :param sku: Gets or sets the SKU name. Note that the SKU name cannot be
     updated to Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of
     those SKU names be updated to any other value.
    :type sku: ~azure.mgmt.storage.v2019_06_01.models.Sku
    :param tags: Gets or sets a list of key value pairs that describe the
     resource. These tags can be used in viewing and grouping this resource
     (across resource groups). A maximum of 15 tags can be provided for a
     resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2019_06_01.models.Identity
    :param custom_domain: Custom domain assigned to the storage account by the
     user. Name is the CNAME source. Only one custom domain is supported per
     storage account at this time. To clear the existing custom domain, use an
     empty string for the custom domain name property.
    :type custom_domain: ~azure.mgmt.storage.v2019_06_01.models.CustomDomain
    :param encryption: Provides the encryption settings on the account. The
     default setting is unencrypted.
    :type encryption: ~azure.mgmt.storage.v2019_06_01.models.Encryption
    :param access_tier: Required for storage accounts where kind =
     BlobStorage. The access tier used for billing. Possible values include:
     'Hot', 'Cool'
    :type access_tier: str or
     ~azure.mgmt.storage.v2019_06_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity
     based authentication settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_06_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage
     service if sets to true.
    :type enable_https_traffic_only: bool
    :param network_rule_set: Network rule set
    :type network_rule_set:
     ~azure.mgmt.storage.v2019_06_01.models.NetworkRuleSet
    :param large_file_shares_state: Allow large file shares if sets to
     Enabled. It cannot be disabled once it is enabled. Possible values
     include: 'Disabled', 'Enabled'
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_06_01.models.LargeFileSharesState
    :param routing_preference: Maintains information about the network routing
     choice opted by the user for data transfer
    :type routing_preference:
     ~azure.mgmt.storage.v2019_06_01.models.RoutingPreference
    :param kind: Optional. Indicates the type of storage account. Currently
     only StorageV2 value supported by server. Possible values include:
     'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
    :type kind: str or ~azure.mgmt.storage.v2019_06_01.models.Kind
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'AccessTier'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, sku=None, tags=None, identity=None, custom_domain=None, encryption=None, access_tier=None, azure_files_identity_based_authentication=None, enable_https_traffic_only: bool=None, network_rule_set=None, large_file_shares_state=None, routing_preference=None, kind=None, **kwargs) -> None:
        super(StorageAccountUpdateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.identity = identity
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = network_rule_set
        self.large_file_shares_state = large_file_shares_state
        self.routing_preference = routing_preference
        self.kind = kind


class TagProperty(Model):
    """A tag of the LegalHold of a blob container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tag: The tag value.
    :vartype tag: str
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: datetime
    :ivar object_identifier: Returns the Object ID of the user who added the
     tag.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user
     who added the tag.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who added the tag.
    :vartype upn: str
    """

    _validation = {
        'tag': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(TagProperty, self).__init__(**kwargs)
        self.tag = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class UpdateHistoryProperty(Model):
    """An update history of the ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar update: The ImmutabilityPolicy update type of a blob container,
     possible values include: put, lock and extend. Possible values include:
     'put', 'lock', 'extend'
    :vartype update: str or
     ~azure.mgmt.storage.v2019_06_01.models.ImmutabilityPolicyUpdateType
    :ivar immutability_period_since_creation_in_days: The immutability period
     for the blobs in the container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar timestamp: Returns the date and time the ImmutabilityPolicy was
     updated.
    :vartype timestamp: datetime
    :ivar object_identifier: Returns the Object ID of the user who updated the
     ImmutabilityPolicy.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user
     who updated the ImmutabilityPolicy.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who updated the
     ImmutabilityPolicy.
    :vartype upn: str
    """

    _validation = {
        'update': {'readonly': True},
        'immutability_period_since_creation_in_days': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'update': {'key': 'update', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpdateHistoryProperty, self).__init__(**kwargs)
        self.update = None
        self.immutability_period_since_creation_in_days = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class Usage(Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar unit: Gets the unit of measurement. Possible values include:
     'Count', 'Bytes', 'Seconds', 'Percent', 'CountsPerSecond',
     'BytesPerSecond'
    :vartype unit: str or ~azure.mgmt.storage.v2019_06_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in
     the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated
     in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2019_06_01.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'UsageUnit'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(self, **kwargs) -> None:
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageName(Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource
     name.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class VirtualNetworkRule(Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to Azure.

    :param virtual_network_resource_id: Required. Resource ID of a subnet, for
     example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    :param action: The action of virtual network rule. Possible values
     include: 'Allow'. Default value: "Allow" .
    :type action: str or ~azure.mgmt.storage.v2019_06_01.models.Action
    :param state: Gets the state of virtual network rule. Possible values
     include: 'provisioning', 'deprovisioning', 'succeeded', 'failed',
     'networkSourceDeleted'
    :type state: str or ~azure.mgmt.storage.v2019_06_01.models.State
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
        'action': {'key': 'action', 'type': 'Action'},
        'state': {'key': 'state', 'type': 'State'},
    }

    def __init__(self, *, virtual_network_resource_id: str, action="Allow", state=None, **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = state
