/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.utils.FileUtils;

@PublicAPI
public class ZipUtils
extends FileUtils {
    protected static final int COMP_LEVEL = 9;

    public static void zip(String[] directoriesAndFiles, File dest, CRC32 crc) throws IOException {
        byte[] zipped = ZipUtils.zipDirectoriesAndFiles(directoriesAndFiles, crc);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));){
            bos.write(zipped);
        }
    }

    public static byte[] zipDirectoriesAndFiles(String[] directoriesAndFiles, CRC32 crc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        ZipUtils.zipIt(zos, directoriesAndFiles, crc);
        zos.flush();
        zos.close();
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    protected static void zipIt(ZipOutputStream zos, String[] directoriesAndFiles, CRC32 crc) throws IOException {
        for (String pathElement : directoriesAndFiles) {
            File fileElement = new File(pathElement);
            pathElement = fileElement.getPath();
            int length = pathElement.lastIndexOf(File.separator) + 1;
            if (fileElement.isFile()) {
                ZipUtils.zipFile(pathElement, length, zos, crc);
                continue;
            }
            if (!fileElement.isDirectory()) continue;
            ZipUtils.zipDirectory(pathElement, length, zos, crc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void zipDirectory(String directoryName, int iBaseFolderLength, ZipOutputStream zos, CRC32 crc) throws IOException {
        File dirobject = new File(directoryName);
        if (!dirobject.exists()) throw new IOException("Directory " + directoryName + " does not exist.");
        if (!dirobject.isDirectory()) throw new IOException(directoryName + " is not a directory.");
        File[] fileList = dirobject.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) {
                ZipUtils.zipDirectory(fileList[i].getPath(), iBaseFolderLength, zos, crc);
                continue;
            }
            if (!fileList[i].isFile()) continue;
            ZipUtils.zipFile(fileList[i].getPath(), iBaseFolderLength, zos, crc);
        }
    }

    protected static void zipFile(String filePath, int iBaseFolderLength, ZipOutputStream jos, CRC32 crc) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filePath));){
            int byteCount;
            String fileNameEntry = filePath.substring(iBaseFolderLength).replace(File.separatorChar, '/');
            ZipEntry fileEntry = new ZipEntry(fileNameEntry);
            jos.putNextEntry(fileEntry);
            byte[] data = new byte[1024];
            while ((byteCount = bis.read(data, 0, 1024)) > -1) {
                if (crc != null) {
                    crc.update(data);
                }
                jos.write(data, 0, byteCount);
            }
            jos.closeEntry();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
    }

    public static void unzip(ZipFile zipFile, File dest) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        if (dest.exists() && dest.isDirectory()) {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File destFile = new File(dest, entry.getName());
                ZipUtils.createFileWithPath(destFile);
                BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(entry));
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));){
                    int nBytes;
                    byte[] buffer = new byte[2048];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, nBytes);
                    }
                    ((OutputStream)out).flush();
                }
                ((InputStream)in).close();
            }
        } else {
            throw new IOException("Destination " + dest.getAbsolutePath() + " is not a directory or does not exist");
        }
    }

    protected static void createFileWithPath(File f) throws IOException {
        String absPath = f.getAbsolutePath();
        StringTokenizer parser = new StringTokenizer(absPath, File.separator);
        StringBuffer globalPath = new StringBuffer(File.separator);
        while (parser.countTokens() > 1) {
            File currentDir = new File((globalPath = globalPath.append(parser.nextToken() + File.separator)).toString());
            if (currentDir.exists() || currentDir.mkdir()) continue;
            throw new IOException("Cannot create directory " + currentDir.getAbsolutePath());
        }
        if (!f.createNewFile()) {
            throw new IOException("Cannot create file " + f.getAbsolutePath());
        }
    }
}

