/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipOutputStream;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.util.ZipUtils;

@PublicAPI
public class JarUtils
extends ZipUtils {
    public static byte[] jarDirectoriesAndFiles(String[] directoriesAndFiles, String manifestVerion, String mainClass, String jarInternalClasspath, CRC32 crc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream((OutputStream)baos, JarUtils.createManifest(manifestVerion, mainClass, jarInternalClasspath));
        jos.setLevel(9);
        JarUtils.jarIt(jos, directoriesAndFiles, crc);
        jos.flush();
        jos.close();
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    protected static void jarIt(ZipOutputStream zos, String[] directoriesAndFiles, CRC32 crc) throws IOException {
        for (String pathElement : directoriesAndFiles) {
            File fileElement = new File(pathElement);
            pathElement = fileElement.getPath();
            if (fileElement.isFile()) {
                int length = pathElement.lastIndexOf(File.separator);
                if (length == -1) {
                    length = 0;
                }
                JarUtils.zipFile(pathElement, length, zos, crc);
                continue;
            }
            if (!fileElement.isDirectory()) continue;
            String strBaseFolder = pathElement.endsWith(File.separator) ? pathElement : pathElement + File.separator;
            JarUtils.zipDirectory(pathElement, strBaseFolder.length(), zos, crc);
        }
    }

    private static Manifest createManifest(String manifestVerion, String mainClass, String jarInternalClasspath) {
        Manifest manifest = new Manifest();
        Attributes manifestAttr = manifest.getMainAttributes();
        if (manifestVerion != null) {
            manifestAttr.putValue("Manifest-Version", manifestVerion);
            if (mainClass != null) {
                manifestAttr.putValue("Main-Class", mainClass);
            }
            if (jarInternalClasspath != null) {
                manifestAttr.putValue("Class-Path", jarInternalClasspath);
            }
        }
        return manifest;
    }

    public static void jar(String[] directoriesAndFiles, File dest, String manifestVerion, String mainClass, String jarInternalClasspath, CRC32 crc) throws IOException {
        byte[] jarred = JarUtils.jarDirectoriesAndFiles(directoriesAndFiles, manifestVerion, mainClass, jarInternalClasspath, crc);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));){
            bos.write(jarred);
        }
    }

    public static void unjar(JarFile jarFile, File dest) throws IOException {
        JarUtils.unzip(jarFile, dest);
    }
}

