# Stubs for gettext (Python 3.4)

from typing import Any, IO, List, Optional, Union, Callable

class NullTranslations:
    def __init__(self, fp: IO[str] = ...) -> None: ...
    def add_fallback(self, fallback: NullTranslations) -> None: ...
    def gettext(self, message: str) -> str: ...
    def lgettext(self, message: str) -> str: ...
    def ngettext(self, singular: str, plural: str, n: int) -> str: ...
    def lngettext(self, singular: str, plural: str, n: int) -> str: ...
    def info(self) -> Any: ...
    def charset(self) -> Any: ...
    def output_charset(self) -> Any: ...
    def set_output_charset(self, charset: Any) -> None: ...
    def install(self, names: List[str] = ...) -> None: ...

class GNUTranslations(NullTranslations):
    LE_MAGIC = ...  # type: int
    BE_MAGIC = ...  # type: int

def find(domain: str, localedir: str = ..., languages: List[str] = ...,
         all: bool = ...): ...

def translation(domain: str, localedir: str = ..., languages: List[str] = ...,
                class_: Callable[[IO[str]], NullTranslations] = ...,
                fallback: bool =... , codeset: Any = ...) -> NullTranslations: ...

def install(domain: str, localedir: str = ..., codeset: Any = ...,
            names: List[str] = ...): ...

def textdomain(domain: str = ...) -> str: ...
def bindtextdomain(domain: str, localedir: str = ...) -> str: ...
def bind_textdomain_codeset(domain: str, codeset: str = ...) -> str: ...
def dgettext(domain: str, message: str) -> str: ...
def ldgettext(domain: str, message: str) -> str: ...
def dngettext(domain: str, singular: str, plural: str, n: int) -> str: ...
def ldngettext(domain: str, singular: str, plural: str, n: int) -> str: ...
def gettext(message: str) -> str: ...
def lgettext(message: str) -> str: ...
def ngettext(singular: str, plural: str, n: int) -> str: ...
def lngettext(singular: str, plural: str, n: int) -> str: ...

Catalog = translation
