from sqlalchemy import Column
from sqlalchemy.types import Date, String

from gtfsdb.model.base import Base


class FeedInfo(Base):
    __tablename__ = 'feed_info'

    feed_publisher_name = Column(String(255), primary_key=True)
    feed_publisher_url = Column(String(255), nullable=False)
    feed_lang = Column(String(255), nullable=False)
    feed_start_date = Column(Date)
    feed_end_date = Column(Date)
    feed_version = Column(String(255))
    feed_license = Column(String(255))
