##############################################################################
#
# Copyright (c) 2005 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""WSGI-specific and compatible interfaces

See PEP-0333 for details.

$Id$
"""
__docformat__ = "reStructuredText"

import zope.interface
from zope.publisher.interfaces.http import IHeaderOutput


class IWSGIOutput(IHeaderOutput):
    """This class handles the output generated by the publisher. It is used to
    collect the headers and as an outstream to output the response body.
    """

    def getHeaders():
        """Return the response headers.

        The headers will be returned as a list of tuples according to the WSGI
        specification.
        """

    def write(data):
        """Write the response to the server.

        If the reponse has not begun, call the WSGI server's
        ``start_response()`` callable to begin the response.
        """


class IWSGIApplication(zope.interface.Interface):
    """A WSGI application."""

    def __call__(environ, start_response):
        """Called by a WSGI server.

        The ``environ`` parameter is a dictionary object, containing CGI-style
        environment variables. This object must be a builtin Python dictionary
        (not a subclass, UserDict or other dictionary emulation), and the
        application is allowed to modify the dictionary in any way it
        desires. The dictionary must also include certain WSGI-required
        variables (described in a later section), and may also include
        server-specific extension variables, named according to a convention
        that will be described below.

        The ``start_response`` parameter is a callable accepting two required
        positional arguments, and one optional argument. For the sake of
        illustration, we have named these arguments ``status``,
        ``response_headers``, and ``exc_info``, but they are not required to
        have these names, and the application must invoke the
        ``start_response`` callable using positional arguments
        (e.g. ``start_response(status, response_headers)``).
        """


class IWSGIServer(zope.interface.Interface):
    """A WSGI server."""

    def set_application(app):
        """Tells the server about the application to use."""


class IWSGIPublisherApplicationCreatedEvent(zope.interface.Interface):
    """A WSGI application has been created."""

    application = zope.interface.Attribute("The WSGI application.")


@zope.interface.implementer(IWSGIPublisherApplicationCreatedEvent)
class WSGIPublisherApplicationCreated(object):

    def __init__(self, application):
        self.application = application
