/* Copyright 2017 - 2022 R. Thomas
 * Copyright 2017 - 2022 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCR120_DLL_LOOKUP_H_
#define LIEF_PE_MSVCR120_DLL_LOOKUP_H_


namespace LIEF {
namespace PE {

const char* msvcr120_dll_lookup(uint32_t i) {
  switch(i) {
  case 0x0145: return "$I10_OUTPUT";
  case 0x0001: return "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z";
  case 0x0002: return "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z";
  case 0x0003: return "??0SchedulerPolicy@Concurrency@@QAA@IZZ";
  case 0x0004: return "??0SchedulerPolicy@Concurrency@@QAE@ABV01@@Z";
  case 0x0005: return "??0SchedulerPolicy@Concurrency@@QAE@XZ";
  case 0x0006: return "??0_Cancellation_beacon@details@Concurrency@@QAE@XZ";
  case 0x0007: return "??0_Condition_variable@details@Concurrency@@QAE@XZ";
  case 0x0008: return "??0_Context@details@Concurrency@@QAE@PAVContext@2@@Z";
  case 0x0009: return "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z";
  case 0x000a: return "??0_Interruption_exception@details@Concurrency@@QAE@XZ";
  case 0x000b: return "??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ";
  case 0x000c: return "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ";
  case 0x000d: return "??0_ReaderWriterLock@details@Concurrency@@QAE@XZ";
  case 0x000e: return "??0_ReentrantBlockingLock@details@Concurrency@@QAE@XZ";
  case 0x000f: return "??0_ReentrantLock@details@Concurrency@@QAE@XZ";
  case 0x0010: return "??0_ReentrantPPLLock@details@Concurrency@@QAE@XZ";
  case 0x0011: return "??0_Scheduler@details@Concurrency@@QAE@PAVScheduler@2@@Z";
  case 0x0012: return "??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z";
  case 0x0013: return "??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z";
  case 0x0014: return "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z";
  case 0x0015: return "??0_StructuredTaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z";
  case 0x0016: return "??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z";
  case 0x0017: return "??0_TaskCollection@details@Concurrency@@QAE@XZ";
  case 0x0018: return "??0_Timer@details@Concurrency@@IAE@I_N@Z";
  case 0x0019: return "??0__non_rtti_object@std@@QAE@ABV01@@Z";
  case 0x001a: return "??0__non_rtti_object@std@@QAE@PBD@Z";
  case 0x001b: return "??0bad_cast@std@@AAE@PBQBD@Z";
  case 0x001c: return "??0bad_cast@std@@QAE@ABV01@@Z";
  case 0x001d: return "??0bad_cast@std@@QAE@PBD@Z";
  case 0x001e: return "??0bad_target@Concurrency@@QAE@PBD@Z";
  case 0x001f: return "??0bad_target@Concurrency@@QAE@XZ";
  case 0x0020: return "??0bad_typeid@std@@QAE@ABV01@@Z";
  case 0x0021: return "??0bad_typeid@std@@QAE@PBD@Z";
  case 0x0022: return "??0context_self_unblock@Concurrency@@QAE@PBD@Z";
  case 0x0023: return "??0context_self_unblock@Concurrency@@QAE@XZ";
  case 0x0024: return "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z";
  case 0x0025: return "??0context_unblock_unbalanced@Concurrency@@QAE@XZ";
  case 0x0026: return "??0critical_section@Concurrency@@QAE@XZ";
  case 0x0027: return "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z";
  case 0x0028: return "??0default_scheduler_exists@Concurrency@@QAE@XZ";
  case 0x0029: return "??0event@Concurrency@@QAE@XZ";
  case 0x002a: return "??0exception@std@@QAE@ABQBD@Z";
  case 0x002b: return "??0exception@std@@QAE@ABQBDH@Z";
  case 0x002c: return "??0exception@std@@QAE@ABV01@@Z";
  case 0x002d: return "??0exception@std@@QAE@XZ";
  case 0x002e: return "??0improper_lock@Concurrency@@QAE@PBD@Z";
  case 0x002f: return "??0improper_lock@Concurrency@@QAE@XZ";
  case 0x0030: return "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z";
  case 0x0031: return "??0improper_scheduler_attach@Concurrency@@QAE@XZ";
  case 0x0032: return "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z";
  case 0x0033: return "??0improper_scheduler_detach@Concurrency@@QAE@XZ";
  case 0x0034: return "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z";
  case 0x0035: return "??0improper_scheduler_reference@Concurrency@@QAE@XZ";
  case 0x0036: return "??0invalid_link_target@Concurrency@@QAE@PBD@Z";
  case 0x0037: return "??0invalid_link_target@Concurrency@@QAE@XZ";
  case 0x0038: return "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z";
  case 0x0039: return "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ";
  case 0x003a: return "??0invalid_operation@Concurrency@@QAE@PBD@Z";
  case 0x003b: return "??0invalid_operation@Concurrency@@QAE@XZ";
  case 0x003c: return "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z";
  case 0x003d: return "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ";
  case 0x003e: return "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z";
  case 0x003f: return "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ";
  case 0x0040: return "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z";
  case 0x0041: return "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ";
  case 0x0042: return "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z";
  case 0x0043: return "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ";
  case 0x0044: return "??0message_not_found@Concurrency@@QAE@PBD@Z";
  case 0x0045: return "??0message_not_found@Concurrency@@QAE@XZ";
  case 0x0046: return "??0missing_wait@Concurrency@@QAE@PBD@Z";
  case 0x0047: return "??0missing_wait@Concurrency@@QAE@XZ";
  case 0x0048: return "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z";
  case 0x0049: return "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ";
  case 0x004a: return "??0operation_timed_out@Concurrency@@QAE@PBD@Z";
  case 0x004b: return "??0operation_timed_out@Concurrency@@QAE@XZ";
  case 0x004c: return "??0reader_writer_lock@Concurrency@@QAE@XZ";
  case 0x004d: return "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z";
  case 0x004e: return "??0scheduler_not_attached@Concurrency@@QAE@XZ";
  case 0x004f: return "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z";
  case 0x0050: return "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z";
  case 0x0051: return "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z";
  case 0x0052: return "??0scheduler_worker_creation_error@Concurrency@@QAE@PBDJ@Z";
  case 0x0053: return "??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z";
  case 0x0054: return "??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z";
  case 0x0055: return "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z";
  case 0x0056: return "??0task_canceled@Concurrency@@QAE@PBD@Z";
  case 0x0057: return "??0task_canceled@Concurrency@@QAE@XZ";
  case 0x0058: return "??0unsupported_os@Concurrency@@QAE@PBD@Z";
  case 0x0059: return "??0unsupported_os@Concurrency@@QAE@XZ";
  case 0x005a: return "??1SchedulerPolicy@Concurrency@@QAE@XZ";
  case 0x005b: return "??1_Cancellation_beacon@details@Concurrency@@QAE@XZ";
  case 0x005c: return "??1_Condition_variable@details@Concurrency@@QAE@XZ";
  case 0x005d: return "??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ";
  case 0x005e: return "??1_ReentrantBlockingLock@details@Concurrency@@QAE@XZ";
  case 0x005f: return "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ";
  case 0x0060: return "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ";
  case 0x0061: return "??1_SpinLock@details@Concurrency@@QAE@XZ";
  case 0x0062: return "??1_StructuredTaskCollection@details@Concurrency@@QAE@XZ";
  case 0x0063: return "??1_TaskCollection@details@Concurrency@@QAE@XZ";
  case 0x0064: return "??1_Timer@details@Concurrency@@MAE@XZ";
  case 0x0065: return "??1__non_rtti_object@std@@UAE@XZ";
  case 0x0066: return "??1bad_cast@std@@UAE@XZ";
  case 0x0067: return "??1bad_typeid@std@@UAE@XZ";
  case 0x0068: return "??1critical_section@Concurrency@@QAE@XZ";
  case 0x0069: return "??1event@Concurrency@@QAE@XZ";
  case 0x006a: return "??1exception@std@@UAE@XZ";
  case 0x006b: return "??1reader_writer_lock@Concurrency@@QAE@XZ";
  case 0x006c: return "??1scoped_lock@critical_section@Concurrency@@QAE@XZ";
  case 0x006d: return "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ";
  case 0x006e: return "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ";
  case 0x006f: return "??1type_info@@UAE@XZ";
  case 0x0070: return "??2@YAPAXI@Z";
  case 0x0071: return "??2@YAPAXIHPBDH@Z";
  case 0x0072: return "??3@YAXPAX@Z";
  case 0x0073: return "??3@YAXPAXHPBDH@Z";
  case 0x0074: return "??4?$_SpinWait@$00@details@Concurrency@@QAEAAV012@ABV012@@Z";
  case 0x0075: return "??4?$_SpinWait@$0A@@details@Concurrency@@QAEAAV012@ABV012@@Z";
  case 0x0076: return "??4SchedulerPolicy@Concurrency@@QAEAAV01@ABV01@@Z";
  case 0x0077: return "??4__non_rtti_object@std@@QAEAAV01@ABV01@@Z";
  case 0x0078: return "??4bad_cast@std@@QAEAAV01@ABV01@@Z";
  case 0x0079: return "??4bad_typeid@std@@QAEAAV01@ABV01@@Z";
  case 0x007a: return "??4exception@std@@QAEAAV01@ABV01@@Z";
  case 0x007b: return "??8type_info@@QBE_NABV0@@Z";
  case 0x007c: return "??9type_info@@QBE_NABV0@@Z";
  case 0x007d: return "??_7__non_rtti_object@std@@6B@";
  case 0x007e: return "??_7bad_cast@std@@6B@";
  case 0x007f: return "??_7bad_typeid@std@@6B@";
  case 0x0080: return "??_7exception@std@@6B@";
  case 0x0081: return "??_F?$_SpinWait@$00@details@Concurrency@@QAEXXZ";
  case 0x0082: return "??_F?$_SpinWait@$0A@@details@Concurrency@@QAEXXZ";
  case 0x0083: return "??_F_Context@details@Concurrency@@QAEXXZ";
  case 0x0084: return "??_F_Scheduler@details@Concurrency@@QAEXXZ";
  case 0x0085: return "??_Fbad_cast@std@@QAEXXZ";
  case 0x0086: return "??_Fbad_typeid@std@@QAEXXZ";
  case 0x0087: return "??_U@YAPAXI@Z";
  case 0x0088: return "??_U@YAPAXIHPBDH@Z";
  case 0x0089: return "??_V@YAXPAX@Z";
  case 0x008a: return "??_V@YAXPAXHPBDH@Z";
  case 0x008b: return "?Alloc@Concurrency@@YAPAXI@Z";
  case 0x008c: return "?Block@Context@Concurrency@@SAXXZ";
  case 0x008d: return "?CaptureCallstack@platform@details@Concurrency@@YAIPAPAXII@Z";
  case 0x008e: return "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z";
  case 0x008f: return "?Create@Scheduler@Concurrency@@SAPAV12@ABVSchedulerPolicy@2@@Z";
  case 0x0090: return "?CreateResourceManager@Concurrency@@YAPAUIResourceManager@1@XZ";
  case 0x0091: return "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@AAVlocation@2@@Z";
  case 0x0092: return "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@XZ";
  case 0x0093: return "?CurrentContext@Context@Concurrency@@SAPAV12@XZ";
  case 0x0094: return "?Detach@CurrentScheduler@Concurrency@@SAXXZ";
  case 0x0095: return "?DisableTracing@Concurrency@@YAJXZ";
  case 0x0096: return "?EnableTracing@Concurrency@@YAJXZ";
  case 0x0097: return "?Free@Concurrency@@YAXPAX@Z";
  case 0x0098: return "?Get@CurrentScheduler@Concurrency@@SAPAVScheduler@2@XZ";
  case 0x0099: return "?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ";
  case 0x009a: return "?GetExecutionContextId@Concurrency@@YAIXZ";
  case 0x009b: return "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ";
  case 0x009c: return "?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ";
  case 0x009d: return "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ";
  case 0x009e: return "?GetPolicyValue@SchedulerPolicy@Concurrency@@QBEIW4PolicyElementKey@2@@Z";
  case 0x009f: return "?GetProcessorCount@Concurrency@@YAIXZ";
  case 0x00a0: return "?GetProcessorNodeCount@Concurrency@@YAIXZ";
  case 0x00a1: return "?GetSchedulerId@Concurrency@@YAIXZ";
  case 0x00a2: return "?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ";
  case 0x00a3: return "?Id@Context@Concurrency@@SAIXZ";
  case 0x00a4: return "?Id@CurrentScheduler@Concurrency@@SAIXZ";
  case 0x00a5: return "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NABVlocation@2@@Z";
  case 0x00a6: return "?IsCurrentTaskCollectionCanceling@Context@Concurrency@@SA_NXZ";
  case 0x00a7: return "?Log2@details@Concurrency@@YAKI@Z";
  case 0x00a8: return "?Oversubscribe@Context@Concurrency@@SAX_N@Z";
  case 0x00a9: return "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z";
  case 0x00aa: return "?ResetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXXZ";
  case 0x00ab: return "?ScheduleGroupId@Context@Concurrency@@SAIXZ";
  case 0x00ac: return "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z";
  case 0x00ad: return "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0AAVlocation@2@@Z";
  case 0x00ae: return "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QAEXII@Z";
  case 0x00af: return "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z";
  case 0x00b0: return "?SetPolicyValue@SchedulerPolicy@Concurrency@@QAEIW4PolicyElementKey@2@I@Z";
  case 0x00b1: return "?VirtualProcessorId@Context@Concurrency@@SAIXZ";
  case 0x00b2: return "?Yield@Context@Concurrency@@SAXXZ";
  case 0x00b3: return "?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ";
  case 0x00b4: return "?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ";
  case 0x00b5: return "?_Acquire@_NonReentrantPPLLock@details@Concurrency@@QAEXPAX@Z";
  case 0x00b6: return "?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ";
  case 0x00b7: return "?_Acquire@_ReentrantLock@details@Concurrency@@QAEXXZ";
  case 0x00b8: return "?_Acquire@_ReentrantPPLLock@details@Concurrency@@QAEXPAX@Z";
  case 0x00b9: return "?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ";
  case 0x00ba: return "?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ";
  case 0x00bb: return "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ";
  case 0x00bc: return "?_Cancel@_TaskCollection@details@Concurrency@@QAEXXZ";
  case 0x00bd: return "?_CheckTaskCollection@_UnrealizedChore@details@Concurrency@@IAEXXZ";
  case 0x00be: return "?_CleanupToken@_StructuredTaskCollection@details@Concurrency@@AAEXXZ";
  case 0x00bf: return "?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z";
  case 0x00c0: return "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ";
  case 0x00c1: return "?_Confirm_cancel@_Cancellation_beacon@details@Concurrency@@QAE_NXZ";
  case 0x00c2: return "?_Copy_str@exception@std@@AAEXPBD@Z";
  case 0x00c3: return "?_CurrentContext@_Context@details@Concurrency@@SA?AV123@XZ";
  case 0x00c4: return "?_Current_node@location@Concurrency@@SA?AV12@XZ";
  case 0x00c5: return "?_Destroy@_AsyncTaskCollection@details@Concurrency@@EAEXXZ";
  case 0x00c6: return "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ";
  case 0x00c7: return "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ";
  case 0x00c8: return "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ";
  case 0x00c9: return "?_GetConcRTTraceInfo@Concurrency@@YAPBU_CONCRT_TRACE_INFO@details@1@XZ";
  case 0x00ca: return "?_GetConcurrency@details@Concurrency@@YAIXZ";
  case 0x00cb: return "?_GetCurrentInlineDepth@_StackGuard@details@Concurrency@@CAAAIXZ";
  case 0x00cc: return "?_GetNumberOfVirtualProcessors@_CurrentScheduler@details@Concurrency@@SAIXZ";
  case 0x00cd: return "?_GetScheduler@_Scheduler@details@Concurrency@@QAEPAVScheduler@3@XZ";
  case 0x00ce: return "?_Id@_CurrentScheduler@details@Concurrency@@SAIXZ";
  case 0x00cf: return "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QAE_NXZ";
  case 0x00d0: return "?_IsCanceling@_TaskCollection@details@Concurrency@@QAE_NXZ";
  case 0x00d1: return "?_IsSynchronouslyBlocked@_Context@details@Concurrency@@QBE_NXZ";
  case 0x00d2: return "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z";
  case 0x00d3: return "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z";
  case 0x00d4: return "?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z";
  case 0x00d5: return "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ";
  case 0x00d6: return "?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ";
  case 0x00d7: return "?_Oversubscribe@_Context@details@Concurrency@@SAX_N@Z";
  case 0x00d8: return "?_Reference@_Scheduler@details@Concurrency@@QAEIXZ";
  case 0x00d9: return "?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ";
  case 0x00da: return "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ";
  case 0x00db: return "?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ";
  case 0x00dc: return "?_Release@_ReentrantLock@details@Concurrency@@QAEXXZ";
  case 0x00dd: return "?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ";
  case 0x00de: return "?_Release@_Scheduler@details@Concurrency@@QAEIXZ";
  case 0x00df: return "?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ";
  case 0x00e0: return "?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ";
  case 0x00e1: return "?_ReportUnobservedException@details@Concurrency@@YAXXZ";
  case 0x00e2: return "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ";
  case 0x00e3: return "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ";
  case 0x00e4: return "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z";
  case 0x00e5: return "?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z";
  case 0x00e6: return "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z";
  case 0x00e7: return "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z";
  case 0x00e8: return "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z";
  case 0x00e9: return "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z";
  case 0x00ea: return "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPAX@Z0@Z";
  case 0x00eb: return "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z";
  case 0x00ec: return "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z";
  case 0x00ed: return "?_SetUnobservedExceptionHandler@details@Concurrency@@YAXP6AXXZ@Z";
  case 0x00ee: return "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ";
  case 0x00ef: return "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ";
  case 0x00f0: return "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ";
  case 0x00f1: return "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ";
  case 0x00f2: return "?_SpinYield@Context@Concurrency@@SAXXZ";
  case 0x00f3: return "?_Start@_Timer@details@Concurrency@@IAEXXZ";
  case 0x00f4: return "?_Stop@_Timer@details@Concurrency@@IAEXXZ";
  case 0x00f5: return "?_Tidy@exception@std@@AAEXXZ";
  case 0x00f6: return "?_Trace_agents@Concurrency@@YAXW4Agents_EventType@1@_JZZ";
  case 0x00f7: return "?_Trace_ppl_function@Concurrency@@YAXABU_GUID@@EW4ConcRT_EventType@1@@Z";
  case 0x00f8: return "?_TryAcquire@_NonReentrantBlockingLock@details@Concurrency@@QAE_NXZ";
  case 0x00f9: return "?_TryAcquire@_ReentrantBlockingLock@details@Concurrency@@QAE_NXZ";
  case 0x00fa: return "?_TryAcquire@_ReentrantLock@details@Concurrency@@QAE_NXZ";
  case 0x00fb: return "?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ";
  case 0x00fc: return "?_Type_info_dtor@type_info@@CAXPAV1@@Z";
  case 0x00fd: return "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z";
  case 0x00fe: return "?_UnderlyingYield@details@Concurrency@@YAXXZ";
  case 0x00ff: return "?_ValidateExecute@@YAHP6GHXZ@Z";
  case 0x0100: return "?_ValidateRead@@YAHPBXI@Z";
  case 0x0101: return "?_ValidateWrite@@YAHPAXI@Z";
  case 0x0102: return "?_Value@_SpinCount@details@Concurrency@@SAIXZ";
  case 0x0103: return "?_Yield@_Context@details@Concurrency@@SAXXZ";
  case 0x0104: return "?__ExceptionPtrAssign@@YAXPAXPBX@Z";
  case 0x0105: return "?__ExceptionPtrCompare@@YA_NPBX0@Z";
  case 0x0106: return "?__ExceptionPtrCopy@@YAXPAXPBX@Z";
  case 0x0107: return "?__ExceptionPtrCopyException@@YAXPAXPBX1@Z";
  case 0x0108: return "?__ExceptionPtrCreate@@YAXPAX@Z";
  case 0x0109: return "?__ExceptionPtrCurrentException@@YAXPAX@Z";
  case 0x010a: return "?__ExceptionPtrDestroy@@YAXPAX@Z";
  case 0x010b: return "?__ExceptionPtrRethrow@@YAXPBX@Z";
  case 0x010c: return "?__ExceptionPtrSwap@@YAXPAX0@Z";
  case 0x010d: return "?__ExceptionPtrToBool@@YA_NPBX@Z";
  case 0x010f: return "?_inconsistency@@YAXXZ";
  case 0x0110: return "?_invalid_parameter@@YAXPBG00II@Z";
  case 0x0111: return "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z";
  case 0x0112: return "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z";
  case 0x0113: return "?_open@@YAHPBDHH@Z";
  case 0x0114: return "?_query_new_handler@@YAP6AHI@ZXZ";
  case 0x0115: return "?_query_new_mode@@YAHXZ";
  case 0x0116: return "?_set_new_handler@@YAP6AHI@ZH@Z";
  case 0x0117: return "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z";
  case 0x0118: return "?_set_new_mode@@YAHH@Z";
  case 0x0119: return "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z";
  case 0x011a: return "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z";
  case 0x011b: return "?_sopen@@YAHPBDHHH@Z";
  case 0x011c: return "?_type_info_dtor_internal_method@type_info@@QAEXXZ";
  case 0x011d: return "?_wopen@@YAHPB_WHH@Z";
  case 0x011e: return "?_wsopen@@YAHPB_WHHH@Z";
  case 0x011f: return "?before@type_info@@QBE_NABV1@@Z";
  case 0x0120: return "?current@location@Concurrency@@SA?AV12@XZ";
  case 0x0121: return "?from_numa_node@location@Concurrency@@SA?AV12@G@Z";
  case 0x0122: return "?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ";
  case 0x0123: return "?lock@critical_section@Concurrency@@QAEXXZ";
  case 0x0124: return "?lock@reader_writer_lock@Concurrency@@QAEXXZ";
  case 0x0125: return "?lock_read@reader_writer_lock@Concurrency@@QAEXXZ";
  case 0x0126: return "?name@type_info@@QBEPBDPAU__type_info_node@@@Z";
  case 0x0127: return "?native_handle@critical_section@Concurrency@@QAEAAV12@XZ";
  case 0x0128: return "?notify_all@_Condition_variable@details@Concurrency@@QAEXXZ";
  case 0x0129: return "?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ";
  case 0x012a: return "?raw_name@type_info@@QBEPBDXZ";
  case 0x012b: return "?reset@event@Concurrency@@QAEXXZ";
  case 0x012c: return "?set@event@Concurrency@@QAEXXZ";
  case 0x012d: return "?set_new_handler@@YAP6AXXZP6AXXZ@Z";
  case 0x012e: return "?set_task_execution_resources@Concurrency@@YAXGPAU_GROUP_AFFINITY@@@Z";
  case 0x012f: return "?set_task_execution_resources@Concurrency@@YAXK@Z";
  case 0x0130: return "?set_terminate@@YAP6AXXZH@Z";
  case 0x0131: return "?set_terminate@@YAP6AXXZP6AXXZ@Z";
  case 0x0132: return "?set_unexpected@@YAP6AXXZH@Z";
  case 0x0133: return "?set_unexpected@@YAP6AXXZP6AXXZ@Z";
  case 0x0134: return "?swprintf@@YAHPAGIPBGZZ";
  case 0x0135: return "?swprintf@@YAHPA_WIPB_WZZ";
  case 0x0136: return "?terminate@@YAXXZ";
  case 0x0137: return "?try_lock@critical_section@Concurrency@@QAE_NXZ";
  case 0x0138: return "?try_lock@reader_writer_lock@Concurrency@@QAE_NXZ";
  case 0x0139: return "?try_lock_for@critical_section@Concurrency@@QAE_NI@Z";
  case 0x013a: return "?try_lock_read@reader_writer_lock@Concurrency@@QAE_NXZ";
  case 0x013b: return "?unexpected@@YAXXZ";
  case 0x013c: return "?unlock@critical_section@Concurrency@@QAEXXZ";
  case 0x013d: return "?unlock@reader_writer_lock@Concurrency@@QAEXXZ";
  case 0x013e: return "?vswprintf@@YAHPA_WIPB_WPAD@Z";
  case 0x013f: return "?wait@Concurrency@@YAXI@Z";
  case 0x0140: return "?wait@_Condition_variable@details@Concurrency@@QAEXAAVcritical_section@3@@Z";
  case 0x0141: return "?wait@event@Concurrency@@QAEII@Z";
  case 0x0142: return "?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z";
  case 0x0143: return "?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z";
  case 0x0144: return "?what@exception@std@@UBEPBDXZ";
  case 0x0146: return "_CIacos";
  case 0x0147: return "_CIasin";
  case 0x0148: return "_CIatan";
  case 0x0149: return "_CIatan2";
  case 0x014a: return "_CIcos";
  case 0x014b: return "_CIcosh";
  case 0x014c: return "_CIexp";
  case 0x014d: return "_CIfmod";
  case 0x014e: return "_CIlog";
  case 0x014f: return "_CIlog10";
  case 0x0150: return "_CIpow";
  case 0x0151: return "_CIsin";
  case 0x0152: return "_CIsinh";
  case 0x0153: return "_CIsqrt";
  case 0x0154: return "_CItan";
  case 0x0155: return "_CItanh";
  case 0x0156: return "_CRT_RTC_INIT";
  case 0x0157: return "_CRT_RTC_INITW";
  case 0x0158: return "_Cbuild";
  case 0x0159: return "_CreateFrameInfo";
  case 0x015a: return "_CxxThrowException";
  case 0x015b: return "_EH_prolog";
  case 0x015c: return "_FCbuild";
  case 0x015d: return "_FindAndUnlinkFrame";
  case 0x015e: return "_Getdays";
  case 0x015f: return "_Getmonths";
  case 0x0160: return "_Gettnames";
  case 0x0161: return "_HUGE";
  case 0x0162: return "_IsExceptionObjectToBeDestroyed";
  case 0x0163: return "_LCbuild";
  case 0x0164: return "_NLG_Dispatch2";
  case 0x0165: return "_NLG_Return";
  case 0x0166: return "_NLG_Return2";
  case 0x0167: return "_SetWinRTOutOfMemoryExceptionCallback";
  case 0x0168: return "_Strftime";
  case 0x0169: return "_W_Getdays";
  case 0x016a: return "_W_Getmonths";
  case 0x016b: return "_W_Gettnames";
  case 0x016c: return "_Wcsftime";
  case 0x016d: return "_XcptFilter";
  case 0x016e: return "__AdjustPointer";
  case 0x016f: return "__BuildCatchObject";
  case 0x0170: return "__BuildCatchObjectHelper";
  case 0x0171: return "__CppXcptFilter";
  case 0x0172: return "__CxxDetectRethrow";
  case 0x0173: return "__CxxExceptionFilter";
  case 0x0174: return "__CxxFrameHandler";
  case 0x0175: return "__CxxFrameHandler2";
  case 0x0176: return "__CxxFrameHandler3";
  case 0x0177: return "__CxxLongjmpUnwind";
  case 0x0178: return "__CxxQueryExceptionSize";
  case 0x0179: return "__CxxRegisterExceptionObject";
  case 0x017a: return "__CxxUnregisterExceptionObject";
  case 0x017b: return "__DestructExceptionObject";
  case 0x017c: return "__FrameUnwindFilter";
  case 0x017d: return "__GetPlatformExceptionInfo";
  case 0x017e: return "__RTCastToVoid";
  case 0x017f: return "__RTDynamicCast";
  case 0x0180: return "__RTtypeid";
  case 0x0181: return "__STRINGTOLD";
  case 0x0182: return "__STRINGTOLD_L";
  case 0x0183: return "__TypeMatch";
  case 0x0184: return "___lc_codepage_func";
  case 0x0185: return "___lc_collate_cp_func";
  case 0x0186: return "___lc_locale_name_func";
  case 0x0187: return "___mb_cur_max_func";
  case 0x0188: return "___mb_cur_max_l_func";
  case 0x0189: return "___setlc_active_func";
  case 0x018a: return "___unguarded_readlc_active_add_func";
  case 0x018b: return "__argc";
  case 0x018c: return "__argv";
  case 0x018d: return "__badioinfo";
  case 0x018e: return "__clean_type_info_names_internal";
  case 0x018f: return "__control87_2";
  case 0x0190: return "__create_locale";
  case 0x0191: return "__crtCompareStringA";
  case 0x0192: return "__crtCompareStringEx";
  case 0x0193: return "__crtCompareStringW";
  case 0x0194: return "__crtCreateEventExW";
  case 0x0195: return "__crtCreateSemaphoreExW";
  case 0x0196: return "__crtCreateSymbolicLinkW";
  case 0x0197: return "__crtEnumSystemLocalesEx";
  case 0x0198: return "__crtFlsAlloc";
  case 0x0199: return "__crtFlsFree";
  case 0x019a: return "__crtFlsGetValue";
  case 0x019b: return "__crtFlsSetValue";
  case 0x019c: return "__crtGetDateFormatEx";
  case 0x019d: return "__crtGetFileInformationByHandleEx";
  case 0x019e: return "__crtGetLocaleInfoEx";
  case 0x019f: return "__crtGetShowWindowMode";
  case 0x01a0: return "__crtGetTickCount64";
  case 0x01a1: return "__crtGetTimeFormatEx";
  case 0x01a2: return "__crtGetUserDefaultLocaleName";
  case 0x01a3: return "__crtInitializeCriticalSectionEx";
  case 0x01a4: return "__crtIsPackagedApp";
  case 0x01a5: return "__crtIsValidLocaleName";
  case 0x01a6: return "__crtLCMapStringA";
  case 0x01a7: return "__crtLCMapStringEx";
  case 0x01a8: return "__crtLCMapStringW";
  case 0x01a9: return "__crtSetFileInformationByHandle";
  case 0x01aa: return "__crtSetThreadStackGuarantee";
  case 0x01ab: return "__crtSetUnhandledExceptionFilter";
  case 0x01ac: return "__crtSleep";
  case 0x01ad: return "__crtTerminateProcess";
  case 0x01ae: return "__crtUnhandledException";
  case 0x01af: return "__daylight";
  case 0x01b0: return "__dllonexit";
  case 0x01b1: return "__doserrno";
  case 0x01b2: return "__dstbias";
  case 0x01b3: return "__fpecode";
  case 0x01b4: return "__free_locale";
  case 0x01b5: return "__get_current_locale";
  case 0x01b6: return "__get_flsindex";
  case 0x01b7: return "__get_tlsindex";
  case 0x01b8: return "__getmainargs";
  case 0x01b9: return "__initenv";
  case 0x01ba: return "__iob_func";
  case 0x01bb: return "__isascii";
  case 0x01bc: return "__iscsym";
  case 0x01bd: return "__iscsymf";
  case 0x01be: return "__iswcsym";
  case 0x01bf: return "__iswcsymf";
  case 0x01c0: return "__lconv";
  case 0x01c1: return "__lconv_init";
  case 0x01c2: return "__libm_sse2_acos";
  case 0x01c3: return "__libm_sse2_acosf";
  case 0x01c4: return "__libm_sse2_asin";
  case 0x01c5: return "__libm_sse2_asinf";
  case 0x01c6: return "__libm_sse2_atan";
  case 0x01c7: return "__libm_sse2_atan2";
  case 0x01c8: return "__libm_sse2_atanf";
  case 0x01c9: return "__libm_sse2_cos";
  case 0x01ca: return "__libm_sse2_cosf";
  case 0x01cb: return "__libm_sse2_exp";
  case 0x01cc: return "__libm_sse2_expf";
  case 0x01cd: return "__libm_sse2_log";
  case 0x01ce: return "__libm_sse2_log10";
  case 0x01cf: return "__libm_sse2_log10f";
  case 0x01d0: return "__libm_sse2_logf";
  case 0x01d1: return "__libm_sse2_pow";
  case 0x01d2: return "__libm_sse2_powf";
  case 0x01d3: return "__libm_sse2_sin";
  case 0x01d4: return "__libm_sse2_sinf";
  case 0x01d5: return "__libm_sse2_tan";
  case 0x01d6: return "__libm_sse2_tanf";
  case 0x01d7: return "__mb_cur_max";
  case 0x01d8: return "__p___argc";
  case 0x01d9: return "__p___argv";
  case 0x01da: return "__p___initenv";
  case 0x01db: return "__p___mb_cur_max";
  case 0x01dc: return "__p___wargv";
  case 0x01dd: return "__p___winitenv";
  case 0x01de: return "__p__acmdln";
  case 0x01df: return "__p__commode";
  case 0x01e0: return "__p__daylight";
  case 0x01e1: return "__p__dstbias";
  case 0x01e2: return "__p__environ";
  case 0x01e3: return "__p__fmode";
  case 0x01e4: return "__p__iob";
  case 0x01e5: return "__p__mbcasemap";
  case 0x01e6: return "__p__mbctype";
  case 0x01e7: return "__p__pctype";
  case 0x01e8: return "__p__pgmptr";
  case 0x01e9: return "__p__pwctype";
  case 0x01ea: return "__p__timezone";
  case 0x01eb: return "__p__tzname";
  case 0x01ec: return "__p__wcmdln";
  case 0x01ed: return "__p__wenviron";
  case 0x01ee: return "__p__wpgmptr";
  case 0x01ef: return "__pctype_func";
  case 0x01f0: return "__pioinfo";
  case 0x01f1: return "__pwctype_func";
  case 0x01f2: return "__pxcptinfoptrs";
  case 0x01f3: return "__report_gsfailure";
  case 0x01f4: return "__set_app_type";
  case 0x01f5: return "__setlc_active";
  case 0x01f6: return "__setusermatherr";
  case 0x01f7: return "__strncnt";
  case 0x01f8: return "__swprintf_l";
  case 0x01f9: return "__sys_errlist";
  case 0x01fa: return "__sys_nerr";
  case 0x01fb: return "__threadhandle";
  case 0x01fc: return "__threadid";
  case 0x01fd: return "__timezone";
  case 0x01fe: return "__toascii";
  case 0x01ff: return "__tzname";
  case 0x0200: return "__unDName";
  case 0x0201: return "__unDNameEx";
  case 0x0202: return "__unDNameHelper";
  case 0x010e: return "__uncaught_exception";
  case 0x0203: return "__unguarded_readlc_active";
  case 0x0204: return "__vswprintf_l";
  case 0x0205: return "__wargv";
  case 0x0206: return "__wcserror";
  case 0x0207: return "__wcserror_s";
  case 0x0208: return "__wcsncnt";
  case 0x0209: return "__wgetmainargs";
  case 0x020a: return "__winitenv";
  case 0x020b: return "_abnormal_termination";
  case 0x020c: return "_abs64";
  case 0x020d: return "_access";
  case 0x020e: return "_access_s";
  case 0x020f: return "_acmdln";
  case 0x0210: return "_aligned_free";
  case 0x0211: return "_aligned_malloc";
  case 0x0212: return "_aligned_msize";
  case 0x0213: return "_aligned_offset_malloc";
  case 0x0214: return "_aligned_offset_realloc";
  case 0x0215: return "_aligned_offset_recalloc";
  case 0x0216: return "_aligned_realloc";
  case 0x0217: return "_aligned_recalloc";
  case 0x0218: return "_amsg_exit";
  case 0x0219: return "_assert";
  case 0x021a: return "_atodbl";
  case 0x021b: return "_atodbl_l";
  case 0x021c: return "_atof_l";
  case 0x021d: return "_atoflt";
  case 0x021e: return "_atoflt_l";
  case 0x021f: return "_atoi64";
  case 0x0220: return "_atoi64_l";
  case 0x0221: return "_atoi_l";
  case 0x0222: return "_atol_l";
  case 0x0223: return "_atoldbl";
  case 0x0224: return "_atoldbl_l";
  case 0x0225: return "_atoll_l";
  case 0x0226: return "_beep";
  case 0x0227: return "_beginthread";
  case 0x0228: return "_beginthreadex";
  case 0x0229: return "_byteswap_uint64";
  case 0x022a: return "_byteswap_ulong";
  case 0x022b: return "_byteswap_ushort";
  case 0x022c: return "_c_exit";
  case 0x022d: return "_cabs";
  case 0x022e: return "_callnewh";
  case 0x022f: return "_calloc_crt";
  case 0x0230: return "_cexit";
  case 0x0231: return "_cgets";
  case 0x0232: return "_cgets_s";
  case 0x0233: return "_cgetws";
  case 0x0234: return "_cgetws_s";
  case 0x0235: return "_chdir";
  case 0x0236: return "_chdrive";
  case 0x0237: return "_chgsign";
  case 0x0238: return "_chgsignf";
  case 0x0239: return "_chkesp";
  case 0x023a: return "_chmod";
  case 0x023b: return "_chsize";
  case 0x023c: return "_chsize_s";
  case 0x023d: return "_clearfp";
  case 0x023e: return "_close";
  case 0x023f: return "_commit";
  case 0x0240: return "_commode";
  case 0x0241: return "_configthreadlocale";
  case 0x0242: return "_control87";
  case 0x0243: return "_controlfp";
  case 0x0244: return "_controlfp_s";
  case 0x0245: return "_copysign";
  case 0x0246: return "_copysignf";
  case 0x0247: return "_cprintf";
  case 0x0248: return "_cprintf_l";
  case 0x0249: return "_cprintf_p";
  case 0x024a: return "_cprintf_p_l";
  case 0x024b: return "_cprintf_s";
  case 0x024c: return "_cprintf_s_l";
  case 0x024d: return "_cputs";
  case 0x024e: return "_cputws";
  case 0x024f: return "_creat";
  case 0x0250: return "_create_locale";
  case 0x0251: return "_crt_debugger_hook";
  case 0x0252: return "_cscanf";
  case 0x0253: return "_cscanf_l";
  case 0x0254: return "_cscanf_s";
  case 0x0255: return "_cscanf_s_l";
  case 0x0256: return "_ctime32";
  case 0x0257: return "_ctime32_s";
  case 0x0258: return "_ctime64";
  case 0x0259: return "_ctime64_s";
  case 0x025a: return "_cwait";
  case 0x025b: return "_cwprintf";
  case 0x025c: return "_cwprintf_l";
  case 0x025d: return "_cwprintf_p";
  case 0x025e: return "_cwprintf_p_l";
  case 0x025f: return "_cwprintf_s";
  case 0x0260: return "_cwprintf_s_l";
  case 0x0261: return "_cwscanf";
  case 0x0262: return "_cwscanf_l";
  case 0x0263: return "_cwscanf_s";
  case 0x0264: return "_cwscanf_s_l";
  case 0x0265: return "_daylight";
  case 0x0266: return "_dclass";
  case 0x0267: return "_difftime32";
  case 0x0268: return "_difftime64";
  case 0x0269: return "_dosmaperr";
  case 0x026a: return "_dpcomp";
  case 0x026b: return "_dsign";
  case 0x026c: return "_dstbias";
  case 0x026d: return "_dtest";
  case 0x026e: return "_dup";
  case 0x026f: return "_dup2";
  case 0x0270: return "_dupenv_s";
  case 0x0271: return "_ecvt";
  case 0x0272: return "_ecvt_s";
  case 0x0273: return "_endthread";
  case 0x0274: return "_endthreadex";
  case 0x0275: return "_environ";
  case 0x0276: return "_eof";
  case 0x0277: return "_errno";
  case 0x0278: return "_except1";
  case 0x0279: return "_except_handler2";
  case 0x027a: return "_except_handler3";
  case 0x027b: return "_except_handler4_common";
  case 0x027c: return "_execl";
  case 0x027d: return "_execle";
  case 0x027e: return "_execlp";
  case 0x027f: return "_execlpe";
  case 0x0280: return "_execv";
  case 0x0281: return "_execve";
  case 0x0282: return "_execvp";
  case 0x0283: return "_execvpe";
  case 0x0284: return "_exit";
  case 0x0285: return "_expand";
  case 0x0286: return "_fclose_nolock";
  case 0x0287: return "_fcloseall";
  case 0x0288: return "_fcvt";
  case 0x0289: return "_fcvt_s";
  case 0x028a: return "_fdclass";
  case 0x028b: return "_fdopen";
  case 0x028c: return "_fdpcomp";
  case 0x028d: return "_fdsign";
  case 0x028e: return "_fdtest";
  case 0x028f: return "_fflush_nolock";
  case 0x0290: return "_fgetchar";
  case 0x0291: return "_fgetwc_nolock";
  case 0x0292: return "_fgetwchar";
  case 0x0293: return "_filbuf";
  case 0x0294: return "_filelength";
  case 0x0295: return "_filelengthi64";
  case 0x0296: return "_fileno";
  case 0x0297: return "_findclose";
  case 0x0298: return "_findfirst32";
  case 0x0299: return "_findfirst32i64";
  case 0x029a: return "_findfirst64";
  case 0x029b: return "_findfirst64i32";
  case 0x029c: return "_findnext32";
  case 0x029d: return "_findnext32i64";
  case 0x029e: return "_findnext64";
  case 0x029f: return "_findnext64i32";
  case 0x02a0: return "_finite";
  case 0x02a1: return "_flsbuf";
  case 0x02a2: return "_flushall";
  case 0x02a3: return "_fmode";
  case 0x02a4: return "_fpclass";
  case 0x02a5: return "_fpieee_flt";
  case 0x02a6: return "_fpreset";
  case 0x02a7: return "_fprintf_l";
  case 0x02a8: return "_fprintf_p";
  case 0x02a9: return "_fprintf_p_l";
  case 0x02aa: return "_fprintf_s_l";
  case 0x02ab: return "_fputchar";
  case 0x02ac: return "_fputwc_nolock";
  case 0x02ad: return "_fputwchar";
  case 0x02ae: return "_fread_nolock";
  case 0x02af: return "_fread_nolock_s";
  case 0x02b0: return "_free_locale";
  case 0x02b1: return "_freea";
  case 0x02b2: return "_freea_s";
  case 0x02b3: return "_freefls";
  case 0x02b4: return "_fscanf_l";
  case 0x02b5: return "_fscanf_s_l";
  case 0x02b6: return "_fseek_nolock";
  case 0x02b7: return "_fseeki64";
  case 0x02b8: return "_fseeki64_nolock";
  case 0x02b9: return "_fsopen";
  case 0x02ba: return "_fstat32";
  case 0x02bb: return "_fstat32i64";
  case 0x02bc: return "_fstat64";
  case 0x02bd: return "_fstat64i32";
  case 0x02be: return "_ftell_nolock";
  case 0x02bf: return "_ftelli64";
  case 0x02c0: return "_ftelli64_nolock";
  case 0x02c1: return "_ftime32";
  case 0x02c2: return "_ftime32_s";
  case 0x02c3: return "_ftime64";
  case 0x02c4: return "_ftime64_s";
  case 0x02c5: return "_ftol";
  case 0x02c6: return "_fullpath";
  case 0x02c7: return "_futime32";
  case 0x02c8: return "_futime64";
  case 0x02c9: return "_fwprintf_l";
  case 0x02ca: return "_fwprintf_p";
  case 0x02cb: return "_fwprintf_p_l";
  case 0x02cc: return "_fwprintf_s_l";
  case 0x02cd: return "_fwrite_nolock";
  case 0x02ce: return "_fwscanf_l";
  case 0x02cf: return "_fwscanf_s_l";
  case 0x02d0: return "_gcvt";
  case 0x02d1: return "_gcvt_s";
  case 0x02d2: return "_get_current_locale";
  case 0x02d3: return "_get_daylight";
  case 0x02d4: return "_get_doserrno";
  case 0x02d5: return "_get_dstbias";
  case 0x02d6: return "_get_errno";
  case 0x02d7: return "_get_fmode";
  case 0x02d8: return "_get_heap_handle";
  case 0x02d9: return "_get_invalid_parameter_handler";
  case 0x02da: return "_get_osfhandle";
  case 0x02db: return "_get_output_format";
  case 0x02dc: return "_get_pgmptr";
  case 0x02dd: return "_get_printf_count_output";
  case 0x02de: return "_get_purecall_handler";
  case 0x02df: return "_get_terminate";
  case 0x02e0: return "_get_timezone";
  case 0x02e1: return "_get_tzname";
  case 0x02e2: return "_get_unexpected";
  case 0x02e3: return "_get_wpgmptr";
  case 0x02e4: return "_getc_nolock";
  case 0x02e5: return "_getch";
  case 0x02e6: return "_getch_nolock";
  case 0x02e7: return "_getche";
  case 0x02e8: return "_getche_nolock";
  case 0x02e9: return "_getcwd";
  case 0x02ea: return "_getdcwd";
  case 0x02eb: return "_getdiskfree";
  case 0x02ec: return "_getdllprocaddr";
  case 0x02ed: return "_getdrive";
  case 0x02ee: return "_getdrives";
  case 0x02ef: return "_getmaxstdio";
  case 0x02f0: return "_getmbcp";
  case 0x02f1: return "_getpid";
  case 0x02f2: return "_getptd";
  case 0x02f3: return "_getsystime";
  case 0x02f4: return "_getw";
  case 0x02f5: return "_getwch";
  case 0x02f6: return "_getwch_nolock";
  case 0x02f7: return "_getwche";
  case 0x02f8: return "_getwche_nolock";
  case 0x02f9: return "_getws";
  case 0x02fa: return "_getws_s";
  case 0x02fb: return "_global_unwind2";
  case 0x02fc: return "_gmtime32";
  case 0x02fd: return "_gmtime32_s";
  case 0x02fe: return "_gmtime64";
  case 0x02ff: return "_gmtime64_s";
  case 0x0300: return "_heapadd";
  case 0x0301: return "_heapchk";
  case 0x0302: return "_heapmin";
  case 0x0303: return "_heapset";
  case 0x0304: return "_heapused";
  case 0x0305: return "_heapwalk";
  case 0x0306: return "_hypot";
  case 0x0307: return "_hypotf";
  case 0x0308: return "_i64toa";
  case 0x0309: return "_i64toa_s";
  case 0x030a: return "_i64tow";
  case 0x030b: return "_i64tow_s";
  case 0x030c: return "_initptd";
  case 0x030d: return "_initterm";
  case 0x030e: return "_initterm_e";
  case 0x030f: return "_inp";
  case 0x0310: return "_inpd";
  case 0x0311: return "_inpw";
  case 0x0312: return "_invalid_parameter";
  case 0x0313: return "_invalid_parameter_noinfo";
  case 0x0314: return "_invalid_parameter_noinfo_noreturn";
  case 0x0315: return "_invoke_watson";
  case 0x0316: return "_iob";
  case 0x0317: return "_isalnum_l";
  case 0x0318: return "_isalpha_l";
  case 0x0319: return "_isatty";
  case 0x031a: return "_isblank_l";
  case 0x031b: return "_iscntrl_l";
  case 0x031c: return "_isctype";
  case 0x031d: return "_isctype_l";
  case 0x031e: return "_isdigit_l";
  case 0x031f: return "_isgraph_l";
  case 0x0320: return "_isleadbyte_l";
  case 0x0321: return "_islower_l";
  case 0x0322: return "_ismbbalnum";
  case 0x0323: return "_ismbbalnum_l";
  case 0x0324: return "_ismbbalpha";
  case 0x0325: return "_ismbbalpha_l";
  case 0x0326: return "_ismbbblank";
  case 0x0327: return "_ismbbblank_l";
  case 0x0328: return "_ismbbgraph";
  case 0x0329: return "_ismbbgraph_l";
  case 0x032a: return "_ismbbkalnum";
  case 0x032b: return "_ismbbkalnum_l";
  case 0x032c: return "_ismbbkana";
  case 0x032d: return "_ismbbkana_l";
  case 0x032e: return "_ismbbkprint";
  case 0x032f: return "_ismbbkprint_l";
  case 0x0330: return "_ismbbkpunct";
  case 0x0331: return "_ismbbkpunct_l";
  case 0x0332: return "_ismbblead";
  case 0x0333: return "_ismbblead_l";
  case 0x0334: return "_ismbbprint";
  case 0x0335: return "_ismbbprint_l";
  case 0x0336: return "_ismbbpunct";
  case 0x0337: return "_ismbbpunct_l";
  case 0x0338: return "_ismbbtrail";
  case 0x0339: return "_ismbbtrail_l";
  case 0x033a: return "_ismbcalnum";
  case 0x033b: return "_ismbcalnum_l";
  case 0x033c: return "_ismbcalpha";
  case 0x033d: return "_ismbcalpha_l";
  case 0x033e: return "_ismbcblank";
  case 0x033f: return "_ismbcblank_l";
  case 0x0340: return "_ismbcdigit";
  case 0x0341: return "_ismbcdigit_l";
  case 0x0342: return "_ismbcgraph";
  case 0x0343: return "_ismbcgraph_l";
  case 0x0344: return "_ismbchira";
  case 0x0345: return "_ismbchira_l";
  case 0x0346: return "_ismbckata";
  case 0x0347: return "_ismbckata_l";
  case 0x0348: return "_ismbcl0";
  case 0x0349: return "_ismbcl0_l";
  case 0x034a: return "_ismbcl1";
  case 0x034b: return "_ismbcl1_l";
  case 0x034c: return "_ismbcl2";
  case 0x034d: return "_ismbcl2_l";
  case 0x034e: return "_ismbclegal";
  case 0x034f: return "_ismbclegal_l";
  case 0x0350: return "_ismbclower";
  case 0x0351: return "_ismbclower_l";
  case 0x0352: return "_ismbcprint";
  case 0x0353: return "_ismbcprint_l";
  case 0x0354: return "_ismbcpunct";
  case 0x0355: return "_ismbcpunct_l";
  case 0x0356: return "_ismbcspace";
  case 0x0357: return "_ismbcspace_l";
  case 0x0358: return "_ismbcsymbol";
  case 0x0359: return "_ismbcsymbol_l";
  case 0x035a: return "_ismbcupper";
  case 0x035b: return "_ismbcupper_l";
  case 0x035c: return "_ismbslead";
  case 0x035d: return "_ismbslead_l";
  case 0x035e: return "_ismbstrail";
  case 0x035f: return "_ismbstrail_l";
  case 0x0360: return "_isnan";
  case 0x0361: return "_isprint_l";
  case 0x0362: return "_ispunct_l";
  case 0x0363: return "_isspace_l";
  case 0x0364: return "_isupper_l";
  case 0x0365: return "_iswalnum_l";
  case 0x0366: return "_iswalpha_l";
  case 0x0367: return "_iswblank_l";
  case 0x0368: return "_iswcntrl_l";
  case 0x0369: return "_iswcsym_l";
  case 0x036a: return "_iswcsymf_l";
  case 0x036b: return "_iswctype_l";
  case 0x036c: return "_iswdigit_l";
  case 0x036d: return "_iswgraph_l";
  case 0x036e: return "_iswlower_l";
  case 0x036f: return "_iswprint_l";
  case 0x0370: return "_iswpunct_l";
  case 0x0371: return "_iswspace_l";
  case 0x0372: return "_iswupper_l";
  case 0x0373: return "_iswxdigit_l";
  case 0x0374: return "_isxdigit_l";
  case 0x0375: return "_itoa";
  case 0x0376: return "_itoa_s";
  case 0x0377: return "_itow";
  case 0x0378: return "_itow_s";
  case 0x0379: return "_j0";
  case 0x037a: return "_j1";
  case 0x037b: return "_jn";
  case 0x037c: return "_kbhit";
  case 0x037d: return "_ldclass";
  case 0x037e: return "_ldpcomp";
  case 0x037f: return "_ldsign";
  case 0x0380: return "_ldtest";
  case 0x0381: return "_lfind";
  case 0x0382: return "_lfind_s";
  case 0x0383: return "_libm_sse2_acos_precise";
  case 0x0384: return "_libm_sse2_asin_precise";
  case 0x0385: return "_libm_sse2_atan_precise";
  case 0x0386: return "_libm_sse2_cos_precise";
  case 0x0387: return "_libm_sse2_exp_precise";
  case 0x0388: return "_libm_sse2_log10_precise";
  case 0x0389: return "_libm_sse2_log_precise";
  case 0x038a: return "_libm_sse2_pow_precise";
  case 0x038b: return "_libm_sse2_sin_precise";
  case 0x038c: return "_libm_sse2_sqrt_precise";
  case 0x038d: return "_libm_sse2_tan_precise";
  case 0x038e: return "_loaddll";
  case 0x038f: return "_local_unwind2";
  case 0x0390: return "_local_unwind4";
  case 0x0391: return "_localtime32";
  case 0x0392: return "_localtime32_s";
  case 0x0393: return "_localtime64";
  case 0x0394: return "_localtime64_s";
  case 0x0395: return "_lock";
  case 0x0396: return "_lock_file";
  case 0x0397: return "_locking";
  case 0x0398: return "_logb";
  case 0x0399: return "_longjmpex";
  case 0x039a: return "_lrotl";
  case 0x039b: return "_lrotr";
  case 0x039c: return "_lsearch";
  case 0x039d: return "_lsearch_s";
  case 0x039e: return "_lseek";
  case 0x039f: return "_lseeki64";
  case 0x03a0: return "_ltoa";
  case 0x03a1: return "_ltoa_s";
  case 0x03a2: return "_ltow";
  case 0x03a3: return "_ltow_s";
  case 0x03a4: return "_makepath";
  case 0x03a5: return "_makepath_s";
  case 0x03a6: return "_malloc_crt";
  case 0x03a7: return "_mbbtombc";
  case 0x03a8: return "_mbbtombc_l";
  case 0x03a9: return "_mbbtype";
  case 0x03aa: return "_mbbtype_l";
  case 0x03ab: return "_mbcasemap";
  case 0x03ac: return "_mbccpy";
  case 0x03ad: return "_mbccpy_l";
  case 0x03ae: return "_mbccpy_s";
  case 0x03af: return "_mbccpy_s_l";
  case 0x03b0: return "_mbcjistojms";
  case 0x03b1: return "_mbcjistojms_l";
  case 0x03b2: return "_mbcjmstojis";
  case 0x03b3: return "_mbcjmstojis_l";
  case 0x03b4: return "_mbclen";
  case 0x03b5: return "_mbclen_l";
  case 0x03b6: return "_mbctohira";
  case 0x03b7: return "_mbctohira_l";
  case 0x03b8: return "_mbctokata";
  case 0x03b9: return "_mbctokata_l";
  case 0x03ba: return "_mbctolower";
  case 0x03bb: return "_mbctolower_l";
  case 0x03bc: return "_mbctombb";
  case 0x03bd: return "_mbctombb_l";
  case 0x03be: return "_mbctoupper";
  case 0x03bf: return "_mbctoupper_l";
  case 0x03c0: return "_mbctype";
  case 0x03c1: return "_mblen_l";
  case 0x03c2: return "_mbsbtype";
  case 0x03c3: return "_mbsbtype_l";
  case 0x03c4: return "_mbscat_s";
  case 0x03c5: return "_mbscat_s_l";
  case 0x03c6: return "_mbschr";
  case 0x03c7: return "_mbschr_l";
  case 0x03c8: return "_mbscmp";
  case 0x03c9: return "_mbscmp_l";
  case 0x03ca: return "_mbscoll";
  case 0x03cb: return "_mbscoll_l";
  case 0x03cc: return "_mbscpy_s";
  case 0x03cd: return "_mbscpy_s_l";
  case 0x03ce: return "_mbscspn";
  case 0x03cf: return "_mbscspn_l";
  case 0x03d0: return "_mbsdec";
  case 0x03d1: return "_mbsdec_l";
  case 0x03d2: return "_mbsicmp";
  case 0x03d3: return "_mbsicmp_l";
  case 0x03d4: return "_mbsicoll";
  case 0x03d5: return "_mbsicoll_l";
  case 0x03d6: return "_mbsinc";
  case 0x03d7: return "_mbsinc_l";
  case 0x03d8: return "_mbslen";
  case 0x03d9: return "_mbslen_l";
  case 0x03da: return "_mbslwr";
  case 0x03db: return "_mbslwr_l";
  case 0x03dc: return "_mbslwr_s";
  case 0x03dd: return "_mbslwr_s_l";
  case 0x03de: return "_mbsnbcat";
  case 0x03df: return "_mbsnbcat_l";
  case 0x03e0: return "_mbsnbcat_s";
  case 0x03e1: return "_mbsnbcat_s_l";
  case 0x03e2: return "_mbsnbcmp";
  case 0x03e3: return "_mbsnbcmp_l";
  case 0x03e4: return "_mbsnbcnt";
  case 0x03e5: return "_mbsnbcnt_l";
  case 0x03e6: return "_mbsnbcoll";
  case 0x03e7: return "_mbsnbcoll_l";
  case 0x03e8: return "_mbsnbcpy";
  case 0x03e9: return "_mbsnbcpy_l";
  case 0x03ea: return "_mbsnbcpy_s";
  case 0x03eb: return "_mbsnbcpy_s_l";
  case 0x03ec: return "_mbsnbicmp";
  case 0x03ed: return "_mbsnbicmp_l";
  case 0x03ee: return "_mbsnbicoll";
  case 0x03ef: return "_mbsnbicoll_l";
  case 0x03f0: return "_mbsnbset";
  case 0x03f1: return "_mbsnbset_l";
  case 0x03f2: return "_mbsnbset_s";
  case 0x03f3: return "_mbsnbset_s_l";
  case 0x03f4: return "_mbsncat";
  case 0x03f5: return "_mbsncat_l";
  case 0x03f6: return "_mbsncat_s";
  case 0x03f7: return "_mbsncat_s_l";
  case 0x03f8: return "_mbsnccnt";
  case 0x03f9: return "_mbsnccnt_l";
  case 0x03fa: return "_mbsncmp";
  case 0x03fb: return "_mbsncmp_l";
  case 0x03fc: return "_mbsncoll";
  case 0x03fd: return "_mbsncoll_l";
  case 0x03fe: return "_mbsncpy";
  case 0x03ff: return "_mbsncpy_l";
  case 0x0400: return "_mbsncpy_s";
  case 0x0401: return "_mbsncpy_s_l";
  case 0x0402: return "_mbsnextc";
  case 0x0403: return "_mbsnextc_l";
  case 0x0404: return "_mbsnicmp";
  case 0x0405: return "_mbsnicmp_l";
  case 0x0406: return "_mbsnicoll";
  case 0x0407: return "_mbsnicoll_l";
  case 0x0408: return "_mbsninc";
  case 0x0409: return "_mbsninc_l";
  case 0x040a: return "_mbsnlen";
  case 0x040b: return "_mbsnlen_l";
  case 0x040c: return "_mbsnset";
  case 0x040d: return "_mbsnset_l";
  case 0x040e: return "_mbsnset_s";
  case 0x040f: return "_mbsnset_s_l";
  case 0x0410: return "_mbspbrk";
  case 0x0411: return "_mbspbrk_l";
  case 0x0412: return "_mbsrchr";
  case 0x0413: return "_mbsrchr_l";
  case 0x0414: return "_mbsrev";
  case 0x0415: return "_mbsrev_l";
  case 0x0416: return "_mbsset";
  case 0x0417: return "_mbsset_l";
  case 0x0418: return "_mbsset_s";
  case 0x0419: return "_mbsset_s_l";
  case 0x041a: return "_mbsspn";
  case 0x041b: return "_mbsspn_l";
  case 0x041c: return "_mbsspnp";
  case 0x041d: return "_mbsspnp_l";
  case 0x041e: return "_mbsstr";
  case 0x041f: return "_mbsstr_l";
  case 0x0420: return "_mbstok";
  case 0x0421: return "_mbstok_l";
  case 0x0422: return "_mbstok_s";
  case 0x0423: return "_mbstok_s_l";
  case 0x0424: return "_mbstowcs_l";
  case 0x0425: return "_mbstowcs_s_l";
  case 0x0426: return "_mbstrlen";
  case 0x0427: return "_mbstrlen_l";
  case 0x0428: return "_mbstrnlen";
  case 0x0429: return "_mbstrnlen_l";
  case 0x042a: return "_mbsupr";
  case 0x042b: return "_mbsupr_l";
  case 0x042c: return "_mbsupr_s";
  case 0x042d: return "_mbsupr_s_l";
  case 0x042e: return "_mbtowc_l";
  case 0x042f: return "_memccpy";
  case 0x0430: return "_memicmp";
  case 0x0431: return "_memicmp_l";
  case 0x0432: return "_mkdir";
  case 0x0433: return "_mkgmtime32";
  case 0x0434: return "_mkgmtime64";
  case 0x0435: return "_mktemp";
  case 0x0436: return "_mktemp_s";
  case 0x0437: return "_mktime32";
  case 0x0438: return "_mktime64";
  case 0x0439: return "_msize";
  case 0x043a: return "_nextafter";
  case 0x043b: return "_onexit";
  case 0x043c: return "_open";
  case 0x043d: return "_open_osfhandle";
  case 0x043e: return "_outp";
  case 0x043f: return "_outpd";
  case 0x0440: return "_outpw";
  case 0x0441: return "_pclose";
  case 0x0442: return "_pctype";
  case 0x0443: return "_pgmptr";
  case 0x0444: return "_pipe";
  case 0x0445: return "_popen";
  case 0x0446: return "_printf_l";
  case 0x0447: return "_printf_p";
  case 0x0448: return "_printf_p_l";
  case 0x0449: return "_printf_s_l";
  case 0x044a: return "_purecall";
  case 0x044b: return "_putch";
  case 0x044c: return "_putch_nolock";
  case 0x044d: return "_putenv";
  case 0x044e: return "_putenv_s";
  case 0x044f: return "_putw";
  case 0x0450: return "_putwch";
  case 0x0451: return "_putwch_nolock";
  case 0x0452: return "_putws";
  case 0x0453: return "_pwctype";
  case 0x0454: return "_read";
  case 0x0455: return "_realloc_crt";
  case 0x0456: return "_recalloc";
  case 0x0457: return "_recalloc_crt";
  case 0x0458: return "_resetstkoflw";
  case 0x0459: return "_rmdir";
  case 0x045a: return "_rmtmp";
  case 0x045b: return "_rotl";
  case 0x045c: return "_rotl64";
  case 0x045d: return "_rotr";
  case 0x045e: return "_rotr64";
  case 0x045f: return "_scalb";
  case 0x0460: return "_scanf_l";
  case 0x0461: return "_scanf_s_l";
  case 0x0462: return "_scprintf";
  case 0x0463: return "_scprintf_l";
  case 0x0464: return "_scprintf_p";
  case 0x0465: return "_scprintf_p_l";
  case 0x0466: return "_scwprintf";
  case 0x0467: return "_scwprintf_l";
  case 0x0468: return "_scwprintf_p";
  case 0x0469: return "_scwprintf_p_l";
  case 0x046a: return "_searchenv";
  case 0x046b: return "_searchenv_s";
  case 0x046d: return "_seh_longjmp_unwind";
  case 0x046c: return "_seh_longjmp_unwind4";
  case 0x046e: return "_set_SSE2_enable";
  case 0x046f: return "_set_abort_behavior";
  case 0x0470: return "_set_controlfp";
  case 0x0471: return "_set_doserrno";
  case 0x0472: return "_set_errno";
  case 0x0473: return "_set_error_mode";
  case 0x0474: return "_set_fmode";
  case 0x0475: return "_set_invalid_parameter_handler";
  case 0x0476: return "_set_malloc_crt_max_wait";
  case 0x0477: return "_set_output_format";
  case 0x0478: return "_set_printf_count_output";
  case 0x0479: return "_set_purecall_handler";
  case 0x047a: return "_seterrormode";
  case 0x047b: return "_setjmp";
  case 0x047c: return "_setjmp3";
  case 0x047d: return "_setmaxstdio";
  case 0x047e: return "_setmbcp";
  case 0x047f: return "_setmode";
  case 0x0480: return "_setsystime";
  case 0x0481: return "_sleep";
  case 0x0482: return "_snprintf";
  case 0x0483: return "_snprintf_c";
  case 0x0484: return "_snprintf_c_l";
  case 0x0485: return "_snprintf_l";
  case 0x0486: return "_snprintf_s";
  case 0x0487: return "_snprintf_s_l";
  case 0x0488: return "_snscanf";
  case 0x0489: return "_snscanf_l";
  case 0x048a: return "_snscanf_s";
  case 0x048b: return "_snscanf_s_l";
  case 0x048c: return "_snwprintf";
  case 0x048d: return "_snwprintf_l";
  case 0x048e: return "_snwprintf_s";
  case 0x048f: return "_snwprintf_s_l";
  case 0x0490: return "_snwscanf";
  case 0x0491: return "_snwscanf_l";
  case 0x0492: return "_snwscanf_s";
  case 0x0493: return "_snwscanf_s_l";
  case 0x0494: return "_sopen";
  case 0x0495: return "_sopen_s";
  case 0x0496: return "_spawnl";
  case 0x0497: return "_spawnle";
  case 0x0498: return "_spawnlp";
  case 0x0499: return "_spawnlpe";
  case 0x049a: return "_spawnv";
  case 0x049b: return "_spawnve";
  case 0x049c: return "_spawnvp";
  case 0x049d: return "_spawnvpe";
  case 0x049e: return "_splitpath";
  case 0x049f: return "_splitpath_s";
  case 0x04a0: return "_sprintf_l";
  case 0x04a1: return "_sprintf_p";
  case 0x04a2: return "_sprintf_p_l";
  case 0x04a3: return "_sprintf_s_l";
  case 0x04a4: return "_sscanf_l";
  case 0x04a5: return "_sscanf_s_l";
  case 0x04a6: return "_stat32";
  case 0x04a7: return "_stat32i64";
  case 0x04a8: return "_stat64";
  case 0x04a9: return "_stat64i32";
  case 0x04aa: return "_statusfp";
  case 0x04ab: return "_statusfp2";
  case 0x04ac: return "_strcoll_l";
  case 0x04ad: return "_strdate";
  case 0x04ae: return "_strdate_s";
  case 0x04af: return "_strdup";
  case 0x04b0: return "_strerror";
  case 0x04b1: return "_strerror_s";
  case 0x04b2: return "_strftime_l";
  case 0x04b3: return "_stricmp";
  case 0x04b4: return "_stricmp_l";
  case 0x04b5: return "_stricoll";
  case 0x04b6: return "_stricoll_l";
  case 0x04b7: return "_strlwr";
  case 0x04b8: return "_strlwr_l";
  case 0x04b9: return "_strlwr_s";
  case 0x04ba: return "_strlwr_s_l";
  case 0x04bb: return "_strncoll";
  case 0x04bc: return "_strncoll_l";
  case 0x04bd: return "_strnicmp";
  case 0x04be: return "_strnicmp_l";
  case 0x04bf: return "_strnicoll";
  case 0x04c0: return "_strnicoll_l";
  case 0x04c1: return "_strnset";
  case 0x04c2: return "_strnset_s";
  case 0x04c3: return "_strrev";
  case 0x04c4: return "_strset";
  case 0x04c5: return "_strset_s";
  case 0x04c6: return "_strtime";
  case 0x04c7: return "_strtime_s";
  case 0x04c8: return "_strtod_l";
  case 0x04c9: return "_strtof_l";
  case 0x04ca: return "_strtoi64";
  case 0x04cb: return "_strtoi64_l";
  case 0x04cc: return "_strtoimax_l";
  case 0x04cd: return "_strtol_l";
  case 0x04ce: return "_strtold_l";
  case 0x04cf: return "_strtoll_l";
  case 0x04d0: return "_strtoui64";
  case 0x04d1: return "_strtoui64_l";
  case 0x04d2: return "_strtoul_l";
  case 0x04d3: return "_strtoull_l";
  case 0x04d4: return "_strtoumax_l";
  case 0x04d5: return "_strupr";
  case 0x04d6: return "_strupr_l";
  case 0x04d7: return "_strupr_s";
  case 0x04d8: return "_strupr_s_l";
  case 0x04d9: return "_strxfrm_l";
  case 0x04da: return "_swab";
  case 0x04db: return "_swprintf";
  case 0x04dc: return "_swprintf_c";
  case 0x04dd: return "_swprintf_c_l";
  case 0x04de: return "_swprintf_p";
  case 0x04df: return "_swprintf_p_l";
  case 0x04e0: return "_swprintf_s_l";
  case 0x04e1: return "_swscanf_l";
  case 0x04e2: return "_swscanf_s_l";
  case 0x04e3: return "_sys_errlist";
  case 0x04e4: return "_sys_nerr";
  case 0x04e5: return "_tell";
  case 0x04e6: return "_telli64";
  case 0x04e7: return "_tempnam";
  case 0x04e8: return "_time32";
  case 0x04e9: return "_time64";
  case 0x04ea: return "_timezone";
  case 0x04eb: return "_tolower";
  case 0x04ec: return "_tolower_l";
  case 0x04ed: return "_toupper";
  case 0x04ee: return "_toupper_l";
  case 0x04ef: return "_towlower_l";
  case 0x04f0: return "_towupper_l";
  case 0x04f1: return "_tzname";
  case 0x04f2: return "_tzset";
  case 0x04f3: return "_ui64toa";
  case 0x04f4: return "_ui64toa_s";
  case 0x04f5: return "_ui64tow";
  case 0x04f6: return "_ui64tow_s";
  case 0x04f7: return "_ultoa";
  case 0x04f8: return "_ultoa_s";
  case 0x04f9: return "_ultow";
  case 0x04fa: return "_ultow_s";
  case 0x04fb: return "_umask";
  case 0x04fc: return "_umask_s";
  case 0x04fd: return "_ungetc_nolock";
  case 0x04fe: return "_ungetch";
  case 0x04ff: return "_ungetch_nolock";
  case 0x0500: return "_ungetwc_nolock";
  case 0x0501: return "_ungetwch";
  case 0x0502: return "_ungetwch_nolock";
  case 0x0503: return "_unlink";
  case 0x0504: return "_unloaddll";
  case 0x0505: return "_unlock";
  case 0x0506: return "_unlock_file";
  case 0x0507: return "_utime32";
  case 0x0508: return "_utime64";
  case 0x0509: return "_vacopy";
  case 0x050a: return "_vcprintf";
  case 0x050b: return "_vcprintf_l";
  case 0x050c: return "_vcprintf_p";
  case 0x050d: return "_vcprintf_p_l";
  case 0x050e: return "_vcprintf_s";
  case 0x050f: return "_vcprintf_s_l";
  case 0x0510: return "_vcwprintf";
  case 0x0511: return "_vcwprintf_l";
  case 0x0512: return "_vcwprintf_p";
  case 0x0513: return "_vcwprintf_p_l";
  case 0x0514: return "_vcwprintf_s";
  case 0x0515: return "_vcwprintf_s_l";
  case 0x0516: return "_vfprintf_l";
  case 0x0517: return "_vfprintf_p";
  case 0x0518: return "_vfprintf_p_l";
  case 0x0519: return "_vfprintf_s_l";
  case 0x051a: return "_vfwprintf_l";
  case 0x051b: return "_vfwprintf_p";
  case 0x051c: return "_vfwprintf_p_l";
  case 0x051d: return "_vfwprintf_s_l";
  case 0x051e: return "_vprintf_l";
  case 0x051f: return "_vprintf_p";
  case 0x0520: return "_vprintf_p_l";
  case 0x0521: return "_vprintf_s_l";
  case 0x0522: return "_vscprintf";
  case 0x0523: return "_vscprintf_l";
  case 0x0524: return "_vscprintf_p";
  case 0x0525: return "_vscprintf_p_l";
  case 0x0526: return "_vscwprintf";
  case 0x0527: return "_vscwprintf_l";
  case 0x0528: return "_vscwprintf_p";
  case 0x0529: return "_vscwprintf_p_l";
  case 0x052a: return "_vsnprintf";
  case 0x052b: return "_vsnprintf_c";
  case 0x052c: return "_vsnprintf_c_l";
  case 0x052d: return "_vsnprintf_l";
  case 0x052e: return "_vsnprintf_s";
  case 0x052f: return "_vsnprintf_s_l";
  case 0x0530: return "_vsnwprintf";
  case 0x0531: return "_vsnwprintf_l";
  case 0x0532: return "_vsnwprintf_s";
  case 0x0533: return "_vsnwprintf_s_l";
  case 0x0534: return "_vsprintf_l";
  case 0x0535: return "_vsprintf_p";
  case 0x0536: return "_vsprintf_p_l";
  case 0x0537: return "_vsprintf_s_l";
  case 0x0538: return "_vswprintf";
  case 0x0539: return "_vswprintf_c";
  case 0x053a: return "_vswprintf_c_l";
  case 0x053b: return "_vswprintf_l";
  case 0x053c: return "_vswprintf_p";
  case 0x053d: return "_vswprintf_p_l";
  case 0x053e: return "_vswprintf_s_l";
  case 0x053f: return "_vwprintf_l";
  case 0x0540: return "_vwprintf_p";
  case 0x0541: return "_vwprintf_p_l";
  case 0x0542: return "_vwprintf_s_l";
  case 0x0543: return "_waccess";
  case 0x0544: return "_waccess_s";
  case 0x0545: return "_wasctime";
  case 0x0546: return "_wasctime_s";
  case 0x0547: return "_wassert";
  case 0x0548: return "_wchdir";
  case 0x0549: return "_wchmod";
  case 0x054a: return "_wcmdln";
  case 0x054b: return "_wcreat";
  case 0x054c: return "_wcreate_locale";
  case 0x054d: return "_wcscoll_l";
  case 0x054e: return "_wcsdup";
  case 0x054f: return "_wcserror";
  case 0x0550: return "_wcserror_s";
  case 0x0551: return "_wcsftime_l";
  case 0x0552: return "_wcsicmp";
  case 0x0553: return "_wcsicmp_l";
  case 0x0554: return "_wcsicoll";
  case 0x0555: return "_wcsicoll_l";
  case 0x0556: return "_wcslwr";
  case 0x0557: return "_wcslwr_l";
  case 0x0558: return "_wcslwr_s";
  case 0x0559: return "_wcslwr_s_l";
  case 0x055a: return "_wcsncoll";
  case 0x055b: return "_wcsncoll_l";
  case 0x055c: return "_wcsnicmp";
  case 0x055d: return "_wcsnicmp_l";
  case 0x055e: return "_wcsnicoll";
  case 0x055f: return "_wcsnicoll_l";
  case 0x0560: return "_wcsnset";
  case 0x0561: return "_wcsnset_s";
  case 0x0562: return "_wcsrev";
  case 0x0563: return "_wcsset";
  case 0x0564: return "_wcsset_s";
  case 0x0565: return "_wcstod_l";
  case 0x0566: return "_wcstof_l";
  case 0x0567: return "_wcstoi64";
  case 0x0568: return "_wcstoi64_l";
  case 0x0569: return "_wcstoimax_l";
  case 0x056a: return "_wcstol_l";
  case 0x056b: return "_wcstold_l";
  case 0x056c: return "_wcstoll_l";
  case 0x056d: return "_wcstombs_l";
  case 0x056e: return "_wcstombs_s_l";
  case 0x056f: return "_wcstoui64";
  case 0x0570: return "_wcstoui64_l";
  case 0x0571: return "_wcstoul_l";
  case 0x0572: return "_wcstoull_l";
  case 0x0573: return "_wcstoumax_l";
  case 0x0574: return "_wcsupr";
  case 0x0575: return "_wcsupr_l";
  case 0x0576: return "_wcsupr_s";
  case 0x0577: return "_wcsupr_s_l";
  case 0x0578: return "_wcsxfrm_l";
  case 0x0579: return "_wctime32";
  case 0x057a: return "_wctime32_s";
  case 0x057b: return "_wctime64";
  case 0x057c: return "_wctime64_s";
  case 0x057d: return "_wctomb_l";
  case 0x057e: return "_wctomb_s_l";
  case 0x057f: return "_wctype";
  case 0x0580: return "_wdupenv_s";
  case 0x0581: return "_wenviron";
  case 0x0582: return "_wexecl";
  case 0x0583: return "_wexecle";
  case 0x0584: return "_wexeclp";
  case 0x0585: return "_wexeclpe";
  case 0x0586: return "_wexecv";
  case 0x0587: return "_wexecve";
  case 0x0588: return "_wexecvp";
  case 0x0589: return "_wexecvpe";
  case 0x058a: return "_wfdopen";
  case 0x058b: return "_wfindfirst32";
  case 0x058c: return "_wfindfirst32i64";
  case 0x058d: return "_wfindfirst64";
  case 0x058e: return "_wfindfirst64i32";
  case 0x058f: return "_wfindnext32";
  case 0x0590: return "_wfindnext32i64";
  case 0x0591: return "_wfindnext64";
  case 0x0592: return "_wfindnext64i32";
  case 0x0593: return "_wfopen";
  case 0x0594: return "_wfopen_s";
  case 0x0595: return "_wfreopen";
  case 0x0596: return "_wfreopen_s";
  case 0x0597: return "_wfsopen";
  case 0x0598: return "_wfullpath";
  case 0x0599: return "_wgetcwd";
  case 0x059a: return "_wgetdcwd";
  case 0x059b: return "_wgetenv";
  case 0x059c: return "_wgetenv_s";
  case 0x059d: return "_wmakepath";
  case 0x059e: return "_wmakepath_s";
  case 0x059f: return "_wmkdir";
  case 0x05a0: return "_wmktemp";
  case 0x05a1: return "_wmktemp_s";
  case 0x05a2: return "_wopen";
  case 0x05a3: return "_wperror";
  case 0x05a4: return "_wpgmptr";
  case 0x05a5: return "_wpopen";
  case 0x05a6: return "_wprintf_l";
  case 0x05a7: return "_wprintf_p";
  case 0x05a8: return "_wprintf_p_l";
  case 0x05a9: return "_wprintf_s_l";
  case 0x05aa: return "_wputenv";
  case 0x05ab: return "_wputenv_s";
  case 0x05ac: return "_wremove";
  case 0x05ad: return "_wrename";
  case 0x05ae: return "_write";
  case 0x05af: return "_wrmdir";
  case 0x05b0: return "_wscanf_l";
  case 0x05b1: return "_wscanf_s_l";
  case 0x05b2: return "_wsearchenv";
  case 0x05b3: return "_wsearchenv_s";
  case 0x05b4: return "_wsetlocale";
  case 0x05b5: return "_wsopen";
  case 0x05b6: return "_wsopen_s";
  case 0x05b7: return "_wspawnl";
  case 0x05b8: return "_wspawnle";
  case 0x05b9: return "_wspawnlp";
  case 0x05ba: return "_wspawnlpe";
  case 0x05bb: return "_wspawnv";
  case 0x05bc: return "_wspawnve";
  case 0x05bd: return "_wspawnvp";
  case 0x05be: return "_wspawnvpe";
  case 0x05bf: return "_wsplitpath";
  case 0x05c0: return "_wsplitpath_s";
  case 0x05c1: return "_wstat32";
  case 0x05c2: return "_wstat32i64";
  case 0x05c3: return "_wstat64";
  case 0x05c4: return "_wstat64i32";
  case 0x05c5: return "_wstrdate";
  case 0x05c6: return "_wstrdate_s";
  case 0x05c7: return "_wstrtime";
  case 0x05c8: return "_wstrtime_s";
  case 0x05c9: return "_wsystem";
  case 0x05ca: return "_wtempnam";
  case 0x05cb: return "_wtmpnam";
  case 0x05cc: return "_wtmpnam_s";
  case 0x05cd: return "_wtof";
  case 0x05ce: return "_wtof_l";
  case 0x05cf: return "_wtoi";
  case 0x05d0: return "_wtoi64";
  case 0x05d1: return "_wtoi64_l";
  case 0x05d2: return "_wtoi_l";
  case 0x05d3: return "_wtol";
  case 0x05d4: return "_wtol_l";
  case 0x05d5: return "_wtoll";
  case 0x05d6: return "_wtoll_l";
  case 0x05d7: return "_wunlink";
  case 0x05d8: return "_wutime32";
  case 0x05d9: return "_wutime64";
  case 0x05da: return "_y0";
  case 0x05db: return "_y1";
  case 0x05dc: return "_yn";
  case 0x05dd: return "abort";
  case 0x05de: return "abs";
  case 0x05df: return "acos";
  case 0x05e0: return "acosh";
  case 0x05e1: return "acoshf";
  case 0x05e2: return "acoshl";
  case 0x05e3: return "asctime";
  case 0x05e4: return "asctime_s";
  case 0x05e5: return "asin";
  case 0x05e6: return "asinh";
  case 0x05e7: return "asinhf";
  case 0x05e8: return "asinhl";
  case 0x05e9: return "atan";
  case 0x05ea: return "atan2";
  case 0x05eb: return "atanh";
  case 0x05ec: return "atanhf";
  case 0x05ed: return "atanhl";
  case 0x05ee: return "atexit";
  case 0x05ef: return "atof";
  case 0x05f0: return "atoi";
  case 0x05f1: return "atol";
  case 0x05f2: return "atoll";
  case 0x05f3: return "bsearch";
  case 0x05f4: return "bsearch_s";
  case 0x05f5: return "btowc";
  case 0x05f6: return "cabs";
  case 0x05f7: return "cabsf";
  case 0x05f8: return "cabsl";
  case 0x05f9: return "cacos";
  case 0x05fa: return "cacosf";
  case 0x05fb: return "cacosh";
  case 0x05fc: return "cacoshf";
  case 0x05fd: return "cacoshl";
  case 0x05fe: return "cacosl";
  case 0x05ff: return "calloc";
  case 0x0600: return "carg";
  case 0x0601: return "cargf";
  case 0x0602: return "cargl";
  case 0x0603: return "casin";
  case 0x0604: return "casinf";
  case 0x0605: return "casinh";
  case 0x0606: return "casinhf";
  case 0x0607: return "casinhl";
  case 0x0608: return "casinl";
  case 0x0609: return "catan";
  case 0x060a: return "catanf";
  case 0x060b: return "catanh";
  case 0x060c: return "catanhf";
  case 0x060d: return "catanhl";
  case 0x060e: return "catanl";
  case 0x060f: return "cbrt";
  case 0x0610: return "cbrtf";
  case 0x0611: return "cbrtl";
  case 0x0612: return "ccos";
  case 0x0613: return "ccosf";
  case 0x0614: return "ccosh";
  case 0x0615: return "ccoshf";
  case 0x0616: return "ccoshl";
  case 0x0617: return "ccosl";
  case 0x0618: return "ceil";
  case 0x0619: return "cexp";
  case 0x061a: return "cexpf";
  case 0x061b: return "cexpl";
  case 0x061c: return "cimag";
  case 0x061d: return "cimagf";
  case 0x061e: return "cimagl";
  case 0x061f: return "clearerr";
  case 0x0620: return "clearerr_s";
  case 0x0621: return "clock";
  case 0x0622: return "clog";
  case 0x0623: return "clog10";
  case 0x0624: return "clog10f";
  case 0x0625: return "clog10l";
  case 0x0626: return "clogf";
  case 0x0627: return "clogl";
  case 0x0628: return "conj";
  case 0x0629: return "conjf";
  case 0x062a: return "conjl";
  case 0x062b: return "copysign";
  case 0x062c: return "copysignf";
  case 0x062d: return "copysignl";
  case 0x062e: return "cos";
  case 0x062f: return "cosh";
  case 0x0630: return "cpow";
  case 0x0631: return "cpowf";
  case 0x0632: return "cpowl";
  case 0x0633: return "cproj";
  case 0x0634: return "cprojf";
  case 0x0635: return "cprojl";
  case 0x0636: return "creal";
  case 0x0637: return "crealf";
  case 0x0638: return "creall";
  case 0x0639: return "csin";
  case 0x063a: return "csinf";
  case 0x063b: return "csinh";
  case 0x063c: return "csinhf";
  case 0x063d: return "csinhl";
  case 0x063e: return "csinl";
  case 0x063f: return "csqrt";
  case 0x0640: return "csqrtf";
  case 0x0641: return "csqrtl";
  case 0x0642: return "ctan";
  case 0x0643: return "ctanf";
  case 0x0644: return "ctanh";
  case 0x0645: return "ctanhf";
  case 0x0646: return "ctanhl";
  case 0x0647: return "ctanl";
  case 0x0648: return "div";
  case 0x0649: return "erf";
  case 0x064a: return "erfc";
  case 0x064b: return "erfcf";
  case 0x064c: return "erfcl";
  case 0x064d: return "erff";
  case 0x064e: return "erfl";
  case 0x064f: return "exit";
  case 0x0650: return "exp";
  case 0x0651: return "exp2";
  case 0x0652: return "exp2f";
  case 0x0653: return "exp2l";
  case 0x0654: return "expm1";
  case 0x0655: return "expm1f";
  case 0x0656: return "expm1l";
  case 0x0657: return "fabs";
  case 0x0658: return "fclose";
  case 0x0659: return "fdim";
  case 0x065a: return "fdimf";
  case 0x065b: return "fdiml";
  case 0x065c: return "feclearexcept";
  case 0x065d: return "fegetenv";
  case 0x065e: return "fegetexceptflag";
  case 0x065f: return "fegetround";
  case 0x0660: return "feholdexcept";
  case 0x0661: return "feof";
  case 0x0662: return "feraiseexcept";
  case 0x0663: return "ferror";
  case 0x0664: return "fesetenv";
  case 0x0665: return "fesetexceptflag";
  case 0x0666: return "fesetround";
  case 0x0667: return "fetestexcept";
  case 0x0668: return "feupdateenv";
  case 0x0669: return "fflush";
  case 0x066a: return "fgetc";
  case 0x066b: return "fgetpos";
  case 0x066c: return "fgets";
  case 0x066d: return "fgetwc";
  case 0x066e: return "fgetws";
  case 0x066f: return "floor";
  case 0x0670: return "fma";
  case 0x0671: return "fmaf";
  case 0x0672: return "fmal";
  case 0x0673: return "fmax";
  case 0x0674: return "fmaxf";
  case 0x0675: return "fmaxl";
  case 0x0676: return "fmin";
  case 0x0677: return "fminf";
  case 0x0678: return "fminl";
  case 0x0679: return "fmod";
  case 0x067a: return "fopen";
  case 0x067b: return "fopen_s";
  case 0x067c: return "fprintf";
  case 0x067d: return "fprintf_s";
  case 0x067e: return "fputc";
  case 0x067f: return "fputs";
  case 0x0680: return "fputwc";
  case 0x0681: return "fputws";
  case 0x0682: return "fread";
  case 0x0683: return "fread_s";
  case 0x0684: return "free";
  case 0x0685: return "freopen";
  case 0x0686: return "freopen_s";
  case 0x0687: return "frexp";
  case 0x0688: return "fscanf";
  case 0x0689: return "fscanf_s";
  case 0x068a: return "fseek";
  case 0x068b: return "fsetpos";
  case 0x068c: return "ftell";
  case 0x068d: return "fwprintf";
  case 0x068e: return "fwprintf_s";
  case 0x068f: return "fwrite";
  case 0x0690: return "fwscanf";
  case 0x0691: return "fwscanf_s";
  case 0x0692: return "getc";
  case 0x0693: return "getchar";
  case 0x0694: return "getenv";
  case 0x0695: return "getenv_s";
  case 0x0696: return "gets";
  case 0x0697: return "gets_s";
  case 0x0698: return "getwc";
  case 0x0699: return "getwchar";
  case 0x069a: return "ilogb";
  case 0x069b: return "ilogbf";
  case 0x069c: return "ilogbl";
  case 0x069d: return "imaxabs";
  case 0x069e: return "imaxdiv";
  case 0x069f: return "is_wctype";
  case 0x06a0: return "isalnum";
  case 0x06a1: return "isalpha";
  case 0x06a2: return "isblank";
  case 0x06a3: return "iscntrl";
  case 0x06a4: return "isdigit";
  case 0x06a5: return "isgraph";
  case 0x06a6: return "isleadbyte";
  case 0x06a7: return "islower";
  case 0x06a8: return "isprint";
  case 0x06a9: return "ispunct";
  case 0x06aa: return "isspace";
  case 0x06ab: return "isupper";
  case 0x06ac: return "iswalnum";
  case 0x06ad: return "iswalpha";
  case 0x06ae: return "iswascii";
  case 0x06af: return "iswblank";
  case 0x06b0: return "iswcntrl";
  case 0x06b1: return "iswctype";
  case 0x06b2: return "iswdigit";
  case 0x06b3: return "iswgraph";
  case 0x06b4: return "iswlower";
  case 0x06b5: return "iswprint";
  case 0x06b6: return "iswpunct";
  case 0x06b7: return "iswspace";
  case 0x06b8: return "iswupper";
  case 0x06b9: return "iswxdigit";
  case 0x06ba: return "isxdigit";
  case 0x06bb: return "labs";
  case 0x06bc: return "ldexp";
  case 0x06bd: return "ldiv";
  case 0x06be: return "lgamma";
  case 0x06bf: return "lgammaf";
  case 0x06c0: return "lgammal";
  case 0x06c1: return "llabs";
  case 0x06c2: return "lldiv";
  case 0x06c3: return "llrint";
  case 0x06c4: return "llrintf";
  case 0x06c5: return "llrintl";
  case 0x06c6: return "llround";
  case 0x06c7: return "llroundf";
  case 0x06c8: return "llroundl";
  case 0x06c9: return "localeconv";
  case 0x06ca: return "log";
  case 0x06cb: return "log10";
  case 0x06cc: return "log1p";
  case 0x06cd: return "log1pf";
  case 0x06ce: return "log1pl";
  case 0x06cf: return "log2";
  case 0x06d0: return "log2f";
  case 0x06d1: return "log2l";
  case 0x06d2: return "logb";
  case 0x06d3: return "logbf";
  case 0x06d4: return "logbl";
  case 0x06d5: return "longjmp";
  case 0x06d6: return "lrint";
  case 0x06d7: return "lrintf";
  case 0x06d8: return "lrintl";
  case 0x06d9: return "lround";
  case 0x06da: return "lroundf";
  case 0x06db: return "lroundl";
  case 0x06dc: return "malloc";
  case 0x06dd: return "mblen";
  case 0x06de: return "mbrlen";
  case 0x06df: return "mbrtowc";
  case 0x06e0: return "mbsrtowcs";
  case 0x06e1: return "mbsrtowcs_s";
  case 0x06e2: return "mbstowcs";
  case 0x06e3: return "mbstowcs_s";
  case 0x06e4: return "mbtowc";
  case 0x06e5: return "memchr";
  case 0x06e6: return "memcmp";
  case 0x06e7: return "memcpy";
  case 0x06e8: return "memcpy_s";
  case 0x06e9: return "memmove";
  case 0x06ea: return "memmove_s";
  case 0x06eb: return "memset";
  case 0x06ec: return "modf";
  case 0x06ed: return "nan";
  case 0x06ee: return "nanf";
  case 0x06ef: return "nanl";
  case 0x06f0: return "nearbyint";
  case 0x06f1: return "nearbyintf";
  case 0x06f2: return "nearbyintl";
  case 0x06f3: return "nextafter";
  case 0x06f4: return "nextafterf";
  case 0x06f5: return "nextafterl";
  case 0x06f6: return "nexttoward";
  case 0x06f7: return "nexttowardf";
  case 0x06f8: return "nexttowardl";
  case 0x06f9: return "norm";
  case 0x06fa: return "normf";
  case 0x06fb: return "norml";
  case 0x06fc: return "perror";
  case 0x06fd: return "pow";
  case 0x06fe: return "printf";
  case 0x06ff: return "printf_s";
  case 0x0700: return "putc";
  case 0x0701: return "putchar";
  case 0x0702: return "puts";
  case 0x0703: return "putwc";
  case 0x0704: return "putwchar";
  case 0x0705: return "qsort";
  case 0x0706: return "qsort_s";
  case 0x0707: return "raise";
  case 0x0708: return "rand";
  case 0x0709: return "rand_s";
  case 0x070a: return "realloc";
  case 0x070b: return "remainder";
  case 0x070c: return "remainderf";
  case 0x070d: return "remainderl";
  case 0x070e: return "remove";
  case 0x070f: return "remquo";
  case 0x0710: return "remquof";
  case 0x0711: return "remquol";
  case 0x0712: return "rename";
  case 0x0713: return "rewind";
  case 0x0714: return "rint";
  case 0x0715: return "rintf";
  case 0x0716: return "rintl";
  case 0x0717: return "round";
  case 0x0718: return "roundf";
  case 0x0719: return "roundl";
  case 0x071a: return "scalbln";
  case 0x071b: return "scalblnf";
  case 0x071c: return "scalblnl";
  case 0x071d: return "scalbn";
  case 0x071e: return "scalbnf";
  case 0x071f: return "scalbnl";
  case 0x0720: return "scanf";
  case 0x0721: return "scanf_s";
  case 0x0722: return "setbuf";
  case 0x0723: return "setlocale";
  case 0x0724: return "setvbuf";
  case 0x0725: return "signal";
  case 0x0726: return "sin";
  case 0x0727: return "sinh";
  case 0x0728: return "sprintf";
  case 0x0729: return "sprintf_s";
  case 0x072a: return "sqrt";
  case 0x072b: return "srand";
  case 0x072c: return "sscanf";
  case 0x072d: return "sscanf_s";
  case 0x072e: return "strcat";
  case 0x072f: return "strcat_s";
  case 0x0730: return "strchr";
  case 0x0731: return "strcmp";
  case 0x0732: return "strcoll";
  case 0x0733: return "strcpy";
  case 0x0734: return "strcpy_s";
  case 0x0735: return "strcspn";
  case 0x0736: return "strerror";
  case 0x0737: return "strerror_s";
  case 0x0738: return "strftime";
  case 0x0739: return "strlen";
  case 0x073a: return "strncat";
  case 0x073b: return "strncat_s";
  case 0x073c: return "strncmp";
  case 0x073d: return "strncpy";
  case 0x073e: return "strncpy_s";
  case 0x073f: return "strnlen";
  case 0x0740: return "strpbrk";
  case 0x0741: return "strrchr";
  case 0x0742: return "strspn";
  case 0x0743: return "strstr";
  case 0x0744: return "strtod";
  case 0x0745: return "strtof";
  case 0x0746: return "strtoimax";
  case 0x0747: return "strtok";
  case 0x0748: return "strtok_s";
  case 0x0749: return "strtol";
  case 0x074a: return "strtold";
  case 0x074b: return "strtoll";
  case 0x074c: return "strtoul";
  case 0x074d: return "strtoull";
  case 0x074e: return "strtoumax";
  case 0x074f: return "strxfrm";
  case 0x0750: return "swprintf_s";
  case 0x0751: return "swscanf";
  case 0x0752: return "swscanf_s";
  case 0x0753: return "system";
  case 0x0754: return "tan";
  case 0x0755: return "tanh";
  case 0x0756: return "tgamma";
  case 0x0757: return "tgammaf";
  case 0x0758: return "tgammal";
  case 0x0759: return "tmpfile";
  case 0x075a: return "tmpfile_s";
  case 0x075b: return "tmpnam";
  case 0x075c: return "tmpnam_s";
  case 0x075d: return "tolower";
  case 0x075e: return "toupper";
  case 0x075f: return "towctrans";
  case 0x0760: return "towlower";
  case 0x0761: return "towupper";
  case 0x0762: return "trunc";
  case 0x0763: return "truncf";
  case 0x0764: return "truncl";
  case 0x0765: return "ungetc";
  case 0x0766: return "ungetwc";
  case 0x0767: return "vfprintf";
  case 0x0768: return "vfprintf_s";
  case 0x0769: return "vfscanf";
  case 0x076a: return "vfscanf_s";
  case 0x076b: return "vfwprintf";
  case 0x076c: return "vfwprintf_s";
  case 0x076d: return "vfwscanf";
  case 0x076e: return "vfwscanf_s";
  case 0x076f: return "vprintf";
  case 0x0770: return "vprintf_s";
  case 0x0771: return "vscanf";
  case 0x0772: return "vscanf_s";
  case 0x0773: return "vsprintf";
  case 0x0774: return "vsprintf_s";
  case 0x0775: return "vsscanf";
  case 0x0776: return "vsscanf_s";
  case 0x0777: return "vswprintf_s";
  case 0x0778: return "vswscanf";
  case 0x0779: return "vswscanf_s";
  case 0x077a: return "vwprintf";
  case 0x077b: return "vwprintf_s";
  case 0x077c: return "vwscanf";
  case 0x077d: return "vwscanf_s";
  case 0x077e: return "wcrtomb";
  case 0x077f: return "wcrtomb_s";
  case 0x0780: return "wcscat";
  case 0x0781: return "wcscat_s";
  case 0x0782: return "wcschr";
  case 0x0783: return "wcscmp";
  case 0x0784: return "wcscoll";
  case 0x0785: return "wcscpy";
  case 0x0786: return "wcscpy_s";
  case 0x0787: return "wcscspn";
  case 0x0788: return "wcsftime";
  case 0x0789: return "wcslen";
  case 0x078a: return "wcsncat";
  case 0x078b: return "wcsncat_s";
  case 0x078c: return "wcsncmp";
  case 0x078d: return "wcsncpy";
  case 0x078e: return "wcsncpy_s";
  case 0x078f: return "wcsnlen";
  case 0x0790: return "wcspbrk";
  case 0x0791: return "wcsrchr";
  case 0x0792: return "wcsrtombs";
  case 0x0793: return "wcsrtombs_s";
  case 0x0794: return "wcsspn";
  case 0x0795: return "wcsstr";
  case 0x0796: return "wcstod";
  case 0x0797: return "wcstof";
  case 0x0798: return "wcstoimax";
  case 0x0799: return "wcstok";
  case 0x079a: return "wcstok_s";
  case 0x079b: return "wcstol";
  case 0x079c: return "wcstold";
  case 0x079d: return "wcstoll";
  case 0x079e: return "wcstombs";
  case 0x079f: return "wcstombs_s";
  case 0x07a0: return "wcstoul";
  case 0x07a1: return "wcstoull";
  case 0x07a2: return "wcstoumax";
  case 0x07a3: return "wcsxfrm";
  case 0x07a4: return "wctob";
  case 0x07a5: return "wctomb";
  case 0x07a6: return "wctomb_s";
  case 0x07a7: return "wctrans";
  case 0x07a8: return "wctype";
  case 0x07a9: return "wmemcpy_s";
  case 0x07aa: return "wmemmove_s";
  case 0x07ab: return "wprintf";
  case 0x07ac: return "wprintf_s";
  case 0x07ad: return "wscanf";
  case 0x07ae: return "wscanf_s";
  }
  return nullptr;
}


}
}

#endif

