/* Copyright 2017 - 2022 R. Thomas
 * Copyright 2017 - 2022 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "pyMachO.hpp"
#include "LIEF/MachO/enums.hpp"
#include "LIEF/MachO/EnumToString.hpp"
#include "enums_wrapper.hpp"

#define PY_ENUM(x) LIEF::MachO::to_string(x), x

namespace LIEF {
namespace MachO {

void init_enums(py::module& m) {

  LIEF::enum_<LIEF::MachO::CPU_TYPES>(m, "CPU_TYPES")
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_ANY))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_X86))
    .value("I386", LIEF::MachO::CPU_TYPES::CPU_TYPE_I386)
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_X86_64))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_MC98000))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_ARM))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_ARM64))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_SPARC))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_POWERPC))
    .value(PY_ENUM(LIEF::MachO::CPU_TYPES::CPU_TYPE_POWERPC64));

  LIEF::enum_<LIEF::MachO::MACHO_TYPES>(m, "MACHO_TYPES")
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::MH_MAGIC))
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::MH_CIGAM))
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::MH_MAGIC_64))
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::MH_CIGAM_64))
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::FAT_MAGIC))
    .value(PY_ENUM(LIEF::MachO::MACHO_TYPES::FAT_CIGAM));


  LIEF::enum_<LIEF::MachO::FILE_TYPES>(m, "FILE_TYPES")
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_OBJECT))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_EXECUTE))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_FVMLIB))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_CORE))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_PRELOAD))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_DYLIB))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_DYLINKER))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_BUNDLE))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_DYLIB_STUB))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_DSYM))
    .value(PY_ENUM(LIEF::MachO::FILE_TYPES::MH_KEXT_BUNDLE));

  LIEF::enum_<LIEF::MachO::HEADER_FLAGS>(m, "HEADER_FLAGS")
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_NOUNDEFS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_INCRLINK))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_DYLDLINK))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_BINDATLOAD))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_PREBOUND))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_SPLIT_SEGS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_LAZY_INIT))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_TWOLEVEL))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_FORCE_FLAT))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_NOMULTIDEFS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_NOFIXPREBINDING))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_PREBINDABLE))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_ALLMODSBOUND))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_SUBSECTIONS_VIA_SYMBOLS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_CANONICAL))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_WEAK_DEFINES))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_BINDS_TO_WEAK))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_ALLOW_STACK_EXECUTION))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_ROOT_SAFE))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_SETUID_SAFE))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_NO_REEXPORTED_DYLIBS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_PIE))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_DEAD_STRIPPABLE_DYLIB))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_HAS_TLV_DESCRIPTORS))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_NO_HEAP_EXECUTION))
    .value(PY_ENUM(LIEF::MachO::HEADER_FLAGS::MH_APP_EXTENSION_SAFE));



  LIEF::enum_<LIEF::MachO::LOAD_COMMAND_TYPES>(m, "LOAD_COMMAND_TYPES")
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SEGMENT))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SYMTAB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SYMSEG))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_THREAD))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_UNIXTHREAD))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LOADFVMLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_IDFVMLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_IDENT))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_FVMFILE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_PREPAGE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYSYMTAB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LOAD_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ID_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LOAD_DYLINKER))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ID_DYLINKER))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_PREBOUND_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ROUTINES))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SUB_FRAMEWORK))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SUB_UMBRELLA))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SUB_CLIENT))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SUB_LIBRARY))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_TWOLEVEL_HINTS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_PREBIND_CKSUM))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LOAD_WEAK_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SEGMENT_64))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ROUTINES_64))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_UUID))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_RPATH))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_CODE_SIGNATURE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SEGMENT_SPLIT_INFO))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_REEXPORT_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LAZY_LOAD_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ENCRYPTION_INFO))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLD_INFO))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLD_INFO_ONLY))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LOAD_UPWARD_DYLIB))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_VERSION_MIN_MACOSX))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_VERSION_MIN_IPHONEOS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_FUNCTION_STARTS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLD_ENVIRONMENT))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_MAIN))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DATA_IN_CODE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_SOURCE_VERSION))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLIB_CODE_SIGN_DRS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_ENCRYPTION_INFO_64))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LINKER_OPTION))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_LINKER_OPTIMIZATION_HINT))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_VERSION_MIN_TVOS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_VERSION_MIN_WATCHOS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_NOTE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_BUILD_VERSION))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLD_EXPORTS_TRIE))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_DYLD_CHAINED_FIXUPS))
    .value(PY_ENUM(LIEF::MachO::LOAD_COMMAND_TYPES::LC_FILESET_ENTRY));


  LIEF::enum_<LIEF::MachO::MACHO_SECTION_TYPES>(m, "SECTION_TYPES")
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_REGULAR))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_ZEROFILL))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_CSTRING_LITERALS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_4BYTE_LITERALS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_8BYTE_LITERALS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_LITERAL_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_NON_LAZY_SYMBOL_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_LAZY_SYMBOL_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_SYMBOL_STUBS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_MOD_INIT_FUNC_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_MOD_TERM_FUNC_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_COALESCED))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_GB_ZEROFILL))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_INTERPOSING))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_16BYTE_LITERALS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_DTRACE_DOF))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_LAZY_DYLIB_SYMBOL_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_THREAD_LOCAL_REGULAR))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_THREAD_LOCAL_ZEROFILL))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_THREAD_LOCAL_VARIABLES))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_THREAD_LOCAL_VARIABLE_POINTERS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_TYPES::S_THREAD_LOCAL_INIT_FUNCTION_POINTERS));


  LIEF::enum_<LIEF::MachO::X86_RELOCATION>(m, "X86_RELOCATION")
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_VANILLA))
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_PAIR))
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_PB_LA_PTR))
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_LOCAL_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::X86_RELOCATION::GENERIC_RELOC_TLV));

  LIEF::enum_<LIEF::MachO::X86_64_RELOCATION>(m, "X86_64_RELOCATION")
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_UNSIGNED))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_SIGNED))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_BRANCH))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_GOT_LOAD))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_GOT))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_SUBTRACTOR))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_SIGNED_1))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_SIGNED_2))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_SIGNED_4))
    .value(PY_ENUM(LIEF::MachO::X86_64_RELOCATION::X86_64_RELOC_TLV));

  LIEF::enum_<LIEF::MachO::PPC_RELOCATION>(m, "PPC_RELOCATION")
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_VANILLA))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_PAIR))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_BR14))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_BR24))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_HI16))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_LO16))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_HA16))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_LO14))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_PB_LA_PTR))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_HI16_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_LO16_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_HA16_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_JBSR))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_LO14_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::PPC_RELOCATION::PPC_RELOC_LOCAL_SECTDIFF));

  LIEF::enum_<LIEF::MachO::ARM_RELOCATION>(m, "ARM_RELOCATION")
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_VANILLA))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_PAIR))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_LOCAL_SECTDIFF))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_PB_LA_PTR))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_BR24))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_THUMB_RELOC_BR22))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_THUMB_32BIT_BRANCH))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_HALF))
    .value(PY_ENUM(LIEF::MachO::ARM_RELOCATION::ARM_RELOC_HALF_SECTDIFF));

  LIEF::enum_<LIEF::MachO::ARM64_RELOCATION>(m, "ARM64_RELOCATION")
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_UNSIGNED))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_SUBTRACTOR))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_BRANCH26))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_PAGE21))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_PAGEOFF12))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_GOT_LOAD_PAGE21))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_GOT_LOAD_PAGEOFF12))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_POINTER_TO_GOT))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_TLVP_LOAD_PAGE21))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_TLVP_LOAD_PAGEOFF12))
    .value(PY_ENUM(LIEF::MachO::ARM64_RELOCATION::ARM64_RELOC_ADDEND));


  LIEF::enum_<LIEF::MachO::RELOCATION_ORIGINS>(m, "RELOCATION_ORIGINS")
    .value(PY_ENUM(LIEF::MachO::RELOCATION_ORIGINS::ORIGIN_UNKNOWN))
    .value(PY_ENUM(LIEF::MachO::RELOCATION_ORIGINS::ORIGIN_DYLDINFO))
    .value(PY_ENUM(LIEF::MachO::RELOCATION_ORIGINS::ORIGIN_RELOC_TABLE));


  LIEF::enum_<LIEF::MachO::REBASE_TYPES>(m, "REBASE_TYPES")
    .value(PY_ENUM(LIEF::MachO::REBASE_TYPES::REBASE_TYPE_POINTER))
    .value(PY_ENUM(LIEF::MachO::REBASE_TYPES::REBASE_TYPE_TEXT_ABSOLUTE32))
    .value(PY_ENUM(LIEF::MachO::REBASE_TYPES::REBASE_TYPE_TEXT_PCREL32));


  LIEF::enum_<LIEF::MachO::BINDING_CLASS>(m, "BINDING_CLASS")
    .value(PY_ENUM(LIEF::MachO::BINDING_CLASS::BIND_CLASS_WEAK))
    .value(PY_ENUM(LIEF::MachO::BINDING_CLASS::BIND_CLASS_LAZY))
    .value(PY_ENUM(LIEF::MachO::BINDING_CLASS::BIND_CLASS_STANDARD))
    .value(PY_ENUM(LIEF::MachO::BINDING_CLASS::BIND_CLASS_THREADED));


  LIEF::enum_<LIEF::MachO::REBASE_OPCODES>(m, "REBASE_OPCODES")
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_DONE))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_SET_TYPE_IMM))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_ADD_ADDR_ULEB))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_ADD_ADDR_IMM_SCALED))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_DO_REBASE_IMM_TIMES))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_DO_REBASE_ULEB_TIMES))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_DO_REBASE_ADD_ADDR_ULEB))
    .value(PY_ENUM(LIEF::MachO::REBASE_OPCODES::REBASE_OPCODE_DO_REBASE_ULEB_TIMES_SKIPPING_ULEB));


  LIEF::enum_<LIEF::MachO::BIND_TYPES>(m, "BIND_TYPES")
    .value(PY_ENUM(LIEF::MachO::BIND_TYPES::BIND_TYPE_POINTER))
    .value(PY_ENUM(LIEF::MachO::BIND_TYPES::BIND_TYPE_TEXT_ABSOLUTE32))
    .value(PY_ENUM(LIEF::MachO::BIND_TYPES::BIND_TYPE_TEXT_PCREL32));


  LIEF::enum_<LIEF::MachO::BIND_SPECIAL_DYLIB>(m, "BIND_SPECIAL_DYLIB")
    .value(PY_ENUM(LIEF::MachO::BIND_SPECIAL_DYLIB::BIND_SPECIAL_DYLIB_SELF))
    .value(PY_ENUM(LIEF::MachO::BIND_SPECIAL_DYLIB::BIND_SPECIAL_DYLIB_MAIN_EXECUTABLE))
    .value(PY_ENUM(LIEF::MachO::BIND_SPECIAL_DYLIB::BIND_SPECIAL_DYLIB_FLAT_LOOKUP));


  LIEF::enum_<LIEF::MachO::BIND_OPCODES>(m, "BIND_OPCODES")
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_DONE))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_DYLIB_ORDINAL_IMM))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_DYLIB_ORDINAL_ULEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_DYLIB_SPECIAL_IMM))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_SYMBOL_TRAILING_FLAGS_IMM))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_TYPE_IMM))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_ADDEND_SLEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_ADD_ADDR_ULEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_DO_BIND))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_DO_BIND_ADD_ADDR_ULEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_DO_BIND_ADD_ADDR_IMM_SCALED))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_DO_BIND_ULEB_TIMES_SKIPPING_ULEB))
    .value(PY_ENUM(LIEF::MachO::BIND_OPCODES::BIND_OPCODE_THREADED));


  LIEF::enum_<LIEF::MachO::EXPORT_SYMBOL_KINDS>(m, "EXPORT_SYMBOL_KINDS")
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_KINDS::EXPORT_SYMBOL_FLAGS_KIND_REGULAR))
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_KINDS::EXPORT_SYMBOL_FLAGS_KIND_THREAD_LOCAL))
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_KINDS::EXPORT_SYMBOL_FLAGS_KIND_ABSOLUTE));

  py::enum_<LIEF::MachO::EXPORT_SYMBOL_FLAGS>(m, "EXPORT_SYMBOL_FLAGS")
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_FLAGS::EXPORT_SYMBOL_FLAGS_WEAK_DEFINITION))
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_FLAGS::EXPORT_SYMBOL_FLAGS_REEXPORT))
    .value(PY_ENUM(LIEF::MachO::EXPORT_SYMBOL_FLAGS::EXPORT_SYMBOL_FLAGS_STUB_AND_RESOLVER));


  LIEF::enum_<LIEF::MachO::VM_PROTECTIONS>(m, "VM_PROTECTIONS")
    .value(PY_ENUM(LIEF::MachO::VM_PROTECTIONS::VM_PROT_READ))
    .value(PY_ENUM(LIEF::MachO::VM_PROTECTIONS::VM_PROT_WRITE))
    .value(PY_ENUM(LIEF::MachO::VM_PROTECTIONS::VM_PROT_EXECUTE));


  LIEF::enum_<LIEF::MachO::SYMBOL_ORIGINS>(m, "SYMBOL_ORIGINS")
    .value(PY_ENUM(LIEF::MachO::SYMBOL_ORIGINS::SYM_ORIGIN_UNKNOWN))
    .value(PY_ENUM(LIEF::MachO::SYMBOL_ORIGINS::SYM_ORIGIN_DYLD_EXPORT))
    .value(PY_ENUM(LIEF::MachO::SYMBOL_ORIGINS::SYM_ORIGIN_LC_SYMTAB));

  LIEF::enum_<LIEF::MachO::MACHO_SECTION_FLAGS>(m, "SECTION_FLAGS")
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_PURE_INSTRUCTIONS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_NO_TOC))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_STRIP_STATIC_SYMS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_NO_DEAD_STRIP))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_LIVE_SUPPORT))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_SELF_MODIFYING_CODE))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_DEBUG))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_SOME_INSTRUCTIONS))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_EXT_RELOC))
    .value(PY_ENUM(LIEF::MachO::MACHO_SECTION_FLAGS::S_ATTR_LOC_RELOC));
}

}
}
