/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.jaxp.IdentityTransformerHandler;
import net.sf.saxon.jaxp.TemplatesHandlerImpl;
import net.sf.saxon.jaxp.TemplatesImpl;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLFilter;

public class SaxonTransformerFactory
extends SAXTransformerFactory {
    private Processor processor;
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public SaxonTransformerFactory() {
        this.processor = new Processor(true);
    }

    public SaxonTransformerFactory(Configuration config) {
        this.processor = new Processor(config);
    }

    public void setConfiguration(Configuration config) {
        this.processor.setConfigurationProperty("http://saxon.sf.net/feature/configuration", config);
    }

    public Configuration getConfiguration() {
        return this.processor.getUnderlyingConfiguration();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.processor.getUnderlyingConfiguration());
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        try {
            XsltCompiler compiler = this.processor.newXsltCompiler();
            XsltExecutable executable = compiler.compile(source);
            return new TemplatesImpl(executable);
        }
        catch (SaxonApiException e) {
            throw new TransformerConfigurationException(e);
        }
    }

    public Templates newTemplates(Source source, CompilerInfo info) throws TransformerConfigurationException {
        try {
            XsltCompiler compiler = this.processor.newXsltCompiler();
            compiler.getUnderlyingCompilerInfo().copyFrom(info);
            return new TemplatesImpl(compiler.compile(source));
        }
        catch (SaxonApiException e) {
            throw new TransformerConfigurationException(e);
        }
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        try {
            XsltCompiler compiler = this.processor.newXsltCompiler();
            return compiler.getAssociatedStylesheet(source, media, title, charset);
        }
        catch (SaxonApiException e) {
            throw new TransformerConfigurationException(e);
        }
    }

    public void setURIResolver(URIResolver resolver) {
        this.getConfiguration().setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.getConfiguration().getURIResolver();
    }

    public boolean getFeature(String name) {
        if (name.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions");
        }
        try {
            Object val = this.getConfiguration().getConfigurationProperty(name);
            return val instanceof Boolean && (Boolean)val != false;
        }
        catch (IllegalArgumentException err) {
            return false;
        }
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration-file")) {
            ConfigurationReader reader = new ConfigurationReader();
            try {
                this.setConfiguration(reader.makeConfiguration(new StreamSource(new File((String)value))));
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(err);
            }
        } else {
            this.processor.setConfigurationProperty(name, value);
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        return this.getConfiguration().getConfigurationProperty(name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.getConfiguration().setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.getConfiguration().getErrorListener();
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newTransformerHandler(tmpl);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        TransformerImpl transformer = (TransformerImpl)templates.newTransformer();
        return transformer.newTransformerHandler();
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer transformer = new IdentityTransformer(this.getConfiguration());
        return new IdentityTransformerHandler(transformer);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.processor);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newXMLFilter(tmpl);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        TransformerImpl transformer = (TransformerImpl)templates.newTransformer();
        return transformer.newXMLFilter();
    }

    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            this.getConfiguration().setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", !value);
        } else {
            try {
                this.getConfiguration().setBooleanProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + name);
            }
        }
    }
}

