/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.Configuration;

public final class Version {
    private static final int[] STRUCTURED_VERSION = new int[]{9, 6, 0, 5};
    private static final String VERSION = "9.6.0.6";
    private static final String BUILD = "0605415";
    private static final String RELEASE_DATE = "2015-06-05";
    private static final String MAJOR_RELEASE_DATE = "2014-10-02";

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVendor() {
        return "Saxonica";
    }

    public static String getProductVariantAndVersion(Configuration config) {
        String edition = config.getEditionCode();
        if ((edition.equals("PE") || edition.equals("EE")) && !config.isLicensedFeature(8)) {
            edition = edition + " (unlicensed)";
        }
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return VERSION;
    }

    public static int[] getStructuredVersionNumber() {
        return STRUCTURED_VERSION;
    }

    public static String getReleaseDate() {
        return RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getProductTitle() {
        return Version.getProductName() + ' ' + Version.getProductVersion() + " from Saxonica";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build " + BUILD + ')');
    }
}

