# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_reservation_api_enums import *


class AppliedReservationList(msrest.serialization.Model):
    """AppliedReservationList.

    :param value:
    :type value: list[str]
    :param next_link: Url to get the next page of reservations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List[str]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AppliedReservationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppliedReservations(msrest.serialization.Model):
    """AppliedReservations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier of the applied reservations.
    :vartype id: str
    :ivar name: Name of resource.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/AppliedReservations".
    :vartype type: str
    :param reservation_order_ids:
    :type reservation_order_ids: ~azure.mgmt.reservations.models.AppliedReservationList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reservation_order_ids': {'key': 'properties.reservationOrderIds', 'type': 'AppliedReservationList'},
    }

    def __init__(
        self,
        *,
        reservation_order_ids: Optional["AppliedReservationList"] = None,
        **kwargs
    ):
        super(AppliedReservations, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.reservation_order_ids = reservation_order_ids


class AvailableScopeProperties(msrest.serialization.Model):
    """AvailableScopeProperties.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.SubscriptionScopeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SubscriptionScopeProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SubscriptionScopeProperties"] = None,
        **kwargs
    ):
        super(AvailableScopeProperties, self).__init__(**kwargs)
        self.properties = properties


class AvailableScopeRequest(msrest.serialization.Model):
    """Available scope.

    :param properties: Available scope request properties.
    :type properties: ~azure.mgmt.reservations.models.AvailableScopeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AvailableScopeRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AvailableScopeRequestProperties"] = None,
        **kwargs
    ):
        super(AvailableScopeRequest, self).__init__(**kwargs)
        self.properties = properties


class AvailableScopeRequestProperties(msrest.serialization.Model):
    """Available scope request properties.

    :param scopes:
    :type scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        super(AvailableScopeRequestProperties, self).__init__(**kwargs)
        self.scopes = scopes


class BillingInformation(msrest.serialization.Model):
    """billing information.

    :param billing_currency_total_paid_amount:
    :type billing_currency_total_paid_amount: ~azure.mgmt.reservations.models.Price
    :param billing_currency_prorated_amount:
    :type billing_currency_prorated_amount: ~azure.mgmt.reservations.models.Price
    :param billing_currency_remaining_commitment_amount:
    :type billing_currency_remaining_commitment_amount: ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'billing_currency_total_paid_amount': {'key': 'billingCurrencyTotalPaidAmount', 'type': 'Price'},
        'billing_currency_prorated_amount': {'key': 'billingCurrencyProratedAmount', 'type': 'Price'},
        'billing_currency_remaining_commitment_amount': {'key': 'billingCurrencyRemainingCommitmentAmount', 'type': 'Price'},
    }

    def __init__(
        self,
        *,
        billing_currency_total_paid_amount: Optional["Price"] = None,
        billing_currency_prorated_amount: Optional["Price"] = None,
        billing_currency_remaining_commitment_amount: Optional["Price"] = None,
        **kwargs
    ):
        super(BillingInformation, self).__init__(**kwargs)
        self.billing_currency_total_paid_amount = billing_currency_total_paid_amount
        self.billing_currency_prorated_amount = billing_currency_prorated_amount
        self.billing_currency_remaining_commitment_amount = billing_currency_remaining_commitment_amount


class CalculateExchangeOperationResultResponse(msrest.serialization.Model):
    """CalculateExchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will typically be a GUID /
     system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include: "Succeeded", "Failed",
     "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.CalculateExchangeOperationResultStatus
    :param properties: CalculateExchange response properties.
    :type properties: ~azure.mgmt.reservations.models.CalculateExchangeResponseProperties
    :param error: Required if status == failed or status == canceled.
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CalculateExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "CalculateExchangeOperationResultStatus"]] = None,
        properties: Optional["CalculateExchangeResponseProperties"] = None,
        error: Optional["OperationResultError"] = None,
        **kwargs
    ):
        super(CalculateExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = error


class CalculateExchangeRequest(msrest.serialization.Model):
    """Calculate exchange request.

    :param properties: Calculate exchange request properties.
    :type properties: ~azure.mgmt.reservations.models.CalculateExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculateExchangeRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CalculateExchangeRequestProperties"] = None,
        **kwargs
    ):
        super(CalculateExchangeRequest, self).__init__(**kwargs)
        self.properties = properties


class CalculateExchangeRequestProperties(msrest.serialization.Model):
    """Calculate exchange request properties.

    :param reservations_to_purchase: List of reservations that are being purchased in this
     exchange.
    :type reservations_to_purchase: list[~azure.mgmt.reservations.models.PurchaseRequest]
    :param reservations_to_exchange: List of reservations that are being returned in this exchange.
    :type reservations_to_exchange: list[~azure.mgmt.reservations.models.ReservationToReturn]
    """

    _attribute_map = {
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[PurchaseRequest]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturn]'},
    }

    def __init__(
        self,
        *,
        reservations_to_purchase: Optional[List["PurchaseRequest"]] = None,
        reservations_to_exchange: Optional[List["ReservationToReturn"]] = None,
        **kwargs
    ):
        super(CalculateExchangeRequestProperties, self).__init__(**kwargs)
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange


class CalculateExchangeResponseProperties(msrest.serialization.Model):
    """CalculateExchange response properties.

    :param session_id: Exchange session identifier.
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being purchased.
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseCalculateExchange]
    :param reservations_to_exchange: Details of the reservations being returned.
    :type reservations_to_exchange: list[~azure.mgmt.reservations.models.ReservationToExchange]
    :param policy_result: Exchange policy errors.
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseCalculateExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        net_payable: Optional["Price"] = None,
        refunds_total: Optional["Price"] = None,
        purchases_total: Optional["Price"] = None,
        reservations_to_purchase: Optional[List["ReservationToPurchaseCalculateExchange"]] = None,
        reservations_to_exchange: Optional[List["ReservationToExchange"]] = None,
        policy_result: Optional["ExchangePolicyErrors"] = None,
        **kwargs
    ):
        super(CalculateExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = session_id
        self.net_payable = net_payable
        self.refunds_total = refunds_total
        self.purchases_total = purchases_total
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange
        self.policy_result = policy_result


class CalculatePriceResponse(msrest.serialization.Model):
    """CalculatePriceResponse.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.CalculatePriceResponseProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculatePriceResponseProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CalculatePriceResponseProperties"] = None,
        **kwargs
    ):
        super(CalculatePriceResponse, self).__init__(**kwargs)
        self.properties = properties


class CalculatePriceResponseProperties(msrest.serialization.Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be charged in customer's
     local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft Partner. Used only
     for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that can be placed after
     calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used during refund for
     calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    :param payment_schedule:
    :type payment_schedule: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
        'payment_schedule': {'key': 'paymentSchedule', 'type': '[PaymentDetail]'},
    }

    def __init__(
        self,
        *,
        billing_currency_total: Optional["CalculatePriceResponsePropertiesBillingCurrencyTotal"] = None,
        is_billing_partner_managed: Optional[bool] = None,
        reservation_order_id: Optional[str] = None,
        sku_title: Optional[str] = None,
        sku_description: Optional[str] = None,
        pricing_currency_total: Optional["CalculatePriceResponsePropertiesPricingCurrencyTotal"] = None,
        payment_schedule: Optional[List["PaymentDetail"]] = None,
        **kwargs
    ):
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = billing_currency_total
        self.is_billing_partner_managed = is_billing_partner_managed
        self.reservation_order_id = reservation_order_id
        self.sku_title = sku_title
        self.sku_description = sku_description
        self.pricing_currency_total = pricing_currency_total
        self.payment_schedule = payment_schedule


class CalculatePriceResponsePropertiesBillingCurrencyTotal(msrest.serialization.Model):
    """Currency and amount that customer will be charged in customer's local currency. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        **kwargs
    ):
        super(CalculatePriceResponsePropertiesBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class CalculatePriceResponsePropertiesPricingCurrencyTotal(msrest.serialization.Model):
    """Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        **kwargs
    ):
        super(CalculatePriceResponsePropertiesPricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class Catalog(msrest.serialization.Model):
    """Catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :param billing_plans: The billing plan options available for this SKU.
    :type billing_plans: dict[str, list[str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan]]
    :ivar terms: Available reservation terms for this resource.
    :vartype terms: list[str or ~azure.mgmt.reservations.models.ReservationTerm]
    :ivar locations:
    :vartype locations: list[str]
    :ivar sku_properties:
    :vartype sku_properties: list[~azure.mgmt.reservations.models.SkuProperty]
    :ivar restrictions:
    :vartype restrictions: list[~azure.mgmt.reservations.models.SkuRestriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'terms': {'readonly': True},
        'locations': {'readonly': True},
        'sku_properties': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'billing_plans': {'key': 'billingPlans', 'type': '{[str]}'},
        'terms': {'key': 'terms', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'sku_properties': {'key': 'skuProperties', 'type': '[SkuProperty]'},
        'restrictions': {'key': 'restrictions', 'type': '[SkuRestriction]'},
    }

    def __init__(
        self,
        *,
        billing_plans: Optional[Dict[str, List[Union[str, "ReservationBillingPlan"]]]] = None,
        **kwargs
    ):
        super(Catalog, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.billing_plans = billing_plans
        self.terms = None
        self.locations = None
        self.sku_properties = None
        self.restrictions = None


class CreateGenericQuotaRequestParameters(msrest.serialization.Model):
    """Quota change requests information.

    :param value: Quota change requests.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CurrentQuotaLimitBase"]] = None,
        **kwargs
    ):
        super(CreateGenericQuotaRequestParameters, self).__init__(**kwargs)
        self.value = value


class CurrentQuotaLimit(msrest.serialization.Model):
    """Current quota limits.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The details of the quota request status. Possible values include:
     "Accepted", "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: A user friendly message.
    :vartype message: str
    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'properties': {'key': 'quotaInformation.properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["QuotaProperties"] = None,
        **kwargs
    ):
        super(CurrentQuotaLimit, self).__init__(**kwargs)
        self.provisioning_state = None
        self.message = None
        self.properties = properties


class CurrentQuotaLimitBase(msrest.serialization.Model):
    """Quota properties.

    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["QuotaProperties"] = None,
        **kwargs
    ):
        super(CurrentQuotaLimitBase, self).__init__(**kwargs)
        self.properties = properties


class Error(msrest.serialization.Model):
    """Error.

    :param error:
    :type error: ~azure.mgmt.reservations.models.ExtendedErrorInfo
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
    }

    def __init__(
        self,
        *,
        error: Optional["ExtendedErrorInfo"] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.error = error


class ExceptionResponse(msrest.serialization.Model):
    """The API error.

    :param error: The API error details.
    :type error: ~azure.mgmt.reservations.models.ServiceError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ServiceError'},
    }

    def __init__(
        self,
        *,
        error: Optional["ServiceError"] = None,
        **kwargs
    ):
        super(ExceptionResponse, self).__init__(**kwargs)
        self.error = error


class ExchangeOperationResultResponse(msrest.serialization.Model):
    """Exchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will typically be a GUID /
     system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include: "Succeeded", "Failed",
     "Cancelled", "PendingRefunds", "PendingPurchases".
    :type status: str or ~azure.mgmt.reservations.models.ExchangeOperationResultStatus
    :param properties: Exchange response properties.
    :type properties: ~azure.mgmt.reservations.models.ExchangeResponseProperties
    :param error: Required if status == failed or status == canceled.
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "ExchangeOperationResultStatus"]] = None,
        properties: Optional["ExchangeResponseProperties"] = None,
        error: Optional["OperationResultError"] = None,
        **kwargs
    ):
        super(ExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = error


class ExchangePolicyError(msrest.serialization.Model):
    """error details.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ExchangePolicyError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ExchangePolicyErrors(msrest.serialization.Model):
    """Exchange policy errors.

    :param policy_errors: Exchange Policy errors.
    :type policy_errors: list[~azure.mgmt.reservations.models.ExchangePolicyError]
    """

    _attribute_map = {
        'policy_errors': {'key': 'policyErrors', 'type': '[ExchangePolicyError]'},
    }

    def __init__(
        self,
        *,
        policy_errors: Optional[List["ExchangePolicyError"]] = None,
        **kwargs
    ):
        super(ExchangePolicyErrors, self).__init__(**kwargs)
        self.policy_errors = policy_errors


class ExchangeRequest(msrest.serialization.Model):
    """Exchange request.

    :param properties: Exchange request properties.
    :type properties: ~azure.mgmt.reservations.models.ExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ExchangeRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ExchangeRequestProperties"] = None,
        **kwargs
    ):
        super(ExchangeRequest, self).__init__(**kwargs)
        self.properties = properties


class ExchangeRequestProperties(msrest.serialization.Model):
    """Exchange request properties.

    :param session_id: SessionId that was returned by CalculateExchange API.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(ExchangeRequestProperties, self).__init__(**kwargs)
        self.session_id = session_id


class ExchangeResponseProperties(msrest.serialization.Model):
    """Exchange response properties.

    :param session_id: Exchange session identifier.
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being purchased.
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseExchange]
    :param reservations_to_exchange: Details of the reservations being returned.
    :type reservations_to_exchange:
     list[~azure.mgmt.reservations.models.ReservationToReturnForExchange]
    :param policy_result: Exchange policy errors.
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturnForExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        net_payable: Optional["Price"] = None,
        refunds_total: Optional["Price"] = None,
        purchases_total: Optional["Price"] = None,
        reservations_to_purchase: Optional[List["ReservationToPurchaseExchange"]] = None,
        reservations_to_exchange: Optional[List["ReservationToReturnForExchange"]] = None,
        policy_result: Optional["ExchangePolicyErrors"] = None,
        **kwargs
    ):
        super(ExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = session_id
        self.net_payable = net_payable
        self.refunds_total = refunds_total
        self.purchases_total = purchases_total
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange
        self.policy_result = policy_result


class ExtendedErrorInfo(msrest.serialization.Model):
    """ExtendedErrorInfo.

    :param code:  Possible values include: "NotSpecified", "InternalServerError", "ServerTimeout",
     "AuthorizationFailed", "BadRequest", "ClientCertificateThumbprintNotSet",
     "InvalidRequestContent", "OperationFailed", "HttpMethodNotSupported", "InvalidRequestUri",
     "MissingTenantId", "InvalidTenantId", "InvalidReservationOrderId", "InvalidReservationId",
     "ReservationIdNotInReservationOrder", "ReservationOrderNotFound", "InvalidSubscriptionId",
     "InvalidAccessToken", "InvalidLocationId", "UnauthenticatedRequestsThrottled",
     "InvalidHealthCheckType", "Forbidden", "BillingScopeIdCannotBeChanged",
     "AppliedScopesNotAssociatedWithCommerceAccount", "PatchValuesSameAsExisting",
     "RoleAssignmentCreationFailed", "ReservationOrderCreationFailed", "ReservationOrderNotEnabled",
     "CapacityUpdateScopesFailed", "UnsupportedReservationTerm", "ReservationOrderIdAlreadyExists",
     "RiskCheckFailed", "CreateQuoteFailed", "ActivateQuoteFailed", "NonsupportedAccountId",
     "PaymentInstrumentNotFound", "MissingAppliedScopesForSingle", "NoValidReservationsToReRate",
     "ReRateOnlyAllowedForEA", "OperationCannotBePerformedInCurrentState",
     "InvalidSingleAppliedScopesCount", "InvalidFulfillmentRequestParameters",
     "NotSupportedCountry", "InvalidRefundQuantity", "PurchaseError", "BillingCustomerInputError",
     "BillingPaymentInstrumentSoftError", "BillingPaymentInstrumentHardError",
     "BillingTransientError", "BillingError", "FulfillmentConfigurationError",
     "FulfillmentOutOfStockError", "FulfillmentTransientError", "FulfillmentError",
     "CalculatePriceFailed".
    :type code: str or ~azure.mgmt.reservations.models.ErrorResponseCode
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[Union[str, "ErrorResponseCode"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ExtendedStatusInfo(msrest.serialization.Model):
    """ExtendedStatusInfo.

    :param status_code:  Possible values include: "None", "Pending", "Active", "PurchaseError",
     "PaymentInstrumentError", "Split", "Merged", "Expired", "Succeeded".
    :type status_code: str or ~azure.mgmt.reservations.models.ReservationStatusCode
    :param message: The message giving detailed information about the status code.
    :type message: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "ReservationStatusCode"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ExtendedStatusInfo, self).__init__(**kwargs)
        self.status_code = status_code
        self.message = message


class MergeRequest(msrest.serialization.Model):
    """MergeRequest.

    :param sources: Format of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type sources: list[str]
    """

    _attribute_map = {
        'sources': {'key': 'properties.sources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        sources: Optional[List[str]] = None,
        **kwargs
    ):
        super(MergeRequest, self).__init__(**kwargs)
        self.sources = sources


class OperationDisplay(msrest.serialization.Model):
    """OperationDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(msrest.serialization.Model):
    """OperationList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.OperationResponse]
    :param next_link: Url to get the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResponse(msrest.serialization.Model):
    """OperationResponse.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.reservations.models.OperationDisplay
    :param origin:
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        super(OperationResponse, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationResultError(msrest.serialization.Model):
    """Required if status == failed or status == canceled.

    :param code: Required if status == failed or status == cancelled. If status == failed, provide
     an invariant error code used for error troubleshooting, aggregation, and analysis.
    :type code: str
    :param message: Required if status == failed. Localized. If status == failed, provide an
     actionable error message indicating what error occurred, and what the user can do to address
     the issue.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(OperationResultError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Patch(msrest.serialization.Model):
    """Patch.

    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    :param name: Name of the Reservation.
    :type name: str
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param renew_properties:
    :type renew_properties: ~azure.mgmt.reservations.models.PatchPropertiesRenewProperties
    """

    _attribute_map = {
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'instance_flexibility': {'key': 'properties.instanceFlexibility', 'type': 'str'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'renew_properties': {'key': 'properties.renewProperties', 'type': 'PatchPropertiesRenewProperties'},
    }

    def __init__(
        self,
        *,
        applied_scope_type: Optional[Union[str, "AppliedScopeType"]] = None,
        applied_scopes: Optional[List[str]] = None,
        instance_flexibility: Optional[Union[str, "InstanceFlexibility"]] = None,
        name: Optional[str] = None,
        renew: Optional[bool] = False,
        renew_properties: Optional["PatchPropertiesRenewProperties"] = None,
        **kwargs
    ):
        super(Patch, self).__init__(**kwargs)
        self.applied_scope_type = applied_scope_type
        self.applied_scopes = applied_scopes
        self.instance_flexibility = instance_flexibility
        self.name = name
        self.renew = renew
        self.renew_properties = renew_properties


class PatchPropertiesRenewProperties(msrest.serialization.Model):
    """PatchPropertiesRenewProperties.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
    }

    def __init__(
        self,
        *,
        purchase_properties: Optional["PurchaseRequest"] = None,
        **kwargs
    ):
        super(PatchPropertiesRenewProperties, self).__init__(**kwargs)
        self.purchase_properties = purchase_properties


class PaymentDetail(msrest.serialization.Model):
    """Information about payment related to a reservation order.

    :param due_date: Date when the payment needs to be done.
    :type due_date: ~datetime.date
    :param payment_date: Date when the transaction is completed. Is null when it is scheduled.
    :type payment_date: ~datetime.date
    :param pricing_currency_total: Amount in pricing currency. Tax not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_currency_total: Amount charged in Billing currency. Tax not included. Is null
     for future payments.
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_account: Shows the Account that is charged for this payment.
    :type billing_account: str
    :param status: Describes whether the payment is completed, failed, cancelled or scheduled in
     the future. Possible values include: "Succeeded", "Failed", "Scheduled", "Cancelled".
    :type status: str or ~azure.mgmt.reservations.models.PaymentStatus
    :param extended_status_info:
    :type extended_status_info: ~azure.mgmt.reservations.models.ExtendedStatusInfo
    """

    _attribute_map = {
        'due_date': {'key': 'dueDate', 'type': 'date'},
        'payment_date': {'key': 'paymentDate', 'type': 'date'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'billing_account': {'key': 'billingAccount', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
    }

    def __init__(
        self,
        *,
        due_date: Optional[datetime.date] = None,
        payment_date: Optional[datetime.date] = None,
        pricing_currency_total: Optional["Price"] = None,
        billing_currency_total: Optional["Price"] = None,
        billing_account: Optional[str] = None,
        status: Optional[Union[str, "PaymentStatus"]] = None,
        extended_status_info: Optional["ExtendedStatusInfo"] = None,
        **kwargs
    ):
        super(PaymentDetail, self).__init__(**kwargs)
        self.due_date = due_date
        self.payment_date = payment_date
        self.pricing_currency_total = pricing_currency_total
        self.billing_currency_total = billing_currency_total
        self.billing_account = billing_account
        self.status = status
        self.extended_status_info = extended_status_info


class Price(msrest.serialization.Model):
    """Price.

    :param currency_code: The ISO 4217 3-letter currency code for the currency used by this
     purchase record.
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        **kwargs
    ):
        super(Price, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class PurchaseRequest(msrest.serialization.Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: The type of the resource that is being reserved. Possible values
     include: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat",
     "SqlDataWarehouse", "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService",
     "ManagedDisk", "BlockBlob", "RedisCache", "AzureDataExplorer", "MySql", "MariaDb",
     "PostgreSql", "DedicatedHost", "SapHana", "SqlAzureHybridBenefit".
    :type reserved_resource_type: str or ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id: Subscription that will be charged for purchasing Reservation.
    :type billing_scope_id: str
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param quantity: Quantity of the SKUs that are part of the Reservation. Must be greater than
     zero.
    :type quantity: int
    :param display_name: Friendly name of the Reservation.
    :type display_name: str
    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param reserved_resource_properties: Properties specific to each reserved resource type. Not
     required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(
        self,
        *,
        sku: Optional["SkuName"] = None,
        location: Optional[str] = None,
        reserved_resource_type: Optional[Union[str, "ReservedResourceType"]] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "ReservationTerm"]] = None,
        billing_plan: Optional[Union[str, "ReservationBillingPlan"]] = None,
        quantity: Optional[int] = None,
        display_name: Optional[str] = None,
        applied_scope_type: Optional[Union[str, "AppliedScopeType"]] = None,
        applied_scopes: Optional[List[str]] = None,
        renew: Optional[bool] = False,
        reserved_resource_properties: Optional["PurchaseRequestPropertiesReservedResourceProperties"] = None,
        **kwargs
    ):
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.reserved_resource_type = reserved_resource_type
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.quantity = quantity
        self.display_name = display_name
        self.applied_scope_type = applied_scope_type
        self.applied_scopes = applied_scopes
        self.renew = renew
        self.reserved_resource_properties = reserved_resource_properties


class PurchaseRequestPropertiesReservedResourceProperties(msrest.serialization.Model):
    """Properties specific to each reserved resource type. Not required if not applicable.

    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    """

    _attribute_map = {
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_flexibility: Optional[Union[str, "InstanceFlexibility"]] = None,
        **kwargs
    ):
        super(PurchaseRequestPropertiesReservedResourceProperties, self).__init__(**kwargs)
        self.instance_flexibility = instance_flexibility


class QuotaLimits(msrest.serialization.Model):
    """Quota limits.

    :param value: List of quotas (service limits).
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    :param next_link: The URI for fetching the next page of quotas (service limits). When no more
     pages exist, the value is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CurrentQuotaLimitBase"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(QuotaLimits, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaLimitsResponse(msrest.serialization.Model):
    """Quotas (service limits) in the request response.

    :param value: List of quotas with the quota request status.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimit]
    :param next_link: The URI for fetching the next page of quota limits. When no more pages exist,
     the value is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CurrentQuotaLimit"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(QuotaLimitsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaProperties(msrest.serialization.Model):
    """Quota properties for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param limit: Quota properties.
    :type limit: int
    :ivar current_value: Current usage value for the resource.
    :vartype current_value: int
    :param unit: The limit units, such as **count** and **bytes**. Use the unit field provided in
     the response of the GET quota operation.
    :type unit: str
    :param name: Name of the resource provide by the resource provider. Use this property for
     quotaRequests resource operations.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :param resource_type: The name of the resource type. Possible values include: "standard",
     "dedicated", "lowPriority", "shared", "serviceSpecific".
    :type resource_type: str or ~azure.mgmt.reservations.models.ResourceType
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example, P1D (per one day), PT1M (per one minute), and PT1S (per one second). This parameter is
     optional because, for some resources such as compute, the time period is irrelevant.
    :vartype quota_period: str
    :param properties: Additional properties for the specified resource provider.
    :type properties: any
    """

    _validation = {
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        limit: Optional[int] = None,
        unit: Optional[str] = None,
        name: Optional["ResourceName"] = None,
        resource_type: Optional[Union[str, "ResourceType"]] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(QuotaProperties, self).__init__(**kwargs)
        self.limit = limit
        self.current_value = None
        self.unit = unit
        self.name = name
        self.resource_type = resource_type
        self.quota_period = None
        self.properties = properties


class QuotaRequestDetails(msrest.serialization.Model):
    """Quota request details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: Quota request name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'properties.value', 'type': '[SubRequest]'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "QuotaRequestState"]] = None,
        value: Optional[List["SubRequest"]] = None,
        **kwargs
    ):
        super(QuotaRequestDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = provisioning_state
        self.message = None
        self.request_submit_time = None
        self.value = value


class QuotaRequestDetailsList(msrest.serialization.Model):
    """Quota request details.

    :param value: The quota requests.
    :type value: list[~azure.mgmt.reservations.models.QuotaRequestDetails]
    :param next_link: The URI to fetch the next page of quota limits. When there are no more pages,
     this is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaRequestDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["QuotaRequestDetails"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(QuotaRequestDetailsList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaRequestOneResourceSubmitResponse(msrest.serialization.Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/ServiceLimits".
    :vartype type: str
    :ivar provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties.properties.properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["QuotaProperties"] = None,
        **kwargs
    ):
        super(QuotaRequestOneResourceSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.request_submit_time = None
        self.properties = properties


class QuotaRequestProperties(msrest.serialization.Model):
    """The details of quota request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'request_submit_time': {'key': 'requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': '[SubRequest]'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "QuotaRequestState"]] = None,
        value: Optional[List["SubRequest"]] = None,
        **kwargs
    ):
        super(QuotaRequestProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.message = None
        self.request_submit_time = None
        self.value = value


class QuotaRequestSubmitResponse(msrest.serialization.Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :param properties: The quota request details.
    :type properties: ~azure.mgmt.reservations.models.QuotaRequestProperties
    :ivar type: Type of resource. "Microsoft.Capacity/serviceLimits".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'QuotaRequestProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: Optional["QuotaRequestProperties"] = None,
        **kwargs
    ):
        super(QuotaRequestSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = properties
        self.type = None


class QuotaRequestSubmitResponse201(msrest.serialization.Model):
    """Response with request ID that the quota request was accepted.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID. Use the requestId parameter to check the request status.
    :vartype id: str
    :ivar name: Operation ID.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The details of the quota request status. Possible values include:
     "Accepted", "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestSubmitResponse201, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None


class RenewPropertiesResponse(msrest.serialization.Model):
    """RenewPropertiesResponse.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param pricing_currency_total: Amount that Microsoft uses for record. Used during refund for
     calculating refund limit. Tax is not included. This is locked price 30 days before expiry.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponsePricingCurrencyTotal
    :param billing_currency_total: Currency and amount that customer will be charged in customer's
     local currency for renewal purchase. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponseBillingCurrencyTotal
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'RenewPropertiesResponsePricingCurrencyTotal'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'RenewPropertiesResponseBillingCurrencyTotal'},
    }

    def __init__(
        self,
        *,
        purchase_properties: Optional["PurchaseRequest"] = None,
        pricing_currency_total: Optional["RenewPropertiesResponsePricingCurrencyTotal"] = None,
        billing_currency_total: Optional["RenewPropertiesResponseBillingCurrencyTotal"] = None,
        **kwargs
    ):
        super(RenewPropertiesResponse, self).__init__(**kwargs)
        self.purchase_properties = purchase_properties
        self.pricing_currency_total = pricing_currency_total
        self.billing_currency_total = billing_currency_total


class RenewPropertiesResponseBillingCurrencyTotal(msrest.serialization.Model):
    """Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        **kwargs
    ):
        super(RenewPropertiesResponseBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class RenewPropertiesResponsePricingCurrencyTotal(msrest.serialization.Model):
    """Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked price 30 days before expiry.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        **kwargs
    ):
        super(RenewPropertiesResponsePricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class ReservationList(msrest.serialization.Model):
    """ReservationList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.ReservationResponse]
    :param next_link: Url to get the next page of reservations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReservationResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ReservationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReservationMergeProperties(msrest.serialization.Model):
    """ReservationMergeProperties.

    :param merge_destination: Reservation Resource Id Created due to the merge. Format of the
     resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type merge_destination: str
    :param merge_sources: Resource Ids of the Source Reservation's merged to form this Reservation.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type merge_sources: list[str]
    """

    _attribute_map = {
        'merge_destination': {'key': 'mergeDestination', 'type': 'str'},
        'merge_sources': {'key': 'mergeSources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        merge_destination: Optional[str] = None,
        merge_sources: Optional[List[str]] = None,
        **kwargs
    ):
        super(ReservationMergeProperties, self).__init__(**kwargs)
        self.merge_destination = merge_destination
        self.merge_sources = merge_sources


class ReservationOrderBillingPlanInformation(msrest.serialization.Model):
    """Information describing the type of billing plan for this reservation.

    :param pricing_currency_total: Amount of money to be paid for the Order. Tax is not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param start_date: Date when the billing plan has started.
    :type start_date: ~datetime.date
    :param next_payment_due_date: For recurring billing plans, indicates the date when next payment
     will be processed. Null when total is paid off.
    :type next_payment_due_date: ~datetime.date
    :param transactions:
    :type transactions: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'start_date': {'key': 'startDate', 'type': 'date'},
        'next_payment_due_date': {'key': 'nextPaymentDueDate', 'type': 'date'},
        'transactions': {'key': 'transactions', 'type': '[PaymentDetail]'},
    }

    def __init__(
        self,
        *,
        pricing_currency_total: Optional["Price"] = None,
        start_date: Optional[datetime.date] = None,
        next_payment_due_date: Optional[datetime.date] = None,
        transactions: Optional[List["PaymentDetail"]] = None,
        **kwargs
    ):
        super(ReservationOrderBillingPlanInformation, self).__init__(**kwargs)
        self.pricing_currency_total = pricing_currency_total
        self.start_date = start_date
        self.next_payment_due_date = next_payment_due_date
        self.transactions = transactions


class ReservationOrderList(msrest.serialization.Model):
    """ReservationOrderList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.ReservationOrderResponse]
    :param next_link: Url to get the next page of reservationOrders.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationOrderResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReservationOrderResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ReservationOrderList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReservationOrderResponse(msrest.serialization.Model):
    """ReservationOrderResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation.
    :vartype id: str
    :ivar name: Name of the reservation.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/reservations".
    :vartype type: str
    :param display_name: Friendly name for user to easily identified the reservation.
    :type display_name: str
    :param request_date_time: This is the DateTime when the reservation was initially requested for
     purchase.
    :type request_date_time: ~datetime.datetime
    :param created_date_time: This is the DateTime when the reservation was created.
    :type created_date_time: ~datetime.datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: ~datetime.date
    :param original_quantity: Quantity of the SKUs that are part of the Reservation. Must be
     greater than zero.
    :type original_quantity: int
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param plan_information: Information describing the type of billing plan for this reservation.
    :type plan_information: ~azure.mgmt.reservations.models.ReservationOrderBillingPlanInformation
    :param reservations:
    :type reservations: list[~azure.mgmt.reservations.models.ReservationResponse]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'request_date_time': {'key': 'properties.requestDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'properties.expiryDate', 'type': 'date'},
        'original_quantity': {'key': 'properties.originalQuantity', 'type': 'int'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'plan_information': {'key': 'properties.planInformation', 'type': 'ReservationOrderBillingPlanInformation'},
        'reservations': {'key': 'properties.reservations', 'type': '[ReservationResponse]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[int] = None,
        display_name: Optional[str] = None,
        request_date_time: Optional[datetime.datetime] = None,
        created_date_time: Optional[datetime.datetime] = None,
        expiry_date: Optional[datetime.date] = None,
        original_quantity: Optional[int] = None,
        term: Optional[Union[str, "ReservationTerm"]] = None,
        provisioning_state: Optional[str] = None,
        billing_plan: Optional[Union[str, "ReservationBillingPlan"]] = None,
        plan_information: Optional["ReservationOrderBillingPlanInformation"] = None,
        reservations: Optional[List["ReservationResponse"]] = None,
        **kwargs
    ):
        super(ReservationOrderResponse, self).__init__(**kwargs)
        self.etag = etag
        self.id = None
        self.name = None
        self.type = None
        self.display_name = display_name
        self.request_date_time = request_date_time
        self.created_date_time = created_date_time
        self.expiry_date = expiry_date
        self.original_quantity = original_quantity
        self.term = term
        self.provisioning_state = provisioning_state
        self.billing_plan = billing_plan
        self.plan_information = plan_information
        self.reservations = reservations


class ReservationProperties(msrest.serialization.Model):
    """ReservationProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param reserved_resource_type: The type of the resource that is being reserved. Possible values
     include: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat",
     "SqlDataWarehouse", "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService",
     "ManagedDisk", "BlockBlob", "RedisCache", "AzureDataExplorer", "MySql", "MariaDb",
     "PostgreSql", "DedicatedHost", "SapHana", "SqlAzureHybridBenefit".
    :type reserved_resource_type: str or ~azure.mgmt.reservations.models.ReservedResourceType
    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    :param display_name: Friendly name for user to easily identify the reservation.
    :type display_name: str
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param quantity: Quantity of the SKUs that are part of the Reservation. Must be greater than
     zero.
    :type quantity: int
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param effective_date_time: DateTime of the Reservation starting when this version is effective
     from.
    :type effective_date_time: ~datetime.datetime
    :ivar last_updated_date_time: DateTime of the last time the Reservation was updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: ~datetime.date
    :param sku_description: Description of the SKU in english.
    :type sku_description: str
    :param extended_status_info:
    :type extended_status_info: ~azure.mgmt.reservations.models.ExtendedStatusInfo
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param split_properties:
    :type split_properties: ~azure.mgmt.reservations.models.ReservationSplitProperties
    :param merge_properties:
    :type merge_properties: ~azure.mgmt.reservations.models.ReservationMergeProperties
    :param billing_scope_id: Subscription that will be charged for purchasing Reservation.
    :type billing_scope_id: str
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param renew_source: Reservation Id of the reservation from which this reservation is renewed.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_source: str
    :param renew_destination: Reservation Id of the reservation which is purchased because of
     renew. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_destination: str
    :param renew_properties:
    :type renew_properties: ~azure.mgmt.reservations.models.RenewPropertiesResponse
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    """

    _validation = {
        'last_updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'reserved_resource_type': {'key': 'reservedResourceType', 'type': 'str'},
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'applied_scope_type': {'key': 'appliedScopeType', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'effective_date_time': {'key': 'effectiveDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'expiryDate', 'type': 'date'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
        'billing_plan': {'key': 'billingPlan', 'type': 'str'},
        'split_properties': {'key': 'splitProperties', 'type': 'ReservationSplitProperties'},
        'merge_properties': {'key': 'mergeProperties', 'type': 'ReservationMergeProperties'},
        'billing_scope_id': {'key': 'billingScopeId', 'type': 'str'},
        'renew': {'key': 'renew', 'type': 'bool'},
        'renew_source': {'key': 'renewSource', 'type': 'str'},
        'renew_destination': {'key': 'renewDestination', 'type': 'str'},
        'renew_properties': {'key': 'renewProperties', 'type': 'RenewPropertiesResponse'},
        'term': {'key': 'term', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reserved_resource_type: Optional[Union[str, "ReservedResourceType"]] = None,
        instance_flexibility: Optional[Union[str, "InstanceFlexibility"]] = None,
        display_name: Optional[str] = None,
        applied_scopes: Optional[List[str]] = None,
        applied_scope_type: Optional[Union[str, "AppliedScopeType"]] = None,
        quantity: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        effective_date_time: Optional[datetime.datetime] = None,
        expiry_date: Optional[datetime.date] = None,
        sku_description: Optional[str] = None,
        extended_status_info: Optional["ExtendedStatusInfo"] = None,
        billing_plan: Optional[Union[str, "ReservationBillingPlan"]] = None,
        split_properties: Optional["ReservationSplitProperties"] = None,
        merge_properties: Optional["ReservationMergeProperties"] = None,
        billing_scope_id: Optional[str] = None,
        renew: Optional[bool] = False,
        renew_source: Optional[str] = None,
        renew_destination: Optional[str] = None,
        renew_properties: Optional["RenewPropertiesResponse"] = None,
        term: Optional[Union[str, "ReservationTerm"]] = None,
        **kwargs
    ):
        super(ReservationProperties, self).__init__(**kwargs)
        self.reserved_resource_type = reserved_resource_type
        self.instance_flexibility = instance_flexibility
        self.display_name = display_name
        self.applied_scopes = applied_scopes
        self.applied_scope_type = applied_scope_type
        self.quantity = quantity
        self.provisioning_state = provisioning_state
        self.effective_date_time = effective_date_time
        self.last_updated_date_time = None
        self.expiry_date = expiry_date
        self.sku_description = sku_description
        self.extended_status_info = extended_status_info
        self.billing_plan = billing_plan
        self.split_properties = split_properties
        self.merge_properties = merge_properties
        self.billing_scope_id = billing_scope_id
        self.renew = renew
        self.renew_source = renew_source
        self.renew_destination = renew_destination
        self.renew_properties = renew_properties
        self.term = term


class ReservationResponse(msrest.serialization.Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation.
    :vartype id: str
    :ivar name: Name of the reservation.
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource. "Microsoft.Capacity/reservationOrders/reservations".
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[int] = None,
        sku: Optional["SkuName"] = None,
        properties: Optional["ReservationProperties"] = None,
        **kwargs
    ):
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = etag
        self.id = None
        self.name = None
        self.sku = sku
        self.properties = properties
        self.type = None


class ReservationSplitProperties(msrest.serialization.Model):
    """ReservationSplitProperties.

    :param split_destinations: List of destination Resource Id that are created due to split.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type split_destinations: list[str]
    :param split_source: Resource Id of the Reservation from which this is split. Format of the
     resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type split_source: str
    """

    _attribute_map = {
        'split_destinations': {'key': 'splitDestinations', 'type': '[str]'},
        'split_source': {'key': 'splitSource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        split_destinations: Optional[List[str]] = None,
        split_source: Optional[str] = None,
        **kwargs
    ):
        super(ReservationSplitProperties, self).__init__(**kwargs)
        self.split_destinations = split_destinations
        self.split_source = split_source


class ReservationToExchange(msrest.serialization.Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned.
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information: billing information.
    :type billing_information: ~azure.mgmt.reservations.models.BillingInformation
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
    }

    def __init__(
        self,
        *,
        reservation_id: Optional[str] = None,
        quantity: Optional[int] = None,
        billing_refund_amount: Optional["Price"] = None,
        billing_information: Optional["BillingInformation"] = None,
        **kwargs
    ):
        super(ReservationToExchange, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity
        self.billing_refund_amount = billing_refund_amount
        self.billing_information = billing_information


class ReservationToPurchaseCalculateExchange(msrest.serialization.Model):
    """Reservation purchase details.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PurchaseRequest"] = None,
        billing_currency_total: Optional["Price"] = None,
        **kwargs
    ):
        super(ReservationToPurchaseCalculateExchange, self).__init__(**kwargs)
        self.properties = properties
        self.billing_currency_total = billing_currency_total


class ReservationToPurchaseExchange(msrest.serialization.Model):
    """Reservation purchase details.

    :param reservation_order_id: Fully qualified id of the ReservationOrder being purchased.
    :type reservation_order_id: str
    :param reservation_id: Fully qualified id of the Reservation being purchased. This value is
     only guaranteed to be non-null if the purchase is successful.
    :type reservation_id: str
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param status: Status of the individual operation. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reservation_order_id: Optional[str] = None,
        reservation_id: Optional[str] = None,
        properties: Optional["PurchaseRequest"] = None,
        billing_currency_total: Optional["Price"] = None,
        status: Optional[Union[str, "OperationStatus"]] = None,
        **kwargs
    ):
        super(ReservationToPurchaseExchange, self).__init__(**kwargs)
        self.reservation_order_id = reservation_order_id
        self.reservation_id = reservation_id
        self.properties = properties
        self.billing_currency_total = billing_currency_total
        self.status = status


class ReservationToReturn(msrest.serialization.Model):
    """Reservation to return.

    :param reservation_id: Fully qualified identifier of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned. Must be greater than zero.
    :type quantity: int
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        reservation_id: Optional[str] = None,
        quantity: Optional[int] = None,
        **kwargs
    ):
        super(ReservationToReturn, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity


class ReservationToReturnForExchange(msrest.serialization.Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned.
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information: billing information.
    :type billing_information: ~azure.mgmt.reservations.models.BillingInformation
    :param status: Status of the individual operation. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reservation_id: Optional[str] = None,
        quantity: Optional[int] = None,
        billing_refund_amount: Optional["Price"] = None,
        billing_information: Optional["BillingInformation"] = None,
        status: Optional[Union[str, "OperationStatus"]] = None,
        **kwargs
    ):
        super(ReservationToReturnForExchange, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity
        self.billing_refund_amount = billing_refund_amount
        self.billing_information = billing_information
        self.status = status


class ResourceName(msrest.serialization.Model):
    """Resource name provided by the resource provider. Use this property for quotaRequest parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Resource name.
    :type value: str
    :ivar localized_value: Resource display localized name.
    :vartype localized_value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ResourceName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = None


class ScopeProperties(msrest.serialization.Model):
    """ScopeProperties.

    :param scope:
    :type scope: str
    :param valid:
    :type valid: bool
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        valid: Optional[bool] = None,
        **kwargs
    ):
        super(ScopeProperties, self).__init__(**kwargs)
        self.scope = scope
        self.valid = valid


class ServiceError(msrest.serialization.Model):
    """The API error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param code: The error code.
    :type code: str
    :param message: The error message text.
    :type message: str
    :ivar details: The list of error details.
    :vartype details: list[~azure.mgmt.reservations.models.ServiceErrorDetail]
    """

    _validation = {
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ServiceErrorDetail]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ServiceError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = None


class ServiceErrorDetail(msrest.serialization.Model):
    """The error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class SkuName(msrest.serialization.Model):
    """SkuName.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SkuName, self).__init__(**kwargs)
        self.name = name


class SkuProperty(msrest.serialization.Model):
    """SkuProperty.

    :param name: An invariant to describe the feature.
    :type name: str
    :param value: An invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(SkuProperty, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SkuRestriction(msrest.serialization.Model):
    """SkuRestriction.

    :param type: The type of restrictions.
    :type type: str
    :param values: The value of restrictions. If the restriction type is set to location. This
     would be different locations where the SKU is restricted.
    :type values: list[str]
    :param reason_code: The reason for restriction.
    :type reason_code: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        values: Optional[List[str]] = None,
        reason_code: Optional[str] = None,
        **kwargs
    ):
        super(SkuRestriction, self).__init__(**kwargs)
        self.type = type
        self.values = values
        self.reason_code = reason_code


class SplitRequest(msrest.serialization.Model):
    """SplitRequest.

    :param quantities: List of the quantities in the new reservations to create.
    :type quantities: list[int]
    :param reservation_id: Resource id of the reservation to be split. Format of the resource id
     should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type reservation_id: str
    """

    _attribute_map = {
        'quantities': {'key': 'properties.quantities', 'type': '[int]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        quantities: Optional[List[int]] = None,
        reservation_id: Optional[str] = None,
        **kwargs
    ):
        super(SplitRequest, self).__init__(**kwargs)
        self.quantities = quantities
        self.reservation_id = reservation_id


class SubRequest(msrest.serialization.Model):
    """The sub-request submitted with the quota request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: Quota (resource limit).
    :vartype limit: int
    :param name: The resource name.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :ivar resource_type: Resource type for which the quota check was made.
    :vartype resource_type: str
    :param unit: The limit units, such as **count** and **bytes**. Use the unit field provided in
     the response of the GET quota operation.
    :type unit: str
    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar sub_request_id: Sub request ID for individual request.
    :vartype sub_request_id: str
    """

    _validation = {
        'limit': {'readonly': True},
        'resource_type': {'readonly': True},
        'message': {'readonly': True},
        'sub_request_id': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'sub_request_id': {'key': 'subRequestId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["ResourceName"] = None,
        unit: Optional[str] = None,
        provisioning_state: Optional[Union[str, "QuotaRequestState"]] = None,
        **kwargs
    ):
        super(SubRequest, self).__init__(**kwargs)
        self.limit = None
        self.name = name
        self.resource_type = None
        self.unit = unit
        self.provisioning_state = provisioning_state
        self.message = None
        self.sub_request_id = None


class SubscriptionScopeProperties(msrest.serialization.Model):
    """SubscriptionScopeProperties.

    :param scopes:
    :type scopes: list[~azure.mgmt.reservations.models.ScopeProperties]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[ScopeProperties]'},
    }

    def __init__(
        self,
        *,
        scopes: Optional[List["ScopeProperties"]] = None,
        **kwargs
    ):
        super(SubscriptionScopeProperties, self).__init__(**kwargs)
        self.scopes = scopes
