
# -*- coding: utf-8 -*-

# Test data for the simplify functions.

# <https://GitHub.com/milkbread/Visvalingam-Wyatt>  not Whyatt!
# <https://GitHub.com/milkbread/Visvalingam-Wyatt/blob/master/route.json>
# <https://GitHub.com/milkbread/Visvalingam-Wyatt/blob/master/out.json>
# <https://milkbread.GitHub.io/Visvalingam-Wyatt>

from bases import TestsBase

from pygeodesy import LatLon_, R_KM, R_M, \
                      ellipsoidalVincenty, sphericalTrigonometry, \
                      areaOf, isclockwise, perimeterOf, unstr
try:
    from geographiclib.geodesic import Geodesic
except ImportError:
    Geodesic = None

__all__ = ('Antarctica', 'Pts', 'PtsFFI', 'RdpFFI',
           'PtsJS', 'PtsJS5', 'VwPts')
__version__ = '23.08.10'

# <https://GeographicLib.SourceForge.io/html/python/examples.html>
Antarctica = [LatLon_(_lat, _lon) for _lat, _lon in (
    (-63.1, -58),
    (-72.9, -74),
    (-71.9,-102),
    (-74.9,-102),
    (-74.3,-131),
    (-77.5,-163),
    (-77.4, 163),
    (-71.7, 172),
    (-65.9, 140),
    (-65.7, 113),
    (-66.6,  88),
    (-66.9,  59),
    (-69.8,  25),
    (-70.0,  -4),
    (-71.0, -14),
    (-77.3, -33),
    (-77.9, -46),
    (-74.7, -61))]  # open

# <https://GitHub.com/urschrei/rdp>
PtsFFI = [LatLon_(_lat, _lon) for _lon, _lat in (
    (-0.701206, 52.220489),  # lon, lat
    (-0.701418, 52.220485),
    (-0.703903, 52.220596),
    (-0.705340, 52.220565),
    (-0.705434, 52.220821),
    (-0.705471, 52.221374),
    (-0.705456, 52.221916),
    (-0.705337, 52.222507),
    (-0.705456, 52.222827),
    (-0.705973, 52.223213),
    (-0.707747, 52.224006),
    (-0.708401, 52.224445),
    (-0.710000, 52.225944),
    (-0.710947, 52.226829),
    (-0.713120, 52.228862),
    (-0.713550, 52.229431),
    (-0.713990, 52.231090),
    (-0.714404, 52.232280),
    (-0.714460, 52.232448),
    (-0.714533, 52.232585),
    (-0.714608, 52.232688),
    (-0.714780, 52.232826),
    (-0.714839, 52.232887),
    (-0.714862, 52.232940),
    (-0.714860, 52.233013),
    (-0.714852, 52.233074),
    (-0.714808, 52.233158),
    (-0.714582, 52.233543),
    (-0.714474, 52.233818),
    (-0.714422, 52.234100),
    (-0.714348, 52.234375),
    (-0.714232, 52.234745),
    (-0.714111, 52.234989),
    (-0.714026, 52.235092),
    (-0.713913, 52.235191),
    (-0.713690, 52.235431),
    (-0.713572, 52.235607),
    (-0.713169, 52.236484),
    (-0.713114, 52.236579),
    (-0.712968, 52.236747),
    (-0.712557, 52.237239),
    (-0.712412, 52.237400),
    (-0.712330, 52.237495),
    (-0.711926, 52.238056),
    (-0.711604, 52.238529),
    (-0.711409, 52.238750),
    (-0.711181, 52.238952),
    (-0.711001, 52.239093),
    (-0.710784, 52.239315),
    (-0.710603, 52.239521),
    (-0.709919, 52.240230),
    (-0.709518, 52.240646),
    (-0.709263, 52.240825),
    (-0.708887, 52.240669),
    (-0.708684, 52.240627),
    (-0.708565, 52.240600),
    (-0.708298, 52.240573),
    (-0.707846, 52.240577),
    (-0.707594, 52.240596),
    (-0.707289, 52.240673),
    (-0.707042, 52.240745),
    (-0.706827, 52.240795),
    (-0.706592, 52.240829),
    (-0.706265, 52.240852),
    (-0.705551, 52.240890),
    (-0.705282, 52.240890),
    (-0.704945, 52.240863),
    (-0.704327, 52.240795),
    (-0.703726, 52.240756))]

RdpFFI = [LatLon_(_lat, _lon) for _lon, _lat in (
    (-0.701206, 52.220489),  # lon, lat
    (-0.705340, 52.220565),
    (-0.705456, 52.222827),
    (-0.713120, 52.228862),
    (-0.714862, 52.232940),
    (-0.709263, 52.240825),
    (-0.703726, 52.240756))]

# <https://GitHub.com/mourner/simplify-js/tree/master/test>
PtsJS = [LatLon_(_y, _x) for _x, _y in (
    (224.55, 250.15), (226.91, 244.19), (233.31, 241.45), (234.98, 236.06),
    (244.21, 232.76), (262.59, 215.31), (267.76, 213.81), (273.57, 201.84),
    (273.12, 192.16), (277.62, 189.03), (280.36, 181.41), (286.51, 177.74),
    (292.41, 159.37), (296.91, 155.64), (314.95, 151.37), (319.75, 145.16),
    (330.33, 137.57), (341.48, 139.96), (369.98, 137.89), (387.39, 142.51),
    (391.28, 139.39), (409.52, 141.14), (414.82, 139.75), (427.72, 127.30),
    (439.60, 119.74), (474.93, 107.87), (486.51, 106.75), (489.20, 109.45),
    (493.79, 108.63), (504.74, 119.66), (512.96, 122.35), (518.63, 120.89),
    (524.09, 126.88), (529.57, 127.86), (534.21, 140.93), (539.27, 147.24),
    (567.69, 148.91), (575.25, 157.26), (580.62, 158.15), (601.53, 156.85),
    (617.74, 159.86), (622.00, 167.04), (629.55, 194.60), (638.90, 195.61),
    (641.26, 200.81), (651.77, 204.56), (671.55, 222.55), (683.68, 217.45),
    (695.25, 219.15), (700.64, 217.98), (703.12, 214.36), (712.26, 215.87),
    (721.49, 212.81), (727.81, 213.36), (729.98, 208.73), (735.32, 208.20),
    (739.94, 204.77), (769.98, 208.42), (779.60, 216.87), (784.20, 218.16),
    (800.24, 214.62), (810.53, 219.73), (817.19, 226.82), (820.77, 236.17),
    (827.23, 236.16), (829.89, 239.89), (851.00, 248.94), (859.88, 255.49),
    (865.21, 268.53), (857.95, 280.30), (865.48, 291.45), (866.81, 298.66),
    (864.68, 302.71), (867.79, 306.17), (859.87, 311.37), (860.08, 314.35),
    (858.29, 314.94), (858.10, 327.60), (854.54, 335.40), (860.92, 343.00),
    (856.43, 350.15), (851.42, 352.96), (849.84, 359.59), (854.56, 365.53),
    (849.74, 370.38), (844.09, 371.89), (844.75, 380.44), (841.52, 383.67),
    (839.57, 390.40), (845.59, 399.05), (848.40, 407.55), (843.71, 411.30),
    (844.09, 419.88), (839.51, 432.76), (841.33, 441.04), (847.62, 449.22),
    (847.16, 458.44), (851.38, 462.79), (853.97, 471.15), (866.36, 480.77))]

PtsJS5 = [LatLon_(_y, _x) for _x, _y in (
    (224.55, 250.15), (267.76, 213.81), (296.91, 155.64), (330.33, 137.57),
    (409.52, 141.14), (439.60, 119.74), (486.51, 106.75), (529.57, 127.86),
    (539.27, 147.24), (617.74, 159.86), (629.55, 194.60), (671.55, 222.55),
    (727.81, 213.36), (739.94, 204.77), (769.98, 208.42), (779.60, 216.87),
    (800.24, 214.62), (820.77, 236.17), (859.88, 255.49), (865.21, 268.53),
    (857.95, 280.30), (867.79, 306.17), (859.87, 311.37), (854.54, 335.40),
    (860.92, 343.00), (849.84, 359.59), (854.56, 365.53), (844.09, 371.89),
    (839.57, 390.40), (848.40, 407.55), (839.51, 432.76), (853.97, 471.15),
    (866.36, 480.77))]

# Paris-Berlin-Warsaw-Minsk-Moscow, see
# <https://milkbread.GitHub.io/Visvalingam-Wyatt>
Pts = [LatLon_(_lat, _lon) for _lon, _lat in (
    (2.329860, 48.860050),  # lon, lat
    (2.330270, 48.860580),
    (2.330650, 48.860691),
    (2.331600, 48.860500),
    (2.333330, 48.860119),
    (2.336570, 48.859371),
    (2.336840, 48.859329),
    (2.337980, 48.859261),
    (2.338480, 48.859180),
    (2.339850, 48.858990),
    (2.340110, 48.859501),
    (2.340350, 48.859970),
    (2.340570, 48.860390),
    (2.340730, 48.860722),
    (2.340820, 48.860901),
    (2.340850, 48.860958),
    (2.340950, 48.861130),
    (2.341210, 48.861691),
    (2.341580, 48.862419),
    (2.341870, 48.862968),
    (2.341910, 48.863049),
    (2.341950, 48.863110),
    (2.342140, 48.863468),
    (2.342200, 48.863590),
    (2.342330, 48.863621),
    (2.342430, 48.863628),
    (2.342530, 48.863628),
    (2.342660, 48.863602),
    (2.342770, 48.863602),
    (2.342840, 48.863560),
    (2.343080, 48.863468),
    (2.343590, 48.863319),
    (2.344070, 48.863201),
    (2.344550, 48.863121),
    (2.345200, 48.862991),
    (2.345810, 48.863060),
    (2.346850, 48.862991),
    (2.347310, 48.862980),
    (2.347620, 48.863010),
    (2.347870, 48.863029),
    (2.347960, 48.863071),
    (2.348150, 48.863468),
    (2.348260, 48.863640),
    (2.348940, 48.863800),
    (2.349060, 48.863861),
    (2.349140, 48.863838),
    (2.350000, 48.863628),
    (2.350930, 48.863411),
    (2.351350, 48.864170),
    (2.351480, 48.864410),
    (2.351940, 48.865238),
    (2.352500, 48.866241),
    (2.352940, 48.867039),
    (2.353170, 48.867451),
    (2.353270, 48.867641),
    (2.353420, 48.867908),
    (2.353580, 48.868191),
    (2.353690, 48.868389),
    (2.353850, 48.868690),
    (2.353990, 48.868950),
    (2.354200, 48.869320),
    (2.354210, 48.869339),
    (2.354940, 48.870609),
    (2.355190, 48.871040),
    (2.355280, 48.871208),
    (2.355570, 48.871719),
    (2.355880, 48.872280),
    (2.356490, 48.873360),
    (2.356750, 48.873829),
    (2.357130, 48.874489),
    (2.357270, 48.874760),
    (2.357330, 48.874851),
    (2.357410, 48.874939),
    (2.357460, 48.875019),
    (2.357690, 48.875019),
    (2.358570, 48.875031),
    (2.358920, 48.874931),
    (2.359020, 48.874901),
    (2.359200, 48.875141),
    (2.359350, 48.875259),
    (2.359560, 48.875340),
    (2.360060, 48.875641),
    (2.360280, 48.875771),
    (2.360550, 48.876091),
    (2.360580, 48.876129),
    (2.361370, 48.877430),
    (2.361600, 48.877838),
    (2.362010, 48.878490),
    (2.362220, 48.878799),
    (2.362250, 48.878860),
    (2.362330, 48.878929),
    (2.362590, 48.879021),
    (2.362900, 48.879250),
    (2.364290, 48.880402),
    (2.364700, 48.880730),
    (2.365150, 48.881100),
    (2.365580, 48.881451),
    (2.365780, 48.881611),
    (2.365990, 48.881779),
    (2.366910, 48.882530),
    (2.368220, 48.883572),
    (2.368570, 48.883850),
    (2.368720, 48.883942),
    (2.368850, 48.884022),
    (2.368990, 48.884171),
    (2.369040, 48.884220),
    (2.369170, 48.884350),
    (2.369340, 48.884480),
    (2.370710, 48.885578),
    (2.370850, 48.885689),
    (2.370970, 48.885780),
    (2.371050, 48.885860),
    (2.372420, 48.886978),
    (2.372700, 48.887211),
    (2.372870, 48.887348),
    (2.373530, 48.887878),
    (2.373950, 48.888241),
    (2.374100, 48.888371),
    (2.374260, 48.888489),
    (2.375960, 48.889839),
    (2.376720, 48.890450),
    (2.376850, 48.890560),
    (2.377010, 48.890690),
    (2.377450, 48.891041),
    (2.377540, 48.891109),
    (2.377680, 48.891220),
    (2.378960, 48.892181),
    (2.379130, 48.892311),
    (2.379280, 48.892429),
    (2.379950, 48.892948),
    (2.380070, 48.893040),
    (2.380170, 48.893120),
    (2.381570, 48.894218),
    (2.381700, 48.894321),
    (2.382190, 48.894680),
    (2.382310, 48.894791),
    (2.382740, 48.895142),
    (2.383250, 48.895561),
    (2.383490, 48.895660),
    (2.383590, 48.895741),
    (2.383650, 48.895779),
    (2.383700, 48.895809),
    (2.383890, 48.895939),
    (2.384010, 48.896049),
    (2.384100, 48.896130),
    (2.384180, 48.896210),
    (2.384260, 48.896278),
    (2.384380, 48.896389),
    (2.385610, 48.897499),
    (2.385690, 48.897579),
    (2.385770, 48.897659),
    (2.386150, 48.898041),
    (2.386240, 48.898140),
    (2.386330, 48.898232),
    (2.386610, 48.898499),
    (2.387750, 48.899559),
    (2.387980, 48.899780),
    (2.388400, 48.900051),
    (2.388640, 48.900181),
    (2.388750, 48.900318),
    (2.388820, 48.900520),
    (2.388890, 48.900719),
    (2.389160, 48.900879),
    (2.389330, 48.900982),
    (2.389460, 48.901089),
    (2.390250, 48.901840),
    (2.391140, 48.902729),
    (2.391520, 48.903069),
    (2.392090, 48.903549),
    (2.392120, 48.903580),
    (2.393980, 48.905231),
    (2.394080, 48.905479),
    (2.394520, 48.905899),
    (2.395340, 48.906681),
    (2.395880, 48.907162),
    (2.396300, 48.907570),
    (2.397030, 48.908249),
    (2.398050, 48.909168),
    (2.398300, 48.909409),
    (2.399990, 48.910980),
    (2.400360, 48.911301),
    (2.403230, 48.913940),
    (2.404030, 48.914711),
    (2.404120, 48.914780),
    (2.404360, 48.915001),
    (2.404860, 48.915482),
    (2.405740, 48.916290),
    (2.406070, 48.916599),
    (2.406820, 48.917290),
    (2.407610, 48.918072),
    (2.408840, 48.919022),
    (2.409140, 48.919281),
    (2.409910, 48.920059),
    (2.411690, 48.921719),
    (2.411850, 48.921848),
    (2.412930, 48.922852),
    (2.413100, 48.923100),
    (2.413260, 48.923210),
    (2.413680, 48.923630),
    (2.413840, 48.923771),
    (2.414280, 48.924171),
    (2.415020, 48.924759),
    (2.415610, 48.925289),
    (2.416950, 48.926701),
    (2.417470, 48.927139),
    (2.417590, 48.927238),
    (2.417970, 48.927460),
    (2.418110, 48.927509),
    (2.418320, 48.927738),
    (2.418650, 48.928082),
    (2.419150, 48.928619),
    (2.420250, 48.929562),
    (2.420320, 48.929630),
    (2.420700, 48.930000),
    (2.421070, 48.930359),
    (2.422530, 48.931641),
    (2.423830, 48.932831),
    (2.424150, 48.933159),
    (2.424780, 48.933659),
    (2.425490, 48.934380),
    (2.426000, 48.934872),
    (2.426320, 48.935200),
    (2.426570, 48.935490),
    (2.427010, 48.935959),
    (2.427340, 48.936291),
    (2.427930, 48.936909),
    (2.428080, 48.937099),
    (2.428420, 48.937450),
    (2.428730, 48.937790),
    (2.429840, 48.938839),
    (2.430530, 48.939720),
    (2.431150, 48.940418),
    (2.432060, 48.940479),
    (2.432480, 48.940559),
    (2.433640, 48.940731),
    (2.434080, 48.940842),
    (2.434770, 48.940929),
    (2.435000, 48.940971),
    (2.435260, 48.941090),
    (2.436180, 48.941540),
    (2.437190, 48.942059),
    (2.437280, 48.942101),
    (2.437840, 48.942329),
    (2.438350, 48.942539),
    (2.438780, 48.942669),
    (2.439050, 48.942730),
    (2.439940, 48.942848),
    (2.440410, 48.942909),
    (2.440930, 48.943031),
    (2.441960, 48.943218),
    (2.442970, 48.943329),
    (2.443940, 48.943481),
    (2.444340, 48.943581),
    (2.445940, 48.943939),
    (2.446270, 48.944019),
    (2.448270, 48.944538),
    (2.450060, 48.945000),
    (2.451370, 48.945351),
    (2.452680, 48.945728),
    (2.452900, 48.945728),
    (2.454310, 48.946060),
    (2.455540, 48.946369),
    (2.456860, 48.946690),
    (2.458690, 48.947109),
    (2.458730, 48.947060),
    (2.458800, 48.947021),
    (2.458930, 48.946991),
    (2.459000, 48.946999),
    (2.459080, 48.947029),
    (2.459150, 48.947079),
    (2.459180, 48.947151),
    (2.459170, 48.947208),
    (2.461370, 48.947720),
    (2.461940, 48.948311),
    (2.463250, 48.949650),
    (2.463490, 48.949940),
    (2.463760, 48.949928),
    (2.466330, 48.949871),
    (2.466370, 48.949799),
    (2.466430, 48.949749),
    (2.466520, 48.949711),
    (2.466580, 48.949699),
    (2.466730, 48.949699),
    (2.466860, 48.949741),
    (2.467400, 48.949692),
    (2.467820, 48.949692),
    (2.469920, 48.949829),
    (2.472930, 48.950180),
    (2.473820, 48.950272),
    (2.474330, 48.950298),
    (2.475240, 48.950352),
    (2.477710, 48.950611),
    (2.480360, 48.950851),
    (2.481900, 48.950981),
    (2.483330, 48.951099),
    (2.483900, 48.951092),
    (2.485350, 48.951141),
    (2.485500, 48.951180),
    (2.485930, 48.951149),
    (2.486160, 48.951180),
    (2.486300, 48.951248),
    (2.486330, 48.951271),
    (2.486410, 48.951241),
    (2.486720, 48.951328),
    (2.487290, 48.951401),
    (2.491060, 48.951740),
    (2.492490, 48.951920),
    (2.492850, 48.952030),
    (2.494550, 48.952229),
    (2.496230, 48.952419),
    (2.498810, 48.952721),
    (2.499010, 48.952740),
    (2.502680, 48.953178),
    (2.506410, 48.953678),
    (2.506450, 48.953690),
    (2.508050, 48.953918),
    (2.508290, 48.953979),
    (2.508580, 48.954079),
    (2.508750, 48.954109),
    (2.508900, 48.954128),
    (2.509050, 48.954121),
    (2.509240, 48.954090),
    (2.509580, 48.954079),
    (2.509730, 48.954102),
    (2.509880, 48.954170),
    (2.509950, 48.954201),
    (2.510010, 48.954300),
    (2.510140, 48.954300),
    (2.510630, 48.954330),
    (2.512180, 48.954639),
    (2.513540, 48.954971),
    (2.514620, 48.955151),
    (2.521420, 48.956329),
    (2.525490, 48.956989),
    (2.529870, 48.957691),
    (2.531110, 48.957771),
    (2.532370, 48.958019),
    (2.534790, 48.958630),
    (2.535170, 48.958752),
    (2.535550, 48.958839),
    (2.538520, 48.959591),
    (2.542460, 48.960732),
    (2.545620, 48.961769),
    (2.548730, 48.962849),
    (2.550420, 48.963409),
    (2.555610, 48.965111),
    (2.557160, 48.965599),
    (2.564680, 48.968071),
    (2.566800, 48.968811),
    (2.570560, 48.970200),
    (2.574050, 48.971600),
    (2.578760, 48.973690),
    (2.581110, 48.974758),
    (2.582220, 48.975220),
    (2.588090, 48.977798),
    (2.596700, 48.981602),
    (2.606930, 48.986118),
    (2.609050, 48.986980),
    (2.625880, 48.994381),
    (2.627740, 48.995270),
    (2.628640, 48.995720),
    (2.632740, 48.997822),
    (2.636360, 48.999821),
    (2.639420, 49.001621),
    (2.639990, 49.001961),
    (2.643460, 49.004150),
    (2.644960, 49.005150),
    (2.646000, 49.005840),
    (2.648860, 49.007881),
    (2.652250, 49.010490),
    (2.655380, 49.013100),
    (2.655860, 49.013611),
    (2.656140, 49.013859),
    (2.659600, 49.016830),
    (2.663360, 49.020771),
    (2.665070, 49.022251),
    (2.671970, 49.029140),
    (2.672740, 49.029900),
    (2.677350, 49.034431),
    (2.681620, 49.038300),
    (2.683020, 49.039391),
    (2.686010, 49.041729),
    (2.692220, 49.046200),
    (2.694150, 49.047779),
    (2.695610, 49.049099),
    (2.697020, 49.050690),
    (2.698580, 49.052738),
    (2.699740, 49.054810),
    (2.700310, 49.055809),
    (2.701510, 49.057819),
    (2.701710, 49.058140),
    (2.701940, 49.058510),
    (2.702280, 49.059052),
    (2.702470, 49.059341),
    (2.702720, 49.059689),
    (2.703050, 49.060139),
    (2.703460, 49.060661),
    (2.703850, 49.061131),
    (2.704390, 49.061699),
    (2.704850, 49.062130),
    (2.704990, 49.062271),
    (2.705190, 49.062462),
    (2.705460, 49.062710),
    (2.705870, 49.063061),
    (2.706310, 49.063450),
    (2.706720, 49.063770),
    (2.707360, 49.064281),
    (2.708040, 49.064819),
    (2.709280, 49.065800),
    (2.710000, 49.066341),
    (2.714270, 49.069450),
    (2.716200, 49.070911),
    (2.716240, 49.070950),
    (2.726290, 49.078609),
    (2.728440, 49.080490),
    (2.729600, 49.081779),
    (2.729910, 49.082119),
    (2.730850, 49.083778),
    (2.731650, 49.085449),
    (2.733080, 49.088581),
    (2.735540, 49.093849),
    (2.736160, 49.095032),
    (2.736890, 49.096149),
    (2.737470, 49.096771),
    (2.738340, 49.097839),
    (2.739250, 49.098728),
    (2.740940, 49.100060),
    (2.741190, 49.100220),
    (2.742500, 49.101139),
    (2.744210, 49.102161),
    (2.745890, 49.102982),
    (2.747800, 49.103828),
    (2.749350, 49.104340),
    (2.750670, 49.104721),
    (2.751840, 49.105049),
    (2.754740, 49.105659),
    (2.757920, 49.106281),
    (2.760130, 49.106819),
    (2.763110, 49.107792),
    (2.765390, 49.108791),
    (2.767670, 49.110130),
    (2.770040, 49.111778),
    (2.772610, 49.113689),
    (2.774680, 49.115330),
    (2.794490, 49.130249),
    (2.796580, 49.131882),
    (2.797070, 49.132301),
    (2.797420, 49.132721),
    (2.797790, 49.133190),
    (2.798180, 49.133862),
    (2.798440, 49.134548),
    (2.798610, 49.135361),
    (2.798690, 49.136189),
    (2.798870, 49.138161),
    (2.798970, 49.139111),
    (2.799120, 49.139870),
    (2.799240, 49.140171),
    (2.799530, 49.140930),
    (2.800020, 49.141762),
    (2.800450, 49.142368),
    (2.801030, 49.142971),
    (2.801730, 49.143631),
    (2.802600, 49.144218),
    (2.803390, 49.144669),
    (2.804160, 49.145050),
    (2.805470, 49.145649),
    (2.807750, 49.146530),
    (2.808680, 49.146900),
    (2.809650, 49.147221),
    (2.810750, 49.147511),
    (2.811270, 49.147621),
    (2.811960, 49.147751),
    (2.813080, 49.147900),
    (2.813710, 49.147968),
    (2.814350, 49.147999),
    (2.815350, 49.148029),
    (2.816500, 49.147991),
    (2.817170, 49.147942),
    (2.818330, 49.147820),
    (2.820250, 49.147640),
    (2.821510, 49.147629),
    (2.822670, 49.147720),
    (2.823810, 49.147888),
    (2.824940, 49.148159),
    (2.826310, 49.148640),
    (2.828040, 49.149410),
    (2.829780, 49.150211),
    (2.846210, 49.157539),
    (2.848480, 49.158550),
    (2.849820, 49.159149),
    (2.850810, 49.159611),
    (2.851190, 49.159790),
    (2.851330, 49.159882),
    (2.851500, 49.160000),
    (2.852040, 49.160511),
    (2.852090, 49.160549),
    (2.852240, 49.160690),
    (2.852440, 49.160839),
    (2.852820, 49.161060),
    (2.855420, 49.162529),
    (2.856930, 49.163368),
    (2.857180, 49.163509),
    (2.860080, 49.165089),
    (2.860800, 49.165390),
    (2.866650, 49.168430),
    (2.869650, 49.170021),
    (2.873730, 49.172180),
    (2.879990, 49.175621),
    (2.881100, 49.176231),
    (2.886420, 49.179279),
    (2.889700, 49.181438),
    (2.891760, 49.182590),
    (2.893580, 49.183601),
    (2.893850, 49.183750),
    (2.895700, 49.184780),
    (2.896540, 49.185249),
    (2.901080, 49.187790),
    (2.903030, 49.188808),
    (2.905490, 49.190102),
    (2.906770, 49.190701),
    (2.908700, 49.191761),
    (2.910320, 49.192410),
    (2.912400, 49.193031),
    (2.914880, 49.193470),
    (2.915770, 49.193699),
    (2.917970, 49.194241),
    (2.919990, 49.195129),
    (2.921780, 49.196159),
    (2.924060, 49.197929),
    (2.925930, 49.199371),
    (2.930850, 49.203152),
    (2.932420, 49.204380),
    (2.932740, 49.204620),
    (2.933660, 49.205330),
    (2.935190, 49.206249),
    (2.935960, 49.206699),
    (2.936980, 49.207180),
    (2.939450, 49.208111),
    (2.940620, 49.208591),
    (2.943580, 49.209690),
    (2.952730, 49.213112),
    (2.954420, 49.213718),
    (2.955060, 49.213951),
    (2.955160, 49.214001),
    (2.955570, 49.214230),
    (2.956040, 49.214489),
    (2.957640, 49.215549),
    (2.960670, 49.217560),
    (2.961880, 49.218311),
    (2.964670, 49.220150),
    (2.964830, 49.220261),
    (2.965000, 49.220360),
    (2.972160, 49.224949),
    (2.975900, 49.227390),
    (2.976840, 49.227852),
    (2.983170, 49.230679),
    (2.986860, 49.232349),
    (2.987760, 49.232700),
    (2.990060, 49.233730),
    (2.994960, 49.235939),
    (2.995490, 49.236160),
    (2.996000, 49.236301),
    (2.997150, 49.236519),
    (2.999040, 49.236801),
    (3.003640, 49.237469),
    (3.004990, 49.237701),
    (3.006480, 49.237999),
    (3.007710, 49.238449),
    (3.008760, 49.238819),
    (3.009690, 49.239140),
    (3.011200, 49.239620),
    (3.012310, 49.239899),
    (3.013490, 49.240120),
    (3.014250, 49.240231),
    (3.015150, 49.240311),
    (3.016120, 49.240349),
    (3.017420, 49.240330),
    (3.018650, 49.240261),
    (3.020380, 49.240170),
    (3.023760, 49.239960),
    (3.025360, 49.240009),
    (3.027050, 49.240231),
    (3.027880, 49.240459),
    (3.028370, 49.240631),
    (3.030500, 49.241070),
    (3.031730, 49.241322),
    (3.032260, 49.241440),
    (3.033010, 49.241539),
    (3.033920, 49.241879),
    (3.034080, 49.241982),
    (3.034860, 49.242661),
    (3.035130, 49.243038),
    (3.035700, 49.244301),
    (3.035810, 49.244530),
    (3.036360, 49.245651),
    (3.036820, 49.246090),
    (3.037580, 49.246540),
    (3.038700, 49.246910),
    (3.040070, 49.247040),
    (3.041250, 49.247139),
    (3.042700, 49.247311),
    (3.044330, 49.247700),
    (3.047330, 49.248638),
    (3.050370, 49.249550),
    (3.053900, 49.250599),
    (3.055890, 49.251160),
    (3.058300, 49.251621),
    (3.062000, 49.252178),
    (3.064620, 49.252682),
    (3.065430, 49.252930),
    (3.066100, 49.253201),
    (3.066700, 49.253490),
    (3.066980, 49.253632),
    (3.067390, 49.253849),
    (3.068230, 49.254398),
    (3.078680, 49.262150),
    (3.079680, 49.262779),
    (3.080680, 49.263340),
    (3.081650, 49.263840),
    (3.082680, 49.264229),
    (3.084300, 49.264870),
    (3.085430, 49.265160),
    (3.089230, 49.265839),
    (3.092040, 49.266029),
    (3.092700, 49.266048),
    (3.093200, 49.266041),
    (3.096540, 49.266109),
    (3.097390, 49.266129),
    (3.103670, 49.266090),
    (3.109060, 49.266151),
    (3.119280, 49.266190),
    (3.128740, 49.266121),
    (3.129820, 49.266151),
    (3.130540, 49.266201),
    (3.131220, 49.266312),
    (3.131470, 49.266361),
    (3.131980, 49.266472),
    (3.133990, 49.267200),
    (3.136750, 49.268410),
    (3.140430, 49.270390),
    (3.146590, 49.274078),
    (3.149110, 49.275848),
    (3.152100, 49.277939),
    (3.152650, 49.278271),
    (3.155960, 49.280190),
    (3.166630, 49.286388),
    (3.168200, 49.287510),
    (3.168330, 49.287609),
    (3.171030, 49.289768),
    (3.172910, 49.290920),
    (3.174810, 49.291920),
    (3.176870, 49.292740),
    (3.179640, 49.294060),
    (3.180860, 49.294731),
    (3.182540, 49.295399),
    (3.184010, 49.295811),
    (3.185710, 49.295959),
    (3.186950, 49.295979),
    (3.188330, 49.295898),
    (3.190000, 49.295830),
    (3.192030, 49.295979),
    (3.193800, 49.296310),
    (3.195400, 49.296730),
    (3.197530, 49.297539),
    (3.199720, 49.298759),
    (3.201480, 49.299938),
    (3.202860, 49.300652),
    (3.204240, 49.301220),
    (3.205910, 49.301651),
    (3.207880, 49.301891),
    (3.210380, 49.302059),
    (3.212190, 49.302269),
    (3.214290, 49.302959),
    (3.220310, 49.305710),
    (3.225460, 49.308640),
    (3.227030, 49.309811),
    (3.228490, 49.311020),
    (3.231070, 49.312740),
    (3.234290, 49.314880),
    (3.237800, 49.317299),
    (3.242330, 49.320560),
    (3.244540, 49.322750),
    (3.247090, 49.325081),
    (3.248000, 49.325722),
    (3.249020, 49.326302),
    (3.250990, 49.327320),
    (3.252060, 49.327991),
    (3.253070, 49.328751),
    (3.253900, 49.329418),
    (3.257490, 49.332272),
    (3.258560, 49.332909),
    (3.259720, 49.333790),
    (3.265700, 49.338329),
    (3.270380, 49.341782),
    (3.271720, 49.342751),
    (3.274530, 49.344791),
    (3.275560, 49.345718),
    (3.276030, 49.346260),
    (3.280220, 49.352268),
    (3.280560, 49.352921),
    (3.280790, 49.353329),
    (3.281640, 49.354950),
    (3.282500, 49.355968),
    (3.283010, 49.356419),
    (3.283050, 49.356419),
    (3.283880, 49.356510),
    (3.284400, 49.356571),
    (3.284950, 49.356640),
    (3.285660, 49.356709),
    (3.285950, 49.356720),
    (3.286410, 49.356709),
    (3.286630, 49.356770),
    (3.286910, 49.356861),
    (3.287190, 49.356979),
    (3.287520, 49.357090),
    (3.287810, 49.357208),
    (3.287940, 49.357300),
    (3.288090, 49.357399),
    (3.288210, 49.357471),
    (3.288400, 49.357559),
    (3.288700, 49.357670),
    (3.288830, 49.357731),
    (3.288870, 49.357750),
    (3.288940, 49.357769),
    (3.289060, 49.357761),
    (3.289170, 49.357719),
    (3.289480, 49.357529),
    (3.290170, 49.357059),
    (3.290520, 49.356831),
    (3.290690, 49.356720),
    (3.290800, 49.356682),
    (3.291080, 49.356670),
    (3.291320, 49.356709),
    (3.291660, 49.356750),
    (3.292060, 49.356781),
    (3.292320, 49.356831),
    (3.292550, 49.356781),
    (3.292740, 49.356781),
    (3.293140, 49.356880),
    (3.293420, 49.356880),
    (3.293690, 49.356869),
    (3.295290, 49.357380),
    (3.295900, 49.357559),
    (3.296600, 49.357738),
    (3.297600, 49.358002),
    (3.298180, 49.358212),
    (3.299700, 49.358330),
    (3.300740, 49.358459),
    (3.301890, 49.358669),
    (3.302850, 49.358860),
    (3.303910, 49.359089),
    (3.306240, 49.359570),
    (3.306690, 49.359631),
    (3.308230, 49.359730),
    (3.308740, 49.359779),
    (3.310330, 49.359970),
    (3.311200, 49.360020),
    (3.312280, 49.359970),
    (3.312860, 49.359921),
    (3.313560, 49.359840),
    (3.313890, 49.359890),
    (3.314410, 49.360039),
    (3.314660, 49.360050),
    (3.314950, 49.360001),
    (3.314950, 49.359982),
    (3.314970, 49.359890),
    (3.315050, 49.359791),
    (3.315200, 49.359718),
    (3.315420, 49.359692),
    (3.315620, 49.359730),
    (3.315750, 49.359798),
    (3.315820, 49.359890),
    (3.316060, 49.360039),
    (3.316830, 49.360142),
    (3.317100, 49.360149),
    (3.317360, 49.360100),
    (3.317640, 49.360031),
    (3.319780, 49.359299),
    (3.321730, 49.358810),
    (3.323170, 49.358620),
    (3.323640, 49.358551),
    (3.323940, 49.358509),
    (3.326280, 49.358509),
    (3.327730, 49.358620),
    (3.328900, 49.358730),
    (3.330980, 49.359200),
    (3.349990, 49.365822),
    (3.351160, 49.366230),
    (3.352330, 49.366730),
    (3.355320, 49.368061),
    (3.356530, 49.368698),
    (3.357560, 49.369381),
    (3.357830, 49.369579),
    (3.358450, 49.369961),
    (3.360150, 49.371399),
    (3.363180, 49.373959),
    (3.367320, 49.377419),
    (3.370900, 49.380451),
    (3.372170, 49.381710),
    (3.372800, 49.382549),
    (3.374870, 49.386822),
    (3.375080, 49.387329),
    (3.375150, 49.387901),
    (3.375240, 49.389030),
    (3.375010, 49.390369),
    (3.374590, 49.391369),
    (3.374240, 49.392052),
    (3.373570, 49.393021),
    (3.372610, 49.393848),
    (3.372210, 49.394199),
    (3.371460, 49.394890),
    (3.368940, 49.397270),
    (3.368580, 49.397690),
    (3.368070, 49.398499),
    (3.367670, 49.399349),
    (3.367590, 49.399570),
    (3.367500, 49.399948),
    (3.367460, 49.400379),
    (3.367420, 49.400700),
    (3.367340, 49.401569),
    (3.367250, 49.402779),
    (3.367160, 49.403622),
    (3.367100, 49.404339),
    (3.367150, 49.404831),
    (3.367290, 49.405369),
    (3.367540, 49.405891),
    (3.367840, 49.406319),
    (3.368120, 49.406639),
    (3.368400, 49.406940),
    (3.368780, 49.407242),
    (3.369190, 49.407539),
    (3.369860, 49.407921),
    (3.370590, 49.408291),
    (3.371510, 49.408718),
    (3.372310, 49.409000),
    (3.372740, 49.409088),
    (3.373290, 49.409142),
    (3.374990, 49.409199),
    (3.375520, 49.409309),
    (3.376000, 49.409401),
    (3.376460, 49.409538),
    (3.378450, 49.410198),
    (3.379020, 49.410419),
    (3.382080, 49.411491),
    (3.384580, 49.412601),
    (3.385940, 49.413212),
    (3.387610, 49.413940),
    (3.390790, 49.415298),
    (3.393280, 49.416401),
    (3.395830, 49.417488),
    (3.396460, 49.417801),
    (3.399930, 49.419800),
    (3.400920, 49.420280),
    (3.401950, 49.420719),
    (3.404630, 49.421539),
    (3.405740, 49.421871),
    (3.406840, 49.422260),
    (3.408060, 49.422791),
    (3.409550, 49.423580),
    (3.410440, 49.424141),
    (3.410780, 49.424381),
    (3.411500, 49.424919),
    (3.412330, 49.425652),
    (3.413080, 49.426418),
    (3.416940, 49.430618),
    (3.420280, 49.434330),
    (3.423710, 49.438011),
    (3.426440, 49.441021),
    (3.427190, 49.441700),
    (3.428040, 49.442322),
    (3.430210, 49.443810),
    (3.434050, 49.446411),
    (3.435040, 49.446930),
    (3.436110, 49.447430),
    (3.438210, 49.448330),
    (3.440600, 49.449200),
    (3.443830, 49.450031),
    (3.446150, 49.450439),
    (3.448860, 49.450741),
    (3.456300, 49.451180),
    (3.462530, 49.451530),
    (3.469740, 49.452019),
    (3.474970, 49.452339),
    (3.478090, 49.452728),
    (3.480840, 49.453320),
    (3.482780, 49.453819),
    (3.485520, 49.454800),
    (3.486720, 49.455299),
    (3.488420, 49.456131),
    (3.490070, 49.457031),
    (3.492070, 49.458191),
    (3.493050, 49.458771),
    (3.494410, 49.459541),
    (3.495600, 49.460110),
    (3.497170, 49.460640),
    (3.498790, 49.461029),
    (3.500430, 49.461220),
    (3.501740, 49.461281),
    (3.503300, 49.461300),
    (3.504010, 49.461311),
    (3.509640, 49.461349),
    (3.511750, 49.461601),
    (3.513870, 49.462139),
    (3.515130, 49.462608),
    (3.516610, 49.463291),
    (3.517880, 49.464142),
    (3.518930, 49.465061),
    (3.519840, 49.466122),
    (3.521070, 49.467690),
    (3.522470, 49.469349),
    (3.523720, 49.470531),
    (3.525360, 49.471779),
    (3.527410, 49.473110),
    (3.529690, 49.474491),
    (3.531250, 49.475441),
    (3.531780, 49.475800),
    (3.532920, 49.476620),
    (3.533950, 49.477421),
    (3.535650, 49.478870),
    (3.537120, 49.480110),
    (3.537430, 49.480400),
    (3.539120, 49.481930),
    (3.540960, 49.483459),
    (3.542120, 49.484451),
    (3.542850, 49.485119),
    (3.544400, 49.486420),
    (3.547350, 49.488979),
    (3.549230, 49.490631),
    (3.550780, 49.492081),
    (3.552560, 49.493870),
    (3.553730, 49.495121),
    (3.554140, 49.495548),
    (3.555050, 49.496510),
    (3.556820, 49.498039),
    (3.558710, 49.499439),
    (3.561810, 49.501659),
    (3.564780, 49.503830),
    (3.568700, 49.506649),
    (3.569100, 49.506931),
    (3.570060, 49.507648),
    (3.570990, 49.508320),
    (3.571610, 49.508770),
    (3.572810, 49.509640),
    (3.574500, 49.510830),
    (3.575360, 49.511421),
    (3.576340, 49.512112),
    (3.576690, 49.512360),
    (3.578030, 49.513309),
    (3.578760, 49.513821),
    (3.582210, 49.516281),
    (3.583260, 49.517010),
    (3.584260, 49.517731),
    (3.585200, 49.518490),
    (3.585820, 49.519058),
    (3.586330, 49.519619),
    (3.586650, 49.520000),
    (3.587030, 49.520519),
    (3.587340, 49.520988),
    (3.587630, 49.521469),
    (3.587870, 49.521938),
    (3.588050, 49.522339),
    (3.588220, 49.522781),
    (3.588370, 49.523220),
    (3.588550, 49.524010),
    (3.588870, 49.525612),
    (3.589130, 49.526970),
    (3.589420, 49.528580),
    (3.589730, 49.530399),
    (3.589890, 49.531071),
    (3.590110, 49.531830),
    (3.590310, 49.532181),
    (3.590610, 49.532509),
    (3.590940, 49.532761),
    (3.591280, 49.532940),
    (3.592260, 49.533421),
    (3.592400, 49.533581),
    (3.592460, 49.533741),
    (3.592360, 49.534031),
    (3.592290, 49.534222),
    (3.592370, 49.534241),
    (3.592860, 49.534489),
    (3.593240, 49.534790),
    (3.593800, 49.535480),
    (3.594050, 49.535789),
    (3.594790, 49.536228),
    (3.595810, 49.536789),
    (3.596730, 49.537159),
    (3.597140, 49.537479),
    (3.599650, 49.538719),
    (3.599970, 49.539108),
    (3.600450, 49.539421),
    (3.600820, 49.539551),
    (3.601390, 49.539650),
    (3.602220, 49.539509),
    (3.602950, 49.539421),
    (3.603350, 49.539310),
    (3.603850, 49.539249),
    (3.604360, 49.539291),
    (3.605310, 49.539490),
    (3.605580, 49.539612),
    (3.605980, 49.539791),
    (3.606510, 49.540310),
    (3.606640, 49.540459),
    (3.607050, 49.540970),
    (3.607500, 49.541649),
    (3.607960, 49.542278),
    (3.608400, 49.542610),
    (3.611060, 49.543991),
    (3.613960, 49.545181),
    (3.615610, 49.546120),
    (3.615900, 49.546219),
    (3.616320, 49.546299),
    (3.616530, 49.546539),
    (3.616600, 49.546558),
    (3.616690, 49.546619),
    (3.616720, 49.546680),
    (3.616730, 49.546711),
    (3.617040, 49.546860),
    (3.617910, 49.547211),
    (3.618900, 49.547562),
    (3.620940, 49.548370),
    (3.623760, 49.549431),
    (3.624250, 49.549641),
    (3.624880, 49.550018),
    (3.626860, 49.550911),
    (3.627010, 49.551029),
    (3.627090, 49.551182),
    (3.627290, 49.551819),
    (3.627550, 49.552280),
    (3.627790, 49.552601),
    (3.628240, 49.553009),
    (3.628690, 49.553291),
    (3.628770, 49.554050),
    (3.628790, 49.554321),
    (3.628820, 49.554680),
    (3.628800, 49.554859),
    (3.628710, 49.555721),
    (3.628570, 49.556099),
    (3.628310, 49.556961),
    (3.627870, 49.558140),
    (3.627800, 49.558270),
    (3.628630, 49.558441),
    (3.629470, 49.558849),
    (3.630120, 49.559368),
    (3.631420, 49.560188),
    (3.631780, 49.560749),
    (3.631920, 49.561279),
    (3.632250, 49.561569),
    (3.633230, 49.561970),
    (3.633680, 49.562191),
    (3.635550, 49.563992),
    (3.635680, 49.564770),
    (3.635610, 49.565159),
    (3.635350, 49.565399),
    (3.635320, 49.565430),
    (3.635200, 49.565689),
    (3.635040, 49.566040),
    (3.634470, 49.567150),
    (3.634340, 49.567471),
    (3.633980, 49.567780),
    (3.633670, 49.568180),
    (3.633550, 49.568359),
    (3.633640, 49.568691),
    (3.633410, 49.569500),
    (3.633290, 49.569859),
    (3.633510, 49.569950),
    (3.633570, 49.569981),
    (3.633600, 49.569969),
    (3.633640, 49.569981),
    (3.633670, 49.570000),
    (3.633690, 49.570011),
    (3.633700, 49.570030),
    (3.633690, 49.570049),
    (3.633680, 49.570068),
    (3.634200, 49.570210),
    (3.634640, 49.570259),
    (3.635020, 49.570301),
    (3.635240, 49.570381),
    (3.635420, 49.570492),
    (3.635550, 49.570641),
    (3.635600, 49.570770),
    (3.635580, 49.571621),
    (3.635540, 49.572151),
    (3.635530, 49.573311),
    (3.635530, 49.573460),
    (3.635550, 49.573650),
    (3.635670, 49.573921),
    (3.637930, 49.575909),
    (3.638240, 49.576191),
    (3.639780, 49.577591),
    (3.639890, 49.577690),
    (3.640070, 49.577850),
    (3.640530, 49.578281),
    (3.643680, 49.581089),
    (3.644690, 49.582039),
    (3.645210, 49.582531),
    (3.645500, 49.582802),
    (3.646340, 49.583530),
    (3.646730, 49.583858),
    (3.647170, 49.584259),
    (3.647650, 49.584702),
    (3.647900, 49.584919),
    (3.648290, 49.585270),
    (3.648620, 49.585571),
    (3.648910, 49.585850),
    (3.648990, 49.585819),
    (3.649090, 49.585812),
    (3.649170, 49.585812),
    (3.649260, 49.585838),
    (3.649350, 49.585911),
    (3.649380, 49.585972),
    (3.649380, 49.586029),
    (3.649350, 49.586090),
    (3.649280, 49.586151),
    (3.650120, 49.586929),
    (3.650600, 49.587379),
    (3.651390, 49.588112),
    (3.652500, 49.589119),
    (3.652540, 49.589149),
    (3.652660, 49.589260),
    (3.653470, 49.589981),
    (3.654110, 49.590549),
    (3.654450, 49.590870),
    (3.654470, 49.590889),
    (3.654500, 49.590889),
    (3.654530, 49.590889),
    (3.654560, 49.590889),
    (3.654580, 49.590900),
    (3.654600, 49.590919),
    (3.654600, 49.590931),
    (3.654600, 49.590950),
    (3.654600, 49.590969),
    (3.654580, 49.590981),
    (3.654610, 49.591011),
    (3.655440, 49.591770),
    (3.656120, 49.592361),
    (3.656490, 49.592640),
    (3.657070, 49.593090),
    (3.657270, 49.593239),
    (3.657390, 49.593330),
    (3.657860, 49.593689),
    (3.658080, 49.593849),
    (3.658210, 49.593868),
    (3.658330, 49.593849),
    (3.658450, 49.593868),
    (3.658580, 49.593910),
    (3.659140, 49.594090),
    (3.659180, 49.594009),
    (3.659270, 49.593941),
    (3.659440, 49.593891),
    (3.659540, 49.593891),
    (3.659670, 49.593910),
    (3.659780, 49.593971),
    (3.659850, 49.594040),
    (3.659870, 49.594090),
    (3.659860, 49.594200),
    (3.659800, 49.594280),
    (3.659680, 49.594341),
    (3.659530, 49.594372),
    (3.659910, 49.596668),
    (3.660890, 49.598480),
    (3.660990, 49.598671),
    (3.662510, 49.601540),
    (3.662790, 49.602051),
    (3.663590, 49.603500),
    (3.664810, 49.605740),
    (3.664940, 49.605930),
    (3.665180, 49.606392),
    (3.665300, 49.606571),
    (3.665420, 49.606709),
    (3.665570, 49.606800),
    (3.665740, 49.606861),
    (3.665860, 49.606949),
    (3.665910, 49.607071),
    (3.665910, 49.607151),
    (3.665840, 49.607262),
    (3.665790, 49.607399),
    (3.665840, 49.607559),
    (3.665960, 49.607780),
    (3.666050, 49.608021),
    (3.666270, 49.608391),
    (3.666860, 49.609539),
    (3.669590, 49.614330),
    (3.675250, 49.624729),
    (3.688710, 49.649849),
    (3.694050, 49.659801),
    (3.700230, 49.670971),
    (3.705510, 49.681160),
    (3.706730, 49.683460),
    (3.710120, 49.689899),
    (3.713400, 49.696129),
    (3.717570, 49.704128),
    (3.718100, 49.704990),
    (3.718670, 49.705761),
    (3.719380, 49.706539),
    (3.720230, 49.707321),
    (3.721050, 49.707970),
    (3.722050, 49.708641),
    (3.730960, 49.713829),
    (3.733580, 49.715481),
    (3.736450, 49.717491),
    (3.741890, 49.721199),
    (3.751640, 49.728088),
    (3.753830, 49.729691),
    (3.754140, 49.729980),
    (3.754540, 49.730549),
    (3.754850, 49.731079),
    (3.755080, 49.731152),
    (3.755180, 49.731239),
    (3.755200, 49.731380),
    (3.755150, 49.731480),
    (3.755050, 49.731560),
    (3.754900, 49.731609),
    (3.754560, 49.732288),
    (3.754500, 49.732590),
    (3.756180, 49.740540),
    (3.756230, 49.740791),
    (3.756360, 49.741291),
    (3.757130, 49.742630),
    (3.759450, 49.743961),
    (3.762960, 49.745411),
    (3.766400, 49.746841),
    (3.770610, 49.748749),
    (3.770690, 49.748791),
    (3.770880, 49.748829),
    (3.771120, 49.748840),
    (3.771210, 49.748829),
    (3.771340, 49.748840),
    (3.771440, 49.748871),
    (3.771520, 49.748909),
    (3.771570, 49.748989),
    (3.771570, 49.749069),
    (3.771640, 49.749168),
    (3.771810, 49.749340),
    (3.776450, 49.752281),
    (3.788980, 49.760368),
    (3.792580, 49.762699),
    (3.794380, 49.764481),
    (3.796360, 49.766750),
    (3.797300, 49.769020),
    (3.798100, 49.770100),
    (3.799330, 49.771358),
    (3.800050, 49.771950),
    (3.802710, 49.774071),
    (3.805200, 49.776779),
    (3.807520, 49.779331),
    (3.808520, 49.780540),
    (3.811210, 49.782219),
    (3.813480, 49.783451),
    (3.829830, 49.792301),
    (3.848630, 49.802551),
    (3.863480, 49.810909),
    (3.863900, 49.811131),
    (3.880470, 49.819889),
    (3.893350, 49.827751),
    (3.896740, 49.830109),
    (3.897640, 49.830742),
    (3.898660, 49.831470),
    (3.898920, 49.831539),
    (3.899070, 49.831558),
    (3.899270, 49.831581),
    (3.899380, 49.831631),
    (3.899530, 49.831760),
    (3.899600, 49.831779),
    (3.899630, 49.831799),
    (3.899670, 49.831829),
    (3.899680, 49.831871),
    (3.899670, 49.831921),
    (3.899690, 49.832001),
    (3.899740, 49.832100),
    (3.899870, 49.832230),
    (3.900140, 49.832340),
    (3.900940, 49.832489),
    (3.901730, 49.832630),
    (3.902750, 49.832821),
    (3.904400, 49.833111),
    (3.906980, 49.833530),
    (3.907290, 49.833580),
    (3.908120, 49.833710),
    (3.908610, 49.833809),
    (3.908840, 49.833858),
    (3.909280, 49.833969),
    (3.909560, 49.834099),
    (3.909810, 49.834320),
    (3.910860, 49.835670),
    (3.911180, 49.835949),
    (3.911630, 49.836300),
    (3.912390, 49.836891),
    (3.912530, 49.837002),
    (3.913060, 49.837421),
    (3.916350, 49.839970),
    (3.916710, 49.840160),
    (3.916960, 49.840221),
    (3.917070, 49.840210),
    (3.917300, 49.840260),
    (3.917360, 49.840309),
    (3.917390, 49.840408),
    (3.917330, 49.840542),
    (3.917430, 49.840752),
    (3.917630, 49.840939),
    (3.919260, 49.842201),
    (3.919500, 49.842281),
    (3.919800, 49.842361),
    (3.919860, 49.842411),
    (3.919940, 49.842571),
    (3.919900, 49.842690),
    (3.926010, 49.847469),
    (3.926100, 49.847530),
    (3.927710, 49.848579),
    (3.929610, 49.849781),
    (3.930600, 49.850300),
    (3.941230, 49.854511),
    (3.942080, 49.854778),
    (3.954800, 49.856899),
    (3.959390, 49.857658),
    (3.960350, 49.857780),
    (3.961810, 49.857868),
    (3.963710, 49.858070),
    (3.965780, 49.858379),
    (3.966650, 49.858490),
    (3.973290, 49.859180),
    (3.975030, 49.859360),
    (3.982970, 49.860130),
    (3.985420, 49.860401),
    (3.986070, 49.860531),
    (3.986740, 49.860741),
    (3.987330, 49.861000),
    (3.987540, 49.861130),
    (3.989040, 49.862068),
    (3.989500, 49.862339),
    (3.990080, 49.862549),
    (3.993040, 49.863449),
    (3.997550, 49.864590),
    (3.998430, 49.864880),
    (3.998970, 49.865131),
    (4.000990, 49.866039),
    (4.002960, 49.866619),
    (4.005520, 49.867611),
    (4.007150, 49.868370),
    (4.010130, 49.869839),
    (4.012740, 49.871159),
    (4.015630, 49.872959),
    (4.016130, 49.873371),
    (4.016580, 49.873878),
    (4.018910, 49.877590),
    (4.019100, 49.878090),
    (4.019190, 49.880131),
    (4.019280, 49.880920),
    (4.019520, 49.881828),
    (4.019870, 49.882740),
    (4.020220, 49.883438),
    (4.020700, 49.884109),
    (4.021340, 49.884880),
    (4.022490, 49.886120),
    (4.023420, 49.887161),
    (4.024220, 49.887981),
    (4.024990, 49.888649),
    (4.026250, 49.889511),
    (4.027650, 49.890209),
    (4.028720, 49.890591),
    (4.029860, 49.890961),
    (4.031140, 49.891220),
    (4.032380, 49.891411),
    (4.033970, 49.891659),
    (4.036540, 49.892029),
    (4.038550, 49.892368),
    (4.040190, 49.892620),
    (4.041120, 49.892830),
    (4.041780, 49.893051),
    (4.042410, 49.893330),
    (4.044140, 49.894169),
    (4.048230, 49.896320),
    (4.054980, 49.899811),
    (4.056230, 49.900478),
    (4.060370, 49.902988),
    (4.061550, 49.903519),
    (4.062930, 49.904060),
    (4.064410, 49.904518),
    (4.065390, 49.904732),
    (4.066980, 49.904961),
    (4.067780, 49.905140),
    (4.068570, 49.905491),
    (4.069050, 49.905701),
    (4.070350, 49.906460),
    (4.070600, 49.906601),
    (4.070690, 49.906570),
    (4.070790, 49.906559),
    (4.070890, 49.906582),
    (4.070980, 49.906609),
    (4.071190, 49.906502),
    (4.072450, 49.905621),
    (4.072890, 49.905312),
    (4.073520, 49.905060),
    (4.074240, 49.904911),
    (4.074970, 49.904812),
    (4.082860, 49.905090),
    (4.087080, 49.904499),
    (4.088390, 49.904419),
    (4.089860, 49.904381),
    (4.092300, 49.904541),
    (4.095470, 49.905190),
    (4.096590, 49.905418),
    (4.100890, 49.908192),
    (4.103290, 49.913052),
    (4.105860, 49.918251),
    (4.106550, 49.923000),
    (4.104830, 49.927971),
    (4.104150, 49.931950),
    (4.105860, 49.934929),
    (4.109810, 49.936588),
    (4.112560, 49.936920),
    (4.117880, 49.938251),
    (4.148260, 49.948738),
    (4.149640, 49.949631),
    (4.162780, 49.969139),
    (4.164520, 49.971760),
    (4.164910, 49.972351),
    (4.165800, 49.973339),
    (4.167240, 49.974251),
    (4.168270, 49.974651),
    (4.171550, 49.975559),
    (4.172620, 49.975941),
    (4.173360, 49.976349),
    (4.173910, 49.976688),
    (4.174100, 49.976929),
    (4.177870, 49.975800),
    (4.178340, 49.975651),
    (4.178620, 49.975590),
    (4.179330, 49.975571),
    (4.179650, 49.975540),
    (4.179890, 49.975590),
    (4.180130, 49.975609),
    (4.180510, 49.975571),
    (4.180900, 49.975521),
    (4.181290, 49.975460),
    (4.181880, 49.975498),
    (4.182420, 49.975620),
    (4.182990, 49.975712),
    (4.183370, 49.975719),
    (4.183710, 49.975712),
    (4.184230, 49.975651),
    (4.185360, 49.975521),
    (4.186190, 49.975441),
    (4.187830, 49.975231),
    (4.189180, 49.975040),
    (4.189570, 49.974991),
    (4.190710, 49.974850),
    (4.191450, 49.974739),
    (4.191680, 49.974689),
    (4.191740, 49.974682),
    (4.192250, 49.974720),
    (4.193980, 49.974758),
    (4.194610, 49.974819),
    (4.195240, 49.974930),
    (4.196010, 49.975090),
    (4.198770, 49.975700),
    (4.202800, 49.976631),
    (4.204610, 49.977039),
    (4.205310, 49.977230),
    (4.205990, 49.977520),
    (4.206680, 49.977890),
    (4.212200, 49.980869),
    (4.215440, 49.982651),
    (4.216500, 49.983219),
    (4.217160, 49.983749),
    (4.217560, 49.984138),
    (4.217690, 49.984280),
    (4.217870, 49.984482),
    (4.218070, 49.984879),
    (4.218200, 49.985600),
    (4.218540, 49.986408),
    (4.219080, 49.987141),
    (4.220190, 49.987831),
    (4.221790, 49.988659),
    (4.228820, 49.992199),
    (4.233960, 49.994770),
    (4.235670, 49.995602),
    (4.240140, 49.997871),
    (4.240750, 49.998192),
    (4.241000, 49.998310),
    (4.241370, 49.998440),
    (4.241730, 49.998550),
    (4.243570, 49.999081),
    (4.245940, 49.999790),
    (4.246210, 49.999680),
    (4.247340, 49.999420),
    (4.247580, 49.999378),
    (4.249150, 49.999329),
    (4.249730, 49.999310),
    (4.250340, 49.999401),
    (4.250730, 49.999561),
    (4.251060, 49.999599),
    (4.251770, 49.999619),
    (4.252970, 49.999630),
    (4.254970, 49.999260),
    (4.255600, 49.999149),
    (4.256180, 49.999111),
    (4.256690, 49.999149),
    (4.256990, 49.999321),
    (4.257080, 49.999359),
    (4.257860, 50.000092),
    (4.260200, 50.002411),
    (4.261530, 50.003780),
    (4.261560, 50.003811),
    (4.261860, 50.004120),
    (4.263240, 50.005482),
    (4.263300, 50.005539),
    (4.264680, 50.006519),
    (4.265480, 50.007149),
    (4.266200, 50.007801),
    (4.266710, 50.008579),
    (4.268820, 50.010052),
    (4.268920, 50.010120),
    (4.270130, 50.010910),
    (4.271170, 50.010750),
    (4.271970, 50.010750),
    (4.273030, 50.010960),
    (4.287950, 50.014118),
    (4.295290, 50.015720),
    (4.295830, 50.015831),
    (4.302240, 50.017262),
    (4.303490, 50.017559),
    (4.303960, 50.017639),
    (4.305480, 50.019310),
    (4.306760, 50.020748),
    (4.307400, 50.021290),
    (4.308140, 50.021839),
    (4.309140, 50.022072),
    (4.309750, 50.022202),
    (4.310350, 50.022339),
    (4.310990, 50.022659),
    (4.311990, 50.023708),
    (4.313130, 50.025181),
    (4.313640, 50.025761),
    (4.313910, 50.026001),
    (4.314030, 50.026100),
    (4.314490, 50.026329),
    (4.316360, 50.026798),
    (4.318560, 50.027500),
    (4.319550, 50.027710),
    (4.319610, 50.027721),
    (4.320890, 50.027901),
    (4.322450, 50.027981),
    (4.324050, 50.027962),
    (4.324750, 50.027729),
    (4.325420, 50.027519),
    (4.326710, 50.026550),
    (4.327300, 50.025921),
    (4.327370, 50.025841),
    (4.327950, 50.025791),
    (4.328380, 50.025970),
    (4.328570, 50.026051),
    (4.329900, 50.026539),
    (4.330990, 50.026859),
    (4.331440, 50.026939),
    (4.332390, 50.027161),
    (4.332720, 50.027180),
    (4.334770, 50.027340),
    (4.336990, 50.027481),
    (4.339210, 50.027161),
    (4.340140, 50.027168),
    (4.340950, 50.027210),
    (4.341560, 50.027241),
    (4.342820, 50.027550),
    (4.344410, 50.027988),
    (4.346580, 50.028351),
    (4.352510, 50.028629),
    (4.352690, 50.028641),
    (4.356230, 50.028591),
    (4.358270, 50.028519),
    (4.360110, 50.028221),
    (4.361280, 50.028210),
    (4.363060, 50.028629),
    (4.365290, 50.028900),
    (4.367810, 50.029251),
    (4.368030, 50.029282),
    (4.370650, 50.029499),
    (4.371810, 50.029701),
    (4.372350, 50.029591),
    (4.373150, 50.029530),
    (4.374710, 50.029491),
    (4.375130, 50.029789),
    (4.375530, 50.029919),
    (4.375700, 50.029930),
    (4.375590, 50.030701),
    (4.376790, 50.030861),
    (4.377430, 50.030521),
    (4.378140, 50.030540),
    (4.378850, 50.030609),
    (4.379130, 50.030750),
    (4.379790, 50.031639),
    (4.380530, 50.032398),
    (4.382070, 50.033600),
    (4.382530, 50.034111),
    (4.383410, 50.035561),
    (4.383440, 50.035599),
    (4.383550, 50.035740),
    (4.385020, 50.036079),
    (4.387330, 50.037170),
    (4.389230, 50.038078),
    (4.390820, 50.038441),
    (4.391130, 50.038490),
    (4.396630, 50.039471),
    (4.396690, 50.039478),
    (4.398380, 50.039780),
    (4.398620, 50.040081),
    (4.399100, 50.040371),
    (4.401460, 50.041271),
    (4.402740, 50.041691),
    (4.404880, 50.042210),
    (4.405430, 50.042561),
    (4.405630, 50.042900),
    (4.405870, 50.043331),
    (4.406040, 50.043510),
    (4.407150, 50.044350),
    (4.407720, 50.044670),
    (4.407890, 50.044739),
    (4.408620, 50.045040),
    (4.409170, 50.045158),
    (4.409520, 50.045189),
    (4.410110, 50.045361),
    (4.411240, 50.045731),
    (4.412920, 50.046371),
    (4.413720, 50.046680),
    (4.418210, 50.048119),
    (4.419450, 50.048801),
    (4.421410, 50.049629),
    (4.422380, 50.050179),
    (4.424350, 50.051449),
    (4.425510, 50.051910),
    (4.426710, 50.052231),
    (4.427880, 50.052540),
    (4.429570, 50.053150),
    (4.431280, 50.053612),
    (4.432570, 50.054241),
    (4.433690, 50.054691),
    (4.435320, 50.055359),
    (4.435620, 50.055519),
    (4.435600, 50.055771),
    (4.435070, 50.056252),
    (4.434970, 50.056450),
    (4.435060, 50.056599),
    (4.435510, 50.057011),
    (4.435650, 50.057060),
    (4.435790, 50.057159),
    (4.436210, 50.057480),
    (4.436590, 50.057850),
    (4.436730, 50.057961),
    (4.436700, 50.058361),
    (4.436630, 50.058701),
    (4.436720, 50.058880),
    (4.437140, 50.059231),
    (4.437650, 50.059570),
    (4.438030, 50.059700),
    (4.439820, 50.060230),
    (4.440370, 50.060398),
    (4.443130, 50.061230),
    (4.447210, 50.062489),
    (4.448910, 50.063011),
    (4.449100, 50.063068),
    (4.450840, 50.063881),
    (4.453690, 50.065201),
    (4.456760, 50.066620),
    (4.461400, 50.068562),
    (4.465330, 50.070049),
    (4.466550, 50.070530),
    (4.467920, 50.070969),
    (4.468860, 50.071751),
    (4.469760, 50.072510),
    (4.470700, 50.073109),
    (4.470820, 50.073269),
    (4.470870, 50.073349),
    (4.470990, 50.073540),
    (4.471190, 50.074051),
    (4.471220, 50.074810),
    (4.471230, 50.074879),
    (4.471250, 50.074951),
    (4.471320, 50.075310),
    (4.471360, 50.075729),
    (4.471440, 50.075970),
    (4.471620, 50.076172),
    (4.471770, 50.076271),
    (4.471810, 50.076302),
    (4.471580, 50.076530),
    (4.471580, 50.076630),
    (4.471580, 50.076740),
    (4.471670, 50.076900),
    (4.471970, 50.077011),
    (4.471660, 50.077370),
    (4.471390, 50.077671),
    (4.471250, 50.077881),
    (4.470960, 50.078201),
    (4.470490, 50.078442),
    (4.469200, 50.078869),
    (4.468800, 50.079021),
    (4.468530, 50.079201),
    (4.468590, 50.079681),
    (4.468620, 50.079910),
    (4.468720, 50.081051),
    (4.468780, 50.081612),
    (4.468790, 50.081699),
    (4.468850, 50.082470),
    (4.468850, 50.082661),
    (4.468860, 50.082771),
    (4.468860, 50.082859),
    (4.468880, 50.083000),
    (4.468880, 50.083069),
    (4.469300, 50.083099),
    (4.470440, 50.083382),
    (4.471110, 50.083591),
    (4.472320, 50.084030),
    (4.473600, 50.084419),
    (4.474940, 50.084629),
    (4.475430, 50.084770),
    (4.475640, 50.084919),
    (4.476180, 50.085258),
    (4.477440, 50.085979),
    (4.478490, 50.086571),
    (4.479500, 50.087151),
    (4.479880, 50.087280),
    (4.480820, 50.087620),
    (4.481370, 50.087910),
    (4.482050, 50.088451),
    (4.482370, 50.088692),
    (4.482900, 50.089039),
    (4.483270, 50.089191),
    (4.483510, 50.089340),
    (4.483750, 50.089531),
    (4.484640, 50.090080),
    (4.485040, 50.090462),
    (4.485470, 50.091080),
    (4.485530, 50.091370),
    (4.485650, 50.091721),
    (4.485760, 50.091961),
    (4.484420, 50.092560),
    (4.483960, 50.092838),
    (4.483650, 50.093140),
    (4.483580, 50.093399),
    (4.483710, 50.093788),
    (4.483730, 50.094379),
    (4.483470, 50.094429),
    (4.483340, 50.094582),
    (4.486500, 50.095711),
    (4.489520, 50.097229),
    (4.490030, 50.097809),
    (4.490160, 50.098141),
    (4.490290, 50.098770),
    (4.490920, 50.099209),
    (4.491620, 50.099388),
    (4.492400, 50.099400),
    (4.493410, 50.099602),
    (4.495380, 50.100342),
    (4.497230, 50.100990),
    (4.497720, 50.101231),
    (4.497970, 50.101540),
    (4.498120, 50.101711),
    (4.498300, 50.101910),
    (4.498470, 50.101952),
    (4.498550, 50.101940),
    (4.498630, 50.101940),
    (4.498710, 50.101990),
    (4.498750, 50.102051),
    (4.498710, 50.102169),
    (4.499550, 50.102650),
    (4.499580, 50.102631),
    (4.499680, 50.102619),
    (4.499800, 50.102631),
    (4.499860, 50.102741),
    (4.499870, 50.102779),
    (4.499820, 50.102840),
    (4.499720, 50.102871),
    (4.499590, 50.102859),
    (4.499510, 50.102829),
    (4.498890, 50.102940),
    (4.498470, 50.103191),
    (4.498060, 50.103470),
    (4.497680, 50.103779),
    (4.496910, 50.104530),
    (4.496620, 50.105129),
    (4.496350, 50.105751),
    (4.496250, 50.106461),
    (4.496300, 50.107231),
    (4.496700, 50.111130),
    (4.496780, 50.111961),
    (4.497120, 50.115211),
    (4.497190, 50.116470),
    (4.496990, 50.117191),
    (4.495100, 50.121288),
    (4.494320, 50.123459),
    (4.493730, 50.125092),
    (4.493510, 50.125900),
    (4.493510, 50.126808),
    (4.493680, 50.127609),
    (4.494040, 50.128559),
    (4.494440, 50.129189),
    (4.495350, 50.130192),
    (4.496420, 50.130981),
    (4.498580, 50.132580),
    (4.500640, 50.134689),
    (4.502040, 50.136169),
    (4.502620, 50.136860),
    (4.503070, 50.137531),
    (4.503730, 50.138950),
    (4.503900, 50.139511),
    (4.504170, 50.141010),
    (4.504210, 50.146320),
    (4.504220, 50.147518),
    (4.504190, 50.150139),
    (4.504240, 50.150650),
    (4.504380, 50.151230),
    (4.504530, 50.151669),
    (4.504650, 50.151852),
    (4.504780, 50.152081),
    (4.505300, 50.152790),
    (4.507430, 50.155079),
    (4.507870, 50.155491),
    (4.509910, 50.157631),
    (4.516290, 50.164360),
    (4.516590, 50.164631),
    (4.517350, 50.165310),
    (4.518300, 50.166161),
    (4.522510, 50.169350),
    (4.523000, 50.169868),
    (4.524500, 50.171089),
    (4.525660, 50.172199),
    (4.525990, 50.172451),
    (4.526580, 50.173260),
    (4.527610, 50.175430),
    (4.528490, 50.177410),
    (4.528900, 50.178669),
    (4.528930, 50.178761),
    (4.529060, 50.179180),
    (4.529440, 50.180279),
    (4.529530, 50.180618),
    (4.530210, 50.183731),
    (4.530300, 50.184631),
    (4.530480, 50.186069),
    (4.530560, 50.187279),
    (4.530560, 50.188679),
    (4.530420, 50.191021),
    (4.530160, 50.195850),
    (4.530740, 50.195950),
    (4.531430, 50.196091),
    (4.532100, 50.196251),
    (4.533910, 50.196899),
    (4.534410, 50.197140),
    (4.535060, 50.197430),
    (4.536930, 50.198292),
    (4.538270, 50.198872),
    (4.540600, 50.199909),
    (4.542970, 50.200439),
    (4.543080, 50.200340),
    (4.543470, 50.200050),
    (4.543550, 50.200100),
    (4.544220, 50.200371),
    (4.545320, 50.200489),
    (4.545690, 50.200260),
    (4.546040, 50.200150),
    (4.546810, 50.200081),
    (4.547450, 50.200020),
    (4.547720, 50.200039),
    (4.548080, 50.200298),
    (4.548320, 50.200439),
    (4.549570, 50.201172),
    (4.550390, 50.201649),
    (4.551650, 50.202511),
    (4.552260, 50.203079),
    (4.552650, 50.203850),
    (4.555720, 50.212891),
    (4.555770, 50.213070),
    (4.557430, 50.218269),
    (4.559250, 50.223999),
    (4.559640, 50.224899),
    (4.560050, 50.225342),
    (4.561460, 50.226662),
    (4.561980, 50.227150),
    (4.562510, 50.227619),
    (4.562590, 50.227680),
    (4.562710, 50.227779),
    (4.562900, 50.227982),
    (4.562700, 50.228222),
    (4.562570, 50.228390),
    (4.562640, 50.228531),
    (4.562740, 50.228561),
    (4.562940, 50.228630),
    (4.563650, 50.229721),
    (4.563990, 50.230591),
    (4.564440, 50.231430),
    (4.565530, 50.232201),
    (4.566080, 50.232658),
    (4.566400, 50.233150),
    (4.566740, 50.233829),
    (4.566970, 50.234390),
    (4.567220, 50.234638),
    (4.567360, 50.234772),
    (4.573110, 50.240292),
    (4.573160, 50.240349),
    (4.577600, 50.245140),
    (4.577790, 50.245411),
    (4.577920, 50.245850),
    (4.578090, 50.246059),
    (4.578520, 50.246361),
    (4.578880, 50.246620),
    (4.578920, 50.246651),
    (4.579030, 50.246731),
    (4.579210, 50.246861),
    (4.579380, 50.247051),
    (4.580160, 50.247780),
    (4.580270, 50.247841),
    (4.580410, 50.247898),
    (4.581570, 50.248402),
    (4.583990, 50.249451),
    (4.585590, 50.250019),
    (4.585640, 50.250038),
    (4.586040, 50.250210),
    (4.586160, 50.250259),
    (4.586210, 50.250290),
    (4.586300, 50.250340),
    (4.586380, 50.250381),
    (4.586420, 50.250389),
    (4.586470, 50.250401),
    (4.586560, 50.250439),
    (4.586610, 50.250450),
    (4.586960, 50.250530),
    (4.587680, 50.250591),
    (4.588160, 50.250530),
    (4.589040, 50.250729),
    (4.591290, 50.250858),
    (4.592290, 50.250919),
    (4.593520, 50.251080),
    (4.595130, 50.251339),
    (4.596340, 50.251640),
    (4.597470, 50.251770),
    (4.597660, 50.251770),
    (4.597840, 50.251801),
    (4.598510, 50.251911),
    (4.599170, 50.251999),
    (4.599820, 50.252102),
    (4.600420, 50.251629),
    (4.600760, 50.251781),
    (4.601530, 50.252251),
    (4.602230, 50.252781),
    (4.602640, 50.252529),
    (4.603200, 50.252449),
    (4.603510, 50.252560),
    (4.603790, 50.252731),
    (4.603960, 50.252781),
    (4.604090, 50.252800),
    (4.604430, 50.252800),
    (4.604810, 50.252750),
    (4.604850, 50.252739),
    (4.605060, 50.252998),
    (4.605960, 50.253689),
    (4.606690, 50.254398),
    (4.607160, 50.254951),
    (4.607220, 50.255009),
    (4.607400, 50.255169),
    (4.607530, 50.255268),
    (4.608600, 50.256279),
    (4.611360, 50.258839),
    (4.613750, 50.261101),
    (4.616130, 50.263351),
    (4.617450, 50.264580),
    (4.617910, 50.265011),
    (4.621530, 50.268379),
    (4.622060, 50.268929),
    (4.622380, 50.269241),
    (4.623560, 50.270340),
    (4.625030, 50.271751),
    (4.625790, 50.272469),
    (4.632180, 50.278500),
    (4.633660, 50.279900),
    (4.634610, 50.280788),
    (4.638420, 50.284409),
    (4.641510, 50.287350),
    (4.643670, 50.289391),
    (4.643940, 50.289639),
    (4.644780, 50.290440),
    (4.647800, 50.293301),
    (4.648590, 50.294048),
    (4.649090, 50.294521),
    (4.651460, 50.296768),
    (4.659000, 50.303940),
    (4.659550, 50.304298),
    (4.659920, 50.304459),
    (4.660310, 50.304630),
    (4.660730, 50.304760),
    (4.661960, 50.305099),
    (4.663200, 50.305370),
    (4.664630, 50.305698),
    (4.666710, 50.306149),
    (4.668210, 50.306480),
    (4.668900, 50.306629),
    (4.671050, 50.307060),
    (4.671700, 50.307190),
    (4.674660, 50.307880),
    (4.684200, 50.309891),
    (4.689570, 50.311111),
    (4.693470, 50.311920),
    (4.694890, 50.312241),
    (4.700810, 50.313511),
    (4.706690, 50.314838),
    (4.713050, 50.316181),
    (4.713310, 50.316250),
    (4.713580, 50.316761),
    (4.713740, 50.317329),
    (4.713560, 50.317741),
    (4.713510, 50.318111),
    (4.713610, 50.318649),
    (4.713910, 50.319359),
    (4.714190, 50.320358),
    (4.715040, 50.322701),
    (4.714990, 50.323910),
    (4.717590, 50.325001),
    (4.717770, 50.324921),
    (4.717850, 50.324821),
    (4.718120, 50.324509),
    (4.718450, 50.324520),
    (4.719770, 50.324989),
    (4.720650, 50.325409),
    (4.720700, 50.325451),
    (4.721360, 50.325920),
    (4.722590, 50.327000),
    (4.723550, 50.329041),
    (4.723630, 50.331020),
    (4.723940, 50.331860),
    (4.724420, 50.332710),
    (4.725740, 50.334461),
    (4.727670, 50.336201),
    (4.730730, 50.338959),
    (4.732270, 50.340450),
    (4.734830, 50.343040),
    (4.735180, 50.343479),
    (4.735340, 50.343788),
    (4.735410, 50.344261),
    (4.735390, 50.344372),
    (4.734920, 50.344349),
    (4.734470, 50.344479),
    (4.733720, 50.344952),
    (4.732910, 50.346062),
    (4.732770, 50.346191),
    (4.733700, 50.346630),
    (4.733740, 50.346760),
    (4.734880, 50.346569),
    (4.736010, 50.346432),
    (4.736110, 50.346420),
    (4.736880, 50.346321),
    (4.737300, 50.346279),
    (4.738290, 50.346149),
    (4.739500, 50.345989),
    (4.740260, 50.345940),
    (4.740830, 50.345921),
    (4.744770, 50.346062),
    (4.744920, 50.346069),
    (4.745100, 50.346272),
    (4.746170, 50.347092),
    (4.746770, 50.347519),
    (4.748540, 50.348888),
    (4.749480, 50.349758),
    (4.752270, 50.352509),
    (4.753900, 50.354118),
    (4.755600, 50.355808),
    (4.759850, 50.360039),
    (4.762570, 50.362671),
    (4.764570, 50.364422),
    (4.765580, 50.365391),
    (4.766400, 50.366650),
    (4.767660, 50.368839),
    (4.768670, 50.370480),
    (4.769410, 50.371750),
    (4.769860, 50.372219),
    (4.770530, 50.372532),
    (4.771550, 50.373001),
    (4.773970, 50.374100),
    (4.774030, 50.374130),
    (4.775150, 50.374630),
    (4.775330, 50.374729),
    (4.776860, 50.375439),
    (4.777530, 50.375912),
    (4.777930, 50.376179),
    (4.778130, 50.376400),
    (4.778210, 50.376530),
    (4.778180, 50.376690),
    (4.778440, 50.377060),
    (4.778620, 50.377468),
    (4.779190, 50.378429),
    (4.779270, 50.378609),
    (4.779180, 50.378960),
    (4.779040, 50.379421),
    (4.779070, 50.379608),
    (4.779210, 50.379780),
    (4.779620, 50.379940),
    (4.780100, 50.380081),
    (4.780390, 50.380169),
    (4.781570, 50.380329),
    (4.781800, 50.380421),
    (4.781910, 50.380428),
    (4.782600, 50.380569),
    (4.782890, 50.380650),
    (4.783150, 50.380779),
    (4.783420, 50.381001),
    (4.785600, 50.382809),
    (4.785960, 50.383129),
    (4.786310, 50.383369),
    (4.786620, 50.383530),
    (4.786970, 50.383671),
    (4.787390, 50.383781),
    (4.789910, 50.384331),
    (4.794010, 50.385250),
    (4.796470, 50.385769),
    (4.802470, 50.387051),
    (4.803070, 50.387180),
    (4.803800, 50.387348),
    (4.804120, 50.387459),
    (4.804480, 50.387428),
    (4.804610, 50.387489),
    (4.804670, 50.387520),
    (4.804700, 50.387669),
    (4.805080, 50.387829),
    (4.806710, 50.388599),
    (4.806770, 50.388618),
    (4.810200, 50.390339),
    (4.812270, 50.391331),
    (4.812730, 50.391560),
    (4.814450, 50.392399),
    (4.815130, 50.392738),
    (4.816840, 50.393589),
    (4.817520, 50.393848),
    (4.818640, 50.394150),
    (4.820810, 50.394878),
    (4.823160, 50.395729),
    (4.824710, 50.396290),
    (4.826060, 50.396770),
    (4.828430, 50.397621),
    (4.829650, 50.398071),
    (4.829870, 50.398190),
    (4.833330, 50.400909),
    (4.834690, 50.401981),
    (4.835050, 50.402309),
    (4.836200, 50.403900),
    (4.837020, 50.405041),
    (4.837400, 50.405411),
    (4.838800, 50.406551),
    (4.839240, 50.406960),
    (4.839900, 50.408199),
    (4.840070, 50.408600),
    (4.840800, 50.410141),
    (4.841710, 50.412090),
    (4.842430, 50.413528),
    (4.843000, 50.414169),
    (4.844230, 50.415329),
    (4.844960, 50.415779),
    (4.846510, 50.416248),
    (4.847440, 50.416351),
    (4.848820, 50.416439),
    (4.848990, 50.416470),
    (4.849840, 50.416611),
    (4.853020, 50.417690),
    (4.854840, 50.418308),
    (4.859200, 50.419769),
    (4.862290, 50.420860),
    (4.863330, 50.421211),
    (4.864990, 50.421761),
    (4.866280, 50.422180),
    (4.866110, 50.422798),
    (4.866040, 50.423031),
    (4.865850, 50.423531),
    (4.865380, 50.424351),
    (4.865440, 50.424381),
    (4.866160, 50.424728),
    (4.866860, 50.425152),
    (4.867130, 50.425259),
    (4.867450, 50.425270),
    (4.867960, 50.425362),
    (4.868010, 50.425388),
    (4.866960, 50.426369),
    (4.866110, 50.427429),
    (4.865710, 50.428028),
    (4.865730, 50.428310),
    (4.865980, 50.428761),
    (4.866080, 50.429001),
    (4.866100, 50.429062),
    (4.866180, 50.429119),
    (4.865970, 50.429409),
    (4.865830, 50.429600),
    (4.865330, 50.430260),
    (4.864830, 50.430859),
    (4.864180, 50.431782),
    (4.863410, 50.432671),
    (4.863170, 50.433022),
    (4.863050, 50.433270),
    (4.862960, 50.433521),
    (4.862700, 50.434669),
    (4.862670, 50.434780),
    (4.862560, 50.435139),
    (4.862410, 50.435600),
    (4.862280, 50.435940),
    (4.861470, 50.436951),
    (4.860850, 50.437710),
    (4.860310, 50.438381),
    (4.859920, 50.438839),
    (4.858760, 50.440289),
    (4.858180, 50.440960),
    (4.858110, 50.441040),
    (4.858090, 50.441078),
    (4.857790, 50.441479),
    (4.857240, 50.442139),
    (4.856830, 50.442760),
    (4.856610, 50.443130),
    (4.856490, 50.443470),
    (4.856440, 50.443600),
    (4.856260, 50.444401),
    (4.856040, 50.445438),
    (4.856040, 50.445511),
    (4.856020, 50.445629),
    (4.855990, 50.445961),
    (4.856060, 50.446918),
    (4.856090, 50.447430),
    (4.856200, 50.448040),
    (4.856370, 50.448929),
    (4.856550, 50.449532),
    (4.856610, 50.449879),
    (4.856820, 50.450489),
    (4.856890, 50.450611),
    (4.857150, 50.450951),
    (4.857970, 50.451931),
    (4.858150, 50.452110),
    (4.858320, 50.452259),
    (4.858470, 50.452339),
    (4.859240, 50.452450),
    (4.859930, 50.452549),
    (4.860250, 50.452660),
    (4.860460, 50.452770),
    (4.860650, 50.452950),
    (4.860820, 50.453152),
    (4.861040, 50.453461),
    (4.861600, 50.454391),
    (4.861860, 50.454910),
    (4.862080, 50.455318),
    (4.862160, 50.455448),
    (4.862720, 50.456161),
    (4.864500, 50.458290),
    (4.864600, 50.458389),
    (4.864860, 50.458660),
    (4.865030, 50.458790),
    (4.865450, 50.459011),
    (4.865700, 50.459141),
    (4.866690, 50.459599),
    (4.866920, 50.459740),
    (4.868190, 50.460480),
    (4.868790, 50.460831),
    (4.869320, 50.461182),
    (4.869420, 50.461281),
    (4.869480, 50.461399),
    (4.869510, 50.461498),
    (4.869530, 50.461639),
    (4.869530, 50.461712),
    (4.869560, 50.462151),
    (4.869600, 50.462261),
    (4.869620, 50.462299),
    (4.869690, 50.462341),
    (4.869720, 50.462349),
    (4.869810, 50.462391),
    (4.869890, 50.462410),
    (4.869970, 50.462421),
    (4.870140, 50.462429),
    (4.870210, 50.462448),
    (4.870370, 50.462448),
    (4.870470, 50.462440),
    (4.870510, 50.462429),
    (4.870580, 50.462429),
    (4.870640, 50.462460),
    (4.870850, 50.462429),
    (4.871170, 50.462391),
    (4.871420, 50.462399),
    (4.871590, 50.462410),
    (4.871750, 50.462440),
    (4.872050, 50.462528),
    (4.872270, 50.462631),
    (4.872530, 50.462769),
    (4.873040, 50.462929),
    (4.873250, 50.462978),
    (4.873630, 50.463081),
    (4.873940, 50.463181),
    (4.874190, 50.463310),
    (4.874550, 50.463459),
    (4.874940, 50.463680),
    (4.875350, 50.464001),
    (4.875710, 50.464241),
    (4.877010, 50.464760),
    (4.877490, 50.464939),
    (4.877750, 50.465069),
    (4.877940, 50.465240),
    (4.878030, 50.465370),
    (4.878060, 50.465500),
    (4.878070, 50.465641),
    (4.878030, 50.465778),
    (4.878020, 50.465851),
    (4.878010, 50.465931),
    (4.878030, 50.465988),
    (4.878140, 50.466049),
    (4.881460, 50.466301),
    (4.884810, 50.466541),
    (4.884960, 50.466469),
    (4.885160, 50.466450),
    (4.885360, 50.466499),
    (4.885430, 50.466591),
    (4.886350, 50.466640),
    (4.888070, 50.466751),
    (4.888800, 50.466801),
    (4.889450, 50.466869),
    (4.890240, 50.466961),
    (4.891470, 50.467121),
    (4.893350, 50.467442),
    (4.895050, 50.467819),
    (4.895320, 50.467899),
    (4.895940, 50.468140),
    (4.896040, 50.468182),
    (4.896710, 50.468529),
    (4.897180, 50.468800),
    (4.897970, 50.469360),
    (4.900340, 50.471039),
    (4.900830, 50.471371),
    (4.902530, 50.472561),
    (4.902830, 50.472790),
    (4.903100, 50.472980),
    (4.903250, 50.473091),
    (4.903340, 50.473099),
    (4.903410, 50.473129),
    (4.903450, 50.473160),
    (4.903680, 50.473221),
    (4.903750, 50.473240),
    (4.903800, 50.473270),
    (4.903830, 50.473301),
    (4.903830, 50.473339),
    (4.904120, 50.473640),
    (4.906120, 50.474949),
    (4.906300, 50.475079),
    (4.906840, 50.475441),
    (4.907170, 50.475651),
    (4.907690, 50.476028),
    (4.907840, 50.475990),
    (4.908000, 50.476002),
    (4.908080, 50.476021),
    (4.908130, 50.476051),
    (4.908240, 50.476151),
    (4.908250, 50.476292),
    (4.908210, 50.476360),
    (4.908640, 50.476639),
    (4.909430, 50.477188),
    (4.910410, 50.477810),
    (4.910740, 50.477810),
    (4.910910, 50.477909),
    (4.910970, 50.478050),
    (4.910930, 50.478142),
    (4.910800, 50.478241),
    (4.911110, 50.478779),
    (4.911650, 50.479450),
    (4.911780, 50.479641),
    (4.912280, 50.480240),
    (4.912790, 50.480839),
    (4.913840, 50.481880),
    (4.914830, 50.482719),
    (4.915350, 50.483040),
    (4.920780, 50.486271),
    (4.923060, 50.487629),
    (4.929100, 50.491150),
    (4.929500, 50.491459),
    (4.929700, 50.491611),
    (4.930340, 50.492390),
    (4.931090, 50.493462),
    (4.931850, 50.494431),
    (4.932390, 50.495121),
    (4.932520, 50.495289),
    (4.932630, 50.495361),
    (4.933290, 50.495708),
    (4.933770, 50.495960),
    (4.934270, 50.496231),
    (4.934550, 50.496380),
    (4.935930, 50.497108),
    (4.936220, 50.497231),
    (4.936410, 50.497318),
    (4.938330, 50.498219),
    (4.939470, 50.498638),
    (4.939750, 50.498699),
    (4.940450, 50.498909),
    (4.940980, 50.499180),
    (4.941110, 50.499439),
    (4.940820, 50.500210),
    (4.940840, 50.500462),
    (4.940980, 50.500721),
    (4.941300, 50.501011),
    (4.943990, 50.503239),
    (4.944560, 50.503571),
    (4.945430, 50.503960),
    (4.946800, 50.504471),
    (4.948450, 50.504902),
    (4.950240, 50.505192),
    (4.954170, 50.505421),
    (4.954450, 50.505428),
    (4.955600, 50.505470),
    (4.956050, 50.505489),
    (4.960170, 50.505569),
    (4.960470, 50.505581),
    (4.961170, 50.505619),
    (4.962500, 50.506039),
    (4.965570, 50.507179),
    (4.968170, 50.508049),
    (4.970230, 50.508789),
    (4.971540, 50.509972),
    (4.973330, 50.511459),
    (4.973990, 50.512032),
    (4.974310, 50.512199),
    (4.978170, 50.513741),
    (4.978800, 50.513988),
    (4.979530, 50.514339),
    (4.981160, 50.515148),
    (4.983910, 50.516510),
    (4.983990, 50.516460),
    (4.984060, 50.516441),
    (4.984170, 50.516430),
    (4.984290, 50.516449),
    (4.984380, 50.516479),
    (4.984460, 50.516560),
    (4.984470, 50.516628),
    (4.984450, 50.516701),
    (4.984420, 50.516739),
    (4.986180, 50.517620),
    (4.989530, 50.519279),
    (4.990840, 50.519920),
    (4.992850, 50.520790),
    (4.999800, 50.523811),
    (5.000080, 50.523911),
    (5.002110, 50.524620),
    (5.002630, 50.524799),
    (5.004290, 50.525360),
    (5.004590, 50.525509),
    (5.004830, 50.525661),
    (5.005610, 50.526180),
    (5.006470, 50.526749),
    (5.007230, 50.527271),
    (5.007400, 50.527401),
    (5.007480, 50.527481),
    (5.007570, 50.527580),
    (5.008510, 50.528992),
    (5.008680, 50.529228),
    (5.008910, 50.529629),
    (5.008960, 50.529701),
    (5.009160, 50.529999),
    (5.009460, 50.530460),
    (5.010200, 50.531601),
    (5.010220, 50.531620),
    (5.010620, 50.532261),
    (5.010700, 50.532398),
    (5.011310, 50.533390),
    (5.012290, 50.534809),
    (5.013000, 50.535950),
    (5.014500, 50.538200),
    (5.015580, 50.539841),
    (5.016950, 50.541969),
    (5.017490, 50.542850),
    (5.018010, 50.543690),
    (5.018310, 50.544079),
    (5.018560, 50.544380),
    (5.019120, 50.544720),
    (5.020110, 50.545349),
    (5.020830, 50.545799),
    (5.021230, 50.546082),
    (5.022120, 50.546619),
    (5.022600, 50.546921),
    (5.023540, 50.547531),
    (5.024330, 50.548031),
    (5.025130, 50.548538),
    (5.026240, 50.549271),
    (5.027370, 50.549992),
    (5.029500, 50.551380),
    (5.029760, 50.551540),
    (5.032730, 50.553490),
    (5.034510, 50.554661),
    (5.035080, 50.555038),
    (5.035220, 50.555141),
    (5.035740, 50.555489),
    (5.036270, 50.555851),
    (5.036640, 50.556080),
    (5.037480, 50.556591),
    (5.037850, 50.556820),
    (5.038620, 50.557362),
    (5.039830, 50.558552),
    (5.041740, 50.560570),
    (5.042760, 50.561649),
    (5.046120, 50.565220),
    (5.050530, 50.569870),
    (5.052660, 50.572128),
    (5.052870, 50.572350),
    (5.055420, 50.575069),
    (5.056920, 50.576649),
    (5.062500, 50.582500),
    (5.063340, 50.582439),
    (5.064060, 50.582401),
    (5.064570, 50.582371),
    (5.064810, 50.582371),
    (5.064980, 50.582340),
    (5.065190, 50.582249),
    (5.065530, 50.582111),
    (5.065880, 50.581970),
    (5.066270, 50.581810),
    (5.066500, 50.581749),
    (5.066750, 50.581718),
    (5.067400, 50.581741),
    (5.067810, 50.581760),
    (5.068150, 50.581779),
    (5.068980, 50.581791),
    (5.069530, 50.581779),
    (5.069890, 50.581749),
    (5.070180, 50.581730),
    (5.070580, 50.581741),
    (5.070710, 50.581749),
    (5.070910, 50.581841),
    (5.071000, 50.581970),
    (5.071110, 50.582588),
    (5.071170, 50.582760),
    (5.071310, 50.582890),
    (5.071440, 50.582951),
    (5.071690, 50.583061),
    (5.072150, 50.583229),
    (5.072370, 50.583340),
    (5.072480, 50.583469),
    (5.072620, 50.583561),
    (5.072720, 50.583672),
    (5.072860, 50.583820),
    (5.073110, 50.584030),
    (5.073380, 50.584190),
    (5.073840, 50.584381),
    (5.074120, 50.584549),
    (5.074290, 50.584690),
    (5.074590, 50.584881),
    (5.075100, 50.585178),
    (5.075420, 50.585361),
    (5.075760, 50.585548),
    (5.075940, 50.585629),
    (5.076830, 50.586021),
    (5.078080, 50.586571),
    (5.079290, 50.587109),
    (5.079860, 50.587349),
    (5.080580, 50.587631),
    (5.081270, 50.587898),
    (5.082160, 50.588150),
    (5.083110, 50.588390),
    (5.084410, 50.588669),
    (5.085440, 50.588860),
    (5.086040, 50.589001),
    (5.086810, 50.589191),
    (5.087790, 50.589378),
    (5.089000, 50.589771),
    (5.089740, 50.590000),
    (5.090110, 50.590179),
    (5.090680, 50.590469),
    (5.091330, 50.590752),
    (5.091770, 50.590969),
    (5.092110, 50.591270),
    (5.092570, 50.591530),
    (5.092970, 50.591660),
    (5.093530, 50.591648),
    (5.094270, 50.591648),
    (5.095110, 50.591671),
    (5.095940, 50.591740),
    (5.096180, 50.591770),
    (5.096350, 50.591820),
    (5.097150, 50.592041),
    (5.097810, 50.592201),
    (5.098500, 50.592400),
    (5.099230, 50.592602),
    (5.099940, 50.592651),
    (5.100650, 50.592659),
    (5.101350, 50.592651),
    (5.102080, 50.592560),
    (5.102760, 50.592491),
    (5.103350, 50.592442),
    (5.104000, 50.592400),
    (5.104780, 50.592281),
    (5.105390, 50.592201),
    (5.105930, 50.592010),
    (5.106460, 50.591770),
    (5.107240, 50.591549),
    (5.108010, 50.591419),
    (5.108790, 50.591358),
    (5.109740, 50.591381),
    (5.110280, 50.591370),
    (5.110900, 50.591358),
    (5.112230, 50.591339),
    (5.112930, 50.591400),
    (5.113890, 50.591549),
    (5.114590, 50.591648),
    (5.114910, 50.591591),
    (5.115750, 50.591351),
    (5.116760, 50.591068),
    (5.117380, 50.590881),
    (5.117930, 50.591202),
    (5.118380, 50.591480),
    (5.118810, 50.591640),
    (5.119390, 50.591690),
    (5.120220, 50.591660),
    (5.121100, 50.591610),
    (5.121990, 50.591572),
    (5.122330, 50.591610),
    (5.123380, 50.591831),
    (5.123930, 50.592640),
    (5.124240, 50.592850),
    (5.126180, 50.593910),
    (5.126440, 50.594170),
    (5.127900, 50.595909),
    (5.131090, 50.597488),
    (5.131430, 50.597710),
    (5.131620, 50.597969),
    (5.131420, 50.598259),
    (5.131420, 50.598381),
    (5.131540, 50.598530),
    (5.135540, 50.601601),
    (5.137230, 50.602890),
    (5.137710, 50.603310),
    (5.140380, 50.606461),
    (5.140450, 50.606602),
    (5.140460, 50.606770),
    (5.140260, 50.608372),
    (5.140010, 50.610310),
    (5.139810, 50.612240),
    (5.139670, 50.613201),
    (5.139670, 50.613689),
    (5.139710, 50.614182),
    (5.139810, 50.614609),
    (5.140140, 50.615211),
    (5.140520, 50.615791),
    (5.140840, 50.615860),
    (5.141580, 50.616192),
    (5.142670, 50.616508),
    (5.143600, 50.616680),
    (5.143890, 50.616718),
    (5.144080, 50.616718),
    (5.144310, 50.616718),
    (5.144980, 50.616699),
    (5.145220, 50.616680),
    (5.146530, 50.616772),
    (5.146790, 50.616791),
    (5.147490, 50.616920),
    (5.148940, 50.617180),
    (5.149580, 50.617260),
    (5.150890, 50.617371),
    (5.151800, 50.617409),
    (5.151870, 50.617420),
    (5.152010, 50.617401),
    (5.152190, 50.617359),
    (5.152820, 50.617149),
    (5.152910, 50.617119),
    (5.153150, 50.617119),
    (5.153910, 50.617161),
    (5.154220, 50.617199),
    (5.154540, 50.617249),
    (5.154700, 50.617310),
    (5.154840, 50.617329),
    (5.155010, 50.617359),
    (5.155220, 50.617371),
    (5.155360, 50.617371),
    (5.155580, 50.617352),
    (5.155770, 50.617321),
    (5.155960, 50.617290),
    (5.156110, 50.617298),
    (5.156270, 50.617359),
    (5.156580, 50.617519),
    (5.156320, 50.617722),
    (5.156200, 50.617760),
    (5.156020, 50.617821),
    (5.155510, 50.617931),
    (5.155180, 50.618011),
    (5.154910, 50.618130),
    (5.154840, 50.618229),
    (5.154930, 50.618320),
    (5.155570, 50.618481),
    (5.156330, 50.618721),
    (5.157090, 50.619030),
    (5.157860, 50.619431),
    (5.158170, 50.619820),
    (5.158200, 50.619999),
    (5.158160, 50.620441),
    (5.158020, 50.620911),
    (5.157780, 50.621590),
    (5.157520, 50.622219),
    (5.156940, 50.622959),
    (5.156870, 50.623100),
    (5.156880, 50.623199),
    (5.157020, 50.623199),
    (5.158200, 50.623199),
    (5.158860, 50.623291),
    (5.160070, 50.623669),
    (5.161150, 50.624081),
    (5.161750, 50.624290),
    (5.162410, 50.624420),
    (5.163030, 50.624519),
    (5.163230, 50.624489),
    (5.163350, 50.624481),
    (5.163350, 50.624451),
    (5.163350, 50.624432),
    (5.163380, 50.624409),
    (5.163400, 50.624401),
    (5.163440, 50.624390),
    (5.163480, 50.624390),
    (5.163530, 50.624390),
    (5.163550, 50.624401),
    (5.163580, 50.624420),
    (5.163600, 50.624458),
    (5.163600, 50.624489),
    (5.163580, 50.624512),
    (5.163540, 50.624531),
    (5.163600, 50.624611),
    (5.164110, 50.624748),
    (5.165490, 50.625469),
    (5.166200, 50.625801),
    (5.167550, 50.626450),
    (5.169750, 50.627239),
    (5.170390, 50.627399),
    (5.171860, 50.627831),
    (5.172950, 50.628170),
    (5.173410, 50.628311),
    (5.175910, 50.628990),
    (5.176120, 50.629181),
    (5.177840, 50.633789),
    (5.178230, 50.634281),
    (5.181190, 50.636341),
    (5.182460, 50.638451),
    (5.184490, 50.641121),
    (5.186420, 50.644291),
    (5.187350, 50.645592),
    (5.188370, 50.646790),
    (5.188860, 50.647228),
    (5.189570, 50.647881),
    (5.190670, 50.649441),
    (5.190880, 50.649490),
    (5.193410, 50.649948),
    (5.193970, 50.650051),
    (5.198890, 50.650829),
    (5.200420, 50.651100),
    (5.201730, 50.651501),
    (5.202740, 50.651829),
    (5.203400, 50.652191),
    (5.206130, 50.654350),
    (5.208680, 50.657120),
    (5.211730, 50.660419),
    (5.226750, 50.670261),
    (5.226870, 50.670330),
    (5.231030, 50.672909),
    (5.233430, 50.674332),
    (5.237950, 50.676979),
    (5.238410, 50.677189),
    (5.244430, 50.680000),
    (5.248100, 50.681721),
    (5.248130, 50.681721),
    (5.248270, 50.681660),
    (5.248490, 50.681721),
    (5.248520, 50.681881),
    (5.251630, 50.683559),
    (5.256480, 50.686939),
    (5.256910, 50.687199),
    (5.257320, 50.687420),
    (5.262970, 50.690708),
    (5.265500, 50.692249),
    (5.266960, 50.693111),
    (5.273010, 50.694790),
    (5.273910, 50.695080),
    (5.274450, 50.695309),
    (5.274600, 50.695381),
    (5.275310, 50.695728),
    (5.275420, 50.695789),
    (5.281430, 50.698700),
    (5.281520, 50.698738),
    (5.289040, 50.702381),
    (5.291930, 50.703789),
    (5.292140, 50.703911),
    (5.292250, 50.704041),
    (5.292390, 50.704010),
    (5.292490, 50.704029),
    (5.292570, 50.704090),
    (5.292570, 50.704170),
    (5.292750, 50.704231),
    (5.292820, 50.704250),
    (5.294350, 50.704960),
    (5.294510, 50.705009),
    (5.294720, 50.705051),
    (5.294810, 50.704990),
    (5.294930, 50.704971),
    (5.295070, 50.705009),
    (5.295120, 50.705070),
    (5.295100, 50.705170),
    (5.295010, 50.705219),
    (5.295220, 50.705311),
    (5.295770, 50.705528),
    (5.297260, 50.706070),
    (5.299930, 50.707081),
    (5.301580, 50.707668),
    (5.302840, 50.708221),
    (5.304340, 50.708900),
    (5.304710, 50.709148),
    (5.308070, 50.711479),
    (5.312100, 50.714931),
    (5.316450, 50.718658),
    (5.316750, 50.718910),
    (5.317790, 50.719810),
    (5.317850, 50.719849),
    (5.321440, 50.722919),
    (5.323200, 50.724239),
    (5.324100, 50.724720),
    (5.325300, 50.725201),
    (5.326510, 50.725670),
    (5.330000, 50.726589),
    (5.330400, 50.726688),
    (5.334550, 50.727749),
    (5.335720, 50.728039),
    (5.337340, 50.728439),
    (5.340080, 50.729130),
    (5.341560, 50.729591),
    (5.342660, 50.730000),
    (5.343350, 50.730309),
    (5.344070, 50.730690),
    (5.344300, 50.730808),
    (5.344350, 50.730789),
    (5.344410, 50.730770),
    (5.344480, 50.730782),
    (5.344540, 50.730801),
    (5.344580, 50.730831),
    (5.344590, 50.730862),
    (5.344600, 50.730900),
    (5.344590, 50.730919),
    (5.344560, 50.730961),
    (5.344540, 50.730980),
    (5.345760, 50.731651),
    (5.347450, 50.732571),
    (5.348760, 50.733212),
    (5.349450, 50.733551),
    (5.349520, 50.733570),
    (5.350320, 50.733921),
    (5.352170, 50.734680),
    (5.354010, 50.735458),
    (5.354660, 50.735722),
    (5.355370, 50.735859),
    (5.355950, 50.735920),
    (5.358870, 50.736092),
    (5.359140, 50.736111),
    (5.362270, 50.736279),
    (5.363670, 50.736359),
    (5.364720, 50.736469),
    (5.365220, 50.736599),
    (5.365790, 50.736729),
    (5.366590, 50.737000),
    (5.368300, 50.737942),
    (5.371030, 50.739361),
    (5.374230, 50.741070),
    (5.376120, 50.742001),
    (5.377920, 50.742920),
    (5.382180, 50.744930),
    (5.384110, 50.745731),
    (5.388770, 50.747570),
    (5.389090, 50.747711),
    (5.389630, 50.747940),
    (5.394050, 50.749969),
    (5.395770, 50.750641),
    (5.398630, 50.751652),
    (5.403090, 50.753311),
    (5.404040, 50.753578),
    (5.406910, 50.754398),
    (5.408040, 50.754650),
    (5.408680, 50.754848),
    (5.409770, 50.755341),
    (5.411380, 50.756229),
    (5.416730, 50.759048),
    (5.419830, 50.760639),
    (5.420670, 50.761070),
    (5.421200, 50.761421),
    (5.422010, 50.761871),
    (5.422720, 50.762138),
    (5.423860, 50.762569),
    (5.425990, 50.763340),
    (5.426430, 50.763481),
    (5.426930, 50.763691),
    (5.427820, 50.764149),
    (5.427990, 50.764252),
    (5.428510, 50.764519),
    (5.428700, 50.764702),
    (5.429570, 50.765160),
    (5.429690, 50.765228),
    (5.430810, 50.765831),
    (5.431890, 50.766350),
    (5.432700, 50.766762),
    (5.433000, 50.766899),
    (5.433170, 50.766979),
    (5.433460, 50.767071),
    (5.433970, 50.767208),
    (5.435560, 50.767632),
    (5.436670, 50.768009),
    (5.437660, 50.768349),
    (5.438330, 50.768608),
    (5.438490, 50.768669),
    (5.438770, 50.768768),
    (5.439610, 50.769100),
    (5.440550, 50.769520),
    (5.441410, 50.770020),
    (5.442390, 50.770599),
    (5.443020, 50.770988),
    (5.443350, 50.771198),
    (5.444840, 50.771980),
    (5.445870, 50.772610),
    (5.447290, 50.773529),
    (5.447780, 50.773911),
    (5.448410, 50.774509),
    (5.448630, 50.774738),
    (5.448960, 50.775219),
    (5.449400, 50.775829),
    (5.449810, 50.776340),
    (5.450110, 50.776730),
    (5.450150, 50.776711),
    (5.450220, 50.776711),
    (5.450270, 50.776718),
    (5.450310, 50.776741),
    (5.450330, 50.776772),
    (5.450340, 50.776798),
    (5.450330, 50.776821),
    (5.450310, 50.776852),
    (5.450260, 50.776878),
    (5.450360, 50.776951),
    (5.450530, 50.777039),
    (5.450760, 50.777069),
    (5.450890, 50.777050),
    (5.450940, 50.777142),
    (5.451050, 50.777241),
    (5.451310, 50.777409),
    (5.452080, 50.777740),
    (5.453870, 50.778351),
    (5.455820, 50.778961),
    (5.455880, 50.779091),
    (5.458110, 50.779530),
    (5.458630, 50.779652),
    (5.458730, 50.779671),
    (5.459400, 50.779800),
    (5.460290, 50.779980),
    (5.460280, 50.780201),
    (5.460270, 50.780491),
    (5.460240, 50.780800),
    (5.460260, 50.781151),
    (5.460370, 50.781509),
    (5.460690, 50.782101),
    (5.460780, 50.782200),
    (5.460870, 50.782299),
    (5.461040, 50.782471),
    (5.461460, 50.782711),
    (5.462030, 50.782970),
    (5.462130, 50.783001),
    (5.462280, 50.783039),
    (5.463340, 50.783199),
    (5.464120, 50.783310),
    (5.464760, 50.783340),
    (5.464960, 50.783321),
    (5.465170, 50.783321),
    (5.465730, 50.783321),
    (5.466150, 50.783329),
    (5.466320, 50.783360),
    (5.466470, 50.783360),
    (5.467180, 50.783470),
    (5.468030, 50.783699),
    (5.468870, 50.783958),
    (5.469370, 50.784000),
    (5.469720, 50.783951),
    (5.469940, 50.783859),
    (5.470100, 50.783760),
    (5.470440, 50.783508),
    (5.470630, 50.783218),
    (5.470760, 50.783058),
    (5.472870, 50.782940),
    (5.473680, 50.782959),
    (5.473790, 50.782951),
    (5.473930, 50.782951),
    (5.474590, 50.782990),
    (5.474660, 50.783081),
    (5.474670, 50.783169),
    (5.474550, 50.783508),
    (5.474430, 50.783798),
    (5.474430, 50.783939),
    (5.474490, 50.784050),
    (5.474560, 50.784088),
    (5.474710, 50.784149),
    (5.475000, 50.784210),
    (5.475580, 50.784229),
    (5.475990, 50.784210),
    (5.476440, 50.784161),
    (5.476820, 50.784050),
    (5.477710, 50.783810),
    (5.478430, 50.783699),
    (5.478890, 50.783661),
    (5.479540, 50.783680),
    (5.480060, 50.783718),
    (5.480540, 50.783798),
    (5.481850, 50.784050),
    (5.484940, 50.784618),
    (5.486270, 50.784859),
    (5.492890, 50.786129),
    (5.500330, 50.787479),
    (5.505270, 50.788422),
    (5.506380, 50.788631),
    (5.509460, 50.789211),
    (5.510560, 50.789410),
    (5.512140, 50.789711),
    (5.515800, 50.790371),
    (5.521850, 50.791500),
    (5.522390, 50.791599),
    (5.527870, 50.792660),
    (5.530150, 50.793110),
    (5.531600, 50.793381),
    (5.532440, 50.793530),
    (5.535150, 50.794029),
    (5.536200, 50.794231),
    (5.540630, 50.795059),
    (5.549790, 50.797211),
    (5.559130, 50.799412),
    (5.561260, 50.799919),
    (5.564600, 50.801060),
    (5.572560, 50.803791),
    (5.573930, 50.804272),
    (5.576030, 50.804989),
    (5.581800, 50.806999),
    (5.586580, 50.808681),
    (5.587350, 50.808941),
    (5.589610, 50.809731),
    (5.592580, 50.810768),
    (5.593660, 50.811199),
    (5.594020, 50.811310),
    (5.595070, 50.811729),
    (5.595120, 50.811722),
    (5.595190, 50.811722),
    (5.595240, 50.811741),
    (5.595270, 50.811749),
    (5.595290, 50.811779),
    (5.595310, 50.811810),
    (5.595310, 50.811829),
    (5.595520, 50.811920),
    (5.597460, 50.812698),
    (5.597590, 50.812752),
    (5.597980, 50.812931),
    (5.598810, 50.813271),
    (5.600820, 50.814079),
    (5.603430, 50.815140),
    (5.603600, 50.815208),
    (5.605310, 50.815899),
    (5.607630, 50.816830),
    (5.612710, 50.818878),
    (5.615520, 50.820019),
    (5.617510, 50.820808),
    (5.624470, 50.823620),
    (5.624910, 50.823799),
    (5.625930, 50.824200),
    (5.626070, 50.824261),
    (5.633040, 50.827080),
    (5.635110, 50.827900),
    (5.638210, 50.829140),
    (5.641280, 50.830399),
    (5.641740, 50.830620),
    (5.643520, 50.831341),
    (5.644030, 50.831520),
    (5.644160, 50.831558),
    (5.644660, 50.831760),
    (5.647650, 50.832951),
    (5.649930, 50.833851),
    (5.650020, 50.833881),
    (5.650070, 50.833900),
    (5.650140, 50.833931),
    (5.650220, 50.833969),
    (5.652300, 50.834801),
    (5.652740, 50.834991),
    (5.653410, 50.835258),
    (5.654060, 50.835529),
    (5.657140, 50.836769),
    (5.661090, 50.838360),
    (5.663420, 50.839291),
    (5.666420, 50.840488),
    (5.666580, 50.840549),
    (5.666700, 50.840599),
    (5.666700, 50.840599),
    (5.666830, 50.840649),
    (5.666790, 50.840691),
    (5.666390, 50.841110),
    (5.666140, 50.841282),
    (5.665880, 50.841541),
    (5.666110, 50.841690),
    (5.666330, 50.841831),
    (5.666770, 50.842121),
    (5.667430, 50.842541),
    (5.667560, 50.842590),
    (5.667670, 50.842628),
    (5.667940, 50.842682),
    (5.668040, 50.842720),
    (5.668420, 50.842911),
    (5.669750, 50.843182),
    (5.670560, 50.843330),
    (5.670930, 50.843391),
    (5.671380, 50.843498),
    (5.671760, 50.843590),
    (5.672050, 50.843811),
    (5.672210, 50.844028),
    (5.672240, 50.844109),
    (5.672230, 50.844200),
    (5.672200, 50.844238),
    (5.672390, 50.844311),
    (5.672350, 50.844421),
    (5.672350, 50.844551),
    (5.672380, 50.844669),
    (5.672430, 50.844791),
    (5.672490, 50.844872),
    (5.672690, 50.845161),
    (5.672810, 50.845249),
    (5.672880, 50.845291),
    (5.672990, 50.845322),
    (5.672820, 50.845570),
    (5.672510, 50.845951),
    (5.672360, 50.846081),
    (5.671980, 50.846241),
    (5.672050, 50.846340),
    (5.672320, 50.846539),
    (5.672470, 50.846649),
    (5.672830, 50.846889),
    (5.673290, 50.847069),
    (5.672940, 50.847549),
    (5.672870, 50.847641),
    (5.672870, 50.847851),
    (5.672560, 50.848400),
    (5.672540, 50.848480),
    (5.672560, 50.848598),
    (5.672630, 50.848701),
    (5.672720, 50.848759),
    (5.672820, 50.848808),
    (5.672860, 50.848839),
    (5.672970, 50.848869),
    (5.674750, 50.849049),
    (5.675680, 50.849140),
    (5.676790, 50.849239),
    (5.676780, 50.849319),
    (5.676930, 50.849339),
    (5.677380, 50.849319),
    (5.677420, 50.849251),
    (5.677480, 50.849209),
    (5.677560, 50.849171),
    (5.677640, 50.849140),
    (5.677720, 50.849129),
    (5.677800, 50.849129),
    (5.677850, 50.849140),
    (5.677950, 50.849159),
    (5.677970, 50.849171),
    (5.678020, 50.849190),
    (5.678040, 50.849201),
    (5.678090, 50.849251),
    (5.678120, 50.849281),
    (5.678140, 50.849331),
    (5.678150, 50.849369),
    (5.678150, 50.849419),
    (5.678130, 50.849461),
    (5.678090, 50.849510),
    (5.678030, 50.849548),
    (5.677980, 50.849579),
    (5.677900, 50.849609),
    (5.677840, 50.849621),
    (5.677840, 50.849720),
    (5.677850, 50.849800),
    (5.677890, 50.849892),
    (5.677950, 50.850010),
    (5.677960, 50.850010),
    (5.679030, 50.850739),
    (5.680250, 50.851589),
    (5.681260, 50.852299),
    (5.681360, 50.852371),
    (5.682300, 50.853020),
    (5.683340, 50.853710),
    (5.683390, 50.853748),
    (5.683650, 50.853901),
    (5.683720, 50.853970),
    (5.683800, 50.854061),
    (5.683840, 50.854141),
    (5.683870, 50.854271),
    (5.683890, 50.854370),
    (5.683890, 50.854469),
    (5.684050, 50.854481),
    (5.684190, 50.854500),
    (5.684330, 50.854549),
    (5.684470, 50.854599),
    (5.684850, 50.854759),
    (5.685480, 50.855259),
    (5.686320, 50.855850),
    (5.686510, 50.856041),
    (5.687400, 50.856819),
    (5.687740, 50.857090),
    (5.687920, 50.857220),
    (5.688290, 50.857460),
    (5.689570, 50.858181),
    (5.690190, 50.858509),
    (5.690370, 50.858601),
    (5.690560, 50.858711),
    (5.690680, 50.858780),
    (5.690720, 50.858799),
    (5.690860, 50.858871),
    (5.691020, 50.858940),
    (5.691190, 50.859020),
    (5.691520, 50.859169),
    (5.691810, 50.859291),
    (5.692170, 50.859421),
    (5.692580, 50.859550),
    (5.693130, 50.859692),
    (5.693650, 50.859791),
    (5.694020, 50.859852),
    (5.694330, 50.859879),
    (5.694670, 50.859909),
    (5.695150, 50.859940),
    (5.695930, 50.859970),
    (5.696450, 50.859989),
    (5.698640, 50.860039),
    (5.700240, 50.860111),
    (5.700900, 50.860149),
    (5.701340, 50.860191),
    (5.701770, 50.860222),
    (5.702240, 50.860260),
    (5.702810, 50.860321),
    (5.703080, 50.860340),
    (5.703260, 50.860359),
    (5.703430, 50.860371),
    (5.704550, 50.860470),
    (5.704900, 50.860500),
    (5.705330, 50.860489),
    (5.705690, 50.860470),
    (5.706020, 50.860432),
    (5.706280, 50.860371),
    (5.706580, 50.860310),
    (5.706970, 50.860199),
    (5.707290, 50.860100),
    (5.707650, 50.860001),
    (5.708430, 50.859791),
    (5.709210, 50.859600),
    (5.709420, 50.859539),
    (5.709550, 50.859509),
    (5.709640, 50.859631),
    (5.709690, 50.859711),
    (5.709990, 50.860111),
    (5.710040, 50.860241),
    (5.710080, 50.860359),
    (5.710300, 50.860641),
    (5.710850, 50.861340),
    (5.711070, 50.861629),
    (5.711360, 50.862011),
    (5.711660, 50.862400),
    (5.711740, 50.862499),
    (5.712330, 50.863289),
    (5.712400, 50.863380),
    (5.712350, 50.863411),
    (5.712320, 50.863449),
    (5.712310, 50.863480),
    (5.712310, 50.863499),
    (5.712340, 50.863541),
    (5.712380, 50.863571),
    (5.712430, 50.863579),
    (5.712480, 50.863579),
    (5.712530, 50.863579),
    (5.712730, 50.863838),
    (5.713560, 50.864941),
    (5.713780, 50.865280),
    (5.714060, 50.865639),
    (5.714900, 50.866482),
    (5.715090, 50.866680),
    (5.715960, 50.867599),
    (5.715990, 50.867630),
    (5.716350, 50.867908),
    (5.716750, 50.868141),
    (5.717110, 50.868279),
    (5.717400, 50.868370),
    (5.717990, 50.868610),
    (5.718370, 50.868820),
    (5.718590, 50.868980),
    (5.718680, 50.869041),
    (5.720060, 50.870152),
    (5.721030, 50.871170),
    (5.721420, 50.871552),
    (5.721790, 50.871861),
    (5.721950, 50.872009),
    (5.722400, 50.872349),
    (5.722880, 50.872631),
    (5.723100, 50.872742),
    (5.723780, 50.873089),
    (5.724240, 50.873291),
    (5.724770, 50.873489),
    (5.728780, 50.874630),
    (5.730080, 50.875019),
    (5.730190, 50.875050),
    (5.731080, 50.875309),
    (5.732250, 50.875648),
    (5.732440, 50.875702),
    (5.733930, 50.876080),
    (5.734470, 50.876240),
    (5.734810, 50.876350),
    (5.734960, 50.876411),
    (5.735000, 50.876369),
    (5.735040, 50.876350),
    (5.735120, 50.876339),
    (5.735200, 50.876339),
    (5.735260, 50.876362),
    (5.735290, 50.876381),
    (5.735330, 50.876431),
    (5.735340, 50.876469),
    (5.735330, 50.876511),
    (5.735870, 50.876640),
    (5.736160, 50.876720),
    (5.736660, 50.876881),
    (5.737330, 50.877140),
    (5.737970, 50.877441),
    (5.739170, 50.877991),
    (5.739950, 50.878288),
    (5.740650, 50.878502),
    (5.741140, 50.878609),
    (5.741520, 50.878651),
    (5.741710, 50.878658),
    (5.741960, 50.878658),
    (5.743090, 50.878651),
    (5.743970, 50.878651),
    (5.744050, 50.878651),
    (5.744200, 50.878681),
    (5.744340, 50.878738),
    (5.744740, 50.879009),
    (5.744990, 50.879139),
    (5.745630, 50.879330),
    (5.747410, 50.879990),
    (5.747560, 50.880039),
    (5.747840, 50.880138),
    (5.749530, 50.880730),
    (5.749880, 50.880852),
    (5.750240, 50.880989),
    (5.750340, 50.881062),
    (5.750340, 50.881062),
    (5.750410, 50.881130),
    (5.750990, 50.881729),
    (5.751100, 50.881828),
    (5.751560, 50.882339),
    (5.751610, 50.882408),
    (5.751630, 50.882469),
    (5.751630, 50.882580),
    (5.751630, 50.882641),
    (5.751630, 50.882931),
    (5.751750, 50.882961),
    (5.751900, 50.882992),
    (5.751940, 50.883018),
    (5.752030, 50.883190),
    (5.752510, 50.884159),
    (5.752910, 50.885021),
    (5.752940, 50.885078),
    (5.753140, 50.885071),
    (5.753510, 50.885040),
    (5.753610, 50.885170),
    (5.753730, 50.885330),
    (5.753950, 50.885738),
    (5.753980, 50.886021),
    (5.753930, 50.886341),
    (5.753940, 50.886478),
    (5.754040, 50.886742),
    (5.754140, 50.886921),
    (5.754310, 50.887199),
    (5.754870, 50.887600),
    (5.755060, 50.887718),
    (5.756620, 50.888699),
    (5.756990, 50.888988),
    (5.757320, 50.889290),
    (5.757520, 50.889469),
    (5.757970, 50.889870),
    (5.759160, 50.890911),
    (5.759660, 50.891258),
    (5.760380, 50.891670),
    (5.762130, 50.892479),
    (5.762210, 50.892521),
    (5.762390, 50.892590),
    (5.762880, 50.892780),
    (5.763250, 50.892979),
    (5.763680, 50.893299),
    (5.764010, 50.893551),
    (5.764310, 50.893810),
    (5.764500, 50.894058),
    (5.765220, 50.894901),
    (5.765440, 50.895100),
    (5.765870, 50.895359),
    (5.766100, 50.895500),
    (5.766640, 50.895962),
    (5.767040, 50.896381),
    (5.767400, 50.896690),
    (5.767680, 50.896980),
    (5.768000, 50.897369),
    (5.768210, 50.897709),
    (5.768270, 50.897861),
    (5.769210, 50.899570),
    (5.769350, 50.899792),
    (5.769590, 50.900188),
    (5.769750, 50.900349),
    (5.769870, 50.900429),
    (5.771450, 50.901230),
    (5.771730, 50.901360),
    (5.773130, 50.902039),
    (5.773660, 50.902302),
    (5.774050, 50.902481),
    (5.774390, 50.902618),
    (5.775660, 50.903019),
    (5.776320, 50.903229),
    (5.776740, 50.903370),
    (5.777030, 50.903530),
    (5.777690, 50.903820),
    (5.778650, 50.904140),
    (5.779020, 50.904282),
    (5.779590, 50.904381),
    (5.779730, 50.904411),
    (5.780180, 50.904491),
    (5.780480, 50.904579),
    (5.780790, 50.904720),
    (5.781400, 50.905140),
    (5.781610, 50.905251),
    (5.782170, 50.905479),
    (5.783090, 50.905769),
    (5.783450, 50.905918),
    (5.783670, 50.906052),
    (5.783880, 50.906181),
    (5.784140, 50.906361),
    (5.784580, 50.906639),
    (5.784800, 50.906792),
    (5.785160, 50.907021),
    (5.786190, 50.907681),
    (5.786530, 50.907829),
    (5.786810, 50.907909),
    (5.787200, 50.907982),
    (5.787630, 50.907990),
    (5.789450, 50.907890),
    (5.792080, 50.907742),
    (5.794240, 50.907619),
    (5.795040, 50.907612),
    (5.795800, 50.907619),
    (5.796100, 50.907639),
    (5.796710, 50.907719),
    (5.797150, 50.907810),
    (5.797970, 50.907982),
    (5.800650, 50.908619),
    (5.801250, 50.908749),
    (5.802530, 50.908970),
    (5.803530, 50.909111),
    (5.804040, 50.909149),
    (5.804450, 50.909161),
    (5.805180, 50.909180),
    (5.805740, 50.909248),
    (5.807090, 50.909550),
    (5.808030, 50.909779),
    (5.808610, 50.909859),
    (5.809130, 50.909870),
    (5.809430, 50.909851),
    (5.810010, 50.909771),
    (5.810640, 50.909618),
    (5.810760, 50.909618),
    (5.810860, 50.909641),
    (5.810930, 50.909561),
    (5.811400, 50.909180),
    (5.811490, 50.909081),
    (5.811820, 50.909119),
    (5.812160, 50.909111),
    (5.812670, 50.909039),
    (5.813870, 50.908791),
    (5.814330, 50.908680),
    (5.815690, 50.908310),
    (5.816060, 50.908230),
    (5.816590, 50.908150),
    (5.817270, 50.908112),
    (5.818620, 50.908051),
    (5.819490, 50.908020),
    (5.819930, 50.908058),
    (5.820260, 50.908100),
    (5.822140, 50.908440),
    (5.822580, 50.908562),
    (5.822830, 50.908649),
    (5.823990, 50.909050),
    (5.824860, 50.909321),
    (5.825000, 50.909340),
    (5.825610, 50.909359),
    (5.825760, 50.909328),
    (5.825960, 50.909489),
    (5.826760, 50.909981),
    (5.826990, 50.910118),
    (5.827210, 50.910332),
    (5.827320, 50.910301),
    (5.827470, 50.910332),
    (5.828350, 50.910931),
    (5.828550, 50.911041),
    (5.828910, 50.911171),
    (5.829790, 50.911240),
    (5.830410, 50.911308),
    (5.833060, 50.911659),
    (5.834070, 50.911831),
    (5.834770, 50.911999),
    (5.835690, 50.912189),
    (5.835700, 50.912189),
    (5.836050, 50.912300),
    (5.836250, 50.912392),
    (5.838230, 50.913540),
    (5.838950, 50.913879),
    (5.839610, 50.914150),
    (5.840920, 50.914730),
    (5.841510, 50.914902),
    (5.841370, 50.915131),
    (5.841320, 50.915279),
    (5.841330, 50.915371),
    (5.842360, 50.916672),
    (5.842460, 50.916801),
    (5.843370, 50.917931),
    (5.844580, 50.919250),
    (5.846780, 50.921429),
    (5.848380, 50.922932),
    (5.849410, 50.922459),
    (5.852490, 50.923519),
    (5.852890, 50.923660),
    (5.858860, 50.926071),
    (5.858940, 50.926128),
    (5.859390, 50.926899),
    (5.859550, 50.927029),
    (5.859660, 50.927059),
    (5.860290, 50.927139),
    (5.860700, 50.927238),
    (5.861380, 50.927559),
    (5.861950, 50.927711),
    (5.862150, 50.927830),
    (5.862560, 50.928329),
    (5.862910, 50.928551),
    (5.863050, 50.928730),
    (5.863080, 50.928810),
    (5.863090, 50.929409),
    (5.863160, 50.929520),
    (5.863490, 50.929871),
    (5.863560, 50.930038),
    (5.863560, 50.930382),
    (5.863480, 50.930630),
    (5.863500, 50.930859),
    (5.863580, 50.931042),
    (5.863930, 50.931339),
    (5.864330, 50.931931),
    (5.864470, 50.932098),
    (5.864890, 50.932449),
    (5.865070, 50.932720),
    (5.865360, 50.932861),
    (5.865730, 50.933102),
    (5.866650, 50.933842),
    (5.866980, 50.934059),
    (5.868010, 50.934528),
    (5.868790, 50.934940),
    (5.869210, 50.935101),
    (5.869960, 50.935429),
    (5.870230, 50.935589),
    (5.870750, 50.935982),
    (5.870970, 50.936100),
    (5.871500, 50.936340),
    (5.872260, 50.936588),
    (5.872670, 50.936749),
    (5.872790, 50.936852),
    (5.872880, 50.936958),
    (5.872950, 50.937092),
    (5.873060, 50.937130),
    (5.873410, 50.937439),
    (5.873560, 50.937538),
    (5.873700, 50.937611),
    (5.873760, 50.937630),
    (5.873880, 50.937698),
    (5.874170, 50.937881),
    (5.874300, 50.937950),
    (5.874310, 50.937950),
    (5.874330, 50.937950),
    (5.874330, 50.937950),
    (5.875550, 50.937462),
    (5.875560, 50.937462),
    (5.875570, 50.937462),
    (5.875640, 50.937469),
    (5.876550, 50.937611),
    (5.876810, 50.937672),
    (5.878040, 50.937969),
    (5.878430, 50.938042),
    (5.878570, 50.938049),
    (5.878760, 50.938110),
    (5.878860, 50.938179),
    (5.878880, 50.938210),
    (5.878910, 50.938259),
    (5.878950, 50.938358),
    (5.878960, 50.938560),
    (5.880440, 50.938740),
    (5.881460, 50.938931),
    (5.882140, 50.939098),
    (5.882480, 50.939251),
    (5.882800, 50.939449),
    (5.883030, 50.939640),
    (5.883290, 50.939892),
    (5.884040, 50.940521),
    (5.884070, 50.940552),
    (5.884660, 50.941101),
    (5.886090, 50.942471),
    (5.887160, 50.942341),
    (5.887700, 50.942291),
    (5.887920, 50.942280),
    (5.888080, 50.942280),
    (5.888360, 50.942291),
    (5.889940, 50.942490),
    (5.890530, 50.942619),
    (5.891130, 50.942799),
    (5.891970, 50.943069),
    (5.892520, 50.943291),
    (5.892970, 50.943401),
    (5.893370, 50.943451),
    (5.894070, 50.943501),
    (5.894380, 50.943489),
    (5.894610, 50.943451),
    (5.895750, 50.943321),
    (5.896350, 50.943321),
    (5.896510, 50.943340),
    (5.896720, 50.943359),
    (5.897430, 50.943420),
    (5.898040, 50.943420),
    (5.898490, 50.943378),
    (5.899010, 50.943272),
    (5.899050, 50.943310),
    (5.899120, 50.943378),
    (5.899250, 50.943451),
    (5.900030, 50.943588),
    (5.900250, 50.943649),
    (5.900430, 50.943729),
    (5.900980, 50.944092),
    (5.902580, 50.945271),
    (5.904560, 50.946972),
    (5.905180, 50.947479),
    (5.905420, 50.947689),
    (5.905480, 50.947739),
    (5.905900, 50.948120),
    (5.906960, 50.949020),
    (5.907350, 50.949348),
    (5.907400, 50.949390),
    (5.907810, 50.949730),
    (5.907910, 50.949791),
    (5.908100, 50.949860),
    (5.908170, 50.949909),
    (5.908510, 50.949791),
    (5.909060, 50.949699),
    (5.909530, 50.949638),
    (5.910440, 50.949539),
    (5.910820, 50.949478),
    (5.911770, 50.949360),
    (5.912790, 50.949249),
    (5.913520, 50.949169),
    (5.914020, 50.949089),
    (5.914490, 50.948959),
    (5.914890, 50.948799),
    (5.915070, 50.948719),
    (5.915160, 50.948711),
    (5.915280, 50.948738),
    (5.915780, 50.949341),
    (5.915960, 50.949459),
    (5.916420, 50.949581),
    (5.916500, 50.949612),
    (5.916130, 50.950119),
    (5.916000, 50.950241),
    (5.916490, 50.950562),
    (5.916890, 50.950821),
    (5.917390, 50.951099),
    (5.918270, 50.951561),
    (5.918530, 50.951729),
    (5.918730, 50.951908),
    (5.920360, 50.953331),
    (5.922500, 50.955151),
    (5.922730, 50.955349),
    (5.923100, 50.955631),
    (5.923630, 50.955971),
    (5.924190, 50.956291),
    (5.924540, 50.956470),
    (5.925870, 50.957081),
    (5.925940, 50.957211),
    (5.926060, 50.957180),
    (5.926270, 50.957161),
    (5.926980, 50.957199),
    (5.927300, 50.957191),
    (5.927440, 50.957321),
    (5.929570, 50.958118),
    (5.929710, 50.958172),
    (5.930070, 50.958241),
    (5.930120, 50.958370),
    (5.930190, 50.958420),
    (5.930560, 50.959011),
    (5.931170, 50.959949),
    (5.931400, 50.960171),
    (5.932130, 50.960499),
    (5.932540, 50.960720),
    (5.933060, 50.961048),
    (5.933390, 50.961311),
    (5.933620, 50.961441),
    (5.933830, 50.961529),
    (5.934200, 50.961632),
    (5.934420, 50.961720),
    (5.934630, 50.961842),
    (5.935200, 50.962261),
    (5.937810, 50.964642),
    (5.937940, 50.964809),
    (5.938250, 50.964851),
    (5.938400, 50.964901),
    (5.938740, 50.965080),
    (5.940090, 50.966129),
    (5.940280, 50.966251),
    (5.940620, 50.966400),
    (5.942330, 50.966911),
    (5.943150, 50.967300),
    (5.943690, 50.967541),
    (5.944520, 50.967899),
    (5.945230, 50.968208),
    (5.946030, 50.968578),
    (5.947780, 50.969490),
    (5.948090, 50.969608),
    (5.948510, 50.969818),
    (5.948890, 50.970051),
    (5.949200, 50.970299),
    (5.950060, 50.971062),
    (5.950290, 50.971352),
    (5.950660, 50.971882),
    (5.950950, 50.972221),
    (5.951260, 50.972542),
    (5.951610, 50.972809),
    (5.952010, 50.973000),
    (5.953850, 50.973660),
    (5.954340, 50.973930),
    (5.955320, 50.974739),
    (5.955510, 50.974861),
    (5.956020, 50.975109),
    (5.956210, 50.975231),
    (5.956710, 50.975620),
    (5.958210, 50.976631),
    (5.959020, 50.977070),
    (5.959210, 50.977219),
    (5.959470, 50.977421),
    (5.959710, 50.977581),
    (5.960060, 50.977810),
    (5.960490, 50.978142),
    (5.961210, 50.978100),
    (5.961350, 50.978340),
    (5.961560, 50.978611),
    (5.961940, 50.978939),
    (5.962230, 50.979141),
    (5.963630, 50.979969),
    (5.963870, 50.980091),
    (5.964160, 50.980202),
    (5.964800, 50.980301),
    (5.965150, 50.980400),
    (5.965410, 50.980480),
    (5.965500, 50.980511),
    (5.965510, 50.980511),
    (5.965540, 50.980518),
    (5.965610, 50.980541),
    (5.965740, 50.980591),
    (5.965950, 50.980640),
    (5.966030, 50.980640),
    (5.966130, 50.980629),
    (5.966240, 50.980598),
    (5.966350, 50.980579),
    (5.966470, 50.980549),
    (5.966550, 50.980518),
    (5.966690, 50.980389),
    (5.966770, 50.980289),
    (5.966810, 50.980240),
    (5.966870, 50.980179),
    (5.966970, 50.980129),
    (5.967100, 50.980091),
    (5.967350, 50.980061),
    (5.967810, 50.980030),
    (5.968050, 50.980019),
    (5.968230, 50.980030),
    (5.968370, 50.980080),
    (5.968480, 50.980110),
    (5.968590, 50.980160),
    (5.968720, 50.980209),
    (5.968860, 50.980282),
    (5.969250, 50.980461),
    (5.969530, 50.980591),
    (5.969820, 50.980721),
    (5.970060, 50.980808),
    (5.970360, 50.980919),
    (5.970540, 50.980980),
    (5.970950, 50.981071),
    (5.971140, 50.981110),
    (5.971260, 50.981129),
    (5.971340, 50.981140),
    (5.971410, 50.981140),
    (5.971470, 50.981129),
    (5.971510, 50.981110),
    (5.971550, 50.981091),
    (5.971570, 50.981060),
    (5.971590, 50.981030),
    (5.971590, 50.980942),
    (5.971620, 50.980511),
    (5.971640, 50.980190),
    (5.971650, 50.980129),
    (5.971670, 50.980110),
    (5.971710, 50.980091),
    (5.971810, 50.980068),
    (5.972180, 50.980129),
    (5.972300, 50.980129),
    (5.972300, 50.980209),
    (5.972350, 50.980251),
    (5.972270, 50.981171),
    (5.972330, 50.981258),
    (5.972460, 50.981319),
    (5.972680, 50.981331),
    (5.973040, 50.981319),
    (5.973470, 50.981361),
    (5.973900, 50.981430),
    (5.974240, 50.981529),
    (5.974430, 50.981609),
    (5.974970, 50.982010),
    (5.975080, 50.982101),
    (5.975210, 50.982182),
    (5.975360, 50.982262),
    (5.975620, 50.982380),
    (5.976220, 50.982601),
    (5.976640, 50.982731),
    (5.976740, 50.982761),
    (5.976780, 50.982811),
    (5.976920, 50.982922),
    (5.977330, 50.983200),
    (5.977860, 50.983582),
    (5.978440, 50.983990),
    (5.978580, 50.984089),
    (5.978810, 50.984249),
    (5.978990, 50.984379),
    (5.979150, 50.984489),
    (5.979340, 50.984581),
    (5.979550, 50.984650),
    (5.979800, 50.984718),
    (5.980510, 50.984909),
    (5.981640, 50.985210),
    (5.983110, 50.985649),
    (5.984540, 50.986031),
    (5.985020, 50.986160),
    (5.985210, 50.986198),
    (5.985290, 50.986229),
    (5.985370, 50.986271),
    (5.985460, 50.986309),
    (5.985520, 50.986351),
    (5.985530, 50.986340),
    (5.985570, 50.986340),
    (5.985600, 50.986340),
    (5.985640, 50.986340),
    (5.985670, 50.986351),
    (5.985680, 50.986351),
    (5.985700, 50.986351),
    (5.985720, 50.986370),
    (5.985740, 50.986382),
    (5.985750, 50.986389),
    (5.985760, 50.986401),
    (5.985780, 50.986420),
    (5.985930, 50.986420),
    (5.985980, 50.986431),
    (5.986040, 50.986431),
    (5.986120, 50.986450),
    (5.986220, 50.986469),
    (5.986310, 50.986511),
    (5.986390, 50.986530),
    (5.986690, 50.986622),
    (5.988720, 50.987160),
    (5.988870, 50.987202),
    (5.990210, 50.987549),
    (5.990710, 50.987679),
    (5.993070, 50.988270),
    (5.993440, 50.988350),
    (5.993890, 50.988499),
    (5.993930, 50.988522),
    (5.994270, 50.988701),
    (5.994440, 50.988831),
    (5.994680, 50.988991),
    (5.994870, 50.989090),
    (5.995000, 50.989128),
    (5.995140, 50.989151),
    (5.995240, 50.989151),
    (5.995330, 50.989151),
    (5.995420, 50.989151),
    (5.995510, 50.989140),
    (5.995590, 50.989120),
    (5.995690, 50.989101),
    (5.995780, 50.989071),
    (5.995870, 50.989029),
    (5.995960, 50.988972),
    (5.996090, 50.988892),
    (5.996200, 50.988811),
    (5.996330, 50.988731),
    (5.996460, 50.988659),
    (5.996570, 50.988602),
    (5.996710, 50.988541),
    (5.996870, 50.988510),
    (5.997260, 50.988480),
    (5.997790, 50.988480),
    (5.998180, 50.988468),
    (5.998430, 50.988480),
    (5.998560, 50.988480),
    (5.999060, 50.988499),
    (5.999470, 50.988548),
    (5.999900, 50.988621),
    (6.000060, 50.988659),
    (6.000400, 50.988750),
    (6.000740, 50.988861),
    (6.001110, 50.988979),
    (6.001070, 50.988972),
    (6.001720, 50.989189),
    (6.002780, 50.989552),
    (6.003220, 50.989700),
    (6.003680, 50.989861),
    (6.003910, 50.989971),
    (6.004130, 50.990101),
    (6.004330, 50.990238),
    (6.004480, 50.990379),
    (6.004600, 50.990540),
    (6.004680, 50.990681),
    (6.004750, 50.990810),
    (6.004780, 50.990940),
    (6.004790, 50.991001),
    (6.004840, 50.991211),
    (6.004870, 50.991451),
    (6.004880, 50.991520),
    (6.004880, 50.991539),
    (6.004890, 50.991611),
    (6.004970, 50.991619),
    (6.005050, 50.991661),
    (6.005080, 50.991692),
    (6.005100, 50.991718),
    (6.005100, 50.991760),
    (6.005080, 50.991798),
    (6.005030, 50.991840),
    (6.004970, 50.991859),
    (6.004910, 50.991871),
    (6.004900, 50.992008),
    (6.004900, 50.992180),
    (6.004840, 50.992310),
    (6.004780, 50.992470),
    (6.004780, 50.992489),
    (6.004800, 50.992710),
    (6.004800, 50.993031),
    (6.004820, 50.993698),
    (6.004850, 50.994381),
    (6.004860, 50.995079),
    (6.005790, 50.995209),
    (6.006890, 50.995369),
    (6.007660, 50.995468),
    (6.007800, 50.995491),
    (6.008670, 50.995609),
    (6.009860, 50.995770),
    (6.010370, 50.995850),
    (6.010400, 50.996269),
    (6.010440, 50.996910),
    (6.010450, 50.997372),
    (6.010490, 50.997849),
    (6.010540, 50.998379),
    (6.011580, 50.998501),
    (6.012430, 50.998589),
    (6.013520, 50.998699),
    (6.013550, 50.998699),
    (6.013610, 50.998699),
    (6.014730, 50.998611),
    (6.016590, 50.998459),
    (6.016920, 50.998440),
    (6.018100, 50.998348),
    (6.019460, 50.998241),
    (6.019930, 50.999271),
    (6.020340, 51.000130),
    (6.020680, 51.000839),
    (6.021110, 51.001770),
    (6.021320, 51.002190),
    (6.021520, 51.002628),
    (6.021560, 51.002701),
    (6.021780, 51.002682),
    (6.022470, 51.002621),
    (6.023480, 51.002541),
    (6.023890, 51.002510),
    (6.024010, 51.002499),
    (6.025230, 51.002399),
    (6.025450, 51.002380),
    (6.026220, 51.002319),
    (6.026950, 51.002270),
    (6.027040, 51.002258),
    (6.027260, 51.002239),
    (6.028120, 51.002171),
    (6.029350, 51.002071),
    (6.029890, 51.002029),
    (6.030030, 51.002022),
    (6.030410, 51.001991),
    (6.031180, 51.001930),
    (6.032260, 51.001839),
    (6.033170, 51.001770),
    (6.033700, 51.001801),
    (6.034430, 51.001839),
    (6.034490, 51.001831),
    (6.034870, 51.001751),
    (6.035310, 51.001640),
    (6.035480, 51.001598),
    (6.035630, 51.001560),
    (6.035950, 51.001629),
    (6.036250, 51.001781),
    (6.036680, 51.002010),
    (6.036730, 51.002041),
    (6.036780, 51.002079),
    (6.036810, 51.002121),
    (6.036830, 51.002178),
    (6.036840, 51.002209),
    (6.036830, 51.002239),
    (6.036940, 51.002251),
    (6.037040, 51.002258),
    (6.037130, 51.002289),
    (6.037220, 51.002319),
    (6.037380, 51.002392),
    (6.037550, 51.002468),
    (6.037850, 51.002609),
    (6.038010, 51.002689),
    (6.038200, 51.002781),
    (6.038580, 51.002960),
    (6.038860, 51.003078),
    (6.039150, 51.003189),
    (6.039590, 51.003342),
    (6.039640, 51.003349),
    (6.039920, 51.003448),
    (6.040110, 51.003510),
    (6.040770, 51.003719),
    (6.041390, 51.003929),
    (6.042230, 51.004219),
    (6.042880, 51.004429),
    (6.043140, 51.004501),
    (6.043190, 51.004509),
    (6.043570, 51.004601),
    (6.044670, 51.004829),
    (6.045820, 51.005058),
    (6.046360, 51.005169),
    (6.046550, 51.005211),
    (6.046880, 51.005280),
    (6.047740, 51.005451),
    (6.048510, 51.005611),
    (6.048660, 51.005638),
    (6.048850, 51.005692),
    (6.049040, 51.005749),
    (6.049300, 51.005852),
    (6.049490, 51.005951),
    (6.049670, 51.006039),
    (6.049850, 51.006149),
    (6.049980, 51.006241),
    (6.050280, 51.006481),
    (6.050500, 51.006660),
    (6.051000, 51.007061),
    (6.051180, 51.007191),
    (6.051510, 51.007450),
    (6.051860, 51.007710),
    (6.052400, 51.008091),
    (6.052730, 51.008331),
    (6.052890, 51.008430),
    (6.053040, 51.008499),
    (6.053140, 51.008541),
    (6.053250, 51.008579),
    (6.053380, 51.008621),
    (6.053480, 51.008640),
    (6.053600, 51.008659),
    (6.053770, 51.008678),
    (6.053930, 51.008690),
    (6.054160, 51.008720),
    (6.054430, 51.008751),
    (6.054720, 51.008789),
    (6.055010, 51.008831),
    (6.055300, 51.008888),
    (6.055340, 51.008900),
    (6.055710, 51.008980),
    (6.056220, 51.009079),
    (6.056760, 51.009209),
    (6.057380, 51.009399),
    (6.057750, 51.009510),
    (6.058010, 51.009590),
    (6.058170, 51.009628),
    (6.058930, 51.009861),
    (6.059230, 51.009972),
    (6.059410, 51.010040),
    (6.059630, 51.010132),
    (6.059850, 51.010220),
    (6.060090, 51.010311),
    (6.060320, 51.010399),
    (6.060600, 51.010521),
    (6.060820, 51.010601),
    (6.061040, 51.010670),
    (6.061200, 51.010712),
    (6.061360, 51.010731),
    (6.061510, 51.010738),
    (6.061690, 51.010738),
    (6.061830, 51.010731),
    (6.062080, 51.010719),
    (6.062310, 51.010700),
    (6.062510, 51.010689),
    (6.062670, 51.010689),
    (6.062900, 51.010689),
    (6.063080, 51.010689),
    (6.063250, 51.010689),
    (6.063420, 51.010712),
    (6.063560, 51.010731),
    (6.063700, 51.010769),
    (6.063820, 51.010799),
    (6.063920, 51.010841),
    (6.063980, 51.010860),
    (6.064020, 51.010880),
    (6.064110, 51.010921),
    (6.064320, 51.011028),
    (6.064540, 51.011162),
    (6.065320, 51.011539),
    (6.066150, 51.012020),
    (6.066730, 51.012371),
    (6.067330, 51.012741),
    (6.067340, 51.012749),
    (6.068100, 51.013191),
    (6.068470, 51.013420),
    (6.068840, 51.013649),
    (6.069170, 51.013859),
    (6.069500, 51.014069),
    (6.069840, 51.014271),
    (6.070140, 51.014450),
    (6.070180, 51.014481),
    (6.070290, 51.014549),
    (6.071080, 51.015030),
    (6.071160, 51.015072),
    (6.071280, 51.015148),
    (6.071810, 51.015469),
    (6.072310, 51.015781),
    (6.072530, 51.015911),
    (6.072720, 51.016041),
    (6.072830, 51.016129),
    (6.073020, 51.016270),
    (6.073130, 51.016361),
    (6.073430, 51.016609),
    (6.073740, 51.016861),
    (6.073870, 51.016979),
    (6.074020, 51.017132),
    (6.074160, 51.017269),
    (6.074370, 51.017509),
    (6.074540, 51.017712),
    (6.074630, 51.017811),
    (6.074700, 51.017872),
    (6.074790, 51.017929),
    (6.075060, 51.018059),
    (6.075590, 51.018299),
    (6.076190, 51.018570),
    (6.076410, 51.018681),
    (6.076640, 51.018799),
    (6.077030, 51.019020),
    (6.077360, 51.019199),
    (6.077710, 51.019379),
    (6.078390, 51.019730),
    (6.078700, 51.019890),
    (6.079010, 51.020050),
    (6.079310, 51.020210),
    (6.079580, 51.020359),
    (6.079750, 51.020451),
    (6.079900, 51.020519),
    (6.080070, 51.020592),
    (6.080230, 51.020641),
    (6.080440, 51.020691),
    (6.081010, 51.020851),
    (6.081730, 51.021049),
    (6.082100, 51.021149),
    (6.082420, 51.021240),
    (6.082750, 51.021332),
    (6.083060, 51.021431),
    (6.083290, 51.021500),
    (6.083560, 51.021610),
    (6.083820, 51.021721),
    (6.084060, 51.021851),
    (6.084280, 51.021969),
    (6.084450, 51.022072),
    (6.084610, 51.022171),
    (6.084790, 51.022308),
    (6.084900, 51.022388),
    (6.084940, 51.022419),
    (6.084960, 51.022411),
    (6.084970, 51.022411),
    (6.085010, 51.022400),
    (6.085060, 51.022400),
    (6.085090, 51.022411),
    (6.085110, 51.022419),
    (6.085130, 51.022430),
    (6.085150, 51.022449),
    (6.085150, 51.022469),
    (6.085160, 51.022480),
    (6.085150, 51.022499),
    (6.085140, 51.022518),
    (6.085130, 51.022541),
    (6.085170, 51.022560),
    (6.085200, 51.022591),
    (6.085380, 51.022690),
    (6.085560, 51.022812),
    (6.085740, 51.022911),
    (6.085970, 51.023041),
    (6.086220, 51.023170),
    (6.086700, 51.023418),
    (6.087170, 51.023659),
    (6.087670, 51.023899),
    (6.088560, 51.024349),
    (6.088630, 51.024380),
    (6.088940, 51.024529),
    (6.089600, 51.024811),
    (6.090530, 51.025188),
    (6.091470, 51.025570),
    (6.091680, 51.025650),
    (6.091890, 51.025730),
    (6.092000, 51.025761),
    (6.092220, 51.025810),
    (6.092500, 51.025879),
    (6.093080, 51.026020),
    (6.093450, 51.026100),
    (6.093830, 51.026199),
    (6.094550, 51.026390),
    (6.095000, 51.026520),
    (6.095010, 51.026520),
    (6.095790, 51.026730),
    (6.096640, 51.026970),
    (6.097510, 51.027199),
    (6.098150, 51.027382),
    (6.098770, 51.027550),
    (6.099070, 51.027630),
    (6.099270, 51.027679),
    (6.099610, 51.027760),
    (6.099640, 51.027771),
    (6.100050, 51.027859),
    (6.100270, 51.027908),
    (6.100520, 51.027962),
    (6.100800, 51.028000),
    (6.101050, 51.028019),
    (6.101400, 51.028030),
    (6.102040, 51.028061),
    (6.102300, 51.028080),
    (6.102550, 51.028091),
    (6.102830, 51.028130),
    (6.103030, 51.028172),
    (6.103240, 51.028229),
    (6.103500, 51.028320),
    (6.103900, 51.028481),
    (6.104060, 51.028542),
    (6.104710, 51.028770),
    (6.105260, 51.028980),
    (6.105800, 51.029179),
    (6.106110, 51.029270),
    (6.106480, 51.029362),
    (6.107040, 51.029469),
    (6.107650, 51.029610),
    (6.107940, 51.029671),
    (6.108100, 51.029709),
    (6.108360, 51.029758),
    (6.108480, 51.029781),
    (6.108590, 51.029800),
    (6.108900, 51.029869),
    (6.109110, 51.029911),
    (6.109420, 51.029968),
    (6.109690, 51.030029),
    (6.110440, 51.030270),
    (6.111010, 51.030472),
    (6.111280, 51.030571),
    (6.111990, 51.030869),
    (6.113650, 51.031609),
    (6.115930, 51.032631),
    (6.116910, 51.033070),
    (6.117810, 51.033421),
    (6.118220, 51.033550),
    (6.118680, 51.033699),
    (6.120020, 51.034088),
    (6.120890, 51.034328),
    (6.121260, 51.034439),
    (6.121720, 51.034550),
    (6.122560, 51.034698),
    (6.122920, 51.034760),
    (6.123310, 51.034851),
    (6.123480, 51.034920),
    (6.123860, 51.035042),
    (6.124220, 51.035198),
    (6.124850, 51.035542),
    (6.125600, 51.036030),
    (6.125840, 51.036190),
    (6.126140, 51.036331),
    (6.126840, 51.036560),
    (6.127020, 51.036610),
    (6.127230, 51.036671),
    (6.127800, 51.036751),
    (6.128910, 51.036850),
    (6.129820, 51.036919),
    (6.130710, 51.037022),
    (6.132220, 51.037239),
    (6.133020, 51.037338),
    (6.133640, 51.037380),
    (6.134090, 51.037361),
    (6.134430, 51.037331),
    (6.134630, 51.037300),
    (6.134850, 51.037258),
    (6.135220, 51.037159),
    (6.135990, 51.036980),
    (6.136270, 51.036942),
    (6.136550, 51.036930),
    (6.136830, 51.036949),
    (6.137150, 51.036980),
    (6.137510, 51.037071),
    (6.137880, 51.037189),
    (6.138660, 51.037460),
    (6.139370, 51.037731),
    (6.140020, 51.037971),
    (6.140700, 51.038181),
    (6.140900, 51.038239),
    (6.141060, 51.038280),
    (6.141780, 51.038490),
    (6.142720, 51.038750),
    (6.142900, 51.038811),
    (6.143490, 51.038940),
    (6.143940, 51.039040),
    (6.144160, 51.039089),
    (6.144540, 51.039150),
    (6.144960, 51.039211),
    (6.145250, 51.039249),
    (6.145790, 51.039299),
    (6.146390, 51.039410),
    (6.146560, 51.039440),
    (6.146610, 51.039459),
    (6.146680, 51.039879),
    (6.146680, 51.040291),
    (6.146680, 51.040371),
    (6.146670, 51.040791),
    (6.146730, 51.040939),
    (6.146870, 51.041039),
    (6.147190, 51.041309),
    (6.147360, 51.041382),
    (6.147580, 51.041431),
    (6.147940, 51.041470),
    (6.148140, 51.041561),
    (6.148520, 51.041870),
    (6.148780, 51.042000),
    (6.148780, 51.042099),
    (6.148760, 51.042271),
    (6.148820, 51.042389),
    (6.149050, 51.042648),
    (6.149430, 51.042912),
    (6.149840, 51.043591),
    (6.150040, 51.043850),
    (6.150260, 51.044151),
    (6.150340, 51.044239),
    (6.150760, 51.044708),
    (6.151100, 51.045078),
    (6.151720, 51.045761),
    (6.151800, 51.045849),
    (6.151830, 51.045879),
    (6.151890, 51.045959),
    (6.152000, 51.046131),
    (6.152370, 51.046890),
    (6.152440, 51.047150),
    (6.152660, 51.047932),
    (6.152810, 51.048309),
    (6.152750, 51.048531),
    (6.152710, 51.048740),
    (6.152720, 51.048840),
    (6.152760, 51.048901),
    (6.152850, 51.048901),
    (6.152940, 51.048920),
    (6.152990, 51.048931),
    (6.153050, 51.048969),
    (6.153100, 51.049030),
    (6.153100, 51.049099),
    (6.153070, 51.049160),
    (6.152990, 51.049210),
    (6.153700, 51.049980),
    (6.154080, 51.050388),
    (6.154820, 51.050991),
    (6.154920, 51.051048),
    (6.156130, 51.051781),
    (6.157430, 51.052502),
    (6.158220, 51.053169),
    (6.158790, 51.053501),
    (6.160210, 51.053848),
    (6.160490, 51.053909),
    (6.161980, 51.054161),
    (6.162820, 51.054329),
    (6.163550, 51.054489),
    (6.164160, 51.054619),
    (6.164470, 51.054661),
    (6.164800, 51.054661),
    (6.165450, 51.054600),
    (6.166130, 51.054489),
    (6.166790, 51.054401),
    (6.167550, 51.054359),
    (6.168190, 51.054390),
    (6.168830, 51.054482),
    (6.169520, 51.054508),
    (6.170310, 51.054451),
    (6.171130, 51.054359),
    (6.172380, 51.054298),
    (6.173120, 51.054390),
    (6.173760, 51.054501),
    (6.176260, 51.055061),
    (6.176340, 51.055080),
    (6.176330, 51.055119),
    (6.176420, 51.055260),
    (6.176620, 51.055309),
    (6.176830, 51.055260),
    (6.176900, 51.055191),
    (6.177230, 51.055271),
    (6.177650, 51.055408),
    (6.177990, 51.055561),
    (6.178240, 51.055672),
    (6.178430, 51.055809),
    (6.178710, 51.056110),
    (6.179080, 51.056709),
    (6.179270, 51.057240),
    (6.179290, 51.057381),
    (6.179260, 51.057522),
    (6.179180, 51.057720),
    (6.178890, 51.058201),
    (6.178660, 51.058529),
    (6.178320, 51.059040),
    (6.178290, 51.059299),
    (6.178350, 51.059551),
    (6.178470, 51.059761),
    (6.178620, 51.059978),
    (6.178890, 51.060181),
    (6.179200, 51.060329),
    (6.179880, 51.060520),
    (6.180360, 51.060619),
    (6.180820, 51.060799),
    (6.181480, 51.061111),
    (6.181950, 51.061352),
    (6.182360, 51.061539),
    (6.182460, 51.061600),
    (6.182780, 51.061798),
    (6.183030, 51.062099),
    (6.183350, 51.062489),
    (6.183720, 51.062969),
    (6.183930, 51.063251),
    (6.184000, 51.063309),
    (6.184320, 51.063599),
    (6.184580, 51.063862),
    (6.184860, 51.064129),
    (6.184980, 51.064240),
    (6.185600, 51.064041),
    (6.186310, 51.063889),
    (6.186780, 51.063881),
    (6.187140, 51.063999),
    (6.188280, 51.064430),
    (6.189040, 51.064732),
    (6.189410, 51.064911),
    (6.189880, 51.065189),
    (6.190290, 51.065552),
    (6.190900, 51.065941),
    (6.191470, 51.066380),
    (6.191630, 51.066509),
    (6.192830, 51.067768),
    (6.193130, 51.068020),
    (6.192580, 51.068539),
    (6.193660, 51.069031),
    (6.193780, 51.069099),
    (6.194340, 51.069370),
    (6.194920, 51.069660),
    (6.195450, 51.069920),
    (6.196120, 51.070259),
    (6.196370, 51.070381),
    (6.197170, 51.070770),
    (6.197800, 51.071091),
    (6.198970, 51.071671),
    (6.199570, 51.071980),
    (6.199880, 51.072159),
    (6.200500, 51.072559),
    (6.201120, 51.072979),
    (6.201430, 51.073200),
    (6.201830, 51.073639),
    (6.202400, 51.074291),
    (6.202600, 51.074459),
    (6.202830, 51.074612),
    (6.203310, 51.074799),
    (6.203390, 51.074829),
    (6.204530, 51.075249),
    (6.206080, 51.075748),
    (6.207360, 51.076149),
    (6.207430, 51.076180),
    (6.207620, 51.076260),
    (6.208190, 51.076500),
    (6.209370, 51.076981),
    (6.209470, 51.077011),
    (6.210460, 51.077419),
    (6.211180, 51.077610),
    (6.212200, 51.077850),
    (6.213080, 51.078049),
    (6.214170, 51.078308),
    (6.214360, 51.078350),
    (6.215360, 51.078491),
    (6.216030, 51.078579),
    (6.216560, 51.078640),
    (6.216660, 51.078671),
    (6.216790, 51.078739),
    (6.216910, 51.078800),
    (6.217040, 51.078861),
    (6.217190, 51.078899),
    (6.217330, 51.078911),
    (6.217430, 51.078899),
    (6.217510, 51.079041),
    (6.217580, 51.079102),
    (6.217690, 51.079140),
    (6.217840, 51.079170),
    (6.218000, 51.079189),
    (6.218920, 51.079182),
    (6.220350, 51.079151),
    (6.220550, 51.079151),
    (6.221930, 51.079128),
    (6.223720, 51.079090),
    (6.224500, 51.079029),
    (6.225980, 51.078892),
    (6.226310, 51.078850),
    (6.226680, 51.079079),
    (6.227020, 51.079300),
    (6.227240, 51.079441),
    (6.227420, 51.079552),
    (6.228110, 51.079979),
    (6.228520, 51.080238),
    (6.228880, 51.080448),
    (6.229260, 51.080639),
    (6.230070, 51.080959),
    (6.230380, 51.081051),
    (6.230930, 51.081211),
    (6.231700, 51.081402),
    (6.231800, 51.081429),
    (6.232530, 51.081600),
    (6.233260, 51.081760),
    (6.234130, 51.081940),
    (6.234640, 51.082020),
    (6.236250, 51.082180),
    (6.237020, 51.082279),
    (6.238530, 51.082520),
    (6.239280, 51.082642),
    (6.239430, 51.082661),
    (6.239860, 51.082722),
    (6.240450, 51.082802),
    (6.241040, 51.082890),
    (6.241640, 51.082970),
    (6.241960, 51.083050),
    (6.242300, 51.083111),
    (6.242440, 51.083141),
    (6.242590, 51.083149),
    (6.243330, 51.083130),
    (6.243390, 51.083130),
    (6.244020, 51.083221),
    (6.244400, 51.083302),
    (6.244520, 51.083290),
    (6.244630, 51.083191),
    (6.244900, 51.083069),
    (6.245160, 51.083019),
    (6.245430, 51.083012),
    (6.246600, 51.083191),
    (6.246840, 51.083229),
    (6.247210, 51.083290),
    (6.248400, 51.083481),
    (6.248690, 51.083488),
    (6.249900, 51.083500),
    (6.250130, 51.083519),
    (6.250970, 51.083561),
    (6.251990, 51.083580),
    (6.252420, 51.083618),
    (6.253230, 51.083740),
    (6.253400, 51.083740),
    (6.253640, 51.083691),
    (6.253810, 51.083672),
    (6.253980, 51.083672),
    (6.254670, 51.083740),
    (6.254890, 51.083790),
    (6.255350, 51.083870),
    (6.256040, 51.084000),
    (6.256540, 51.084049),
    (6.257050, 51.084091),
    (6.257110, 51.084339),
    (6.258240, 51.086559),
    (6.258300, 51.086700),
    (6.258310, 51.086819),
    (6.258310, 51.087311),
    (6.258340, 51.087429),
    (6.258360, 51.087471),
    (6.258380, 51.087509),
    (6.258450, 51.087551),
    (6.258600, 51.087589),
    (6.258750, 51.087650),
    (6.258940, 51.087730),
    (6.259710, 51.088409),
    (6.259890, 51.088558),
    (6.260130, 51.088749),
    (6.260340, 51.088909),
    (6.260520, 51.089111),
    (6.260980, 51.089470),
    (6.261190, 51.089642),
    (6.261300, 51.089771),
    (6.261550, 51.090019),
    (6.261670, 51.090149),
    (6.262440, 51.091541),
    (6.262790, 51.092152),
    (6.262850, 51.092258),
    (6.263340, 51.093140),
    (6.264130, 51.094181),
    (6.264460, 51.094589),
    (6.265060, 51.095280),
    (6.265760, 51.096001),
    (6.265910, 51.096218),
    (6.267040, 51.097099),
    (6.268620, 51.097980),
    (6.270300, 51.098911),
    (6.272230, 51.099930),
    (6.272760, 51.100101),
    (6.274360, 51.100449),
    (6.275280, 51.100769),
    (6.275550, 51.100861),
    (6.276170, 51.101051),
    (6.276640, 51.101330),
    (6.276760, 51.101501),
    (6.276840, 51.101730),
    (6.277130, 51.101730),
    (6.277640, 51.101742),
    (6.278170, 51.101761),
    (6.279730, 51.101978),
    (6.280080, 51.102032),
    (6.280420, 51.102112),
    (6.280860, 51.102242),
    (6.281210, 51.102360),
    (6.281550, 51.102520),
    (6.281930, 51.102699),
    (6.283200, 51.103279),
    (6.284240, 51.103748),
    (6.284650, 51.103859),
    (6.285140, 51.104061),
    (6.285400, 51.104179),
    (6.285610, 51.104290),
    (6.286050, 51.104660),
    (6.286350, 51.104950),
    (6.286530, 51.105091),
    (6.286680, 51.105202),
    (6.286890, 51.105289),
    (6.287310, 51.105438),
    (6.287590, 51.105511),
    (6.287950, 51.105610),
    (6.288220, 51.105690),
    (6.288450, 51.105831),
    (6.288880, 51.106152),
    (6.289430, 51.106571),
    (6.289620, 51.106689),
    (6.289780, 51.106750),
    (6.289980, 51.106800),
    (6.290180, 51.106850),
    (6.291890, 51.107059),
    (6.292280, 51.107109),
    (6.293570, 51.107319),
    (6.294620, 51.107521),
    (6.294820, 51.107552),
    (6.295060, 51.107590),
    (6.295490, 51.107670),
    (6.296110, 51.107792),
    (6.296470, 51.107841),
    (6.296830, 51.107868),
    (6.298120, 51.107941),
    (6.299530, 51.108040),
    (6.300310, 51.108139),
    (6.301080, 51.108292),
    (6.303230, 51.108780),
    (6.304290, 51.109058),
    (6.305560, 51.109402),
    (6.306840, 51.109791),
    (6.307790, 51.110199),
    (6.308840, 51.110641),
    (6.308940, 51.110661),
    (6.309740, 51.110889),
    (6.310590, 51.111069),
    (6.310910, 51.111130),
    (6.313200, 51.112720),
    (6.315150, 51.113991),
    (6.317060, 51.115269),
    (6.321160, 51.117939),
    (6.323710, 51.119629),
    (6.324220, 51.119961),
    (6.326390, 51.121971),
    (6.327430, 51.123711),
    (6.328610, 51.125690),
    (6.329740, 51.127720),
    (6.329780, 51.127781),
    (6.331400, 51.127499),
    (6.333760, 51.126999),
    (6.334270, 51.126919),
    (6.334790, 51.126900),
    (6.335680, 51.126862),
    (6.336050, 51.126850),
    (6.336360, 51.126831),
    (6.336510, 51.126850),
    (6.336580, 51.127270),
    (6.336970, 51.128651),
    (6.336990, 51.128780),
    (6.337470, 51.131119),
    (6.337960, 51.133202),
    (6.338140, 51.133919),
    (6.338160, 51.133949),
    (6.338260, 51.134140),
    (6.338290, 51.134190),
    (6.338490, 51.134521),
    (6.338630, 51.134670),
    (6.338800, 51.134861),
    (6.339120, 51.135151),
    (6.339490, 51.135399),
    (6.340010, 51.135719),
    (6.340580, 51.136051),
    (6.341140, 51.136360),
    (6.341580, 51.136650),
    (6.341700, 51.136730),
    (6.343330, 51.137791),
    (6.343950, 51.138248),
    (6.344210, 51.138451),
    (6.344470, 51.138680),
    (6.344750, 51.138920),
    (6.344890, 51.139050),
    (6.345280, 51.139488),
    (6.345490, 51.139790),
    (6.345780, 51.140121),
    (6.345940, 51.140228),
    (6.346180, 51.140308),
    (6.346400, 51.140339),
    (6.346770, 51.140419),
    (6.347080, 51.140560),
    (6.349160, 51.141869),
    (6.349670, 51.142239),
    (6.350130, 51.142590),
    (6.350530, 51.142761),
    (6.350720, 51.142849),
    (6.350810, 51.142860),
    (6.350880, 51.142879),
    (6.350930, 51.142921),
    (6.350950, 51.142941),
    (6.350970, 51.142990),
    (6.350960, 51.143028),
    (6.350920, 51.143089),
    (6.351030, 51.143169),
    (6.352290, 51.144039),
    (6.353340, 51.144810),
    (6.353860, 51.145180),
    (6.354000, 51.145302),
    (6.354120, 51.145432),
    (6.354300, 51.145679),
    (6.354590, 51.146030),
    (6.354840, 51.146351),
    (6.355210, 51.146778),
    (6.355430, 51.146999),
    (6.355690, 51.147202),
    (6.356280, 51.147621),
    (6.356880, 51.147961),
    (6.357680, 51.148399),
    (6.358470, 51.148769),
    (6.360030, 51.149479),
    (6.360370, 51.149590),
    (6.360680, 51.149719),
    (6.360790, 51.149761),
    (6.360910, 51.149750),
    (6.361020, 51.149799),
    (6.361040, 51.149879),
    (6.361120, 51.149929),
    (6.361890, 51.150291),
    (6.362060, 51.150410),
    (6.362690, 51.150711),
    (6.363140, 51.150982),
    (6.363280, 51.151089),
    (6.363400, 51.151169),
    (6.363470, 51.151230),
    (6.363530, 51.151291),
    (6.364310, 51.152061),
    (6.365030, 51.152969),
    (6.365470, 51.153641),
    (6.365990, 51.154461),
    (6.366500, 51.155182),
    (6.368140, 51.157379),
    (6.368250, 51.157520),
    (6.368330, 51.157669),
    (6.368340, 51.157742),
    (6.368310, 51.157841),
    (6.368400, 51.158020),
    (6.368550, 51.158169),
    (6.368730, 51.158279),
    (6.369030, 51.158409),
    (6.369850, 51.158760),
    (6.371150, 51.159538),
    (6.373670, 51.161320),
    (6.374970, 51.162270),
    (6.375580, 51.162720),
    (6.377170, 51.163879),
    (6.378380, 51.164749),
    (6.378590, 51.164890),
    (6.380190, 51.165859),
    (6.380650, 51.166111),
    (6.381930, 51.166630),
    (6.383120, 51.167042),
    (6.384440, 51.167500),
    (6.385380, 51.167850),
    (6.387220, 51.168751),
    (6.389630, 51.170040),
    (6.391190, 51.170872),
    (6.393010, 51.171871),
    (6.394810, 51.172920),
    (6.397420, 51.174252),
    (6.397540, 51.174309),
    (6.397930, 51.174519),
    (6.398630, 51.174889),
    (6.399960, 51.175579),
    (6.400670, 51.175961),
    (6.401170, 51.176250),
    (6.401240, 51.176311),
    (6.401590, 51.176510),
    (6.402730, 51.177200),
    (6.403230, 51.177528),
    (6.403280, 51.177559),
    (6.403690, 51.177860),
    (6.403760, 51.177910),
    (6.404050, 51.178108),
    (6.405440, 51.179062),
    (6.406300, 51.179649),
    (6.406440, 51.179779),
    (6.406560, 51.179871),
    (6.406800, 51.180069),
    (6.407070, 51.180271),
    (6.407270, 51.180401),
    (6.407610, 51.180641),
    (6.407860, 51.180851),
    (6.408560, 51.181389),
    (6.409290, 51.181900),
    (6.409780, 51.182220),
    (6.410380, 51.182659),
    (6.410600, 51.182800),
    (6.410930, 51.183022),
    (6.411270, 51.183250),
    (6.411740, 51.183540),
    (6.411880, 51.183640),
    (6.412060, 51.183750),
    (6.412370, 51.183971),
    (6.412590, 51.184139),
    (6.412770, 51.184280),
    (6.413020, 51.184460),
    (6.413440, 51.184731),
    (6.413910, 51.185001),
    (6.414270, 51.185219),
    (6.415720, 51.186230),
    (6.415930, 51.186378),
    (6.416580, 51.186821),
    (6.417540, 51.187489),
    (6.417950, 51.187771),
    (6.418260, 51.187981),
    (6.419230, 51.188629),
    (6.419700, 51.188950),
    (6.421150, 51.189980),
    (6.422030, 51.190639),
    (6.422180, 51.190750),
    (6.422800, 51.191189),
    (6.423820, 51.191799),
    (6.423970, 51.191891),
    (6.424960, 51.192558),
    (6.425120, 51.192669),
    (6.425170, 51.192760),
    (6.425260, 51.193069),
    (6.425330, 51.193420),
    (6.425350, 51.193501),
    (6.425410, 51.194000),
    (6.425430, 51.194118),
    (6.425570, 51.195129),
    (6.425620, 51.195309),
    (6.425720, 51.195469),
    (6.425850, 51.195591),
    (6.426100, 51.195728),
    (6.426200, 51.195751),
    (6.426350, 51.195770),
    (6.426500, 51.195789),
    (6.426630, 51.195789),
    (6.427080, 51.195709),
    (6.427940, 51.195549),
    (6.428650, 51.195400),
    (6.428910, 51.195381),
    (6.429150, 51.195400),
    (6.429730, 51.195530),
    (6.430970, 51.195839),
    (6.431160, 51.195881),
    (6.431680, 51.196030),
    (6.432580, 51.196320),
    (6.432880, 51.195980),
    (6.433050, 51.195850),
    (6.433330, 51.195629),
    (6.433870, 51.195278),
    (6.434140, 51.195160),
    (6.434460, 51.195068),
    (6.434790, 51.195061),
    (6.435480, 51.195080),
    (6.435840, 51.195080),
    (6.436560, 51.195080),
    (6.436820, 51.195049),
    (6.436970, 51.195122),
    (6.437100, 51.195141),
    (6.437370, 51.195179),
    (6.437690, 51.195179),
    (6.437940, 51.195179),
    (6.437990, 51.195179),
    (6.438040, 51.195190),
    (6.438510, 51.195400),
    (6.438580, 51.195431),
    (6.438650, 51.195461),
    (6.439150, 51.195721),
    (6.439690, 51.196011),
    (6.439810, 51.196098),
    (6.440080, 51.196270),
    (6.440510, 51.196510),
    (6.441130, 51.196781),
    (6.441530, 51.196999),
    (6.441990, 51.197128),
    (6.442520, 51.197479),
    (6.442920, 51.197731),
    (6.443210, 51.197899),
    (6.443530, 51.198090),
    (6.444490, 51.198551),
    (6.445990, 51.199131),
    (6.446900, 51.199478),
    (6.447920, 51.199730),
    (6.448180, 51.199791),
    (6.448850, 51.200310),
    (6.449020, 51.200451),
    (6.449180, 51.200550),
    (6.449350, 51.200668),
    (6.449910, 51.200932),
    (6.450790, 51.201271),
    (6.451240, 51.201462),
    (6.451360, 51.201500),
    (6.452290, 51.201920),
    (6.453120, 51.202251),
    (6.453440, 51.202400),
    (6.453530, 51.202438),
    (6.453730, 51.202560),
    (6.453950, 51.202690),
    (6.454530, 51.203171),
    (6.454640, 51.203251),
    (6.454710, 51.203281),
    (6.454780, 51.203289),
    (6.455190, 51.203190),
    (6.455230, 51.203190),
    (6.455280, 51.203201),
    (6.455360, 51.203220),
    (6.455440, 51.203289),
    (6.455530, 51.203381),
    (6.455640, 51.203499),
    (6.456200, 51.204250),
    (6.459430, 51.206520),
    (6.460260, 51.206970),
    (6.460360, 51.207039),
    (6.460410, 51.207069),
    (6.460480, 51.207111),
    (6.460860, 51.207378),
    (6.460890, 51.207401),
    (6.462590, 51.208530),
    (6.462860, 51.208710),
    (6.463000, 51.208801),
    (6.463800, 51.209332),
    (6.464510, 51.209808),
    (6.464780, 51.209991),
    (6.465610, 51.210541),
    (6.466760, 51.211319),
    (6.466900, 51.211430),
    (6.467670, 51.211929),
    (6.468180, 51.212238),
    (6.469270, 51.212978),
    (6.470670, 51.213951),
    (6.471920, 51.214802),
    (6.472510, 51.215160),
    (6.473070, 51.215500),
    (6.474330, 51.216431),
    (6.474570, 51.216579),
    (6.475070, 51.216911),
    (6.475220, 51.217010),
    (6.475770, 51.217369),
    (6.475930, 51.217468),
    (6.476670, 51.218029),
    (6.476970, 51.218269),
    (6.477290, 51.218578),
    (6.477980, 51.219261),
    (6.478890, 51.220089),
    (6.479120, 51.220310),
    (6.479280, 51.220470),
    (6.481180, 51.222301),
    (6.481410, 51.222519),
    (6.481960, 51.223042),
    (6.482470, 51.223499),
    (6.483160, 51.224209),
    (6.483410, 51.224449),
    (6.484540, 51.225632),
    (6.485840, 51.226849),
    (6.487210, 51.228100),
    (6.488080, 51.229000),
    (6.488620, 51.229519),
    (6.488820, 51.229778),
    (6.488830, 51.229980),
    (6.488760, 51.230228),
    (6.488560, 51.230640),
    (6.488540, 51.230690),
    (6.488350, 51.231049),
    (6.488300, 51.231171),
    (6.487930, 51.231838),
    (6.487080, 51.233509),
    (6.486560, 51.234489),
    (6.486200, 51.235161),
    (6.485840, 51.235790),
    (6.485230, 51.236980),
    (6.485170, 51.237080),
    (6.484770, 51.237808),
    (6.484570, 51.238159),
    (6.484340, 51.238590),
    (6.484230, 51.238800),
    (6.482210, 51.242500),
    (6.481280, 51.244389),
    (6.480810, 51.245338),
    (6.480530, 51.245838),
    (6.480420, 51.246059),
    (6.480060, 51.246719),
    (6.479880, 51.246990),
    (6.479560, 51.247341),
    (6.477230, 51.249260),
    (6.476790, 51.249691),
    (6.476600, 51.249939),
    (6.476560, 51.250118),
    (6.476550, 51.250229),
    (6.476550, 51.250252),
    (6.476580, 51.250469),
    (6.476640, 51.250679),
    (6.476810, 51.250969),
    (6.477230, 51.251801),
    (6.477480, 51.252258),
    (6.477630, 51.252510),
    (6.477790, 51.252701),
    (6.477970, 51.252861),
    (6.478230, 51.252998),
    (6.478830, 51.253250),
    (6.479140, 51.253399),
    (6.479390, 51.253510),
    (6.480150, 51.253860),
    (6.480240, 51.253899),
    (6.480320, 51.253941),
    (6.481060, 51.254280),
    (6.482120, 51.254810),
    (6.482430, 51.254951),
    (6.482670, 51.255070),
    (6.483060, 51.255241),
    (6.484660, 51.255989),
    (6.485630, 51.256439),
    (6.485690, 51.256470),
    (6.486280, 51.256760),
    (6.486360, 51.256790),
    (6.487050, 51.257130),
    (6.487450, 51.257320),
    (6.487970, 51.257580),
    (6.488880, 51.258011),
    (6.489010, 51.258080),
    (6.489610, 51.258438),
    (6.489780, 51.258572),
    (6.490960, 51.259338),
    (6.491430, 51.259640),
    (6.491990, 51.259991),
    (6.492860, 51.260471),
    (6.493320, 51.260670),
    (6.494270, 51.261082),
    (6.495140, 51.261478),
    (6.495510, 51.261681),
    (6.495860, 51.261902),
    (6.496330, 51.262291),
    (6.496750, 51.262798),
    (6.497170, 51.263500),
    (6.497720, 51.264778),
    (6.497790, 51.264938),
    (6.498170, 51.265869),
    (6.498410, 51.266418),
    (6.498750, 51.266891),
    (6.498950, 51.267090),
    (6.498990, 51.267120),
    (6.500030, 51.268181),
    (6.500230, 51.268490),
    (6.500860, 51.269779),
    (6.502950, 51.274021),
    (6.503270, 51.274738),
    (6.503310, 51.274830),
    (6.503750, 51.275841),
    (6.504520, 51.277451),
    (6.504870, 51.278030),
    (6.505200, 51.278519),
    (6.505580, 51.278969),
    (6.506040, 51.279350),
    (6.506790, 51.279869),
    (6.511900, 51.283329),
    (6.513920, 51.285000),
    (6.516000, 51.286709),
    (6.517480, 51.287922),
    (6.518010, 51.288349),
    (6.518670, 51.288891),
    (6.519470, 51.289558),
    (6.521020, 51.290840),
    (6.521980, 51.291641),
    (6.522610, 51.292160),
    (6.522750, 51.292271),
    (6.522820, 51.292339),
    (6.524220, 51.292461),
    (6.524480, 51.292488),
    (6.524930, 51.292599),
    (6.525390, 51.292770),
    (6.525880, 51.292870),
    (6.526380, 51.292820),
    (6.526590, 51.292801),
    (6.526610, 51.292850),
    (6.526990, 51.293880),
    (6.527590, 51.295090),
    (6.528450, 51.296310),
    (6.529650, 51.297668),
    (6.530700, 51.298721),
    (6.530910, 51.298901),
    (6.531000, 51.298981),
    (6.531090, 51.299049),
    (6.531550, 51.299412),
    (6.532840, 51.300381),
    (6.534400, 51.301361),
    (6.536610, 51.302528),
    (6.536830, 51.302639),
    (6.537940, 51.303249),
    (6.538710, 51.303650),
    (6.539150, 51.303871),
    (6.540110, 51.304359),
    (6.541170, 51.304871),
    (6.543160, 51.305840),
    (6.544400, 51.306431),
    (6.546260, 51.307369),
    (6.546780, 51.307590),
    (6.548530, 51.308392),
    (6.551900, 51.309860),
    (6.553790, 51.310692),
    (6.553860, 51.310730),
    (6.554060, 51.310822),
    (6.554140, 51.310848),
    (6.554260, 51.310909),
    (6.554370, 51.310959),
    (6.554660, 51.311100),
    (6.555230, 51.311359),
    (6.555990, 51.311699),
    (6.556740, 51.311970),
    (6.556880, 51.312000),
    (6.557110, 51.312061),
    (6.557270, 51.312092),
    (6.557410, 51.312191),
    (6.557470, 51.312321),
    (6.557470, 51.312462),
    (6.557460, 51.312569),
    (6.557440, 51.312679),
    (6.557380, 51.312939),
    (6.557400, 51.313229),
    (6.557810, 51.313839),
    (6.558110, 51.314281),
    (6.558300, 51.314579),
    (6.558320, 51.314610),
    (6.559460, 51.316311),
    (6.559690, 51.316650),
    (6.560100, 51.317280),
    (6.560460, 51.317810),
    (6.560760, 51.318272),
    (6.561400, 51.319248),
    (6.561460, 51.319321),
    (6.562250, 51.320518),
    (6.562300, 51.320610),
    (6.562470, 51.320862),
    (6.563460, 51.322361),
    (6.563580, 51.322529),
    (6.563870, 51.322639),
    (6.564130, 51.322689),
    (6.564370, 51.322651),
    (6.565080, 51.322762),
    (6.566440, 51.322979),
    (6.568320, 51.323250),
    (6.568580, 51.323200),
    (6.568850, 51.323219),
    (6.569220, 51.323261),
    (6.569390, 51.323299),
    (6.570890, 51.323750),
    (6.571200, 51.323860),
    (6.571260, 51.323879),
    (6.571350, 51.323910),
    (6.571460, 51.323959),
    (6.571570, 51.323990),
    (6.571580, 51.324009),
    (6.571690, 51.324051),
    (6.571910, 51.324139),
    (6.571950, 51.324200),
    (6.572070, 51.324280),
    (6.572790, 51.324551),
    (6.573140, 51.324680),
    (6.574440, 51.325161),
    (6.575610, 51.325588),
    (6.575780, 51.325649),
    (6.575780, 51.325760),
    (6.575710, 51.326309),
    (6.575620, 51.326900),
    (6.575580, 51.327030),
    (6.575180, 51.327549),
    (6.575130, 51.327862),
    (6.574950, 51.328152),
    (6.574830, 51.328289),
    (6.574900, 51.328350),
    (6.575590, 51.329041),
    (6.576380, 51.329491),
    (6.578720, 51.330719),
    (6.578860, 51.330791),
    (6.578940, 51.330841),
    (6.580060, 51.331509),
    (6.580100, 51.331532),
    (6.580340, 51.331619),
    (6.582370, 51.332321),
    (6.582650, 51.332420),
    (6.583520, 51.332691),
    (6.584040, 51.332821),
    (6.584450, 51.332932),
    (6.585960, 51.333260),
    (6.586120, 51.333260),
    (6.586390, 51.333309),
    (6.586690, 51.333370),
    (6.586880, 51.333408),
    (6.587160, 51.333469),
    (6.588060, 51.333672),
    (6.588550, 51.333790),
    (6.589020, 51.333889),
    (6.589450, 51.333931),
    (6.591340, 51.333969),
    (6.591420, 51.333981),
    (6.592550, 51.334061),
    (6.593630, 51.334270),
    (6.593850, 51.334370),
    (6.594710, 51.334560),
    (6.598070, 51.335369),
    (6.598480, 51.335442),
    (6.599410, 51.335651),
    (6.601330, 51.335979),
    (6.601640, 51.336048),
    (6.602770, 51.336418),
    (6.604090, 51.336849),
    (6.604740, 51.337070),
    (6.606700, 51.337730),
    (6.608440, 51.338310),
    (6.613540, 51.340000),
    (6.617310, 51.341240),
    (6.617620, 51.341339),
    (6.620760, 51.342411),
    (6.621230, 51.342579),
    (6.621720, 51.342739),
    (6.621900, 51.342789),
    (6.623800, 51.343529),
    (6.624650, 51.343861),
    (6.625710, 51.344318),
    (6.626290, 51.344582),
    (6.626680, 51.344742),
    (6.627100, 51.344891),
    (6.627520, 51.345020),
    (6.627920, 51.345119),
    (6.628390, 51.345230),
    (6.629730, 51.345490),
    (6.630520, 51.345650),
    (6.631280, 51.345798),
    (6.632440, 51.346031),
    (6.633350, 51.346199),
    (6.633960, 51.346298),
    (6.634550, 51.346378),
    (6.634720, 51.346409),
    (6.635060, 51.346451),
    (6.636250, 51.346569),
    (6.637490, 51.346699),
    (6.638480, 51.346809),
    (6.639080, 51.346859),
    (6.639500, 51.346889),
    (6.639870, 51.346889),
    (6.640360, 51.346901),
    (6.641780, 51.346840),
    (6.642810, 51.346809),
    (6.644000, 51.346802),
    (6.645240, 51.346809),
    (6.647590, 51.346882),
    (6.648060, 51.346901),
    (6.648670, 51.346931),
    (6.650100, 51.346970),
    (6.651950, 51.347031),
    (6.652820, 51.347061),
    (6.653220, 51.347099),
    (6.653410, 51.347118),
    (6.653620, 51.347149),
    (6.654060, 51.347229),
    (6.654370, 51.347290),
    (6.654640, 51.347370),
    (6.655150, 51.347542),
    (6.655590, 51.347710),
    (6.656000, 51.347919),
    (6.656360, 51.348129),
    (6.664210, 51.352791),
    (6.665110, 51.353298),
    (6.665180, 51.353329),
    (6.665830, 51.353710),
    (6.666850, 51.354160),
    (6.667610, 51.354431),
    (6.669930, 51.355122),
    (6.676180, 51.356899),
    (6.677830, 51.357342),
    (6.679310, 51.357681),
    (6.681070, 51.357979),
    (6.681880, 51.358070),
    (6.682730, 51.358158),
    (6.683250, 51.358200),
    (6.684690, 51.358292),
    (6.685720, 51.358318),
    (6.687060, 51.358299),
    (6.687410, 51.358280),
    (6.687760, 51.358269),
    (6.687960, 51.358250),
    (6.688010, 51.358311),
    (6.688310, 51.358620),
    (6.688390, 51.358700),
    (6.688570, 51.358871),
    (6.688790, 51.359089),
    (6.689190, 51.359489),
    (6.689370, 51.359680),
    (6.689880, 51.360081),
    (6.690420, 51.360481),
    (6.690470, 51.360519),
    (6.690560, 51.360580),
    (6.691460, 51.361149),
    (6.692410, 51.361801),
    (6.693340, 51.362400),
    (6.693960, 51.362801),
    (6.694430, 51.363110),
    (6.694880, 51.363430),
    (6.695090, 51.363579),
    (6.695320, 51.363682),
    (6.695580, 51.363770),
    (6.695730, 51.363789),
    (6.695800, 51.363800),
    (6.696080, 51.363800),
    (6.696760, 51.363609),
    (6.697340, 51.363430),
    (6.698020, 51.363232),
    (6.698240, 51.363171),
    (6.698690, 51.363041),
    (6.699230, 51.362888),
    (6.699760, 51.362770),
    (6.700570, 51.362679),
    (6.700790, 51.362671),
    (6.703410, 51.362461),
    (6.706770, 51.362228),
    (6.709060, 51.362091),
    (6.709560, 51.362122),
    (6.709970, 51.362160),
    (6.710380, 51.362240),
    (6.710810, 51.362400),
    (6.711980, 51.362831),
    (6.712310, 51.362961),
    (6.713600, 51.363522),
    (6.715280, 51.364159),
    (6.716770, 51.364769),
    (6.717890, 51.365231),
    (6.718980, 51.365639),
    (6.719200, 51.365730),
    (6.720220, 51.366119),
    (6.720940, 51.366440),
    (6.723390, 51.367249),
    (6.723580, 51.367310),
    (6.723630, 51.367329),
    (6.724940, 51.367741),
    (6.725180, 51.367821),
    (6.726090, 51.368099),
    (6.726800, 51.368271),
    (6.727530, 51.368370),
    (6.727970, 51.368420),
    (6.728190, 51.368450),
    (6.728810, 51.368500),
    (6.728910, 51.368511),
    (6.728980, 51.368519),
    (6.729870, 51.368629),
    (6.730450, 51.368690),
    (6.731750, 51.368912),
    (6.732050, 51.368950),
    (6.732340, 51.368980),
    (6.733520, 51.369091),
    (6.734100, 51.369148),
    (6.735440, 51.369251),
    (6.735980, 51.369289),
    (6.736440, 51.369339),
    (6.737410, 51.369419),
    (6.737600, 51.369431),
    (6.738100, 51.369499),
    (6.739700, 51.369740),
    (6.740450, 51.369839),
    (6.740760, 51.369881),
    (6.741130, 51.369942),
    (6.741290, 51.369961),
    (6.741500, 51.369991),
    (6.741580, 51.369999),
    (6.742380, 51.370079),
    (6.743150, 51.370140),
    (6.744560, 51.370239),
    (6.746420, 51.370380),
    (6.747700, 51.370510),
    (6.749510, 51.370781),
    (6.750010, 51.370861),
    (6.750100, 51.370880),
    (6.750950, 51.371021),
    (6.751800, 51.371189),
    (6.752040, 51.371181),
    (6.752270, 51.371132),
    (6.752650, 51.371490),
    (6.752750, 51.371510),
    (6.753200, 51.371738),
    (6.753520, 51.371929),
    (6.753780, 51.372139),
    (6.754730, 51.372879),
    (6.754910, 51.373032),
    (6.755450, 51.373470),
    (6.756800, 51.374611),
    (6.756870, 51.374680),
    (6.757560, 51.375160),
    (6.758290, 51.375622),
    (6.758890, 51.375900),
    (6.759200, 51.376030),
    (6.759320, 51.376068),
    (6.759980, 51.376289),
    (6.760290, 51.376381),
    (6.760890, 51.376560),
    (6.760980, 51.376591),
    (6.761530, 51.376820),
    (6.761580, 51.376839),
    (6.761850, 51.376942),
    (6.762050, 51.377048),
    (6.762350, 51.377171),
    (6.765670, 51.378922),
    (6.769670, 51.380989),
    (6.770860, 51.381580),
    (6.771070, 51.381680),
    (6.771160, 51.381729),
    (6.771170, 51.381741),
    (6.771920, 51.382130),
    (6.772790, 51.382481),
    (6.773410, 51.382740),
    (6.773900, 51.383011),
    (6.774310, 51.383209),
    (6.774490, 51.383289),
    (6.774580, 51.383339),
    (6.775290, 51.383690),
    (6.775780, 51.383949),
    (6.776100, 51.384121),
    (6.776300, 51.384239),
    (6.777120, 51.384800),
    (6.777390, 51.384960),
    (6.780710, 51.386730),
    (6.782120, 51.387459),
    (6.782950, 51.387779),
    (6.783430, 51.387970),
    (6.783580, 51.388020),
    (6.783760, 51.388081),
    (6.783850, 51.388222),
    (6.783890, 51.388290),
    (6.784020, 51.388481),
    (6.784180, 51.388699),
    (6.784480, 51.389111),
    (6.784840, 51.389519),
    (6.785240, 51.389912),
    (6.785850, 51.390610),
    (6.786050, 51.390949),
    (6.786250, 51.391121),
    (6.786490, 51.391140),
    (6.786600, 51.391140),
    (6.786780, 51.391140),
    (6.787050, 51.391140),
    (6.787700, 51.391140),
    (6.788180, 51.391209),
    (6.788970, 51.391411),
    (6.790210, 51.391891),
    (6.791520, 51.392330),
    (6.792030, 51.392509),
    (6.792270, 51.392601),
    (6.793060, 51.392879),
    (6.793340, 51.392990),
    (6.794180, 51.393291),
    (6.795490, 51.393799),
    (6.795700, 51.393879),
    (6.796840, 51.394279),
    (6.797160, 51.394409),
    (6.797290, 51.394451),
    (6.797820, 51.394630),
    (6.798740, 51.394970),
    (6.798960, 51.395061),
    (6.799110, 51.395130),
    (6.799240, 51.395210),
    (6.799510, 51.395229),
    (6.799820, 51.395370),
    (6.799930, 51.395451),
    (6.799990, 51.395538),
    (6.800110, 51.395519),
    (6.800510, 51.395660),
    (6.800780, 51.395771),
    (6.801040, 51.395870),
    (6.801210, 51.395920),
    (6.801330, 51.395950),
    (6.801410, 51.395969),
    (6.801540, 51.395988),
    (6.801650, 51.395988),
    (6.801690, 51.396099),
    (6.801660, 51.396172),
    (6.801650, 51.396198),
    (6.801660, 51.396599),
    (6.801690, 51.396629),
    (6.801740, 51.396660),
    (6.801810, 51.396671),
    (6.801860, 51.396660),
    (6.801970, 51.396641),
    (6.802020, 51.396641),
    (6.802070, 51.396648),
    (6.802140, 51.396660),
    (6.802200, 51.396660),
    (6.802250, 51.396648),
    (6.802300, 51.396690),
    (6.802350, 51.396751),
    (6.802370, 51.396801),
    (6.802380, 51.396870),
    (6.802370, 51.396931),
    (6.802360, 51.396980),
    (6.802360, 51.397011),
    (6.802360, 51.397049),
    (6.802390, 51.397060),
    (6.802430, 51.397079),
    (6.802500, 51.397091),
    (6.802550, 51.397129),
    (6.802550, 51.397160),
    (6.802550, 51.397209),
    (6.802600, 51.397228),
    (6.802940, 51.397282),
    (6.803010, 51.397289),
    (6.803200, 51.397308),
    (6.803470, 51.397339),
    (6.803530, 51.397339),
    (6.803590, 51.397350),
    (6.803650, 51.397362),
    (6.803730, 51.397381),
    (6.803800, 51.397388),
    (6.803870, 51.397400),
    (6.803920, 51.397411),
    (6.803930, 51.397411),
    (6.804120, 51.397419),
    (6.804260, 51.397449),
    (6.804320, 51.397461),
    (6.804450, 51.397469),
    (6.804530, 51.397480),
    (6.804610, 51.397499),
    (6.804630, 51.397499),
    (6.804800, 51.397549),
    (6.804860, 51.397572),
    (6.804980, 51.397598),
    (6.805450, 51.397751),
    (6.805600, 51.397789),
    (6.805800, 51.397579),
    (6.805960, 51.397598),
    (6.806460, 51.397781),
    (6.806800, 51.397911),
    (6.807900, 51.398312),
    (6.808490, 51.398521),
    (6.808710, 51.398590),
    (6.809430, 51.398830),
    (6.810120, 51.399071),
    (6.811280, 51.399460),
    (6.811660, 51.399570),
    (6.811950, 51.399651),
    (6.812160, 51.399712),
    (6.812370, 51.399792),
    (6.812570, 51.400009),
    (6.812870, 51.400391),
    (6.813730, 51.401588),
    (6.814080, 51.402050),
    (6.814540, 51.402679),
    (6.814850, 51.402969),
    (6.815680, 51.403690),
    (6.816290, 51.404381),
    (6.816460, 51.404530),
    (6.817250, 51.405079),
    (6.817910, 51.405472),
    (6.818560, 51.405861),
    (6.818710, 51.405949),
    (6.818890, 51.406059),
    (6.818940, 51.406090),
    (6.819170, 51.406231),
    (6.819270, 51.406300),
    (6.819720, 51.406551),
    (6.820450, 51.407139),
    (6.820460, 51.407162),
    (6.820990, 51.408199),
    (6.821430, 51.409119),
    (6.821490, 51.409248),
    (6.821710, 51.409691),
    (6.821820, 51.409901),
    (6.822340, 51.410950),
    (6.822660, 51.411369),
    (6.822850, 51.411598),
    (6.822920, 51.411709),
    (6.822990, 51.411789),
    (6.823190, 51.412140),
    (6.823470, 51.412998),
    (6.823520, 51.413681),
    (6.823570, 51.414280),
    (6.823580, 51.414532),
    (6.823550, 51.414841),
    (6.823740, 51.414909),
    (6.824850, 51.415279),
    (6.825560, 51.415520),
    (6.826170, 51.415730),
    (6.826930, 51.416088),
    (6.827020, 51.416130),
    (6.827250, 51.416279),
    (6.827620, 51.416271),
    (6.829410, 51.416489),
    (6.829700, 51.416489),
    (6.830100, 51.416451),
    (6.830190, 51.416481),
    (6.830270, 51.416519),
    (6.830550, 51.416710),
    (6.830780, 51.416870),
    (6.832240, 51.417809),
    (6.832530, 51.417931),
    (6.832990, 51.418129),
    (6.833330, 51.418289),
    (6.833590, 51.418430),
    (6.833640, 51.418468),
    (6.833810, 51.418549),
    (6.834160, 51.418770),
    (6.834640, 51.419170),
    (6.834820, 51.419331),
    (6.835230, 51.419670),
    (6.835830, 51.420139),
    (6.836010, 51.420269),
    (6.836650, 51.420712),
    (6.837070, 51.420979),
    (6.837530, 51.421261),
    (6.838160, 51.421570),
    (6.838770, 51.421841),
    (6.839230, 51.422050),
    (6.839610, 51.422230),
    (6.840000, 51.422489),
    (6.840150, 51.422661),
    (6.841350, 51.422710),
    (6.841590, 51.422760),
    (6.841830, 51.422840),
    (6.842100, 51.422939),
    (6.842490, 51.423130),
    (6.842790, 51.423328),
    (6.843160, 51.423691),
    (6.843450, 51.423981),
    (6.843560, 51.424091),
    (6.843710, 51.424240),
    (6.843950, 51.424480),
    (6.844180, 51.424721),
    (6.844250, 51.424831),
    (6.844280, 51.424911),
    (6.844290, 51.425079),
    (6.844290, 51.425110),
    (6.844290, 51.425171),
    (6.844300, 51.425220),
    (6.844300, 51.425251),
    (6.844300, 51.425301),
    (6.844330, 51.425400),
    (6.844420, 51.425491),
    (6.844880, 51.425930),
    (6.844920, 51.426022),
    (6.844920, 51.426109),
    (6.844980, 51.426121),
    (6.845030, 51.426140),
    (6.845060, 51.426170),
    (6.845080, 51.426201),
    (6.845070, 51.426262),
    (6.845850, 51.426479),
    (6.846630, 51.426731),
    (6.847150, 51.426960),
    (6.847620, 51.427158),
    (6.847840, 51.427250),
    (6.848390, 51.427559),
    (6.848670, 51.427780),
    (6.848810, 51.427929),
    (6.848960, 51.428169),
    (6.849070, 51.428299),
    (6.849590, 51.428871),
    (6.849890, 51.429039),
    (6.850050, 51.429050),
    (6.850500, 51.428940),
    (6.850820, 51.428860),
    (6.851970, 51.428711),
    (6.853020, 51.428730),
    (6.853520, 51.428719),
    (6.854420, 51.428810),
    (6.855220, 51.428970),
    (6.855630, 51.429062),
    (6.856080, 51.429161),
    (6.856650, 51.429321),
    (6.857290, 51.429489),
    (6.857970, 51.429668),
    (6.858360, 51.429749),
    (6.858640, 51.429790),
    (6.858850, 51.429920),
    (6.859630, 51.429939),
    (6.859910, 51.429970),
    (6.860180, 51.429989),
    (6.861050, 51.430069),
    (6.862750, 51.430271),
    (6.863410, 51.430359),
    (6.864890, 51.430611),
    (6.865930, 51.430809),
    (6.866540, 51.431000),
    (6.867070, 51.431190),
    (6.867590, 51.431400),
    (6.868310, 51.431660),
    (6.869000, 51.431881),
    (6.869530, 51.431980),
    (6.870220, 51.432030),
    (6.870260, 51.432041),
    (6.870940, 51.432060),
    (6.871690, 51.432018),
    (6.873570, 51.431839),
    (6.874450, 51.431770),
    (6.876040, 51.431629),
    (6.876640, 51.431580),
    (6.878010, 51.431438),
    (6.878030, 51.431580),
    (6.878040, 51.431721),
    (6.878010, 51.432060),
    (6.877910, 51.432362),
    (6.877760, 51.432621),
    (6.877380, 51.432941),
    (6.877310, 51.433121),
    (6.877350, 51.433289),
    (6.877510, 51.433430),
    (6.877600, 51.433479),
    (6.877740, 51.433529),
    (6.878400, 51.433762),
    (6.879260, 51.434120),
    (6.879600, 51.434319),
    (6.880080, 51.434570),
    (6.880190, 51.434608),
    (6.881100, 51.434910),
    (6.881350, 51.434990),
    (6.882250, 51.435299),
    (6.882730, 51.435459),
    (6.883480, 51.435711),
    (6.883680, 51.435780),
    (6.884870, 51.436199),
    (6.885190, 51.436291),
    (6.885500, 51.436378),
    (6.885810, 51.436508),
    (6.885910, 51.436600),
    (6.886390, 51.436749),
    (6.887300, 51.437069),
    (6.887800, 51.437260),
    (6.888050, 51.437359),
    (6.888320, 51.437469),
    (6.888460, 51.437531),
    (6.889540, 51.437889),
    (6.889970, 51.438011),
    (6.890840, 51.438339),
    (6.893290, 51.439709),
    (6.893790, 51.439991),
    (6.894280, 51.440281),
    (6.895450, 51.440891),
    (6.896770, 51.441601),
    (6.897420, 51.441841),
    (6.898040, 51.442039),
    (6.898450, 51.442131),
    (6.900820, 51.442848),
    (6.902600, 51.443409),
    (6.903710, 51.443748),
    (6.903890, 51.443821),
    (6.904110, 51.443920),
    (6.904430, 51.444080),
    (6.905150, 51.444450),
    (6.905440, 51.444599),
    (6.906020, 51.444901),
    (6.906730, 51.445271),
    (6.908280, 51.446098),
    (6.908600, 51.446301),
    (6.908850, 51.446510),
    (6.909320, 51.446850),
    (6.910030, 51.447201),
    (6.910910, 51.447601),
    (6.911440, 51.447819),
    (6.911530, 51.447861),
    (6.913320, 51.448750),
    (6.913730, 51.448792),
    (6.914390, 51.449059),
    (6.914580, 51.449139),
    (6.915310, 51.449421),
    (6.916130, 51.449940),
    (6.916290, 51.450050),
    (6.916670, 51.450321),
    (6.918340, 51.451832),
    (6.920460, 51.453758),
    (6.922440, 51.455280),
    (6.924640, 51.456982),
    (6.927170, 51.458969),
    (6.927300, 51.459080),
    (6.928930, 51.460461),
    (6.929010, 51.460522),
    (6.929790, 51.461090),
    (6.930030, 51.461288),
    (6.931100, 51.462120),
    (6.931670, 51.462551),
    (6.931870, 51.462601),
    (6.932070, 51.462631),
    (6.932300, 51.462639),
    (6.932490, 51.462639),
    (6.932770, 51.462631),
    (6.932900, 51.462589),
    (6.933590, 51.462460),
    (6.934030, 51.462421),
    (6.934480, 51.462410),
    (6.934880, 51.462399),
    (6.936700, 51.462379),
    (6.938470, 51.462360),
    (6.939440, 51.462349),
    (6.939940, 51.462410),
    (6.940090, 51.462399),
    (6.941000, 51.462391),
    (6.941170, 51.462410),
    (6.941940, 51.462509),
    (6.943800, 51.462860),
    (6.946120, 51.463242),
    (6.947520, 51.463501),
    (6.947810, 51.463558),
    (6.947900, 51.463570),
    (6.948570, 51.463619),
    (6.948690, 51.463619),
    (6.949140, 51.463589),
    (6.949140, 51.463589),
    (6.949140, 51.463589),
    (6.949150, 51.463600),
    (6.949160, 51.463600),
    (6.949160, 51.463612),
    (6.949310, 51.463718),
    (6.949910, 51.464230),
    (6.950270, 51.464539),
    (6.950630, 51.464821),
    (6.951360, 51.465389),
    (6.951650, 51.465611),
    (6.951910, 51.465820),
    (6.952280, 51.466099),
    (6.952800, 51.466511),
    (6.952970, 51.466640),
    (6.953490, 51.467060),
    (6.954180, 51.467529),
    (6.954520, 51.467701),
    (6.954880, 51.467838),
    (6.955330, 51.467991),
    (6.956400, 51.468369),
    (6.956510, 51.468418),
    (6.956850, 51.468651),
    (6.957690, 51.469151),
    (6.958340, 51.469509),
    (6.958560, 51.469601),
    (6.958700, 51.469662),
    (6.958780, 51.469681),
    (6.958990, 51.469780),
    (6.961440, 51.470810),
    (6.962140, 51.471169),
    (6.963080, 51.471710),
    (6.963780, 51.472061),
    (6.964020, 51.472191),
    (6.964840, 51.472698),
    (6.965170, 51.472900),
    (6.965650, 51.473122),
    (6.966700, 51.473469),
    (6.967240, 51.473591),
    (6.967290, 51.473610),
    (6.967830, 51.473740),
    (6.968600, 51.473930),
    (6.969000, 51.474091),
    (6.969600, 51.474312),
    (6.971220, 51.474819),
    (6.971690, 51.474941),
    (6.971750, 51.474949),
    (6.971920, 51.474991),
    (6.972870, 51.475281),
    (6.973260, 51.475399),
    (6.973980, 51.475590),
    (6.975700, 51.475910),
    (6.975950, 51.475960),
    (6.978550, 51.476440),
    (6.978390, 51.476952),
    (6.978330, 51.477070),
    (6.978050, 51.477489),
    (6.977570, 51.477940),
    (6.976690, 51.478859),
    (6.976510, 51.479031),
    (6.977390, 51.479321),
    (6.977540, 51.479382),
    (6.978040, 51.479568),
    (6.978230, 51.479721),
    (6.978260, 51.479759),
    (6.978570, 51.480099),
    (6.978590, 51.480190),
    (6.978620, 51.480282),
    (6.978770, 51.480820),
    (6.978780, 51.480888),
    (6.978810, 51.480980),
    (6.978870, 51.481178),
    (6.979060, 51.481758),
    (6.979080, 51.481819),
    (6.979150, 51.481979),
    (6.979260, 51.482311),
    (6.979370, 51.482620),
    (6.979360, 51.482750),
    (6.979380, 51.483009),
    (6.979390, 51.483189),
    (6.979350, 51.483429),
    (6.979350, 51.484150),
    (6.979390, 51.484440),
    (6.979400, 51.484650),
    (6.979410, 51.484711),
    (6.979430, 51.484989),
    (6.979590, 51.485310),
    (6.979680, 51.485519),
    (6.980070, 51.486629),
    (6.980090, 51.486710),
    (6.980130, 51.486858),
    (6.980150, 51.486969),
    (6.980150, 51.486980),
    (6.980230, 51.487350),
    (6.980320, 51.487789),
    (6.980470, 51.488770),
    (6.980480, 51.488819),
    (6.980740, 51.488819),
    (6.980960, 51.488831),
    (6.981170, 51.488831),
    (6.981310, 51.488850),
    (6.981690, 51.488911),
    (6.981860, 51.488930),
    (6.982290, 51.489010),
    (6.982640, 51.489090),
    (6.983170, 51.489208),
    (6.984330, 51.489479),
    (6.985300, 51.489700),
    (6.985850, 51.489841),
    (6.986260, 51.489941),
    (6.986460, 51.489990),
    (6.986560, 51.490009),
    (6.987440, 51.490200),
    (6.987520, 51.490219),
    (6.989690, 51.490730),
    (6.991020, 51.491039),
    (6.991890, 51.491261),
    (6.992160, 51.491329),
    (6.993650, 51.491680),
    (6.994830, 51.491951),
    (6.996520, 51.492371),
    (6.996840, 51.492451),
    (6.997000, 51.492489),
    (6.997370, 51.492580),
    (6.997490, 51.492611),
    (6.997730, 51.492661),
    (6.999430, 51.493099),
    (6.999930, 51.493221),
    (7.000160, 51.493279),
    (7.001570, 51.493629),
    (7.002440, 51.493832),
    (7.002710, 51.493900),
    (7.002720, 51.493980),
    (7.002740, 51.494099),
    (7.002930, 51.494202),
    (7.004070, 51.494781),
    (7.004230, 51.494862),
    (7.004900, 51.495152),
    (7.005380, 51.495369),
    (7.005400, 51.495380),
    (7.006020, 51.495659),
    (7.006350, 51.495800),
    (7.006610, 51.495911),
    (7.006760, 51.495979),
    (7.007080, 51.496090),
    (7.007930, 51.496361),
    (7.008070, 51.496368),
    (7.008110, 51.496429),
    (7.008170, 51.496590),
    (7.008110, 51.497059),
    (7.008070, 51.497742),
    (7.008070, 51.497890),
    (7.008050, 51.498100),
    (7.007980, 51.499371),
    (7.007980, 51.499489),
    (7.007980, 51.499580),
    (7.008160, 51.499630),
    (7.009670, 51.500118),
    (7.009910, 51.500309),
    (7.010240, 51.500580),
    (7.011140, 51.501438),
    (7.011360, 51.501659),
    (7.011850, 51.502151),
    (7.012350, 51.502640),
    (7.012500, 51.502800),
    (7.013110, 51.503361),
    (7.013690, 51.503948),
    (7.014550, 51.504780),
    (7.015890, 51.506111),
    (7.016030, 51.506260),
    (7.016110, 51.506340),
    (7.018230, 51.508400),
    (7.018530, 51.508781),
    (7.019770, 51.508999),
    (7.020680, 51.509171),
    (7.020930, 51.509209),
    (7.022620, 51.509491),
    (7.022680, 51.509499),
    (7.024580, 51.509850),
    (7.025340, 51.509991),
    (7.026400, 51.510181),
    (7.027440, 51.510391),
    (7.028190, 51.510521),
    (7.028740, 51.510620),
    (7.028910, 51.510658),
    (7.029600, 51.510799),
    (7.029870, 51.510849),
    (7.030550, 51.510990),
    (7.031890, 51.511230),
    (7.032240, 51.511311),
    (7.032610, 51.511391),
    (7.032790, 51.511421),
    (7.033410, 51.511532),
    (7.035740, 51.511978),
    (7.036210, 51.512058),
    (7.037060, 51.512218),
    (7.037380, 51.512249),
    (7.038290, 51.512260),
    (7.038690, 51.512280),
    (7.038770, 51.512299),
    (7.039000, 51.512390),
    (7.039610, 51.512619),
    (7.039840, 51.512730),
    (7.040410, 51.513210),
    (7.040880, 51.513531),
    (7.040970, 51.513569),
    (7.041140, 51.513649),
    (7.042200, 51.514000),
    (7.042750, 51.514030),
    (7.043330, 51.513939),
    (7.043550, 51.513908),
    (7.043710, 51.513870),
    (7.043890, 51.513859),
    (7.044000, 51.513870),
    (7.044070, 51.513889),
    (7.044200, 51.513920),
    (7.044300, 51.513931),
    (7.044530, 51.513950),
    (7.045140, 51.513901),
    (7.046010, 51.513828),
    (7.046380, 51.513821),
    (7.046630, 51.513908),
    (7.046750, 51.514042),
    (7.046970, 51.514301),
    (7.047190, 51.514420),
    (7.047590, 51.514469),
    (7.048220, 51.514500),
    (7.049060, 51.514580),
    (7.051300, 51.514709),
    (7.053370, 51.514931),
    (7.054910, 51.515228),
    (7.056660, 51.515690),
    (7.058100, 51.516090),
    (7.059580, 51.516640),
    (7.062840, 51.518040),
    (7.066110, 51.519421),
    (7.066850, 51.519760),
    (7.067600, 51.520069),
    (7.068440, 51.520451),
    (7.070340, 51.521461),
    (7.071280, 51.522091),
    (7.071740, 51.522469),
    (7.072260, 51.522919),
    (7.072920, 51.523548),
    (7.073240, 51.523918),
    (7.073490, 51.524281),
    (7.073950, 51.525040),
    (7.074220, 51.525612),
    (7.074470, 51.526230),
    (7.074710, 51.526821),
    (7.075000, 51.527401),
    (7.075350, 51.527969),
    (7.075730, 51.528481),
    (7.076070, 51.528870),
    (7.076450, 51.529240),
    (7.076910, 51.529640),
    (7.077410, 51.530029),
    (7.077920, 51.530369),
    (7.078470, 51.530689),
    (7.079200, 51.531059),
    (7.079960, 51.531380),
    (7.080800, 51.531700),
    (7.081240, 51.531830),
    (7.082770, 51.532188),
    (7.084560, 51.532478),
    (7.085140, 51.532539),
    (7.086800, 51.532681),
    (7.089140, 51.532902),
    (7.090960, 51.533161),
    (7.092490, 51.533421),
    (7.093760, 51.533749),
    (7.095030, 51.534119),
    (7.095840, 51.534389),
    (7.095970, 51.534439),
    (7.096290, 51.534561),
    (7.098190, 51.535290),
    (7.098580, 51.535419),
    (7.099770, 51.535782),
    (7.100560, 51.536011),
    (7.101720, 51.536228),
    (7.102770, 51.536419),
    (7.104190, 51.536591),
    (7.112680, 51.537460),
    (7.115820, 51.537781),
    (7.117000, 51.537899),
    (7.118180, 51.537960),
    (7.119090, 51.537991),
    (7.120190, 51.537979),
    (7.122710, 51.537830),
    (7.125020, 51.537720),
    (7.126460, 51.537651),
    (7.127010, 51.537651),
    (7.127800, 51.537659),
    (7.128950, 51.537670),
    (7.129230, 51.537670),
    (7.129450, 51.537670),
    (7.131140, 51.537731),
    (7.133150, 51.537880),
    (7.135010, 51.538040),
    (7.138780, 51.538460),
    (7.139920, 51.538631),
    (7.141490, 51.538929),
    (7.142510, 51.539188),
    (7.143450, 51.539471),
    (7.144430, 51.539780),
    (7.146750, 51.540569),
    (7.148490, 51.541119),
    (7.149090, 51.541260),
    (7.150260, 51.541531),
    (7.151980, 51.541851),
    (7.153310, 51.542000),
    (7.154160, 51.542042),
    (7.155170, 51.542049),
    (7.157830, 51.541931),
    (7.159010, 51.541889),
    (7.160640, 51.541821),
    (7.162270, 51.541889),
    (7.162950, 51.541931),
    (7.166520, 51.542160),
    (7.168060, 51.542259),
    (7.168840, 51.542290),
    (7.171180, 51.542358),
    (7.172460, 51.542419),
    (7.172710, 51.542431),
    (7.174350, 51.542580),
    (7.174900, 51.542641),
    (7.177280, 51.542992),
    (7.177530, 51.543041),
    (7.178090, 51.543129),
    (7.178870, 51.543251),
    (7.179880, 51.543381),
    (7.180110, 51.543411),
    (7.180740, 51.543491),
    (7.180980, 51.543510),
    (7.182250, 51.543640),
    (7.183710, 51.543720),
    (7.185510, 51.543770),
    (7.187350, 51.543739),
    (7.188310, 51.543751),
    (7.190100, 51.543739),
    (7.191140, 51.543770),
    (7.192030, 51.543770),
    (7.193450, 51.543800),
    (7.195470, 51.543900),
    (7.197000, 51.544010),
    (7.197800, 51.544090),
    (7.198560, 51.544189),
    (7.199550, 51.544361),
    (7.200300, 51.544498),
    (7.202270, 51.544949),
    (7.202740, 51.545071),
    (7.203270, 51.545212),
    (7.203850, 51.545368),
    (7.205020, 51.545738),
    (7.209100, 51.547192),
    (7.211500, 51.548038),
    (7.211980, 51.548210),
    (7.212500, 51.548439),
    (7.214700, 51.549198),
    (7.215410, 51.549500),
    (7.218480, 51.550709),
    (7.220240, 51.551399),
    (7.225720, 51.553692),
    (7.230400, 51.555630),
    (7.231080, 51.555908),
    (7.231370, 51.556030),
    (7.231640, 51.556141),
    (7.232450, 51.556469),
    (7.233100, 51.556751),
    (7.233900, 51.557121),
    (7.234810, 51.557549),
    (7.236040, 51.557961),
    (7.237320, 51.558350),
    (7.238660, 51.558632),
    (7.240110, 51.558880),
    (7.241480, 51.559021),
    (7.242900, 51.559101),
    (7.243860, 51.559132),
    (7.245710, 51.558990),
    (7.247140, 51.558868),
    (7.248560, 51.558651),
    (7.250410, 51.558300),
    (7.251590, 51.558060),
    (7.252660, 51.557812),
    (7.253990, 51.557541),
    (7.255320, 51.557320),
    (7.256710, 51.557159),
    (7.258090, 51.557060),
    (7.258620, 51.557030),
    (7.261410, 51.557030),
    (7.262540, 51.557098),
    (7.263540, 51.557159),
    (7.266210, 51.557510),
    (7.267520, 51.557701),
    (7.268390, 51.557861),
    (7.269020, 51.557961),
    (7.270180, 51.558128),
    (7.271110, 51.558270),
    (7.272070, 51.558392),
    (7.273210, 51.558479),
    (7.275510, 51.558601),
    (7.276560, 51.558620),
    (7.278040, 51.558590),
    (7.278980, 51.558540),
    (7.279820, 51.558491),
    (7.280970, 51.558418),
    (7.281940, 51.558361),
    (7.282910, 51.558289),
    (7.283860, 51.558239),
    (7.284810, 51.558189),
    (7.286240, 51.558159),
    (7.287660, 51.558189),
    (7.289060, 51.558270),
    (7.290470, 51.558411),
    (7.291850, 51.558571),
    (7.292080, 51.558601),
    (7.292610, 51.558670),
    (7.294170, 51.558830),
    (7.295070, 51.558949),
    (7.295980, 51.559071),
    (7.296880, 51.559189),
    (7.297780, 51.559299),
    (7.298680, 51.559422),
    (7.299580, 51.559528),
    (7.300450, 51.559639),
    (7.301270, 51.559731),
    (7.302070, 51.559830),
    (7.302830, 51.559929),
    (7.303620, 51.560020),
    (7.304420, 51.560120),
    (7.305200, 51.560211),
    (7.305830, 51.560299),
    (7.306340, 51.560329),
    (7.310260, 51.560749),
    (7.310560, 51.560768),
    (7.313380, 51.560768),
    (7.313970, 51.560760),
    (7.314110, 51.560749),
    (7.314250, 51.560749),
    (7.314390, 51.560711),
    (7.314490, 51.560680),
    (7.314580, 51.560638),
    (7.314640, 51.560551),
    (7.314750, 51.560249),
    (7.314670, 51.559898),
    (7.314650, 51.559841),
    (7.314470, 51.559219),
    (7.314140, 51.558239),
    (7.314350, 51.558231),
    (7.315000, 51.558109),
    (7.315160, 51.558090),
    (7.315890, 51.557961),
    (7.316350, 51.557880),
    (7.316490, 51.557850),
    (7.316840, 51.557800),
    (7.317270, 51.557751),
    (7.317570, 51.557758),
    (7.317980, 51.557789),
    (7.318210, 51.557831),
    (7.318480, 51.557899),
    (7.319500, 51.558208),
    (7.319750, 51.558289),
    (7.320080, 51.558392),
    (7.320160, 51.558418),
    (7.320490, 51.558521),
    (7.321400, 51.558800),
    (7.322810, 51.559250),
    (7.323580, 51.559471),
    (7.324290, 51.559681),
    (7.325180, 51.559879),
    (7.325560, 51.559971),
    (7.326670, 51.560211),
    (7.327210, 51.560379),
    (7.327620, 51.560520),
    (7.327980, 51.560711),
    (7.328030, 51.560730),
    (7.328480, 51.561001),
    (7.329130, 51.561489),
    (7.329250, 51.561581),
    (7.329860, 51.562038),
    (7.330410, 51.562408),
    (7.330640, 51.562592),
    (7.330950, 51.562832),
    (7.331530, 51.563251),
    (7.333310, 51.564541),
    (7.334320, 51.565159),
    (7.334720, 51.565361),
    (7.335070, 51.565540),
    (7.335430, 51.565708),
    (7.336160, 51.566040),
    (7.337720, 51.566689),
    (7.338890, 51.567181),
    (7.339240, 51.567329),
    (7.339560, 51.567471),
    (7.339720, 51.567539),
    (7.339900, 51.567612),
    (7.340540, 51.567890),
    (7.340810, 51.568001),
    (7.341020, 51.568089),
    (7.341150, 51.568150),
    (7.341480, 51.568298),
    (7.341900, 51.568481),
    (7.342160, 51.568588),
    (7.342360, 51.568691),
    (7.342840, 51.568901),
    (7.343530, 51.569191),
    (7.343850, 51.569302),
    (7.344320, 51.569450),
    (7.344830, 51.569561),
    (7.345880, 51.569839),
    (7.346380, 51.569962),
    (7.346760, 51.570061),
    (7.347200, 51.570171),
    (7.348050, 51.570381),
    (7.349450, 51.570709),
    (7.350990, 51.571072),
    (7.351180, 51.571140),
    (7.351720, 51.571301),
    (7.352200, 51.571442),
    (7.352390, 51.571491),
    (7.352530, 51.571560),
    (7.353330, 51.571911),
    (7.354190, 51.572289),
    (7.354810, 51.572399),
    (7.355370, 51.572491),
    (7.356620, 51.572689),
    (7.357270, 51.572720),
    (7.358590, 51.572781),
    (7.359440, 51.572811),
    (7.359890, 51.572830),
    (7.360180, 51.572842),
    (7.360310, 51.572880),
    (7.360370, 51.572960),
    (7.360550, 51.573311),
    (7.360670, 51.573551),
    (7.360930, 51.574039),
    (7.361230, 51.574440),
    (7.361500, 51.574360),
    (7.361730, 51.574291),
    (7.362130, 51.574100),
    (7.362480, 51.573940),
    (7.362530, 51.573921),
    (7.362890, 51.573799),
    (7.363010, 51.573761),
    (7.363120, 51.573730),
    (7.363590, 51.573631),
    (7.364080, 51.573559),
    (7.364470, 51.573528),
    (7.364870, 51.573521),
    (7.365560, 51.573509),
    (7.366160, 51.573540),
    (7.366250, 51.573540),
    (7.367080, 51.573589),
    (7.367890, 51.573570),
    (7.368850, 51.573479),
    (7.369360, 51.573399),
    (7.370030, 51.573280),
    (7.370150, 51.573261),
    (7.371070, 51.573090),
    (7.371310, 51.573051),
    (7.371420, 51.573029),
    (7.371880, 51.572971),
    (7.372020, 51.572948),
    (7.372330, 51.572922),
    (7.372450, 51.572910),
    (7.373350, 51.572788),
    (7.373680, 51.572750),
    (7.374530, 51.572651),
    (7.375500, 51.572529),
    (7.375980, 51.572479),
    (7.376460, 51.572418),
    (7.377620, 51.572289),
    (7.377810, 51.572609),
    (7.377980, 51.572830),
    (7.378030, 51.572899),
    (7.378090, 51.572990),
    (7.378390, 51.573261),
    (7.378600, 51.573410),
    (7.378930, 51.573620),
    (7.379240, 51.573769),
    (7.379740, 51.574039),
    (7.380050, 51.574181),
    (7.381400, 51.574810),
    (7.381610, 51.574902),
    (7.381730, 51.574951),
    (7.382290, 51.575180),
    (7.382660, 51.575241),
    (7.383260, 51.575241),
    (7.384020, 51.575199),
    (7.384500, 51.575161),
    (7.384930, 51.575161),
    (7.385220, 51.575191),
    (7.385490, 51.575230),
    (7.386010, 51.575260),
    (7.386540, 51.575272),
    (7.386540, 51.575359),
    (7.386550, 51.575611),
    (7.386580, 51.575790),
    (7.386600, 51.575851),
    (7.386640, 51.575958),
    (7.386680, 51.576099),
    (7.386780, 51.576340),
    (7.386830, 51.576530),
    (7.386880, 51.576759),
    (7.386900, 51.576889),
    (7.386910, 51.577030),
    (7.386880, 51.577412),
    (7.386870, 51.577629),
    (7.386890, 51.577839),
    (7.386920, 51.577961),
    (7.386990, 51.578251),
    (7.387120, 51.578430),
    (7.387320, 51.578621),
    (7.387460, 51.578701),
    (7.387690, 51.578781),
    (7.389000, 51.579170),
    (7.390220, 51.579540),
    (7.390520, 51.579632),
    (7.390900, 51.579739),
    (7.391280, 51.579861),
    (7.391520, 51.579941),
    (7.392170, 51.580181),
    (7.393070, 51.580471),
    (7.393790, 51.580750),
    (7.393980, 51.580818),
    (7.394110, 51.580879),
    (7.394270, 51.580940),
    (7.394420, 51.581020),
    (7.394860, 51.581261),
    (7.395160, 51.581429),
    (7.395450, 51.581581),
    (7.395870, 51.581841),
    (7.395980, 51.581982),
    (7.396010, 51.582001),
    (7.396610, 51.582500),
    (7.397290, 51.583229),
    (7.397430, 51.583401),
    (7.397790, 51.583820),
    (7.398040, 51.584011),
    (7.398340, 51.584190),
    (7.398830, 51.584480),
    (7.399360, 51.584751),
    (7.400520, 51.585121),
    (7.401540, 51.585381),
    (7.401570, 51.585388),
    (7.402560, 51.585640),
    (7.402770, 51.585701),
    (7.403220, 51.585812),
    (7.404350, 51.586102),
    (7.404550, 51.586151),
    (7.405610, 51.586411),
    (7.406340, 51.586590),
    (7.406750, 51.586700),
    (7.406970, 51.586750),
    (7.407530, 51.586891),
    (7.408110, 51.587101),
    (7.408410, 51.587318),
    (7.409200, 51.587879),
    (7.409710, 51.588490),
    (7.410140, 51.589008),
    (7.410380, 51.589260),
    (7.410650, 51.589451),
    (7.411800, 51.590080),
    (7.412610, 51.590519),
    (7.413240, 51.590851),
    (7.413850, 51.591160),
    (7.414360, 51.591450),
    (7.415630, 51.592159),
    (7.415740, 51.592220),
    (7.415800, 51.592258),
    (7.416390, 51.592609),
    (7.416490, 51.592682),
    (7.416920, 51.592930),
    (7.417290, 51.593140),
    (7.417670, 51.593319),
    (7.418040, 51.593460),
    (7.418260, 51.593529),
    (7.418520, 51.593590),
    (7.418800, 51.593651),
    (7.419720, 51.593849),
    (7.420630, 51.594040),
    (7.421510, 51.594219),
    (7.422010, 51.594330),
    (7.422030, 51.594341),
    (7.422750, 51.594521),
    (7.422960, 51.594582),
    (7.423230, 51.594650),
    (7.423380, 51.594688),
    (7.423850, 51.594810),
    (7.424720, 51.595032),
    (7.424900, 51.595081),
    (7.425270, 51.595181),
    (7.425530, 51.595249),
    (7.425690, 51.595291),
    (7.425890, 51.595341),
    (7.426130, 51.595390),
    (7.426370, 51.595428),
    (7.426450, 51.595440),
    (7.426690, 51.595470),
    (7.426870, 51.595482),
    (7.428010, 51.595551),
    (7.429650, 51.595638),
    (7.430080, 51.595669),
    (7.430770, 51.595711),
    (7.431370, 51.595760),
    (7.431610, 51.595791),
    (7.432410, 51.595791),
    (7.433220, 51.595749),
    (7.433560, 51.595749),
    (7.434140, 51.595741),
    (7.437100, 51.595600),
    (7.439340, 51.595490),
    (7.440170, 51.595459),
    (7.440890, 51.595539),
    (7.441250, 51.595570),
    (7.442550, 51.595821),
    (7.443630, 51.596100),
    (7.443910, 51.596180),
    (7.444950, 51.596481),
    (7.445220, 51.596550),
    (7.446530, 51.596951),
    (7.446740, 51.597000),
    (7.448020, 51.597389),
    (7.449000, 51.597672),
    (7.449710, 51.597919),
    (7.450110, 51.598091),
    (7.450730, 51.598431),
    (7.450830, 51.598480),
    (7.451700, 51.598930),
    (7.452770, 51.599571),
    (7.453860, 51.600182),
    (7.454320, 51.600361),
    (7.454660, 51.600529),
    (7.454970, 51.600689),
    (7.456780, 51.601528),
    (7.458250, 51.602169),
    (7.458750, 51.602379),
    (7.460630, 51.603062),
    (7.463120, 51.603779),
    (7.465240, 51.604179),
    (7.466110, 51.604309),
    (7.466580, 51.604401),
    (7.467750, 51.604549),
    (7.470300, 51.604740),
    (7.471580, 51.604771),
    (7.472760, 51.604759),
    (7.473840, 51.604740),
    (7.475450, 51.604630),
    (7.476410, 51.604511),
    (7.477200, 51.604351),
    (7.478160, 51.604149),
    (7.478650, 51.604031),
    (7.479620, 51.603828),
    (7.480420, 51.603710),
    (7.481510, 51.603588),
    (7.482620, 51.603489),
    (7.483940, 51.603298),
    (7.484580, 51.603161),
    (7.485470, 51.602921),
    (7.487050, 51.602280),
    (7.487480, 51.602089),
    (7.487680, 51.602001),
    (7.488080, 51.601799),
    (7.488310, 51.601669),
    (7.488550, 51.601551),
    (7.488790, 51.601440),
    (7.489020, 51.601318),
    (7.489290, 51.601200),
    (7.489460, 51.601120),
    (7.489640, 51.601028),
    (7.489750, 51.600979),
    (7.490240, 51.601372),
    (7.490620, 51.601719),
    (7.490760, 51.601841),
    (7.490800, 51.601891),
    (7.491570, 51.602501),
    (7.492020, 51.602852),
    (7.492400, 51.603222),
    (7.492930, 51.603519),
    (7.493270, 51.603729),
    (7.493730, 51.604080),
    (7.494250, 51.604431),
    (7.494590, 51.604691),
    (7.495210, 51.605221),
    (7.495670, 51.605579),
    (7.496280, 51.605999),
    (7.496780, 51.606331),
    (7.497300, 51.606670),
    (7.497920, 51.607021),
    (7.498530, 51.607319),
    (7.499170, 51.607601),
    (7.499830, 51.607849),
    (7.500440, 51.608040),
    (7.501300, 51.608330),
    (7.502050, 51.608570),
    (7.503020, 51.608822),
    (7.503720, 51.609001),
    (7.504520, 51.609180),
    (7.505300, 51.609371),
    (7.506100, 51.609531),
    (7.506950, 51.609631),
    (7.507730, 51.609730),
    (7.508520, 51.609772),
    (7.509490, 51.609760),
    (7.513560, 51.609558),
    (7.515010, 51.609631),
    (7.515260, 51.609650),
    (7.516320, 51.609772),
    (7.517320, 51.609680),
    (7.518600, 51.609509),
    (7.518700, 51.609489),
    (7.520320, 51.609249),
    (7.521180, 51.609138),
    (7.521980, 51.609039),
    (7.522410, 51.609009),
    (7.523140, 51.609009),
    (7.523390, 51.609001),
    (7.523480, 51.609001),
    (7.523960, 51.608971),
    (7.524530, 51.608971),
    (7.524630, 51.608971),
    (7.524880, 51.608971),
    (7.525000, 51.608971),
    (7.525560, 51.608971),
    (7.525810, 51.608971),
    (7.526030, 51.608971),
    (7.527270, 51.608978),
    (7.527820, 51.609020),
    (7.528830, 51.609051),
    (7.529610, 51.609081),
    (7.530090, 51.609131),
    (7.532630, 51.609489),
    (7.533150, 51.609531),
    (7.533680, 51.609550),
    (7.534130, 51.609539),
    (7.534810, 51.609440),
    (7.535840, 51.609100),
    (7.536850, 51.608742),
    (7.537630, 51.608551),
    (7.538530, 51.608471),
    (7.539050, 51.608459),
    (7.539930, 51.608559),
    (7.541050, 51.608761),
    (7.542060, 51.609051),
    (7.544400, 51.609810),
    (7.544650, 51.609901),
    (7.544930, 51.610008),
    (7.545500, 51.610229),
    (7.546150, 51.610470),
    (7.547840, 51.611050),
    (7.548260, 51.611191),
    (7.549090, 51.611420),
    (7.549810, 51.611580),
    (7.551280, 51.611729),
    (7.551280, 51.612030),
    (7.551330, 51.612171),
    (7.551380, 51.612251),
    (7.551470, 51.612331),
    (7.551630, 51.612431),
    (7.555080, 51.613689),
    (7.558390, 51.614971),
    (7.558680, 51.615101),
    (7.561150, 51.616261),
    (7.561930, 51.616669),
    (7.563330, 51.617439),
    (7.565350, 51.618721),
    (7.565980, 51.619190),
    (7.567140, 51.620071),
    (7.568810, 51.621399),
    (7.573740, 51.625648),
    (7.574310, 51.626110),
    (7.574650, 51.626389),
    (7.575130, 51.626732),
    (7.575790, 51.627159),
    (7.576920, 51.627861),
    (7.579400, 51.629070),
    (7.580830, 51.629589),
    (7.582310, 51.630070),
    (7.584300, 51.630680),
    (7.586690, 51.631481),
    (7.590960, 51.633430),
    (7.593070, 51.634670),
    (7.594350, 51.635262),
    (7.594900, 51.635490),
    (7.596590, 51.636028),
    (7.598540, 51.636379),
    (7.601560, 51.636650),
    (7.603980, 51.636929),
    (7.605940, 51.637329),
    (7.612510, 51.639351),
    (7.614280, 51.639790),
    (7.615750, 51.640011),
    (7.616490, 51.640099),
    (7.617210, 51.640148),
    (7.618300, 51.640221),
    (7.619620, 51.640282),
    (7.620650, 51.640339),
    (7.621630, 51.640419),
    (7.622030, 51.640480),
    (7.622530, 51.640572),
    (7.624210, 51.640942),
    (7.626370, 51.641460),
    (7.628820, 51.642139),
    (7.634750, 51.643681),
    (7.635640, 51.643970),
    (7.636560, 51.644421),
    (7.636980, 51.644680),
    (7.637490, 51.645039),
    (7.638330, 51.645611),
    (7.639040, 51.646111),
    (7.639550, 51.646389),
    (7.639960, 51.646561),
    (7.640430, 51.646709),
    (7.642880, 51.647190),
    (7.642980, 51.647209),
    (7.643580, 51.647339),
    (7.643700, 51.647369),
    (7.644530, 51.647560),
    (7.645630, 51.647820),
    (7.647280, 51.648300),
    (7.650240, 51.649158),
    (7.655060, 51.650620),
    (7.656790, 51.651039),
    (7.657930, 51.651279),
    (7.659280, 51.651501),
    (7.660660, 51.651699),
    (7.662230, 51.651798),
    (7.663080, 51.651859),
    (7.664560, 51.651878),
    (7.666480, 51.651859),
    (7.672810, 51.651810),
    (7.673580, 51.651821),
    (7.675420, 51.651878),
    (7.676140, 51.651939),
    (7.676420, 51.651951),
    (7.677360, 51.652031),
    (7.679450, 51.652290),
    (7.680310, 51.652409),
    (7.681320, 51.652599),
    (7.682190, 51.652790),
    (7.682280, 51.652809),
    (7.683120, 51.653011),
    (7.683950, 51.653221),
    (7.684570, 51.653389),
    (7.684680, 51.653419),
    (7.684820, 51.653450),
    (7.684960, 51.653500),
    (7.686470, 51.653980),
    (7.687130, 51.654221),
    (7.687800, 51.654480),
    (7.689140, 51.655022),
    (7.691210, 51.655899),
    (7.692850, 51.656590),
    (7.694180, 51.657059),
    (7.694440, 51.657150),
    (7.695310, 51.657452),
    (7.697580, 51.658081),
    (7.699870, 51.658588),
    (7.701910, 51.658932),
    (7.701890, 51.658989),
    (7.701590, 51.659618),
    (7.701460, 51.659889),
    (7.700490, 51.662441),
    (7.700390, 51.662739),
    (7.700210, 51.663311),
    (7.700170, 51.663540),
    (7.700170, 51.663700),
    (7.700230, 51.663872),
    (7.700440, 51.664101),
    (7.700670, 51.664230),
    (7.700970, 51.664330),
    (7.701310, 51.664398),
    (7.701820, 51.664509),
    (7.702550, 51.664639),
    (7.702940, 51.664711),
    (7.703890, 51.664879),
    (7.704340, 51.664951),
    (7.704640, 51.665051),
    (7.704760, 51.665112),
    (7.704870, 51.665180),
    (7.704960, 51.665260),
    (7.705030, 51.665329),
    (7.705070, 51.665409),
    (7.705130, 51.665531),
    (7.705140, 51.665680),
    (7.705140, 51.665821),
    (7.705090, 51.665951),
    (7.704970, 51.666199),
    (7.704170, 51.667679),
    (7.704010, 51.667980),
    (7.703890, 51.668289),
    (7.703860, 51.668530),
    (7.703870, 51.668770),
    (7.703970, 51.669140),
    (7.704210, 51.669472),
    (7.704690, 51.669922),
    (7.705010, 51.670200),
    (7.705220, 51.670490),
    (7.705300, 51.670639),
    (7.705320, 51.670830),
    (7.705310, 51.671150),
    (7.705240, 51.671501),
    (7.704870, 51.672310),
    (7.704830, 51.672401),
    (7.704740, 51.672581),
    (7.704720, 51.672630),
    (7.704830, 51.672680),
    (7.704870, 51.672710),
    (7.704890, 51.672791),
    (7.705590, 51.672798),
    (7.706210, 51.672810),
    (7.708320, 51.673340),
    (7.710350, 51.673851),
    (7.711020, 51.674019),
    (7.711750, 51.674191),
    (7.714670, 51.674789),
    (7.714950, 51.674870),
    (7.716420, 51.675369),
    (7.719040, 51.676529),
    (7.724280, 51.678661),
    (7.726390, 51.679489),
    (7.728640, 51.680309),
    (7.731230, 51.681129),
    (7.734800, 51.682400),
    (7.736040, 51.682850),
    (7.738920, 51.683830),
    (7.739220, 51.683929),
    (7.739520, 51.684021),
    (7.740040, 51.684219),
    (7.740620, 51.684441),
    (7.741100, 51.684631),
    (7.741560, 51.684849),
    (7.742240, 51.685211),
    (7.742920, 51.685631),
    (7.743730, 51.686100),
    (7.743810, 51.686138),
    (7.744290, 51.686390),
    (7.745370, 51.686790),
    (7.745930, 51.686958),
    (7.746390, 51.687080),
    (7.746710, 51.687160),
    (7.746970, 51.687210),
    (7.747760, 51.687359),
    (7.748560, 51.687469),
    (7.750250, 51.687679),
    (7.750750, 51.687740),
    (7.750920, 51.687759),
    (7.752000, 51.687920),
    (7.752380, 51.687981),
    (7.752760, 51.688080),
    (7.753840, 51.688450),
    (7.755840, 51.689140),
    (7.755890, 51.689159),
    (7.757460, 51.689690),
    (7.760750, 51.690849),
    (7.761000, 51.690899),
    (7.761180, 51.690922),
    (7.761370, 51.690941),
    (7.761610, 51.690960),
    (7.761850, 51.690971),
    (7.761990, 51.690960),
    (7.762140, 51.690948),
    (7.762230, 51.690929),
    (7.762500, 51.690899),
    (7.762580, 51.690880),
    (7.763100, 51.690800),
    (7.763270, 51.690769),
    (7.764220, 51.690609),
    (7.767710, 51.690189),
    (7.768120, 51.690128),
    (7.768460, 51.690079),
    (7.769020, 51.690010),
    (7.769620, 51.689968),
    (7.770700, 51.689930),
    (7.771820, 51.689850),
    (7.772370, 51.689831),
    (7.772930, 51.689800),
    (7.773920, 51.689850),
    (7.774170, 51.689850),
    (7.774340, 51.689850),
    (7.774410, 51.689838),
    (7.774600, 51.689831),
    (7.774800, 51.689812),
    (7.775650, 51.689671),
    (7.776600, 51.689449),
    (7.777210, 51.689301),
    (7.777610, 51.689220),
    (7.777810, 51.689190),
    (7.778180, 51.689140),
    (7.778760, 51.689072),
    (7.779400, 51.689011),
    (7.780390, 51.688950),
    (7.781380, 51.688900),
    (7.781630, 51.688881),
    (7.782010, 51.688850),
    (7.782290, 51.688831),
    (7.782500, 51.688789),
    (7.783140, 51.688641),
    (7.783430, 51.688580),
    (7.783830, 51.688499),
    (7.784250, 51.688438),
    (7.785610, 51.688290),
    (7.786320, 51.688210),
    (7.786950, 51.688141),
    (7.787640, 51.688068),
    (7.788370, 51.687981),
    (7.788820, 51.687931),
    (7.789100, 51.687908),
    (7.789580, 51.687889),
    (7.789780, 51.687889),
    (7.789970, 51.687920),
    (7.790220, 51.687950),
    (7.791070, 51.688091),
    (7.792030, 51.688259),
    (7.793490, 51.688511),
    (7.794210, 51.688641),
    (7.794550, 51.688690),
    (7.794910, 51.688721),
    (7.796290, 51.688789),
    (7.797050, 51.688820),
    (7.797820, 51.688850),
    (7.799880, 51.688938),
    (7.800170, 51.688961),
    (7.800570, 51.688999),
    (7.801060, 51.689079),
    (7.801230, 51.689110),
    (7.801300, 51.689129),
    (7.802510, 51.689350),
    (7.802940, 51.689430),
    (7.804320, 51.689678),
    (7.805030, 51.689812),
    (7.805300, 51.689861),
    (7.805760, 51.689949),
    (7.806660, 51.690121),
    (7.807620, 51.690300),
    (7.808460, 51.690418),
    (7.808820, 51.690441),
    (7.808970, 51.690460),
    (7.809070, 51.690491),
    (7.809150, 51.690529),
    (7.809220, 51.690559),
    (7.809300, 51.690620),
    (7.809380, 51.690701),
    (7.809500, 51.690769),
    (7.809580, 51.690811),
    (7.809620, 51.690830),
    (7.810100, 51.690941),
    (7.810570, 51.691040),
    (7.810730, 51.691071),
    (7.811580, 51.691238),
    (7.811770, 51.691269),
    (7.813030, 51.691479),
    (7.813860, 51.691620),
    (7.814490, 51.691761),
    (7.814650, 51.691811),
    (7.814900, 51.691879),
    (7.815110, 51.691959),
    (7.815500, 51.692108),
    (7.815870, 51.692299),
    (7.816680, 51.692719),
    (7.817370, 51.693062),
    (7.817810, 51.693279),
    (7.818610, 51.693680),
    (7.819050, 51.693890),
    (7.819330, 51.694031),
    (7.819680, 51.694180),
    (7.820030, 51.694290),
    (7.820460, 51.694401),
    (7.821670, 51.694710),
    (7.821810, 51.694759),
    (7.821820, 51.694740),
    (7.821930, 51.694698),
    (7.822050, 51.694710),
    (7.822140, 51.694729),
    (7.822190, 51.694771),
    (7.822210, 51.694801),
    (7.822210, 51.694870),
    (7.822720, 51.694981),
    (7.823010, 51.695061),
    (7.823290, 51.695179),
    (7.823540, 51.695309),
    (7.824200, 51.695679),
    (7.824550, 51.695862),
    (7.824570, 51.695869),
    (7.825160, 51.696129),
    (7.825550, 51.696270),
    (7.826180, 51.696449),
    (7.827010, 51.696720),
    (7.827220, 51.696789),
    (7.827850, 51.696991),
    (7.828360, 51.697151),
    (7.828770, 51.697269),
    (7.829640, 51.697529),
    (7.829990, 51.697639),
    (7.830360, 51.697750),
    (7.831060, 51.697960),
    (7.831580, 51.698090),
    (7.832500, 51.698261),
    (7.832850, 51.698330),
    (7.832960, 51.698349),
    (7.833300, 51.698421),
    (7.834360, 51.698620),
    (7.834950, 51.698730),
    (7.835190, 51.698769),
    (7.835770, 51.698898),
    (7.836910, 51.699131),
    (7.837250, 51.699200),
    (7.837500, 51.699249),
    (7.837530, 51.699261),
    (7.837760, 51.699329),
    (7.838010, 51.699440),
    (7.838250, 51.699551),
    (7.838940, 51.699902),
    (7.839500, 51.700150),
    (7.839650, 51.700199),
    (7.840070, 51.700321),
    (7.840340, 51.700390),
    (7.840960, 51.700550),
    (7.842070, 51.700840),
    (7.842490, 51.700958),
    (7.842820, 51.701092),
    (7.843850, 51.701660),
    (7.844120, 51.701778),
    (7.844550, 51.701950),
    (7.844900, 51.702061),
    (7.845180, 51.702148),
    (7.845410, 51.702221),
    (7.845630, 51.702271),
    (7.845990, 51.702358),
    (7.846310, 51.702400),
    (7.847030, 51.702492),
    (7.848190, 51.702629),
    (7.848880, 51.702702),
    (7.849160, 51.702740),
    (7.850570, 51.702888),
    (7.852090, 51.703060),
    (7.852500, 51.703110),
    (7.852540, 51.703110),
    (7.854330, 51.703308),
    (7.854770, 51.703350),
    (7.855300, 51.703381),
    (7.855580, 51.703400),
    (7.857360, 51.703468),
    (7.859240, 51.703560),
    (7.859940, 51.703579),
    (7.860050, 51.703590),
    (7.860360, 51.703602),
    (7.864410, 51.703781),
    (7.866300, 51.703861),
    (7.866740, 51.703911),
    (7.866840, 51.703930),
    (7.867210, 51.704041),
    (7.868600, 51.704460),
    (7.869660, 51.704800),
    (7.871430, 51.705372),
    (7.874690, 51.706310),
    (7.875130, 51.706409),
    (7.875760, 51.706532),
    (7.876130, 51.706581),
    (7.876510, 51.706619),
    (7.876960, 51.706650),
    (7.877410, 51.706669),
    (7.877800, 51.706669),
    (7.878530, 51.706661),
    (7.879290, 51.706631),
    (7.880410, 51.706581),
    (7.880750, 51.706570),
    (7.880890, 51.706581),
    (7.881250, 51.706581),
    (7.881580, 51.706600),
    (7.881960, 51.706638),
    (7.882570, 51.706730),
    (7.882930, 51.706791),
    (7.883280, 51.706860),
    (7.883940, 51.707008),
    (7.884410, 51.707111),
    (7.884700, 51.707169),
    (7.884980, 51.707211),
    (7.885520, 51.707298),
    (7.885920, 51.707340),
    (7.886390, 51.707371),
    (7.887840, 51.707432),
    (7.888570, 51.707451),
    (7.890580, 51.707531),
    (7.892450, 51.707581),
    (7.895620, 51.707691),
    (7.901300, 51.707241),
    (7.903640, 51.707390),
    (7.906690, 51.707619),
    (7.908260, 51.707741),
    (7.909720, 51.707851),
    (7.912270, 51.707741),
    (7.913980, 51.707680),
    (7.914480, 51.707680),
    (7.916180, 51.708050),
    (7.916470, 51.708099),
    (7.918300, 51.708370),
    (7.919360, 51.708481),
    (7.920380, 51.708580),
    (7.921570, 51.708809),
    (7.922190, 51.709122),
    (7.924830, 51.710819),
    (7.925770, 51.711449),
    (7.926900, 51.712189),
    (7.928760, 51.713409),
    (7.929150, 51.713669),
    (7.933590, 51.716770),
    (7.935140, 51.717571),
    (7.936760, 51.718262),
    (7.937310, 51.718460),
    (7.939620, 51.719200),
    (7.941940, 51.719959),
    (7.943930, 51.720661),
    (7.948920, 51.722408),
    (7.951300, 51.723270),
    (7.951670, 51.723400),
    (7.954740, 51.724449),
    (7.955850, 51.724892),
    (7.961000, 51.726631),
    (7.963850, 51.727589),
    (7.966830, 51.728642),
    (7.970640, 51.729961),
    (7.975080, 51.731491),
    (7.977760, 51.732422),
    (7.977990, 51.732498),
    (7.983950, 51.734558),
    (7.986270, 51.735321),
    (7.987960, 51.735901),
    (7.991960, 51.737259),
    (7.998030, 51.739349),
    (8.002740, 51.741009),
    (8.008920, 51.743172),
    (8.011830, 51.744240),
    (8.013640, 51.744991),
    (8.014930, 51.745571),
    (8.015380, 51.745781),
    (8.016030, 51.746101),
    (8.016870, 51.746510),
    (8.019270, 51.747711),
    (8.019900, 51.748001),
    (8.020280, 51.748180),
    (8.022440, 51.749260),
    (8.022500, 51.749229),
    (8.022580, 51.749222),
    (8.022640, 51.749229),
    (8.022700, 51.749260),
    (8.022730, 51.749298),
    (8.022730, 51.749340),
    (8.022700, 51.749401),
    (8.024840, 51.750401),
    (8.025290, 51.750622),
    (8.026820, 51.751381),
    (8.029510, 51.752731),
    (8.031450, 51.753670),
    (8.031810, 51.753899),
    (8.032060, 51.754139),
    (8.032170, 51.754250),
    (8.032610, 51.754688),
    (8.032740, 51.754829),
    (8.032810, 51.754879),
    (8.033240, 51.755070),
    (8.033810, 51.755161),
    (8.034180, 51.755180),
    (8.034570, 51.755199),
    (8.034800, 51.755299),
    (8.034960, 51.755150),
    (8.035170, 51.755081),
    (8.035460, 51.755039),
    (8.035830, 51.755032),
    (8.036310, 51.755039),
    (8.036450, 51.754601),
    (8.036610, 51.754261),
    (8.037070, 51.754318),
    (8.037860, 51.754410),
    (8.038660, 51.754440),
    (8.039080, 51.754379),
    (8.039950, 51.754108),
    (8.040550, 51.754028),
    (8.041070, 51.753990),
    (8.041580, 51.753979),
    (8.041750, 51.753971),
    (8.041960, 51.753990),
    (8.042180, 51.754040),
    (8.042410, 51.754139),
    (8.042480, 51.754181),
    (8.043120, 51.754459),
    (8.043530, 51.754681),
    (8.043710, 51.754730),
    (8.044050, 51.754761),
    (8.044300, 51.754730),
    (8.044570, 51.754669),
    (8.044940, 51.754539),
    (8.045130, 51.754471),
    (8.046050, 51.754150),
    (8.046150, 51.754108),
    (8.046280, 51.754238),
    (8.046610, 51.754490),
    (8.047370, 51.754860),
    (8.047580, 51.754822),
    (8.048110, 51.754860),
    (8.049910, 51.755081),
    (8.050660, 51.755169),
    (8.051850, 51.755299),
    (8.053010, 51.755428),
    (8.053670, 51.755550),
    (8.054420, 51.755711),
    (8.057820, 51.756500),
    (8.058410, 51.756630),
    (8.061620, 51.757389),
    (8.063310, 51.757771),
    (8.064930, 51.758148),
    (8.065800, 51.758350),
    (8.069010, 51.759102),
    (8.072970, 51.760010),
    (8.074950, 51.760471),
    (8.076230, 51.760830),
    (8.077300, 51.761162),
    (8.078230, 51.761539),
    (8.080850, 51.762711),
    (8.083360, 51.763821),
    (8.087620, 51.765671),
    (8.087780, 51.765739),
    (8.089110, 51.766209),
    (8.092900, 51.767429),
    (8.096570, 51.768620),
    (8.101140, 51.770100),
    (8.107470, 51.772141),
    (8.112800, 51.773289),
    (8.115980, 51.774010),
    (8.116450, 51.774181),
    (8.116860, 51.774330),
    (8.117740, 51.774769),
    (8.120650, 51.776218),
    (8.121550, 51.776680),
    (8.126540, 51.779060),
    (8.127030, 51.779301),
    (8.127730, 51.779560),
    (8.131980, 51.780739),
    (8.143320, 51.783939),
    (8.146170, 51.784988),
    (8.146280, 51.785042),
    (8.150670, 51.786911),
    (8.151920, 51.787479),
    (8.153490, 51.788151),
    (8.158580, 51.790359),
    (8.160190, 51.791050),
    (8.163960, 51.792648),
    (8.167300, 51.794071),
    (8.170160, 51.795219),
    (8.171060, 51.795429),
    (8.171780, 51.795559),
    (8.173490, 51.795891),
    (8.177630, 51.796612),
    (8.178090, 51.796761),
    (8.178500, 51.796951),
    (8.180230, 51.797760),
    (8.181820, 51.798470),
    (8.183500, 51.799229),
    (8.184430, 51.799671),
    (8.184690, 51.799801),
    (8.184910, 51.799900),
    (8.185050, 51.799839),
    (8.185180, 51.799831),
    (8.185330, 51.799858),
    (8.185420, 51.799931),
    (8.185450, 51.800018),
    (8.185390, 51.800121),
    (8.185680, 51.800251),
    (8.186770, 51.800739),
    (8.187870, 51.801231),
    (8.192930, 51.803490),
    (8.194680, 51.804260),
    (8.195030, 51.804329),
    (8.195870, 51.804508),
    (8.196770, 51.804581),
    (8.198000, 51.804588),
    (8.200410, 51.804459),
    (8.200990, 51.804352),
    (8.201580, 51.804241),
    (8.201940, 51.804100),
    (8.202060, 51.804001),
    (8.202160, 51.803928),
    (8.202320, 51.803600),
    (8.202400, 51.803509),
    (8.204240, 51.803741),
    (8.206670, 51.804050),
    (8.207570, 51.804192),
    (8.209340, 51.804409),
    (8.209970, 51.803928),
    (8.210700, 51.803440),
    (8.210900, 51.803379),
    (8.211150, 51.803398),
    (8.211700, 51.803551),
    (8.213170, 51.803982),
    (8.213470, 51.804008),
    (8.215100, 51.803970),
    (8.217450, 51.803822),
    (8.218550, 51.804050),
    (8.218970, 51.804169),
    (8.219110, 51.804291),
    (8.219100, 51.805229),
    (8.219120, 51.805370),
    (8.219200, 51.805489),
    (8.219410, 51.805592),
    (8.219600, 51.805660),
    (8.219840, 51.805721),
    (8.220520, 51.805859),
    (8.222650, 51.806061),
    (8.223920, 51.806332),
    (8.226340, 51.806850),
    (8.228030, 51.807251),
    (8.233910, 51.809799),
    (8.235520, 51.810360),
    (8.238710, 51.811508),
    (8.245180, 51.813759),
    (8.245520, 51.813881),
    (8.245700, 51.813950),
    (8.246720, 51.814301),
    (8.252230, 51.816132),
    (8.253340, 51.816502),
    (8.254550, 51.817162),
    (8.255980, 51.818310),
    (8.257390, 51.819080),
    (8.259960, 51.820148),
    (8.263060, 51.821770),
    (8.263450, 51.821980),
    (8.263980, 51.822250),
    (8.268110, 51.823101),
    (8.272320, 51.824310),
    (8.273230, 51.824570),
    (8.273900, 51.824741),
    (8.274320, 51.824772),
    (8.275260, 51.824760),
    (8.275480, 51.824760),
    (8.277480, 51.824760),
    (8.277720, 51.824791),
    (8.278530, 51.824970),
    (8.278990, 51.825130),
    (8.279130, 51.825180),
    (8.279260, 51.825230),
    (8.279490, 51.825340),
    (8.279590, 51.825390),
    (8.280600, 51.825840),
    (8.281210, 51.826080),
    (8.282110, 51.826488),
    (8.282360, 51.826569),
    (8.284040, 51.826790),
    (8.284590, 51.826859),
    (8.284860, 51.826920),
    (8.285060, 51.826969),
    (8.286180, 51.827351),
    (8.288930, 51.828251),
    (8.290830, 51.828800),
    (8.292060, 51.829128),
    (8.292970, 51.829319),
    (8.293260, 51.829411),
    (8.293590, 51.829571),
    (8.294310, 51.830132),
    (8.294550, 51.830280),
    (8.295090, 51.830551),
    (8.296370, 51.831150),
    (8.296930, 51.831402),
    (8.297880, 51.831749),
    (8.299700, 51.832409),
    (8.300160, 51.832561),
    (8.300550, 51.832680),
    (8.301020, 51.832760),
    (8.301420, 51.832760),
    (8.301820, 51.832668),
    (8.302210, 51.833179),
    (8.304430, 51.832668),
    (8.304610, 51.832909),
    (8.304800, 51.833061),
    (8.304910, 51.833141),
    (8.304990, 51.833191),
    (8.305300, 51.833382),
    (8.305490, 51.833340),
    (8.305730, 51.833328),
    (8.305920, 51.833328),
    (8.306210, 51.833340),
    (8.306320, 51.833340),
    (8.306600, 51.833340),
    (8.306790, 51.833340),
    (8.306990, 51.833328),
    (8.307110, 51.833328),
    (8.307480, 51.833340),
    (8.307570, 51.833340),
    (8.307880, 51.833340),
    (8.308470, 51.833370),
    (8.308810, 51.833561),
    (8.308920, 51.833679),
    (8.309780, 51.833500),
    (8.310000, 51.833790),
    (8.310250, 51.834110),
    (8.310310, 51.834110),
    (8.310930, 51.833961),
    (8.310940, 51.833939),
    (8.310950, 51.833920),
    (8.312010, 51.833641),
    (8.312150, 51.833832),
    (8.312330, 51.834000),
    (8.312380, 51.834049),
    (8.312850, 51.834480),
    (8.313140, 51.834740),
    (8.313460, 51.835030),
    (8.313780, 51.835419),
    (8.313880, 51.835991),
    (8.313880, 51.836102),
    (8.313880, 51.836159),
    (8.313910, 51.836609),
    (8.313960, 51.837311),
    (8.314110, 51.837730),
    (8.314190, 51.837841),
    (8.314270, 51.837990),
    (8.314310, 51.838051),
    (8.314500, 51.838390),
    (8.315100, 51.838341),
    (8.315530, 51.838280),
    (8.315910, 51.838390),
    (8.316360, 51.838699),
    (8.316840, 51.839069),
    (8.317490, 51.839550),
    (8.317740, 51.839699),
    (8.319500, 51.839882),
    (8.319940, 51.839920),
    (8.320830, 51.840000),
    (8.322010, 51.840099),
    (8.322720, 51.840191),
    (8.323100, 51.840260),
    (8.326350, 51.840881),
    (8.331460, 51.841850),
    (8.332570, 51.842030),
    (8.334530, 51.842220),
    (8.334900, 51.842270),
    (8.335250, 51.842331),
    (8.336490, 51.842640),
    (8.337130, 51.842770),
    (8.337550, 51.842831),
    (8.338640, 51.842991),
    (8.339870, 51.843151),
    (8.340000, 51.843170),
    (8.342370, 51.843498),
    (8.343420, 51.843632),
    (8.343830, 51.843719),
    (8.344430, 51.843948),
    (8.348190, 51.845570),
    (8.351180, 51.846859),
    (8.354450, 51.848259),
    (8.357140, 51.849411),
    (8.357500, 51.849529),
    (8.357820, 51.849621),
    (8.358150, 51.849682),
    (8.358480, 51.849720),
    (8.359200, 51.849739),
    (8.362050, 51.849751),
    (8.364060, 51.849770),
    (8.366050, 51.849789),
    (8.366690, 51.849838),
    (8.366800, 51.849861),
    (8.366930, 51.849880),
    (8.367330, 51.849941),
    (8.369150, 51.850311),
    (8.370110, 51.850498),
    (8.370420, 51.850559),
    (8.370690, 51.850590),
    (8.370860, 51.850620),
    (8.371020, 51.850632),
    (8.371280, 51.850651),
    (8.371760, 51.850651),
    (8.372970, 51.850651),
    (8.373480, 51.850651),
    (8.376830, 51.850700),
    (8.378320, 51.850731),
    (8.378650, 51.850750),
    (8.378980, 51.850800),
    (8.381890, 51.851311),
    (8.381980, 51.851330),
    (8.384680, 51.851799),
    (8.387510, 51.852299),
    (8.388060, 51.852402),
    (8.388340, 51.852470),
    (8.388610, 51.852551),
    (8.391920, 51.853748),
    (8.397420, 51.855751),
    (8.397740, 51.855839),
    (8.398750, 51.856030),
    (8.403170, 51.856819),
    (8.403480, 51.856861),
    (8.403920, 51.856869),
    (8.407030, 51.856861),
    (8.407610, 51.856869),
    (8.407990, 51.856899),
    (8.410130, 51.857090),
    (8.410710, 51.857140),
    (8.411710, 51.857231),
    (8.414270, 51.857460),
    (8.416270, 51.857639),
    (8.416630, 51.857712),
    (8.417000, 51.857819),
    (8.417940, 51.858158),
    (8.418790, 51.858471),
    (8.418920, 51.858509),
    (8.420170, 51.858971),
    (8.421200, 51.859341),
    (8.422890, 51.859970),
    (8.423710, 51.860271),
    (8.424130, 51.860409),
    (8.424570, 51.860500),
    (8.424870, 51.860538),
    (8.425230, 51.860561),
    (8.425740, 51.860561),
    (8.426250, 51.860531),
    (8.426700, 51.860500),
    (8.427130, 51.860451),
    (8.427610, 51.860371),
    (8.428520, 51.860241),
    (8.429000, 51.860168),
    (8.431540, 51.859791),
    (8.431700, 51.859779),
    (8.432090, 51.859741),
    (8.433930, 51.859600),
    (8.434120, 51.859581),
    (8.435800, 51.859459),
    (8.436930, 51.859451),
    (8.437920, 51.859440),
    (8.438160, 51.859440),
    (8.439580, 51.859440),
    (8.440450, 51.859440),
    (8.441770, 51.859440),
    (8.442310, 51.859440),
    (8.442520, 51.859440),
    (8.443110, 51.859440),
    (8.444330, 51.859482),
    (8.444320, 51.859550),
    (8.444300, 51.859821),
    (8.444360, 51.859940),
    (8.445190, 51.860340),
    (8.445510, 51.860470),
    (8.445930, 51.860668),
    (8.446350, 51.860760),
    (8.447640, 51.861012),
    (8.447770, 51.861012),
    (8.447820, 51.861210),
    (8.448240, 51.862949),
    (8.448450, 51.863411),
    (8.448790, 51.863918),
    (8.449210, 51.864609),
    (8.449510, 51.865040),
    (8.450180, 51.866051),
    (8.451420, 51.865978),
    (8.452740, 51.865910),
    (8.458410, 51.866001),
    (8.459560, 51.866009),
    (8.459790, 51.866058),
    (8.464610, 51.867168),
    (8.465220, 51.867310),
    (8.465400, 51.867359),
    (8.468020, 51.868679),
    (8.470760, 51.869999),
    (8.471910, 51.870548),
    (8.474170, 51.871670),
    (8.475480, 51.872280),
    (8.475780, 51.872440),
    (8.477090, 51.873089),
    (8.477390, 51.873329),
    (8.477640, 51.873562),
    (8.477860, 51.873711),
    (8.479590, 51.874550),
    (8.480480, 51.874908),
    (8.481920, 51.875641),
    (8.482000, 51.875710),
    (8.483130, 51.875851),
    (8.486430, 51.876122),
    (8.487630, 51.876492),
    (8.488870, 51.876911),
    (8.489750, 51.877121),
    (8.491130, 51.877609),
    (8.491310, 51.877659),
    (8.491280, 51.877781),
    (8.491240, 51.877991),
    (8.491210, 51.878201),
    (8.491120, 51.878490),
    (8.491030, 51.878841),
    (8.490790, 51.879719),
    (8.491030, 51.879749),
    (8.491690, 51.879829),
    (8.491950, 51.879848),
    (8.492220, 51.879871),
    (8.492920, 51.879921),
    (8.493690, 51.879959),
    (8.494240, 51.879990),
    (8.495600, 51.880070),
    (8.496850, 51.880131),
    (8.499040, 51.880260),
    (8.500740, 51.880348),
    (8.501400, 51.880409),
    (8.501860, 51.880482),
    (8.502230, 51.880569),
    (8.502590, 51.880692),
    (8.502870, 51.880779),
    (8.503800, 51.881119),
    (8.503990, 51.881210),
    (8.504370, 51.881371),
    (8.504570, 51.881458),
    (8.505290, 51.881760),
    (8.505580, 51.881821),
    (8.505850, 51.881882),
    (8.506190, 51.881920),
    (8.506350, 51.881939),
    (8.506700, 51.881969),
    (8.507870, 51.882030),
    (8.508340, 51.882030),
    (8.509350, 51.882000),
    (8.509590, 51.881989),
    (8.510730, 51.881908),
    (8.510820, 51.881901),
    (8.511370, 51.881859),
    (8.511710, 51.881840),
    (8.513150, 51.881721),
    (8.513300, 51.881710),
    (8.513750, 51.881710),
    (8.515440, 51.881599),
    (8.516330, 51.881531),
    (8.516850, 51.881500),
    (8.518100, 51.881420),
    (8.519050, 51.881359),
    (8.519660, 51.881310),
    (8.519890, 51.881302),
    (8.520010, 51.881310),
    (8.520150, 51.881329),
    (8.520290, 51.881371),
    (8.520390, 51.881420),
    (8.520550, 51.881512),
    (8.520720, 51.881592),
    (8.520860, 51.881630),
    (8.521410, 51.881699),
    (8.521490, 51.881741),
    (8.521540, 51.881779),
    (8.521560, 51.881821),
    (8.521570, 51.881870),
    (8.521460, 51.882339),
    (8.522850, 51.882511),
    (8.526480, 51.882648),
    (8.527450, 51.882721),
    (8.528830, 51.882740),
    (8.530820, 51.881618),
    (8.531290, 51.881481),
    (8.532660, 51.881279),
    (8.536980, 51.880810),
    (8.537210, 51.880779),
    (8.538730, 51.880329),
    (8.539450, 51.880112),
    (8.540330, 51.880001),
    (8.541270, 51.879929),
    (8.542050, 51.879971),
    (8.542970, 51.880192),
    (8.543830, 51.880360),
    (8.544810, 51.880508),
    (8.545340, 51.880562),
    (8.545820, 51.880589),
    (8.546280, 51.880550),
    (8.546870, 51.880169),
    (8.547560, 51.879860),
    (8.548480, 51.879871),
    (8.549540, 51.879879),
    (8.550350, 51.879829),
    (8.550940, 51.879639),
    (8.551310, 51.879391),
    (8.555000, 51.880360),
    (8.555960, 51.880600),
    (8.557420, 51.880970),
    (8.557610, 51.881008),
    (8.558270, 51.881149),
    (8.559230, 51.881329),
    (8.565740, 51.882408),
    (8.567580, 51.882710),
    (8.572110, 51.883461),
    (8.573590, 51.883621),
    (8.574620, 51.883709),
    (8.575280, 51.883789),
    (8.576080, 51.883862),
    (8.578400, 51.884090),
    (8.580020, 51.884258),
    (8.580310, 51.884289),
    (8.582600, 51.884541),
    (8.582870, 51.884560),
    (8.583910, 51.884640),
    (8.584100, 51.884579),
    (8.584470, 51.884949),
    (8.585300, 51.885689),
    (8.585710, 51.886082),
    (8.587160, 51.887402),
    (8.587330, 51.887569),
    (8.587470, 51.887779),
    (8.588090, 51.888840),
    (8.588440, 51.889290),
    (8.588960, 51.889729),
    (8.589830, 51.890282),
    (8.590700, 51.890850),
    (8.592240, 51.891869),
    (8.592490, 51.892071),
    (8.594910, 51.893921),
    (8.595860, 51.894650),
    (8.596980, 51.895500),
    (8.598520, 51.896709),
    (8.598640, 51.896648),
    (8.599290, 51.896358),
    (8.600690, 51.896259),
    (8.601790, 51.896370),
    (8.602870, 51.896839),
    (8.603510, 51.897400),
    (8.603620, 51.897621),
    (8.603800, 51.897980),
    (8.603940, 51.898369),
    (8.603970, 51.898430),
    (8.604100, 51.898602),
    (8.604260, 51.898819),
    (8.605360, 51.899639),
    (8.606920, 51.900452),
    (8.607170, 51.900539),
    (8.607520, 51.900669),
    (8.608610, 51.900799),
    (8.608950, 51.900841),
    (8.610280, 51.900990),
    (8.611790, 51.901161),
    (8.611840, 51.901089),
    (8.611930, 51.901070),
    (8.612000, 51.901112),
    (8.612030, 51.901180),
    (8.613270, 51.901260),
    (8.613610, 51.901291),
    (8.614560, 51.901340),
    (8.615340, 51.901371),
    (8.616340, 51.901440),
    (8.616390, 51.901440),
    (8.616900, 51.901470),
    (8.617690, 51.901489),
    (8.618560, 51.901550),
    (8.618590, 51.901550),
    (8.619070, 51.901581),
    (8.619760, 51.901588),
    (8.619950, 51.901588),
    (8.621270, 51.901600),
    (8.623390, 51.901600),
    (8.624270, 51.901600),
    (8.625220, 51.901600),
    (8.625850, 51.901600),
    (8.627590, 51.901630),
    (8.628930, 51.901669),
    (8.629200, 51.901661),
    (8.630150, 51.901669),
    (8.631770, 51.901649),
    (8.633190, 51.901630),
    (8.634040, 51.901730),
    (8.634780, 51.901989),
    (8.635500, 51.902351),
    (8.635840, 51.902630),
    (8.635990, 51.902611),
    (8.636140, 51.902649),
    (8.636210, 51.902760),
    (8.636150, 51.902870),
    (8.636470, 51.903069),
    (8.637370, 51.903461),
    (8.637750, 51.903629),
    (8.638560, 51.903980),
    (8.638810, 51.904091),
    (8.639920, 51.904560),
    (8.641050, 51.904980),
    (8.641370, 51.905060),
    (8.641500, 51.905090),
    (8.642630, 51.905361),
    (8.643820, 51.905830),
    (8.644730, 51.906212),
    (8.644850, 51.906231),
    (8.647180, 51.906860),
    (8.648900, 51.907379),
    (8.649500, 51.907532),
    (8.652670, 51.908401),
    (8.653380, 51.908581),
    (8.653540, 51.908470),
    (8.653800, 51.908360),
    (8.654130, 51.908249),
    (8.654450, 51.908211),
    (8.654830, 51.908272),
    (8.656270, 51.908569),
    (8.656410, 51.908611),
    (8.656970, 51.908760),
    (8.657580, 51.908890),
    (8.659170, 51.909309),
    (8.660210, 51.909580),
    (8.661010, 51.909760),
    (8.662160, 51.909859),
    (8.662770, 51.909950),
    (8.663270, 51.909489),
    (8.663240, 51.909409),
    (8.663250, 51.909340),
    (8.663310, 51.909302),
    (8.663400, 51.909290),
    (8.663530, 51.909309),
    (8.663600, 51.909409),
    (8.663810, 51.909382),
    (8.664400, 51.909222),
    (8.664860, 51.909222),
    (8.665170, 51.909279),
    (8.665820, 51.909401),
    (8.666340, 51.909409),
    (8.666850, 51.909340),
    (8.667100, 51.909290),
    (8.667660, 51.909180),
    (8.668190, 51.909142),
    (8.668820, 51.909241),
    (8.669560, 51.909439),
    (8.670410, 51.909538),
    (8.671440, 51.909439),
    (8.673440, 51.909168),
    (8.676970, 51.908718),
    (8.678260, 51.908531),
    (8.680700, 51.908119),
    (8.683090, 51.907570),
    (8.683850, 51.907360),
    (8.683930, 51.907330),
    (8.683940, 51.907219),
    (8.684040, 51.907131),
    (8.684220, 51.907120),
    (8.684340, 51.907211),
    (8.685080, 51.906952),
    (8.686120, 51.906601),
    (8.688420, 51.905651),
    (8.688800, 51.905472),
    (8.692020, 51.903961),
    (8.693180, 51.903450),
    (8.694460, 51.902988),
    (8.696320, 51.902660),
    (8.697910, 51.902649),
    (8.698210, 51.902641),
    (8.699280, 51.902840),
    (8.699380, 51.902851),
    (8.700250, 51.903049),
    (8.702220, 51.903519),
    (8.702370, 51.903561),
    (8.703170, 51.903709),
    (8.704200, 51.903721),
    (8.705700, 51.903702),
    (8.708280, 51.903660),
    (8.709170, 51.903702),
    (8.709530, 51.903721),
    (8.710630, 51.903881),
    (8.711230, 51.903961),
    (8.712360, 51.904190),
    (8.716750, 51.905090),
    (8.717140, 51.905201),
    (8.717460, 51.905289),
    (8.717730, 51.905418),
    (8.718630, 51.905842),
    (8.721820, 51.907879),
    (8.723350, 51.909081),
    (8.723950, 51.908852),
    (8.724400, 51.908710),
    (8.724760, 51.908600),
    (8.725310, 51.908440),
    (8.725890, 51.908321),
    (8.727020, 51.908150),
    (8.728910, 51.907879),
    (8.729970, 51.907768),
    (8.732130, 51.907600),
    (8.732640, 51.907490),
    (8.732890, 51.907360),
    (8.733860, 51.907532),
    (8.735160, 51.907761),
    (8.735370, 51.907810),
    (8.736600, 51.908051),
    (8.736780, 51.908089),
    (8.737430, 51.908230),
    (8.737930, 51.908340),
    (8.737950, 51.908329),
    (8.738000, 51.908310),
    (8.738050, 51.908298),
    (8.738190, 51.908199),
    (8.738510, 51.908180),
    (8.741390, 51.907990),
    (8.742720, 51.907902),
    (8.743200, 51.907871),
    (8.746060, 51.907909),
    (8.746800, 51.907921),
    (8.748460, 51.907928),
    (8.750070, 51.907810),
    (8.754740, 51.907471),
    (8.754900, 51.907459),
    (8.755680, 51.907391),
    (8.757550, 51.907230),
    (8.758370, 51.907150),
    (8.759910, 51.907009),
    (8.762270, 51.906830),
    (8.762710, 51.906792),
    (8.763510, 51.906712),
    (8.764450, 51.906639),
    (8.765460, 51.906590),
    (8.766410, 51.906509),
    (8.767350, 51.906429),
    (8.768100, 51.906330),
    (8.769060, 51.906361),
    (8.770420, 51.906471),
    (8.772600, 51.906609),
    (8.774440, 51.907330),
    (8.775530, 51.908199),
    (8.777360, 51.909679),
    (8.779380, 51.911308),
    (8.779830, 51.911770),
    (8.780060, 51.912209),
    (8.780170, 51.912601),
    (8.780190, 51.912998),
    (8.780210, 51.913410),
    (8.780590, 51.913490),
    (8.780680, 51.913490),
    (8.780830, 51.913250),
    (8.781900, 51.913460),
    (8.782600, 51.913540),
    (8.787000, 51.914181),
    (8.787180, 51.914211),
    (8.788950, 51.914410),
    (8.791140, 51.914669),
    (8.792130, 51.914780),
    (8.793250, 51.914890),
    (8.793330, 51.914902),
    (8.793370, 51.914909),
    (8.793590, 51.915039),
    (8.794420, 51.915459),
    (8.795490, 51.916000),
    (8.795770, 51.916161),
    (8.795910, 51.916260),
    (8.796390, 51.916821),
    (8.796540, 51.917000),
    (8.798400, 51.919182),
    (8.798540, 51.919361),
    (8.798720, 51.919479),
    (8.798820, 51.919521),
    (8.798960, 51.919609),
    (8.799260, 51.919731),
    (8.799750, 51.919891),
    (8.800800, 51.920212),
    (8.801180, 51.920330),
    (8.801600, 51.920460),
    (8.801820, 51.920509),
    (8.801980, 51.920559),
    (8.802140, 51.920601),
    (8.802400, 51.920650),
    (8.802590, 51.920670),
    (8.802920, 51.920650),
    (8.804250, 51.920540),
    (8.805520, 51.920441),
    (8.806030, 51.920399),
    (8.806290, 51.920391),
    (8.806590, 51.920399),
    (8.808060, 51.920502),
    (8.809390, 51.920570),
    (8.809660, 51.920609),
    (8.811790, 51.920738),
    (8.812130, 51.920761),
    (8.812200, 51.920761),
    (8.812390, 51.920780),
    (8.812460, 51.920780),
    (8.813160, 51.920830),
    (8.815240, 51.920990),
    (8.815610, 51.921021),
    (8.816160, 51.921101),
    (8.816600, 51.921219),
    (8.817000, 51.921349),
    (8.817530, 51.921619),
    (8.818070, 51.921890),
    (8.818560, 51.922112),
    (8.818960, 51.922249),
    (8.819170, 51.922329),
    (8.819740, 51.922482),
    (8.820170, 51.922569),
    (8.821210, 51.922729),
    (8.822260, 51.922901),
    (8.823500, 51.923100),
    (8.824140, 51.923260),
    (8.825760, 51.923752),
    (8.826460, 51.923939),
    (8.827850, 51.924191),
    (8.828910, 51.924351),
    (8.829250, 51.924389),
    (8.829680, 51.924400),
    (8.829870, 51.924389),
    (8.830250, 51.924351),
    (8.830630, 51.924290),
    (8.831010, 51.924198),
    (8.831470, 51.924080),
    (8.832270, 51.923931),
    (8.832680, 51.923870),
    (8.833070, 51.923851),
    (8.834230, 51.923889),
    (8.834380, 51.923981),
    (8.836620, 51.925449),
    (8.837110, 51.925819),
    (8.837490, 51.926281),
    (8.837840, 51.926708),
    (8.837990, 51.926739),
    (8.838050, 51.926849),
    (8.838170, 51.927010),
    (8.838350, 51.927231),
    (8.838440, 51.927410),
    (8.838590, 51.927689),
    (8.838720, 51.927952),
    (8.838760, 51.928101),
    (8.838770, 51.928230),
    (8.838840, 51.928322),
    (8.839100, 51.928612),
    (8.839600, 51.928959),
    (8.839980, 51.929062),
    (8.840170, 51.929111),
    (8.841150, 51.929230),
    (8.841760, 51.929501),
    (8.842120, 51.929760),
    (8.842330, 51.929890),
    (8.842630, 51.930111),
    (8.843480, 51.930630),
    (8.843790, 51.930672),
    (8.844380, 51.931030),
    (8.845170, 51.931461),
    (8.846540, 51.932110),
    (8.846940, 51.932301),
    (8.847230, 51.932320),
    (8.847810, 51.932251),
    (8.848400, 51.932140),
    (8.849010, 51.931999),
    (8.849170, 51.931961),
    (8.850030, 51.931679),
    (8.851220, 51.931290),
    (8.852020, 51.931099),
    (8.852370, 51.931141),
    (8.852660, 51.931271),
    (8.852830, 51.931301),
    (8.852930, 51.931320),
    (8.853000, 51.931309),
    (8.853090, 51.931229),
    (8.853730, 51.931492),
    (8.854450, 51.931648),
    (8.855140, 51.931789),
    (8.856540, 51.932030),
    (8.857110, 51.932049),
    (8.858320, 51.932110),
    (8.859910, 51.932159),
    (8.860750, 51.932178),
    (8.861990, 51.932190),
    (8.864280, 51.932110),
    (8.864710, 51.932152),
    (8.864980, 51.932220),
    (8.866450, 51.932831),
    (8.866580, 51.932899),
    (8.867640, 51.933590),
    (8.868190, 51.933899),
    (8.868450, 51.934040),
    (8.869190, 51.934490),
    (8.869670, 51.934750),
    (8.869840, 51.934818),
    (8.870480, 51.935211),
    (8.870720, 51.935390),
    (8.870860, 51.935589),
    (8.870960, 51.935589),
    (8.871150, 51.935589),
    (8.871580, 51.935631),
    (8.871530, 51.935871),
    (8.871810, 51.936581),
    (8.871990, 51.937069),
    (8.872130, 51.937401),
    (8.872190, 51.937550),
    (8.872340, 51.937920),
    (8.872370, 51.937969),
    (8.872530, 51.938370),
    (8.872610, 51.938358),
    (8.872720, 51.938339),
    (8.872860, 51.938320),
    (8.874110, 51.938160),
    (8.874850, 51.938061),
    (8.875130, 51.938770),
    (8.875300, 51.939209),
    (8.875400, 51.939491),
    (8.875430, 51.939571),
    (8.875520, 51.939800),
    (8.875780, 51.940479),
    (8.876020, 51.940430),
    (8.876440, 51.940350),
    (8.876590, 51.940311),
    (8.876810, 51.940250),
    (8.877180, 51.940140),
    (8.878120, 51.939941),
    (8.878970, 51.939751),
    (8.879080, 51.939720),
    (8.879340, 51.939678),
    (8.879720, 51.939621),
    (8.880550, 51.939411),
    (8.880820, 51.939289),
    (8.881450, 51.939739),
    (8.882250, 51.940269),
    (8.882970, 51.940842),
    (8.883740, 51.940620),
    (8.884710, 51.940361),
    (8.884950, 51.940319),
    (8.885910, 51.941521),
    (8.885930, 51.941559),
    (8.885980, 51.941551),
    (8.886000, 51.941559),
    (8.886020, 51.941559),
    (8.886060, 51.941540),
    (8.886740, 51.941059),
    (8.887510, 51.940552),
    (8.887900, 51.940289),
    (8.888430, 51.940521),
    (8.888950, 51.940689),
    (8.889830, 51.940960),
    (8.890710, 51.941151),
    (8.890980, 51.941250),
    (8.891310, 51.941559),
    (8.891810, 51.942188),
    (8.892230, 51.942848),
    (8.892350, 51.943001),
    (8.892780, 51.943329),
    (8.893040, 51.943451),
    (8.893250, 51.943569),
    (8.894240, 51.944118),
    (8.895010, 51.944599),
    (8.895500, 51.944889),
    (8.895880, 51.945110),
    (8.896630, 51.945541),
    (8.896750, 51.945610),
    (8.897980, 51.946320),
    (8.898020, 51.946350),
    (8.898800, 51.946819),
    (8.898860, 51.946812),
    (8.898900, 51.946812),
    (8.898960, 51.946819),
    (8.898990, 51.946838),
    (8.899020, 51.946869),
    (8.899040, 51.946911),
    (8.899020, 51.946960),
    (8.898990, 51.946980),
    (8.899210, 51.947109),
    (8.899570, 51.947281),
    (8.899980, 51.947399),
    (8.900440, 51.947609),
    (8.901160, 51.947491),
    (8.903800, 51.946941),
    (8.904860, 51.946690),
    (8.905440, 51.946499),
    (8.906870, 51.945911),
    (8.906970, 51.945850),
    (8.907760, 51.945450),
    (8.908530, 51.945160),
    (8.909690, 51.944851),
    (8.912460, 51.944141),
    (8.912650, 51.944431),
    (8.912920, 51.944641),
    (8.913320, 51.944752),
    (8.913650, 51.944820),
    (8.914890, 51.944939),
    (8.916690, 51.945190),
    (8.917900, 51.945450),
    (8.919110, 51.945801),
    (8.919560, 51.945961),
    (8.920310, 51.946201),
    (8.920630, 51.946320),
    (8.921980, 51.946831),
    (8.922580, 51.947121),
    (8.922700, 51.947189),
    (8.924140, 51.948002),
    (8.925360, 51.948841),
    (8.925910, 51.949299),
    (8.926340, 51.949730),
    (8.927230, 51.950790),
    (8.927510, 51.951229),
    (8.927610, 51.951370),
    (8.928110, 51.951340),
    (8.928780, 51.951530),
    (8.929290, 51.952171),
    (8.929440, 51.952888),
    (8.931010, 51.954929),
    (8.934300, 51.956890),
    (8.935750, 51.956989),
    (8.936330, 51.956989),
    (8.937620, 51.956902),
    (8.937900, 51.956871),
    (8.938690, 51.956749),
    (8.939140, 51.956680),
    (8.940520, 51.956532),
    (8.941660, 51.956501),
    (8.942960, 51.956650),
    (8.944280, 51.956909),
    (8.945480, 51.957218),
    (8.948040, 51.957970),
    (8.948480, 51.958038),
    (8.948690, 51.958069),
    (8.949790, 51.958080),
    (8.951740, 51.958000),
    (8.952180, 51.958000),
    (8.952260, 51.958000),
    (8.954150, 51.958019),
    (8.955560, 51.958111),
    (8.956100, 51.958111),
    (8.956180, 51.958149),
    (8.957250, 51.958569),
    (8.957880, 51.958889),
    (8.958400, 51.959202),
    (8.958940, 51.959461),
    (8.960180, 51.959751),
    (8.960860, 51.959862),
    (8.960910, 51.959862),
    (8.961630, 51.959831),
    (8.961870, 51.959789),
    (8.963140, 51.959431),
    (8.963640, 51.959259),
    (8.965080, 51.958691),
    (8.965750, 51.958389),
    (8.966970, 51.957741),
    (8.968310, 51.957130),
    (8.973130, 51.955120),
    (8.973610, 51.954929),
    (8.973760, 51.954929),
    (8.973770, 51.954929),
    (8.973900, 51.954979),
    (8.974020, 51.955139),
    (8.974100, 51.955601),
    (8.974190, 51.955849),
    (8.974270, 51.955921),
    (8.974350, 51.955971),
    (8.974540, 51.956020),
    (8.974720, 51.956039),
    (8.975070, 51.956020),
    (8.975590, 51.956039),
    (8.976130, 51.956108),
    (8.978040, 51.956371),
    (8.978660, 51.956409),
    (8.980740, 51.956409),
    (8.985680, 51.956402),
    (8.988110, 51.956390),
    (8.988790, 51.956379),
    (8.989320, 51.956429),
    (8.991520, 51.956638),
    (8.993410, 51.956821),
    (8.994130, 51.956951),
    (8.995250, 51.957359),
    (8.995550, 51.957420),
    (8.995820, 51.957420),
    (8.996480, 51.957272),
    (8.996840, 51.957230),
    (8.997340, 51.957249),
    (8.997570, 51.957249),
    (8.998020, 51.957279),
    (8.998640, 51.957352),
    (8.998810, 51.957359),
    (8.999350, 51.957310),
    (8.999670, 51.957241),
    (8.999750, 51.957211),
    (9.000040, 51.957088),
    (9.000180, 51.956940),
    (9.000270, 51.956680),
    (9.000430, 51.956558),
    (9.001530, 51.956390),
    (9.001960, 51.956360),
    (9.002410, 51.956379),
    (9.003530, 51.956558),
    (9.003950, 51.956692),
    (9.004300, 51.956871),
    (9.004880, 51.957390),
    (9.005840, 51.958260),
    (9.006710, 51.959049),
    (9.008460, 51.960640),
    (9.009380, 51.961460),
    (9.009440, 51.961479),
    (9.010470, 51.962250),
    (9.011320, 51.962799),
    (9.012460, 51.963421),
    (9.012610, 51.963501),
    (9.014000, 51.964169),
    (9.015120, 51.964630),
    (9.016080, 51.964970),
    (9.016630, 51.965130),
    (9.017260, 51.965328),
    (9.018160, 51.965561),
    (9.019040, 51.965759),
    (9.020040, 51.965950),
    (9.021020, 51.966099),
    (9.022090, 51.966240),
    (9.023410, 51.966358),
    (9.024970, 51.966461),
    (9.025740, 51.966511),
    (9.026520, 51.966549),
    (9.027220, 51.966629),
    (9.028230, 51.966721),
    (9.029300, 51.966831),
    (9.029820, 51.966919),
    (9.031090, 51.967121),
    (9.031480, 51.967190),
    (9.032360, 51.967361),
    (9.033370, 51.967590),
    (9.035860, 51.968239),
    (9.039070, 51.969460),
    (9.041180, 51.970558),
    (9.041930, 51.971191),
    (9.042370, 51.971691),
    (9.042970, 51.972641),
    (9.044110, 51.973431),
    (9.044790, 51.973991),
    (9.045420, 51.974602),
    (9.045800, 51.974850),
    (9.046270, 51.975010),
    (9.046770, 51.975060),
    (9.047290, 51.975029),
    (9.048360, 51.974880),
    (9.048890, 51.974838),
    (9.049410, 51.974850),
    (9.050440, 51.974972),
    (9.050870, 51.975101),
    (9.051650, 51.975498),
    (9.051790, 51.975590),
    (9.052150, 51.975842),
    (9.055370, 51.978439),
    (9.055730, 51.978691),
    (9.055970, 51.978809),
    (9.056370, 51.978920),
    (9.056840, 51.978970),
    (9.059960, 51.979099),
    (9.060520, 51.979172),
    (9.061720, 51.979420),
    (9.063360, 51.979752),
    (9.063940, 51.979820),
    (9.065730, 51.979801),
    (9.067220, 51.979820),
    (9.067790, 51.979912),
    (9.069170, 51.980251),
    (9.069810, 51.980358),
    (9.070590, 51.980499),
    (9.073670, 51.980869),
    (9.075070, 51.981041),
    (9.076460, 51.981098),
    (9.077910, 51.981159),
    (9.081540, 51.981590),
    (9.082270, 51.981670),
    (9.083600, 51.981812),
    (9.084020, 51.981892),
    (9.084590, 51.982010),
    (9.084940, 51.982121),
    (9.085110, 51.982170),
    (9.085280, 51.982300),
    (9.085480, 51.982460),
    (9.085580, 51.982658),
    (9.085620, 51.983089),
    (9.085530, 51.984020),
    (9.085670, 51.984230),
    (9.085970, 51.984539),
    (9.086990, 51.985439),
    (9.087250, 51.985641),
    (9.088880, 51.986469),
    (9.089490, 51.986980),
    (9.090300, 51.987881),
    (9.092440, 51.988960),
    (9.093740, 51.989849),
    (9.095540, 51.990501),
    (9.096870, 51.990940),
    (9.098910, 51.991020),
    (9.100970, 51.991100),
    (9.101210, 51.991070),
    (9.101620, 51.991032),
    (9.103660, 51.990650),
    (9.104470, 51.990620),
    (9.105130, 51.990822),
    (9.105560, 51.991039),
    (9.106610, 51.991699),
    (9.107020, 51.991539),
    (9.107440, 51.991371),
    (9.107980, 51.991192),
    (9.108270, 51.991112),
    (9.108900, 51.990940),
    (9.109160, 51.990879),
    (9.109680, 51.990761),
    (9.110180, 51.990669),
    (9.110500, 51.990631),
    (9.110640, 51.990631),
    (9.111290, 51.990589),
    (9.112420, 51.990589),
    (9.113060, 51.990601),
    (9.113760, 51.990601),
    (9.114170, 51.990601),
    (9.115000, 51.990608),
    (9.115500, 51.990589),
    (9.115940, 51.990540),
    (9.116350, 51.990459),
    (9.117180, 51.990261),
    (9.117680, 51.990231),
    (9.119810, 51.990330),
    (9.120250, 51.990349),
    (9.120350, 51.990349),
    (9.123520, 51.990269),
    (9.124480, 51.990238),
    (9.124940, 51.990231),
    (9.125700, 51.990150),
    (9.126000, 51.990101),
    (9.126410, 51.990028),
    (9.127030, 51.989922),
    (9.127630, 51.989910),
    (9.128030, 51.989899),
    (9.128680, 51.989891),
    (9.129310, 51.989830),
    (9.129990, 51.989700),
    (9.132880, 51.989010),
    (9.133670, 51.988861),
    (9.134680, 51.988689),
    (9.135670, 51.988579),
    (9.136050, 51.988510),
    (9.136290, 51.988461),
    (9.136480, 51.988392),
    (9.136660, 51.988319),
    (9.136770, 51.988380),
    (9.137040, 51.988571),
    (9.137370, 51.988762),
    (9.137890, 51.988998),
    (9.138030, 51.989052),
    (9.138560, 51.989239),
    (9.139460, 51.989460),
    (9.140160, 51.989559),
    (9.141240, 51.989639),
    (9.142510, 51.989719),
    (9.143170, 51.989761),
    (9.144410, 51.989841),
    (9.145030, 51.989868),
    (9.145630, 51.989910),
    (9.146130, 51.989960),
    (9.146870, 51.989990),
    (9.148020, 51.990101),
    (9.148920, 51.990200),
    (9.149690, 51.990311),
    (9.150280, 51.990410),
    (9.151490, 51.990669),
    (9.152190, 51.990799),
    (9.153070, 51.990971),
    (9.153530, 51.991058),
    (9.154250, 51.991199),
    (9.155020, 51.991360),
    (9.155740, 51.991550),
    (9.157820, 51.992229),
    (9.158310, 51.992470),
    (9.158730, 51.992729),
    (9.159060, 51.992981),
    (9.159500, 51.993290),
    (9.160040, 51.993660),
    (9.160540, 51.994011),
    (9.161230, 51.994492),
    (9.161740, 51.994888),
    (9.162490, 51.995640),
    (9.162760, 51.995899),
    (9.163500, 51.996658),
    (9.163800, 51.997009),
    (9.164050, 51.997440),
    (9.164360, 51.998009),
    (9.164790, 51.998791),
    (9.165070, 51.999290),
    (9.165290, 51.999649),
    (9.165500, 51.999931),
    (9.165930, 52.000381),
    (9.166540, 52.001030),
    (9.166960, 52.001461),
    (9.167190, 52.001690),
    (9.167450, 52.001881),
    (9.167880, 52.002121),
    (9.169230, 52.002800),
    (9.169480, 52.002918),
    (9.169880, 52.003101),
    (9.170390, 52.003281),
    (9.170870, 52.003448),
    (9.171710, 52.003719),
    (9.172240, 52.003811),
    (9.173350, 52.003990),
    (9.174280, 52.004009),
    (9.174620, 52.003990),
    (9.175110, 52.003979),
    (9.175670, 52.004040),
    (9.176330, 52.004181),
    (9.177450, 52.004559),
    (9.178260, 52.004822),
    (9.179220, 52.005119),
    (9.179890, 52.005329),
    (9.180650, 52.005638),
    (9.181780, 52.006168),
    (9.182810, 52.006630),
    (9.183960, 52.007149),
    (9.184940, 52.007599),
    (9.185590, 52.007950),
    (9.186330, 52.008430),
    (9.188160, 52.009640),
    (9.188990, 52.010170),
    (9.189390, 52.010311),
    (9.190770, 52.010750),
    (9.191580, 52.010990),
    (9.193010, 52.011421),
    (9.193870, 52.011681),
    (9.195920, 52.012310),
    (9.196740, 52.012550),
    (9.198020, 52.012951),
    (9.198770, 52.013161),
    (9.199620, 52.013329),
    (9.200940, 52.013531),
    (9.202110, 52.013721),
    (9.203040, 52.013870),
    (9.205250, 52.014210),
    (9.207430, 52.014511),
    (9.207950, 52.014530),
    (9.208400, 52.014530),
    (9.208640, 52.014500),
    (9.209130, 52.014549),
    (9.209500, 52.014660),
    (9.210160, 52.014820),
    (9.210600, 52.014870),
    (9.211050, 52.014839),
    (9.211750, 52.014729),
    (9.211930, 52.014690),
    (9.212330, 52.014599),
    (9.212720, 52.014721),
    (9.212960, 52.014839),
    (9.213170, 52.014961),
    (9.213390, 52.015091),
    (9.213570, 52.015190),
    (9.215030, 52.015991),
    (9.216950, 52.017071),
    (9.218230, 52.017811),
    (9.219460, 52.018589),
    (9.219710, 52.018780),
    (9.219740, 52.018799),
    (9.220990, 52.019779),
    (9.221580, 52.020210),
    (9.222400, 52.020870),
    (9.223160, 52.021549),
    (9.224500, 52.022861),
    (9.224860, 52.023270),
    (9.225280, 52.024261),
    (9.225360, 52.024502),
    (9.225440, 52.024712),
    (9.225520, 52.024891),
    (9.225780, 52.025131),
    (9.226040, 52.025318),
    (9.226650, 52.025681),
    (9.227480, 52.026169),
    (9.227560, 52.026211),
    (9.228310, 52.026669),
    (9.228800, 52.026920),
    (9.228900, 52.027000),
    (9.229280, 52.027290),
    (9.229870, 52.027939),
    (9.230280, 52.028191),
    (9.230740, 52.028389),
    (9.231730, 52.028801),
    (9.232290, 52.029079),
    (9.232800, 52.029339),
    (9.233290, 52.029629),
    (9.233810, 52.029888),
    (9.234330, 52.030079),
    (9.234580, 52.030128),
    (9.234670, 52.030151),
    (9.235700, 52.030312),
    (9.236870, 52.030411),
    (9.237450, 52.030449),
    (9.238000, 52.030548),
    (9.238540, 52.030720),
    (9.238910, 52.030960),
    (9.239010, 52.030991),
    (9.241060, 52.032211),
    (9.241880, 52.032669),
    (9.242110, 52.032810),
    (9.244670, 52.034229),
    (9.245710, 52.034779),
    (9.246680, 52.035309),
    (9.246780, 52.035370),
    (9.247730, 52.035992),
    (9.247940, 52.036129),
    (9.251320, 52.038380),
    (9.252050, 52.038879),
    (9.253550, 52.039902),
    (9.254610, 52.040600),
    (9.255150, 52.041000),
    (9.255210, 52.041039),
    (9.255840, 52.041500),
    (9.256340, 52.041809),
    (9.256530, 52.041931),
    (9.257480, 52.042580),
    (9.258250, 52.043072),
    (9.258390, 52.043159),
    (9.259220, 52.043690),
    (9.259800, 52.044048),
    (9.259980, 52.044270),
    (9.260400, 52.044640),
    (9.260670, 52.045052),
    (9.261040, 52.045681),
    (9.261300, 52.046162),
    (9.261830, 52.046638),
    (9.261960, 52.046799),
    (9.262300, 52.047031),
    (9.262550, 52.047180),
    (9.262850, 52.047409),
    (9.263920, 52.047939),
    (9.264930, 52.048458),
    (9.265070, 52.048550),
    (9.266790, 52.049438),
    (9.267000, 52.049549),
    (9.267500, 52.049900),
    (9.267780, 52.050159),
    (9.268080, 52.050522),
    (9.268360, 52.050812),
    (9.268720, 52.050999),
    (9.269420, 52.051540),
    (9.269860, 52.051861),
    (9.270770, 52.052330),
    (9.271680, 52.052670),
    (9.274810, 52.053719),
    (9.276400, 52.054279),
    (9.277820, 52.054871),
    (9.278700, 52.055191),
    (9.284200, 52.057549),
    (9.284420, 52.057640),
    (9.287080, 52.058788),
    (9.288980, 52.059631),
    (9.289740, 52.059940),
    (9.290310, 52.060169),
    (9.292290, 52.060909),
    (9.294490, 52.061260),
    (9.296530, 52.061501),
    (9.297760, 52.061680),
    (9.298360, 52.061790),
    (9.298890, 52.061932),
    (9.299390, 52.062050),
    (9.300190, 52.062290),
    (9.300960, 52.062592),
    (9.302080, 52.063271),
    (9.302480, 52.063591),
    (9.303400, 52.064449),
    (9.303490, 52.064621),
    (9.303910, 52.065361),
    (9.304040, 52.065632),
    (9.304270, 52.066071),
    (9.304480, 52.066509),
    (9.304810, 52.066849),
    (9.305210, 52.067150),
    (9.305360, 52.067261),
    (9.305470, 52.067341),
    (9.305620, 52.067451),
    (9.305710, 52.067509),
    (9.305840, 52.067600),
    (9.307340, 52.068760),
    (9.308240, 52.069420),
    (9.308410, 52.069530),
    (9.309240, 52.070068),
    (9.309440, 52.070171),
    (9.309930, 52.070351),
    (9.310470, 52.070549),
    (9.311060, 52.070721),
    (9.312150, 52.071030),
    (9.312530, 52.071140),
    (9.312620, 52.071171),
    (9.313930, 52.071609),
    (9.318700, 52.073158),
    (9.325960, 52.075989),
    (9.328320, 52.076908),
    (9.329650, 52.077412),
    (9.330400, 52.077709),
    (9.331120, 52.077969),
    (9.331360, 52.078079),
    (9.332870, 52.078651),
    (9.334440, 52.079269),
    (9.335350, 52.079762),
    (9.335620, 52.079910),
    (9.336530, 52.080421),
    (9.337750, 52.081188),
    (9.343260, 52.084782),
    (9.343390, 52.084850),
    (9.343980, 52.085209),
    (9.346470, 52.086811),
    (9.347240, 52.087170),
    (9.347770, 52.087440),
    (9.348230, 52.087749),
    (9.348810, 52.088211),
    (9.349610, 52.088692),
    (9.349850, 52.088829),
    (9.350270, 52.089062),
    (9.350650, 52.089340),
    (9.350770, 52.089458),
    (9.351040, 52.089729),
    (9.351230, 52.089870),
    (9.351340, 52.089981),
    (9.351560, 52.090191),
    (9.351770, 52.090340),
    (9.351820, 52.090370),
    (9.351930, 52.090439),
    (9.352010, 52.090500),
    (9.352070, 52.090561),
    (9.352110, 52.090660),
    (9.352010, 52.090790),
    (9.351750, 52.091141),
    (9.351690, 52.091339),
    (9.351630, 52.091560),
    (9.351690, 52.091770),
    (9.352020, 52.092541),
    (9.352140, 52.092930),
    (9.352220, 52.093609),
    (9.352310, 52.094769),
    (9.352230, 52.095749),
    (9.352190, 52.095970),
    (9.352040, 52.096512),
    (9.351850, 52.097019),
    (9.351600, 52.097569),
    (9.351190, 52.098301),
    (9.350860, 52.098709),
    (9.350780, 52.098801),
    (9.350480, 52.099121),
    (9.350260, 52.099331),
    (9.350190, 52.099400),
    (9.350070, 52.099522),
    (9.349880, 52.099880),
    (9.349280, 52.100639),
    (9.349090, 52.100910),
    (9.349050, 52.101139),
    (9.349090, 52.101231),
    (9.349160, 52.101280),
    (9.349390, 52.101429),
    (9.349740, 52.101471),
    (9.350130, 52.101570),
    (9.352110, 52.101589),
    (9.352270, 52.101509),
    (9.352690, 52.101501),
    (9.352940, 52.101490),
    (9.353280, 52.101440),
    (9.353340, 52.101429),
    (9.353410, 52.101410),
    (9.353910, 52.101231),
    (9.354300, 52.101101),
    (9.354350, 52.101082),
    (9.354740, 52.100979),
    (9.355080, 52.100891),
    (9.355540, 52.100811),
    (9.355780, 52.100780),
    (9.356000, 52.100761),
    (9.356230, 52.100739),
    (9.356470, 52.100731),
    (9.356840, 52.100731),
    (9.357230, 52.100719),
    (9.357510, 52.100719),
    (9.357830, 52.100739),
    (9.358290, 52.100849),
    (9.358670, 52.100990),
    (9.359430, 52.101379),
    (9.359960, 52.101761),
    (9.360420, 52.102180),
    (9.360490, 52.102261),
    (9.360590, 52.102390),
    (9.360680, 52.102520),
    (9.360890, 52.102840),
    (9.360950, 52.102940),
    (9.361080, 52.103161),
    (9.361160, 52.103340),
    (9.361270, 52.103588),
    (9.361350, 52.103779),
    (9.361550, 52.103970),
    (9.361600, 52.104019),
    (9.361680, 52.104061),
    (9.361840, 52.104111),
    (9.362560, 52.104172),
    (9.362620, 52.104172),
    (9.362730, 52.104172),
    (9.363240, 52.104172),
    (9.364170, 52.104172),
    (9.364620, 52.104172),
    (9.365220, 52.104172),
    (9.365270, 52.104172),
    (9.365990, 52.104141),
    (9.367500, 52.104069),
    (9.368130, 52.104038),
    (9.369640, 52.103951),
    (9.369850, 52.103939),
    (9.370170, 52.103920),
    (9.370430, 52.103909),
    (9.371680, 52.103840),
    (9.372220, 52.103821),
    (9.373130, 52.103779),
    (9.373790, 52.103748),
    (9.374530, 52.103722),
    (9.374780, 52.103710),
    (9.375970, 52.103619),
    (9.376260, 52.103580),
    (9.376670, 52.103561),
    (9.376770, 52.103561),
    (9.376860, 52.103569),
    (9.377070, 52.103580),
    (9.377330, 52.103470),
    (9.377520, 52.103439),
    (9.377590, 52.103401),
    (9.377720, 52.103352),
    (9.377820, 52.103279),
    (9.377970, 52.103180),
    (9.378040, 52.103119),
    (9.378120, 52.102970),
    (9.378160, 52.102871),
    (9.378210, 52.102772),
    (9.378240, 52.102699),
    (9.378250, 52.102661),
    (9.378330, 52.102470),
    (9.378550, 52.102039),
    (9.378580, 52.101990),
    (9.378750, 52.101681),
    (9.378830, 52.101582),
    (9.379010, 52.101372),
    (9.379140, 52.101379),
    (9.379410, 52.101398),
    (9.379690, 52.101452),
    (9.380140, 52.101559),
    (9.380460, 52.101650),
    (9.381570, 52.101891),
    (9.381920, 52.101971),
    (9.383200, 52.102268),
    (9.384070, 52.102451),
    (9.385520, 52.102699),
    (9.385750, 52.102741),
    (9.385900, 52.102772),
    (9.386480, 52.102852),
    (9.387040, 52.102921),
    (9.387250, 52.102909),
    (9.387540, 52.102890),
    (9.387860, 52.102829),
    (9.388380, 52.102631),
    (9.389180, 52.102180),
    (9.389470, 52.102032),
    (9.390400, 52.101490),
    (9.390930, 52.101158),
    (9.391130, 52.101051),
    (9.391440, 52.100868),
    (9.391980, 52.100540),
    (9.392180, 52.100441),
    (9.392410, 52.100349),
    (9.392770, 52.100269),
    (9.392980, 52.100250),
    (9.393060, 52.100250),
    (9.393250, 52.100262),
    (9.393720, 52.100330),
    (9.395060, 52.100609),
    (9.396060, 52.100830),
    (9.396460, 52.100899),
    (9.396820, 52.100948),
    (9.397100, 52.100948),
    (9.397400, 52.100941),
    (9.397720, 52.100922),
    (9.398180, 52.100849),
    (9.398670, 52.100780),
    (9.399540, 52.100639),
    (9.399910, 52.100590),
    (9.400250, 52.100540),
    (9.400540, 52.100521),
    (9.401160, 52.100521),
    (9.401830, 52.100540),
    (9.401950, 52.100540),
    (9.402030, 52.100540),
    (9.402180, 52.100552),
    (9.402250, 52.100552),
    (9.402770, 52.100559),
    (9.403190, 52.100540),
    (9.403590, 52.100491),
    (9.403820, 52.100471),
    (9.404200, 52.100422),
    (9.404600, 52.100391),
    (9.405110, 52.100399),
    (9.406030, 52.100422),
    (9.406740, 52.100422),
    (9.407160, 52.100399),
    (9.407570, 52.100361),
    (9.407940, 52.100319),
    (9.408140, 52.100311),
    (9.409830, 52.100159),
    (9.410390, 52.100128),
    (9.411290, 52.100140),
    (9.412450, 52.100140),
    (9.412750, 52.100151),
    (9.413140, 52.100159),
    (9.413560, 52.100201),
    (9.414340, 52.100311),
    (9.415510, 52.100460),
    (9.416050, 52.100521),
    (9.416930, 52.100651),
    (9.417490, 52.100750),
    (9.418290, 52.100929),
    (9.420060, 52.101349),
    (9.420540, 52.101452),
    (9.421140, 52.101540),
    (9.421770, 52.101631),
    (9.422250, 52.101681),
    (9.422750, 52.101719),
    (9.423530, 52.101761),
    (9.424440, 52.101768),
    (9.425920, 52.101749),
    (9.427500, 52.101711),
    (9.428130, 52.101711),
    (9.428760, 52.101719),
    (9.429460, 52.101749),
    (9.430110, 52.101799),
    (9.430320, 52.101822),
    (9.430540, 52.101841),
    (9.430660, 52.101849),
    (9.431100, 52.101910),
    (9.431930, 52.102039),
    (9.432760, 52.102211),
    (9.433620, 52.102428),
    (9.434210, 52.102612),
    (9.435140, 52.102928),
    (9.436810, 52.103642),
    (9.439350, 52.104671),
    (9.440780, 52.105099),
    (9.443110, 52.105358),
    (9.445260, 52.105339),
    (9.447500, 52.105560),
    (9.448080, 52.105740),
    (9.449500, 52.106190),
    (9.452430, 52.107288),
    (9.453290, 52.107521),
    (9.454020, 52.107658),
    (9.454890, 52.107769),
    (9.455360, 52.107811),
    (9.455880, 52.107811),
    (9.456510, 52.107830),
    (9.458330, 52.107571),
    (9.459790, 52.107368),
    (9.460600, 52.107239),
    (9.462310, 52.107128),
    (9.464340, 52.107269),
    (9.467670, 52.107700),
    (9.469740, 52.107761),
    (9.471840, 52.107479),
    (9.473400, 52.107231),
    (9.476390, 52.106659),
    (9.478230, 52.106491),
    (9.480070, 52.106560),
    (9.480620, 52.106651),
    (9.481020, 52.106720),
    (9.482280, 52.107052),
    (9.483450, 52.107521),
    (9.484140, 52.107929),
    (9.486540, 52.109810),
    (9.488460, 52.111320),
    (9.490280, 52.112000),
    (9.493380, 52.112621),
    (9.499270, 52.113701),
    (9.502160, 52.114201),
    (9.503020, 52.114349),
    (9.505480, 52.114769),
    (9.507090, 52.114948),
    (9.507730, 52.114990),
    (9.510220, 52.115181),
    (9.512210, 52.115292),
    (9.513940, 52.115551),
    (9.515930, 52.115959),
    (9.517330, 52.116390),
    (9.518620, 52.116859),
    (9.527090, 52.120281),
    (9.530070, 52.121460),
    (9.530930, 52.121738),
    (9.531280, 52.121861),
    (9.531880, 52.121979),
    (9.532310, 52.122040),
    (9.533620, 52.121899),
    (9.534560, 52.121731),
    (9.535160, 52.121521),
    (9.535780, 52.121189),
    (9.536470, 52.120831),
    (9.537420, 52.120140),
    (9.538710, 52.119041),
    (9.538990, 52.118820),
    (9.539630, 52.118320),
    (9.540140, 52.118031),
    (9.540770, 52.117920),
    (9.541480, 52.117889),
    (9.542100, 52.118000),
    (9.542830, 52.118130),
    (9.543560, 52.118252),
    (9.544210, 52.118320),
    (9.544880, 52.118382),
    (9.545180, 52.118401),
    (9.545380, 52.118320),
    (9.545520, 52.118290),
    (9.545990, 52.117962),
    (9.546140, 52.117821),
    (9.546500, 52.117538),
    (9.546650, 52.117481),
    (9.547230, 52.117310),
    (9.547850, 52.117310),
    (9.548310, 52.117310),
    (9.549220, 52.117371),
    (9.550030, 52.117611),
    (9.550280, 52.117611),
    (9.550440, 52.117611),
    (9.550680, 52.117619),
    (9.550920, 52.117630),
    (9.551430, 52.117630),
    (9.551760, 52.117619),
    (9.552800, 52.117229),
    (9.556490, 52.115829),
    (9.557680, 52.115341),
    (9.558520, 52.114922),
    (9.559310, 52.114449),
    (9.560550, 52.113621),
    (9.561300, 52.113071),
    (9.562090, 52.112560),
    (9.562740, 52.112160),
    (9.563520, 52.111778),
    (9.564240, 52.111511),
    (9.565020, 52.111271),
    (9.566100, 52.111061),
    (9.566790, 52.110909),
    (9.567500, 52.110691),
    (9.567860, 52.110561),
    (9.568220, 52.110359),
    (9.568580, 52.109859),
    (9.568660, 52.109760),
    (9.569150, 52.109131),
    (9.569550, 52.108669),
    (9.570250, 52.108120),
    (9.570590, 52.107849),
    (9.571350, 52.107090),
    (9.572970, 52.106030),
    (9.573960, 52.105480),
    (9.574290, 52.105251),
    (9.574850, 52.104839),
    (9.575100, 52.104580),
    (9.575380, 52.104321),
    (9.575660, 52.104080),
    (9.576560, 52.103611),
    (9.577230, 52.103298),
    (9.579310, 52.101830),
    (9.580600, 52.100830),
    (9.582080, 52.099400),
    (9.582820, 52.098808),
    (9.583580, 52.098301),
    (9.584710, 52.097698),
    (9.585950, 52.097111),
    (9.587000, 52.096352),
    (9.588790, 52.094769),
    (9.592510, 52.092171),
    (9.593340, 52.091469),
    (9.594270, 52.090530),
    (9.594860, 52.089760),
    (9.595400, 52.088749),
    (9.595830, 52.088230),
    (9.597050, 52.087269),
    (9.598500, 52.086472),
    (9.599180, 52.086109),
    (9.599340, 52.085991),
    (9.600050, 52.085499),
    (9.600650, 52.084999),
    (9.600830, 52.084492),
    (9.601010, 52.084278),
    (9.601290, 52.084061),
    (9.601850, 52.083900),
    (9.602380, 52.083820),
    (9.602820, 52.083832),
    (9.604850, 52.083889),
    (9.607300, 52.084042),
    (9.607700, 52.084061),
    (9.610950, 52.084141),
    (9.613350, 52.084469),
    (9.616770, 52.085072),
    (9.621520, 52.086189),
    (9.626500, 52.087292),
    (9.628230, 52.087700),
    (9.630760, 52.088440),
    (9.631600, 52.088760),
    (9.631920, 52.088860),
    (9.632220, 52.088970),
    (9.633510, 52.089481),
    (9.634050, 52.089809),
    (9.634800, 52.090382),
    (9.635020, 52.090511),
    (9.635210, 52.090561),
    (9.635400, 52.090591),
    (9.637670, 52.090618),
    (9.637870, 52.090618),
    (9.637970, 52.090630),
    (9.639250, 52.090691),
    (9.640370, 52.090889),
    (9.641530, 52.091171),
    (9.643040, 52.091549),
    (9.644490, 52.091930),
    (9.644680, 52.092010),
    (9.645180, 52.092201),
    (9.645930, 52.092449),
    (9.646780, 52.092751),
    (9.647390, 52.092899),
    (9.648540, 52.093109),
    (9.649180, 52.093208),
    (9.649560, 52.093281),
    (9.649760, 52.093330),
    (9.650020, 52.093430),
    (9.650160, 52.093540),
    (9.650270, 52.093620),
    (9.650550, 52.093842),
    (9.650980, 52.093990),
    (9.651740, 52.094090),
    (9.652160, 52.094231),
    (9.653030, 52.094791),
    (9.654240, 52.095570),
    (9.654740, 52.095928),
    (9.656630, 52.097149),
    (9.659270, 52.098869),
    (9.659290, 52.098881),
    (9.660510, 52.099480),
    (9.663510, 52.100609),
    (9.665370, 52.101452),
    (9.666440, 52.102001),
    (9.667510, 52.102440),
    (9.668970, 52.102959),
    (9.669690, 52.103230),
    (9.670600, 52.103569),
    (9.671650, 52.104080),
    (9.672680, 52.104580),
    (9.673320, 52.104820),
    (9.674300, 52.105190),
    (9.675080, 52.105530),
    (9.678510, 52.107071),
    (9.679590, 52.107590),
    (9.680910, 52.108410),
    (9.681770, 52.109268),
    (9.682280, 52.109241),
    (9.682540, 52.109280),
    (9.684210, 52.110130),
    (9.686740, 52.110931),
    (9.688640, 52.111649),
    (9.689830, 52.112209),
    (9.690550, 52.112621),
    (9.693010, 52.113861),
    (9.693210, 52.114159),
    (9.693830, 52.114719),
    (9.694260, 52.115051),
    (9.695090, 52.115051),
    (9.695350, 52.115051),
    (9.697560, 52.115070),
    (9.698450, 52.115200),
    (9.698980, 52.115421),
    (9.699130, 52.115601),
    (9.699370, 52.115841),
    (9.699570, 52.115990),
    (9.700620, 52.116249),
    (9.701120, 52.116421),
    (9.702660, 52.117168),
    (9.703720, 52.117580),
    (9.705080, 52.117970),
    (9.708590, 52.118721),
    (9.708980, 52.118801),
    (9.709120, 52.119160),
    (9.710380, 52.119141),
    (9.711720, 52.119240),
    (9.713990, 52.119598),
    (9.715850, 52.119930),
    (9.717220, 52.120239),
    (9.719210, 52.120720),
    (9.720200, 52.120899),
    (9.722440, 52.121189),
    (9.722560, 52.121208),
    (9.722670, 52.121231),
    (9.726220, 52.122002),
    (9.728550, 52.122551),
    (9.728790, 52.122608),
    (9.731590, 52.123268),
    (9.732880, 52.123379),
    (9.734520, 52.123520),
    (9.736270, 52.123600),
    (9.737150, 52.123680),
    (9.737600, 52.123760),
    (9.738050, 52.123852),
    (9.738330, 52.123920),
    (9.738620, 52.124001),
    (9.738920, 52.124130),
    (9.739730, 52.124580),
    (9.743160, 52.126190),
    (9.746260, 52.128220),
    (9.747150, 52.129299),
    (9.748090, 52.130428),
    (9.748360, 52.130981),
    (9.748400, 52.131401),
    (9.748530, 52.132462),
    (9.748830, 52.134861),
    (9.748930, 52.135109),
    (9.748990, 52.135231),
    (9.749130, 52.135460),
    (9.749660, 52.135960),
    (9.750320, 52.136398),
    (9.752660, 52.137421),
    (9.755910, 52.138870),
    (9.758290, 52.141060),
    (9.761700, 52.144211),
    (9.762230, 52.144562),
    (9.762300, 52.144600),
    (9.762460, 52.144699),
    (9.762630, 52.144810),
    (9.763520, 52.145321),
    (9.765480, 52.146469),
    (9.767290, 52.147079),
    (9.768110, 52.147289),
    (9.767910, 52.147530),
    (9.767790, 52.147781),
    (9.767730, 52.147999),
    (9.767730, 52.148209),
    (9.767770, 52.148411),
    (9.767870, 52.148602),
    (9.767990, 52.148750),
    (9.768060, 52.148941),
    (9.768150, 52.149029),
    (9.768340, 52.149059),
    (9.768880, 52.148998),
    (9.769040, 52.148960),
    (9.769140, 52.148891),
    (9.769220, 52.148800),
    (9.769250, 52.148689),
    (9.769320, 52.148640),
    (9.769450, 52.148609),
    (9.770180, 52.148651),
    (9.770310, 52.148651),
    (9.771160, 52.148750),
    (9.772290, 52.148891),
    (9.772930, 52.148930),
    (9.773510, 52.148930),
    (9.775340, 52.148670),
    (9.777630, 52.148201),
    (9.781770, 52.147739),
    (9.783290, 52.147621),
    (9.787960, 52.149891),
    (9.791240, 52.151211),
    (9.792300, 52.151630),
    (9.792800, 52.151711),
    (9.793240, 52.151680),
    (9.793670, 52.151588),
    (9.794920, 52.151260),
    (9.795140, 52.151199),
    (9.796090, 52.150990),
    (9.796350, 52.150970),
    (9.797150, 52.150990),
    (9.797370, 52.151009),
    (9.797780, 52.151089),
    (9.800790, 52.151791),
    (9.801040, 52.151859),
    (9.801320, 52.151909),
    (9.802260, 52.152130),
    (9.803110, 52.152390),
    (9.804140, 52.152748),
    (9.806500, 52.153580),
    (9.807570, 52.153919),
    (9.808910, 52.154190),
    (9.810200, 52.154339),
    (9.812580, 52.154499),
    (9.813050, 52.154541),
    (9.813650, 52.154659),
    (9.813800, 52.154701),
    (9.814180, 52.154819),
    (9.817120, 52.156151),
    (9.817960, 52.156509),
    (9.818800, 52.156738),
    (9.819770, 52.156929),
    (9.821170, 52.157040),
    (9.825230, 52.156921),
    (9.830120, 52.156719),
    (9.830370, 52.156731),
    (9.832150, 52.156830),
    (9.834290, 52.157108),
    (9.836860, 52.157440),
    (9.837230, 52.157490),
    (9.839890, 52.157841),
    (9.840580, 52.157921),
    (9.842350, 52.158272),
    (9.846100, 52.159031),
    (9.848960, 52.159618),
    (9.850910, 52.159939),
    (9.851850, 52.159981),
    (9.853960, 52.160069),
    (9.855800, 52.160019),
    (9.856100, 52.160000),
    (9.859130, 52.159962),
    (9.863040, 52.159691),
    (9.865840, 52.159370),
    (9.866470, 52.159302),
    (9.868950, 52.158951),
    (9.871000, 52.158611),
    (9.873590, 52.158279),
    (9.878760, 52.158150),
    (9.883940, 52.158661),
    (9.889120, 52.159340),
    (9.892180, 52.159512),
    (9.895160, 52.159550),
    (9.897760, 52.159519),
    (9.898930, 52.159439),
    (9.901990, 52.159111),
    (9.904140, 52.158901),
    (9.904320, 52.158890),
    (9.905080, 52.158760),
    (9.905970, 52.158501),
    (9.906950, 52.158131),
    (9.907420, 52.157890),
    (9.908590, 52.157398),
    (9.909650, 52.157089),
    (9.911350, 52.156849),
    (9.915390, 52.156929),
    (9.915880, 52.156929),
    (9.916710, 52.156910),
    (9.918320, 52.156929),
    (9.920270, 52.156879),
    (9.921500, 52.156830),
    (9.922770, 52.156700),
    (9.923850, 52.156521),
    (9.924650, 52.156311),
    (9.925070, 52.156170),
    (9.925600, 52.155899),
    (9.926740, 52.155369),
    (9.927650, 52.154869),
    (9.928220, 52.154530),
    (9.928980, 52.154190),
    (9.929920, 52.153851),
    (9.930810, 52.153641),
    (9.931470, 52.153561),
    (9.932340, 52.153511),
    (9.933200, 52.153481),
    (9.933680, 52.153469),
    (9.934170, 52.153461),
    (9.934850, 52.153511),
    (9.935110, 52.153561),
    (9.935410, 52.153622),
    (9.935810, 52.153690),
    (9.936290, 52.153782),
    (9.936780, 52.153889),
    (9.937000, 52.153950),
    (9.937330, 52.154011),
    (9.937540, 52.154060),
    (9.938140, 52.154221),
    (9.938880, 52.154400),
    (9.940200, 52.154709),
    (9.940820, 52.154789),
    (9.941160, 52.154819),
    (9.941780, 52.154800),
    (9.942300, 52.154789),
    (9.943200, 52.154770),
    (9.943840, 52.154751),
    (9.944530, 52.154720),
    (9.944810, 52.154709),
    (9.944950, 52.154701),
    (9.945370, 52.154671),
    (9.946350, 52.154640),
    (9.947150, 52.154640),
    (9.947430, 52.154671),
    (9.947880, 52.154758),
    (9.948230, 52.154850),
    (9.948460, 52.154888),
    (9.948580, 52.154919),
    (9.948740, 52.154961),
    (9.949000, 52.155048),
    (9.949270, 52.155128),
    (9.949900, 52.155338),
    (9.950260, 52.155460),
    (9.950580, 52.155560),
    (9.951340, 52.155819),
    (9.951940, 52.156021),
    (9.952480, 52.156189),
    (9.953570, 52.156528),
    (9.954910, 52.156940),
    (9.955590, 52.157188),
    (9.956220, 52.157330),
    (9.956660, 52.157421),
    (9.957040, 52.157478),
    (9.957500, 52.157539),
    (9.958490, 52.157661),
    (9.958650, 52.157681),
    (9.959430, 52.157761),
    (9.960580, 52.157909),
    (9.962280, 52.158089),
    (9.963510, 52.158211),
    (9.963740, 52.158218),
    (9.965700, 52.158371),
    (9.967420, 52.158489),
    (9.967900, 52.158501),
    (9.968400, 52.158501),
    (9.969320, 52.158489),
    (9.970380, 52.158421),
    (9.970740, 52.158390),
    (9.971130, 52.158340),
    (9.971350, 52.158230),
    (9.971430, 52.158051),
    (9.971560, 52.157909),
    (9.971780, 52.157791),
    (9.971950, 52.157730),
    (9.972120, 52.157700),
    (9.972320, 52.157681),
    (9.972580, 52.157711),
    (9.972840, 52.157799),
    (9.972970, 52.157879),
    (9.973100, 52.158001),
    (9.973340, 52.158089),
    (9.973540, 52.158119),
    (9.974840, 52.158039),
    (9.975550, 52.158031),
    (9.976190, 52.158070),
    (9.976830, 52.158119),
    (9.977600, 52.158260),
    (9.978540, 52.158508),
    (9.980470, 52.159050),
    (9.983470, 52.159870),
    (9.984340, 52.160110),
    (9.985340, 52.160412),
    (9.986770, 52.160782),
    (9.987150, 52.160851),
    (9.988110, 52.161030),
    (9.988750, 52.161129),
    (9.989600, 52.161240),
    (9.990610, 52.161331),
    (9.991720, 52.161400),
    (9.993100, 52.161419),
    (9.993180, 52.161419),
    (9.995980, 52.161419),
    (9.997790, 52.161419),
    (9.998010, 52.161419),
    (9.998170, 52.161419),
    (9.998890, 52.161419),
    (10.005160, 52.161461),
    (10.008090, 52.161461),
    (10.009190, 52.161362),
    (10.009650, 52.161301),
    (10.010350, 52.161190),
    (10.011360, 52.160980),
    (10.011450, 52.160969),
    (10.011960, 52.160870),
    (10.012120, 52.160839),
    (10.012800, 52.160721),
    (10.013620, 52.160690),
    (10.014520, 52.160648),
    (10.015050, 52.160660),
    (10.015320, 52.160671),
    (10.015680, 52.160728),
    (10.016040, 52.160839),
    (10.016350, 52.160992),
    (10.016400, 52.161011),
    (10.016830, 52.161259),
    (10.017430, 52.161598),
    (10.017800, 52.161831),
    (10.019610, 52.162849),
    (10.020260, 52.163250),
    (10.022070, 52.164322),
    (10.024960, 52.165970),
    (10.026340, 52.166679),
    (10.026930, 52.166939),
    (10.027590, 52.167240),
    (10.028640, 52.167709),
    (10.030410, 52.168491),
    (10.031550, 52.168980),
    (10.033190, 52.169731),
    (10.033230, 52.169750),
    (10.033320, 52.169788),
    (10.033740, 52.169971),
    (10.034460, 52.170319),
    (10.034520, 52.170361),
    (10.035100, 52.170719),
    (10.035450, 52.170929),
    (10.035720, 52.171131),
    (10.036000, 52.171261),
    (10.036530, 52.171421),
    (10.037180, 52.171551),
    (10.037500, 52.171619),
    (10.038630, 52.171860),
    (10.039890, 52.172180),
    (10.040780, 52.172421),
    (10.042100, 52.172810),
    (10.043320, 52.173149),
    (10.044020, 52.173359),
    (10.045030, 52.173691),
    (10.046060, 52.174042),
    (10.047230, 52.174431),
    (10.048620, 52.174850),
    (10.049970, 52.175251),
    (10.051160, 52.175610),
    (10.052040, 52.175880),
    (10.055750, 52.176979),
    (10.058510, 52.177731),
    (10.061100, 52.178410),
    (10.065900, 52.179371),
    (10.067440, 52.179729),
    (10.068340, 52.180000),
    (10.068990, 52.180111),
    (10.069270, 52.180141),
    (10.069500, 52.180191),
    (10.069870, 52.180309),
    (10.070500, 52.180550),
    (10.071480, 52.180920),
    (10.073240, 52.181702),
    (10.074400, 52.182209),
    (10.078630, 52.184021),
    (10.079810, 52.184502),
    (10.080640, 52.184799),
    (10.081370, 52.184978),
    (10.081480, 52.184990),
    (10.082780, 52.185188),
    (10.085290, 52.185410),
    (10.085430, 52.185421),
    (10.090880, 52.185890),
    (10.093590, 52.186138),
    (10.095170, 52.186279),
    (10.097510, 52.186489),
    (10.098590, 52.186691),
    (10.099890, 52.187061),
    (10.099990, 52.187099),
    (10.100950, 52.187420),
    (10.102080, 52.187679),
    (10.103480, 52.187962),
    (10.104440, 52.188171),
    (10.104980, 52.188400),
    (10.105220, 52.188519),
    (10.105490, 52.188751),
    (10.107500, 52.190319),
    (10.107660, 52.190460),
    (10.107700, 52.190529),
    (10.109190, 52.191711),
    (10.110350, 52.192638),
    (10.110780, 52.192902),
    (10.111150, 52.193161),
    (10.111850, 52.193531),
    (10.112890, 52.194019),
    (10.114490, 52.194550),
    (10.118380, 52.195690),
    (10.119510, 52.196041),
    (10.122500, 52.196991),
    (10.123390, 52.197250),
    (10.123870, 52.197399),
    (10.125200, 52.197842),
    (10.126410, 52.198200),
    (10.127940, 52.198681),
    (10.129380, 52.199108),
    (10.131670, 52.199730),
    (10.132000, 52.199829),
    (10.134390, 52.200432),
    (10.136350, 52.200901),
    (10.137920, 52.201229),
    (10.138930, 52.201321),
    (10.140190, 52.201290),
    (10.141220, 52.201160),
    (10.141730, 52.201050),
    (10.142850, 52.200722),
    (10.143770, 52.200371),
    (10.144910, 52.199970),
    (10.145460, 52.199860),
    (10.145940, 52.199760),
    (10.146780, 52.199650),
    (10.147320, 52.199669),
    (10.148480, 52.199780),
    (10.150120, 52.199909),
    (10.151090, 52.199982),
    (10.152710, 52.200100),
    (10.154100, 52.200218),
    (10.156120, 52.200378),
    (10.157630, 52.200562),
    (10.158790, 52.200760),
    (10.159670, 52.200970),
    (10.161660, 52.201679),
    (10.161870, 52.201790),
    (10.162300, 52.202011),
    (10.163270, 52.202560),
    (10.163810, 52.202888),
    (10.164340, 52.203190),
    (10.165310, 52.203709),
    (10.166290, 52.204269),
    (10.167920, 52.205181),
    (10.169570, 52.206120),
    (10.171180, 52.207150),
    (10.172290, 52.207840),
    (10.172750, 52.208172),
    (10.173080, 52.208382),
    (10.173620, 52.208660),
    (10.174040, 52.208820),
    (10.174600, 52.208961),
    (10.174980, 52.209000),
    (10.175190, 52.208988),
    (10.175280, 52.208981),
    (10.176090, 52.208939),
    (10.177770, 52.208771),
    (10.179020, 52.208691),
    (10.179150, 52.208679),
    (10.179380, 52.208672),
    (10.180330, 52.208599),
    (10.180570, 52.208591),
    (10.180910, 52.208599),
    (10.181150, 52.208630),
    (10.181790, 52.208710),
    (10.182580, 52.208839),
    (10.183650, 52.209042),
    (10.185270, 52.209351),
    (10.185890, 52.209480),
    (10.187530, 52.209808),
    (10.187990, 52.210030),
    (10.188380, 52.210331),
    (10.188690, 52.210602),
    (10.189100, 52.210930),
    (10.189610, 52.211330),
    (10.190040, 52.211601),
    (10.190550, 52.211868),
    (10.191320, 52.212231),
    (10.192160, 52.212650),
    (10.193490, 52.213249),
    (10.194200, 52.213551),
    (10.194910, 52.213821),
    (10.195740, 52.214008),
    (10.196280, 52.214119),
    (10.197040, 52.214260),
    (10.197810, 52.214359),
    (10.201960, 52.214828),
    (10.202300, 52.214870),
    (10.203470, 52.215050),
    (10.204990, 52.215279),
    (10.205180, 52.215309),
    (10.206290, 52.215569),
    (10.206970, 52.215771),
    (10.207100, 52.215809),
    (10.210400, 52.216839),
    (10.212420, 52.217468),
    (10.213800, 52.217911),
    (10.214360, 52.218079),
    (10.214610, 52.218170),
    (10.215370, 52.218529),
    (10.215990, 52.218929),
    (10.216030, 52.218971),
    (10.216200, 52.219070),
    (10.217370, 52.219711),
    (10.217730, 52.219849),
    (10.217960, 52.219940),
    (10.218250, 52.220051),
    (10.219500, 52.220501),
    (10.220470, 52.220840),
    (10.220610, 52.220890),
    (10.221590, 52.221279),
    (10.222160, 52.221470),
    (10.222490, 52.221581),
    (10.228360, 52.223679),
    (10.232120, 52.225029),
    (10.232770, 52.225269),
    (10.233190, 52.225410),
    (10.236340, 52.226589),
    (10.237340, 52.226891),
    (10.237770, 52.227001),
    (10.238160, 52.227081),
    (10.238450, 52.227100),
    (10.239140, 52.227131),
    (10.239270, 52.227131),
    (10.240510, 52.227112),
    (10.241460, 52.227131),
    (10.243510, 52.227112),
    (10.244870, 52.227242),
    (10.247440, 52.227470),
    (10.252320, 52.228649),
    (10.252640, 52.228741),
    (10.254890, 52.229359),
    (10.266070, 52.232399),
    (10.266650, 52.232559),
    (10.269390, 52.233261),
    (10.271580, 52.233990),
    (10.273730, 52.234840),
    (10.286100, 52.239361),
    (10.290150, 52.240841),
    (10.292990, 52.241890),
    (10.294100, 52.242298),
    (10.294780, 52.242550),
    (10.297500, 52.243542),
    (10.301470, 52.244980),
    (10.302640, 52.245399),
    (10.303930, 52.245869),
    (10.304180, 52.245960),
    (10.304820, 52.246231),
    (10.305680, 52.246780),
    (10.306320, 52.247299),
    (10.306850, 52.247688),
    (10.307430, 52.247978),
    (10.309040, 52.248531),
    (10.312200, 52.249630),
    (10.313140, 52.249950),
    (10.313820, 52.250271),
    (10.314860, 52.250938),
    (10.316620, 52.252048),
    (10.319340, 52.253780),
    (10.320280, 52.254349),
    (10.320340, 52.254391),
    (10.320530, 52.254509),
    (10.321070, 52.254829),
    (10.321630, 52.255001),
    (10.322500, 52.255169),
    (10.323160, 52.255291),
    (10.324700, 52.255550),
    (10.325310, 52.255501),
    (10.326020, 52.255440),
    (10.326790, 52.255600),
    (10.327440, 52.255791),
    (10.327610, 52.255878),
    (10.328080, 52.256130),
    (10.328580, 52.256359),
    (10.329090, 52.256519),
    (10.329530, 52.256569),
    (10.329920, 52.256660),
    (10.330140, 52.256882),
    (10.330220, 52.257172),
    (10.330280, 52.257679),
    (10.330370, 52.257832),
    (10.330570, 52.257961),
    (10.330790, 52.258030),
    (10.331450, 52.258011),
    (10.333850, 52.257919),
    (10.334390, 52.257881),
    (10.336570, 52.257740),
    (10.338500, 52.257610),
    (10.338960, 52.257591),
    (10.339300, 52.257561),
    (10.339570, 52.257549),
    (10.339920, 52.257530),
    (10.340710, 52.257530),
    (10.341260, 52.257530),
    (10.342040, 52.257549),
    (10.342730, 52.257591),
    (10.343450, 52.257648),
    (10.343650, 52.257629),
    (10.343810, 52.257599),
    (10.343990, 52.257549),
    (10.344220, 52.257450),
    (10.344260, 52.257420),
    (10.344500, 52.257320),
    (10.345110, 52.257191),
    (10.347010, 52.257061),
    (10.347070, 52.257061),
    (10.348580, 52.256969),
    (10.349970, 52.256920),
    (10.351140, 52.257019),
    (10.352880, 52.257320),
    (10.354330, 52.257599),
    (10.354390, 52.257599),
    (10.354450, 52.257610),
    (10.355950, 52.257870),
    (10.356800, 52.258011),
    (10.356900, 52.258030),
    (10.357040, 52.258049),
    (10.357100, 52.258060),
    (10.357210, 52.258080),
    (10.357730, 52.258171),
    (10.357890, 52.258221),
    (10.357970, 52.258259),
    (10.358050, 52.258339),
    (10.358180, 52.258430),
    (10.358300, 52.258499),
    (10.358460, 52.258572),
    (10.358610, 52.258591),
    (10.358720, 52.258579),
    (10.358870, 52.258518),
    (10.358950, 52.258450),
    (10.358990, 52.258419),
    (10.359010, 52.258400),
    (10.359040, 52.258389),
    (10.359060, 52.258400),
    (10.361540, 52.258839),
    (10.361690, 52.258869),
    (10.361750, 52.258881),
    (10.362440, 52.258999),
    (10.364420, 52.259350),
    (10.365410, 52.259541),
    (10.365610, 52.259571),
    (10.365660, 52.259579),
    (10.365990, 52.259640),
    (10.366060, 52.259651),
    (10.366350, 52.259701),
    (10.366500, 52.259731),
    (10.367430, 52.259899),
    (10.370090, 52.260368),
    (10.370150, 52.260380),
    (10.370540, 52.260460),
    (10.370770, 52.260509),
    (10.371020, 52.260559),
    (10.371230, 52.260601),
    (10.371690, 52.260700),
    (10.372170, 52.260761),
    (10.372210, 52.260769),
    (10.372690, 52.260799),
    (10.372790, 52.260799),
    (10.372880, 52.260792),
    (10.373050, 52.260780),
    (10.373230, 52.260780),
    (10.373310, 52.260780),
    (10.373680, 52.260799),
    (10.374150, 52.260899),
    (10.374190, 52.260910),
    (10.374720, 52.261089),
    (10.374980, 52.261238),
    (10.375130, 52.261330),
    (10.375320, 52.261429),
    (10.375620, 52.261532),
    (10.375860, 52.261589),
    (10.376250, 52.261631),
    (10.376760, 52.261639),
    (10.376970, 52.261639),
    (10.377350, 52.261631),
    (10.377450, 52.261620),
    (10.377720, 52.261620),
    (10.377910, 52.261600),
    (10.378030, 52.261589),
    (10.378210, 52.261581),
    (10.378640, 52.261620),
    (10.379280, 52.261730),
    (10.379310, 52.261730),
    (10.379690, 52.261768),
    (10.380520, 52.261841),
    (10.382160, 52.261890),
    (10.383030, 52.261921),
    (10.383210, 52.261940),
    (10.383330, 52.261940),
    (10.387520, 52.262058),
    (10.388210, 52.262081),
    (10.388500, 52.262131),
    (10.388760, 52.262230),
    (10.388920, 52.262299),
    (10.389050, 52.262379),
    (10.389140, 52.262428),
    (10.389250, 52.262459),
    (10.389410, 52.262470),
    (10.389580, 52.262470),
    (10.391140, 52.261990),
    (10.391880, 52.261780),
    (10.392000, 52.261742),
    (10.392160, 52.261700),
    (10.392410, 52.261631),
    (10.392770, 52.261532),
    (10.394220, 52.261040),
    (10.395740, 52.260521),
    (10.397560, 52.259899),
    (10.398880, 52.259472),
    (10.400450, 52.258949),
    (10.401480, 52.258652),
    (10.401520, 52.258640),
    (10.401960, 52.258518),
    (10.402840, 52.258270),
    (10.404130, 52.257919),
    (10.405100, 52.257648),
    (10.406100, 52.257381),
    (10.406620, 52.257240),
    (10.407400, 52.257069),
    (10.407580, 52.257038),
    (10.408090, 52.256939),
    (10.408750, 52.256908),
    (10.409630, 52.256939),
    (10.409730, 52.256950),
    (10.410730, 52.257000),
    (10.413280, 52.257092),
    (10.413560, 52.257099),
    (10.417180, 52.257240),
    (10.420290, 52.257351),
    (10.421030, 52.257381),
    (10.424820, 52.257561),
    (10.428660, 52.257710),
    (10.429440, 52.257801),
    (10.429970, 52.257851),
    (10.434900, 52.258362),
    (10.438180, 52.258411),
    (10.438910, 52.258419),
    (10.443590, 52.258511),
    (10.444940, 52.258530),
    (10.445700, 52.258560),
    (10.445950, 52.258610),
    (10.446460, 52.258720),
    (10.449720, 52.259789),
    (10.450540, 52.260059),
    (10.451580, 52.260250),
    (10.452470, 52.260422),
    (10.452530, 52.260368),
    (10.452900, 52.260151),
    (10.453000, 52.260059),
    (10.453030, 52.260010),
    (10.453100, 52.259861),
    (10.453210, 52.259621),
    (10.453510, 52.259109),
    (10.453630, 52.258991),
    (10.453680, 52.258911),
    (10.453760, 52.258789),
    (10.453850, 52.258701),
    (10.453990, 52.258652),
    (10.454120, 52.258572),
    (10.454630, 52.258659),
    (10.454820, 52.258400),
    (10.454880, 52.258320),
    (10.455180, 52.257912),
    (10.455240, 52.257839),
    (10.455250, 52.257820),
    (10.455590, 52.257420),
    (10.455650, 52.257359),
    (10.455660, 52.257339),
    (10.455750, 52.257240),
    (10.455790, 52.257221),
    (10.455960, 52.257229),
    (10.456580, 52.257278),
    (10.456850, 52.257301),
    (10.458370, 52.257408),
    (10.459540, 52.257500),
    (10.459640, 52.257511),
    (10.461140, 52.257629),
    (10.461260, 52.257641),
    (10.464370, 52.257900),
    (10.465300, 52.257980),
    (10.466380, 52.258080),
    (10.466860, 52.258121),
    (10.469080, 52.258301),
    (10.471310, 52.258492),
    (10.472040, 52.258549),
    (10.472700, 52.258610),
    (10.473580, 52.258671),
    (10.473960, 52.258709),
    (10.474140, 52.258720),
    (10.474270, 52.258732),
    (10.475210, 52.258820),
    (10.476190, 52.258911),
    (10.476450, 52.258930),
    (10.476820, 52.258961),
    (10.477290, 52.259010),
    (10.477840, 52.259071),
    (10.478430, 52.259121),
    (10.478590, 52.259140),
    (10.479310, 52.259201),
    (10.479860, 52.259251),
    (10.480950, 52.259350),
    (10.481250, 52.259380),
    (10.481720, 52.259430),
    (10.484480, 52.260132),
    (10.485020, 52.260269),
    (10.485320, 52.260330),
    (10.486060, 52.260361),
    (10.486560, 52.260380),
    (10.487820, 52.260399),
    (10.488120, 52.260410),
    (10.488500, 52.260441),
    (10.489730, 52.260460),
    (10.491020, 52.260479),
    (10.492290, 52.260509),
    (10.493910, 52.260540),
    (10.494650, 52.260551),
    (10.496830, 52.260590),
    (10.497610, 52.260601),
    (10.498380, 52.260609),
    (10.498590, 52.260620),
    (10.498810, 52.260620),
    (10.499050, 52.260651),
    (10.499960, 52.260849),
    (10.500270, 52.260860),
    (10.500790, 52.260830),
    (10.501580, 52.260738),
    (10.502250, 52.260651),
    (10.502700, 52.260609),
    (10.502860, 52.260609),
    (10.502930, 52.260609),
    (10.502990, 52.260609),
    (10.503120, 52.260620),
    (10.503930, 52.260750),
    (10.504410, 52.260830),
    (10.504740, 52.260880),
    (10.505510, 52.261009),
    (10.505600, 52.261021),
    (10.506550, 52.261181),
    (10.508110, 52.261429),
    (10.508240, 52.261429),
    (10.508930, 52.261391),
    (10.509100, 52.261379),
    (10.509350, 52.261341),
    (10.509430, 52.261330),
    (10.509540, 52.261311),
    (10.509960, 52.261250),
    (10.510110, 52.261261),
    (10.511250, 52.262299),
    (10.511330, 52.262329),
    (10.511470, 52.262371),
    (10.511630, 52.262390),
    (10.512020, 52.262371),
    (10.513320, 52.262440),
    (10.513360, 52.262451),
    (10.513520, 52.262459),
    (10.513940, 52.262489),
    (10.514020, 52.262501),
    (10.514200, 52.262520),
    (10.514290, 52.262138),
    (10.514290, 52.262112),
    (10.514340, 52.261959),
    (10.514440, 52.261581),
    (10.515090, 52.260769),
    (10.515300, 52.260490),
    (10.515750, 52.259800),
    (10.515960, 52.259460),
    (10.516130, 52.259190),
    (10.516300, 52.258961),
    (10.516640, 52.258411),
    (10.516720, 52.258301),
    (10.516790, 52.258202),
    (10.516850, 52.258141),
    (10.516880, 52.258110),
    (10.516920, 52.258091),
    (10.516980, 52.258060),
    (10.517040, 52.258041),
    (10.517120, 52.258018),
    (10.517180, 52.258018),
    (10.517270, 52.258018),
    (10.517320, 52.258030),
    (10.517410, 52.258049),
    (10.517600, 52.258091),
    (10.517730, 52.258129),
    (10.518290, 52.258270),
    (10.518470, 52.258301),
    (10.519580, 52.258419),
    (10.519760, 52.258438),
    (10.519860, 52.258450),
    (10.519980, 52.258469),
    (10.520170, 52.258492),
    (10.520440, 52.258518),
    (10.520630, 52.258530),
    (10.520860, 52.258549),
    (10.521030, 52.258572),
    (10.521180, 52.258579),
    (10.522020, 52.258629),
    (10.522440, 52.258640),
    (10.522710, 52.258629),
    (10.522990, 52.258591),
    (10.523130, 52.258572),
    (10.524730, 52.258221),
    (10.525330, 52.258148),
    (10.525520, 52.258072),
    (10.525680, 52.258011),
    (10.526500, 52.257549),
    (10.526820, 52.257381),
    (10.527020, 52.257290),
    (10.527480, 52.257221),
    (10.527610, 52.257240),
    (10.527730, 52.257301),
    (10.527880, 52.257420),
    (10.528080, 52.257839),
    (10.529220, 52.258129),
    (10.529370, 52.258148),
    (10.529560, 52.258171),
    (10.529650, 52.258179),
    (10.529710, 52.258179),
    (10.530140, 52.258221),
    (10.530400, 52.258190),
    (10.530770, 52.258160),
    (10.531240, 52.258041),
    (10.531540, 52.257900),
    (10.531660, 52.257851),
    (10.532340, 52.257431),
    (10.533220, 52.256771),
    (10.533440, 52.256779),
    (10.533600, 52.256790),
    (10.534190, 52.256760),
    (10.535690, 52.256729),
    (10.536180, 52.256729),
    (10.537300, 52.256760),
    (10.537850, 52.256771),
    (10.537990, 52.256771),
    (10.539140, 52.256760),
    (10.540030, 52.256790),
    (10.540190, 52.256790),
    (10.540410, 52.256790),
    (10.541160, 52.256809),
    (10.541910, 52.256859),
    (10.542710, 52.256901),
    (10.543570, 52.256939),
    (10.544370, 52.256969),
    (10.544840, 52.257038),
    (10.546020, 52.257500),
    (10.546730, 52.257179),
    (10.546950, 52.257080),
    (10.548220, 52.256519),
    (10.548370, 52.256451),
    (10.548810, 52.256260),
    (10.549010, 52.256180),
    (10.549330, 52.256039),
    (10.550260, 52.255661),
    (10.551020, 52.255451),
    (10.551270, 52.255402),
    (10.551500, 52.255360),
    (10.551550, 52.255360),
    (10.551680, 52.255341),
    (10.551790, 52.255329),
    (10.552520, 52.255291),
    (10.556050, 52.255100),
    (10.556410, 52.255081),
    (10.556800, 52.255058),
    (10.557110, 52.255051),
    (10.557990, 52.255001),
    (10.559070, 52.254940),
    (10.560430, 52.254871),
    (10.560780, 52.254860),
    (10.561360, 52.254829),
    (10.561780, 52.254799),
    (10.561900, 52.254799),
    (10.561990, 52.254791),
    (10.562380, 52.254768),
    (10.562600, 52.254761),
    (10.562740, 52.254742),
    (10.563450, 52.254608),
    (10.564310, 52.254372),
    (10.567420, 52.253479),
    (10.568170, 52.253311),
    (10.568640, 52.253281),
    (10.569330, 52.253239),
    (10.569740, 52.253151),
    (10.569960, 52.253090),
    (10.571390, 52.252720),
    (10.571700, 52.252621),
    (10.571920, 52.252560),
    (10.572190, 52.252510),
    (10.572780, 52.252380),
    (10.573470, 52.252300),
    (10.574210, 52.252232),
    (10.574850, 52.252171),
    (10.575530, 52.252079),
    (10.576460, 52.251930),
    (10.577060, 52.251839),
    (10.577780, 52.251770),
    (10.578960, 52.251720),
    (10.579870, 52.251690),
    (10.580230, 52.251678),
    (10.580640, 52.251671),
    (10.580840, 52.251659),
    (10.581550, 52.251621),
    (10.582310, 52.251560),
    (10.582820, 52.251511),
    (10.583300, 52.251450),
    (10.584120, 52.251331),
    (10.584980, 52.251190),
    (10.585890, 52.251019),
    (10.586760, 52.250858),
    (10.587100, 52.250801),
    (10.587440, 52.250751),
    (10.587840, 52.250710),
    (10.588290, 52.250671),
    (10.589410, 52.250629),
    (10.589820, 52.250622),
    (10.590710, 52.250599),
    (10.591010, 52.250591),
    (10.591330, 52.250599),
    (10.591590, 52.250610),
    (10.591800, 52.250629),
    (10.592260, 52.250648),
    (10.592600, 52.250660),
    (10.592820, 52.250671),
    (10.592980, 52.250660),
    (10.596100, 52.250580),
    (10.596370, 52.250580),
    (10.597430, 52.250568),
    (10.598660, 52.250549),
    (10.599270, 52.250568),
    (10.599630, 52.250580),
    (10.599940, 52.250599),
    (10.600290, 52.250622),
    (10.600630, 52.250660),
    (10.601310, 52.250729),
    (10.601860, 52.250809),
    (10.603320, 52.251091),
    (10.605440, 52.251671),
    (10.606260, 52.251919),
    (10.608650, 52.252609),
    (10.608770, 52.252651),
    (10.609300, 52.252800),
    (10.609620, 52.252899),
    (10.609730, 52.252930),
    (10.610040, 52.253040),
    (10.610430, 52.253239),
    (10.610630, 52.253410),
    (10.611050, 52.253750),
    (10.611490, 52.254040),
    (10.611850, 52.254211),
    (10.612300, 52.254318),
    (10.612870, 52.254391),
    (10.613420, 52.254391),
    (10.614080, 52.254349),
    (10.614390, 52.254330),
    (10.616040, 52.254230),
    (10.616430, 52.254211),
    (10.617590, 52.254169),
    (10.618070, 52.254131),
    (10.618590, 52.254082),
    (10.620830, 52.253880),
    (10.622270, 52.253712),
    (10.622400, 52.253700),
    (10.622700, 52.253670),
    (10.622940, 52.253639),
    (10.624570, 52.253460),
    (10.626910, 52.253269),
    (10.629610, 52.253120),
    (10.630600, 52.253040),
    (10.631080, 52.252979),
    (10.631660, 52.252869),
    (10.632340, 52.252689),
    (10.633140, 52.252419),
    (10.634220, 52.252060),
    (10.634700, 52.251930),
    (10.635320, 52.251781),
    (10.636120, 52.251652),
    (10.637320, 52.251461),
    (10.639420, 52.251148),
    (10.640440, 52.250999),
    (10.641400, 52.250858),
    (10.642030, 52.250759),
    (10.642800, 52.250641),
    (10.644490, 52.250381),
    (10.645280, 52.250259),
    (10.645890, 52.250172),
    (10.646320, 52.250111),
    (10.646870, 52.250031),
    (10.647170, 52.249981),
    (10.647540, 52.249939),
    (10.647900, 52.249901),
    (10.648440, 52.249828),
    (10.648880, 52.249771),
    (10.649140, 52.249722),
    (10.650510, 52.249371),
    (10.651710, 52.249100),
    (10.651970, 52.249031),
    (10.652320, 52.248951),
    (10.653410, 52.248711),
    (10.654520, 52.248470),
    (10.654990, 52.248371),
    (10.655430, 52.248310),
    (10.655870, 52.248249),
    (10.656600, 52.248150),
    (10.656840, 52.248119),
    (10.658460, 52.247890),
    (10.659050, 52.247791),
    (10.659610, 52.247669),
    (10.660670, 52.247410),
    (10.661060, 52.247299),
    (10.661570, 52.247181),
    (10.661850, 52.247150),
    (10.662160, 52.247150),
    (10.662430, 52.247200),
    (10.662630, 52.247280),
    (10.662850, 52.247398),
    (10.663820, 52.246899),
    (10.664260, 52.246712),
    (10.665310, 52.246311),
    (10.666150, 52.246052),
    (10.667150, 52.245800),
    (10.668090, 52.245640),
    (10.669100, 52.245571),
    (10.670000, 52.245579),
    (10.670710, 52.245640),
    (10.672540, 52.245880),
    (10.673920, 52.246010),
    (10.674800, 52.246040),
    (10.676790, 52.246059),
    (10.681360, 52.246109),
    (10.687790, 52.246220),
    (10.690960, 52.246269),
    (10.696410, 52.246349),
    (10.697090, 52.246380),
    (10.697560, 52.246449),
    (10.698120, 52.246552),
    (10.701680, 52.247299),
    (10.701960, 52.247360),
    (10.702890, 52.247509),
    (10.703510, 52.247570),
    (10.707870, 52.247910),
    (10.710460, 52.248119),
    (10.711630, 52.248192),
    (10.712460, 52.248180),
    (10.713470, 52.248150),
    (10.714560, 52.248070),
    (10.717750, 52.247662),
    (10.719770, 52.247398),
    (10.720460, 52.247360),
    (10.721240, 52.247330),
    (10.721990, 52.247341),
    (10.722660, 52.247410),
    (10.723380, 52.247501),
    (10.723990, 52.247601),
    (10.724600, 52.247711),
    (10.724780, 52.247749),
    (10.725170, 52.247822),
    (10.725930, 52.247921),
    (10.726470, 52.247971),
    (10.728340, 52.248051),
    (10.728710, 52.248100),
    (10.729600, 52.248260),
    (10.730710, 52.248589),
    (10.731400, 52.248901),
    (10.731880, 52.249180),
    (10.732310, 52.249500),
    (10.732860, 52.250080),
    (10.733670, 52.251530),
    (10.734110, 52.252110),
    (10.734500, 52.252480),
    (10.734790, 52.252762),
    (10.735510, 52.253311),
    (10.736580, 52.253880),
    (10.737570, 52.254238),
    (10.738380, 52.254509),
    (10.741360, 52.255268),
    (10.744810, 52.256168),
    (10.746630, 52.256741),
    (10.747950, 52.257160),
    (10.748950, 52.257339),
    (10.750180, 52.257431),
    (10.750780, 52.257408),
    (10.752070, 52.257351),
    (10.752480, 52.257301),
    (10.753210, 52.257179),
    (10.754830, 52.256920),
    (10.755520, 52.256851),
    (10.756210, 52.256870),
    (10.756870, 52.256989),
    (10.757250, 52.257092),
    (10.758190, 52.257462),
    (10.759250, 52.257832),
    (10.759680, 52.257931),
    (10.760660, 52.258049),
    (10.761250, 52.258091),
    (10.766470, 52.257881),
    (10.775620, 52.257610),
    (10.779140, 52.257542),
    (10.782370, 52.257568),
    (10.785740, 52.257629),
    (10.786510, 52.257641),
    (10.789100, 52.257660),
    (10.790770, 52.257530),
    (10.792700, 52.257191),
    (10.793280, 52.257069),
    (10.797040, 52.256302),
    (10.800580, 52.255711),
    (10.801040, 52.255630),
    (10.801880, 52.255409),
    (10.802570, 52.255211),
    (10.803100, 52.255070),
    (10.803600, 52.254929),
    (10.804580, 52.254650),
    (10.805610, 52.254360),
    (10.806280, 52.254181),
    (10.807140, 52.253941),
    (10.807740, 52.253769),
    (10.808430, 52.253578),
    (10.808410, 52.253220),
    (10.809760, 52.250870),
    (10.810410, 52.249660),
    (10.810900, 52.248779),
    (10.811510, 52.247662),
    (10.811770, 52.247581),
    (10.812940, 52.247391),
    (10.813820, 52.247360),
    (10.814670, 52.247410),
    (10.815340, 52.247490),
    (10.815450, 52.247398),
    (10.815500, 52.247181),
    (10.815550, 52.246941),
    (10.815710, 52.246731),
    (10.815940, 52.246540),
    (10.816250, 52.246330),
    (10.816440, 52.246201),
    (10.816770, 52.245991),
    (10.816910, 52.245892),
    (10.817020, 52.245762),
    (10.817150, 52.245209),
    (10.817400, 52.245098),
    (10.817840, 52.244980),
    (10.818300, 52.244831),
    (10.818390, 52.244659),
    (10.818990, 52.244659),
    (10.819960, 52.244499),
    (10.820840, 52.244270),
    (10.821070, 52.244190),
    (10.821310, 52.244091),
    (10.822250, 52.243839),
    (10.822960, 52.243729),
    (10.823680, 52.243690),
    (10.824080, 52.243698),
    (10.824410, 52.243759),
    (10.824950, 52.243500),
    (10.825370, 52.243370),
    (10.826080, 52.243149),
    (10.826950, 52.242828),
    (10.827460, 52.242599),
    (10.828080, 52.242279),
    (10.828670, 52.241859),
    (10.829190, 52.241348),
    (10.829730, 52.240841),
    (10.830280, 52.240479),
    (10.830710, 52.240238),
    (10.831290, 52.239971),
    (10.831810, 52.239761),
    (10.832320, 52.239540),
    (10.832910, 52.239300),
    (10.833560, 52.238972),
    (10.834300, 52.238541),
    (10.834610, 52.238338),
    (10.834990, 52.238121),
    (10.835270, 52.238022),
    (10.835840, 52.237839),
    (10.836990, 52.237492),
    (10.837570, 52.237282),
    (10.838070, 52.237019),
    (10.838780, 52.236549),
    (10.839300, 52.236149),
    (10.840020, 52.235630),
    (10.840870, 52.235149),
    (10.841490, 52.234901),
    (10.842130, 52.234711),
    (10.842630, 52.234612),
    (10.845100, 52.234280),
    (10.845720, 52.234180),
    (10.846570, 52.233971),
    (10.847470, 52.233669),
    (10.848420, 52.233269),
    (10.850600, 52.232140),
    (10.851690, 52.231720),
    (10.852330, 52.231522),
    (10.853010, 52.231331),
    (10.853800, 52.231152),
    (10.854710, 52.230991),
    (10.855660, 52.230888),
    (10.857250, 52.230839),
    (10.858350, 52.230900),
    (10.860050, 52.230980),
    (10.861170, 52.230949),
    (10.862580, 52.230801),
    (10.863920, 52.230621),
    (10.865240, 52.230450),
    (10.868730, 52.230011),
    (10.869540, 52.229900),
    (10.870250, 52.229740),
    (10.870910, 52.229580),
    (10.872930, 52.229012),
    (10.875630, 52.228249),
    (10.879890, 52.227058),
    (10.880560, 52.226898),
    (10.881130, 52.226810),
    (10.881840, 52.226742),
    (10.882530, 52.226719),
    (10.883090, 52.226749),
    (10.883480, 52.226791),
    (10.886530, 52.227322),
    (10.887490, 52.227459),
    (10.888350, 52.227539),
    (10.889200, 52.227570),
    (10.892610, 52.227520),
    (10.894570, 52.227509),
    (10.895680, 52.227581),
    (10.897810, 52.227840),
    (10.899730, 52.228088),
    (10.900490, 52.228199),
    (10.901070, 52.228222),
    (10.901740, 52.228130),
    (10.902650, 52.227940),
    (10.903160, 52.227798),
    (10.903800, 52.227600),
    (10.904170, 52.227501),
    (10.904650, 52.227360),
    (10.904930, 52.227291),
    (10.905070, 52.227261),
    (10.905320, 52.227230),
    (10.905430, 52.227211),
    (10.906100, 52.227180),
    (10.906520, 52.227200),
    (10.907350, 52.227261),
    (10.908700, 52.227291),
    (10.909000, 52.227291),
    (10.909210, 52.227261),
    (10.909330, 52.227249),
    (10.909430, 52.227219),
    (10.909790, 52.227119),
    (10.909960, 52.227051),
    (10.910030, 52.227032),
    (10.910090, 52.227001),
    (10.910250, 52.226940),
    (10.910640, 52.226780),
    (10.911260, 52.226589),
    (10.911750, 52.226479),
    (10.912220, 52.226440),
    (10.913550, 52.226440),
    (10.914250, 52.226452),
    (10.914660, 52.226460),
    (10.919680, 52.226528),
    (10.920230, 52.226509),
    (10.920860, 52.226452),
    (10.922210, 52.226250),
    (10.924780, 52.225800),
    (10.924890, 52.225780),
    (10.929970, 52.224869),
    (10.930930, 52.224731),
    (10.931620, 52.224659),
    (10.932630, 52.224602),
    (10.933530, 52.224602),
    (10.936470, 52.224640),
    (10.937150, 52.224609),
    (10.937800, 52.224548),
    (10.939190, 52.224430),
    (10.940500, 52.224300),
    (10.941780, 52.224220),
    (10.942590, 52.224201),
    (10.943440, 52.224209),
    (10.944350, 52.224258),
    (10.944660, 52.224289),
    (10.944990, 52.224319),
    (10.949000, 52.224800),
    (10.951500, 52.225109),
    (10.952410, 52.225208),
    (10.952840, 52.225250),
    (10.953360, 52.225269),
    (10.954700, 52.225269),
    (10.957700, 52.225311),
    (10.958130, 52.225330),
    (10.958440, 52.225349),
    (10.958770, 52.225399),
    (10.959420, 52.225491),
    (10.960880, 52.225811),
    (10.961710, 52.225960),
    (10.962840, 52.226139),
    (10.964190, 52.226280),
    (10.975070, 52.227501),
    (10.978550, 52.227829),
    (10.979330, 52.227890),
    (10.980200, 52.227959),
    (10.980500, 52.227989),
    (10.987670, 52.228611),
    (10.988090, 52.228649),
    (10.989730, 52.228821),
    (10.991070, 52.228951),
    (10.991890, 52.229031),
    (10.992520, 52.229050),
    (10.992620, 52.229061),
    (10.992920, 52.229080),
    (10.993270, 52.229111),
    (10.993900, 52.229160),
    (10.994460, 52.229179),
    (10.995200, 52.229191),
    (10.995450, 52.229191),
    (10.995470, 52.229191),
    (10.995980, 52.229191),
    (10.996420, 52.229191),
    (10.997400, 52.229179),
    (10.997780, 52.229191),
    (10.998050, 52.229099),
    (10.998720, 52.228851),
    (10.999300, 52.228661),
    (11.000870, 52.228119),
    (11.001780, 52.227829),
    (11.003680, 52.227261),
    (11.003920, 52.227089),
    (11.004090, 52.227001),
    (11.004330, 52.226879),
    (11.004910, 52.226540),
    (11.005050, 52.226460),
    (11.005150, 52.226391),
    (11.006050, 52.225868),
    (11.006240, 52.225761),
    (11.006460, 52.225620),
    (11.006570, 52.225552),
    (11.007290, 52.225109),
    (11.007480, 52.225010),
    (11.007690, 52.224911),
    (11.007950, 52.224819),
    (11.008250, 52.224720),
    (11.008900, 52.224541),
    (11.009140, 52.224468),
    (11.009290, 52.224430),
    (11.009390, 52.224411),
    (11.009770, 52.224350),
    (11.009980, 52.224331),
    (11.010040, 52.224319),
    (11.010160, 52.224331),
    (11.010400, 52.224339),
    (11.011150, 52.224369),
    (11.011340, 52.224361),
    (11.011530, 52.224350),
    (11.011730, 52.224312),
    (11.011920, 52.224281),
    (11.012500, 52.224159),
    (11.012790, 52.224140),
    (11.013020, 52.224152),
    (11.013320, 52.224171),
    (11.013400, 52.224190),
    (11.013620, 52.224232),
    (11.013920, 52.224331),
    (11.014360, 52.224609),
    (11.014800, 52.224930),
    (11.014920, 52.224972),
    (11.014980, 52.224979),
    (11.015050, 52.224972),
    (11.015140, 52.224930),
    (11.015690, 52.224400),
    (11.016710, 52.223412),
    (11.016820, 52.223320),
    (11.016870, 52.223282),
    (11.016950, 52.223240),
    (11.017060, 52.223190),
    (11.017210, 52.223141),
    (11.017570, 52.223030),
    (11.018890, 52.222672),
    (11.019880, 52.222382),
    (11.020120, 52.222290),
    (11.020320, 52.222229),
    (11.020500, 52.222160),
    (11.020670, 52.222080),
    (11.021430, 52.221722),
    (11.021540, 52.221661),
    (11.022170, 52.221371),
    (11.022690, 52.221130),
    (11.022730, 52.221111),
    (11.022830, 52.221069),
    (11.023500, 52.220749),
    (11.025770, 52.219719),
    (11.026020, 52.219608),
    (11.026860, 52.219231),
    (11.028230, 52.218590),
    (11.028500, 52.218460),
    (11.028630, 52.218399),
    (11.028680, 52.218369),
    (11.028730, 52.218349),
    (11.030050, 52.217781),
    (11.030140, 52.217739),
    (11.030220, 52.217709),
    (11.030420, 52.217651),
    (11.030620, 52.217602),
    (11.030840, 52.217571),
    (11.031060, 52.217541),
    (11.031290, 52.217529),
    (11.031500, 52.217548),
    (11.031700, 52.217579),
    (11.031890, 52.217609),
    (11.032020, 52.217651),
    (11.032270, 52.217709),
    (11.032530, 52.217800),
    (11.032940, 52.217918),
    (11.032980, 52.217930),
    (11.033290, 52.218021),
    (11.033760, 52.218109),
    (11.034100, 52.218140),
    (11.034370, 52.218140),
    (11.034700, 52.218121),
    (11.034990, 52.218090),
    (11.035040, 52.218090),
    (11.035510, 52.217979),
    (11.038080, 52.217400),
    (11.040610, 52.216759),
    (11.041350, 52.216572),
    (11.041860, 52.216438),
    (11.042180, 52.216301),
    (11.042380, 52.216190),
    (11.042530, 52.216061),
    (11.042600, 52.215961),
    (11.042650, 52.215870),
    (11.042840, 52.215939),
    (11.043260, 52.216099),
    (11.043360, 52.216141),
    (11.044120, 52.216370),
    (11.044500, 52.216450),
    (11.046010, 52.216740),
    (11.048150, 52.217159),
    (11.052340, 52.217960),
    (11.052040, 52.218510),
    (11.051700, 52.219109),
    (11.053120, 52.219360),
    (11.053380, 52.219398),
    (11.053800, 52.219471),
    (11.053890, 52.219501),
    (11.053930, 52.219551),
    (11.053970, 52.219662),
    (11.054010, 52.219810),
    (11.054000, 52.219940),
    (11.054000, 52.220070),
    (11.054150, 52.220058),
    (11.054300, 52.220081),
    (11.054440, 52.220112),
    (11.054630, 52.220139),
    (11.054770, 52.220150),
    (11.054940, 52.220131),
    (11.055560, 52.219940),
    (11.056610, 52.219559),
    (11.058190, 52.219021),
    (11.059490, 52.218639),
    (11.060970, 52.218262),
    (11.064060, 52.217609),
    (11.065950, 52.217312),
    (11.069040, 52.217010),
    (11.074340, 52.216759),
    (11.080810, 52.216389),
    (11.083960, 52.216160),
    (11.086790, 52.215820),
    (11.088480, 52.215549),
    (11.089660, 52.215321),
    (11.091000, 52.215000),
    (11.092060, 52.214710),
    (11.093080, 52.214390),
    (11.093930, 52.214119),
    (11.095410, 52.213581),
    (11.097000, 52.213032),
    (11.098420, 52.212528),
    (11.099480, 52.212200),
    (11.100290, 52.211971),
    (11.101480, 52.211639),
    (11.106470, 52.210320),
    (11.107940, 52.209942),
    (11.109450, 52.209572),
    (11.110860, 52.209259),
    (11.111960, 52.209019),
    (11.113010, 52.208809),
    (11.114370, 52.208530),
    (11.116760, 52.208210),
    (11.118510, 52.208031),
    (11.131400, 52.207260),
    (11.132010, 52.207218),
    (11.133300, 52.207180),
    (11.134460, 52.207150),
    (11.134740, 52.207142),
    (11.136630, 52.207142),
    (11.138070, 52.207230),
    (11.139100, 52.207298),
    (11.147410, 52.208012),
    (11.150500, 52.208260),
    (11.152660, 52.208382),
    (11.154280, 52.208431),
    (11.156830, 52.208389),
    (11.159520, 52.208260),
    (11.161680, 52.208080),
    (11.164340, 52.207748),
    (11.166670, 52.207439),
    (11.167560, 52.207272),
    (11.178970, 52.204609),
    (11.180410, 52.204288),
    (11.183070, 52.203690),
    (11.186970, 52.202950),
    (11.190540, 52.202518),
    (11.193090, 52.202309),
    (11.201360, 52.201889),
    (11.202060, 52.201839),
    (11.226170, 52.200691),
    (11.230640, 52.200531),
    (11.234650, 52.200310),
    (11.236250, 52.200180),
    (11.238530, 52.199970),
    (11.242180, 52.199551),
    (11.243590, 52.199379),
    (11.249320, 52.198601),
    (11.250600, 52.198441),
    (11.262890, 52.196831),
    (11.263430, 52.196758),
    (11.264250, 52.196640),
    (11.268200, 52.196110),
    (11.269560, 52.195919),
    (11.270210, 52.195831),
    (11.295260, 52.192509),
    (11.295720, 52.192451),
    (11.299800, 52.191921),
    (11.301930, 52.191681),
    (11.302420, 52.191631),
    (11.316440, 52.190380),
    (11.342720, 52.188000),
    (11.350630, 52.187290),
    (11.352270, 52.187160),
    (11.353910, 52.187069),
    (11.355560, 52.187012),
    (11.357350, 52.186981),
    (11.359240, 52.186951),
    (11.363340, 52.186958),
    (11.367130, 52.187000),
    (11.385550, 52.187130),
    (11.389680, 52.187180),
    (11.389980, 52.187180),
    (11.390580, 52.187191),
    (11.390910, 52.187191),
    (11.392750, 52.187210),
    (11.411410, 52.187790),
    (11.411850, 52.187809),
    (11.417390, 52.187962),
    (11.420940, 52.188080),
    (11.421540, 52.188099),
    (11.425000, 52.188190),
    (11.428030, 52.188290),
    (11.431270, 52.188339),
    (11.433130, 52.188320),
    (11.434950, 52.188210),
    (11.436680, 52.188049),
    (11.438530, 52.187771),
    (11.440890, 52.187340),
    (11.442460, 52.186981),
    (11.445990, 52.186001),
    (11.446220, 52.185928),
    (11.446530, 52.185829),
    (11.456380, 52.183041),
    (11.461970, 52.181412),
    (11.477810, 52.176910),
    (11.480200, 52.176159),
    (11.481380, 52.175781),
    (11.482780, 52.175251),
    (11.484910, 52.174389),
    (11.487240, 52.173431),
    (11.490690, 52.172020),
    (11.495770, 52.169930),
    (11.500370, 52.168049),
    (11.501730, 52.167519),
    (11.503070, 52.167030),
    (11.504530, 52.166550),
    (11.505440, 52.166279),
    (11.506770, 52.165939),
    (11.508040, 52.165649),
    (11.509270, 52.165401),
    (11.510260, 52.165230),
    (11.511350, 52.165070),
    (11.512380, 52.164940),
    (11.513680, 52.164829),
    (11.514800, 52.164749),
    (11.515870, 52.164700),
    (11.516040, 52.164700),
    (11.516230, 52.164688),
    (11.517430, 52.164680),
    (11.518250, 52.164680),
    (11.519800, 52.164742),
    (11.521640, 52.164879),
    (11.522490, 52.164982),
    (11.523280, 52.165081),
    (11.523650, 52.165131),
    (11.525440, 52.165390),
    (11.525690, 52.165421),
    (11.532670, 52.166431),
    (11.533920, 52.166611),
    (11.538470, 52.167301),
    (11.539150, 52.167400),
    (11.552810, 52.169441),
    (11.555750, 52.169910),
    (11.557110, 52.170231),
    (11.558390, 52.170559),
    (11.561330, 52.171291),
    (11.570870, 52.173820),
    (11.578120, 52.175751),
    (11.587460, 52.178219),
    (11.603000, 52.182308),
    (11.609190, 52.183929),
    (11.613150, 52.185032),
    (11.616280, 52.185822),
    (11.619190, 52.186619),
    (11.622380, 52.187531),
    (11.623750, 52.188011),
    (11.625240, 52.188580),
    (11.625460, 52.188660),
    (11.627330, 52.189590),
    (11.629590, 52.190868),
    (11.632370, 52.192478),
    (11.645400, 52.199959),
    (11.646130, 52.200359),
    (11.646950, 52.200840),
    (11.647290, 52.201038),
    (11.660160, 52.208420),
    (11.660650, 52.208679),
    (11.661790, 52.209332),
    (11.664840, 52.211090),
    (11.665650, 52.211540),
    (11.666070, 52.211788),
    (11.669590, 52.213799),
    (11.673390, 52.215851),
    (11.674780, 52.216461),
    (11.676330, 52.217049),
    (11.677310, 52.217369),
    (11.678770, 52.217838),
    (11.680520, 52.218311),
    (11.681510, 52.218540),
    (11.684450, 52.219070),
    (11.687590, 52.219440),
    (11.689300, 52.219589),
    (11.689450, 52.219601),
    (11.689830, 52.219631),
    (11.706810, 52.221169),
    (11.712110, 52.221680),
    (11.716320, 52.222061),
    (11.731660, 52.223511),
    (11.732720, 52.223629),
    (11.733620, 52.223759),
    (11.742580, 52.225361),
    (11.751690, 52.226990),
    (11.757410, 52.228050),
    (11.759240, 52.228409),
    (11.761170, 52.228741),
    (11.763740, 52.229019),
    (11.765710, 52.229149),
    (11.767780, 52.229179),
    (11.771920, 52.228970),
    (11.790400, 52.227791),
    (11.792140, 52.227680),
    (11.793290, 52.227600),
    (11.798040, 52.227291),
    (11.807330, 52.226688),
    (11.807930, 52.226650),
    (11.817910, 52.226009),
    (11.823130, 52.225689),
    (11.825870, 52.225510),
    (11.826620, 52.225471),
    (11.828190, 52.225410),
    (11.830020, 52.225430),
    (11.831250, 52.225471),
    (11.832670, 52.225559),
    (11.833790, 52.225651),
    (11.847730, 52.227291),
    (11.849970, 52.227551),
    (11.850620, 52.227631),
    (11.888910, 52.232159),
    (11.891810, 52.232510),
    (11.892760, 52.232639),
    (11.893580, 52.232731),
    (11.896580, 52.233051),
    (11.899950, 52.233360),
    (11.902740, 52.233601),
    (11.905310, 52.233768),
    (11.907980, 52.233879),
    (11.924290, 52.234348),
    (11.940530, 52.234779),
    (11.957140, 52.235249),
    (11.963760, 52.235409),
    (11.971190, 52.235600),
    (11.977290, 52.235748),
    (11.978940, 52.235790),
    (11.980510, 52.235771),
    (11.982490, 52.235699),
    (11.988120, 52.235432),
    (11.996990, 52.235081),
    (12.014010, 52.234341),
    (12.027730, 52.233761),
    (12.034740, 52.233421),
    (12.042130, 52.233101),
    (12.053010, 52.232632),
    (12.054200, 52.232609),
    (12.055410, 52.232620),
    (12.056750, 52.232670),
    (12.058700, 52.232841),
    (12.060020, 52.232960),
    (12.061130, 52.233101),
    (12.063840, 52.233459),
    (12.065480, 52.233681),
    (12.066100, 52.233768),
    (12.139940, 52.243149),
    (12.145010, 52.243790),
    (12.190650, 52.249649),
    (12.210380, 52.252121),
    (12.212640, 52.252350),
    (12.214300, 52.252441),
    (12.216910, 52.252491),
    (12.219900, 52.252319),
    (12.225030, 52.251801),
    (12.225720, 52.251740),
    (12.256650, 52.249069),
    (12.261740, 52.248631),
    (12.266100, 52.248280),
    (12.282260, 52.246990),
    (12.285430, 52.246780),
    (12.288500, 52.246658),
    (12.291590, 52.246750),
    (12.293490, 52.246891),
    (12.295680, 52.247169),
    (12.298310, 52.247650),
    (12.301450, 52.248470),
    (12.302460, 52.248791),
    (12.303680, 52.249241),
    (12.304370, 52.249500),
    (12.305230, 52.249821),
    (12.313510, 52.253349),
    (12.314190, 52.253639),
    (12.336280, 52.262920),
    (12.338910, 52.263882),
    (12.341070, 52.264481),
    (12.343050, 52.264950),
    (12.345230, 52.265339),
    (12.362520, 52.267719),
    (12.431900, 52.277241),
    (12.434010, 52.277550),
    (12.436580, 52.278061),
    (12.438510, 52.278561),
    (12.440700, 52.279259),
    (12.442440, 52.279900),
    (12.443860, 52.280529),
    (12.445220, 52.281189),
    (12.446400, 52.281849),
    (12.455230, 52.287270),
    (12.458280, 52.289360),
    (12.460310, 52.290829),
    (12.462350, 52.292488),
    (12.465950, 52.295609),
    (12.470670, 52.299759),
    (12.476090, 52.304459),
    (12.479050, 52.307030),
    (12.482170, 52.309750),
    (12.485250, 52.312519),
    (12.487820, 52.314991),
    (12.490880, 52.318409),
    (12.495110, 52.323139),
    (12.498370, 52.326832),
    (12.501480, 52.330280),
    (12.504580, 52.333721),
    (12.505860, 52.335201),
    (12.506450, 52.335838),
    (12.507230, 52.336571),
    (12.508400, 52.337528),
    (12.509530, 52.338360),
    (12.510550, 52.338982),
    (12.510970, 52.339230),
    (12.512640, 52.340118),
    (12.513260, 52.340401),
    (12.514130, 52.340809),
    (12.516030, 52.341591),
    (12.519680, 52.342892),
    (12.523590, 52.344269),
    (12.533890, 52.347919),
    (12.536660, 52.348782),
    (12.539220, 52.349419),
    (12.540550, 52.349751),
    (12.540900, 52.349819),
    (12.545170, 52.350552),
    (12.547970, 52.350880),
    (12.550270, 52.351059),
    (12.552950, 52.351181),
    (12.555190, 52.351189),
    (12.558470, 52.351158),
    (12.564220, 52.351070),
    (12.576610, 52.350922),
    (12.593040, 52.350681),
    (12.595990, 52.350632),
    (12.597170, 52.350590),
    (12.598600, 52.350498),
    (12.599810, 52.350410),
    (12.601710, 52.350182),
    (12.603670, 52.349911),
    (12.605070, 52.349659),
    (12.606440, 52.349380),
    (12.608030, 52.348999),
    (12.611330, 52.348122),
    (12.622960, 52.344818),
    (12.623840, 52.344570),
    (12.624460, 52.344391),
    (12.627790, 52.343460),
    (12.629730, 52.342911),
    (12.630380, 52.342720),
    (12.642090, 52.339420),
    (12.642970, 52.339191),
    (12.647150, 52.338009),
    (12.648890, 52.337540),
    (12.652240, 52.336620),
    (12.653700, 52.336250),
    (12.655360, 52.335899),
    (12.656730, 52.335670),
    (12.658540, 52.335419),
    (12.659740, 52.335300),
    (12.660930, 52.335209),
    (12.662180, 52.335152),
    (12.663090, 52.335121),
    (12.664030, 52.335129),
    (12.665500, 52.335171),
    (12.667210, 52.335270),
    (12.668830, 52.335411),
    (12.681370, 52.336739),
    (12.682070, 52.336811),
    (12.688020, 52.337440),
    (12.688730, 52.337521),
    (12.694720, 52.338161),
    (12.698200, 52.338520),
    (12.699360, 52.338631),
    (12.700870, 52.338799),
    (12.703560, 52.339081),
    (12.709730, 52.339729),
    (12.711740, 52.339951),
    (12.713220, 52.340092),
    (12.714300, 52.340160),
    (12.715550, 52.340210),
    (12.716970, 52.340221),
    (12.718340, 52.340179),
    (12.719680, 52.340111),
    (12.720690, 52.340050),
    (12.721430, 52.340000),
    (12.723750, 52.339859),
    (12.725330, 52.339790),
    (12.726110, 52.339771),
    (12.728040, 52.339729),
    (12.731750, 52.339642),
    (12.734090, 52.339588),
    (12.734990, 52.339611),
    (12.736280, 52.339661),
    (12.737440, 52.339729),
    (12.751660, 52.340691),
    (12.757700, 52.341099),
    (12.758480, 52.341141),
    (12.759660, 52.341209),
    (12.761340, 52.341270),
    (12.762910, 52.341259),
    (12.764640, 52.341171),
    (12.766080, 52.341049),
    (12.775800, 52.340149),
    (12.786890, 52.339111),
    (12.789910, 52.338871),
    (12.797160, 52.338409),
    (12.798920, 52.338299),
    (12.804110, 52.338009),
    (12.805840, 52.337910),
    (12.806810, 52.337830),
    (12.807680, 52.337711),
    (12.808710, 52.337509),
    (12.809700, 52.337280),
    (12.810700, 52.336960),
    (12.811940, 52.336460),
    (12.812680, 52.336109),
    (12.813380, 52.335690),
    (12.814050, 52.335190),
    (12.814260, 52.335030),
    (12.814470, 52.334839),
    (12.815130, 52.334141),
    (12.815610, 52.333599),
    (12.816120, 52.332981),
    (12.816730, 52.332359),
    (12.817230, 52.331921),
    (12.817940, 52.331402),
    (12.818690, 52.330929),
    (12.819610, 52.330479),
    (12.820400, 52.330170),
    (12.821240, 52.329880),
    (12.824390, 52.328949),
    (12.828370, 52.327759),
    (12.838430, 52.324871),
    (12.842380, 52.323738),
    (12.845870, 52.322739),
    (12.852710, 52.320759),
    (12.854590, 52.320202),
    (12.855640, 52.319859),
    (12.856490, 52.319580),
    (12.857380, 52.319260),
    (12.858520, 52.318802),
    (12.859410, 52.318409),
    (12.861300, 52.317501),
    (12.864130, 52.316090),
    (12.869840, 52.313278),
    (12.874000, 52.311230),
    (12.875580, 52.310440),
    (12.875820, 52.310322),
    (12.877530, 52.309509),
    (12.882600, 52.306961),
    (12.885130, 52.305679),
    (12.900260, 52.298168),
    (12.901990, 52.297329),
    (12.903640, 52.296490),
    (12.905730, 52.295471),
    (12.911700, 52.292488),
    (12.913530, 52.291592),
    (12.913940, 52.291409),
    (12.914830, 52.291069),
    (12.915400, 52.290920),
    (12.915930, 52.290779),
    (12.916740, 52.290630),
    (12.917690, 52.290520),
    (12.918310, 52.290482),
    (12.918790, 52.290451),
    (12.919240, 52.290451),
    (12.919920, 52.290482),
    (12.920990, 52.290581),
    (12.921830, 52.290749),
    (12.922740, 52.290970),
    (12.923710, 52.291271),
    (12.925080, 52.291809),
    (12.925990, 52.292110),
    (12.927430, 52.292511),
    (12.929490, 52.292961),
    (12.952280, 52.298199),
    (12.957070, 52.299309),
    (12.968360, 52.301849),
    (12.971160, 52.302490),
    (12.972770, 52.302849),
    (12.973450, 52.303020),
    (12.974100, 52.303169),
    (12.975030, 52.303341),
    (12.975950, 52.303471),
    (12.976580, 52.303539),
    (12.977330, 52.303600),
    (12.978170, 52.303638),
    (13.008040, 52.303379),
    (13.008660, 52.303322),
    (13.009480, 52.303280),
    (13.010430, 52.303249),
    (13.010930, 52.303219),
    (13.011450, 52.303162),
    (13.012040, 52.303059),
    (13.013970, 52.302910),
    (13.014370, 52.302849),
    (13.014660, 52.302799),
    (13.015060, 52.302719),
    (13.015580, 52.302582),
    (13.015720, 52.302540),
    (13.016150, 52.302441),
    (13.016210, 52.302422),
    (13.017660, 52.302010),
    (13.017930, 52.301929),
    (13.018020, 52.301910),
    (13.018180, 52.301880),
    (13.018420, 52.301861),
    (13.018670, 52.301819),
    (13.019480, 52.301571),
    (13.019910, 52.301540),
    (13.024850, 52.300140),
    (13.025320, 52.299999),
    (13.025890, 52.299839),
    (13.027300, 52.299450),
    (13.028280, 52.299179),
    (13.029000, 52.298981),
    (13.029480, 52.298851),
    (13.030070, 52.298691),
    (13.030510, 52.298599),
    (13.031000, 52.298489),
    (13.031500, 52.298409),
    (13.031910, 52.298351),
    (13.032350, 52.298302),
    (13.032750, 52.298260),
    (13.033160, 52.298229),
    (13.033570, 52.298222),
    (13.034020, 52.298210),
    (13.034480, 52.298210),
    (13.034770, 52.298210),
    (13.035350, 52.298229),
    (13.035790, 52.298248),
    (13.036390, 52.298309),
    (13.036890, 52.298370),
    (13.037500, 52.298470),
    (13.038050, 52.298580),
    (13.038600, 52.298691),
    (13.039300, 52.298889),
    (13.039770, 52.299019),
    (13.040380, 52.299240),
    (13.042630, 52.300060),
    (13.043380, 52.300331),
    (13.043860, 52.300480),
    (13.044410, 52.300621),
    (13.044910, 52.300739),
    (13.045350, 52.300819),
    (13.045860, 52.300911),
    (13.046340, 52.300980),
    (13.046860, 52.301041),
    (13.047350, 52.301090),
    (13.047840, 52.301121),
    (13.048340, 52.301140),
    (13.048960, 52.301140),
    (13.053110, 52.300999),
    (13.061630, 52.300701),
    (13.062230, 52.300671),
    (13.067090, 52.300499),
    (13.077720, 52.300159),
    (13.079520, 52.300110),
    (13.081230, 52.300049),
    (13.082190, 52.300030),
    (13.082930, 52.300060),
    (13.083620, 52.300091),
    (13.084300, 52.300140),
    (13.085200, 52.300228),
    (13.085820, 52.300331),
    (13.086960, 52.300541),
    (13.095170, 52.302139),
    (13.095260, 52.302139),
    (13.095850, 52.302261),
    (13.097340, 52.302559),
    (13.097990, 52.302670),
    (13.098570, 52.302750),
    (13.099330, 52.302830),
    (13.099790, 52.302860),
    (13.100390, 52.302898),
    (13.100910, 52.302921),
    (13.101390, 52.302929),
    (13.101960, 52.302921),
    (13.103990, 52.302879),
    (13.112850, 52.302631),
    (13.116350, 52.302570),
    (13.117120, 52.302540),
    (13.123870, 52.302391),
    (13.125530, 52.302311),
    (13.141690, 52.301029),
    (13.142490, 52.300968),
    (13.143980, 52.300850),
    (13.144470, 52.300831),
    (13.144880, 52.300812),
    (13.145390, 52.300812),
    (13.145920, 52.300800),
    (13.153460, 52.300850),
    (13.155580, 52.300819),
    (13.156120, 52.300800),
    (13.156620, 52.300781),
    (13.157140, 52.300739),
    (13.164180, 52.300209),
    (13.175240, 52.299351),
    (13.180640, 52.298931),
    (13.180970, 52.298920),
    (13.181420, 52.298908),
    (13.182100, 52.298908),
    (13.182570, 52.298920),
    (13.183010, 52.298931),
    (13.183490, 52.298962),
    (13.183910, 52.299000),
    (13.184310, 52.299042),
    (13.184750, 52.299091),
    (13.185190, 52.299149),
    (13.185690, 52.299221),
    (13.186080, 52.299301),
    (13.186460, 52.299370),
    (13.186780, 52.299431),
    (13.187320, 52.299561),
    (13.189250, 52.300030),
    (13.189950, 52.300190),
    (13.195300, 52.301510),
    (13.195660, 52.301579),
    (13.196120, 52.301670),
    (13.196520, 52.301731),
    (13.196930, 52.301800),
    (13.197300, 52.301849),
    (13.197730, 52.301899),
    (13.198060, 52.301929),
    (13.198410, 52.301960),
    (13.198870, 52.301979),
    (13.199350, 52.302010),
    (13.199770, 52.302021),
    (13.200110, 52.302021),
    (13.200530, 52.302010),
    (13.200890, 52.302010),
    (13.201350, 52.301998),
    (13.204370, 52.301891),
    (13.208190, 52.301739),
    (13.212510, 52.301590),
    (13.216580, 52.301430),
    (13.217610, 52.301399),
    (13.228140, 52.301010),
    (13.238760, 52.300629),
    (13.245770, 52.300362),
    (13.246180, 52.300339),
    (13.246670, 52.300331),
    (13.247130, 52.300320),
    (13.247610, 52.300320),
    (13.248020, 52.300320),
    (13.248490, 52.300331),
    (13.248960, 52.300350),
    (13.249440, 52.300369),
    (13.249960, 52.300419),
    (13.250480, 52.300461),
    (13.251020, 52.300529),
    (13.251540, 52.300598),
    (13.252070, 52.300701),
    (13.252590, 52.300812),
    (13.253120, 52.300919),
    (13.253600, 52.301041),
    (13.254090, 52.301170),
    (13.254670, 52.301331),
    (13.256820, 52.302052),
    (13.261490, 52.303631),
    (13.269090, 52.306171),
    (13.270180, 52.306549),
    (13.271920, 52.307129),
    (13.272380, 52.307289),
    (13.272850, 52.307430),
    (13.273350, 52.307571),
    (13.273830, 52.307701),
    (13.274300, 52.307819),
    (13.274810, 52.307941),
    (13.275320, 52.308048),
    (13.275810, 52.308140),
    (13.276320, 52.308239),
    (13.276800, 52.308319),
    (13.277320, 52.308392),
    (13.277840, 52.308449),
    (13.278350, 52.308510),
    (13.278890, 52.308559),
    (13.279420, 52.308590),
    (13.279940, 52.308601),
    (13.280480, 52.308609),
    (13.281000, 52.308620),
    (13.281530, 52.308601),
    (13.282060, 52.308571),
    (13.282550, 52.308552),
    (13.283110, 52.308498),
    (13.287640, 52.308010),
    (13.290700, 52.307640),
    (13.292300, 52.307468),
    (13.292830, 52.307430),
    (13.293320, 52.307388),
    (13.293850, 52.307369),
    (13.294910, 52.307350),
    (13.299500, 52.307259),
    (13.299880, 52.307259),
    (13.301670, 52.307220),
    (13.302440, 52.307178),
    (13.307490, 52.306789),
    (13.315530, 52.306160),
    (13.322290, 52.305630),
    (13.323360, 52.305561),
    (13.324420, 52.305519),
    (13.325470, 52.305500),
    (13.326560, 52.305500),
    (13.327600, 52.305531),
    (13.328690, 52.305580),
    (13.329760, 52.305660),
    (13.330870, 52.305771),
    (13.332030, 52.305901),
    (13.332780, 52.305969),
    (13.337120, 52.306438),
    (13.338030, 52.306530),
    (13.346600, 52.307461),
    (13.347680, 52.307571),
    (13.348730, 52.307659),
    (13.349790, 52.307709),
    (13.350730, 52.307739),
    (13.350860, 52.307751),
    (13.351910, 52.307758),
    (13.361540, 52.307690),
    (13.362370, 52.307690),
    (13.373330, 52.307610),
    (13.374340, 52.307590),
    (13.375230, 52.307549),
    (13.376120, 52.307499),
    (13.377130, 52.307430),
    (13.383940, 52.306961),
    (13.384850, 52.306900),
    (13.387660, 52.306709),
    (13.389970, 52.306549),
    (13.390380, 52.306530),
    (13.394690, 52.306259),
    (13.397370, 52.306160),
    (13.405090, 52.306030),
    (13.415100, 52.305882),
    (13.415750, 52.305882),
    (13.417210, 52.305851),
    (13.418310, 52.305840),
    (13.422420, 52.305801),
    (13.426090, 52.305828),
    (13.427570, 52.305851),
    (13.432750, 52.305931),
    (13.439150, 52.306030),
    (13.440540, 52.306080),
    (13.441310, 52.306141),
    (13.441600, 52.306160),
    (13.442380, 52.306229),
    (13.442900, 52.306290),
    (13.445510, 52.306641),
    (13.446600, 52.306839),
    (13.451870, 52.307899),
    (13.452980, 52.308128),
    (13.454210, 52.308380),
    (13.456110, 52.308769),
    (13.457860, 52.309120),
    (13.460550, 52.309681),
    (13.460780, 52.309719),
    (13.463900, 52.310341),
    (13.464500, 52.310459),
    (13.468600, 52.311310),
    (13.471770, 52.311951),
    (13.474960, 52.312611),
    (13.475350, 52.312679),
    (13.479510, 52.313530),
    (13.479950, 52.313622),
    (13.485670, 52.314789),
    (13.487830, 52.315231),
    (13.496450, 52.316971),
    (13.497990, 52.317291),
    (13.501230, 52.317951),
    (13.504420, 52.318600),
    (13.505640, 52.318810),
    (13.506420, 52.318932),
    (13.507180, 52.319031),
    (13.508220, 52.319141),
    (13.509160, 52.319210),
    (13.510010, 52.319260),
    (13.510740, 52.319302),
    (13.511550, 52.319309),
    (13.512310, 52.319321),
    (13.512930, 52.319309),
    (13.513680, 52.319290),
    (13.515050, 52.319229),
    (13.521420, 52.318851),
    (13.525850, 52.318569),
    (13.529360, 52.318359),
    (13.531070, 52.318310),
    (13.532680, 52.318279),
    (13.536010, 52.318340),
    (13.537040, 52.318371),
    (13.544710, 52.318588),
    (13.550870, 52.318771),
    (13.554570, 52.318890),
    (13.554780, 52.318890),
    (13.556580, 52.318951),
    (13.557850, 52.318970),
    (13.561250, 52.319111),
    (13.562410, 52.319141),
    (13.569820, 52.319351),
    (13.573750, 52.319481),
    (13.579050, 52.319611),
    (13.581390, 52.319679),
    (13.581790, 52.319679),
    (13.582280, 52.319672),
    (13.582740, 52.319649),
    (13.583240, 52.319630),
    (13.583710, 52.319592),
    (13.584290, 52.319530),
    (13.584770, 52.319469),
    (13.585300, 52.319401),
    (13.585790, 52.319302),
    (13.586300, 52.319199),
    (13.586740, 52.319111),
    (13.587160, 52.318981),
    (13.587580, 52.318878),
    (13.588000, 52.318771),
    (13.588540, 52.318600),
    (13.589080, 52.318409),
    (13.598340, 52.314541),
    (13.601870, 52.313011),
    (13.602440, 52.312778),
    (13.603550, 52.312370),
    (13.604420, 52.312092),
    (13.605830, 52.311699),
    (13.606620, 52.311562),
    (13.607410, 52.311440),
    (13.608280, 52.311340),
    (13.609650, 52.311218),
    (13.611020, 52.311131),
    (13.614750, 52.310940),
    (13.616850, 52.310749),
    (13.619420, 52.310581),
    (13.622190, 52.310410),
    (13.625030, 52.310219),
    (13.626990, 52.310089),
    (13.627500, 52.310070),
    (13.628450, 52.310070),
    (13.629390, 52.310070),
    (13.631210, 52.310169),
    (13.632530, 52.310249),
    (13.633490, 52.310280),
    (13.634270, 52.310299),
    (13.636980, 52.310390),
    (13.643890, 52.310650),
    (13.646030, 52.310699),
    (13.648170, 52.310829),
    (13.649040, 52.310890),
    (13.651330, 52.311039),
    (13.654370, 52.311359),
    (13.654970, 52.311451),
    (13.658490, 52.311939),
    (13.662560, 52.312649),
    (13.662700, 52.312679),
    (13.663310, 52.312778),
    (13.663630, 52.312840),
    (13.668210, 52.313709),
    (13.670780, 52.314220),
    (13.680740, 52.316711),
    (13.688530, 52.318481),
    (13.698690, 52.320930),
    (13.710610, 52.323811),
    (13.711570, 52.324039),
    (13.712430, 52.324181),
    (13.713570, 52.324329),
    (13.714400, 52.324421),
    (13.715380, 52.324478),
    (13.716400, 52.324501),
    (13.720130, 52.324390),
    (13.725390, 52.324230),
    (13.726510, 52.324211),
    (13.731150, 52.324032),
    (13.733640, 52.323959),
    (13.738060, 52.323719),
    (13.742050, 52.323471),
    (13.746680, 52.323330),
    (13.751640, 52.323170),
    (13.753060, 52.323151),
    (13.754100, 52.323158),
    (13.755050, 52.323200),
    (13.755920, 52.323231),
    (13.756700, 52.323261),
    (13.757510, 52.323280),
    (13.758260, 52.323280),
    (13.759340, 52.323261),
    (13.760090, 52.323231),
    (13.761710, 52.323090),
    (13.762770, 52.323009),
    (13.763620, 52.322910),
    (13.764640, 52.322769),
    (13.766320, 52.322479),
    (13.768990, 52.321991),
    (13.772660, 52.321259),
    (13.774100, 52.320969),
    (13.779390, 52.319851),
    (13.782620, 52.319210),
    (13.783960, 52.318939),
    (13.786130, 52.318501),
    (13.790780, 52.317551),
    (13.791020, 52.317509),
    (13.791810, 52.317341),
    (13.792900, 52.317108),
    (13.795190, 52.316570),
    (13.799770, 52.315449),
    (13.801290, 52.315079),
    (13.808440, 52.313332),
    (13.816510, 52.311310),
    (13.819120, 52.310841),
    (13.820420, 52.310638),
    (13.821700, 52.310490),
    (13.822920, 52.310379),
    (13.824100, 52.310299),
    (13.825230, 52.310242),
    (13.826590, 52.310211),
    (13.827630, 52.310211),
    (13.829190, 52.310280),
    (13.831020, 52.310390),
    (13.834560, 52.310612),
    (13.838080, 52.310829),
    (13.841170, 52.311031),
    (13.859730, 52.312199),
    (13.864920, 52.312481),
    (13.871600, 52.312920),
    (13.873940, 52.313129),
    (13.875990, 52.313400),
    (13.878480, 52.313770),
    (13.890500, 52.315659),
    (13.892830, 52.316002),
    (13.893820, 52.316109),
    (13.893950, 52.316139),
    (13.895130, 52.316231),
    (13.897110, 52.316341),
    (13.897430, 52.316349),
    (13.897820, 52.316360),
    (13.898430, 52.316368),
    (13.899410, 52.316368),
    (13.899740, 52.316368),
    (13.900800, 52.316319),
    (13.901260, 52.316299),
    (13.901460, 52.316280),
    (13.902170, 52.316231),
    (13.902650, 52.316200),
    (13.903500, 52.316120),
    (13.904230, 52.316051),
    (13.905060, 52.315929),
    (13.906220, 52.315769),
    (13.907530, 52.315540),
    (13.908080, 52.315449),
    (13.909350, 52.315250),
    (13.912430, 52.314678),
    (13.917170, 52.313839),
    (13.918560, 52.313591),
    (13.920600, 52.313251),
    (13.922720, 52.313000),
    (13.924570, 52.312859),
    (13.928280, 52.312672),
    (13.931980, 52.312469),
    (13.936850, 52.312210),
    (13.943620, 52.311890),
    (13.945010, 52.311821),
    (13.947110, 52.311699),
    (13.949250, 52.311600),
    (13.951860, 52.311531),
    (13.953880, 52.311501),
    (13.955690, 52.311520),
    (13.956470, 52.311550),
    (13.957230, 52.311550),
    (13.957590, 52.311550),
    (13.958480, 52.311600),
    (13.959390, 52.311649),
    (13.960510, 52.311710),
    (13.963300, 52.311890),
    (13.964030, 52.311958),
    (13.964760, 52.312031),
    (13.965530, 52.312111),
    (13.967600, 52.312309),
    (13.970420, 52.312679),
    (13.976950, 52.313519),
    (13.982210, 52.314190),
    (13.989010, 52.315079),
    (13.991140, 52.315590),
    (13.995350, 52.316631),
    (14.010750, 52.320862),
    (14.011740, 52.321140),
    (14.016990, 52.322540),
    (14.033020, 52.327091),
    (14.035490, 52.327888),
    (14.038170, 52.328770),
    (14.039940, 52.329361),
    (14.040850, 52.329639),
    (14.041850, 52.329868),
    (14.044900, 52.330509),
    (14.048330, 52.331181),
    (14.054310, 52.332371),
    (14.059400, 52.333389),
    (14.063500, 52.334190),
    (14.064160, 52.334278),
    (14.064990, 52.334389),
    (14.066080, 52.334450),
    (14.067790, 52.334480),
    (14.068820, 52.334492),
    (14.069610, 52.334499),
    (14.071800, 52.334530),
    (14.076110, 52.334610),
    (14.076730, 52.334621),
    (14.079480, 52.334629),
    (14.079900, 52.334641),
    (14.083190, 52.334690),
    (14.083960, 52.334709),
    (14.094040, 52.334930),
    (14.101640, 52.335129),
    (14.103790, 52.335171),
    (14.109770, 52.335300),
    (14.110470, 52.335320),
    (14.115300, 52.335442),
    (14.120590, 52.335579),
    (14.129080, 52.335781),
    (14.135940, 52.335941),
    (14.142780, 52.336109),
    (14.144190, 52.336159),
    (14.145630, 52.336269),
    (14.146980, 52.336399),
    (14.148470, 52.336590),
    (14.150050, 52.336849),
    (14.151060, 52.337040),
    (14.153230, 52.337559),
    (14.158990, 52.339050),
    (14.162260, 52.339931),
    (14.165920, 52.340870),
    (14.173330, 52.342800),
    (14.175650, 52.343361),
    (14.178100, 52.343769),
    (14.180730, 52.343922),
    (14.183420, 52.343849),
    (14.186900, 52.343418),
    (14.189890, 52.342861),
    (14.194280, 52.341751),
    (14.197150, 52.340660),
    (14.203530, 52.338570),
    (14.209150, 52.337471),
    (14.214410, 52.337059),
    (14.225970, 52.336620),
    (14.241650, 52.336029),
    (14.244650, 52.335850),
    (14.246820, 52.335609),
    (14.248630, 52.335361),
    (14.250900, 52.334930),
    (14.253710, 52.334209),
    (14.254860, 52.333839),
    (14.255420, 52.333649),
    (14.258210, 52.332611),
    (14.265300, 52.330059),
    (14.269440, 52.328659),
    (14.270810, 52.328289),
    (14.273100, 52.327721),
    (14.275730, 52.327179),
    (14.279540, 52.326401),
    (14.284480, 52.325371),
    (14.287700, 52.324718),
    (14.291050, 52.324291),
    (14.297960, 52.323990),
    (14.311890, 52.323471),
    (14.325860, 52.322960),
    (14.347400, 52.322159),
    (14.350580, 52.322029),
    (14.359000, 52.321739),
    (14.372530, 52.321239),
    (14.379740, 52.320950),
    (14.380240, 52.320938),
    (14.381830, 52.320881),
    (14.391430, 52.320560),
    (14.398040, 52.320290),
    (14.402530, 52.320190),
    (14.411640, 52.320221),
    (14.421280, 52.320320),
    (14.430980, 52.320400),
    (14.448890, 52.320591),
    (14.457170, 52.320690),
    (14.461260, 52.320679),
    (14.463750, 52.320641),
    (14.465980, 52.320591),
    (14.469340, 52.320530),
    (14.474220, 52.320431),
    (14.476170, 52.320412),
    (14.478410, 52.320358),
    (14.486460, 52.320190),
    (14.497410, 52.320011),
    (14.503240, 52.319920),
    (14.506290, 52.319832),
    (14.509290, 52.319721),
    (14.512840, 52.319519),
    (14.516510, 52.319302),
    (14.519920, 52.319069),
    (14.520700, 52.318989),
    (14.521670, 52.318890),
    (14.522650, 52.318729),
    (14.523810, 52.318451),
    (14.524880, 52.318111),
    (14.526010, 52.317699),
    (14.528360, 52.316898),
    (14.529150, 52.316601),
    (14.529920, 52.316311),
    (14.530360, 52.316170),
    (14.531150, 52.315948),
    (14.532090, 52.315681),
    (14.532660, 52.315552),
    (14.534120, 52.315231),
    (14.535880, 52.314899),
    (14.537050, 52.314720),
    (14.538460, 52.314548),
    (14.539610, 52.314442),
    (14.541020, 52.314350),
    (14.543540, 52.314289),
    (14.545710, 52.314320),
    (14.547280, 52.314381),
    (14.547860, 52.314388),
    (14.551430, 52.314510),
    (14.553820, 52.314579),
    (14.555630, 52.314610),
    (14.557090, 52.314621),
    (14.560080, 52.314590),
    (14.563030, 52.314548),
    (14.566590, 52.314499),
    (14.568220, 52.314579),
    (14.570630, 52.314789),
    (14.573180, 52.315029),
    (14.577680, 52.315430),
    (14.581390, 52.315800),
    (14.584040, 52.316078),
    (14.585230, 52.316212),
    (14.586150, 52.316299),
    (14.586610, 52.316319),
    (14.587420, 52.316380),
    (14.588230, 52.316490),
    (14.589910, 52.316669),
    (14.590260, 52.316700),
    (14.591270, 52.316830),
    (14.592640, 52.317039),
    (14.593280, 52.317169),
    (14.597120, 52.318180),
    (14.606010, 52.320629),
    (14.611060, 52.321980),
    (14.611630, 52.322140),
    (14.615200, 52.323078),
    (14.621090, 52.324699),
    (14.622960, 52.325180),
    (14.624350, 52.325459),
    (14.626080, 52.325741),
    (14.628220, 52.326019),
    (14.629100, 52.326092),
    (14.630640, 52.326199),
    (14.633120, 52.326248),
    (14.635360, 52.326160),
    (14.637460, 52.325989),
    (14.638980, 52.325851),
    (14.640770, 52.325691),
    (14.642970, 52.325489),
    (14.645360, 52.325272),
    (14.650070, 52.324810),
    (14.651870, 52.324631),
    (14.657510, 52.324131),
    (14.657730, 52.324120),
    (14.661480, 52.323959),
    (14.664560, 52.323940),
    (14.668520, 52.324268),
    (14.673860, 52.324959),
    (14.681930, 52.325951),
    (14.687980, 52.326790),
    (14.695770, 52.327820),
    (14.699480, 52.328308),
    (14.699910, 52.328381),
    (14.702760, 52.328800),
    (14.707160, 52.329350),
    (14.710180, 52.329762),
    (14.713110, 52.330120),
    (14.716110, 52.330570),
    (14.717430, 52.330719),
    (14.719870, 52.330990),
    (14.722980, 52.331348),
    (14.724190, 52.331509),
    (14.730330, 52.332329),
    (14.735100, 52.332970),
    (14.739980, 52.333672),
    (14.745970, 52.334278),
    (14.749610, 52.334839),
    (14.752850, 52.335121),
    (14.755990, 52.335320),
    (14.760150, 52.335251),
    (14.762590, 52.335251),
    (14.768020, 52.335251),
    (14.777380, 52.335281),
    (14.787830, 52.335312),
    (14.795240, 52.335312),
    (14.800100, 52.335312),
    (14.802870, 52.335121),
    (14.805950, 52.334740),
    (14.809920, 52.334000),
    (14.817190, 52.332600),
    (14.824690, 52.331188),
    (14.830980, 52.329979),
    (14.836990, 52.328960),
    (14.839050, 52.328659),
    (14.841760, 52.328522),
    (14.842560, 52.328499),
    (14.843740, 52.328541),
    (14.844960, 52.328590),
    (14.845750, 52.328621),
    (14.846370, 52.328690),
    (14.846940, 52.328739),
    (14.847760, 52.328831),
    (14.848110, 52.328869),
    (14.850100, 52.329151),
    (14.855030, 52.329880),
    (14.875600, 52.333172),
    (14.877770, 52.333542),
    (14.884010, 52.334438),
    (14.894500, 52.335011),
    (14.897290, 52.335060),
    (14.903640, 52.334839),
    (14.912530, 52.334080),
    (14.917210, 52.333851),
    (14.920660, 52.333939),
    (14.923950, 52.334221),
    (14.942390, 52.337490),
    (14.945660, 52.337959),
    (14.949630, 52.338470),
    (14.955640, 52.338371),
    (14.959930, 52.337681),
    (14.972060, 52.335072),
    (14.978420, 52.333679),
    (14.984860, 52.332790),
    (15.014210, 52.332489),
    (15.017210, 52.332470),
    (15.019230, 52.332359),
    (15.022400, 52.331928),
    (15.029720, 52.330811),
    (15.040660, 52.328541),
    (15.051960, 52.326160),
    (15.057440, 52.325199),
    (15.062210, 52.324680),
    (15.065990, 52.324520),
    (15.070300, 52.324551),
    (15.079760, 52.324860),
    (15.084980, 52.325050),
    (15.089620, 52.325111),
    (15.096840, 52.325298),
    (15.106060, 52.325520),
    (15.134010, 52.326260),
    (15.141860, 52.326530),
    (15.148840, 52.326599),
    (15.153770, 52.326420),
    (15.158660, 52.326069),
    (15.165720, 52.325298),
    (15.172770, 52.324230),
    (15.180940, 52.322510),
    (15.185700, 52.321178),
    (15.192000, 52.319199),
    (15.197980, 52.316959),
    (15.204170, 52.314671),
    (15.210300, 52.312710),
    (15.216020, 52.311481),
    (15.222380, 52.310791),
    (15.234390, 52.310040),
    (15.238000, 52.309811),
    (15.241970, 52.309299),
    (15.244940, 52.308620),
    (15.248080, 52.307560),
    (15.250510, 52.306511),
    (15.253310, 52.304852),
    (15.255260, 52.303299),
    (15.258480, 52.300861),
    (15.261660, 52.298618),
    (15.265100, 52.297039),
    (15.269280, 52.295712),
    (15.273790, 52.294769),
    (15.278350, 52.294399),
    (15.284460, 52.294231),
    (15.290280, 52.294762),
    (15.294180, 52.295330),
    (15.298300, 52.296082),
    (15.308130, 52.298470),
    (15.325480, 52.302799),
    (15.334270, 52.304981),
    (15.342390, 52.306999),
    (15.361300, 52.311710),
    (15.380580, 52.316380),
    (15.389680, 52.318008),
    (15.394060, 52.318531),
    (15.398210, 52.318890),
    (15.403980, 52.319118),
    (15.409600, 52.319031),
    (15.415450, 52.318649),
    (15.421370, 52.318130),
    (15.435500, 52.316940),
    (15.443140, 52.316601),
    (15.450850, 52.316429),
    (15.460130, 52.316448),
    (15.469640, 52.316780),
    (15.480500, 52.317581),
    (15.525930, 52.322929),
    (15.534810, 52.323811),
    (15.542090, 52.323990),
    (15.546080, 52.323750),
    (15.553530, 52.322948),
    (15.566190, 52.320820),
    (15.584820, 52.317322),
    (15.594200, 52.315411),
    (15.602580, 52.313671),
    (15.611310, 52.311298),
    (15.645000, 52.301800),
    (15.653580, 52.299480),
    (15.660380, 52.298550),
    (15.666340, 52.298111),
    (15.693540, 52.296860),
    (15.706100, 52.296539),
    (15.712540, 52.296532),
    (15.716380, 52.296692),
    (15.719710, 52.297009),
    (15.726210, 52.297649),
    (15.733410, 52.298710),
    (15.741850, 52.300629),
    (15.752860, 52.303860),
    (15.766420, 52.308010),
    (15.769980, 52.309109),
    (15.779090, 52.311970),
    (15.792040, 52.315861),
    (15.806970, 52.320320),
    (15.815940, 52.323009),
    (15.822290, 52.324772),
    (15.829860, 52.326359),
    (15.837110, 52.327572),
    (15.850700, 52.328609),
    (15.866580, 52.328949),
    (15.867550, 52.328979),
    (15.868890, 52.328991),
    (15.872030, 52.329029),
    (15.881970, 52.329041),
    (15.885570, 52.329102),
    (15.907500, 52.329449),
    (15.913320, 52.329540),
    (15.925070, 52.329750),
    (15.936360, 52.330448),
    (15.945400, 52.331379),
    (15.953600, 52.332611),
    (15.961800, 52.334122),
    (15.995240, 52.342091),
    (16.007250, 52.344440),
    (16.049379, 52.350460),
    (16.069920, 52.353291),
    (16.093580, 52.357590),
    (16.097740, 52.358330),
    (16.100071, 52.358749),
    (16.101440, 52.358990),
    (16.102610, 52.359211),
    (16.104290, 52.359539),
    (16.108561, 52.360352),
    (16.117229, 52.361950),
    (16.123461, 52.362999),
    (16.130489, 52.363850),
    (16.136801, 52.364521),
    (16.147249, 52.365608),
    (16.161501, 52.367062),
    (16.165270, 52.367298),
    (16.168301, 52.367420),
    (16.172119, 52.367451),
    (16.185591, 52.367611),
    (16.187149, 52.367630),
    (16.192730, 52.367821),
    (16.196550, 52.368038),
    (16.201460, 52.368622),
    (16.207010, 52.369450),
    (16.222179, 52.372471),
    (16.238211, 52.375481),
    (16.241230, 52.375839),
    (16.244749, 52.376221),
    (16.249599, 52.376629),
    (16.263130, 52.377140),
    (16.270679, 52.377380),
    (16.279659, 52.377781),
    (16.288481, 52.378220),
    (16.309139, 52.379379),
    (16.321550, 52.380039),
    (16.342890, 52.381180),
    (16.356291, 52.381981),
    (16.369160, 52.382660),
    (16.377230, 52.383240),
    (16.383631, 52.383869),
    (16.396589, 52.385590),
    (16.408449, 52.387280),
    (16.415630, 52.388142),
    (16.422710, 52.388851),
    (16.428341, 52.389351),
    (16.434139, 52.389690),
    (16.445290, 52.390060),
    (16.448879, 52.390018),
    (16.453251, 52.389881),
    (16.456450, 52.389729),
    (16.459141, 52.389500),
    (16.461380, 52.389240),
    (16.466070, 52.388569),
    (16.473820, 52.387341),
    (16.475540, 52.387070),
    (16.477989, 52.386841),
    (16.479481, 52.386749),
    (16.480310, 52.386700),
    (16.483351, 52.386551),
    (16.486731, 52.386478),
    (16.491039, 52.386570),
    (16.494961, 52.386761),
    (16.499990, 52.387081),
    (16.507830, 52.387459),
    (16.511551, 52.387501),
    (16.514919, 52.387451),
    (16.520399, 52.387249),
    (16.526070, 52.386700),
    (16.531031, 52.386040),
    (16.535200, 52.385269),
    (16.537630, 52.384708),
    (16.540649, 52.383999),
    (16.551830, 52.380840),
    (16.560900, 52.378120),
    (16.561279, 52.378010),
    (16.563869, 52.377232),
    (16.566050, 52.376591),
    (16.575661, 52.373539),
    (16.584909, 52.370152),
    (16.599230, 52.364700),
    (16.609520, 52.360741),
    (16.616970, 52.357941),
    (16.619610, 52.357101),
    (16.622040, 52.356419),
    (16.624540, 52.355820),
    (16.628189, 52.355068),
    (16.638000, 52.353432),
    (16.646940, 52.352150),
    (16.654249, 52.350979),
    (16.656679, 52.350590),
    (16.660419, 52.349979),
    (16.664169, 52.349369),
    (16.666870, 52.349030),
    (16.671410, 52.348579),
    (16.679750, 52.348389),
    (16.691719, 52.348930),
    (16.704990, 52.349468),
    (16.713869, 52.349819),
    (16.715731, 52.349899),
    (16.718731, 52.350010),
    (16.726601, 52.350319),
    (16.729759, 52.350422),
    (16.730129, 52.350441),
    (16.731810, 52.350491),
    (16.731850, 52.350491),
    (16.731960, 52.350491),
    (16.731979, 52.350491),
    (16.733709, 52.350491),
    (16.736811, 52.350491),
    (16.742020, 52.350491),
    (16.750790, 52.350479),
    (16.761419, 52.350521),
    (16.770590, 52.350479),
    (16.778931, 52.350430),
    (16.795071, 52.350460),
    (16.810120, 52.350330),
    (16.826269, 52.350300),
    (16.838690, 52.350288),
    (16.841270, 52.350361),
    (16.845310, 52.350529),
    (16.846109, 52.350571),
    (16.849070, 52.350800),
    (16.851641, 52.351028),
    (16.851950, 52.351070),
    (16.863569, 52.352489),
    (16.876530, 52.354092),
    (16.879700, 52.354420),
    (16.884821, 52.354610),
    (16.886431, 52.354622),
    (16.888260, 52.354610),
    (16.890070, 52.354580),
    (16.892290, 52.354500),
    (16.895750, 52.354301),
    (16.897921, 52.354149),
    (16.899799, 52.353989),
    (16.901699, 52.353840),
    (16.902439, 52.353779),
    (16.907690, 52.353359),
    (16.910280, 52.353130),
    (16.914261, 52.352810),
    (16.916389, 52.352650),
    (16.919210, 52.352428),
    (16.923109, 52.352100),
    (16.937201, 52.350979),
    (16.949640, 52.349918),
    (16.956039, 52.349400),
    (16.961029, 52.348999),
    (16.965500, 52.348652),
    (16.973419, 52.348000),
    (16.986170, 52.347019),
    (16.991770, 52.346531),
    (17.000900, 52.345741),
    (17.004881, 52.345322),
    (17.007601, 52.345009),
    (17.013760, 52.344269),
    (17.020700, 52.343330),
    (17.025400, 52.342529),
    (17.034031, 52.340950),
    (17.049919, 52.337791),
    (17.064600, 52.334721),
    (17.078711, 52.331821),
    (17.087839, 52.329639),
    (17.089300, 52.329311),
    (17.092470, 52.328499),
    (17.094801, 52.327869),
    (17.099489, 52.326542),
    (17.107441, 52.324188),
    (17.114479, 52.322010),
    (17.124830, 52.318771),
    (17.124960, 52.318729),
    (17.128820, 52.317520),
    (17.136431, 52.315140),
    (17.144501, 52.312561),
    (17.147800, 52.311531),
    (17.149670, 52.311031),
    (17.150949, 52.310692),
    (17.151051, 52.310669),
    (17.151300, 52.310612),
    (17.151421, 52.310589),
    (17.153610, 52.310101),
    (17.154390, 52.309872),
    (17.157721, 52.309158),
    (17.163059, 52.308281),
    (17.166821, 52.307789),
    (17.170919, 52.307411),
    (17.175390, 52.307159),
    (17.179951, 52.307072),
    (17.185240, 52.307159),
    (17.190941, 52.307610),
    (17.193920, 52.307919),
    (17.201851, 52.309040),
    (17.207350, 52.309639),
    (17.212879, 52.310059),
    (17.223009, 52.310219),
    (17.241720, 52.310131),
    (17.253790, 52.310131),
    (17.265499, 52.310059),
    (17.272200, 52.310009),
    (17.278469, 52.310040),
    (17.296169, 52.310001),
    (17.305731, 52.309929),
    (17.321720, 52.309929),
    (17.342350, 52.309841),
    (17.354420, 52.309818),
    (17.362419, 52.310108),
    (17.376181, 52.311218),
    (17.382330, 52.312019),
    (17.388250, 52.312881),
    (17.399639, 52.314861),
    (17.411970, 52.317001),
    (17.414829, 52.317390),
    (17.417191, 52.317711),
    (17.421089, 52.318138),
    (17.424089, 52.318409),
    (17.425091, 52.318489),
    (17.427660, 52.318691),
    (17.431700, 52.318920),
    (17.436029, 52.319038),
    (17.440769, 52.319050),
    (17.454201, 52.318821),
    (17.468769, 52.318630),
    (17.482670, 52.318409),
    (17.496050, 52.318180),
    (17.509060, 52.317921),
    (17.513220, 52.317699),
    (17.521919, 52.316971),
    (17.526711, 52.316311),
    (17.529650, 52.315899),
    (17.531231, 52.315552),
    (17.531919, 52.315262),
    (17.532320, 52.314949),
    (17.532579, 52.314449),
    (17.532690, 52.313931),
    (17.532721, 52.313709),
    (17.532900, 52.313400),
    (17.533180, 52.313160),
    (17.533661, 52.312901),
    (17.534140, 52.312790),
    (17.535089, 52.312660),
    (17.537979, 52.312389),
    (17.540131, 52.312119),
    (17.540211, 52.312050),
    (17.540260, 52.312031),
    (17.540291, 52.311951),
    (17.540371, 52.311680),
    (17.540400, 52.311550),
    (17.540489, 52.311111),
    (17.540710, 52.310650),
    (17.541161, 52.309971),
    (17.541880, 52.309269),
    (17.542521, 52.308830),
    (17.542919, 52.308590),
    (17.543131, 52.308472),
    (17.544741, 52.307850),
    (17.545010, 52.307770),
    (17.545589, 52.307590),
    (17.546570, 52.307289),
    (17.548800, 52.306599),
    (17.549089, 52.306469),
    (17.549259, 52.306381),
    (17.549271, 52.306301),
    (17.549339, 52.306221),
    (17.549410, 52.306190),
    (17.549561, 52.306160),
    (17.549709, 52.306190),
    (17.549810, 52.306240),
    (17.549870, 52.306358),
    (17.549820, 52.306450),
    (17.549780, 52.306480),
    (17.549919, 52.306782),
    (17.550961, 52.308361),
    (17.552139, 52.310181),
    (17.552441, 52.310711),
    (17.553921, 52.312820),
    (17.554529, 52.313641),
    (17.554741, 52.313629),
    (17.554911, 52.313709),
    (17.555559, 52.313580),
    (17.556240, 52.313389),
    (17.556780, 52.313240),
    (17.557289, 52.313160),
    (17.558620, 52.312969),
    (17.563829, 52.312168),
    (17.568171, 52.311501),
    (17.569120, 52.311501),
    (17.570061, 52.311661),
    (17.570820, 52.311909),
    (17.572210, 52.312511),
    (17.575109, 52.313751),
    (17.580099, 52.316212),
    (17.581940, 52.317131),
    (17.582109, 52.317059),
    (17.582239, 52.317131),
    (17.582260, 52.317299),
    (17.591841, 52.322079),
    (17.593470, 52.322899),
    (17.595200, 52.323669),
    (17.597691, 52.324501),
    (17.600439, 52.325150),
    (17.602650, 52.325489),
    (17.610991, 52.326290),
    (17.612070, 52.326389),
    (17.616261, 52.326771),
    (17.618530, 52.326981),
    (17.620930, 52.326950),
    (17.625080, 52.326351),
    (17.630070, 52.325581),
    (17.634701, 52.324890),
    (17.635469, 52.324772),
    (17.639090, 52.324211),
    (17.644131, 52.323441),
    (17.645760, 52.323231),
    (17.649719, 52.323078),
    (17.654930, 52.322880),
    (17.659500, 52.322701),
    (17.663910, 52.322510),
    (17.665409, 52.322430),
    (17.669571, 52.322449),
    (17.671431, 52.322460),
    (17.675159, 52.321980),
    (17.675320, 52.321960),
    (17.678539, 52.321899),
    (17.684780, 52.321812),
    (17.691059, 52.321671),
    (17.694660, 52.321720),
    (17.700939, 52.322041),
    (17.704840, 52.322281),
    (17.706450, 52.322250),
    (17.712780, 52.321701),
    (17.718519, 52.321220),
    (17.724510, 52.320690),
    (17.726589, 52.320740),
    (17.729259, 52.320820),
    (17.732750, 52.320930),
    (17.738630, 52.321152),
    (17.740990, 52.321152),
    (17.743330, 52.320919),
    (17.750771, 52.319420),
    (17.757271, 52.318192),
    (17.765110, 52.318439),
    (17.768921, 52.317822),
    (17.770720, 52.317669),
    (17.771641, 52.317791),
    (17.776390, 52.318741),
    (17.778669, 52.319000),
    (17.780680, 52.319012),
    (17.781050, 52.319012),
    (17.783670, 52.318829),
    (17.789230, 52.317570),
    (17.797211, 52.315601),
    (17.805929, 52.313480),
    (17.810341, 52.312401),
    (17.813641, 52.311600),
    (17.814590, 52.311371),
    (17.815290, 52.311111),
    (17.817551, 52.310280),
    (17.818331, 52.309990),
    (17.819960, 52.309391),
    (17.820360, 52.309250),
    (17.823561, 52.308071),
    (17.825010, 52.307571),
    (17.829069, 52.306221),
    (17.834209, 52.304508),
    (17.837660, 52.303299),
    (17.843309, 52.300629),
    (17.848810, 52.298031),
    (17.854540, 52.295311),
    (17.860399, 52.292549),
    (17.864611, 52.290531),
    (17.865049, 52.290310),
    (17.865410, 52.290039),
    (17.865549, 52.289860),
    (17.865549, 52.289768),
    (17.865601, 52.289711),
    (17.865650, 52.289688),
    (17.865721, 52.289669),
    (17.865841, 52.289680),
    (17.865940, 52.289711),
    (17.865959, 52.289730),
    (17.865990, 52.289768),
    (17.865999, 52.289829),
    (17.866091, 52.289822),
    (17.866220, 52.289799),
    (17.866529, 52.289669),
    (17.866779, 52.289581),
    (17.866791, 52.289520),
    (17.866859, 52.289471),
    (17.866989, 52.289459),
    (17.867029, 52.289410),
    (17.867620, 52.289101),
    (17.868530, 52.288670),
    (17.869690, 52.288109),
    (17.870939, 52.287590),
    (17.872110, 52.287239),
    (17.872881, 52.287010),
    (17.873240, 52.286911),
    (17.873751, 52.286819),
    (17.874180, 52.286739),
    (17.875660, 52.286572),
    (17.876240, 52.286480),
    (17.878031, 52.286201),
    (17.879259, 52.286018),
    (17.879860, 52.285919),
    (17.880501, 52.285801),
    (17.880600, 52.285789),
    (17.883101, 52.284969),
    (17.887421, 52.283581),
    (17.888941, 52.283051),
    (17.889429, 52.282902),
    (17.889730, 52.282822),
    (17.889999, 52.282791),
    (17.890190, 52.282780),
    (17.890551, 52.282730),
    (17.890619, 52.282669),
    (17.890560, 52.282631),
    (17.890530, 52.282600),
    (17.890499, 52.282539),
    (17.890511, 52.282501),
    (17.890520, 52.282459),
    (17.890570, 52.282410),
    (17.890650, 52.282372),
    (17.890699, 52.282349),
    (17.890829, 52.282341),
    (17.890909, 52.282360),
    (17.891710, 52.282181),
    (17.892910, 52.281811),
    (17.899090, 52.279800),
    (17.899920, 52.279579),
    (17.900669, 52.279449),
    (17.903799, 52.279190),
    (17.904619, 52.279060),
    (17.905491, 52.278839),
    (17.906620, 52.278419),
    (17.908340, 52.277248),
    (17.909760, 52.276470),
    (17.911570, 52.275829),
    (17.921329, 52.272469),
    (17.937460, 52.263641),
    (17.956169, 52.253769),
    (17.958750, 52.252399),
    (17.960810, 52.252090),
    (17.995489, 52.248508),
    (18.003380, 52.247780),
    (18.008190, 52.247879),
    (18.019690, 52.248409),
    (18.030331, 52.247150),
    (18.061041, 52.245140),
    (18.081181, 52.243660),
    (18.083620, 52.243481),
    (18.086220, 52.243279),
    (18.088440, 52.243130),
    (18.092360, 52.242840),
    (18.092350, 52.242771),
    (18.092390, 52.242722),
    (18.092470, 52.242680),
    (18.092569, 52.242661),
    (18.092710, 52.242691),
    (18.092779, 52.242741),
    (18.092800, 52.242802),
    (18.093210, 52.242771),
    (18.094580, 52.242680),
    (18.095360, 52.242680),
    (18.097000, 52.242779),
    (18.097740, 52.242790),
    (18.099400, 52.242760),
    (18.099621, 52.242760),
    (18.100220, 52.242748),
    (18.100380, 52.242748),
    (18.103991, 52.242680),
    (18.106251, 52.242641),
    (18.114321, 52.242512),
    (18.117729, 52.242451),
    (18.143881, 52.243092),
    (18.145260, 52.243019),
    (18.146799, 52.242710),
    (18.149191, 52.241810),
    (18.151239, 52.241261),
    (18.154840, 52.240372),
    (18.188250, 52.235580),
    (18.192940, 52.234940),
    (18.193689, 52.234829),
    (18.199640, 52.234009),
    (18.200640, 52.233860),
    (18.202101, 52.233650),
    (18.207590, 52.232849),
    (18.207750, 52.232830),
    (18.210970, 52.232361),
    (18.211769, 52.232319),
    (18.211910, 52.232361),
    (18.212061, 52.232288),
    (18.212351, 52.232281),
    (18.212500, 52.232231),
    (18.213150, 52.232052),
    (18.219040, 52.231239),
    (18.219170, 52.231220),
    (18.221760, 52.230869),
    (18.222111, 52.230808),
    (18.223400, 52.230598),
    (18.224770, 52.230320),
    (18.226959, 52.229851),
    (18.228170, 52.229591),
    (18.230150, 52.229172),
    (18.232510, 52.228661),
    (18.233431, 52.228470),
    (18.234320, 52.228279),
    (18.239700, 52.227131),
    (18.239901, 52.227089),
    (18.241430, 52.226761),
    (18.243719, 52.226261),
    (18.243750, 52.226131),
    (18.243950, 52.226009),
    (18.244190, 52.226009),
    (18.244450, 52.226131),
    (18.245581, 52.225868),
    (18.246241, 52.225731),
    (18.246599, 52.225681),
    (18.247110, 52.225601),
    (18.247561, 52.225441),
    (18.248569, 52.225208),
    (18.249229, 52.224998),
    (18.249580, 52.224831),
    (18.249910, 52.224651),
    (18.250050, 52.224541),
    (18.250330, 52.224251),
    (18.250580, 52.223862),
    (18.250879, 52.223110),
    (18.250980, 52.222912),
    (18.252430, 52.219280),
    (18.252670, 52.218880),
    (18.253201, 52.218281),
    (18.253790, 52.217628),
    (18.255859, 52.215401),
    (18.256559, 52.214809),
    (18.257931, 52.213692),
    (18.258289, 52.213409),
    (18.259171, 52.212700),
    (18.260090, 52.211960),
    (18.262831, 52.209869),
    (18.270050, 52.204010),
    (18.270399, 52.203819),
    (18.271231, 52.203411),
    (18.272209, 52.203091),
    (18.272480, 52.203011),
    (18.272690, 52.202969),
    (18.272940, 52.202919),
    (18.273720, 52.202770),
    (18.274210, 52.202721),
    (18.274950, 52.202560),
    (18.276640, 52.202221),
    (18.277731, 52.201988),
    (18.278629, 52.201809),
    (18.281620, 52.201199),
    (18.289351, 52.199638),
    (18.301750, 52.197021),
    (18.305389, 52.196270),
    (18.312389, 52.194870),
    (18.315889, 52.194199),
    (18.320650, 52.193211),
    (18.328430, 52.191570),
    (18.340090, 52.189140),
    (18.347509, 52.187630),
    (18.351219, 52.186771),
    (18.356600, 52.185650),
    (18.361509, 52.184650),
    (18.366680, 52.183529),
    (18.371960, 52.182411),
    (18.379070, 52.180969),
    (18.384871, 52.179749),
    (18.389879, 52.178661),
    (18.394800, 52.177670),
    (18.400860, 52.176449),
    (18.405199, 52.175491),
    (18.410469, 52.174400),
    (18.415020, 52.173630),
    (18.416691, 52.173630),
    (18.420380, 52.174320),
    (18.421061, 52.174412),
    (18.422409, 52.174469),
    (18.425890, 52.174400),
    (18.431320, 52.174301),
    (18.434980, 52.174240),
    (18.438641, 52.174110),
    (18.443649, 52.174019),
    (18.450720, 52.173840),
    (18.458700, 52.173660),
    (18.475010, 52.173370),
    (18.486191, 52.173119),
    (18.492510, 52.172958),
    (18.500191, 52.172771),
    (18.507509, 52.172829),
    (18.509069, 52.172871),
    (18.511530, 52.172932),
    (18.515970, 52.173019),
    (18.524281, 52.173210),
    (18.530710, 52.173340),
    (18.534420, 52.173370),
    (18.539120, 52.173500),
    (18.545441, 52.173660),
    (18.550980, 52.173820),
    (18.554800, 52.173920),
    (18.561331, 52.174019),
    (18.567909, 52.174179),
    (18.570721, 52.174179),
    (18.570910, 52.174179),
    (18.571409, 52.174240),
    (18.576380, 52.175362),
    (18.581450, 52.176579),
    (18.589180, 52.178471),
    (18.595551, 52.179939),
    (18.601980, 52.181419),
    (18.606159, 52.182381),
    (18.608431, 52.182800),
    (18.610491, 52.182899),
    (18.610920, 52.183399),
    (18.611210, 52.183601),
    (18.615829, 52.184700),
    (18.619110, 52.185471),
    (18.620390, 52.185760),
    (18.629360, 52.187820),
    (18.631380, 52.188271),
    (18.631510, 52.188190),
    (18.631660, 52.188171),
    (18.631821, 52.188202),
    (18.631929, 52.188271),
    (18.631950, 52.188339),
    (18.631941, 52.188419),
    (18.631889, 52.188469),
    (18.634359, 52.190029),
    (18.634609, 52.190380),
    (18.634670, 52.190689),
    (18.634630, 52.190922),
    (18.634460, 52.191219),
    (18.634251, 52.191582),
    (18.634470, 52.191639),
    (18.634550, 52.191750),
    (18.634411, 52.193062),
    (18.634300, 52.193909),
    (18.634220, 52.194382),
    (18.634130, 52.194462),
    (18.633900, 52.194592),
    (18.634430, 52.195148),
    (18.636311, 52.197369),
    (18.637630, 52.198978),
    (18.638439, 52.199921),
    (18.639561, 52.200199),
    (18.641560, 52.200668),
    (18.642611, 52.200920),
    (18.646320, 52.201801),
    (18.647070, 52.202091),
    (18.647120, 52.202049),
    (18.647190, 52.202030),
    (18.647310, 52.202019),
    (18.647421, 52.202049),
    (18.647511, 52.202110),
    (18.647970, 52.202148),
    (18.648300, 52.202229),
    (18.659580, 52.204929),
    (18.663980, 52.205921),
    (18.665001, 52.205940),
    (18.666149, 52.205761),
    (18.667360, 52.205349),
    (18.667419, 52.205399),
    (18.669479, 52.206970),
    (18.671671, 52.208561),
    (18.672421, 52.209110),
    (18.673220, 52.209702),
    (18.674770, 52.210369),
    (18.676310, 52.210678),
    (18.677629, 52.210732),
    (18.679911, 52.210461),
    (18.682190, 52.210361),
    (18.685480, 52.211060),
    (18.707380, 52.216282),
    (18.723631, 52.220341),
    (18.740179, 52.224468),
    (18.761070, 52.229771),
    (18.774151, 52.232971),
    (18.777250, 52.233742),
    (18.791170, 52.237202),
    (18.814440, 52.242981),
    (18.832359, 52.247540),
    (18.838200, 52.249008),
    (18.843590, 52.250240),
    (18.845110, 52.250511),
    (18.848881, 52.250931),
    (18.853649, 52.251480),
    (18.864920, 52.252789),
    (18.881430, 52.254711),
    (18.893669, 52.256168),
    (18.895350, 52.256229),
    (18.897690, 52.256130),
    (18.899700, 52.256001),
    (18.905581, 52.255482),
    (18.908171, 52.255009),
    (18.910839, 52.254601),
    (18.913570, 52.254238),
    (18.914570, 52.254089),
    (18.915560, 52.253891),
    (18.919010, 52.252560),
    (18.920570, 52.252110),
    (18.923180, 52.251961),
    (18.924049, 52.251919),
    (18.927750, 52.251751),
    (18.937000, 52.250671),
    (18.942400, 52.250080),
    (18.947941, 52.249538),
    (18.953840, 52.248959),
    (18.967060, 52.249111),
    (18.978081, 52.249161),
    (18.993450, 52.249329),
    (19.022381, 52.249641),
    (19.037729, 52.249779),
    (19.057770, 52.251240),
    (19.062490, 52.251560),
    (19.078590, 52.252621),
    (19.087900, 52.253010),
    (19.097851, 52.253391),
    (19.098301, 52.252651),
    (19.100410, 52.250050),
    (19.102510, 52.248348),
    (19.102680, 52.248211),
    (19.106131, 52.248081),
    (19.112711, 52.247890),
    (19.116409, 52.248081),
    (19.119570, 52.248428),
    (19.129230, 52.248489),
    (19.132219, 52.248379),
    (19.132780, 52.248211),
    (19.133989, 52.247910),
    (19.136061, 52.248112),
    (19.143221, 52.248798),
    (19.144760, 52.248428),
    (19.146049, 52.248371),
    (19.150400, 52.248791),
    (19.154869, 52.249931),
    (19.155210, 52.250111),
    (19.155830, 52.250439),
    (19.156290, 52.250610),
    (19.157089, 52.250820),
    (19.157909, 52.251041),
    (19.158430, 52.251179),
    (19.159491, 52.251350),
    (19.159769, 52.251400),
    (19.160210, 52.251530),
    (19.161860, 52.252048),
    (19.162830, 52.252350),
    (19.163080, 52.252430),
    (19.165310, 52.253109),
    (19.166000, 52.253319),
    (19.167870, 52.253929),
    (19.170031, 52.254082),
    (19.170040, 52.254791),
    (19.170059, 52.255871),
    (19.170771, 52.255859),
    (19.171080, 52.255852),
    (19.173180, 52.255798),
    (19.174749, 52.255772),
    (19.177340, 52.255718),
    (19.184870, 52.255581),
    (19.185410, 52.255539),
    (19.185801, 52.255409),
    (19.186239, 52.255280),
    (19.188431, 52.255241),
    (19.189030, 52.255329),
    (19.190531, 52.255291),
    (19.191151, 52.255459),
    (19.195700, 52.255360),
    (19.197201, 52.255112),
    (19.199301, 52.254509),
    (19.199980, 52.254318),
    (19.201010, 52.254028),
    (19.204729, 52.252998),
    (19.213940, 52.250370),
    (19.221689, 52.248699),
    (19.230410, 52.246910),
    (19.238400, 52.245220),
    (19.246651, 52.243561),
    (19.254869, 52.241871),
    (19.259621, 52.240871),
    (19.260960, 52.240429),
    (19.261471, 52.240181),
    (19.263260, 52.239311),
    (19.265921, 52.238239),
    (19.268141, 52.238159),
    (19.269831, 52.238571),
    (19.271111, 52.238800),
    (19.272249, 52.238850),
    (19.273951, 52.238811),
    (19.277100, 52.238461),
    (19.282230, 52.237900),
    (19.287399, 52.237339),
    (19.296709, 52.236359),
    (19.297529, 52.236271),
    (19.304729, 52.235481),
    (19.312590, 52.234631),
    (19.315479, 52.234150),
    (19.316460, 52.233780),
    (19.317141, 52.233521),
    (19.318279, 52.232792),
    (19.319950, 52.231079),
    (19.320780, 52.230339),
    (19.321680, 52.229462),
    (19.325310, 52.225819),
    (19.326210, 52.224918),
    (19.327101, 52.224129),
    (19.327730, 52.223598),
    (19.328920, 52.222889),
    (19.331511, 52.221642),
    (19.338480, 52.218380),
    (19.338980, 52.218090),
    (19.342680, 52.216400),
    (19.344561, 52.215790),
    (19.348150, 52.215031),
    (19.350771, 52.214470),
    (19.354900, 52.213570),
    (19.355600, 52.213409),
    (19.356300, 52.213249),
    (19.358801, 52.212700),
    (19.365080, 52.211281),
    (19.367050, 52.210960),
    (19.369400, 52.210941),
    (19.371731, 52.211288),
    (19.373770, 52.211941),
    (19.380480, 52.214779),
    (19.385851, 52.216991),
    (19.386290, 52.217152),
    (19.387329, 52.217590),
    (19.388611, 52.218121),
    (19.391710, 52.219349),
    (19.392851, 52.219818),
    (19.394199, 52.220371),
    (19.395330, 52.220890),
    (19.404119, 52.224468),
    (19.405670, 52.224911),
    (19.406651, 52.225090),
    (19.408079, 52.225201),
    (19.410160, 52.225040),
    (19.421770, 52.223900),
    (19.427210, 52.223358),
    (19.431721, 52.222851),
    (19.431730, 52.222820),
    (19.431749, 52.222790),
    (19.431810, 52.222740),
    (19.431850, 52.222721),
    (19.431890, 52.222710),
    (19.431990, 52.222691),
    (19.432079, 52.222698),
    (19.432171, 52.222721),
    (19.432249, 52.222759),
    (19.432289, 52.222790),
    (19.434370, 52.222591),
    (19.436371, 52.222462),
    (19.444071, 52.221691),
    (19.451731, 52.220940),
    (19.456949, 52.220440),
    (19.460630, 52.220100),
    (19.465050, 52.219631),
    (19.478041, 52.218391),
    (19.480280, 52.218170),
    (19.490030, 52.217159),
    (19.512360, 52.215012),
    (19.528200, 52.213451),
    (19.536350, 52.212681),
    (19.572590, 52.209068),
    (19.573191, 52.209011),
    (19.576130, 52.208340),
    (19.577801, 52.207859),
    (19.581690, 52.210312),
    (19.585791, 52.212872),
    (19.588449, 52.214561),
    (19.589291, 52.215481),
    (19.591129, 52.217701),
    (19.595900, 52.223301),
    (19.598000, 52.225101),
    (19.599670, 52.226131),
    (19.601351, 52.227112),
    (19.605021, 52.229450),
    (19.605740, 52.229519),
    (19.607180, 52.229530),
    (19.607830, 52.229542),
    (19.609091, 52.230320),
    (19.609400, 52.230370),
    (19.615530, 52.228699),
    (19.616131, 52.228580),
    (19.617331, 52.228249),
    (19.618900, 52.227909),
    (19.619720, 52.227749),
    (19.622101, 52.231258),
    (19.622940, 52.232441),
    (19.623350, 52.232330),
    (19.623541, 52.232281),
    (19.627701, 52.231121),
    (19.629101, 52.232800),
    (19.629890, 52.233730),
    (19.631729, 52.235909),
    (19.632259, 52.236549),
    (19.634371, 52.236080),
    (19.636040, 52.235699),
    (19.637199, 52.235439),
    (19.638100, 52.235222),
    (19.638580, 52.235142),
    (19.651711, 52.237110),
    (19.652399, 52.237202),
    (19.653431, 52.237370),
    (19.654579, 52.237541),
    (19.655920, 52.237759),
    (19.657631, 52.238010),
    (19.659389, 52.238312),
    (19.661110, 52.238571),
    (19.680220, 52.241619),
    (19.698179, 52.244518),
    (19.699261, 52.244370),
    (19.700871, 52.244122),
    (19.702730, 52.243961),
    (19.703270, 52.243950),
    (19.705320, 52.243931),
    (19.710480, 52.243900),
    (19.711880, 52.243870),
    (19.712549, 52.243790),
    (19.714161, 52.243488),
    (19.716089, 52.243179),
    (19.719360, 52.242641),
    (19.722860, 52.242050),
    (19.723040, 52.242008),
    (19.723471, 52.241920),
    (19.724039, 52.241711),
    (19.726480, 52.240700),
    (19.728371, 52.239971),
    (19.728979, 52.239792),
    (19.730400, 52.239380),
    (19.731230, 52.239071),
    (19.731550, 52.238918),
    (19.731951, 52.238602),
    (19.732651, 52.237869),
    (19.732830, 52.237091),
    (19.733000, 52.236172),
    (19.733080, 52.236031),
    (19.733290, 52.235931),
    (19.737129, 52.234829),
    (19.741230, 52.233719),
    (19.743799, 52.233101),
    (19.746941, 52.233021),
    (19.751450, 52.233212),
    (19.758301, 52.232349),
    (19.763460, 52.231739),
    (19.766451, 52.230869),
    (19.767920, 52.230419),
    (19.769779, 52.229839),
    (19.770370, 52.229610),
    (19.770901, 52.229309),
    (19.770990, 52.229229),
    (19.771830, 52.229301),
    (19.772200, 52.229340),
    (19.772619, 52.229401),
    (19.774870, 52.230049),
    (19.776630, 52.230549),
    (19.777651, 52.230820),
    (19.779461, 52.231339),
    (19.781460, 52.231930),
    (19.781960, 52.232040),
    (19.782419, 52.232079),
    (19.786301, 52.232231),
    (19.790260, 52.232361),
    (19.793949, 52.232498),
    (19.795410, 52.232559),
    (19.797871, 52.232639),
    (19.800650, 52.232738),
    (19.803659, 52.232849),
    (19.806290, 52.232948),
    (19.810631, 52.233089),
    (19.812740, 52.233170),
    (19.814779, 52.233250),
    (19.815491, 52.233280),
    (19.818729, 52.233391),
    (19.821711, 52.233501),
    (19.823891, 52.233551),
    (19.824261, 52.233570),
    (19.826160, 52.233631),
    (19.831699, 52.233810),
    (19.833719, 52.233860),
    (19.835661, 52.233860),
    (19.839380, 52.233849),
    (19.842951, 52.233841),
    (19.844761, 52.233849),
    (19.846251, 52.233841),
    (19.847139, 52.233829),
    (19.847580, 52.233841),
    (19.847980, 52.233910),
    (19.848709, 52.234051),
    (19.849331, 52.234161),
    (19.849850, 52.234268),
    (19.851650, 52.234638),
    (19.853239, 52.234798),
    (19.853809, 52.234890),
    (19.854219, 52.235050),
    (19.855499, 52.236351),
    (19.856110, 52.236679),
    (19.861731, 52.239120),
    (19.865940, 52.241058),
    (19.867241, 52.241619),
    (19.867809, 52.241692),
    (19.869671, 52.241741),
    (19.871321, 52.241741),
    (19.871481, 52.241730),
    (19.873211, 52.241638),
    (19.873730, 52.241581),
    (19.880541, 52.241299),
    (19.880989, 52.241249),
    (19.881069, 52.241280),
    (19.883221, 52.241211),
    (19.886360, 52.241070),
    (19.892839, 52.240810),
    (19.895020, 52.240730),
    (19.895981, 52.240688),
    (19.896460, 52.240711),
    (19.897890, 52.240940),
    (19.900591, 52.241341),
    (19.901649, 52.241508),
    (19.906429, 52.242229),
    (19.909010, 52.242599),
    (19.910391, 52.242802),
    (19.911840, 52.243011),
    (19.914829, 52.243469),
    (19.917040, 52.243809),
    (19.917509, 52.243881),
    (19.917879, 52.243889),
    (19.920160, 52.243790),
    (19.920200, 52.243778),
    (19.920980, 52.243771),
    (19.921101, 52.243759),
    (19.921640, 52.243660),
    (19.922079, 52.243568),
    (19.922310, 52.243488),
    (19.924030, 52.243462),
    (19.925440, 52.243469),
    (19.927071, 52.243500),
    (19.929750, 52.243519),
    (19.931709, 52.243542),
    (19.934771, 52.243568),
    (19.935450, 52.243580),
    (19.936270, 52.243580),
    (19.936649, 52.243580),
    (19.936911, 52.243629),
    (19.940519, 52.244499),
    (19.941170, 52.244671),
    (19.946720, 52.246010),
    (19.950979, 52.247082),
    (19.955580, 52.248169),
    (19.959391, 52.249088),
    (19.962049, 52.249729),
    (19.964821, 52.250420),
    (19.967421, 52.251060),
    (19.967550, 52.251091),
    (19.968969, 52.251400),
    (19.973110, 52.252430),
    (19.973419, 52.252499),
    (19.973690, 52.252560),
    (19.978081, 52.253632),
    (19.981970, 52.254551),
    (19.982330, 52.254581),
    (19.982809, 52.254761),
    (19.983610, 52.254951),
    (19.985109, 52.255341),
    (19.987591, 52.255970),
    (19.990191, 52.256569),
    (19.991199, 52.256821),
    (19.991449, 52.256809),
    (19.992290, 52.256729),
    (19.994390, 52.256630),
    (19.996040, 52.256561),
    (19.997040, 52.256519),
    (19.998659, 52.256489),
    (20.006901, 52.256699),
    (20.008631, 52.256741),
    (20.017210, 52.256939),
    (20.017700, 52.256931),
    (20.024111, 52.256859),
    (20.033489, 52.256741),
    (20.041599, 52.256641),
    (20.042749, 52.256630),
    (20.043699, 52.256550),
    (20.046391, 52.256149),
    (20.049400, 52.255630),
    (20.050341, 52.255451),
    (20.055519, 52.254520),
    (20.057230, 52.254219),
    (20.059910, 52.253738),
    (20.062420, 52.253300),
    (20.069441, 52.251968),
    (20.076811, 52.250462),
    (20.085699, 52.248772),
    (20.086180, 52.248619),
    (20.086800, 52.248508),
    (20.092779, 52.248169),
    (20.093170, 52.248119),
    (20.093321, 52.248058),
    (20.100500, 52.243580),
    (20.101419, 52.243011),
    (20.101810, 52.242760),
    (20.102091, 52.242619),
    (20.102360, 52.242538),
    (20.102930, 52.242409),
    (20.103340, 52.242310),
    (20.103781, 52.242180),
    (20.105459, 52.241501),
    (20.105600, 52.241531),
    (20.117611, 52.240589),
    (20.120569, 52.240398),
    (20.129551, 52.240070),
    (20.134100, 52.239910),
    (20.136419, 52.239819),
    (20.138590, 52.239761),
    (20.140120, 52.239719),
    (20.141211, 52.239700),
    (20.142941, 52.239799),
    (20.144850, 52.239899),
    (20.147341, 52.240059),
    (20.153601, 52.239491),
    (20.156521, 52.239120),
    (20.160561, 52.238430),
    (20.165649, 52.238770),
    (20.167259, 52.238850),
    (20.168070, 52.239040),
    (20.175770, 52.241760),
    (20.179319, 52.242931),
    (20.181070, 52.240528),
    (20.181629, 52.239670),
    (20.182261, 52.238819),
    (20.182320, 52.238739),
    (20.182440, 52.238762),
    (20.182940, 52.238918),
    (20.183180, 52.238960),
    (20.183559, 52.238979),
    (20.183950, 52.238918),
    (20.185961, 52.238529),
    (20.193470, 52.237030),
    (20.197439, 52.236229),
    (20.199650, 52.235779),
    (20.201540, 52.235401),
    (20.203171, 52.235069),
    (20.211411, 52.233421),
    (20.216820, 52.232349),
    (20.219151, 52.231869),
    (20.222700, 52.231152),
    (20.223780, 52.230881),
    (20.224131, 52.230770),
    (20.224220, 52.230740),
    (20.224400, 52.230721),
    (20.224819, 52.230701),
    (20.225531, 52.230640),
    (20.226259, 52.230591),
    (20.227551, 52.230480),
    (20.230730, 52.230099),
    (20.232109, 52.229961),
    (20.235849, 52.229580),
    (20.236610, 52.229500),
    (20.237221, 52.229439),
    (20.238300, 52.229351),
    (20.240570, 52.229149),
    (20.245220, 52.228699),
    (20.247200, 52.228539),
    (20.247290, 52.228531),
    (20.250999, 52.228199),
    (20.251249, 52.228180),
    (20.254890, 52.227859),
    (20.256281, 52.227741),
    (20.258261, 52.227570),
    (20.264879, 52.226952),
    (20.265450, 52.226830),
    (20.265760, 52.226528),
    (20.265970, 52.226158),
    (20.266020, 52.226082),
    (20.266050, 52.226021),
    (20.267429, 52.226261),
    (20.267891, 52.226398),
    (20.269930, 52.226471),
    (20.270821, 52.226421),
    (20.279560, 52.225651),
    (20.284170, 52.225231),
    (20.312540, 52.222660),
    (20.312559, 52.222660),
    (20.332560, 52.220852),
    (20.337410, 52.220421),
    (20.341660, 52.220032),
    (20.349609, 52.219318),
    (20.360630, 52.218319),
    (20.371441, 52.217331),
    (20.379770, 52.216560),
    (20.386440, 52.215939),
    (20.399679, 52.214710),
    (20.410049, 52.213760),
    (20.416161, 52.213200),
    (20.421209, 52.212730),
    (20.428320, 52.212090),
    (20.430229, 52.211891),
    (20.432301, 52.211700),
    (20.442711, 52.210758),
    (20.444670, 52.210590),
    (20.457140, 52.209419),
    (20.464710, 52.208721),
    (20.488091, 52.206589),
    (20.504660, 52.205059),
    (20.512369, 52.204350),
    (20.513290, 52.204269),
    (20.528410, 52.202869),
    (20.541780, 52.201641),
    (20.545820, 52.201469),
    (20.571939, 52.200390),
    (20.603590, 52.199059),
    (20.605860, 52.198990),
    (20.605989, 52.198990),
    (20.606270, 52.198978),
    (20.609030, 52.198841),
    (20.610081, 52.198799),
    (20.612419, 52.198711),
    (20.615770, 52.198582),
    (20.616989, 52.198528),
    (20.617180, 52.198528),
    (20.617800, 52.198502),
    (20.619940, 52.199001),
    (20.621490, 52.199360),
    (20.622860, 52.199680),
    (20.623730, 52.199902),
    (20.624050, 52.199982),
    (20.625120, 52.200249),
    (20.630800, 52.201630),
    (20.650591, 52.206440),
    (20.653879, 52.207199),
    (20.656031, 52.207699),
    (20.656719, 52.207859),
    (20.659109, 52.208321),
    (20.663530, 52.208889),
    (20.664450, 52.208988),
    (20.673531, 52.210060),
    (20.681749, 52.211029),
    (20.684040, 52.211300),
    (20.684271, 52.211330),
    (20.688919, 52.211842),
    (20.691401, 52.212139),
    (20.696220, 52.212730),
    (20.699341, 52.212742),
    (20.700979, 52.212711),
    (20.707050, 52.212570),
    (20.714899, 52.212391),
    (20.735781, 52.211922),
    (20.740480, 52.211800),
    (20.747881, 52.211632),
    (20.748190, 52.211620),
    (20.756330, 52.211430),
    (20.757820, 52.211399),
    (20.764900, 52.211239),
    (20.768450, 52.211151),
    (20.769911, 52.211121),
    (20.774481, 52.210991),
    (20.776991, 52.210911),
    (20.777290, 52.210899),
    (20.778219, 52.210880),
    (20.779650, 52.210838),
    (20.782400, 52.210770),
    (20.785101, 52.210690),
    (20.785780, 52.210678),
    (20.788231, 52.210579),
    (20.788971, 52.210560),
    (20.791401, 52.210499),
    (20.793079, 52.210461),
    (20.794001, 52.210442),
    (20.794769, 52.210411),
    (20.796230, 52.210381),
    (20.797279, 52.210331),
    (20.798109, 52.210300),
    (20.801121, 52.210232),
    (20.804319, 52.210140),
    (20.807760, 52.210041),
    (20.809210, 52.209999),
    (20.809710, 52.209999),
    (20.810190, 52.210030),
    (20.810459, 52.210060),
    (20.810530, 52.210079),
    (20.811230, 52.210178),
    (20.817699, 52.211182),
    (20.823919, 52.212151),
    (20.825809, 52.212440),
    (20.826891, 52.212551),
    (20.830940, 52.213100),
    (20.835529, 52.213821),
    (20.838430, 52.214272),
    (20.838989, 52.214352),
    (20.839729, 52.214451),
    (20.841749, 52.214741),
    (20.845209, 52.214951),
    (20.849510, 52.215221),
    (20.849810, 52.215240),
    (20.859699, 52.215832),
    (20.859930, 52.215839),
    (20.861000, 52.215900),
    (20.861971, 52.215961),
    (20.862600, 52.216000),
    (20.864870, 52.216141),
    (20.865061, 52.216148),
    (20.867830, 52.216320),
    (20.869600, 52.216419),
    (20.871410, 52.216431),
    (20.873581, 52.216431),
    (20.873911, 52.216431),
    (20.874929, 52.216389),
    (20.877769, 52.216381),
    (20.880011, 52.216381),
    (20.880110, 52.216381),
    (20.880430, 52.216370),
    (20.880590, 52.216370),
    (20.882721, 52.216381),
    (20.883820, 52.216381),
    (20.885969, 52.216381),
    (20.888700, 52.216389),
    (20.890570, 52.216370),
    (20.890720, 52.216370),
    (20.892530, 52.216358),
    (20.896070, 52.216370),
    (20.896629, 52.216389),
    (20.897150, 52.216431),
    (20.897690, 52.216480),
    (20.898470, 52.216572),
    (20.900440, 52.216770),
    (20.900890, 52.216808),
    (20.901470, 52.216869),
    (20.901930, 52.216930),
    (20.904011, 52.217159),
    (20.904280, 52.217209),
    (20.906019, 52.217579),
    (20.907990, 52.218021),
    (20.909330, 52.218342),
    (20.909580, 52.218399),
    (20.910271, 52.218559),
    (20.914419, 52.219501),
    (20.915840, 52.219879),
    (20.916050, 52.219921),
    (20.916210, 52.219971),
    (20.916550, 52.220051),
    (20.918680, 52.220539),
    (20.920620, 52.221008),
    (20.921289, 52.221161),
    (20.923550, 52.221710),
    (20.924530, 52.221939),
    (20.925131, 52.222080),
    (20.926991, 52.222500),
    (20.928200, 52.222778),
    (20.929831, 52.223190),
    (20.930031, 52.223240),
    (20.930210, 52.223289),
    (20.931520, 52.223671),
    (20.932190, 52.223881),
    (20.932739, 52.224041),
    (20.936180, 52.225071),
    (20.936390, 52.225140),
    (20.936680, 52.225220),
    (20.936890, 52.225269),
    (20.938530, 52.225620),
    (20.939369, 52.225719),
    (20.939659, 52.225761),
    (20.940701, 52.225788),
    (20.941589, 52.225868),
    (20.941660, 52.225880),
    (20.941980, 52.225929),
    (20.942369, 52.225979),
    (20.944630, 52.226311),
    (20.946051, 52.226559),
    (20.948071, 52.226921),
    (20.951281, 52.227390),
    (20.951660, 52.227451),
    (20.951990, 52.227482),
    (20.954250, 52.227638),
    (20.955820, 52.227730),
    (20.956141, 52.227730),
    (20.956659, 52.227692),
    (20.956940, 52.227692),
    (20.957491, 52.227730),
    (20.957609, 52.227760),
    (20.958191, 52.227890),
    (20.958549, 52.227940),
    (20.959330, 52.227970),
    (20.959591, 52.225151),
    (20.959650, 52.224880),
    (20.959721, 52.224800),
    (20.960070, 52.224739),
    (20.960630, 52.224659),
    (20.961420, 52.224541),
    (20.962500, 52.224388),
    (20.963850, 52.224209),
    (20.964861, 52.224060),
    (20.967770, 52.223629),
    (20.968719, 52.223499),
    (20.969360, 52.223400),
    (20.969971, 52.223309),
    (20.970280, 52.223282),
    (20.971260, 52.223469),
    (20.971821, 52.223560),
    (20.974091, 52.224079),
    (20.975559, 52.224388),
    (20.977409, 52.224800),
    (20.977730, 52.224861),
    (20.978390, 52.225170),
    (20.981100, 52.225750),
    (20.983339, 52.226189),
    (20.984390, 52.226479),
    (20.986641, 52.227268),
    (20.986820, 52.227291),
    (20.987040, 52.227139),
    (20.987261, 52.226891),
    (20.987410, 52.226669),
    (20.987520, 52.226440),
    (20.988010, 52.225811),
    (20.988230, 52.225510),
    (20.988581, 52.225090),
    (20.988649, 52.225010),
    (20.988560, 52.224949),
    (20.988569, 52.224850),
    (20.988680, 52.224689),
    (20.988750, 52.224628),
    (20.988760, 52.224621),
    (20.988779, 52.224602),
    (20.988791, 52.224590),
    (20.988831, 52.224548),
    (20.988970, 52.224461),
    (20.989599, 52.224682),
    (20.989771, 52.224739),
    (20.990841, 52.225159),
    (20.991171, 52.225250),
    (20.992580, 52.225571),
    (20.995470, 52.226250),
    (20.995750, 52.226311),
    (20.995831, 52.226330),
    (20.995859, 52.226330),
    (20.996000, 52.226360),
    (20.996201, 52.226410),
    (20.997089, 52.226620),
    (20.999750, 52.227180),
    (21.000700, 52.227360),
    (21.001249, 52.227421),
    (21.001730, 52.227428),
    (21.002090, 52.227482),
    (21.002359, 52.227581),
    (21.003170, 52.227810),
    (21.003839, 52.228001),
    (21.005409, 52.228352),
    (21.007721, 52.228859),
    (21.009621, 52.229259),
    (21.010559, 52.229469),
    (21.010960, 52.229542),
    (21.011259, 52.229549),
    (21.011431, 52.229542),
    (21.011551, 52.229542),
    (21.011749, 52.229561),
    (21.011850, 52.229568),
    (21.011900, 52.229580),
    (21.012110, 52.229641),
    (21.012190, 52.229691),
    (21.012230, 52.229740),
    (21.012640, 52.229900),
    (21.012960, 52.230000),
    (21.013281, 52.230049),
    (21.014391, 52.230289),
    (21.016171, 52.230671),
    (21.016390, 52.230709),
    (21.016710, 52.230782),
    (21.018749, 52.231201),
    (21.020380, 52.231529),
    (21.020720, 52.231571),
    (21.020769, 52.231571),
    (21.020910, 52.231571),
    (21.021009, 52.231590),
    (21.021170, 52.231651),
    (21.021379, 52.231781),
    (21.021740, 52.231899),
    (21.022949, 52.232140),
    (21.023741, 52.232319),
    (21.025000, 52.232590),
    (21.026150, 52.232830),
    (21.026369, 52.232880),
    (21.026640, 52.232941),
    (21.032320, 52.234119),
    (21.033760, 52.234409),
    (21.034439, 52.234550),
    (21.035789, 52.234821),
    (21.036739, 52.234970),
    (21.037279, 52.235100),
    (21.037399, 52.235142),
    (21.037540, 52.235180),
    (21.044930, 52.236691),
    (21.045219, 52.236740),
    (21.045389, 52.236771),
    (21.046270, 52.236938),
    (21.047819, 52.237259),
    (21.048960, 52.237492),
    (21.049299, 52.237549),
    (21.049641, 52.237621),
    (21.050110, 52.237709),
    (21.050619, 52.237782),
    (21.050800, 52.237801),
    (21.051121, 52.237820),
    (21.051571, 52.237831),
    (21.051750, 52.237862),
    (21.051889, 52.237881),
    (21.052010, 52.237919),
    (21.052191, 52.237961),
    (21.052429, 52.238079),
    (21.052650, 52.238178),
    (21.052919, 52.238289),
    (21.053579, 52.238499),
    (21.054090, 52.238640),
    (21.055361, 52.238892),
    (21.055691, 52.238960),
    (21.058580, 52.239552),
    (21.059811, 52.239799),
    (21.061790, 52.240211),
    (21.062330, 52.240318),
    (21.062550, 52.240372),
    (21.064421, 52.240749),
    (21.069500, 52.241791),
    (21.071520, 52.242210),
    (21.071791, 52.242260),
    (21.075680, 52.243061),
    (21.075800, 52.243092),
    (21.077669, 52.243469),
    (21.077971, 52.243530),
    (21.081539, 52.244259),
    (21.082701, 52.244499),
    (21.083500, 52.244652),
    (21.083839, 52.244690),
    (21.083910, 52.244629),
    (21.083969, 52.244591),
    (21.084221, 52.244461),
    (21.084440, 52.244411),
    (21.084810, 52.244381),
    (21.085100, 52.244419),
    (21.085310, 52.244480),
    (21.085489, 52.244560),
    (21.085699, 52.244678),
    (21.085831, 52.244751),
    (21.086000, 52.244781),
    (21.086281, 52.244781),
    (21.087080, 52.244740),
    (21.088400, 52.244671),
    (21.088659, 52.244709),
    (21.088900, 52.244759),
    (21.089130, 52.244820),
    (21.089399, 52.244862),
    (21.089540, 52.244839),
    (21.090120, 52.244751),
    (21.090960, 52.244610),
    (21.092991, 52.244202),
    (21.094851, 52.243809),
    (21.094940, 52.243801),
    (21.095190, 52.243740),
    (21.095350, 52.243710),
    (21.095461, 52.243690),
    (21.095631, 52.243649),
    (21.097300, 52.243290),
    (21.097771, 52.243191),
    (21.099270, 52.242882),
    (21.099951, 52.242741),
    (21.101561, 52.242401),
    (21.101870, 52.242340),
    (21.102100, 52.242290),
    (21.102381, 52.242222),
    (21.103750, 52.241940),
    (21.105391, 52.241581),
    (21.106760, 52.241291),
    (21.107389, 52.241161),
    (21.107531, 52.241131),
    (21.108259, 52.240971),
    (21.109070, 52.240799),
    (21.110590, 52.240479),
    (21.113319, 52.239899),
    (21.113800, 52.239792),
    (21.114130, 52.239700),
    (21.114300, 52.239658),
    (21.115021, 52.239429),
    (21.115240, 52.239349),
    (21.115629, 52.239208),
    (21.116280, 52.238930),
    (21.118500, 52.237930),
    (21.120090, 52.237251),
    (21.120291, 52.237148),
    (21.120520, 52.237049),
    (21.121441, 52.236649),
    (21.122311, 52.236271),
    (21.123060, 52.235931),
    (21.124081, 52.235500),
    (21.125320, 52.234959),
    (21.125690, 52.234779),
    (21.126040, 52.234570),
    (21.126240, 52.234440),
    (21.126410, 52.234299),
    (21.126511, 52.234200),
    (21.126551, 52.234100),
    (21.126480, 52.234020),
    (21.126431, 52.233910),
    (21.126419, 52.233829),
    (21.126459, 52.233700),
    (21.126539, 52.233601),
    (21.126680, 52.233501),
    (21.126850, 52.233440),
    (21.127010, 52.233410),
    (21.127220, 52.233398),
    (21.127430, 52.233440),
    (21.127661, 52.233540),
    (21.127729, 52.233589),
    (21.127790, 52.233650),
    (21.127850, 52.233761),
    (21.127859, 52.233849),
    (21.127819, 52.234001),
    (21.127769, 52.234070),
    (21.127729, 52.234150),
    (21.127760, 52.234219),
    (21.128941, 52.235310),
    (21.129070, 52.235420),
    (21.130039, 52.236340),
    (21.130600, 52.236900),
    (21.130711, 52.237080),
    (21.130810, 52.237209),
    (21.130871, 52.237309),
    (21.130899, 52.237389),
    (21.130951, 52.237709),
    (21.131290, 52.238060),
    (21.131580, 52.238312),
    (21.131861, 52.238571),
    (21.132740, 52.239399),
    (21.133150, 52.239750),
    (21.134050, 52.240440),
    (21.134529, 52.240810),
    (21.135059, 52.241219),
    (21.135590, 52.241711),
    (21.135830, 52.241730),
    (21.137260, 52.242840),
    (21.137470, 52.243000),
    (21.138510, 52.243809),
    (21.138700, 52.243950),
    (21.138840, 52.244061),
    (21.139179, 52.244320),
    (21.139400, 52.244480),
    (21.140181, 52.245140),
    (21.141460, 52.246422),
    (21.141590, 52.246540),
    (21.142651, 52.247391),
    (21.143499, 52.248131),
    (21.144341, 52.249088),
    (21.144520, 52.249279),
    (21.144859, 52.249531),
    (21.145710, 52.250050),
    (21.151991, 52.252911),
    (21.152651, 52.253220),
    (21.154461, 52.254501),
    (21.154980, 52.254848),
    (21.155220, 52.255001),
    (21.155270, 52.255039),
    (21.156580, 52.255959),
    (21.156540, 52.256119),
    (21.156410, 52.256359),
    (21.156401, 52.256611),
    (21.156521, 52.257229),
    (21.156561, 52.257389),
    (21.156590, 52.257439),
    (21.156679, 52.257469),
    (21.156910, 52.257481),
    (21.158649, 52.257431),
    (21.158951, 52.257420),
    (21.159460, 52.257389),
    (21.160879, 52.257320),
    (21.165060, 52.257160),
    (21.168831, 52.256981),
    (21.169411, 52.257000),
    (21.170540, 52.257030),
    (21.171551, 52.256981),
    (21.172991, 52.256920),
    (21.174320, 52.256851),
    (21.175619, 52.256790),
    (21.176781, 52.256729),
    (21.178049, 52.256672),
    (21.178301, 52.256660),
    (21.178471, 52.256649),
    (21.179440, 52.256592),
    (21.180731, 52.256550),
    (21.208300, 52.255299),
    (21.208910, 52.255268),
    (21.220619, 52.254688),
    (21.222561, 52.254589),
    (21.224140, 52.254520),
    (21.227230, 52.254391),
    (21.229210, 52.254311),
    (21.252150, 52.253189),
    (21.252090, 52.254688),
    (21.252371, 52.255081),
    (21.252649, 52.255192),
    (21.253269, 52.255440),
    (21.253820, 52.256069),
    (21.253839, 52.256432),
    (21.253519, 52.257130),
    (21.253510, 52.257450),
    (21.254860, 52.258018),
    (21.257771, 52.259048),
    (21.259520, 52.259350),
    (21.262800, 52.260132),
    (21.263500, 52.260231),
    (21.264410, 52.260502),
    (21.265249, 52.260578),
    (21.267340, 52.261181),
    (21.269720, 52.261951),
    (21.270981, 52.262272),
    (21.271311, 52.262310),
    (21.271570, 52.262341),
    (21.272141, 52.262489),
    (21.276079, 52.263840),
    (21.278299, 52.264370),
    (21.279119, 52.264568),
    (21.286650, 52.265968),
    (21.288630, 52.266380),
    (21.294300, 52.267342),
    (21.295530, 52.267578),
    (21.295971, 52.267540),
    (21.296370, 52.267750),
    (21.296820, 52.267910),
    (21.299459, 52.268410),
    (21.300091, 52.268589),
    (21.301479, 52.269199),
    (21.302441, 52.269920),
    (21.302620, 52.270000),
    (21.302870, 52.270111),
    (21.302999, 52.270168),
    (21.304131, 52.270580),
    (21.306370, 52.271370),
    (21.307011, 52.271858),
    (21.307581, 52.272251),
    (21.308371, 52.272812),
    (21.309580, 52.273640),
    (21.309731, 52.273720),
    (21.309919, 52.273750),
    (21.310530, 52.273720),
    (21.311609, 52.273628),
    (21.312401, 52.273590),
    (21.312599, 52.273590),
    (21.313869, 52.273701),
    (21.316839, 52.274281),
    (21.318609, 52.274639),
    (21.319241, 52.274712),
    (21.330360, 52.275379),
    (21.331360, 52.275372),
    (21.332310, 52.275291),
    (21.342470, 52.274471),
    (21.346479, 52.274170),
    (21.348869, 52.273731),
    (21.358480, 52.271099),
    (21.360519, 52.270748),
    (21.365950, 52.270241),
    (21.371161, 52.269810),
    (21.377380, 52.269169),
    (21.379520, 52.268829),
    (21.385941, 52.267799),
    (21.409889, 52.264690),
    (21.417910, 52.264622),
    (21.421129, 52.263962),
    (21.424780, 52.263458),
    (21.431490, 52.262821),
    (21.432850, 52.262859),
    (21.434200, 52.263119),
    (21.436190, 52.263790),
    (21.441469, 52.265820),
    (21.449129, 52.267410),
    (21.460421, 52.270741),
    (21.462460, 52.271339),
    (21.462589, 52.271381),
    (21.464279, 52.271870),
    (21.465580, 52.272141),
    (21.467930, 52.272419),
    (21.473370, 52.273079),
    (21.474079, 52.273239),
    (21.476101, 52.274078),
    (21.476910, 52.274261),
    (21.478580, 52.274490),
    (21.486990, 52.275291),
    (21.495800, 52.276199),
    (21.497709, 52.276409),
    (21.511250, 52.278950),
    (21.514771, 52.279652),
    (21.523621, 52.281479),
    (21.524710, 52.281830),
    (21.532551, 52.285461),
    (21.535490, 52.286751),
    (21.537130, 52.288689),
    (21.537519, 52.288940),
    (21.537979, 52.289101),
    (21.538380, 52.289150),
    (21.538790, 52.289169),
    (21.539989, 52.289211),
    (21.541809, 52.289268),
    (21.541929, 52.289268),
    (21.544279, 52.289310),
    (21.546591, 52.289360),
    (21.548090, 52.289360),
    (21.548830, 52.289360),
    (21.553391, 52.289600),
    (21.553949, 52.289631),
    (21.554390, 52.290321),
    (21.554461, 52.290421),
    (21.554840, 52.291618),
    (21.555080, 52.292839),
    (21.555550, 52.296009),
    (21.556990, 52.297119),
    (21.561310, 52.299980),
    (21.568979, 52.305168),
    (21.574070, 52.308479),
    (21.576059, 52.309200),
    (21.578119, 52.309792),
    (21.580690, 52.310219),
    (21.583160, 52.310631),
    (21.584400, 52.310799),
    (21.585859, 52.311031),
    (21.586910, 52.310902),
    (21.588421, 52.310452),
    (21.589760, 52.310150),
    (21.590960, 52.310040),
    (21.591801, 52.310162),
    (21.593981, 52.310760),
    (21.618759, 52.317848),
    (21.623739, 52.319279),
    (21.624611, 52.319530),
    (21.626089, 52.319729),
    (21.627260, 52.319679),
    (21.629009, 52.319370),
    (21.631081, 52.319279),
    (21.635151, 52.319199),
    (21.635220, 52.319191),
    (21.644079, 52.318890),
    (21.651810, 52.318569),
    (21.655870, 52.318390),
    (21.657030, 52.318359),
    (21.658279, 52.318420),
    (21.659140, 52.318630),
    (21.660610, 52.319111),
    (21.663679, 52.320122),
    (21.663679, 52.320122),
    (21.664940, 52.320580),
    (21.666229, 52.321301),
    (21.667210, 52.322010),
    (21.667700, 52.322361),
    (21.668659, 52.323040),
    (21.669531, 52.323551),
    (21.670570, 52.323971),
    (21.671350, 52.324211),
    (21.672510, 52.324429),
    (21.673679, 52.324532),
    (21.675220, 52.324501),
    (21.679590, 52.324162),
    (21.682070, 52.324200),
    (21.686239, 52.324348),
    (21.688061, 52.324478),
    (21.689051, 52.324650),
    (21.690281, 52.325020),
    (21.691530, 52.325588),
    (21.706160, 52.333389),
    (21.710211, 52.335529),
    (21.711380, 52.336159),
    (21.712780, 52.336731),
    (21.714380, 52.337170),
    (21.717489, 52.338428),
    (21.718840, 52.339039),
    (21.720430, 52.339828),
    (21.722851, 52.341389),
    (21.728460, 52.345242),
    (21.729950, 52.346291),
    (21.730619, 52.346859),
    (21.731079, 52.347191),
    (21.734051, 52.348969),
    (21.734230, 52.349091),
    (21.735420, 52.349838),
    (21.738180, 52.351398),
    (21.739260, 52.351910),
    (21.743040, 52.353119),
    (21.744619, 52.353531),
    (21.746840, 52.354050),
    (21.748810, 52.354969),
    (21.749781, 52.355381),
    (21.752371, 52.356140),
    (21.753441, 52.356461),
    (21.754669, 52.356998),
    (21.755880, 52.357750),
    (21.760290, 52.359798),
    (21.761850, 52.360470),
    (21.763691, 52.361130),
    (21.768230, 52.362431),
    (21.771500, 52.363331),
    (21.773350, 52.363739),
    (21.776381, 52.365059),
    (21.779610, 52.366371),
    (21.789061, 52.370701),
    (21.790079, 52.371208),
    (21.791201, 52.371620),
    (21.792629, 52.371830),
    (21.794001, 52.371861),
    (21.796570, 52.371811),
    (21.798870, 52.371861),
    (21.802040, 52.372070),
    (21.804840, 52.372311),
    (21.806259, 52.372330),
    (21.807449, 52.372631),
    (21.808580, 52.372940),
    (21.812031, 52.373520),
    (21.813471, 52.373600),
    (21.822800, 52.373531),
    (21.825130, 52.373459),
    (21.828079, 52.373459),
    (21.841631, 52.374420),
    (21.843430, 52.374519),
    (21.844460, 52.374531),
    (21.845360, 52.374432),
    (21.846500, 52.374161),
    (21.847811, 52.373772),
    (21.848740, 52.373569),
    (21.849770, 52.373402),
    (21.850710, 52.373390),
    (21.880100, 52.376629),
    (21.889009, 52.377659),
    (21.890329, 52.377831),
    (21.892250, 52.377869),
    (21.902870, 52.377209),
    (21.904329, 52.377121),
    (21.907120, 52.376740),
    (21.910721, 52.376141),
    (21.912140, 52.375919),
    (21.913549, 52.375568),
    (21.916920, 52.375431),
    (21.920151, 52.374729),
    (21.927441, 52.374241),
    (21.931620, 52.373970),
    (21.958200, 52.371609),
    (21.958910, 52.371590),
    (21.959970, 52.371681),
    (21.961691, 52.371868),
    (21.962250, 52.371819),
    (21.962709, 52.371780),
    (21.963120, 52.371799),
    (21.963461, 52.371880),
    (21.964701, 52.372318),
    (21.965450, 52.372581),
    (21.966000, 52.372940),
    (21.966610, 52.373611),
    (21.966860, 52.373951),
    (21.967199, 52.374359),
    (21.967529, 52.374859),
    (21.967791, 52.375622),
    (21.968189, 52.376652),
    (21.969030, 52.377991),
    (21.970510, 52.379929),
    (21.970579, 52.380089),
    (21.970690, 52.380119),
    (21.970739, 52.380161),
    (21.970751, 52.380180),
    (21.970819, 52.380219),
    (21.970940, 52.380268),
    (21.971210, 52.380371),
    (21.974350, 52.380951),
    (21.982210, 52.382401),
    (21.985380, 52.382938),
    (21.986111, 52.382919),
    (21.986540, 52.382851),
    (21.987440, 52.382622),
    (21.991730, 52.381180),
    (21.991899, 52.381130),
    (21.992439, 52.380970),
    (21.992910, 52.380859),
    (21.993509, 52.380821),
    (21.993980, 52.380878),
    (22.006540, 52.386799),
    (22.010229, 52.388500),
    (22.011240, 52.389080),
    (22.011520, 52.389408),
    (22.011700, 52.389690),
    (22.011869, 52.389999),
    (22.011921, 52.390091),
    (22.012440, 52.391010),
    (22.012850, 52.391628),
    (22.012991, 52.391769),
    (22.013041, 52.391739),
    (22.013140, 52.391731),
    (22.013241, 52.391762),
    (22.013300, 52.391819),
    (22.013430, 52.391819),
    (22.013580, 52.391811),
    (22.013781, 52.391811),
    (22.014280, 52.391830),
    (22.015060, 52.391899),
    (22.015680, 52.392139),
    (22.016260, 52.392479),
    (22.016359, 52.392559),
    (22.017260, 52.393471),
    (22.017691, 52.393719),
    (22.018280, 52.393890),
    (22.019011, 52.393921),
    (22.019711, 52.393909),
    (22.020140, 52.393879),
    (22.020849, 52.393822),
    (22.024771, 52.394051),
    (22.025539, 52.394112),
    (22.025700, 52.394131),
    (22.025721, 52.394081),
    (22.025780, 52.394039),
    (22.025850, 52.394009),
    (22.025930, 52.394001),
    (22.026039, 52.394020),
    (22.026091, 52.394051),
    (22.026150, 52.394131),
    (22.026150, 52.394180),
    (22.026110, 52.394230),
    (22.026310, 52.394360),
    (22.026461, 52.394482),
    (22.026680, 52.394699),
    (22.026779, 52.394878),
    (22.027121, 52.395760),
    (22.027201, 52.396240),
    (22.027451, 52.396919),
    (22.027620, 52.397678),
    (22.027580, 52.397949),
    (22.027309, 52.398819),
    (22.027229, 52.399040),
    (22.027399, 52.399090),
    (22.027460, 52.399170),
    (22.027470, 52.399239),
    (22.027639, 52.399239),
    (22.028191, 52.399101),
    (22.029560, 52.399181),
    (22.046600, 52.402012),
    (22.049709, 52.402531),
    (22.059540, 52.404480),
    (22.060699, 52.404739),
    (22.064110, 52.405060),
    (22.065630, 52.405170),
    (22.067539, 52.405411),
    (22.068550, 52.405621),
    (22.069670, 52.405708),
    (22.070980, 52.405602),
    (22.072430, 52.405090),
    (22.073549, 52.404610),
    (22.074150, 52.404442),
    (22.078440, 52.404140),
    (22.080799, 52.404060),
    (22.083719, 52.404011),
    (22.085220, 52.404099),
    (22.088909, 52.403881),
    (22.113550, 52.401649),
    (22.115520, 52.401482),
    (22.116720, 52.401272),
    (22.120890, 52.399891),
    (22.122900, 52.399120),
    (22.124210, 52.398628),
    (22.128759, 52.398460),
    (22.131269, 52.398430),
    (22.149981, 52.405041),
    (22.154831, 52.406670),
    (22.164829, 52.410110),
    (22.165730, 52.410412),
    (22.166590, 52.410622),
    (22.172340, 52.409801),
    (22.173500, 52.409630),
    (22.178221, 52.408390),
    (22.180500, 52.407742),
    (22.181049, 52.407612),
    (22.198730, 52.407471),
    (22.203430, 52.407421),
    (22.203831, 52.407421),
    (22.209270, 52.407360),
    (22.211060, 52.407341),
    (22.213150, 52.407330),
    (22.215740, 52.407299),
    (22.217461, 52.407299),
    (22.220461, 52.407280),
    (22.225430, 52.407219),
    (22.226400, 52.407219),
    (22.226730, 52.407211),
    (22.227850, 52.407200),
    (22.230591, 52.407181),
    (22.232929, 52.407150),
    (22.233589, 52.407150),
    (22.235901, 52.407131),
    (22.236191, 52.407150),
    (22.236200, 52.407089),
    (22.236259, 52.407051),
    (22.236361, 52.407040),
    (22.236441, 52.407051),
    (22.236490, 52.407089),
    (22.236509, 52.407139),
    (22.240351, 52.407051),
    (22.240829, 52.407089),
    (22.242670, 52.407070),
    (22.244970, 52.407040),
    (22.247061, 52.407021),
    (22.247999, 52.407150),
    (22.248150, 52.407211),
    (22.249720, 52.407860),
    (22.250710, 52.408001),
    (22.251221, 52.408051),
    (22.252081, 52.406910),
    (22.252760, 52.406361),
    (22.252960, 52.406200),
    (22.253691, 52.405811),
    (22.254320, 52.405460),
    (22.254551, 52.405338),
    (22.254999, 52.404999),
    (22.255730, 52.404549),
    (22.256729, 52.403980),
    (22.256510, 52.403709),
    (22.258240, 52.402451),
    (22.258720, 52.402149),
    (22.260509, 52.401089),
    (22.261629, 52.399979),
    (22.265341, 52.396278),
    (22.266029, 52.395901),
    (22.266581, 52.395859),
    (22.292850, 52.393970),
    (22.303789, 52.394508),
    (22.306070, 52.394310),
    (22.309710, 52.393631),
    (22.311970, 52.392921),
    (22.316799, 52.391220),
    (22.320440, 52.389851),
    (22.321951, 52.389721),
    (22.326839, 52.389679),
    (22.331341, 52.389400),
    (22.332569, 52.389530),
    (22.339649, 52.391029),
    (22.341169, 52.391048),
    (22.342550, 52.390839),
    (22.352461, 52.389462),
    (22.361980, 52.388222),
    (22.368771, 52.387379),
    (22.381081, 52.388710),
    (22.382240, 52.388618),
    (22.383230, 52.388359),
    (22.384470, 52.388031),
    (22.387770, 52.385658),
    (22.389021, 52.385071),
    (22.390530, 52.385040),
    (22.402330, 52.384850),
    (22.408279, 52.384739),
    (22.411360, 52.384682),
    (22.436550, 52.386219),
    (22.445650, 52.389511),
    (22.450350, 52.391159),
    (22.471720, 52.396889),
    (22.490240, 52.401840),
    (22.495741, 52.401661),
    (22.500000, 52.401520),
    (22.514490, 52.401009),
    (22.514830, 52.400928),
    (22.515810, 52.400730),
    (22.516581, 52.400650),
    (22.519381, 52.401100),
    (22.519899, 52.401501),
    (22.521009, 52.403961),
    (22.521629, 52.404400),
    (22.547840, 52.411331),
    (22.551279, 52.411652),
    (22.552099, 52.411732),
    (22.554331, 52.412399),
    (22.559601, 52.414398),
    (22.561319, 52.415058),
    (22.572910, 52.419521),
    (22.574480, 52.419590),
    (22.595699, 52.413731),
    (22.603260, 52.412251),
    (22.613960, 52.410149),
    (22.646240, 52.403030),
    (22.651409, 52.401840),
    (22.657560, 52.400532),
    (22.658470, 52.400318),
    (22.658590, 52.400291),
    (22.659950, 52.400002),
    (22.660749, 52.399948),
    (22.661921, 52.400242),
    (22.663589, 52.400921),
    (22.664221, 52.401031),
    (22.665119, 52.400921),
    (22.672649, 52.399719),
    (22.688009, 52.397270),
    (22.690420, 52.396889),
    (22.694981, 52.396000),
    (22.697500, 52.395512),
    (22.711451, 52.392422),
    (22.714790, 52.391701),
    (22.715820, 52.391571),
    (22.717190, 52.391651),
    (22.720501, 52.392120),
    (22.724751, 52.392422),
    (22.739599, 52.393879),
    (22.755819, 52.395512),
    (22.770451, 52.397018),
    (22.773390, 52.397308),
    (22.786461, 52.398651),
    (22.792299, 52.399250),
    (22.793711, 52.399330),
    (22.798000, 52.399330),
    (22.800320, 52.399288),
    (22.805691, 52.398392),
    (22.807400, 52.398090),
    (22.820061, 52.395031),
    (22.824190, 52.393990),
    (22.831249, 52.392651),
    (22.837379, 52.391609),
    (22.840170, 52.391090),
    (22.840879, 52.391010),
    (22.846380, 52.391041),
    (22.849030, 52.391048),
    (22.866739, 52.393200),
    (22.869190, 52.393509),
    (22.870041, 52.393650),
    (22.870081, 52.393589),
    (22.870180, 52.393539),
    (22.870270, 52.393520),
    (22.870380, 52.393520),
    (22.870489, 52.393559),
    (22.870569, 52.393631),
    (22.870581, 52.393700),
    (22.879110, 52.394730),
    (22.880230, 52.394871),
    (22.894329, 52.395580),
    (22.900061, 52.395828),
    (22.906900, 52.394379),
    (22.914431, 52.391609),
    (22.916149, 52.391159),
    (22.932631, 52.387810),
    (22.936081, 52.387192),
    (22.951330, 52.384472),
    (22.952221, 52.384312),
    (22.955351, 52.384209),
    (22.982630, 52.383560),
    (22.984390, 52.383389),
    (22.986660, 52.382568),
    (22.989260, 52.381142),
    (22.992929, 52.380058),
    (22.996450, 52.379311),
    (23.025761, 52.373539),
    (23.028931, 52.372978),
    (23.032320, 52.372509),
    (23.035601, 52.371811),
    (23.036810, 52.371559),
    (23.040131, 52.370819),
    (23.041960, 52.370708),
    (23.042919, 52.370602),
    (23.046120, 52.369961),
    (23.067961, 52.365520),
    (23.084681, 52.365089),
    (23.116390, 52.364552),
    (23.117599, 52.364471),
    (23.121201, 52.363392),
    (23.122419, 52.362900),
    (23.123699, 52.362091),
    (23.127041, 52.360020),
    (23.128990, 52.359341),
    (23.129910, 52.359161),
    (23.133320, 52.359058),
    (23.138651, 52.358711),
    (23.143370, 52.358559),
    (23.149380, 52.358421),
    (23.153681, 52.358391),
    (23.172119, 52.358070),
    (23.202539, 52.356010),
    (23.205111, 52.355869),
    (23.211750, 52.355751),
    (23.226709, 52.356140),
    (23.242081, 52.357330),
    (23.253811, 52.357792),
    (23.261181, 52.357792),
    (23.262850, 52.357792),
    (23.265181, 52.357830),
    (23.266239, 52.357849),
    (23.267241, 52.357780),
    (23.269779, 52.357460),
    (23.270861, 52.357319),
    (23.271391, 52.357262),
    (23.271830, 52.357231),
    (23.272680, 52.357349),
    (23.273451, 52.357491),
    (23.275560, 52.357880),
    (23.277719, 52.358349),
    (23.282061, 52.359291),
    (23.290710, 52.361160),
    (23.304449, 52.364491),
    (23.306040, 52.364799),
    (23.307760, 52.364769),
    (23.309681, 52.364319),
    (23.311710, 52.363831),
    (23.318100, 52.361809),
    (23.323410, 52.360149),
    (23.325171, 52.360001),
    (23.327271, 52.360149),
    (23.336010, 52.360710),
    (23.338619, 52.360859),
    (23.346500, 52.363960),
    (23.352020, 52.366131),
    (23.354349, 52.367039),
    (23.355789, 52.367580),
    (23.355949, 52.367649),
    (23.357189, 52.368229),
    (23.358130, 52.368401),
    (23.359381, 52.368481),
    (23.360479, 52.368698),
    (23.360821, 52.368771),
    (23.362070, 52.369099),
    (23.362160, 52.369122),
    (23.363449, 52.369461),
    (23.363880, 52.369591),
    (23.365379, 52.370029),
    (23.366249, 52.370750),
    (23.366650, 52.371090),
    (23.367090, 52.371460),
    (23.368139, 52.372341),
    (23.370300, 52.371300),
    (23.371330, 52.370811),
    (23.372181, 52.370399),
    (23.373840, 52.369591),
    (23.374649, 52.369160),
    (23.375040, 52.368961),
    (23.375130, 52.368912),
    (23.375231, 52.368790),
    (23.375340, 52.368530),
    (23.375561, 52.368191),
    (23.375719, 52.368031),
    (23.376011, 52.368050),
    (23.376341, 52.368111),
    (23.376961, 52.368259),
    (23.377251, 52.368309),
    (23.377560, 52.368328),
    (23.378151, 52.368340),
    (23.378750, 52.368320),
    (23.379419, 52.368259),
    (23.380871, 52.367981),
    (23.387060, 52.366760),
    (23.387400, 52.366699),
    (23.387640, 52.366638),
    (23.389891, 52.366070),
    (23.390120, 52.366020),
    (23.393551, 52.365150),
    (23.394810, 52.364830),
    (23.395809, 52.364540),
    (23.396851, 52.364250),
    (23.397940, 52.363930),
    (23.401119, 52.362919),
    (23.401331, 52.362862),
    (23.402920, 52.362381),
    (23.404020, 52.362049),
    (23.411501, 52.359821),
    (23.415010, 52.358669),
    (23.415939, 52.358410),
    (23.418400, 52.357670),
    (23.431160, 52.353649),
    (23.435530, 52.352570),
    (23.440331, 52.351349),
    (23.446329, 52.349789),
    (23.456421, 52.347252),
    (23.473850, 52.342812),
    (23.499460, 52.337379),
    (23.515949, 52.333660),
    (23.538010, 52.328690),
    (23.550560, 52.325871),
    (23.562099, 52.323261),
    (23.578819, 52.319530),
    (23.607420, 52.310791),
    (23.630039, 52.303959),
    (23.631901, 52.303410),
    (23.632750, 52.303211),
    (23.633690, 52.303120),
    (23.634920, 52.303230),
    (23.635811, 52.303490),
    (23.639290, 52.304409),
    (23.640150, 52.304619),
    (23.640930, 52.304710),
    (23.683750, 52.304981),
    (23.702250, 52.305141),
    (23.707750, 52.305611),
    (23.723570, 52.306980),
    (23.736130, 52.310532),
    (23.741360, 52.312012),
    (23.747580, 52.314209),
    (23.758909, 52.318230),
    (23.765020, 52.320351),
    (23.771931, 52.322739),
    (23.775940, 52.324310),
    (23.776699, 52.324612),
    (23.779400, 52.325539),
    (23.781460, 52.326210),
    (23.782249, 52.326370),
    (23.782890, 52.326420),
    (23.782970, 52.326420),
    (23.783030, 52.326431),
    (23.783140, 52.326439),
    (23.783220, 52.326450),
    (23.786091, 52.326691),
    (23.790001, 52.327061),
    (23.794260, 52.327431),
    (23.802071, 52.328201),
    (23.828220, 52.330688),
    (23.832529, 52.331120),
    (23.851870, 52.332901),
    (23.872919, 52.334900),
    (23.878469, 52.336109),
    (23.896601, 52.340229),
    (23.901180, 52.341141),
    (23.905741, 52.342018),
    (23.907280, 52.342312),
    (23.910770, 52.342979),
    (23.915230, 52.343781),
    (23.916260, 52.343990),
    (23.935129, 52.347641),
    (23.947220, 52.349861),
    (23.960070, 52.352329),
    (23.961050, 52.352520),
    (23.962111, 52.352631),
    (23.963110, 52.352730),
    (23.985500, 52.352249),
    (23.986540, 52.352230),
    (23.987410, 52.352261),
    (23.988310, 52.352348),
    (23.989580, 52.352589),
    (24.007839, 52.356209),
    (24.046850, 52.364220),
    (24.049509, 52.364769),
    (24.056959, 52.366291),
    (24.096809, 52.374321),
    (24.119551, 52.378929),
    (24.122410, 52.379520),
    (24.138790, 52.382820),
    (24.152611, 52.385609),
    (24.165819, 52.388279),
    (24.166380, 52.388451),
    (24.166910, 52.388618),
    (24.167391, 52.388840),
    (24.167860, 52.389080),
    (24.172600, 52.392250),
    (24.178471, 52.396160),
    (24.181021, 52.397850),
    (24.183241, 52.399342),
    (24.183689, 52.399700),
    (24.184160, 52.400131),
    (24.184540, 52.400551),
    (24.184780, 52.400879),
    (24.185049, 52.401329),
    (24.185301, 52.401909),
    (24.185711, 52.403149),
    (24.186199, 52.404709),
    (24.186350, 52.405090),
    (24.186569, 52.405441),
    (24.186819, 52.405788),
    (24.187090, 52.406078),
    (24.187361, 52.406349),
    (24.187880, 52.406761),
    (24.188290, 52.407051),
    (24.188810, 52.407360),
    (24.189501, 52.407700),
    (24.190220, 52.407990),
    (24.191080, 52.408279),
    (24.192101, 52.408550),
    (24.201571, 52.410931),
    (24.218170, 52.415119),
    (24.219271, 52.415421),
    (24.219980, 52.415661),
    (24.220501, 52.415871),
    (24.220930, 52.416050),
    (24.224140, 52.417580),
    (24.231239, 52.421051),
    (24.241261, 52.425900),
    (24.246500, 52.428440),
    (24.254440, 52.432301),
    (24.259550, 52.434780),
    (24.260780, 52.435371),
    (24.270000, 52.439800),
    (24.291140, 52.450119),
    (24.293200, 52.451130),
    (24.294970, 52.451988),
    (24.296221, 52.452599),
    (24.297220, 52.453121),
    (24.297939, 52.453579),
    (24.299391, 52.454590),
    (24.301060, 52.455730),
    (24.312889, 52.463921),
    (24.333639, 52.478088),
    (24.355289, 52.492939),
    (24.358540, 52.495159),
    (24.370390, 52.503250),
    (24.372410, 52.504681),
    (24.373369, 52.505310),
    (24.374109, 52.505821),
    (24.374981, 52.506329),
    (24.375900, 52.506790),
    (24.380140, 52.508759),
    (24.403669, 52.519920),
    (24.423820, 52.529400),
    (24.434549, 52.534500),
    (24.440020, 52.537109),
    (24.444500, 52.539249),
    (24.446150, 52.540031),
    (24.446840, 52.540340),
    (24.447189, 52.540501),
    (24.447531, 52.540649),
    (24.448259, 52.541000),
    (24.449261, 52.541431),
    (24.449400, 52.541500),
    (24.450020, 52.541759),
    (24.450880, 52.542179),
    (24.458019, 52.545559),
    (24.459160, 52.546120),
    (24.460899, 52.546951),
    (24.462700, 52.547791),
    (24.463869, 52.548351),
    (24.463989, 52.548409),
    (24.464199, 52.548500),
    (24.464430, 52.548611),
    (24.468321, 52.550430),
    (24.470020, 52.551262),
    (24.472309, 52.552319),
    (24.472639, 52.552479),
    (24.473009, 52.552639),
    (24.473740, 52.553059),
    (24.474001, 52.553219),
    (24.474211, 52.553341),
    (24.474560, 52.553520),
    (24.474770, 52.553631),
    (24.474960, 52.553669),
    (24.475250, 52.553661),
    (24.475309, 52.553661),
    (24.475380, 52.553661),
    (24.475861, 52.553509),
    (24.476139, 52.553452),
    (24.478809, 52.552849),
    (24.481300, 52.552261),
    (24.488960, 52.550320),
    (24.496340, 52.548481),
    (24.502090, 52.547031),
    (24.502741, 52.546848),
    (24.503269, 52.546570),
    (24.509460, 52.542561),
    (24.509899, 52.542389),
    (24.514351, 52.541851),
    (24.520571, 52.541168),
    (24.521650, 52.540852),
    (24.528530, 52.538071),
    (24.535030, 52.535450),
    (24.548109, 52.533852),
    (24.549700, 52.533661),
    (24.551741, 52.533390),
    (24.553921, 52.533119),
    (24.569540, 52.531219),
    (24.579081, 52.530060),
    (24.581881, 52.529510),
    (24.593559, 52.527321),
    (24.613720, 52.523540),
    (24.616880, 52.523029),
    (24.620190, 52.522629),
    (24.625980, 52.521770),
    (24.628811, 52.521400),
    (24.633940, 52.520721),
    (24.642771, 52.519508),
    (24.648130, 52.518749),
    (24.653151, 52.518059),
    (24.658340, 52.517319),
    (24.659731, 52.517189),
    (24.661329, 52.517200),
    (24.665880, 52.511589),
    (24.669519, 52.506451),
    (24.670309, 52.505440),
    (24.675800, 52.502560),
    (24.682810, 52.498409),
    (24.694901, 52.491291),
    (24.698389, 52.489399),
    (24.699961, 52.490620),
    (24.702690, 52.492199),
    (24.708040, 52.492809),
    (24.710590, 52.492550),
    (24.711470, 52.492329),
    (24.712250, 52.491951),
    (24.713591, 52.490871),
    (24.714270, 52.490520),
    (24.715111, 52.490559),
    (24.721880, 52.491531),
    (24.723989, 52.491501),
    (24.732140, 52.493221),
    (24.740191, 52.494919),
    (24.747370, 52.497070),
    (24.755520, 52.499512),
    (24.762341, 52.502892),
    (24.780310, 52.503029),
    (24.786449, 52.503078),
    (24.788561, 52.502190),
    (24.809050, 52.499008),
    (24.810440, 52.499630),
    (24.812590, 52.500389),
    (24.814489, 52.500599),
    (24.818460, 52.500729),
    (24.823030, 52.500771),
    (24.833281, 52.502239),
    (24.839069, 52.502850),
    (24.846621, 52.504009),
    (24.847549, 52.504269),
    (24.849100, 52.505081),
    (24.851669, 52.506489),
    (24.854589, 52.507271),
    (24.857510, 52.507950),
    (24.860430, 52.508381),
    (24.863951, 52.508640),
    (24.879440, 52.510391),
    (24.891340, 52.511711),
    (24.895720, 52.512119),
    (24.897850, 52.512348),
    (24.908319, 52.515850),
    (24.910521, 52.516541),
    (24.912729, 52.517239),
    (24.927090, 52.521999),
    (24.931499, 52.522301),
    (24.937590, 52.522610),
    (24.937941, 52.522629),
    (24.942240, 52.523640),
    (24.952829, 52.526131),
    (24.953590, 52.526291),
    (24.953770, 52.526199),
    (24.953970, 52.526192),
    (24.954201, 52.526211),
    (24.954300, 52.526230),
    (24.954411, 52.526409),
    (24.954439, 52.526470),
    (24.954910, 52.526661),
    (24.958260, 52.527500),
    (24.958469, 52.527592),
    (24.961321, 52.528271),
    (24.963610, 52.528870),
    (24.968941, 52.530201),
    (24.976240, 52.532040),
    (24.977341, 52.532379),
    (24.977510, 52.532440),
    (24.977720, 52.532520),
    (24.980650, 52.534592),
    (24.983040, 52.533489),
    (24.984240, 52.534069),
    (24.984280, 52.534088),
    (24.985680, 52.534821),
    (24.987551, 52.535782),
    (24.989691, 52.536900),
    (24.991579, 52.537891),
    (24.992439, 52.538288),
    (24.994350, 52.539200),
    (24.996559, 52.540291),
    (25.009001, 52.546490),
    (25.015949, 52.549919),
    (25.022520, 52.553200),
    (25.028641, 52.556240),
    (25.039310, 52.561581),
    (25.082600, 52.583099),
    (25.089399, 52.586479),
    (25.092480, 52.587978),
    (25.098669, 52.591030),
    (25.105860, 52.594669),
    (25.143629, 52.613449),
    (25.166519, 52.624908),
    (25.186199, 52.634369),
    (25.195511, 52.638672),
    (25.208820, 52.645618),
    (25.214830, 52.648621),
    (25.218840, 52.650631),
    (25.219761, 52.651070),
    (25.220961, 52.651649),
    (25.227699, 52.655151),
    (25.236811, 52.659550),
    (25.248730, 52.665451),
    (25.261490, 52.671700),
    (25.305740, 52.693470),
    (25.308670, 52.694920),
    (25.312599, 52.696800),
    (25.312960, 52.696972),
    (25.317030, 52.698898),
    (25.321791, 52.701408),
    (25.324810, 52.702888),
    (25.325939, 52.703442),
    (25.329550, 52.705219),
    (25.331450, 52.706150),
    (25.333040, 52.706921),
    (25.333321, 52.707062),
    (25.335239, 52.708000),
    (25.335390, 52.708038),
    (25.336519, 52.708599),
    (25.337450, 52.709049),
    (25.338840, 52.709770),
    (25.339001, 52.709850),
    (25.340651, 52.710678),
    (25.343031, 52.711849),
    (25.344570, 52.712582),
    (25.345390, 52.712959),
    (25.348261, 52.714401),
    (25.351110, 52.715820),
    (25.353230, 52.716869),
    (25.353319, 52.716919),
    (25.362921, 52.721691),
    (25.368521, 52.724361),
    (25.383369, 52.731709),
    (25.416059, 52.747719),
    (25.416531, 52.747940),
    (25.422319, 52.750851),
    (25.444260, 52.761650),
    (25.447741, 52.763309),
    (25.457479, 52.768108),
    (25.480209, 52.779350),
    (25.497141, 52.787552),
    (25.524851, 52.801071),
    (25.530849, 52.803902),
    (25.579710, 52.827850),
    (25.582350, 52.829300),
    (25.604130, 52.839729),
    (25.631390, 52.852959),
    (25.635679, 52.855019),
    (25.638460, 52.855549),
    (25.639090, 52.855640),
    (25.644520, 52.855450),
    (25.646669, 52.855289),
    (25.648319, 52.855350),
    (25.650080, 52.855690),
    (25.651960, 52.856602),
    (25.653681, 52.857800),
    (25.655680, 52.858841),
    (25.666500, 52.860920),
    (25.672050, 52.862011),
    (25.687149, 52.864841),
    (25.709299, 52.869221),
    (25.723789, 52.872040),
    (25.724230, 52.872131),
    (25.732470, 52.873589),
    (25.748199, 52.876610),
    (25.767550, 52.880322),
    (25.783020, 52.883289),
    (25.783541, 52.883381),
    (25.851761, 52.896431),
    (25.856750, 52.897282),
    (25.930479, 52.911362),
    (25.960039, 52.916840),
    (25.991899, 52.923031),
    (26.004629, 52.925510),
    (26.023239, 52.928768),
    (26.032280, 52.930408),
    (26.072531, 52.937889),
    (26.078020, 52.938911),
    (26.086691, 52.940540),
    (26.125660, 52.948780),
    (26.151751, 52.949902),
    (26.180330, 52.951092),
    (26.217840, 52.952808),
    (26.225479, 52.953072),
    (26.242020, 52.953640),
    (26.271139, 52.954868),
    (26.291340, 52.955780),
    (26.299210, 52.956081),
    (26.314320, 52.956760),
    (26.348240, 52.958221),
    (26.349079, 52.958241),
    (26.372940, 52.959171),
    (26.407610, 52.960541),
    (26.418341, 52.960991),
    (26.446751, 52.962170),
    (26.459021, 52.962662),
    (26.465981, 52.962940),
    (26.466881, 52.962978),
    (26.472099, 52.963219),
    (26.472839, 52.963261),
    (26.473551, 52.963291),
    (26.474150, 52.963322),
    (26.474880, 52.963348),
    (26.478081, 52.963451),
    (26.511980, 52.964661),
    (26.524260, 52.965000),
    (26.532261, 52.965340),
    (26.533991, 52.965420),
    (26.542440, 52.965752),
    (26.545700, 52.965919),
    (26.550270, 52.966122),
    (26.556589, 52.966381),
    (26.592489, 52.967831),
    (26.603390, 52.968349),
    (26.620871, 52.969181),
    (26.623011, 52.969299),
    (26.637550, 52.969891),
    (26.653870, 52.970409),
    (26.664419, 52.970749),
    (26.665220, 52.970772),
    (26.694630, 52.971611),
    (26.696430, 52.971611),
    (26.715059, 52.972809),
    (26.729601, 52.973400),
    (26.766821, 52.974621),
    (26.768490, 52.974689),
    (26.773380, 52.975121),
    (26.839090, 52.977451),
    (26.845301, 52.977669),
    (26.846380, 52.977711),
    (26.866699, 52.978661),
    (26.881140, 52.979328),
    (26.896160, 52.979759),
    (26.909599, 52.980141),
    (26.911270, 52.980190),
    (26.922470, 52.980640),
    (26.947130, 52.981609),
    (26.983450, 52.982861),
    (26.988070, 52.982990),
    (27.001150, 52.983540),
    (27.023769, 52.984261),
    (27.036060, 52.984661),
    (27.036230, 52.984669),
    (27.055620, 52.985291),
    (27.074570, 52.986019),
    (27.078770, 52.986149),
    (27.081270, 52.986191),
    (27.127819, 52.987751),
    (27.168501, 52.989460),
    (27.199940, 52.990349),
    (27.214680, 52.990810),
    (27.218941, 52.990952),
    (27.259140, 52.992290),
    (27.264380, 52.992378),
    (27.272190, 52.992809),
    (27.279261, 52.993130),
    (27.308750, 52.994438),
    (27.339569, 52.995171),
    (27.346260, 52.995331),
    (27.382740, 52.996498),
    (27.398050, 52.997169),
    (27.400141, 52.997189),
    (27.413799, 52.999321),
    (27.417629, 52.999859),
    (27.432301, 53.002079),
    (27.447081, 53.004219),
    (27.461821, 53.006359),
    (27.485849, 53.009850),
    (27.487740, 53.010132),
    (27.487949, 53.010170),
    (27.490499, 53.010559),
    (27.490761, 53.010590),
    (27.494181, 53.011101),
    (27.506029, 53.012840),
    (27.512131, 53.013680),
    (27.518230, 53.014591),
    (27.521481, 53.015049),
    (27.526051, 53.015701),
    (27.530600, 53.016392),
    (27.537170, 53.017391),
    (27.538179, 53.017590),
    (27.538811, 53.017761),
    (27.539570, 53.018131),
    (27.540400, 53.018608),
    (27.540541, 53.018719),
    (27.541241, 53.019291),
    (27.544220, 53.021450),
    (27.545719, 53.022480),
    (27.545971, 53.022659),
    (27.547640, 53.023842),
    (27.548229, 53.024261),
    (27.548531, 53.024471),
    (27.549490, 53.025150),
    (27.549870, 53.025421),
    (27.550011, 53.025520),
    (27.552160, 53.026970),
    (27.553129, 53.027660),
    (27.553310, 53.027790),
    (27.554621, 53.028709),
    (27.555000, 53.028992),
    (27.555201, 53.029140),
    (27.555889, 53.029621),
    (27.558380, 53.031368),
    (27.558769, 53.031651),
    (27.560419, 53.032681),
    (27.564240, 53.035461),
    (27.564520, 53.035679),
    (27.566790, 53.037090),
    (27.567261, 53.037380),
    (27.568850, 53.037941),
    (27.570440, 53.038261),
    (27.571859, 53.038540),
    (27.572830, 53.038750),
    (27.573971, 53.039001),
    (27.576210, 53.039421),
    (27.577440, 53.039661),
    (27.578341, 53.039822),
    (27.579081, 53.039982),
    (27.580570, 53.040298),
    (27.581440, 53.040470),
    (27.582230, 53.040619),
    (27.582510, 53.040668),
    (27.582781, 53.040730),
    (27.582970, 53.040771),
    (27.583719, 53.040920),
    (27.584270, 53.041031),
    (27.585211, 53.041222),
    (27.586500, 53.041481),
    (27.586840, 53.041561),
    (27.588980, 53.041988),
    (27.593399, 53.042919),
    (27.596750, 53.043560),
    (27.598339, 53.043880),
    (27.610590, 53.046360),
    (27.617970, 53.047852),
    (27.620350, 53.048328),
    (27.621500, 53.048550),
    (27.622881, 53.048820),
    (27.624161, 53.049110),
    (27.632420, 53.050732),
    (27.632940, 53.050838),
    (27.664419, 53.057129),
    (27.670670, 53.058399),
    (27.672421, 53.058640),
    (27.684271, 53.061150),
    (27.695499, 53.063358),
    (27.722830, 53.068779),
    (27.730869, 53.070381),
    (27.752890, 53.074749),
    (27.754780, 53.075062),
    (27.758169, 53.074902),
    (27.766920, 53.074261),
    (27.788549, 53.072449),
    (27.825140, 53.069500),
    (27.838329, 53.068432),
    (27.842470, 53.068081),
    (27.846479, 53.067741),
    (27.850821, 53.067440),
    (27.861071, 53.066631),
    (27.889940, 53.064232),
    (27.909740, 53.062592),
    (27.926821, 53.061230),
    (27.938061, 53.060329),
    (27.973850, 53.057362),
    (27.977369, 53.057011),
    (27.981150, 53.056751),
    (27.987410, 53.056129),
    (28.005100, 53.054951),
    (28.040030, 53.051849),
    (28.046650, 53.051189),
    (28.052521, 53.050720),
    (28.061010, 53.050129),
    (28.125759, 53.044628),
    (28.129511, 53.044281),
    (28.147129, 53.042671),
    (28.179171, 53.040001),
    (28.195299, 53.038391),
    (28.216209, 53.036362),
    (28.226280, 53.035381),
    (28.233919, 53.034779),
    (28.241890, 53.034061),
    (28.252291, 53.033150),
    (28.261971, 53.032230),
    (28.263050, 53.032181),
    (28.267071, 53.032730),
    (28.269020, 53.033020),
    (28.269510, 53.033089),
    (28.278351, 53.034439),
    (28.280609, 53.034779),
    (28.284861, 53.035419),
    (28.285601, 53.035530),
    (28.304390, 53.038330),
    (28.323210, 53.041290),
    (28.325399, 53.041630),
    (28.326660, 53.041828),
    (28.337860, 53.043430),
    (28.405621, 53.053551),
    (28.409691, 53.053951),
    (28.413910, 53.054352),
    (28.419130, 53.054680),
    (28.439140, 53.056332),
    (28.445580, 53.057011),
    (28.458891, 53.058201),
    (28.472811, 53.059460),
    (28.481770, 53.060181),
    (28.544580, 53.065800),
    (28.553869, 53.066631),
    (28.556170, 53.066830),
    (28.607281, 53.071281),
    (28.611170, 53.071621),
    (28.618851, 53.072281),
    (28.623421, 53.072510),
    (28.626169, 53.072491),
    (28.628071, 53.072479),
    (28.630119, 53.072472),
    (28.633230, 53.072529),
    (28.634871, 53.072559),
    (28.663200, 53.074108),
    (28.687780, 53.075722),
    (28.693199, 53.076050),
    (28.716709, 53.077789),
    (28.766411, 53.081051),
    (28.798000, 53.083321),
    (28.799629, 53.083431),
    (28.818451, 53.084709),
    (28.837820, 53.086021),
    (28.846500, 53.086689),
    (28.849060, 53.086861),
    (28.855320, 53.087269),
    (28.857380, 53.087410),
    (28.867519, 53.088081),
    (28.870781, 53.088211),
    (28.882799, 53.088940),
    (28.890850, 53.089520),
    (28.909241, 53.090832),
    (28.914900, 53.091251),
    (28.938320, 53.092991),
    (28.939560, 53.093079),
    (28.947340, 53.093658),
    (28.978920, 53.095612),
    (28.980650, 53.095718),
    (28.983049, 53.095871),
    (28.985880, 53.096062),
    (28.993771, 53.096642),
    (29.004551, 53.097431),
    (29.006580, 53.097721),
    (29.018410, 53.099590),
    (29.040810, 53.103100),
    (29.050859, 53.104740),
    (29.052059, 53.104900),
    (29.055830, 53.105511),
    (29.057470, 53.105770),
    (29.061331, 53.106449),
    (29.062460, 53.106640),
    (29.066561, 53.107311),
    (29.078150, 53.109112),
    (29.091970, 53.111359),
    (29.106050, 53.113659),
    (29.113939, 53.114861),
    (29.127159, 53.116840),
    (29.129129, 53.117180),
    (29.136431, 53.118290),
    (29.138060, 53.118549),
    (29.143909, 53.119450),
    (29.151859, 53.120682),
    (29.166771, 53.123051),
    (29.169649, 53.123669),
    (29.173700, 53.124279),
    (29.178190, 53.124939),
    (29.178961, 53.125149),
    (29.181480, 53.125481),
    (29.184099, 53.125889),
    (29.186310, 53.126228),
    (29.190371, 53.126888),
    (29.192350, 53.127190),
    (29.192659, 53.127239),
    (29.193769, 53.127411),
    (29.195040, 53.127621),
    (29.195190, 53.127651),
    (29.196751, 53.127899),
    (29.202351, 53.128761),
    (29.203470, 53.128880),
    (29.204180, 53.128948),
    (29.206289, 53.129120),
    (29.209860, 53.129391),
    (29.213110, 53.129688),
    (29.218639, 53.130119),
    (29.220690, 53.130291),
    (29.220631, 53.130711),
    (29.223249, 53.131260),
    (29.225410, 53.131710),
    (29.227699, 53.132198),
    (29.227520, 53.133579),
    (29.229670, 53.133991),
    (29.231939, 53.134350),
    (29.231760, 53.135750),
    (29.231600, 53.136929),
    (29.231560, 53.137112),
    (29.231199, 53.140072),
    (29.231110, 53.140751),
    (29.231230, 53.141041),
    (29.231899, 53.141918),
    (29.233471, 53.143570),
    (29.233810, 53.143879),
    (29.234150, 53.144138),
    (29.235531, 53.145000),
    (29.235630, 53.145061),
    (29.235800, 53.145149),
    (29.237089, 53.145901),
    (29.239590, 53.146999),
    (29.240339, 53.147320),
    (29.241261, 53.147709),
    (29.243731, 53.148762),
    (29.245939, 53.149681),
    (29.246460, 53.149792),
    (29.246519, 53.149780),
    (29.246811, 53.149761),
    (29.247000, 53.149750),
    (29.249069, 53.149071),
    (29.249580, 53.148861),
    (29.250010, 53.148659),
    (29.250250, 53.148479),
    (29.250549, 53.148121),
    (29.251381, 53.147079),
    (29.252350, 53.146069),
    (29.253639, 53.145309),
    (29.257401, 53.143250),
    (29.258301, 53.142872),
    (29.259260, 53.142601),
    (29.260290, 53.142368),
    (29.264980, 53.141861),
    (29.267790, 53.141590),
    (29.275591, 53.140789),
    (29.277031, 53.140652),
    (29.279301, 53.140419),
    (29.280010, 53.140350),
    (29.290359, 53.139290),
    (29.293119, 53.139011),
    (29.293591, 53.138981),
    (29.294870, 53.138828),
    (29.295340, 53.138779),
    (29.296049, 53.138748),
    (29.298241, 53.138859),
    (29.303610, 53.139130),
    (29.303770, 53.139141),
    (29.305349, 53.139221),
    (29.308620, 53.139420),
    (29.311440, 53.139580),
    (29.311760, 53.139591),
    (29.312099, 53.139610),
    (29.313669, 53.139671),
    (29.314360, 53.139751),
    (29.316759, 53.139839),
    (29.319719, 53.140018),
    (29.321051, 53.140099),
    (29.322081, 53.140099),
    (29.344090, 53.141369),
    (29.345770, 53.141472),
    (29.353149, 53.141899),
    (29.356670, 53.142071),
    (29.363710, 53.142502),
    (29.363800, 53.142231),
    (29.364161, 53.142059),
    (29.364660, 53.142040),
    (29.364910, 53.142159),
    (29.365080, 53.142330),
    (29.365129, 53.142502),
    (29.372580, 53.142899),
    (29.375811, 53.143009),
    (29.389799, 53.141300),
    (29.395380, 53.140701),
    (29.408600, 53.139149),
    (29.433491, 53.136230),
    (29.434780, 53.136150),
    (29.438040, 53.135799),
    (29.450480, 53.134430),
    (29.461040, 53.133141),
    (29.469790, 53.132019),
    (29.481300, 53.130650),
    (29.483530, 53.130051),
    (29.485161, 53.129539),
    (29.504299, 53.124298),
    (29.510910, 53.123791),
    (29.511681, 53.123699),
    (29.516140, 53.123531),
    (29.522320, 53.124130),
    (29.530199, 53.124859),
    (29.533300, 53.125542),
    (29.540779, 53.127480),
    (29.542990, 53.127991),
    (29.544161, 53.128208),
    (29.545650, 53.128132),
    (29.551500, 53.126961),
    (29.558460, 53.124729),
    (29.562941, 53.123291),
    (29.563780, 53.123020),
    (29.566099, 53.121300),
    (29.566490, 53.121071),
    (29.567129, 53.120701),
    (29.568640, 53.120361),
    (29.569540, 53.120251),
    (29.583860, 53.118549),
    (29.603781, 53.116150),
    (29.625059, 53.113659),
    (29.636570, 53.112228),
    (29.656820, 53.109711),
    (29.657940, 53.109631),
    (29.683340, 53.106621),
    (29.719311, 53.102341),
    (29.724751, 53.101700),
    (29.726990, 53.101429),
    (29.729691, 53.101040),
    (29.731750, 53.100780),
    (29.743509, 53.099411),
    (29.763290, 53.096970),
    (29.788660, 53.093830),
    (29.802650, 53.092201),
    (29.823690, 53.089680),
    (29.840580, 53.087650),
    (29.864401, 53.084721),
    (29.875521, 53.083359),
    (29.877001, 53.083179),
    (29.903330, 53.080021),
    (29.922640, 53.077610),
    (29.947451, 53.074730),
    (29.951059, 53.074310),
    (29.978600, 53.070831),
    (29.985229, 53.070019),
    (29.986151, 53.069908),
    (29.989540, 53.069500),
    (29.990629, 53.069370),
    (29.991011, 53.069321),
    (29.992451, 53.069149),
    (29.996010, 53.068710),
    (30.000360, 53.068218),
    (30.001600, 53.068081),
    (30.003960, 53.067810),
    (30.005659, 53.067589),
    (30.006830, 53.067539),
    (30.009411, 53.067410),
    (30.012739, 53.067379),
    (30.013580, 53.067471),
    (30.014099, 53.067532),
    (30.015829, 53.067749),
    (30.017599, 53.067940),
    (30.018511, 53.068039),
    (30.020069, 53.068241),
    (30.021709, 53.068470),
    (30.022720, 53.068581),
    (30.026520, 53.069141),
    (30.027460, 53.069401),
    (30.030581, 53.069832),
    (30.034470, 53.070358),
    (30.038059, 53.070850),
    (30.038759, 53.070999),
    (30.039370, 53.071259),
    (30.039900, 53.071579),
    (30.041679, 53.072670),
    (30.043989, 53.074070),
    (30.044880, 53.074589),
    (30.045740, 53.074848),
    (30.046101, 53.074890),
    (30.047260, 53.074821),
    (30.048389, 53.074741),
    (30.049780, 53.074638),
    (30.051060, 53.074570),
    (30.052340, 53.074509),
    (30.053101, 53.074471),
    (30.054050, 53.074409),
    (30.055620, 53.074329),
    (30.057480, 53.074242),
    (30.083309, 53.072891),
    (30.091200, 53.072830),
    (30.094299, 53.072811),
    (30.117630, 53.072521),
    (30.125299, 53.072418),
    (30.137730, 53.071918),
    (30.150520, 53.072121),
    (30.167259, 53.071861),
    (30.187000, 53.071602),
    (30.191280, 53.071579),
    (30.193661, 53.071541),
    (30.209141, 53.071259),
    (30.227850, 53.070999),
    (30.240129, 53.070911),
    (30.245020, 53.070831),
    (30.248350, 53.070831),
    (30.255489, 53.070831),
    (30.257210, 53.071259),
    (30.258841, 53.071930),
    (30.268560, 53.075840),
    (30.299669, 53.089359),
    (30.313080, 53.095032),
    (30.333080, 53.103619),
    (30.337971, 53.105770),
    (30.362089, 53.115891),
    (30.364000, 53.116711),
    (30.374201, 53.121059),
    (30.377661, 53.122540),
    (30.386040, 53.126110),
    (30.416170, 53.138969),
    (30.437540, 53.147991),
    (30.444401, 53.151001),
    (30.448160, 53.152550),
    (30.449369, 53.153049),
    (30.458191, 53.156700),
    (30.458670, 53.156849),
    (30.458969, 53.156860),
    (30.459209, 53.156849),
    (30.459511, 53.156830),
    (30.459730, 53.156860),
    (30.459900, 53.156910),
    (30.460039, 53.157001),
    (30.460110, 53.157120),
    (30.460150, 53.157230),
    (30.460350, 53.157520),
    (30.460489, 53.157669),
    (30.460680, 53.157829),
    (30.470150, 53.161812),
    (30.480600, 53.166168),
    (30.494450, 53.178581),
    (30.497021, 53.181381),
    (30.508350, 53.191681),
    (30.510839, 53.193741),
    (30.522079, 53.199230),
    (30.534100, 53.205330),
    (30.542589, 53.209702),
    (30.551090, 53.214081),
    (30.583191, 53.230289),
    (30.586281, 53.231850),
    (30.608250, 53.243011),
    (30.611860, 53.244850),
    (30.616320, 53.247131),
    (30.616751, 53.247341),
    (30.637030, 53.257469),
    (30.652800, 53.265320),
    (30.671169, 53.274681),
    (30.682409, 53.280338),
    (30.706270, 53.292358),
    (30.710911, 53.294590),
    (30.726101, 53.302269),
    (30.742229, 53.310429),
    (30.756571, 53.317680),
    (30.761141, 53.319962),
    (30.762230, 53.320511),
    (30.787130, 53.332958),
    (30.802660, 53.340851),
    (30.815550, 53.347321),
    (30.822781, 53.350941),
    (30.830730, 53.354931),
    (30.836821, 53.357929),
    (30.848410, 53.363861),
    (30.854300, 53.366730),
    (30.854931, 53.367031),
    (30.873301, 53.376301),
    (30.884710, 53.381882),
    (30.901810, 53.390461),
    (30.904890, 53.392010),
    (30.910351, 53.394749),
    (30.933981, 53.406601),
    (30.944880, 53.412090),
    (30.948320, 53.413731),
    (30.959841, 53.419529),
    (30.962200, 53.420780),
    (30.969601, 53.424541),
    (30.974609, 53.426979),
    (30.976730, 53.428009),
    (30.984970, 53.432011),
    (30.985479, 53.432270),
    (30.997259, 53.438049),
    (30.998779, 53.438702),
    (30.999990, 53.440762),
    (31.003160, 53.446079),
    (31.005739, 53.445999),
    (31.006680, 53.450802),
    (31.008829, 53.451832),
    (31.021009, 53.455608),
    (31.035259, 53.460331),
    (31.035780, 53.460499),
    (31.036810, 53.460838),
    (31.051229, 53.465569),
    (31.053200, 53.466171),
    (31.084339, 53.476158),
    (31.120661, 53.487801),
    (31.127359, 53.489941),
    (31.148809, 53.496819),
    (31.151739, 53.497761),
    (31.201521, 53.513721),
    (31.216360, 53.518471),
    (31.226089, 53.521580),
    (31.235849, 53.524700),
    (31.266920, 53.534489),
    (31.269680, 53.535412),
    (31.275669, 53.537411),
    (31.277990, 53.538090),
    (31.310711, 53.548351),
    (31.314131, 53.549419),
    (31.319790, 53.551311),
    (31.320940, 53.551689),
    (31.335770, 53.556591),
    (31.339531, 53.557831),
    (31.357420, 53.563061),
    (31.362410, 53.564030),
    (31.365841, 53.565762),
    (31.373310, 53.568260),
    (31.377001, 53.569279),
    (31.380520, 53.569660),
    (31.385370, 53.568390),
    (31.387079, 53.571220),
    (31.391371, 53.575089),
    (31.420740, 53.590790),
    (31.424650, 53.592030),
    (31.428391, 53.592731),
    (31.431049, 53.593109),
    (31.432501, 53.593319),
    (31.439369, 53.594311),
    (31.445450, 53.595169),
    (31.452440, 53.596371),
    (31.453930, 53.596668),
    (31.465750, 53.600960),
    (31.471399, 53.603020),
    (31.481331, 53.606651),
    (31.482731, 53.607151),
    (31.489559, 53.609631),
    (31.494949, 53.611561),
    (31.505440, 53.615421),
    (31.529890, 53.624260),
    (31.541691, 53.628521),
    (31.542160, 53.628689),
    (31.548361, 53.630959),
    (31.567680, 53.637932),
    (31.569559, 53.638611),
    (31.589491, 53.645859),
    (31.624319, 53.658379),
    (31.636930, 53.662880),
    (31.639851, 53.663921),
    (31.642670, 53.664959),
    (31.654530, 53.669319),
    (31.660830, 53.671631),
    (31.681999, 53.679272),
    (31.683701, 53.680340),
    (31.684629, 53.681080),
    (31.685640, 53.682060),
    (31.686550, 53.683319),
    (31.693090, 53.693390),
    (31.694229, 53.695141),
    (31.694740, 53.695930),
    (31.695511, 53.697109),
    (31.696060, 53.697689),
    (31.696760, 53.698421),
    (31.699160, 53.700481),
    (31.701910, 53.702202),
    (31.702900, 53.702690),
    (31.703449, 53.702969),
    (31.704149, 53.703209),
    (31.705770, 53.703751),
    (31.708260, 53.704430),
    (31.710159, 53.704891),
    (31.712900, 53.705212),
    (31.714540, 53.705330),
    (31.715990, 53.705441),
    (31.720440, 53.705662),
    (31.722601, 53.705761),
    (31.724850, 53.705872),
    (31.726311, 53.705940),
    (31.727690, 53.706001),
    (31.729271, 53.706070),
    (31.742350, 53.706680),
    (31.747009, 53.706909),
    (31.757780, 53.707432),
    (31.760620, 53.707520),
    (31.764219, 53.707352),
    (31.765850, 53.707088),
    (31.767401, 53.706749),
    (31.769970, 53.705811),
    (31.774441, 53.703400),
    (31.776751, 53.702541),
    (31.780010, 53.702030),
    (31.782930, 53.701859),
    (31.784389, 53.701939),
    (31.787050, 53.702030),
    (31.795719, 53.702801),
    (31.810230, 53.703999),
    (31.824560, 53.705120),
    (31.835030, 53.706150),
    (31.842070, 53.706661),
    (31.844130, 53.706841),
    (31.854429, 53.707779),
    (31.856661, 53.707951),
    (31.878731, 53.709679),
    (31.908760, 53.712238),
    (31.921749, 53.713310),
    (31.924400, 53.713581),
    (31.928930, 53.713959),
    (31.938351, 53.714771),
    (31.938810, 53.714802),
    (31.940701, 53.714951),
    (31.960110, 53.716560),
    (31.966921, 53.717121),
    (31.969749, 53.717258),
    (31.975229, 53.717709),
    (31.978889, 53.717972),
    (31.985920, 53.718391),
    (31.991329, 53.718941),
    (31.999571, 53.719879),
    (32.001202, 53.719971),
    (32.003849, 53.720112),
    (32.011810, 53.720718),
    (32.014320, 53.721008),
    (32.016762, 53.721169),
    (32.018009, 53.721321),
    (32.028240, 53.722111),
    (32.035530, 53.722759),
    (32.042629, 53.723381),
    (32.056950, 53.724621),
    (32.059109, 53.724720),
    (32.065948, 53.725311),
    (32.073551, 53.725891),
    (32.076149, 53.726120),
    (32.077351, 53.726219),
    (32.098450, 53.727901),
    (32.118629, 53.729530),
    (32.141430, 53.731369),
    (32.145771, 53.731670),
    (32.146889, 53.731758),
    (32.147339, 53.731800),
    (32.155910, 53.732460),
    (32.157070, 53.732780),
    (32.157661, 53.733009),
    (32.158779, 53.733372),
    (32.176979, 53.739109),
    (32.186131, 53.742001),
    (32.205460, 53.748100),
    (32.214230, 53.750870),
    (32.215260, 53.751190),
    (32.218090, 53.752071),
    (32.219570, 53.752541),
    (32.225052, 53.754261),
    (32.227089, 53.754910),
    (32.243031, 53.759941),
    (32.244499, 53.760399),
    (32.261349, 53.765720),
    (32.280788, 53.771671),
    (32.297779, 53.777081),
    (32.387821, 53.805222),
    (32.442059, 53.821991),
    (32.445259, 53.822990),
    (32.474480, 53.832130),
    (32.502659, 53.840931),
    (32.540859, 53.852680),
    (32.543861, 53.853390),
    (32.547459, 53.853851),
    (32.558708, 53.855320),
    (32.563690, 53.856030),
    (32.567890, 53.857239),
    (32.606689, 53.867771),
    (32.608570, 53.868370),
    (32.621731, 53.875198),
    (32.634491, 53.881790),
    (32.638531, 53.883610),
    (32.644711, 53.884720),
    (32.648911, 53.885632),
    (32.654411, 53.887249),
    (32.671051, 53.892269),
    (32.685909, 53.896759),
    (32.730629, 53.910309),
    (32.753029, 53.917030),
    (32.771091, 53.922508),
    (32.773891, 53.923359),
    (32.774872, 53.923630),
    (32.775959, 53.923962),
    (32.777081, 53.924301),
    (32.778389, 53.924702),
    (32.779079, 53.924919),
    (32.796848, 53.930271),
    (32.804909, 53.932701),
    (32.810940, 53.934528),
    (32.817348, 53.936470),
    (32.822350, 53.937988),
    (32.824451, 53.938641),
    (32.826309, 53.939209),
    (32.827549, 53.939590),
    (32.830070, 53.940350),
    (32.831909, 53.940891),
    (32.832001, 53.940910),
    (32.832031, 53.940929),
    (32.835251, 53.941891),
    (32.837631, 53.942600),
    (32.838711, 53.942928),
    (32.841450, 53.943741),
    (32.842590, 53.944080),
    (32.843510, 53.944389),
    (32.846111, 53.945251),
    (32.846539, 53.945499),
    (32.849110, 53.946960),
    (32.850361, 53.947739),
    (32.851051, 53.948120),
    (32.852058, 53.948662),
    (32.852551, 53.948719),
    (32.854340, 53.947762),
    (32.854771, 53.947529),
    (32.856049, 53.946838),
    (32.857849, 53.947990),
    (32.859341, 53.949070),
    (32.860691, 53.950340),
    (32.862061, 53.951630),
    (32.863331, 53.952801),
    (32.863651, 53.953121),
    (32.863892, 53.953339),
    (32.864059, 53.953411),
    (32.864250, 53.953449),
    (32.864578, 53.953411),
    (32.865021, 53.953098),
    (32.865479, 53.952969),
    (32.865910, 53.952942),
    (32.866680, 53.953178),
    (32.866951, 53.953289),
    (32.867081, 53.953529),
    (32.867111, 53.953850),
    (32.867020, 53.954109),
    (32.866760, 53.954330),
    (32.866692, 53.954399),
    (32.865841, 53.954578),
    (32.865540, 53.954720),
    (32.865479, 53.954948),
    (32.865559, 53.955021),
    (32.865929, 53.955429),
    (32.866161, 53.955688),
    (32.866360, 53.955921),
    (32.866631, 53.956211),
    (32.867199, 53.956841),
    (32.867390, 53.957069),
    (32.867611, 53.957298),
    (32.868019, 53.957760),
    (32.868080, 53.957829),
    (32.868130, 53.957890),
    (32.868698, 53.958519),
    (32.869381, 53.959278),
    (32.869541, 53.959469),
    (32.870010, 53.959999),
    (32.871231, 53.961399),
    (32.875759, 53.966579),
    (32.876991, 53.967812),
    (32.877159, 53.967918),
    (32.878880, 53.969090),
    (32.880539, 53.970200),
    (32.881580, 53.970879),
    (32.885300, 53.973331),
    (32.886890, 53.974388),
    (32.888050, 53.974861),
    (32.916790, 53.986599),
    (32.920910, 53.988239),
    (32.924728, 53.989849),
    (32.926651, 53.990631),
    (32.927860, 53.991089),
    (32.964561, 54.006031),
    (33.038891, 54.036240),
    (33.050991, 54.041031),
    (33.051430, 54.041199),
    (33.052380, 54.041592),
    (33.053719, 54.042030),
    (33.055519, 54.042580),
    (33.057732, 54.043129),
    (33.060059, 54.043800),
    (33.062340, 54.044449),
    (33.063938, 54.044930),
    (33.065208, 54.045502),
    (33.079830, 54.050030),
    (33.103489, 54.057098),
    (33.135578, 54.066780),
    (33.198151, 54.085751),
    (33.233330, 54.096329),
    (33.259430, 54.104149),
    (33.281120, 54.110691),
    (33.281681, 54.110851),
    (33.284809, 54.111820),
    (33.293892, 54.114540),
    (33.294930, 54.114849),
    (33.316238, 54.121250),
    (33.340012, 54.128311),
    (33.343342, 54.129299),
    (33.362679, 54.135101),
    (33.364719, 54.135700),
    (33.371750, 54.137810),
    (33.372959, 54.138180),
    (33.402931, 54.147099),
    (33.445080, 54.159512),
    (33.463009, 54.164791),
    (33.537849, 54.187191),
    (33.564289, 54.195030),
    (33.581970, 54.200150),
    (33.600311, 54.205681),
    (33.611179, 54.208969),
    (33.655270, 54.221840),
    (33.665249, 54.224751),
    (33.669731, 54.226158),
    (33.676559, 54.227951),
    (33.708389, 54.234341),
    (33.712551, 54.235241),
    (33.713539, 54.235451),
    (33.714989, 54.235790),
    (33.717682, 54.236382),
    (33.719151, 54.236912),
    (33.719379, 54.236992),
    (33.720921, 54.237560),
    (33.723511, 54.238628),
    (33.732540, 54.242168),
    (33.757610, 54.251999),
    (33.815540, 54.268921),
    (33.858860, 54.281670),
    (33.877350, 54.287121),
    (33.922550, 54.300240),
    (33.997280, 54.322060),
    (34.064171, 54.341591),
    (34.073601, 54.345390),
    (34.090092, 54.351990),
    (34.093239, 54.353230),
    (34.124500, 54.365719),
    (34.169109, 54.383549),
    (34.171322, 54.384411),
    (34.184570, 54.392181),
    (34.195370, 54.398689),
    (34.219109, 54.412819),
    (34.225010, 54.415981),
    (34.241489, 54.421669),
    (34.303249, 54.443432),
    (34.331100, 54.453220),
    (34.373199, 54.467949),
    (34.412640, 54.481750),
    (34.417511, 54.483570),
    (34.427059, 54.486912),
    (34.478222, 54.504799),
    (34.480282, 54.505779),
    (34.481899, 54.506870),
    (34.517441, 54.539501),
    (34.523239, 54.544819),
    (34.525311, 54.546371),
    (34.527210, 54.547169),
    (34.584171, 54.562981),
    (34.585339, 54.563301),
    (34.585979, 54.563480),
    (34.608330, 54.569618),
    (34.640869, 54.578629),
    (34.696659, 54.594090),
    (34.709099, 54.597500),
    (34.709541, 54.597630),
    (34.723831, 54.601551),
    (34.726841, 54.602379),
    (34.748009, 54.608200),
    (34.795799, 54.621521),
    (34.805470, 54.624062),
    (34.825062, 54.629459),
    (34.844830, 54.634911),
    (34.845520, 54.635090),
    (34.853790, 54.637371),
    (34.874390, 54.643051),
    (34.919960, 54.655540),
    (35.013649, 54.681080),
    (35.016289, 54.681789),
    (35.025162, 54.684170),
    (35.036732, 54.687302),
    (35.044930, 54.689522),
    (35.053928, 54.691952),
    (35.095718, 54.703239),
    (35.107868, 54.706532),
    (35.109951, 54.707100),
    (35.113838, 54.708149),
    (35.118740, 54.709480),
    (35.120369, 54.709900),
    (35.126949, 54.711681),
    (35.127090, 54.711712),
    (35.132839, 54.713261),
    (35.137161, 54.714649),
    (35.143459, 54.716660),
    (35.145729, 54.717361),
    (35.150440, 54.718811),
    (35.166191, 54.723900),
    (35.168770, 54.724731),
    (35.172482, 54.725971),
    (35.172958, 54.726120),
    (35.179489, 54.728210),
    (35.180222, 54.728439),
    (35.182850, 54.729271),
    (35.184719, 54.729900),
    (35.186470, 54.730461),
    (35.187069, 54.730659),
    (35.194382, 54.733002),
    (35.195290, 54.733299),
    (35.195530, 54.733379),
    (35.204639, 54.736271),
    (35.207020, 54.737011),
    (35.208580, 54.737511),
    (35.209351, 54.737751),
    (35.210571, 54.738152),
    (35.211830, 54.738579),
    (35.212830, 54.738899),
    (35.214191, 54.739330),
    (35.214951, 54.739571),
    (35.219650, 54.741070),
    (35.220150, 54.741230),
    (35.220921, 54.741489),
    (35.221779, 54.741680),
    (35.224110, 54.741680),
    (35.224209, 54.741680),
    (35.225849, 54.741669),
    (35.226681, 54.741680),
    (35.226849, 54.741669),
    (35.229580, 54.741711),
    (35.229630, 54.742531),
    (35.229710, 54.744011),
    (35.230808, 54.744019),
    (35.231411, 54.744019),
    (35.232170, 54.744030),
    (35.232311, 54.744030),
    (35.233341, 54.744030),
    (35.234570, 54.744019),
    (35.234909, 54.744019),
    (35.236061, 54.744030),
    (35.237591, 54.744041),
    (35.237991, 54.744091),
    (35.238270, 54.744171),
    (35.239239, 54.744438),
    (35.239658, 54.744560),
    (35.241009, 54.744961),
    (35.242569, 54.745419),
    (35.242950, 54.745541),
    (35.247139, 54.746780),
    (35.247311, 54.746830),
    (35.248058, 54.747059),
    (35.248402, 54.747150),
    (35.248920, 54.747311),
    (35.249229, 54.747398),
    (35.249519, 54.747490),
    (35.251381, 54.748020),
    (35.252491, 54.748360),
    (35.254082, 54.748821),
    (35.254398, 54.748920),
    (35.255581, 54.749260),
    (35.257179, 54.749729),
    (35.261021, 54.750858),
    (35.263340, 54.751530),
    (35.265411, 54.752331),
    (35.279129, 54.758949),
    (35.282539, 54.760559),
    (35.288071, 54.763210),
    (35.294102, 54.766079),
    (35.296951, 54.767319),
    (35.302391, 54.769920),
    (35.303188, 54.770370),
    (35.305199, 54.771389),
    (35.305710, 54.771648),
    (35.311272, 54.774261),
    (35.315849, 54.776451),
    (35.319820, 54.777950),
    (35.334599, 54.783192),
    (35.340771, 54.785351),
    (35.341209, 54.785511),
    (35.351120, 54.788990),
    (35.352211, 54.789379),
    (35.359989, 54.792110),
    (35.365379, 54.793980),
    (35.393929, 54.803989),
    (35.407162, 54.808620),
    (35.434368, 54.818199),
    (35.462391, 54.828030),
    (35.468342, 54.830101),
    (35.481152, 54.834560),
    (35.493389, 54.838829),
    (35.518871, 54.847698),
    (35.520470, 54.848259),
    (35.532269, 54.852348),
    (35.533649, 54.852840),
    (35.548180, 54.857880),
    (35.558769, 54.861561),
    (35.567570, 54.864620),
    (35.581860, 54.869549),
    (35.592758, 54.873348),
    (35.603760, 54.877140),
    (35.620819, 54.883018),
    (35.629929, 54.886162),
    (35.633900, 54.887520),
    (35.638401, 54.889069),
    (35.651321, 54.893520),
    (35.655830, 54.895081),
    (35.659550, 54.896351),
    (35.666920, 54.898891),
    (35.670391, 54.900101),
    (35.672218, 54.900711),
    (35.674221, 54.901409),
    (35.678131, 54.902771),
    (35.678921, 54.903042),
    (35.684929, 54.905109),
    (35.696800, 54.909199),
    (35.703579, 54.911541),
    (35.712620, 54.914639),
    (35.737862, 54.923290),
    (35.741692, 54.924610),
    (35.742722, 54.925011),
    (35.743809, 54.925598),
    (35.745010, 54.926311),
    (35.750839, 54.929729),
    (35.752251, 54.930569),
    (35.753201, 54.931061),
    (35.754810, 54.931808),
    (35.756771, 54.932629),
    (35.759392, 54.933609),
    (35.762180, 54.934620),
    (35.762600, 54.934780),
    (35.767792, 54.936649),
    (35.775349, 54.939301),
    (35.779930, 54.940910),
    (35.790298, 54.944550),
    (35.806461, 54.950161),
    (35.823910, 54.956268),
    (35.839981, 54.961800),
    (35.840271, 54.961899),
    (35.847511, 54.964432),
    (35.848301, 54.964668),
    (35.848919, 54.964802),
    (35.851650, 54.965309),
    (35.852692, 54.965500),
    (35.854912, 54.965900),
    (35.855782, 54.966110),
    (35.856140, 54.966240),
    (35.856441, 54.966450),
    (35.859550, 54.966141),
    (35.862381, 54.965721),
    (35.865120, 54.965290),
    (35.867939, 54.964909),
    (35.870731, 54.964500),
    (35.871250, 54.965599),
    (35.873619, 54.965290),
    (35.874229, 54.965271),
    (35.876148, 54.965221),
    (35.878670, 54.965172),
    (35.881920, 54.965191),
    (35.886051, 54.965340),
    (35.894878, 54.965649),
    (35.897099, 54.965729),
    (35.900318, 54.965839),
    (35.904202, 54.965981),
    (35.914379, 54.966351),
    (35.929390, 54.966911),
    (35.944618, 54.967468),
    (35.974880, 54.968552),
    (36.047100, 54.971069),
    (36.054531, 54.971291),
    (36.058708, 54.971439),
    (36.082439, 54.972290),
    (36.087860, 54.972481),
    (36.095200, 54.972721),
    (36.107658, 54.973148),
    (36.108089, 54.973171),
    (36.151329, 54.974640),
    (36.153542, 54.974751),
    (36.155701, 54.974960),
    (36.159931, 54.975422),
    (36.161758, 54.975620),
    (36.163250, 54.975780),
    (36.164879, 54.975971),
    (36.167641, 54.976261),
    (36.172161, 54.976749),
    (36.194340, 54.979172),
    (36.202919, 54.980099),
    (36.234692, 54.983521),
    (36.236420, 54.983700),
    (36.246609, 54.984791),
    (36.246861, 54.984821),
    (36.247059, 54.984840),
    (36.248909, 54.985050),
    (36.253040, 54.985489),
    (36.257801, 54.986000),
    (36.277729, 54.988140),
    (36.297169, 54.990219),
    (36.297371, 54.990238),
    (36.302509, 54.990791),
    (36.322029, 54.992882),
    (36.323780, 54.993069),
    (36.332779, 54.993999),
    (36.334911, 54.994221),
    (36.336399, 54.994389),
    (36.338459, 54.994610),
    (36.341640, 54.994961),
    (36.347569, 54.995590),
    (36.351299, 54.995991),
    (36.352261, 54.996120),
    (36.352680, 54.996170),
    (36.357460, 54.996681),
    (36.377491, 54.998791),
    (36.378300, 54.998871),
    (36.386490, 54.999722),
    (36.391960, 55.000278),
    (36.394230, 55.000511),
    (36.394600, 55.000038),
    (36.395210, 54.999519),
    (36.395691, 54.999359),
    (36.395821, 54.999660),
    (36.395561, 55.000259),
    (36.395309, 55.000648),
    (36.395580, 55.000679),
    (36.411018, 55.002300),
    (36.414059, 55.002621),
    (36.421051, 55.003361),
    (36.425171, 55.003799),
    (36.426300, 55.003929),
    (36.427990, 55.004101),
    (36.428810, 55.004189),
    (36.435989, 55.004959),
    (36.437290, 55.005100),
    (36.438580, 55.005230),
    (36.439560, 55.005329),
    (36.439579, 55.005329),
    (36.440109, 55.005390),
    (36.443340, 55.005730),
    (36.445881, 55.006001),
    (36.446079, 55.006020),
    (36.447769, 55.006229),
    (36.448231, 55.006371),
    (36.448589, 55.006512),
    (36.449081, 55.006760),
    (36.450779, 55.007771),
    (36.452450, 55.008732),
    (36.454571, 55.007561),
    (36.456871, 55.008881),
    (36.458450, 55.009800),
    (36.460331, 55.010841),
    (36.461552, 55.011589),
    (36.462090, 55.011589),
    (36.462749, 55.011902),
    (36.462528, 55.012180),
    (36.463310, 55.012600),
    (36.466789, 55.011360),
    (36.467178, 55.011219),
    (36.469379, 55.010441),
    (36.471001, 55.010990),
    (36.474190, 55.012058),
    (36.475910, 55.012661),
    (36.476929, 55.013008),
    (36.478828, 55.013660),
    (36.480381, 55.014118),
    (36.482128, 55.014690),
    (36.483849, 55.015320),
    (36.485119, 55.015709),
    (36.486740, 55.016289),
    (36.489059, 55.017052),
    (36.491879, 55.017979),
    (36.497520, 55.019859),
    (36.499729, 55.020611),
    (36.500172, 55.020729),
    (36.500690, 55.020950),
    (36.503029, 55.021721),
    (36.504539, 55.022240),
    (36.515591, 55.026871),
    (36.519932, 55.028660),
    (36.521889, 55.029491),
    (36.522259, 55.029640),
    (36.526299, 55.031319),
    (36.528919, 55.032429),
    (36.533401, 55.034599),
    (36.540951, 55.038361),
    (36.548439, 55.042110),
    (36.549259, 55.042660),
    (36.552898, 55.046169),
    (36.553551, 55.046589),
    (36.555988, 55.047668),
    (36.556519, 55.047890),
    (36.560410, 55.049530),
    (36.560940, 55.049751),
    (36.571308, 55.054111),
    (36.571781, 55.054310),
    (36.574070, 55.055260),
    (36.578732, 55.057240),
    (36.582039, 55.058578),
    (36.583260, 55.059101),
    (36.589630, 55.061840),
    (36.592579, 55.063110),
    (36.594040, 55.063709),
    (36.597710, 55.065151),
    (36.608292, 55.069592),
    (36.609440, 55.070099),
    (36.612560, 55.071381),
    (36.616371, 55.072971),
    (36.626659, 55.077259),
    (36.627541, 55.077621),
    (36.627869, 55.077759),
    (36.628151, 55.077839),
    (36.628300, 55.077869),
    (36.628460, 55.077881),
    (36.628479, 55.077839),
    (36.628590, 55.077820),
    (36.628719, 55.077839),
    (36.628880, 55.077900),
    (36.629021, 55.078030),
    (36.629250, 55.078232),
    (36.629601, 55.078480),
    (36.630199, 55.078732),
    (36.635231, 55.080791),
    (36.646080, 55.085030),
    (36.646770, 55.085289),
    (36.647362, 55.085510),
    (36.648689, 55.086029),
    (36.649731, 55.086449),
    (36.650089, 55.086590),
    (36.650791, 55.086868),
    (36.650810, 55.086880),
    (36.653461, 55.087921),
    (36.655010, 55.088531),
    (36.655140, 55.088581),
    (36.657181, 55.089359),
    (36.657661, 55.089539),
    (36.660591, 55.090691),
    (36.661110, 55.090889),
    (36.661880, 55.091190),
    (36.662682, 55.091511),
    (36.664280, 55.092121),
    (36.664989, 55.092400),
    (36.665119, 55.092449),
    (36.672081, 55.095150),
    (36.673569, 55.095741),
    (36.673870, 55.095860),
    (36.674370, 55.096062),
    (36.674389, 55.096069),
    (36.676991, 55.097069),
    (36.684021, 55.099781),
    (36.691219, 55.102600),
    (36.697910, 55.105228),
    (36.699532, 55.105881),
    (36.724789, 55.115730),
    (36.739330, 55.121391),
    (36.741249, 55.122150),
    (36.782631, 55.138222),
    (36.783581, 55.138592),
    (36.827160, 55.124310),
    (36.827240, 55.124439),
    (36.827469, 55.124500),
    (36.828400, 55.124371),
    (36.828861, 55.124191),
    (36.829460, 55.123871),
    (36.831390, 55.123260),
    (36.833130, 55.122669),
    (36.833691, 55.122631),
    (36.837830, 55.125221),
    (36.838299, 55.125488),
    (36.838829, 55.125599),
    (36.839470, 55.125420),
    (36.839802, 55.125408),
    (36.840450, 55.125500),
    (36.841061, 55.125702),
    (36.841450, 55.125751),
    (36.844299, 55.127022),
    (36.844299, 55.127270),
    (36.844170, 55.127510),
    (36.844090, 55.127651),
    (36.843800, 55.128342),
    (36.845020, 55.128139),
    (36.845650, 55.127850),
    (36.847130, 55.128010),
    (36.851540, 55.129349),
    (36.852230, 55.129501),
    (36.853519, 55.128181),
    (36.854671, 55.126999),
    (36.855030, 55.126869),
    (36.856468, 55.126320),
    (36.857281, 55.126209),
    (36.858219, 55.125500),
    (36.858620, 55.125050),
    (36.859791, 55.124939),
    (36.861351, 55.125252),
    (36.863739, 55.125210),
    (36.865528, 55.124840),
    (36.866920, 55.123600),
    (36.867962, 55.123371),
    (36.868210, 55.123230),
    (36.868519, 55.123230),
    (36.870239, 55.122799),
    (36.871319, 55.122719),
    (36.873489, 55.122120),
    (36.878040, 55.121422),
    (36.879768, 55.121571),
    (36.881130, 55.121429),
    (36.882271, 55.120300),
    (36.882439, 55.120140),
    (36.883530, 55.119930),
    (36.885380, 55.118759),
    (36.885719, 55.118679),
    (36.888580, 55.118851),
    (36.890270, 55.119499),
    (36.893002, 55.119720),
    (36.893909, 55.120510),
    (36.895050, 55.120571),
    (36.896858, 55.120560),
    (36.897900, 55.120510),
    (36.899040, 55.120838),
    (36.898998, 55.121250),
    (36.899231, 55.121410),
    (36.901169, 55.121361),
    (36.904629, 55.121361),
    (36.906700, 55.121632),
    (36.907532, 55.121658),
    (36.908291, 55.121361),
    (36.909599, 55.121201),
    (36.910629, 55.121189),
    (36.912361, 55.121510),
    (36.913651, 55.121300),
    (36.913849, 55.120960),
    (36.914822, 55.120880),
    (36.916538, 55.120350),
    (36.917221, 55.119930),
    (36.917641, 55.119400),
    (36.918671, 55.118858),
    (36.923481, 55.117691),
    (36.924629, 55.117088),
    (36.925041, 55.117111),
    (36.925522, 55.117378),
    (36.926281, 55.117409),
    (36.927269, 55.117722),
    (36.929180, 55.117870),
    (36.930370, 55.117722),
    (36.931049, 55.117771),
    (36.932671, 55.118160),
    (36.934750, 55.118370),
    (36.936138, 55.118290),
    (36.936272, 55.118229),
    (36.936821, 55.118179),
    (36.937000, 55.118500),
    (36.938251, 55.119270),
    (36.939838, 55.119869),
    (36.940750, 55.120289),
    (36.941639, 55.120701),
    (36.941830, 55.120861),
    (36.941490, 55.121479),
    (36.943291, 55.121792),
    (36.944160, 55.121792),
    (36.944839, 55.121342),
    (36.946201, 55.120682),
    (36.946701, 55.120651),
    (36.947140, 55.120171),
    (36.947350, 55.119579),
    (36.947800, 55.119331),
    (36.950001, 55.118980),
    (36.952759, 55.118759),
    (36.954979, 55.118290),
    (36.956612, 55.117630),
    (36.959080, 55.116741),
    (36.959782, 55.116261),
    (36.960171, 55.115780),
    (36.961102, 55.115959),
    (36.963470, 55.116131),
    (36.964779, 55.116020),
    (36.966122, 55.115688),
    (36.967899, 55.115410),
    (36.969620, 55.115162),
    (36.971779, 55.114609),
    (36.972111, 55.114410),
    (36.975330, 55.113541),
    (36.976372, 55.113091),
    (36.979698, 55.112720),
    (36.981850, 55.112061),
    (36.982861, 55.111900),
    (36.983608, 55.111919),
    (36.983849, 55.111900),
    (36.984032, 55.111889),
    (36.984131, 55.111729),
    (36.984329, 55.111691),
    (36.985050, 55.111481),
    (36.986408, 55.111431),
    (36.986691, 55.111671),
    (36.986691, 55.112030),
    (36.986950, 55.112202),
    (36.988060, 55.112289),
    (36.990520, 55.112129),
    (36.995300, 55.112720),
    (36.997551, 55.113468),
    (37.002251, 55.112461),
    (37.002441, 55.112202),
    (37.002010, 55.111301),
    (37.002331, 55.111259),
    (37.002491, 55.111469),
    (37.003620, 55.112839),
    (37.004219, 55.112991),
    (37.004631, 55.113361),
    (37.004700, 55.113750),
    (37.004871, 55.113708),
    (37.005569, 55.112679),
    (37.006821, 55.112041),
    (37.009731, 55.110920),
    (37.011341, 55.110828),
    (37.012211, 55.111111),
    (37.013489, 55.111740),
    (37.015469, 55.112370),
    (37.025341, 55.113319),
    (37.028591, 55.113392),
    (37.033852, 55.113140),
    (37.038738, 55.113060),
    (37.039631, 55.113041),
    (37.040710, 55.113220),
    (37.041599, 55.113998),
    (37.041950, 55.114510),
    (37.042931, 55.114922),
    (37.043598, 55.114948),
    (37.045071, 55.114681),
    (37.045959, 55.114349),
    (37.048660, 55.112850),
    (37.050270, 55.111179),
    (37.055370, 55.108898),
    (37.056831, 55.108440),
    (37.057072, 55.108139),
    (37.057430, 55.107979),
    (37.057678, 55.107849),
    (37.057838, 55.107262),
    (37.058128, 55.107182),
    (37.058922, 55.106998),
    (37.059620, 55.107159),
    (37.060150, 55.107090),
    (37.060841, 55.106640),
    (37.062290, 55.106491),
    (37.063110, 55.106880),
    (37.064270, 55.106812),
    (37.065941, 55.106300),
    (37.066029, 55.105728),
    (37.066090, 55.105122),
    (37.066662, 55.105049),
    (37.070591, 55.105068),
    (37.072441, 55.105000),
    (37.074471, 55.105499),
    (37.076759, 55.106209),
    (37.077831, 55.106541),
    (37.081692, 55.107811),
    (37.082699, 55.108021),
    (37.084110, 55.107941),
    (37.086071, 55.107460),
    (37.090179, 55.107029),
    (37.092060, 55.106750),
    (37.094391, 55.106251),
    (37.096390, 55.105461),
    (37.096081, 55.104919),
    (37.096249, 55.104839),
    (37.096260, 55.104649),
    (37.096039, 55.104561),
    (37.096230, 55.104519),
    (37.096291, 55.104389),
    (37.096909, 55.104198),
    (37.097580, 55.103859),
    (37.098019, 55.103531),
    (37.100090, 55.103168),
    (37.103882, 55.103390),
    (37.107899, 55.102951),
    (37.108829, 55.105179),
    (37.109989, 55.106289),
    (37.114559, 55.108601),
    (37.126110, 55.112492),
    (37.132870, 55.113869),
    (37.135551, 55.114422),
    (37.143639, 55.114399),
    (37.160591, 55.113689),
    (37.167400, 55.112629),
    (37.168499, 55.112598),
    (37.173981, 55.113960),
    (37.177631, 55.115292),
    (37.181881, 55.111858),
    (37.184792, 55.110481),
    (37.186169, 55.109829),
    (37.197540, 55.109692),
    (37.206772, 55.106010),
    (37.211079, 55.105511),
    (37.222580, 55.106209),
    (37.228321, 55.106129),
    (37.233238, 55.105061),
    (37.244549, 55.103298),
    (37.247639, 55.103149),
    (37.251339, 55.102421),
    (37.252621, 55.102470),
    (37.253731, 55.102798),
    (37.256569, 55.103989),
    (37.267151, 55.105621),
    (37.275108, 55.106789),
    (37.276058, 55.107079),
    (37.286098, 55.111752),
    (37.287560, 55.112240),
    (37.291851, 55.112679),
    (37.304550, 55.116409),
    (37.308929, 55.117290),
    (37.312279, 55.117882),
    (37.324741, 55.121410),
    (37.327599, 55.122120),
    (37.335152, 55.123531),
    (37.337212, 55.123909),
    (37.337811, 55.123749),
    (37.338638, 55.123631),
    (37.339630, 55.123581),
    (37.343979, 55.123459),
    (37.345379, 55.123421),
    (37.346241, 55.123451),
    (37.347469, 55.123619),
    (37.348919, 55.123890),
    (37.351589, 55.123871),
    (37.353069, 55.123852),
    (37.354549, 55.123878),
    (37.356030, 55.123951),
    (37.359230, 55.124241),
    (37.365318, 55.124741),
    (37.369572, 55.125099),
    (37.374989, 55.125599),
    (37.376949, 55.125889),
    (37.380440, 55.126400),
    (37.381500, 55.126640),
    (37.384418, 55.127621),
    (37.387081, 55.128578),
    (37.387680, 55.128719),
    (37.388451, 55.128849),
    (37.391029, 55.129051),
    (37.391918, 55.129059),
    (37.392891, 55.128929),
    (37.393860, 55.128700),
    (37.395061, 55.128460),
    (37.396061, 55.128349),
    (37.396832, 55.128281),
    (37.401058, 55.128029),
    (37.404419, 55.127831),
    (37.405540, 55.127850),
    (37.406551, 55.127918),
    (37.407661, 55.128029),
    (37.407982, 55.128071),
    (37.408821, 55.128250),
    (37.410431, 55.128651),
    (37.415249, 55.130058),
    (37.416939, 55.130619),
    (37.418121, 55.131161),
    (37.418579, 55.131500),
    (37.419781, 55.132660),
    (37.421021, 55.133739),
    (37.421600, 55.134079),
    (37.422401, 55.134399),
    (37.423740, 55.134689),
    (37.430691, 55.135429),
    (37.439819, 55.136429),
    (37.444241, 55.137070),
    (37.445789, 55.137390),
    (37.446259, 55.137711),
    (37.446480, 55.137909),
    (37.446522, 55.138149),
    (37.446522, 55.138840),
    (37.446651, 55.139130),
    (37.446819, 55.139309),
    (37.447330, 55.139400),
    (37.448231, 55.139309),
    (37.449612, 55.139111),
    (37.450611, 55.139000),
    (37.450859, 55.139011),
    (37.451141, 55.139160),
    (37.451370, 55.140060),
    (37.451740, 55.141350),
    (37.451839, 55.141541),
    (37.452782, 55.141369),
    (37.453220, 55.142189),
    (37.455021, 55.141769),
    (37.455151, 55.141739),
    (37.456871, 55.141331),
    (37.457401, 55.141209),
    (37.457920, 55.141090),
    (37.458149, 55.141060),
    (37.458469, 55.141041),
    (37.458759, 55.141090),
    (37.460041, 55.141430),
    (37.461380, 55.141788),
    (37.462379, 55.142052),
    (37.462780, 55.142170),
    (37.463261, 55.142288),
    (37.465839, 55.143002),
    (37.467461, 55.143429),
    (37.468800, 55.143780),
    (37.468929, 55.143810),
    (37.470261, 55.144161),
    (37.472549, 55.144730),
    (37.472809, 55.144791),
    (37.472919, 55.144821),
    (37.473640, 55.145000),
    (37.473930, 55.145069),
    (37.474579, 55.145241),
    (37.475269, 55.145409),
    (37.476589, 55.145729),
    (37.477341, 55.145920),
    (37.477928, 55.146061),
    (37.478760, 55.146271),
    (37.480831, 55.146721),
    (37.481369, 55.146839),
    (37.484119, 55.147449),
    (37.484379, 55.147511),
    (37.486080, 55.147911),
    (37.487350, 55.148220),
    (37.487560, 55.148270),
    (37.487820, 55.148331),
    (37.487961, 55.148350),
    (37.488129, 55.148338),
    (37.488251, 55.148319),
    (37.488350, 55.148300),
    (37.488491, 55.148300),
    (37.488590, 55.148289),
    (37.488670, 55.148258),
    (37.488750, 55.148201),
    (37.489029, 55.147820),
    (37.489441, 55.147301),
    (37.489552, 55.147141),
    (37.489601, 55.146950),
    (37.489651, 55.146370),
    (37.489910, 55.143520),
    (37.489929, 55.143330),
    (37.489910, 55.143139),
    (37.489658, 55.142712),
    (37.489529, 55.142540),
    (37.489479, 55.142349),
    (37.489471, 55.142250),
    (37.489460, 55.142078),
    (37.489571, 55.141670),
    (37.490040, 55.140911),
    (37.490170, 55.140800),
    (37.490341, 55.140751),
    (37.490551, 55.140739),
    (37.490761, 55.140751),
    (37.490978, 55.140789),
    (37.491161, 55.140881),
    (37.492050, 55.141529),
    (37.492809, 55.141972),
    (37.493599, 55.142300),
    (37.494450, 55.142559),
    (37.495399, 55.142799),
    (37.499352, 55.143520),
    (37.500710, 55.143681),
    (37.502541, 55.143810),
    (37.503448, 55.143860),
    (37.504372, 55.143829),
    (37.510361, 55.143398),
    (37.512569, 55.143269),
    (37.520920, 55.143978),
    (37.522591, 55.144081),
    (37.523918, 55.144058),
    (37.524540, 55.144039),
    (37.524780, 55.143970),
    (37.525200, 55.143761),
    (37.525620, 55.143398),
    (37.526211, 55.142811),
    (37.528091, 55.140289),
    (37.529202, 55.139511),
    (37.532959, 55.137581),
    (37.537201, 55.134258),
    (37.538979, 55.132900),
    (37.541039, 55.131809),
    (37.542179, 55.131199),
    (37.545330, 55.129169),
    (37.546650, 55.129459),
    (37.546921, 55.129520),
    (37.555550, 55.130920),
    (37.556320, 55.130970),
    (37.557949, 55.131062),
    (37.559521, 55.131149),
    (37.560650, 55.131229),
    (37.567589, 55.128361),
    (37.575562, 55.117641),
    (37.579189, 55.112530),
    (37.580021, 55.111240),
    (37.580830, 55.109951),
    (37.581760, 55.108349),
    (37.582611, 55.106709),
    (37.583469, 55.104809),
    (37.584179, 55.102982),
    (37.584450, 55.101910),
    (37.584751, 55.100800),
    (37.585098, 55.098652),
    (37.585129, 55.096741),
    (37.585041, 55.095650),
    (37.584900, 55.094589),
    (37.584690, 55.093491),
    (37.584419, 55.092388),
    (37.584171, 55.091629),
    (37.583961, 55.091049),
    (37.583450, 55.089729),
    (37.582878, 55.088551),
    (37.582291, 55.087399),
    (37.582001, 55.086880),
    (37.581619, 55.086182),
    (37.581181, 55.085449),
    (37.580238, 55.084030),
    (37.579189, 55.082489),
    (37.578209, 55.081131),
    (37.577320, 55.080040),
    (37.577030, 55.079651),
    (37.576401, 55.078850),
    (37.576080, 55.078442))]

# "threshold": "0.0005", ...  # lon, lat, area?
VwPts = [LatLon_(_lat, _lon) for _lon, _lat, _a2 in (
    (2.32986, 48.86005,  0),  # lon, lat
    (2.35093, 48.863411, 0.0006764590350000889),
    (2.43115, 48.940418, 0.005275181324999963),
    (2.54246, 48.960732, 0.0013039877850000996),
    (2.63999, 49.001961, 0.010534887319999823),
    (2.80339, 49.144669, 0.024102912679999897),
    (2.85119, 49.159790, 0.0007342628499998849),
    (2.99549, 49.236160, 0.0034791586549993733),
    (3.08543, 49.265160, 0.0006159743600001309),
    (3.13198, 49.266472, 0.003311627689999829),
    (3.21429, 49.302959, 0.0009464529800000195),
    (3.28301, 49.356419, 0.0018893187500001478),
    (3.32890, 49.358730, 0.09552116839999703),
    (3.37508, 49.387329, 0.0005483386499999484),
    (3.36840, 49.406940, 0.0008029409999999435),
    (3.43405, 49.446411, 0.002959171529999519),
    (3.51661, 49.463291, 0.0026900486400000365),
    (3.62701, 49.551029, 0.015417812199999662),
    (3.65985, 49.594040, 0.0005695053100000875),
    (3.71867, 49.705761, 0.00977195401000054),
    (3.80852, 49.780540, 0.0014305421600002072),
    (3.93060, 49.850300, 0.011768190849826103),
    (4.00552, 49.867611, 0.0006279938350000511),
    (4.02625, 49.889511, 0.0006053469450000905),
    (4.09659, 49.905418, 0.0021937935149999514),
    (4.10586, 49.934929, 0.0008882974199991181),
    (4.16724, 49.974251, 0.0006570687600002264),
    (4.31856, 50.027500, 0.004801179380001489),
    (4.37885, 50.030609, 0.0010781928850002172),
    (4.46792, 50.070969, 0.03488412753500111),
    (4.49368, 50.127609, 0.0008648552000000303),
    (4.57809, 50.246059, 0.0010913535349680074),
    (4.60485, 50.252739, 0.0005071614200001603),
    (4.65955, 50.304298, 0.001078659360000252),
    (4.71331, 50.316250, 0.005746164855001361),
    (4.86628, 50.422180, 0.0012534538349999722),
    (4.85599, 50.445961, 0.0036526170449996402),
    (4.94456, 50.503571, 0.0007576398200001946),
    (5.00459, 50.525509, 0.0019311189600001934),
    (5.06250, 50.582500, 0.01865430001500212),
    (5.12338, 50.591831, 0.0014397069050002618),
    (5.19067, 50.649441, 0.0005253489150003868),
    (5.32410, 50.724720, 0.0013054674849995174),
    (5.46203, 50.782970, 0.38402723349999696),
    (5.59527, 50.811749, 0.003648713830000012),
    (5.70955, 50.859509, 0.0009227223999996644),
    (5.78653, 50.907829, 0.0012011808400062926),
    (5.83605, 50.912300, 0.0013927635499998384),
    (5.96387, 50.980091, 0.0013384183800003785),
    (6.14661, 51.039459, 0.0032356071399997893),
    (6.21046, 51.077419, 0.0008143443249999117),
    (6.33651, 51.126850, 0.04902457900000075),
    (6.36855, 51.158169, 0.0007331124400002367),
    (6.48883, 51.229980, 0.003027862770000432),
    (6.47779, 51.252701, 0.0015974398750002344),
    (6.58010, 51.331532, 0.026891873830001863),
    (6.75227, 51.371132, 0.007320081329999557),
    (6.84989, 51.429039, 0.0016811635150002966),
    (6.87801, 51.431438, 0.000512130390000089),
    (6.97855, 51.476440, 0.0011294343550004844),
    (7.01853, 51.508781, 0.0005533025450000715),
    (7.08124, 51.531830, 30.637291359080464),
    (7.24011, 51.558880, 0.0005946596100000248),
    (7.31798, 51.557789, 0.0031382185750001104),
    (7.42589, 51.595341, 0.0014381680599997108),
    (7.54105, 51.608761, 0.023957451864999257),
    (7.59659, 51.636028, 0.0007998361400001845),
    (7.70191, 51.658932, 0.0011498674699997706),
    (7.74593, 51.686958, 0.004628844099999091),
    (7.92157, 51.708809, 0.004967921119997949),
    (8.03324, 51.755070, 0.0006727705950003259),
    (8.19468, 51.804260, 0.0005307743000001811),
    (8.35782, 51.849621, 0.05281267402498393),
    (8.44433, 51.859482, 0.0006462804050000689),
    (8.49079, 51.879719, 0.0005782189850000984),
    (8.5841000, 51.884579, 0.0009925159049999634),
    (8.6627700, 51.909950, 0.0038223860100000872),
    (8.7726000, 51.906609, 0.00667983440999894),
    (8.9343000, 51.956890, 0.002762111659999994),
    (9.0024100, 51.956379, 0.0012302698100002585),
    (9.0968700, 51.990940, 0.0009850244750002075),
    (9.1550200, 51.991360, 0.00463162946500384),
    (9.3353500, 52.079762, 0.00102454309500001),
    (9.3618400, 52.104111, 0.016210181225000855),
    (9.4800700, 52.106560, 0.0008511323199998173),
    (9.5323100, 52.122040, 0.003928847264999778),
    (9.6133500, 52.084469, 0.024710846605002817),
    (9.7386200, 52.124001, 0.0009839387999998684),
    (9.7681500, 52.149029, 0.007084765800000054),
    (9.8509100, 52.159939, 0.00086617153000034),
    (9.9341700, 52.153461, 0.0005665361000000064),
    (10.015680, 52.160728, 0.007558770084999596),
    (10.159670, 52.200970, 0.0006649291799999768),
    (10.330790, 52.258030, 2.6073560327749523),
    (10.514200, 52.262520, 0.001902058545000699),
    (10.669100, 52.245571, 0.004948494300001596),
    (10.790770, 52.257530, 0.0024091588200003456),
    (10.881130, 52.226810, 0.0011020893599978292),
    (10.997780, 52.229191, 0.0013778860650000852),
    (11.118510, 52.208031, 0.0006157936350002171),
    (11.352270, 52.187160, 0.000984766875000195),
    (11.436680, 52.188049, 0.18220487750999814),
    (11.521640, 52.164879, 0.005529395700000094),
    (11.622380, 52.187531, 0.0008918949599999886),
    (11.680520, 52.218311, 0.0013726619999999356),
    (11.763740, 52.229019, 0.0079287214000009),
    (12.056750, 52.232670, 0.0016880092800002455),
    (12.214300, 52.252441, 0.0012197837899998105),
    (12.343050, 52.264950, 0.0005295360450000073),
    (12.442440, 52.279900, 0.003422048374999983),
    (12.509530, 52.338360, 0.0008390861550002213),
    (12.552950, 52.351181, 0.026837878589999302),
    (12.660930, 52.335209, 0.001307028479999809),
    (12.807680, 52.337711, 0.005270944050000337),
    (12.918790, 52.290451, 0.02498763803498333),
    (12.977330, 52.303600, 0.0018784250500008376),
    (13.248490, 52.300331, 0.0016729491000007984),
    (13.279420, 52.308590, 0.0007041621900002286),
    (13.440540, 52.306080, 0.0010678526499998911),
    (13.510740, 52.319302, 0.0012690690550003036),
    (13.646030, 52.310699, 0.0012363328449999094),
    (13.824100, 52.310299, 0.0010152788399996218),
    (13.957590, 52.311550, 0.005348844410000293),
    (14.063500, 52.334190, 0.0008116855400002243),
    (14.180730, 52.343922, 0.20303513344984891),
    (14.291050, 52.324291, 0.0019266052749997023),
    (14.543540, 52.314289, 0.01409927991499738),
    (14.755990, 52.335320, 0.005373102765001079),
    (14.842560, 52.328499, 0.0008129688600002133),
    (14.955640, 52.338371, 0.001625489265000505),
    (15.062210, 52.324680, 0.0007415078349998441),
    (15.165720, 52.325298, 0.002478634384999817),
    (15.284460, 52.294231, 0.005768687434999004),
    (15.394060, 52.318531, 0.0014994112999996828),
    (15.542090, 52.323990, 0.014535860675002775),
    (15.653580, 52.299480, 0.0005582185399998018),
    (15.712540, 52.296532, 0.06615280913498117),
    (15.837110, 52.327572, 0.0013612283400006745),
    (16.130489, 52.363850, 0.005248244294000376),
    (16.448879, 52.390018, 0.08860175424850196),
    (16.535200, 52.385269, 0.0012601281000001862),
    (16.671410, 52.348579, 0.005768998621500028),
    (16.888260, 52.354610, 0.001358722025499731),
    (17.004881, 52.345322, 0.006050716657500223),
    (17.170919, 52.307411, 0.029430887288497232),
    (17.440769, 52.319050, 0.0007205185349998619),
    (17.620930, 52.326950, 0.0013525745904998316),
    (17.783670, 52.318829, 1.150875008088602),
    (17.890829, 52.282341, 0.01088199056599956),
    (17.986370, 52.313019, 0.0007916693010001785),
    (18.009010, 52.336861, 0.0006768038859996414),
    (18.130541, 52.365410, 0.0013594757285001848),
    (18.158409, 52.394329, 0.010194835151500213),
    (18.418810, 52.389400, 0.0023208751200005082),
    (18.527161, 52.386780, 0.0005453816600001758),
    (18.615891, 52.398628, 0.0006317860959999628),
    (18.681290, 52.393120, 0.003998675989999382),
    (18.762569, 52.420631, 0.0012300901194997852),
    (18.805080, 52.412800, 0.0005289674395001868),
    (18.868090, 52.426079, 0.018334857585000558),
    (19.052900, 52.404129, 0.01182622432000123),
    (19.164961, 52.405380, 0.0009709318260000118),
    (19.248480, 52.423641, 0.0005799199539998452),
    (19.305229, 52.413750, 0.0007908931205001335),
    (19.482149, 52.444271, 0.0007165993455001046),
    (19.611401, 52.465778, 0.13340130416599558),
    (19.706430, 52.546162, 0.009254246704500575),
    (19.816271, 52.573441, 0.000855054029499975),
    (19.885170, 52.606121, 0.0014355817200004946),
    (20.056530, 52.647541, 0.21623071443998879),
    (20.331970, 52.616940, 0.029833217064998682),
    (20.440701, 52.624760, 0.0013162869750000267),
    (20.493790, 52.652790, 0.0026567240250003573),
    (20.570709, 52.663910, 0.0007827753049998423),
    (20.655951, 52.655880, 0.0016156096159978728),
    (20.890230, 52.694012, 0.007938527149999652),
    (21.043341, 52.678680, 0.005578297333500103),
    (21.115641, 52.708408, 0.002397200585999842),
    (21.315540, 52.724289, 0.03672012526000031),
    (21.398420, 52.698738, 0.0024483483700000817),
    (21.633520, 52.685341, 0.6855450359339951),
    (21.859060, 52.784401, 0.0043868435999998906),
    (22.246490, 52.987999, 0.002620540360000784),
    (22.466600, 53.090141, 0.06174189788000266),
    (22.924431, 53.164379, 1.3505344985999352),
    (22.975700, 53.163528, 0.0008491012775003619),
    (23.233709, 53.126122, 0.0050751893489986806),
    (23.418150, 53.125820, 0.0017231361000003742),
    (23.506680, 53.144360, 0.006176253293999816),
    (23.643511, 53.108250, 0.0389964381259985),
    (23.796881, 53.108688, 0.001176999713999742),
    (23.871290, 53.124249, 0.0024300958499996546),
    (24.068720, 53.116779, 0.0062176423539992195),
    (24.450899, 53.153690, 0.008191595654608464),
    (24.478390, 53.142380, 0.0005606419294997695),
    (24.717630, 53.137539, 0.00233563516000034),
    (24.851120, 53.146969, 0.00970452865549962),
    (25.131519, 53.118011, 0.0023665216855005135),
    (25.251310, 53.088760, 0.006705846240499901),
    (25.417540, 53.097252, 0.0010895988389995814),
    (25.488529, 53.087769, 0.037688359720497694),
    (25.598780, 53.107700, 0.0009777281950000749),
    (25.715191, 53.146481, 0.007753966616000042),
    (25.901340, 53.139820, 0.0005876681744998979),
    (25.925850, 53.132629, 15.624207141311611),
    (26.067511, 53.181671, 0.0006953675744998947),
    (26.120001, 53.209660, 0.0025667765099997154),
    (26.330429, 53.266708, 0.015442059139498357),
    (26.599449, 53.402821, 0.00306352640349959),
    (26.761070, 53.507370, 0.014732591120000332),
    (26.813770, 53.512680, 0.0006814578999998298),
    (26.966890, 53.553970, 0.05847813158500108),
    (27.039070, 53.589420, 0.0018875338250001297),
    (27.089849, 53.666660, 0.007829284025000079),
    (27.303511, 53.735130, 0.005011199784500702),
    (27.391319, 53.803421, 0.0005928050575001501),
    (27.432171, 53.817829, 0.0006160187779998591),
    (27.494040, 53.869808, 0.0016981824205002005),
    (27.585680, 53.916759, 0.9355083148300166),
    (27.719620, 53.955311, 0.0009746368959998464),
    (27.854549, 54.008701, 0.009018125029501734),
    (27.997959, 54.030449, 0.0017747047010011285),
    (28.337090, 54.106628, 0.011066727375504988),
    (28.481810, 54.202950, 0.0005153089800003474),
    (28.512350, 54.237518, 0.0007449054899999776),
    (28.571150, 54.255291, 0.027840016371499444),
    (28.770069, 54.277180, 0.0006223182559984489),
    (29.036091, 54.312710, 0.04917403952351433),
    (29.166031, 54.364811, 0.003102402454000118),
    (29.304399, 54.372540, 0.0010403242859962842),
    (29.807631, 54.477001, 0.005650901765488488),
    (29.896370, 54.473911, 0.0017798839699999177),
    (30.119080, 54.506271, 0.013423775744500646),
    (30.195641, 54.542679, 0.0009894983555001128),
    (30.275570, 54.554840, 0.0018340367199999046),
    (30.409130, 54.619732, 0.10448855816644895),
    (30.591089, 54.642479, 0.001543720579999872),
    (30.780769, 54.683159, 0.009890022788000625),
    (31.064070, 54.689949, 0.007023433094500995),
    (31.201559, 54.703480, 0.0012718874155001928),
    (31.372890, 54.738861, 0.0010077760915000265),
    (31.481560, 54.749538, 0.08998507272699677),
    (31.637960, 54.814232, 0.0011683243500004794),
    (31.673710, 54.843960, 0.01575373942200063),
    (32.004681, 54.865780, 0.0029648347299996514),
    (32.101212, 54.890060, 0.02520276334899922),
    (32.147099, 54.925900, 0.0006533915870000944),
    (32.299351, 55.016338, 2.5306121627785108),
    (32.504452, 55.056099, 0.0014501986585007901),
    (32.597309, 55.059959, 0.0024946020060057374),
    (32.674419, 55.078171, 0.000604723479999913),
    (33.195610, 55.132179, 0.000745868490499901),
    (33.346119, 55.152840, 0.007396271786001787),
    (33.471249, 55.183289, 0.04676558635650117),
    (33.647659, 55.179359, 0.002276000220000347),
    (33.897350, 55.199600, 0.0039050867449983546),
    (34.061390, 55.187550, 0.06661104649048372),
    (34.237122, 55.222080, 0.0033569191450003952),
    (34.389042, 55.265400, 0.000708731580000381),
    (34.562809, 55.324280, 0.0073479436810012224),
    (34.946049, 55.486511, 0.010486538965999144),
    (35.120701, 55.505718, 0.17555820487549917),
    (35.398941, 55.491329, 0.002017215894500156),
    (35.519581, 55.470581, 0.0007216633059995171),
    (35.618980, 55.465450, 0.007075233160503159),
    (35.913269, 55.465580, 0.0011515429755005692),
    (36.064789, 55.457821, 0.27428072454153984),
    (36.175480, 55.494419, 0.002097421690499958),
    (36.455029, 55.548950, 0.01867971054849846),
    (37.198662, 55.626869, 0.0554204532515025),
    (37.297470, 55.657600, 0.0015273776339998135),
    (37.366482, 55.709980, 0.002582013140000326),
    (37.537930, 55.737560, 0.003194690800000177),
    (37.569962, 55.779980, 0))]

# <https://GeographicLib.SourceForge.io/html/python/examples.html>
_JFK_LHR1 = [LatLon_(_lat, _lon) for _lat, _lon in (
    ( 0,   73.8),  # equator
    (40.6, 73.8),  # JFK
    (51.6,  0.5),  # LHR
    ( 0,    0.5))]

_JFK_LHR2 = [LatLon_(_lat, _lon) for _lat, _lon in (
    (-40.6, 73.8),  # double the area
    ( 40.6, 73.8),  # JFK
    ( 51.6,  0.5),  # LHR
    (-51.6,  0.5))]

# del _lat, _lon


def _2LL(pts, LL):
    # map LatLon_ instances to LL
    for p in pts:
        yield LL(p.lat, p.lon)


class Tests(TestsBase):

    def test7(self, f, xs, fmt='%.3f', skip=False, LL=None, known=False, **kwds):
        n = f.__name__
        if n.endswith('Of'):
            n = '.'.join(f.__module__.split('.')[-1:] + [n])

        g = globals()
        for x, p in zip(xs, ('Antarctica',
                             'PtsFFI', 'RdpFFI', 'Pts', 'VwPts',
                             '_JFK_LHR1', '_JFK_LHR2')):
            t   = unstr(n, p, wrap=True, **kwds)
            pts = g[p]
            if skip and len(pts) > 1024:
                r = e = 0
            else:
                if LL:
                    pts = _2LL(pts, LL)
                # wrap since GeographicLib LONG_UNROLL is always set
                r = f(pts, wrap=True, **kwds)
                e = abs((r - x) / x) if x else 0
            self.test(t, r, x, fmt=fmt, known=known or (e < 4e-4))

    def testAreas(self):
        self.test7(areaOf, (13552524.8,
                   1.288, 1.241, 131184.240, 140310.144,
                   4.00413688487425e7, 2*4.00413688487425e7),
                   known=True, radius=R_KM, adjust=True)
        self.test7(areaOf, (13552524.8,
                   1.288, 1.241, 131184.240, 140310.144,
                   4.00413688487425e7, 2*4.00413688487425e7),
                   known=True, radius=R_KM, adjust=False)
        # spherical areaOf requires spherical LatLon
        self.test7(sphericalTrigonometry.areaOf, (241480413.388,  # 13552524.8096748
                   1.338, 1.289, 125942.444, 118897.757,
                   40105639.197, 80211278.393),  # 2*40105639.197 == .394
                   LL=sphericalTrigonometry.LatLon, radius=R_KM)
        try:  # no LatLon restrictions for ellipsoidal areaOf
            # XXX keep ellipsoidalVincenty for backward compatibility
            self.test7(ellipsoidalVincenty.areaOf, (1.366270e+13,  # 13662703680020.1
                       1.343272e+06, 1.294375e+06, 1.271286e+11, 1.200540e+11,
                       4.00413688487425e13, 2*4.00413688487425e13),
                       fmt='%.6e', skip=Geodesic is None)
            self.test7(ellipsoidalVincenty.areaOf, (1.366270e+13,  # 13662703680020.1
                       1.343272e+06, 1.294375e+06, 1.271286e+11, 1.200540e+11,
                       4.00413688487425e13, 2*4.00413688487425e13),
                       fmt='%.6e', LL=ellipsoidalVincenty.LatLon, skip=Geodesic is None)
        except (DeprecationWarning, ImportError) as x:
            t = ' '.join(str(x).split())
            # XXX keep ellipsoidalVincenty for backward compatibility
            self.test('ellipsoidalVincenty.areaOf', t, 'DEPRECATED', known=True)

    def testClockwise(self):
        self.test7(isclockwise, (True,  # XXX False if ispolar is True?
                   True, True, True, True,
                   False, False),
                   adjust=False)

    def testPerimeters(self):
        self.test7(perimeterOf, (16765661.499,
                   3224.123, 3185.467, 2762313.129, 2672557.850,
                   15766750.804, 25981742.208),
                   known=True, radius=R_M, closed=False)
        # spherical perimeterOf requires spherical LatLon
        self.test7(sphericalTrigonometry.perimeterOf, (15470624.834,  # 16765661.499 closed
                   3224.123, 3185.467, 2762313.116, 2672556.441,
                   15789078.314, 26041264.665),  # 15766750.804, 25981742.208
                   LL=sphericalTrigonometry.LatLon, radius=R_M, closed=False)
        try:  # no LatLon restrictions for ellipsoidal perimeterOf
            # XXX keep ellipsoidalVincenty for backward compatibility
            self.test7(ellipsoidalVincenty.perimeterOf, (15531770.613,
                       3229.337, 3190.602, 2769709.412, 2679915.858,
                       15763434.962, 25972353.155),  # assumed
                       LL=ellipsoidalVincenty.LatLon, closed=False, skip=Geodesic is None)
            self.test7(ellipsoidalVincenty.perimeterOf, (16830891.356,
                       5491.045, 5452.310, 5259077.242, 5171947.931,
                       23921931.540, 31524112.555), closed=True, skip=Geodesic is None)  # assumed
        except (DeprecationWarning, ImportError) as x:
            t = ' '.join(str(x).split())
            # XXX keep ellipsoidalVincenty for backward compatibility
            self.test('ellipsoidalVincenty.perimeterOf', t, 'DEPRECATED', known=True)

    def testGeodesic(self):
        # <https://GeographicLib.SourceForge.io/html/python/examples.html>
        def _s(n, m='(Sphere)'):
            return 'geographiclib.' + n + m

        def _w(n, m='(WGS84)'):
            return 'geographiclib.' + n + m

        if Geodesic:
            wgs = Geodesic.WGS84
            sph = Geodesic(R_M, 0)

            w = wgs.Inverse(-41.32, 174.81, 40.96, -5.50, outmask=Geodesic.DISTANCE | Geodesic.LONG_UNROLL)
            self.test(_w('WNZ-SAL'), w['s12'], 19959679.267, fmt='%.3f')
            self.test(_w('WNZ-SAL'), w['lon2'], 354.50, fmt='%.2f')
            s = sph.Inverse(-41.32, 174.81, 40.96, -5.50, outmask=Geodesic.DISTANCE | Geodesic.LONG_UNROLL)
            self.test(_s('WNZ-SAL'), s['s12'], 19967403.498, fmt='%.3f')
            self.test(_s('WNZ-SAL'), s['lon2'], 354.50, fmt='%.2f')

            w = wgs.Inverse(40.1, 116.6, 37.6, -122.4, outmask=Geodesic.DISTANCE | Geodesic.LONG_UNROLL)
            self.test(_w('BJS-SFO'), w['s12'], 9513998.0, fmt='%.1f')
            self.test(_w('BJS-SFO'), w['lon2'], 237.6, fmt='%.1f')
            s = sph.Inverse(40.1, 116.6, 37.6, -122.4, outmask=Geodesic.DISTANCE | Geodesic.LONG_UNROLL)
            self.test(_s('BJS-SFO'), s['s12'], 9491734.6, fmt='%.1f')
            self.test(_s('BJS-SFO'), s['lon2'], 237.6, fmt='%.1f')

            w = wgs.Direct(-32.06, 115.74, 225, 20000e3)
            self.test(_w('SW-Perth'), w['lat2'],  32.11195529, fmt='%.8f')
            self.test(_w('SW-Perth'), w['lon2'], -63.95925278, fmt='%.8f')
            s = sph.Direct(-32.06, 115.74, 225, 20000e3)
            self.test(_s('SW-Perth'), s['lat2'],  31.96383509, fmt='%.8f')
            self.test(_s('SW-Perth'), s['lon2'], -64.14670854, fmt='%.8f')

            w = wgs.Inverse(40.6, -73.8, 51.6, -0.5, outmask=Geodesic.DISTANCE | Geodesic.AREA | Geodesic.LONG_UNROLL)
            self.test(_w('JFK-LHR'), w['S12'], 40041368848742.5, fmt='%.1f')
            self.test(_w('JFK-LHR'), w['s12'], 5551759.4, fmt='%.1f')
            s = sph.Inverse(40.6, -73.8, 51.6, -0.5, outmask=Geodesic.DISTANCE | Geodesic.AREA | Geodesic.LONG_UNROLL)
            self.test(_s('JFK-LHR'), s['S12'], 40105639196534.8, fmt='%.1f')
            self.test(_s('JFK-LHR'), s['s12'], 5536892.0, fmt='%.1f')

            p = wgs.Polygon()
            for ll in Antarctica:
                p.AddPoint(ll.lat, ll.lon)
            _, p, a = p.Compute()
            self.test(_w('Antarctica Peri'), p, 16831067.893, fmt='%.3f')
            self.test(_w('Antarctica Area'), a, 13662703680020.1, fmt='%.1f')

            p = sph.Polygon()
            for ll in Antarctica:
                p.AddPoint(ll.lat, ll.lon)
            _, p, a = p.Compute()
            self.test(_s('Antarctica Peri'), p, 16765661.499, fmt='%.3f')
            self.test(_s('Antarctica Area'), a, 13552524809674.8, fmt='%.1f')

        else:
            self.test('no module', _s('Geodesic', ''), _s('Geodesic', ''))


if __name__ == '__main__':

    t = Tests(__file__, __version__)
    t.testAreas()
    t.testPerimeters()
    t.testGeodesic()
    t.testClockwise()
    t.results()
    t.exit()
