(function() {
  require(["common/base", "../test/common/test_parent"], function(base, test_parent) {
    var Collections, testparents;
    Collections = base.Collections;
    testparents = test_parent.Collection;
    base.locations['TestParent'] = "../test/common/test_parent";
    base.mod_cache["../test/common/test_parent"] = test_parent;
    test('parent_settings_propagate', function() {
      var child, child_test_prop, parent, parent_ref, parent_test_prop;
      testparents.reset();
      parent = Collections('TestParent').create({
        id: 'parent',
        testprop: 'aassddff'
      });
      parent_ref = parent.ref();
      child = Collections('TestParent').create({
        id: 'first',
        'parent': parent_ref
      });
      child_test_prop = child.get('testprop');
      parent_test_prop = parent.get('testprop');
      return ok(child_test_prop === parent_test_prop);
    });
    return test('display_defaults_propagate', function() {
      var child, parent;
      testparents.reset();
      parent = Collections('TestParent').create({
        id: 'parent'
      });
      child = Collections('TestParent').create({
        id: 'first',
        'parent': parent.ref()
      });
      return ok(child.get('testprop') === parent.get('testprop'));
    });
  });

}).call(this);

/*
//@ sourceMappingURL=has_parent_test.js.map
*/