/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.recman.BlockIo;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;

final class FreePhysicalRowIdPageManager {
    protected RecordFile _file;
    protected PageManager _pageman;
    private int blockSize;
    final ArrayList<Long> freeBlocksInTransactionRowid = new ArrayList();
    final ArrayList<Integer> freeBlocksInTransactionSize = new ArrayList();

    FreePhysicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this._file = file;
        this._pageman = pageman;
        this.blockSize = file.BLOCK_SIZE;
    }

    long get(int size) throws IOException {
        long retval = 0L;
        PageCursor curs = new PageCursor(this._pageman, 4);
        while (curs.next() != 0L) {
            FreePhysicalRowIdPage fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(this._file.get(curs.getCurrent()), this.blockSize);
            int slot = fp.getFirstLargerThan(size);
            if (slot != -1) {
                retval = fp.slotToLocation(slot);
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this._file.release(curs.getCurrent(), false);
                    this._pageman.free((short)4, curs.getCurrent());
                } else {
                    this._file.release(curs.getCurrent(), true);
                }
                return retval;
            }
            this._file.release(curs.getCurrent(), false);
        }
        return 0L;
    }

    void put(long rowid, int size) throws IOException {
        this.freeBlocksInTransactionRowid.add(rowid);
        this.freeBlocksInTransactionSize.add(size);
    }

    public void commit() throws IOException {
        short freePhysRowId;
        int size;
        long rowid;
        int slot;
        FreePhysicalRowIdPage fp;
        BlockIo curBlock;
        long freePage;
        Iterator<Long> rowidIter = this.freeBlocksInTransactionRowid.iterator();
        Iterator<Integer> sizeIter = this.freeBlocksInTransactionSize.iterator();
        PageCursor curs = new PageCursor(this._pageman, 4);
        while (curs.next() != 0L) {
            freePage = curs.getCurrent();
            curBlock = this._file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock, this.blockSize);
            slot = fp.getFirstFree();
            while (slot != -1 && rowidIter.hasNext()) {
                rowid = rowidIter.next();
                size = sizeIter.next();
                freePhysRowId = fp.alloc(slot);
                fp.setLocationBlock(freePhysRowId, Location.getBlock(rowid));
                fp.setLocationOffset(freePhysRowId, Location.getOffset(rowid));
                fp.FreePhysicalRowId_setSize(freePhysRowId, size);
                slot = fp.getFirstFree();
            }
            this._file.release(freePage, true);
            if (rowidIter.hasNext()) continue;
            break;
        }
        while (rowidIter.hasNext()) {
            freePage = this._pageman.allocate((short)4);
            curBlock = this._file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock, this.blockSize);
            slot = fp.getFirstFree();
            while (slot != -1 && rowidIter.hasNext()) {
                rowid = rowidIter.next();
                size = sizeIter.next();
                freePhysRowId = fp.alloc(slot);
                fp.setLocationBlock(freePhysRowId, Location.getBlock(rowid));
                fp.setLocationOffset(freePhysRowId, Location.getOffset(rowid));
                fp.FreePhysicalRowId_setSize(freePhysRowId, size);
                slot = fp.getFirstFree();
            }
            this._file.release(freePage, true);
            if (rowidIter.hasNext()) continue;
            break;
        }
        if (rowidIter.hasNext()) {
            throw new InternalError();
        }
        this.freeBlocksInTransactionRowid.clear();
        this.freeBlocksInTransactionSize.clear();
    }
}

