/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelValidator
implements Validator<String> {
    ExpressionParser parser = new SpelExpressionParser();
    Expression spelExpression;

    public SpelValidator(String spelExpression) {
        this.spelExpression = this.parser.parseExpression(spelExpression);
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        try {
            context.getSpELContext().setVariable("value", (Object)parameterValue);
            context.getSpELContext().registerFunction("t", ModelValidatorContext.SpELVariables.class.getDeclaredMethod("t", Object.class));
            context.getSpELContext().registerFunction("f", ModelValidatorContext.SpELVariables.class.getDeclaredMethod("f", Object.class));
            context.getSpELContext().registerFunction("s", ModelValidatorContext.SpELVariables.class.getDeclaredMethod("s", Object.class));
            Object untypedResult = this.spelExpression.getValue((EvaluationContext)context.getSpELContext());
            Boolean validVariable = null;
            if (context.getSpELVariables() != null) {
                validVariable = context.getSpELVariables().getValid();
            }
            if (!(untypedResult instanceof Boolean) && validVariable == null) {
                throw new ValidationException("'valid' variable has not been set and SPEL expression did not return a boolean value.");
            }
            boolean evaluationResult = validVariable != null ? validVariable.booleanValue() : ((Boolean)untypedResult).booleanValue();
            if (!evaluationResult) {
                throw new ValidationException("SPEL expression returned false, received " + parameterValue);
            }
        }
        catch (EvaluationException e) {
            throw new ValidationException("SPEL expression raised an error: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ValidationException("Unexpected error: " + e.getMessage(), e);
        }
        return parameterValue;
    }
}

