/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class PasswordField {
    public static final char[] getPassword(InputStream in, String promt) throws IOException {
        PushbackInputStream pbIn = null;
        pbIn = pbIn instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        return PasswordField.getPassword(pbIn, promt);
    }

    public static final char[] getPassword(PushbackInputStream in, String prompt) throws IOException {
        MaskingThread maskingthread = new MaskingThread(prompt);
        maskingthread.start();
        char[] buf = new char[64];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    in.unread(c2);
                }
                default: {
                    if (--room < 0) {
                        char[] tmp = new char[offset + 64];
                        room = tmp.length - offset - 1;
                        System.arraycopy(buf, 0, tmp, 0, offset);
                        Arrays.fill(buf, ' ');
                        buf = tmp;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.terminate();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private static class MaskingThread
    extends Thread {
        private AtomicBoolean cont = new AtomicBoolean(true);

        public MaskingThread(String prompt) {
            System.out.print(prompt + " ");
        }

        @Override
        public void run() {
            int oldPrio = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                while (this.cont.get()) {
                    System.out.print("\b ");
                    Thread.yield();
                }
            }
            finally {
                Thread.currentThread().setPriority(oldPrio);
            }
        }

        public void terminate() {
            this.cont.set(false);
        }
    }
}

