/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive_grid_cloud_portal.common.FileType;

public class RemoteSource
implements IDataSpaceClient.IRemoteSource {
    private IDataSpaceClient.Dataspace dataspace;
    private String path;
    private List<String> includes;
    private List<String> excludes;
    private FileType pathType = FileType.UNKNOWN;

    public RemoteSource() {
    }

    public RemoteSource(IDataSpaceClient.Dataspace dataspace) {
        this.dataspace = dataspace;
    }

    public RemoteSource(IDataSpaceClient.Dataspace dataspace, String pathname) {
        this.dataspace = dataspace;
        this.path = pathname;
    }

    @Override
    public IDataSpaceClient.Dataspace getDataspace() {
        return this.dataspace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setIncludes(List<String> includes) {
        Preconditions.checkNotNull(includes);
        this.includes = Lists.newArrayList(includes);
    }

    public void setIncludes(String ... includes) {
        Preconditions.checkNotNull((Object)includes);
        this.includes = Lists.newArrayList((Object[])includes);
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    public void setExcludes(List<String> excludes) {
        Preconditions.checkNotNull(excludes);
        this.excludes = Lists.newArrayList(excludes);
    }

    public void setExcludes(String ... excludes) {
        Preconditions.checkNotNull((Object)excludes);
        this.excludes = Lists.newArrayList((Object[])excludes);
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public FileType getType() {
        return this.pathType;
    }

    public void setType(FileType pathType) {
        this.pathType = pathType;
    }

    public String toString() {
        return "RemoteSource{dataspace=" + (Object)((Object)this.dataspace) + ", path='" + this.path + '\'' + ", includes=" + this.includes + ", excludes=" + this.excludes + ", pathType=" + this.pathType + '}';
    }
}

