/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.MethodHashing;

public class PropertyInjectorImpl
implements PropertyInjector {
    protected HashMap<Field, ValueInjector> fieldMap = new HashMap();
    protected List<SetterMethod> setters = new ArrayList<SetterMethod>();
    protected HashMap<Long, Method> setterhashes = new HashMap();
    protected Class<?> clazz;

    public PropertyInjectorImpl(Class<?> clazz, ResteasyProviderFactory factory) {
        this.clazz = clazz;
        this.populateMap(clazz, factory);
    }

    protected void populateMap(Class<?> clazz, ResteasyProviderFactory factory) {
        Type genericType;
        Class<?> type;
        ValueInjector extractor;
        Annotation[] annotations;
        for (Field field : this.getDeclaredFields(clazz)) {
            annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0 || (extractor = this.getParameterExtractor(clazz, factory, field, annotations, type = field.getType(), genericType = field.getGenericType())) == null) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                this.setAccessible(field);
            }
            this.fieldMap.put(field, extractor);
        }
        for (AccessibleObject accessibleObject : this.getDeclaredMethods(clazz)) {
            Method older;
            if (!((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1 || (annotations = accessibleObject.getAnnotations()) == null || annotations.length == 0 || (extractor = this.getParameterExtractor(clazz, factory, accessibleObject, annotations, type = ((Method)accessibleObject).getParameterTypes()[0], genericType = ((Method)accessibleObject).getGenericParameterTypes()[0])) == null) continue;
            long hash = 0L;
            try {
                hash = MethodHashing.methodHash((Method)accessibleObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(((Method)accessibleObject).getModifiers()) && (older = this.setterhashes.get(hash)) != null) continue;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) {
                this.setAccessible(accessibleObject);
            }
            this.setters.add(new SetterMethod((Method)accessibleObject, extractor));
            this.setterhashes.put(hash, (Method)accessibleObject);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.populateMap(clazz.getSuperclass(), factory);
        }
    }

    private ValueInjector getParameterExtractor(Class<?> clazz, ResteasyProviderFactory factory, AccessibleObject accessibleObject, Annotation[] annotations, Class<?> type, Type genericType) {
        boolean extractBody = FindAnnotation.findAnnotation(annotations, Body.class) != null;
        ValueInjector injector = factory.getInjectorFactory().createParameterExtractor(clazz, accessibleObject, type, genericType, annotations, extractBody, factory);
        return injector;
    }

    @Override
    public void inject(HttpRequest request, HttpResponse response, Object target) throws Failure {
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            try {
                entry.getKey().set(target, entry.getValue().inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
        }
        for (SetterMethod setter : this.setters) {
            try {
                setter.method.invoke(target, setter.extractor.inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
    }

    @Override
    public void inject(Object target) {
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            try {
                entry.getKey().set(target, entry.getValue().inject());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        for (SetterMethod setter : this.setters) {
            try {
                setter.method.invoke(target, setter.extractor.inject());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Field[] getDeclaredFields(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return clazz.getDeclaredFields();
                }
            });
        }
        return clazz.getDeclaredFields();
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        return clazz.getDeclaredMethods();
    }

    private void setAccessible(final AccessibleObject member) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    member.setAccessible(true);
                    return null;
                }
            });
        } else {
            member.setAccessible(true);
        }
    }

    private static class SetterMethod {
        public Method method;
        public ValueInjector extractor;

        private SetterMethod(Method method, ValueInjector extractor) {
            this.method = method;
            this.extractor = extractor;
        }
    }
}

