/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.frontend;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.frontend.ConfigurableFieldData;
import org.ow2.proactive.resourcemanager.nodesource.common.PluginDescriptor;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="pluginDescriptor")
public class PluginDescriptorData
implements Serializable {
    private String pluginName;
    private String pluginDescription;
    private Collection<ConfigurableFieldData> configurableFields = new LinkedList<ConfigurableFieldData>();
    private Map<String, String> defaultValues;
    private Map<Integer, String> sectionDescriptions = new HashMap<Integer, String>();
    private Map<String, String> meta = new HashMap<String, String>();
    private static final long serialVersionUID = 130L;

    public PluginDescriptorData() {
    }

    public PluginDescriptorData(PluginDescriptor pluginDescriptor) {
        this.defaultValues = pluginDescriptor.getDefaultValues();
        this.meta = pluginDescriptor.getMeta();
        this.pluginDescription = pluginDescriptor.getPluginDescription();
        this.pluginName = pluginDescriptor.getPluginName();
        this.sectionDescriptions = pluginDescriptor.getSectionDescriptions();
        this.configurableFields = pluginDescriptor.getConfigurableFields().stream().map(ConfigurableFieldData::new).collect(Collectors.toList());
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginDescription() {
        return this.pluginDescription;
    }

    public void setPluginDescription(String pluginDescription) {
        this.pluginDescription = pluginDescription;
    }

    public Collection<ConfigurableFieldData> getConfigurableFields() {
        return this.configurableFields;
    }

    public void setConfigurableFields(Collection<ConfigurableFieldData> configurableFields) {
        this.configurableFields = configurableFields;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Map<String, String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public Map<Integer, String> getSectionDescriptions() {
        return this.sectionDescriptions;
    }

    public void setSectionDescriptions(Map<Integer, String> sectionDescriptions) {
        this.sectionDescriptions = sectionDescriptions;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }
}

