/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.utils.FileUtils;

@PublicAPI
public class ZipUtils
extends FileUtils {
    private static final Logger logger = Logger.getLogger(ZipUtils.class);
    protected static final int COMP_LEVEL = 9;

    public static void zip(String[] directoriesAndFiles, File dest, CRC32 crc) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            ZipUtils.zipDirectoriesAndFiles(zos, directoriesAndFiles, crc);
        }
    }

    public static void zipDirectoriesAndFiles(ZipOutputStream zos, String[] directoriesAndFiles, CRC32 crc) throws IOException {
        zos.setLevel(9);
        ZipUtils.zipIt(zos, directoriesAndFiles, crc);
        zos.flush();
    }

    protected static void zipIt(ZipOutputStream zos, String[] directoriesAndFiles, CRC32 crc) throws IOException {
        for (String pathElement : directoriesAndFiles) {
            File fileElement = new File(pathElement);
            pathElement = fileElement.getPath();
            int length = pathElement.lastIndexOf(File.separator) + 1;
            if (fileElement.isFile()) {
                ZipUtils.zipFile(pathElement, length, zos, crc);
                continue;
            }
            if (!fileElement.isDirectory()) continue;
            ZipUtils.zipDirectory(pathElement, length, zos, crc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void zipDirectory(String directoryName, int iBaseFolderLength, ZipOutputStream zos, CRC32 crc) throws IOException {
        File dirobject = new File(directoryName);
        if (!dirobject.exists()) throw new IOException("Directory " + directoryName + " does not exist.");
        if (!dirobject.isDirectory()) throw new IOException(directoryName + " is not a directory.");
        File[] fileList = dirobject.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    ZipUtils.zipDirectory(fileList[i].getPath(), iBaseFolderLength, zos, crc);
                    continue;
                }
                if (!fileList[i].isFile()) continue;
                ZipUtils.zipFile(fileList[i].getPath(), iBaseFolderLength, zos, crc);
            }
            return;
        } else {
            logger.warn((Object)("Problem accessing folder: " + dirobject));
        }
    }

    protected static void zipFile(String filePath, int iBaseFolderLength, ZipOutputStream jos, CRC32 crc) throws IOException {
        try (BufferedInputStream bis2 = new BufferedInputStream(new FileInputStream(filePath));){
            int byteCount;
            String fileNameEntry = filePath.substring(iBaseFolderLength).replace(File.separatorChar, '/');
            ZipEntry fileEntry = new ZipEntry(fileNameEntry);
            jos.putNextEntry(fileEntry);
            byte[] data = new byte[1024];
            while ((byteCount = bis2.read(data, 0, 1024)) > -1) {
                if (crc != null) {
                    crc.update(data);
                }
                jos.write(data, 0, byteCount);
            }
            jos.closeEntry();
        }
        catch (ZipException bis2) {
        }
        catch (IOException e) {
            logger.error((Object)("Error occurred while trying to zip file " + filePath), (Throwable)e);
            throw e;
        }
    }

    public static void unzip(ZipFile zipFile, File dest) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        if (dest.exists() && dest.isDirectory()) {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File destFile = new File(dest, entry.getName());
                ZipUtils.createFileWithPath(destFile);
                BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(entry));
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));){
                    int nBytes;
                    byte[] buffer = new byte[2048];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, nBytes);
                    }
                    ((OutputStream)out).flush();
                }
                ((InputStream)in).close();
            }
        } else {
            throw new IOException("Destination " + dest.getAbsolutePath() + " is not a directory or does not exist");
        }
    }

    protected static void createFileWithPath(File f) throws IOException {
        String absPath = f.getAbsolutePath();
        StringTokenizer parser = new StringTokenizer(absPath, File.separator);
        StringBuffer globalPath = new StringBuffer(File.separator);
        while (parser.countTokens() > 1) {
            File currentDir = new File((globalPath = globalPath.append(parser.nextToken() + File.separator)).toString());
            if (currentDir.exists() || currentDir.mkdir()) continue;
            throw new IOException("Cannot create directory " + currentDir.getAbsolutePath());
        }
        if (!f.createNewFile()) {
            throw new IOException("Cannot create file " + f.getAbsolutePath());
        }
    }
}

