/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ConversionException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public abstract class BaseParserValidator<T>
implements ParserValidator<T> {
    protected static final String LEFT_PARAM_DELIMITER = "(";
    protected static final String RIGHT_PARAM_DELIMITER = ")";
    protected static final String PARAMETER_REGEXP = "\\(([^)]*)\\)";
    protected String model;
    protected ModelType type;
    protected String typeRegexp;

    protected BaseParserValidator(String model, ModelType type) throws ModelSyntaxException {
        this(model, type, "^" + BaseParserValidator.ignoreCaseRegexp(type.name()) + "$");
    }

    protected BaseParserValidator(String model, ModelType type, String typeRegexp) throws ModelSyntaxException {
        if (Strings.isNullOrEmpty((String)model)) {
            throw new ModelSyntaxException("Model cannot be empty");
        }
        this.model = model.trim();
        this.type = type;
        this.typeRegexp = typeRegexp;
        if (!model.matches(typeRegexp)) {
            throw new ModelSyntaxException(String.format("Model expression %s doesn't match the expected pattern: %s", model, typeRegexp));
        }
    }

    protected Class<?> getClassType() {
        return this.type.getClassType();
    }

    protected abstract Converter<T> createConverter(String var1) throws ModelSyntaxException;

    protected abstract Validator<T> createValidator(String var1, Converter<T> var2) throws ModelSyntaxException;

    protected String parseAndGetOneGroup(String valueToParse, String regexp) throws ModelSyntaxException {
        List<String> groups = BaseParserValidator.parseAndGetRegexGroups(valueToParse, regexp);
        if (groups.size() != 1) {
            throw new ModelSyntaxException("Illegal " + (Object)((Object)this.type) + " expression in '" + valueToParse + "', model does not match regexp " + regexp);
        }
        return groups.get(0);
    }

    protected static List<String> parseAndGetRegexGroups(String valueToParse, String regexp) throws ModelSyntaxException {
        try {
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(valueToParse);
            if (matcher.find()) {
                return BaseParserValidator.getMatchedGroups(matcher, matcher.groupCount());
            }
            throw new ModelSyntaxException("Expression '" + valueToParse + "' does not match " + regexp);
        }
        catch (PatternSyntaxException e) {
            throw new ModelSyntaxException("Internal error, regular expression '" + regexp + "' is invalid: " + e.getMessage(), e);
        }
    }

    private static List<String> getMatchedGroups(Matcher matcher, int numberOfGroupsFound) {
        LinkedList<String> groupsFound = new LinkedList<String>();
        for (int i = 0; i < numberOfGroupsFound; ++i) {
            String groupMatched = matcher.group(i + 1);
            if (groupMatched == null) continue;
            groupsFound.add(groupMatched);
        }
        return groupsFound;
    }

    @Override
    public T parseAndValidate(String parameterValue) throws ConversionException, ValidationException, ModelSyntaxException {
        return this.parseAndValidate(parameterValue, null, false);
    }

    @Override
    public T parseAndValidate(String parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ConversionException, ValidationException, ModelSyntaxException {
        Converter<T> converter = this.createConverter(this.model);
        return this.createValidator(this.model, converter).validate(converter.convert(parameterValue), context, isVariableHidden);
    }

    public static String ignoreCaseRegexp(String matcher) {
        return String.format("(?i:%s)", matcher);
    }
}

