# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AadAuthenticationParameters(msrest.serialization.Model):
    """AAD Vpn authentication type related parameters.

    :param aad_tenant: AAD Vpn authentication parameter AAD tenant.
    :type aad_tenant: str
    :param aad_audience: AAD Vpn authentication parameter AAD audience.
    :type aad_audience: str
    :param aad_issuer: AAD Vpn authentication parameter AAD issuer.
    :type aad_issuer: str
    """

    _attribute_map = {
        'aad_tenant': {'key': 'aadTenant', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
        'aad_issuer': {'key': 'aadIssuer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AadAuthenticationParameters, self).__init__(**kwargs)
        self.aad_tenant = kwargs.get('aad_tenant', None)
        self.aad_audience = kwargs.get('aad_audience', None)
        self.aad_issuer = kwargs.get('aad_issuer', None)


class AddressSpace(msrest.serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = kwargs.get('address_prefixes', None)


class Resource(msrest.serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :param identity: The identity of the application gateway, if configured.
    :type identity: ~azure.mgmt.network.v2020_03_01.models.ManagedServiceIdentity
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySku
    :param ssl_policy: SSL policy of the application gateway resource.
    :type ssl_policy: ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Possible values
     include: "Stopped", "Starting", "Running", "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Subnets of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayIPConfiguration]
    :param authentication_certificates: Authentication certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type authentication_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayAuthenticationCertificate]
    :param trusted_root_certificates: Trusted Root certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type trusted_root_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayTrustedRootCertificate]
    :param ssl_certificates: SSL certificates of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type ssl_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type frontend_ports:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type http_listeners:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type url_path_maps: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRequestRoutingRule]
    :param rewrite_rule_sets: Rewrite rules for the application gateway resource.
    :type rewrite_rule_sets:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRewriteRuleSet]
    :param redirect_configurations: Redirect configurations of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :type redirect_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRedirectConfiguration]
    :param web_application_firewall_configuration: Web application firewall configuration.
    :type web_application_firewall_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :param firewall_policy: Reference to the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param enable_http2: Whether HTTP2 is enabled on the application gateway resource.
    :type enable_http2: bool
    :param enable_fips: Whether FIPS is enabled on the application gateway resource.
    :type enable_fips: bool
    :param autoscale_configuration: Autoscale Configuration.
    :type autoscale_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayAutoscaleConfiguration
    :ivar resource_guid: The resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application gateway resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param custom_error_configurations: Custom error configurations of the application gateway
     resource.
    :type custom_error_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayCustomError]
    :param force_firewall_policy_association: If true, associates a firewall policy with an
     application gateway regardless whether the policy differs from the WAF Config.
    :type force_firewall_policy_association: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'operational_state': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'ssl_policy': {'key': 'properties.sslPolicy', 'type': 'ApplicationGatewaySslPolicy'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[ApplicationGatewayAuthenticationCertificate]'},
        'trusted_root_certificates': {'key': 'properties.trustedRootCertificates', 'type': '[ApplicationGatewayTrustedRootCertificate]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'rewrite_rule_sets': {'key': 'properties.rewriteRuleSets', 'type': '[ApplicationGatewayRewriteRuleSet]'},
        'redirect_configurations': {'key': 'properties.redirectConfigurations', 'type': '[ApplicationGatewayRedirectConfiguration]'},
        'web_application_firewall_configuration': {'key': 'properties.webApplicationFirewallConfiguration', 'type': 'ApplicationGatewayWebApplicationFirewallConfiguration'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'enable_http2': {'key': 'properties.enableHttp2', 'type': 'bool'},
        'enable_fips': {'key': 'properties.enableFips', 'type': 'bool'},
        'autoscale_configuration': {'key': 'properties.autoscaleConfiguration', 'type': 'ApplicationGatewayAutoscaleConfiguration'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'custom_error_configurations': {'key': 'properties.customErrorConfigurations', 'type': '[ApplicationGatewayCustomError]'},
        'force_firewall_policy_association': {'key': 'properties.forceFirewallPolicyAssociation', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGateway, self).__init__(**kwargs)
        self.etag = None
        self.zones = kwargs.get('zones', None)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.ssl_policy = kwargs.get('ssl_policy', None)
        self.operational_state = None
        self.gateway_ip_configurations = kwargs.get('gateway_ip_configurations', None)
        self.authentication_certificates = kwargs.get('authentication_certificates', None)
        self.trusted_root_certificates = kwargs.get('trusted_root_certificates', None)
        self.ssl_certificates = kwargs.get('ssl_certificates', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.frontend_ports = kwargs.get('frontend_ports', None)
        self.probes = kwargs.get('probes', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.backend_http_settings_collection = kwargs.get('backend_http_settings_collection', None)
        self.http_listeners = kwargs.get('http_listeners', None)
        self.url_path_maps = kwargs.get('url_path_maps', None)
        self.request_routing_rules = kwargs.get('request_routing_rules', None)
        self.rewrite_rule_sets = kwargs.get('rewrite_rule_sets', None)
        self.redirect_configurations = kwargs.get('redirect_configurations', None)
        self.web_application_firewall_configuration = kwargs.get('web_application_firewall_configuration', None)
        self.firewall_policy = kwargs.get('firewall_policy', None)
        self.enable_http2 = kwargs.get('enable_http2', None)
        self.enable_fips = kwargs.get('enable_fips', None)
        self.autoscale_configuration = kwargs.get('autoscale_configuration', None)
        self.resource_guid = None
        self.provisioning_state = None
        self.custom_error_configurations = kwargs.get('custom_error_configurations', None)
        self.force_firewall_policy_association = kwargs.get('force_firewall_policy_association', None)


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the authentication certificate that is unique within an Application
     Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param data: Certificate public data.
    :type data: str
    :ivar provisioning_state: The provisioning state of the authentication certificate resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayAuthenticationCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.data = kwargs.get('data', None)
        self.provisioning_state = None


class ApplicationGatewayAutoscaleConfiguration(msrest.serialization.Model):
    """Application Gateway autoscale configuration.

    All required parameters must be populated in order to send to Azure.

    :param min_capacity: Required. Lower bound on number of Application Gateway capacity.
    :type min_capacity: int
    :param max_capacity: Upper bound on number of Application Gateway capacity.
    :type max_capacity: int
    """

    _validation = {
        'min_capacity': {'required': True, 'minimum': 0},
        'max_capacity': {'minimum': 2},
    }

    _attribute_map = {
        'min_capacity': {'key': 'minCapacity', 'type': 'int'},
        'max_capacity': {'key': 'maxCapacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayAutoscaleConfiguration, self).__init__(**kwargs)
        self.min_capacity = kwargs['min_capacity']
        self.max_capacity = kwargs.get('max_capacity', None)


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param predefined_policies: List of available Ssl predefined policy.
    :type predefined_policies: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Possible values include: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
     "AppGwSslPolicy20170401S".
    :type default_policy: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslPolicyName
    :param available_cipher_suites: List of available Ssl cipher suites.
    :type available_cipher_suites: list[str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslCipherSuite]
    :param available_protocols: List of available Ssl protocols.
    :type available_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'predefined_policies': {'key': 'properties.predefinedPolicies', 'type': '[SubResource]'},
        'default_policy': {'key': 'properties.defaultPolicy', 'type': 'str'},
        'available_cipher_suites': {'key': 'properties.availableCipherSuites', 'type': '[str]'},
        'available_protocols': {'key': 'properties.availableProtocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayAvailableSslOptions, self).__init__(**kwargs)
        self.predefined_policies = kwargs.get('predefined_policies', None)
        self.default_policy = kwargs.get('default_policy', None)
        self.available_cipher_suites = kwargs.get('available_cipher_suites', None)
        self.available_protocols = kwargs.get('available_protocols', None)


class ApplicationGatewayAvailableSslPredefinedPolicies(msrest.serialization.Model):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :param value: List of available Ssl predefined policy.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslPredefinedPolicy]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewaySslPredefinedPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayAvailableSslPredefinedPolicies, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ApplicationGatewayAvailableWafRuleSetsResult(msrest.serialization.Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :param value: The list of application gateway rule sets.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewayFirewallRuleSet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayAvailableWafRuleSetsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ApplicationGatewayBackendAddress(msrest.serialization.Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address.
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.ip_address = kwargs.get('ip_address', None)


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the backend address pool that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses.
    :type backend_addresses:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'backend_ip_configurations': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddressPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.backend_ip_configurations = None
        self.backend_addresses = kwargs.get('backend_addresses', None)
        self.provisioning_state = None


class ApplicationGatewayBackendHealth(msrest.serialization.Model):
    """Response for ApplicationGatewayBackendHealth API service call.

    :param backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        'backend_address_pools': {'key': 'backendAddressPools', 'type': '[ApplicationGatewayBackendHealthPool]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealth, self).__init__(**kwargs)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)


class ApplicationGatewayBackendHealthHttpSettings(msrest.serialization.Model):
    """Application gateway BackendHealthHttp settings.

    :param backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
    :type backend_http_settings:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHttpSettings
    :param servers: List of ApplicationGatewayBackendHealthServer resources.
    :type servers:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'ApplicationGatewayBackendHttpSettings'},
        'servers': {'key': 'servers', 'type': '[ApplicationGatewayBackendHealthServer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthHttpSettings, self).__init__(**kwargs)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.servers = kwargs.get('servers', None)


class ApplicationGatewayBackendHealthOnDemand(msrest.serialization.Model):
    """Result of on demand test probe.

    :param backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendAddressPool
    :param backend_health_http_settings: Application gateway BackendHealthHttp settings.
    :type backend_health_http_settings:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHealthHttpSettings
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_health_http_settings': {'key': 'backendHealthHttpSettings', 'type': 'ApplicationGatewayBackendHealthHttpSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthOnDemand, self).__init__(**kwargs)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_health_http_settings = kwargs.get('backend_health_http_settings', None)


class ApplicationGatewayBackendHealthPool(msrest.serialization.Model):
    """Application gateway BackendHealth pool.

    :param backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendAddressPool
    :param backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_http_settings_collection': {'key': 'backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHealthHttpSettings]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthPool, self).__init__(**kwargs)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings_collection = kwargs.get('backend_http_settings_collection', None)


class ApplicationGatewayBackendHealthServer(msrest.serialization.Model):
    """Application gateway backendhealth http settings.

    :param address: IP address or FQDN of backend server.
    :type address: str
    :param ip_configuration: Reference to IP configuration of backend server.
    :type ip_configuration: ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration
    :param health: Health of backend server. Possible values include: "Unknown", "Up", "Down",
     "Partial", "Draining".
    :type health: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendHealthServerHealth
    :param health_probe_log: Health Probe Log.
    :type health_probe_log: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'ip_configuration': {'key': 'ipConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'health': {'key': 'health', 'type': 'str'},
        'health_probe_log': {'key': 'healthProbeLog', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHealthServer, self).__init__(**kwargs)
        self.address = kwargs.get('address', None)
        self.ip_configuration = kwargs.get('ip_configuration', None)
        self.health = kwargs.get('health', None)
        self.health_probe_log = kwargs.get('health_probe_log', None)


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the backend http settings that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param port: The destination port on the backend.
    :type port: int
    :param protocol: The protocol used to communicate with the backend. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values include: "Enabled",
     "Disabled".
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway will fail the request
     if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param authentication_certificates: Array of references to application gateway authentication
     certificates.
    :type authentication_certificates: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param trusted_root_certificates: Array of references to application gateway trusted root
     certificates.
    :type trusted_root_certificates: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param connection_draining: Connection draining of the backend http settings resource.
    :type connection_draining:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayConnectionDraining
    :param host_name: Host header to be sent to the backend servers.
    :type host_name: str
    :param pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :type pick_host_name_from_backend_address: bool
    :param affinity_cookie_name: Cookie name to use for the affinity cookie.
    :type affinity_cookie_name: str
    :param probe_enabled: Whether the probe is enabled. Default value is false.
    :type probe_enabled: bool
    :param path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :type path: str
    :ivar provisioning_state: The provisioning state of the backend HTTP settings resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[SubResource]'},
        'trusted_root_certificates': {'key': 'properties.trustedRootCertificates', 'type': '[SubResource]'},
        'connection_draining': {'key': 'properties.connectionDraining', 'type': 'ApplicationGatewayConnectionDraining'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'pick_host_name_from_backend_address': {'key': 'properties.pickHostNameFromBackendAddress', 'type': 'bool'},
        'affinity_cookie_name': {'key': 'properties.affinityCookieName', 'type': 'str'},
        'probe_enabled': {'key': 'properties.probeEnabled', 'type': 'bool'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.port = kwargs.get('port', None)
        self.protocol = kwargs.get('protocol', None)
        self.cookie_based_affinity = kwargs.get('cookie_based_affinity', None)
        self.request_timeout = kwargs.get('request_timeout', None)
        self.probe = kwargs.get('probe', None)
        self.authentication_certificates = kwargs.get('authentication_certificates', None)
        self.trusted_root_certificates = kwargs.get('trusted_root_certificates', None)
        self.connection_draining = kwargs.get('connection_draining', None)
        self.host_name = kwargs.get('host_name', None)
        self.pick_host_name_from_backend_address = kwargs.get('pick_host_name_from_backend_address', None)
        self.affinity_cookie_name = kwargs.get('affinity_cookie_name', None)
        self.probe_enabled = kwargs.get('probe_enabled', None)
        self.path = kwargs.get('path', None)
        self.provisioning_state = None


class ApplicationGatewayConnectionDraining(msrest.serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether connection draining is enabled or not.
    :type enabled: bool
    :param drain_timeout_in_sec: Required. The number of seconds connection draining is active.
     Acceptable values are from 1 second to 3600 seconds.
    :type drain_timeout_in_sec: int
    """

    _validation = {
        'enabled': {'required': True},
        'drain_timeout_in_sec': {'required': True, 'maximum': 3600, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'drain_timeout_in_sec': {'key': 'drainTimeoutInSec', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayConnectionDraining, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.drain_timeout_in_sec = kwargs['drain_timeout_in_sec']


class ApplicationGatewayCustomError(msrest.serialization.Model):
    """Customer error of an application gateway.

    :param status_code: Status code of the application gateway customer error. Possible values
     include: "HttpStatus403", "HttpStatus502".
    :type status_code: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayCustomErrorStatusCode
    :param custom_error_page_url: Error page URL of the application gateway customer error.
    :type custom_error_page_url: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'custom_error_page_url': {'key': 'customErrorPageUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayCustomError, self).__init__(**kwargs)
        self.status_code = kwargs.get('status_code', None)
        self.custom_error_page_url = kwargs.get('custom_error_page_url', None)


class ApplicationGatewayFirewallDisabledRuleGroup(msrest.serialization.Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the rule group that will be disabled.
    :type rule_group_name: str
    :param rules: The list of rules that will be disabled. If null, all rules of the rule group
     will be disabled.
    :type rules: list[int]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFirewallDisabledRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = kwargs['rule_group_name']
        self.rules = kwargs.get('rules', None)


class ApplicationGatewayFirewallExclusion(msrest.serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable to be excluded.
    :type match_variable: str
    :param selector_match_operator: Required. When matchVariable is a collection, operate on the
     selector to specify which elements in the collection this exclusion applies to.
    :type selector_match_operator: str
    :param selector: Required. When matchVariable is a collection, operator used to specify which
     elements in the collection this exclusion applies to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFirewallExclusion, self).__init__(**kwargs)
        self.match_variable = kwargs['match_variable']
        self.selector_match_operator = kwargs['selector_match_operator']
        self.selector = kwargs['selector']


class ApplicationGatewayFirewallRule(msrest.serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. The identifier of the web application firewall rule.
    :type rule_id: int
    :param description: The description of the web application firewall rule.
    :type description: str
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRule, self).__init__(**kwargs)
        self.rule_id = kwargs['rule_id']
        self.description = kwargs.get('description', None)


class ApplicationGatewayFirewallRuleGroup(msrest.serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the web application firewall rule group.
    :type rule_group_name: str
    :param description: The description of the web application firewall rule group.
    :type description: str
    :param rules: Required. The rules of the web application firewall rule group.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        'rule_group_name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ApplicationGatewayFirewallRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = kwargs['rule_group_name']
        self.description = kwargs.get('description', None)
        self.rules = kwargs['rules']


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application firewall rule set.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param rule_set_type: The type of the web application firewall rule set.
    :type rule_set_type: str
    :param rule_set_version: The version of the web application firewall rule set type.
    :type rule_set_version: str
    :param rule_groups: The rule groups of the web application firewall rule set.
    :type rule_groups:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ApplicationGatewayFirewallRuleGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFirewallRuleSet, self).__init__(**kwargs)
        self.provisioning_state = None
        self.rule_set_type = kwargs.get('rule_set_type', None)
        self.rule_set_version = kwargs.get('rule_set_version', None)
        self.rule_groups = kwargs.get('rule_groups', None)


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the frontend IP configuration that is unique within an Application
     Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param subnet: Reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param public_ip_address: Reference to the PublicIP resource.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = None


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the frontend port that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param port: Frontend port.
    :type port: int
    :ivar provisioning_state: The provisioning state of the frontend port resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFrontendPort, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.port = kwargs.get('port', None)
        self.provisioning_state = None


class ApplicationGatewayHeaderConfiguration(msrest.serialization.Model):
    """Header configuration of the Actions set in Application Gateway.

    :param header_name: Header name of the header configuration.
    :type header_name: str
    :param header_value: Header value of the header configuration.
    :type header_value: str
    """

    _attribute_map = {
        'header_name': {'key': 'headerName', 'type': 'str'},
        'header_value': {'key': 'headerValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayHeaderConfiguration, self).__init__(**kwargs)
        self.header_name = kwargs.get('header_name', None)
        self.header_value = kwargs.get('header_value', None)


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the HTTP listener that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param protocol: Protocol of the HTTP listener. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :type require_server_name_indication: bool
    :ivar provisioning_state: The provisioning state of the HTTP listener resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param custom_error_configurations: Custom error configurations of the HTTP listener.
    :type custom_error_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayCustomError]
    :param firewall_policy: Reference to the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param host_names: List of Host names for HTTP Listener that allows special wildcard characters
     as well.
    :type host_names: list[str]
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'custom_error_configurations': {'key': 'properties.customErrorConfigurations', 'type': '[ApplicationGatewayCustomError]'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayHttpListener, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.protocol = kwargs.get('protocol', None)
        self.host_name = kwargs.get('host_name', None)
        self.ssl_certificate = kwargs.get('ssl_certificate', None)
        self.require_server_name_indication = kwargs.get('require_server_name_indication', None)
        self.provisioning_state = None
        self.custom_error_configurations = kwargs.get('custom_error_configurations', None)
        self.firewall_policy = kwargs.get('firewall_policy', None)
        self.host_names = kwargs.get('host_names', None)


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the IP configuration that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param subnet: Reference to the subnet resource. A subnet from where application gateway gets
     its private address.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the application gateway IP configuration
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.subnet = kwargs.get('subnet', None)
        self.provisioning_state = None


class ApplicationGatewayListResult(msrest.serialization.Model):
    """Response for ListApplicationGateways API service call.

    :param value: List of an application gateways in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGateway]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ApplicationGatewayOnDemandProbe(msrest.serialization.Model):
    """Details of on demand test probe request.

    :param protocol: The protocol used for the probe. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :type path: str
    :param timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :type timeout: int
    :param pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param match: Criterion for classifying a healthy probe response.
    :type match: ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProbeHealthResponseMatch
    :param backend_address_pool: Reference to backend pool of application gateway to which probe
     request will be sent.
    :type backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param backend_http_settings: Reference to backend http setting of application gateway to be
     used for test probe.
    :type backend_http_settings: ~azure.mgmt.network.v2020_03_01.models.SubResource
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'match': {'key': 'match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayOnDemandProbe, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.host = kwargs.get('host', None)
        self.path = kwargs.get('path', None)
        self.timeout = kwargs.get('timeout', None)
        self.pick_host_name_from_backend_http_settings = kwargs.get('pick_host_name_from_backend_http_settings', None)
        self.match = kwargs.get('match', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the path rule that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map path rule.
    :type backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path map path rule.
    :type backend_http_settings: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of URL path map path rule.
    :type redirect_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
    :type rewrite_rule_set: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the path rule resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param firewall_policy: Reference to the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'rewrite_rule_set': {'key': 'properties.rewriteRuleSet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayPathRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.paths = kwargs.get('paths', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.redirect_configuration = kwargs.get('redirect_configuration', None)
        self.rewrite_rule_set = kwargs.get('rewrite_rule_set', None)
        self.provisioning_state = None
        self.firewall_policy = kwargs.get('firewall_policy', None)


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the probe that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param protocol: The protocol used for the probe. Possible values include: "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :type path: str
    :param interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :type interval: int
    :param timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :type unhealthy_threshold: int
    :param pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :type min_servers: int
    :param match: Criterion for classifying a healthy probe response.
    :type match: ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: The provisioning state of the probe resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param port: Custom port which will be used for probing the backend servers. The valid value
     ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
     valid for Standard_v2 and WAF_v2 only.
    :type port: int
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'port': {'maximum': 65535, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'properties.pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'min_servers': {'key': 'properties.minServers', 'type': 'int'},
        'match': {'key': 'properties.match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayProbe, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.protocol = kwargs.get('protocol', None)
        self.host = kwargs.get('host', None)
        self.path = kwargs.get('path', None)
        self.interval = kwargs.get('interval', None)
        self.timeout = kwargs.get('timeout', None)
        self.unhealthy_threshold = kwargs.get('unhealthy_threshold', None)
        self.pick_host_name_from_backend_http_settings = kwargs.get('pick_host_name_from_backend_http_settings', None)
        self.min_servers = kwargs.get('min_servers', None)
        self.match = kwargs.get('match', None)
        self.provisioning_state = None
        self.port = kwargs.get('port', None)


class ApplicationGatewayProbeHealthResponseMatch(msrest.serialization.Model):
    """Application gateway probe health response match.

    :param body: Body that must be contained in the health response. Default value is empty.
    :type body: str
    :param status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :type status_codes: list[str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'status_codes': {'key': 'statusCodes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayProbeHealthResponseMatch, self).__init__(**kwargs)
        self.body = kwargs.get('body', None)
        self.status_codes = kwargs.get('status_codes', None)


class ApplicationGatewayRedirectConfiguration(SubResource):
    """Redirect configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the redirect configuration that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param redirect_type: HTTP redirection type. Possible values include: "Permanent", "Found",
     "SeeOther", "Temporary".
    :type redirect_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRedirectType
    :param target_listener: Reference to a listener to redirect the request to.
    :type target_listener: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param target_url: Url to redirect the request to.
    :type target_url: str
    :param include_path: Include path in the redirected url.
    :type include_path: bool
    :param include_query_string: Include query string in the redirected url.
    :type include_query_string: bool
    :param request_routing_rules: Request routing specifying redirect configuration.
    :type request_routing_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param url_path_maps: Url path maps specifying default redirect configuration.
    :type url_path_maps: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param path_rules: Path rules specifying redirect configuration.
    :type path_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'redirect_type': {'key': 'properties.redirectType', 'type': 'str'},
        'target_listener': {'key': 'properties.targetListener', 'type': 'SubResource'},
        'target_url': {'key': 'properties.targetUrl', 'type': 'str'},
        'include_path': {'key': 'properties.includePath', 'type': 'bool'},
        'include_query_string': {'key': 'properties.includeQueryString', 'type': 'bool'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[SubResource]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[SubResource]'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRedirectConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.redirect_type = kwargs.get('redirect_type', None)
        self.target_listener = kwargs.get('target_listener', None)
        self.target_url = kwargs.get('target_url', None)
        self.include_path = kwargs.get('include_path', None)
        self.include_query_string = kwargs.get('include_query_string', None)
        self.request_routing_rules = kwargs.get('request_routing_rules', None)
        self.url_path_maps = kwargs.get('url_path_maps', None)
        self.path_rules = kwargs.get('path_rules', None)


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the request routing rule that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param rule_type: Rule type. Possible values include: "Basic", "PathBasedRouting".
    :type rule_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRequestRoutingRuleType
    :param priority: Priority of the request routing rule.
    :type priority: int
    :param backend_address_pool: Backend address pool resource of the application gateway.
    :type backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of the application gateway.
    :type backend_http_settings: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
    :type rewrite_rule_set: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of the application gateway.
    :type redirect_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing rule resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'priority': {'maximum': 20000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'rewrite_rule_set': {'key': 'properties.rewriteRuleSet', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.rule_type = kwargs.get('rule_type', None)
        self.priority = kwargs.get('priority', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.http_listener = kwargs.get('http_listener', None)
        self.url_path_map = kwargs.get('url_path_map', None)
        self.rewrite_rule_set = kwargs.get('rewrite_rule_set', None)
        self.redirect_configuration = kwargs.get('redirect_configuration', None)
        self.provisioning_state = None


class ApplicationGatewayRewriteRule(msrest.serialization.Model):
    """Rewrite rule of an application gateway.

    :param name: Name of the rewrite rule that is unique within an Application Gateway.
    :type name: str
    :param rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution
     of a particular rule in a RewriteRuleSet.
    :type rule_sequence: int
    :param conditions: Conditions based on which the action set execution will be evaluated.
    :type conditions:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRewriteRuleCondition]
    :param action_set: Set of actions to be done as part of the rewrite Rule.
    :type action_set: ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRewriteRuleActionSet
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'rule_sequence': {'key': 'ruleSequence', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[ApplicationGatewayRewriteRuleCondition]'},
        'action_set': {'key': 'actionSet', 'type': 'ApplicationGatewayRewriteRuleActionSet'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRewriteRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.rule_sequence = kwargs.get('rule_sequence', None)
        self.conditions = kwargs.get('conditions', None)
        self.action_set = kwargs.get('action_set', None)


class ApplicationGatewayRewriteRuleActionSet(msrest.serialization.Model):
    """Set of actions in the Rewrite Rule in Application Gateway.

    :param request_header_configurations: Request Header Actions in the Action Set.
    :type request_header_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayHeaderConfiguration]
    :param response_header_configurations: Response Header Actions in the Action Set.
    :type response_header_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayHeaderConfiguration]
    :param url_configuration: Url Configuration Action in the Action Set.
    :type url_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayUrlConfiguration
    """

    _attribute_map = {
        'request_header_configurations': {'key': 'requestHeaderConfigurations', 'type': '[ApplicationGatewayHeaderConfiguration]'},
        'response_header_configurations': {'key': 'responseHeaderConfigurations', 'type': '[ApplicationGatewayHeaderConfiguration]'},
        'url_configuration': {'key': 'urlConfiguration', 'type': 'ApplicationGatewayUrlConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRewriteRuleActionSet, self).__init__(**kwargs)
        self.request_header_configurations = kwargs.get('request_header_configurations', None)
        self.response_header_configurations = kwargs.get('response_header_configurations', None)
        self.url_configuration = kwargs.get('url_configuration', None)


class ApplicationGatewayRewriteRuleCondition(msrest.serialization.Model):
    """Set of conditions in the Rewrite Rule in Application Gateway.

    :param variable: The condition parameter of the RewriteRuleCondition.
    :type variable: str
    :param pattern: The pattern, either fixed string or regular expression, that evaluates the
     truthfulness of the condition.
    :type pattern: str
    :param ignore_case: Setting this parameter to truth value with force the pattern to do a case
     in-sensitive comparison.
    :type ignore_case: bool
    :param negate: Setting this value as truth will force to check the negation of the condition
     given by the user.
    :type negate: bool
    """

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'negate': {'key': 'negate', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRewriteRuleCondition, self).__init__(**kwargs)
        self.variable = kwargs.get('variable', None)
        self.pattern = kwargs.get('pattern', None)
        self.ignore_case = kwargs.get('ignore_case', None)
        self.negate = kwargs.get('negate', None)


class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the rewrite rule set that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param rewrite_rules: Rewrite rules in the rewrite rule set.
    :type rewrite_rules: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: The provisioning state of the rewrite rule set resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rewrite_rules': {'key': 'properties.rewriteRules', 'type': '[ApplicationGatewayRewriteRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRewriteRuleSet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.rewrite_rules = kwargs.get('rewrite_rules', None)
        self.provisioning_state = None


class ApplicationGatewaySku(msrest.serialization.Model):
    """SKU of an application gateway.

    :param name: Name of an application gateway SKU. Possible values include: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", "WAF_v2".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySkuName
    :param tier: Tier of an application gateway. Possible values include: "Standard", "WAF",
     "Standard_v2", "WAF_v2".
    :type tier: str or ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayTier
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the SSL certificate that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only applicable in PUT request.
    :type password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :param key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :type key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the SSL certificate resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'public_cert_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'key_vault_secret_id': {'key': 'properties.keyVaultSecretId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySslCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.data = kwargs.get('data', None)
        self.password = kwargs.get('password', None)
        self.public_cert_data = None
        self.key_vault_secret_id = kwargs.get('key_vault_secret_id', None)
        self.provisioning_state = None


class ApplicationGatewaySslPolicy(msrest.serialization.Model):
    """Application Gateway Ssl policy.

    :param disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :type disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslProtocol]
    :param policy_type: Type of Ssl Policy. Possible values include: "Predefined", "Custom".
    :type policy_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslPolicyType
    :param policy_name: Name of Ssl predefined policy. Possible values include:
     "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S".
    :type policy_name: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslPolicyName
    :param cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Possible values include: "TLSv1_0", "TLSv1_1", "TLSv1_2".
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'disabled_ssl_protocols': {'key': 'disabledSslProtocols', 'type': '[str]'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'cipher_suites': {'key': 'cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'minProtocolVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySslPolicy, self).__init__(**kwargs)
        self.disabled_ssl_protocols = kwargs.get('disabled_ssl_protocols', None)
        self.policy_type = kwargs.get('policy_type', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.cipher_suites = kwargs.get('cipher_suites', None)
        self.min_protocol_version = kwargs.get('min_protocol_version', None)


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the Ssl predefined policy.
    :type name: str
    :param cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Possible values include: "TLSv1_0", "TLSv1_1", "TLSv1_2".
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'cipher_suites': {'key': 'properties.cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'properties.minProtocolVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySslPredefinedPolicy, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.cipher_suites = kwargs.get('cipher_suites', None)
        self.min_protocol_version = kwargs.get('min_protocol_version', None)


class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the trusted root certificate that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param data: Certificate public data.
    :type data: str
    :param key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :type key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the trusted root certificate resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'key_vault_secret_id': {'key': 'properties.keyVaultSecretId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayTrustedRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.data = kwargs.get('data', None)
        self.key_vault_secret_id = kwargs.get('key_vault_secret_id', None)
        self.provisioning_state = None


class ApplicationGatewayUrlConfiguration(msrest.serialization.Model):
    """Url configuration of the Actions set in Application Gateway.

    :param modified_path: Url path which user has provided for url rewrite. Null means no path will
     be updated. Default value is null.
    :type modified_path: str
    :param modified_query_string: Query string which user has provided for url rewrite. Null means
     no query string will be updated. Default value is null.
    :type modified_query_string: str
    :param reroute: If set as true, it will re-evaluate the url path map provided in path based
     request routing rules using modified path. Default value is false.
    :type reroute: bool
    """

    _attribute_map = {
        'modified_path': {'key': 'modifiedPath', 'type': 'str'},
        'modified_query_string': {'key': 'modifiedQueryString', 'type': 'str'},
        'reroute': {'key': 'reroute', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayUrlConfiguration, self).__init__(**kwargs)
        self.modified_path = kwargs.get('modified_path', None)
        self.modified_query_string = kwargs.get('modified_query_string', None)
        self.reroute = kwargs.get('reroute', None)


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the URL path map that is unique within an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param default_backend_address_pool: Default backend address pool resource of URL path map.
    :type default_backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param default_backend_http_settings: Default backend http settings resource of URL path map.
    :type default_backend_http_settings: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
    :type default_rewrite_rule_set: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param default_redirect_configuration: Default redirect configuration resource of URL path map.
    :type default_redirect_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: The provisioning state of the URL path map resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'default_rewrite_rule_set': {'key': 'properties.defaultRewriteRuleSet', 'type': 'SubResource'},
        'default_redirect_configuration': {'key': 'properties.defaultRedirectConfiguration', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayUrlPathMap, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.default_backend_address_pool = kwargs.get('default_backend_address_pool', None)
        self.default_backend_http_settings = kwargs.get('default_backend_http_settings', None)
        self.default_rewrite_rule_set = kwargs.get('default_rewrite_rule_set', None)
        self.default_redirect_configuration = kwargs.get('default_redirect_configuration', None)
        self.path_rules = kwargs.get('path_rules', None)
        self.provisioning_state = None


class ApplicationGatewayWebApplicationFirewallConfiguration(msrest.serialization.Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the web application firewall is enabled or not.
    :type enabled: bool
    :param firewall_mode: Required. Web application firewall mode. Possible values include:
     "Detection", "Prevention".
    :type firewall_mode: str or
     ~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallMode
    :param rule_set_type: Required. The type of the web application firewall rule set. Possible
     values are: 'OWASP'.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the rule set type.
    :type rule_set_version: str
    :param disabled_rule_groups: The disabled rule groups.
    :type disabled_rule_groups:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :param request_body_check: Whether allow WAF to check request Body.
    :type request_body_check: bool
    :param max_request_body_size: Maximum request body size for WAF.
    :type max_request_body_size: int
    :param max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :type max_request_body_size_in_kb: int
    :param file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :type file_upload_limit_in_mb: int
    :param exclusions: The exclusion list.
    :type exclusions:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayFirewallExclusion]
    """

    _validation = {
        'enabled': {'required': True},
        'firewall_mode': {'required': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'max_request_body_size': {'maximum': 128, 'minimum': 8},
        'max_request_body_size_in_kb': {'maximum': 128, 'minimum': 8},
        'file_upload_limit_in_mb': {'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'disabled_rule_groups': {'key': 'disabledRuleGroups', 'type': '[ApplicationGatewayFirewallDisabledRuleGroup]'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'bool'},
        'max_request_body_size': {'key': 'maxRequestBodySize', 'type': 'int'},
        'max_request_body_size_in_kb': {'key': 'maxRequestBodySizeInKb', 'type': 'int'},
        'file_upload_limit_in_mb': {'key': 'fileUploadLimitInMb', 'type': 'int'},
        'exclusions': {'key': 'exclusions', 'type': '[ApplicationGatewayFirewallExclusion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayWebApplicationFirewallConfiguration, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.firewall_mode = kwargs['firewall_mode']
        self.rule_set_type = kwargs['rule_set_type']
        self.rule_set_version = kwargs['rule_set_version']
        self.disabled_rule_groups = kwargs.get('disabled_rule_groups', None)
        self.request_body_check = kwargs.get('request_body_check', None)
        self.max_request_body_size = kwargs.get('max_request_body_size', None)
        self.max_request_body_size_in_kb = kwargs.get('max_request_body_size_in_kb', None)
        self.file_upload_limit_in_mb = kwargs.get('file_upload_limit_in_mb', None)
        self.exclusions = kwargs.get('exclusions', None)


class FirewallPolicyRuleCondition(msrest.serialization.Model):
    """Properties of a rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationRuleCondition, NatRuleCondition, NetworkRuleCondition.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Rule Condition Type.Constant filled by server.  Possible
     values include: "ApplicationRuleCondition", "NetworkRuleCondition", "NatRuleCondition".
    :type rule_condition_type: str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionType
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
    }

    _subtype_map = {
        'rule_condition_type': {'ApplicationRuleCondition': 'ApplicationRuleCondition', 'NatRuleCondition': 'NatRuleCondition', 'NetworkRuleCondition': 'NetworkRuleCondition'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyRuleCondition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.rule_condition_type = None  # type: Optional[str]


class ApplicationRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type application.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Rule Condition Type.Constant filled by server.  Possible
     values include: "ApplicationRuleCondition", "NetworkRuleCondition", "NatRuleCondition".
    :type rule_condition_type: str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionType
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses or Service Tags.
    :type destination_addresses: list[str]
    :param protocols: Array of Application Protocols.
    :type protocols:
     list[~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionApplicationProtocol]
    :param target_fqdns: List of FQDNs for this rule condition.
    :type target_fqdns: list[str]
    :param fqdn_tags: List of FQDN Tags for this rule condition.
    :type fqdn_tags: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[FirewallPolicyRuleConditionApplicationProtocol]'},
        'target_fqdns': {'key': 'targetFqdns', 'type': '[str]'},
        'fqdn_tags': {'key': 'fqdnTags', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationRuleCondition, self).__init__(**kwargs)
        self.rule_condition_type = 'ApplicationRuleCondition'  # type: str
        self.source_addresses = kwargs.get('source_addresses', None)
        self.destination_addresses = kwargs.get('destination_addresses', None)
        self.protocols = kwargs.get('protocols', None)
        self.target_fqdns = kwargs.get('target_fqdns', None)
        self.fqdn_tags = kwargs.get('fqdn_tags', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)


class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the application security group resource. It
     uniquely identifies a resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application security group resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationSecurityGroup, self).__init__(**kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None


class ApplicationSecurityGroupListResult(msrest.serialization.Model):
    """A list of application security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of application security groups.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ApplicationSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationSecurityGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AuthorizationListResult(msrest.serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :param value: The authorizations in an ExpressRoute Circuit.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitAuthorization]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitAuthorization]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AutoApprovedPrivateLinkService(msrest.serialization.Model):
    """The information of an AutoApprovedPrivateLinkService.

    :param private_link_service: The id of the private link service resource.
    :type private_link_service: str
    """

    _attribute_map = {
        'private_link_service': {'key': 'privateLinkService', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoApprovedPrivateLinkService, self).__init__(**kwargs)
        self.private_link_service = kwargs.get('private_link_service', None)


class AutoApprovedPrivateLinkServicesResult(msrest.serialization.Model):
    """An array of private link service id that can be linked to a private end point with auto approved.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: An array of auto approved private link service.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AutoApprovedPrivateLinkService]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoApprovedPrivateLinkService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoApprovedPrivateLinkServicesResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class Availability(msrest.serialization.Model):
    """Availability of the metric.

    :param time_grain: The time grain of the availability.
    :type time_grain: str
    :param retention: The retention of the availability.
    :type retention: str
    :param blob_duration: Duration of the availability blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Availability, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.retention = kwargs.get('retention', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class AvailableDelegation(msrest.serialization.Model):
    """The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.

    :param name: The name of the AvailableDelegation resource.
    :type name: str
    :param id: A unique identifier of the AvailableDelegation resource.
    :type id: str
    :param type: Resource type.
    :type type: str
    :param service_name: The name of the service and resource.
    :type service_name: str
    :param actions: The actions permitted to the service upon delegation.
    :type actions: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'actions': {'key': 'actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableDelegation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.service_name = kwargs.get('service_name', None)
        self.actions = kwargs.get('actions', None)


class AvailableDelegationsResult(msrest.serialization.Model):
    """An array of available delegations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: An array of available delegations.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AvailableDelegation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableDelegation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableDelegationsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AvailablePrivateEndpointType(msrest.serialization.Model):
    """The information of an AvailablePrivateEndpointType.

    :param name: The name of the service and resource.
    :type name: str
    :param id: A unique identifier of the AvailablePrivateEndpoint Type resource.
    :type id: str
    :param type: Resource type.
    :type type: str
    :param resource_name: The name of the service and resource.
    :type resource_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailablePrivateEndpointType, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.resource_name = kwargs.get('resource_name', None)


class AvailablePrivateEndpointTypesResult(msrest.serialization.Model):
    """An array of available PrivateEndpoint types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: An array of available privateEndpoint type.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AvailablePrivateEndpointType]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailablePrivateEndpointType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailablePrivateEndpointTypesResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AvailableProvidersList(msrest.serialization.Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to Azure.

    :param countries: Required. List of available countries.
    :type countries: list[~azure.mgmt.network.v2020_03_01.models.AvailableProvidersListCountry]
    """

    _validation = {
        'countries': {'required': True},
    }

    _attribute_map = {
        'countries': {'key': 'countries', 'type': '[AvailableProvidersListCountry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableProvidersList, self).__init__(**kwargs)
        self.countries = kwargs['countries']


class AvailableProvidersListCity(msrest.serialization.Model):
    """City or town details.

    :param city_name: The city or town name.
    :type city_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    """

    _attribute_map = {
        'city_name': {'key': 'cityName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableProvidersListCity, self).__init__(**kwargs)
        self.city_name = kwargs.get('city_name', None)
        self.providers = kwargs.get('providers', None)


class AvailableProvidersListCountry(msrest.serialization.Model):
    """Country details.

    :param country_name: The country name.
    :type country_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param states: List of available states in the country.
    :type states: list[~azure.mgmt.network.v2020_03_01.models.AvailableProvidersListState]
    """

    _attribute_map = {
        'country_name': {'key': 'countryName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'states': {'key': 'states', 'type': '[AvailableProvidersListState]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableProvidersListCountry, self).__init__(**kwargs)
        self.country_name = kwargs.get('country_name', None)
        self.providers = kwargs.get('providers', None)
        self.states = kwargs.get('states', None)


class AvailableProvidersListParameters(msrest.serialization.Model):
    """Constraints that determine the list of available Internet service providers.

    :param azure_locations: A list of Azure regions.
    :type azure_locations: list[str]
    :param country: The country for available providers list.
    :type country: str
    :param state: The state for available providers list.
    :type state: str
    :param city: The city or town for available providers list.
    :type city: str
    """

    _attribute_map = {
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableProvidersListParameters, self).__init__(**kwargs)
        self.azure_locations = kwargs.get('azure_locations', None)
        self.country = kwargs.get('country', None)
        self.state = kwargs.get('state', None)
        self.city = kwargs.get('city', None)


class AvailableProvidersListState(msrest.serialization.Model):
    """State details.

    :param state_name: The state name.
    :type state_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param cities: List of available cities or towns in the state.
    :type cities: list[~azure.mgmt.network.v2020_03_01.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        'state_name': {'key': 'stateName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'cities': {'key': 'cities', 'type': '[AvailableProvidersListCity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableProvidersListState, self).__init__(**kwargs)
        self.state_name = kwargs.get('state_name', None)
        self.providers = kwargs.get('providers', None)
        self.cities = kwargs.get('cities', None)


class AvailableServiceAlias(msrest.serialization.Model):
    """The available service alias.

    :param name: The name of the service alias.
    :type name: str
    :param id: The ID of the service alias.
    :type id: str
    :param type: The type of the resource.
    :type type: str
    :param resource_name: The resource name of the service alias.
    :type resource_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableServiceAlias, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.resource_name = kwargs.get('resource_name', None)


class AvailableServiceAliasesResult(msrest.serialization.Model):
    """An array of available service aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: An array of available service aliases.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AvailableServiceAlias]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableServiceAlias]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableServiceAliasesResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AzureAsyncOperationResult(msrest.serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :param status: Status of the Azure async operation. Possible values include: "InProgress",
     "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.network.v2020_03_01.models.NetworkOperationStatus
    :param error: Details of the error occurred during specified asynchronous operation.
    :type error: ~azure.mgmt.network.v2020_03_01.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class AzureFirewall(Resource):
    """Azure Firewall resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param application_rule_collections: Collection of application rule collections used by Azure
     Firewall.
    :type application_rule_collections:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallApplicationRuleCollection]
    :param nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
    :type nat_rule_collections:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallNatRuleCollection]
    :param network_rule_collections: Collection of network rule collections used by Azure Firewall.
    :type network_rule_collections:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallNetworkRuleCollection]
    :param ip_configurations: IP configuration of the Azure Firewall resource.
    :type ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallIPConfiguration]
    :param management_ip_configuration: IP configuration of the Azure Firewall used for management
     traffic.
    :type management_ip_configuration:
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallIPConfiguration
    :ivar provisioning_state: The provisioning state of the Azure firewall resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param threat_intel_mode: The operation mode for Threat Intelligence. Possible values include:
     "Alert", "Deny", "Off".
    :type threat_intel_mode: str or
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallThreatIntelMode
    :param virtual_hub: The virtualHub to which the firewall belongs.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param firewall_policy: The firewallPolicy associated with this azure firewall.
    :type firewall_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar hub_ip_addresses: IP addresses associated with AzureFirewall.
    :vartype hub_ip_addresses: ~azure.mgmt.network.v2020_03_01.models.HubIPAddresses
    :ivar ip_groups: IpGroups associated with AzureFirewall.
    :vartype ip_groups: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallIpGroups]
    :param sku: The Azure Firewall Resource SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.AzureFirewallSku
    :param additional_properties: The additional properties used to further config this azure
     firewall.
    :type additional_properties: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'hub_ip_addresses': {'readonly': True},
        'ip_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'etag': {'key': 'etag', 'type': 'str'},
        'application_rule_collections': {'key': 'properties.applicationRuleCollections', 'type': '[AzureFirewallApplicationRuleCollection]'},
        'nat_rule_collections': {'key': 'properties.natRuleCollections', 'type': '[AzureFirewallNatRuleCollection]'},
        'network_rule_collections': {'key': 'properties.networkRuleCollections', 'type': '[AzureFirewallNetworkRuleCollection]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[AzureFirewallIPConfiguration]'},
        'management_ip_configuration': {'key': 'properties.managementIpConfiguration', 'type': 'AzureFirewallIPConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'threat_intel_mode': {'key': 'properties.threatIntelMode', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'hub_ip_addresses': {'key': 'properties.hubIpAddresses', 'type': 'HubIPAddresses'},
        'ip_groups': {'key': 'properties.ipGroups', 'type': '[AzureFirewallIpGroups]'},
        'sku': {'key': 'properties.sku', 'type': 'AzureFirewallSku'},
        'additional_properties': {'key': 'properties.additionalProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewall, self).__init__(**kwargs)
        self.zones = kwargs.get('zones', None)
        self.etag = None
        self.application_rule_collections = kwargs.get('application_rule_collections', None)
        self.nat_rule_collections = kwargs.get('nat_rule_collections', None)
        self.network_rule_collections = kwargs.get('network_rule_collections', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.management_ip_configuration = kwargs.get('management_ip_configuration', None)
        self.provisioning_state = None
        self.threat_intel_mode = kwargs.get('threat_intel_mode', None)
        self.virtual_hub = kwargs.get('virtual_hub', None)
        self.firewall_policy = kwargs.get('firewall_policy', None)
        self.hub_ip_addresses = None
        self.ip_groups = None
        self.sku = kwargs.get('sku', None)
        self.additional_properties = kwargs.get('additional_properties', None)


class AzureFirewallApplicationRule(msrest.serialization.Model):
    """Properties of an application rule.

    :param name: Name of the application rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param protocols: Array of ApplicationRuleProtocols.
    :type protocols:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallApplicationRuleProtocol]
    :param target_fqdns: List of FQDNs for this rule.
    :type target_fqdns: list[str]
    :param fqdn_tags: List of FQDN Tags for this rule.
    :type fqdn_tags: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[AzureFirewallApplicationRuleProtocol]'},
        'target_fqdns': {'key': 'targetFqdns', 'type': '[str]'},
        'fqdn_tags': {'key': 'fqdnTags', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallApplicationRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.source_addresses = kwargs.get('source_addresses', None)
        self.protocols = kwargs.get('protocols', None)
        self.target_fqdns = kwargs.get('target_fqdns', None)
        self.fqdn_tags = kwargs.get('fqdn_tags', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)


class AzureFirewallApplicationRuleCollection(SubResource):
    """Application rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the Azure firewall. This name can
     be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param priority: Priority of the application rule collection resource.
    :type priority: int
    :param action: The action type of a rule collection.
    :type action: ~azure.mgmt.network.v2020_03_01.models.AzureFirewallRCAction
    :param rules: Collection of rules used by a application rule collection.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallApplicationRule]
    :ivar provisioning_state: The provisioning state of the application rule collection resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallApplicationRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallApplicationRuleCollection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.priority = kwargs.get('priority', None)
        self.action = kwargs.get('action', None)
        self.rules = kwargs.get('rules', None)
        self.provisioning_state = None


class AzureFirewallApplicationRuleProtocol(msrest.serialization.Model):
    """Properties of the application rule protocol.

    :param protocol_type: Protocol type. Possible values include: "Http", "Https", "Mssql".
    :type protocol_type: str or
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallApplicationRuleProtocolType
    :param port: Port number for the protocol, cannot be greater than 64000. This field is
     optional.
    :type port: int
    """

    _validation = {
        'port': {'maximum': 64000, 'minimum': 0},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallApplicationRuleProtocol, self).__init__(**kwargs)
        self.protocol_type = kwargs.get('protocol_type', None)
        self.port = kwargs.get('port', None)


class AzureFirewallFqdnTag(Resource):
    """Azure Firewall FQDN Tag Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the Azure firewall FQDN tag resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar fqdn_tag_name: The name of this FQDN Tag.
    :vartype fqdn_tag_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'fqdn_tag_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'fqdn_tag_name': {'key': 'properties.fqdnTagName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallFqdnTag, self).__init__(**kwargs)
        self.etag = None
        self.provisioning_state = None
        self.fqdn_tag_name = None


class AzureFirewallFqdnTagListResult(msrest.serialization.Model):
    """Response for ListAzureFirewallFqdnTags API service call.

    :param value: List of Azure Firewall FQDN Tags in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallFqdnTag]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AzureFirewallFqdnTag]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallFqdnTagListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AzureFirewallIPConfiguration(SubResource):
    """IP configuration of an Azure Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in
     User Defined Routes.
    :vartype private_ip_address: str
    :param subnet: Reference to the subnet resource. This resource must be named
     'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param public_ip_address: Reference to the PublicIP resource. This field is a mandatory input
     if subnet is not null.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the Azure firewall IP configuration
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.private_ip_address = None
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = None


class AzureFirewallIpGroups(msrest.serialization.Model):
    """IpGroups associated with azure firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar change_number: The iteration number.
    :vartype change_number: str
    """

    _validation = {
        'id': {'readonly': True},
        'change_number': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'change_number': {'key': 'changeNumber', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallIpGroups, self).__init__(**kwargs)
        self.id = None
        self.change_number = None


class AzureFirewallListResult(msrest.serialization.Model):
    """Response for ListAzureFirewalls API service call.

    :param value: List of Azure Firewalls in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewall]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AzureFirewall]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AzureFirewallNatRCAction(msrest.serialization.Model):
    """AzureFirewall NAT Rule Collection Action.

    :param type: The type of action. Possible values include: "Snat", "Dnat".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.AzureFirewallNatRCActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallNatRCAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class AzureFirewallNatRule(msrest.serialization.Model):
    """Properties of a NAT rule.

    :param name: Name of the NAT rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses for this rule. Supports IP
     ranges, prefixes, and service tags.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
    :type protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallNetworkRuleProtocol]
    :param translated_address: The translated address for this NAT rule.
    :type translated_address: str
    :param translated_port: The translated port for this NAT rule.
    :type translated_port: str
    :param translated_fqdn: The translated FQDN for this NAT rule.
    :type translated_fqdn: str
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'translated_address': {'key': 'translatedAddress', 'type': 'str'},
        'translated_port': {'key': 'translatedPort', 'type': 'str'},
        'translated_fqdn': {'key': 'translatedFqdn', 'type': 'str'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallNatRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.source_addresses = kwargs.get('source_addresses', None)
        self.destination_addresses = kwargs.get('destination_addresses', None)
        self.destination_ports = kwargs.get('destination_ports', None)
        self.protocols = kwargs.get('protocols', None)
        self.translated_address = kwargs.get('translated_address', None)
        self.translated_port = kwargs.get('translated_port', None)
        self.translated_fqdn = kwargs.get('translated_fqdn', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)


class AzureFirewallNatRuleCollection(SubResource):
    """NAT rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the Azure firewall. This name can
     be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param priority: Priority of the NAT rule collection resource.
    :type priority: int
    :param action: The action type of a NAT rule collection.
    :type action: ~azure.mgmt.network.v2020_03_01.models.AzureFirewallNatRCAction
    :param rules: Collection of rules used by a NAT rule collection.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallNatRule]
    :ivar provisioning_state: The provisioning state of the NAT rule collection resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallNatRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallNatRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallNatRuleCollection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.priority = kwargs.get('priority', None)
        self.action = kwargs.get('action', None)
        self.rules = kwargs.get('rules', None)
        self.provisioning_state = None


class AzureFirewallNetworkRule(msrest.serialization.Model):
    """Properties of the network rule.

    :param name: Name of the network rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param protocols: Array of AzureFirewallNetworkRuleProtocols.
    :type protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallNetworkRuleProtocol]
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param destination_fqdns: List of destination FQDNs.
    :type destination_fqdns: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    :param destination_ip_groups: List of destination IpGroups for this rule.
    :type destination_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'destination_fqdns': {'key': 'destinationFqdns', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
        'destination_ip_groups': {'key': 'destinationIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallNetworkRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.protocols = kwargs.get('protocols', None)
        self.source_addresses = kwargs.get('source_addresses', None)
        self.destination_addresses = kwargs.get('destination_addresses', None)
        self.destination_ports = kwargs.get('destination_ports', None)
        self.destination_fqdns = kwargs.get('destination_fqdns', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)
        self.destination_ip_groups = kwargs.get('destination_ip_groups', None)


class AzureFirewallNetworkRuleCollection(SubResource):
    """Network rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the Azure firewall. This name can
     be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param priority: Priority of the network rule collection resource.
    :type priority: int
    :param action: The action type of a rule collection.
    :type action: ~azure.mgmt.network.v2020_03_01.models.AzureFirewallRCAction
    :param rules: Collection of rules used by a network rule collection.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallNetworkRule]
    :ivar provisioning_state: The provisioning state of the network rule collection resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallNetworkRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallNetworkRuleCollection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.priority = kwargs.get('priority', None)
        self.action = kwargs.get('action', None)
        self.rules = kwargs.get('rules', None)
        self.provisioning_state = None


class AzureFirewallPublicIPAddress(msrest.serialization.Model):
    """Public IP Address associated with azure firewall.

    :param address: Public IP Address value.
    :type address: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallPublicIPAddress, self).__init__(**kwargs)
        self.address = kwargs.get('address', None)


class AzureFirewallRCAction(msrest.serialization.Model):
    """Properties of the AzureFirewallRCAction.

    :param type: The type of action. Possible values include: "Allow", "Deny".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.AzureFirewallRCActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallRCAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class AzureFirewallSku(msrest.serialization.Model):
    """SKU of an Azure Firewall.

    :param name: Name of an Azure Firewall SKU. Possible values include: "AZFW_VNet", "AZFW_Hub".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.AzureFirewallSkuName
    :param tier: Tier of an Azure Firewall. Possible values include: "Standard".
    :type tier: str or ~azure.mgmt.network.v2020_03_01.models.AzureFirewallSkuTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFirewallSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)


class AzureReachabilityReport(msrest.serialization.Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to Azure.

    :param aggregation_level: Required. The aggregation level of Azure reachability report. Can be
     Country, State or City.
    :type aggregation_level: str
    :param provider_location: Required. Parameters that define a geographic location.
    :type provider_location: ~azure.mgmt.network.v2020_03_01.models.AzureReachabilityReportLocation
    :param reachability_report: Required. List of Azure reachability report items.
    :type reachability_report:
     list[~azure.mgmt.network.v2020_03_01.models.AzureReachabilityReportItem]
    """

    _validation = {
        'aggregation_level': {'required': True},
        'provider_location': {'required': True},
        'reachability_report': {'required': True},
    }

    _attribute_map = {
        'aggregation_level': {'key': 'aggregationLevel', 'type': 'str'},
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'reachability_report': {'key': 'reachabilityReport', 'type': '[AzureReachabilityReportItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureReachabilityReport, self).__init__(**kwargs)
        self.aggregation_level = kwargs['aggregation_level']
        self.provider_location = kwargs['provider_location']
        self.reachability_report = kwargs['reachability_report']


class AzureReachabilityReportItem(msrest.serialization.Model):
    """Azure reachability report details for a given provider location.

    :param provider: The Internet service provider.
    :type provider: str
    :param azure_location: The Azure region.
    :type azure_location: str
    :param latencies: List of latency details for each of the time series.
    :type latencies:
     list[~azure.mgmt.network.v2020_03_01.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'azure_location': {'key': 'azureLocation', 'type': 'str'},
        'latencies': {'key': 'latencies', 'type': '[AzureReachabilityReportLatencyInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureReachabilityReportItem, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.azure_location = kwargs.get('azure_location', None)
        self.latencies = kwargs.get('latencies', None)


class AzureReachabilityReportLatencyInfo(msrest.serialization.Model):
    """Details on latency for a time series.

    :param time_stamp: The time stamp.
    :type time_stamp: ~datetime.datetime
    :param score: The relative latency score between 1 and 100, higher values indicating a faster
     connection.
    :type score: int
    """

    _validation = {
        'score': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'score': {'key': 'score', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureReachabilityReportLatencyInfo, self).__init__(**kwargs)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.score = kwargs.get('score', None)


class AzureReachabilityReportLocation(msrest.serialization.Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to Azure.

    :param country: Required. The name of the country.
    :type country: str
    :param state: The name of the state.
    :type state: str
    :param city: The name of the city or town.
    :type city: str
    """

    _validation = {
        'country': {'required': True},
    }

    _attribute_map = {
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureReachabilityReportLocation, self).__init__(**kwargs)
        self.country = kwargs['country']
        self.state = kwargs.get('state', None)
        self.city = kwargs.get('city', None)


class AzureReachabilityReportParameters(msrest.serialization.Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to Azure.

    :param provider_location: Required. Parameters that define a geographic location.
    :type provider_location: ~azure.mgmt.network.v2020_03_01.models.AzureReachabilityReportLocation
    :param providers: List of Internet service providers.
    :type providers: list[str]
    :param azure_locations: Optional Azure regions to scope the query to.
    :type azure_locations: list[str]
    :param start_time: Required. The start time for the Azure reachability report.
    :type start_time: ~datetime.datetime
    :param end_time: Required. The end time for the Azure reachability report.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'provider_location': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureReachabilityReportParameters, self).__init__(**kwargs)
        self.provider_location = kwargs['provider_location']
        self.providers = kwargs.get('providers', None)
        self.azure_locations = kwargs.get('azure_locations', None)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of backend address pools
     used by the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: An array of references to IP addresses defined in network
     interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar outbound_rule: A reference to an outbound rule that uses this backend address pool.
    :vartype outbound_rule: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar outbound_rules: An array of references to outbound rules that use this backend address
     pool.
    :vartype outbound_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'backend_ip_configurations': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'outbound_rule': {'readonly': True},
        'outbound_rules': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_rule': {'key': 'properties.outboundRule', 'type': 'SubResource'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendAddressPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_rule = None
        self.outbound_rules = None
        self.provisioning_state = None


class BastionActiveSession(msrest.serialization.Model):
    """The session detail for a target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar session_id: A unique id for the session.
    :vartype session_id: str
    :ivar start_time: The time when the session started.
    :vartype start_time: str
    :ivar target_subscription_id: The subscription id for the target virtual machine.
    :vartype target_subscription_id: str
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar target_host_name: The host name of the target.
    :vartype target_host_name: str
    :ivar target_resource_group: The resource group of the target.
    :vartype target_resource_group: str
    :ivar user_name: The user name who is active on this session.
    :vartype user_name: str
    :ivar target_ip_address: The IP Address of the target.
    :vartype target_ip_address: str
    :ivar protocol: The protocol used to connect to the target. Possible values include: "SSH",
     "RDP".
    :vartype protocol: str or ~azure.mgmt.network.v2020_03_01.models.BastionConnectProtocol
    :ivar target_resource_id: The resource id of the target.
    :vartype target_resource_id: str
    :ivar session_duration_in_mins: Duration in mins the session has been active.
    :vartype session_duration_in_mins: float
    """

    _validation = {
        'session_id': {'readonly': True},
        'start_time': {'readonly': True},
        'target_subscription_id': {'readonly': True},
        'resource_type': {'readonly': True},
        'target_host_name': {'readonly': True},
        'target_resource_group': {'readonly': True},
        'user_name': {'readonly': True},
        'target_ip_address': {'readonly': True},
        'protocol': {'readonly': True},
        'target_resource_id': {'readonly': True},
        'session_duration_in_mins': {'readonly': True},
    }

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'target_subscription_id': {'key': 'targetSubscriptionId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_host_name': {'key': 'targetHostName', 'type': 'str'},
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'target_ip_address': {'key': 'targetIpAddress', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'session_duration_in_mins': {'key': 'sessionDurationInMins', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionActiveSession, self).__init__(**kwargs)
        self.session_id = None
        self.start_time = None
        self.target_subscription_id = None
        self.resource_type = None
        self.target_host_name = None
        self.target_resource_group = None
        self.user_name = None
        self.target_ip_address = None
        self.protocol = None
        self.target_resource_id = None
        self.session_duration_in_mins = None


class BastionActiveSessionListResult(msrest.serialization.Model):
    """Response for GetActiveSessions.

    :param value: List of active sessions on the bastion.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BastionActiveSession]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BastionActiveSession]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionActiveSessionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BastionHost(Resource):
    """Bastion Host resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param ip_configurations: IP configuration of the Bastion Host resource.
    :type ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.BastionHostIPConfiguration]
    :param dns_name: FQDN for the endpoint on which bastion host is accessible.
    :type dns_name: str
    :ivar provisioning_state: The provisioning state of the bastion host resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[BastionHostIPConfiguration]'},
        'dns_name': {'key': 'properties.dnsName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionHost, self).__init__(**kwargs)
        self.etag = None
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.dns_name = kwargs.get('dns_name', None)
        self.provisioning_state = None


class BastionHostIPConfiguration(SubResource):
    """IP configuration of an Bastion Host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Ip configuration type.
    :vartype type: str
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the bastion host IP configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_ip_allocation_method: Private IP allocation method. Possible values include:
     "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionHostIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = None
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)


class BastionHostListResult(msrest.serialization.Model):
    """Response for ListBastionHosts API service call.

    :param value: List of Bastion Hosts in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BastionHost]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BastionHost]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionHostListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BastionSessionDeleteResult(msrest.serialization.Model):
    """Response for DisconnectActiveSessions.

    :param value: List of sessions with their corresponding state.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BastionSessionState]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BastionSessionState]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionSessionDeleteResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BastionSessionState(msrest.serialization.Model):
    """The session state detail for a target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar session_id: A unique id for the session.
    :vartype session_id: str
    :ivar message: Used for extra information.
    :vartype message: str
    :ivar state: The state of the session. Disconnected/Failed/NotFound.
    :vartype state: str
    """

    _validation = {
        'session_id': {'readonly': True},
        'message': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionSessionState, self).__init__(**kwargs)
        self.session_id = None
        self.message = None
        self.state = None


class BastionShareableLink(msrest.serialization.Model):
    """Bastion Shareable Link.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param vm: Required. Reference of the virtual machine resource.
    :type vm: ~azure.mgmt.network.v2020_03_01.models.VM
    :ivar bsl: The unique Bastion Shareable Link to the virtual machine.
    :vartype bsl: str
    :ivar created_at: The time when the link was created.
    :vartype created_at: str
    :ivar message: Optional field indicating the warning or error message related to the vm in case
     of partial failure.
    :vartype message: str
    """

    _validation = {
        'vm': {'required': True},
        'bsl': {'readonly': True},
        'created_at': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'vm': {'key': 'vm', 'type': 'VM'},
        'bsl': {'key': 'bsl', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionShareableLink, self).__init__(**kwargs)
        self.vm = kwargs['vm']
        self.bsl = None
        self.created_at = None
        self.message = None


class BastionShareableLinkListRequest(msrest.serialization.Model):
    """Post request for all the Bastion Shareable Link endpoints.

    :param vms: List of VM references.
    :type vms: list[~azure.mgmt.network.v2020_03_01.models.BastionShareableLink]
    """

    _attribute_map = {
        'vms': {'key': 'vms', 'type': '[BastionShareableLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionShareableLinkListRequest, self).__init__(**kwargs)
        self.vms = kwargs.get('vms', None)


class BastionShareableLinkListResult(msrest.serialization.Model):
    """Response for all the Bastion Shareable Link endpoints.

    :param value: List of Bastion Shareable Links for the request.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BastionShareableLink]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BastionShareableLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BastionShareableLinkListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BGPCommunity(msrest.serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :param service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :type service_supported_region: str
    :param community_name: The name of the bgp community. e.g. Skype.
    :type community_name: str
    :param community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :type community_value: str
    :param community_prefixes: The prefixes that the bgp community contains.
    :type community_prefixes: list[str]
    :param is_authorized_to_use: Customer is authorized to use bgp community or not.
    :type is_authorized_to_use: bool
    :param service_group: The service group of the bgp community contains.
    :type service_group: str
    """

    _attribute_map = {
        'service_supported_region': {'key': 'serviceSupportedRegion', 'type': 'str'},
        'community_name': {'key': 'communityName', 'type': 'str'},
        'community_value': {'key': 'communityValue', 'type': 'str'},
        'community_prefixes': {'key': 'communityPrefixes', 'type': '[str]'},
        'is_authorized_to_use': {'key': 'isAuthorizedToUse', 'type': 'bool'},
        'service_group': {'key': 'serviceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BGPCommunity, self).__init__(**kwargs)
        self.service_supported_region = kwargs.get('service_supported_region', None)
        self.community_name = kwargs.get('community_name', None)
        self.community_value = kwargs.get('community_value', None)
        self.community_prefixes = kwargs.get('community_prefixes', None)
        self.is_authorized_to_use = kwargs.get('is_authorized_to_use', None)
        self.service_group = kwargs.get('service_group', None)


class BgpPeerStatus(msrest.serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Possible values include: "Unknown", "Stopped", "Idle",
     "Connecting", "Connected".
    :vartype state: str or ~azure.mgmt.network.v2020_03_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: long
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: long
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: long
    """

    _validation = {
        'local_address': {'readonly': True},
        'neighbor': {'readonly': True},
        'asn': {'readonly': True},
        'state': {'readonly': True},
        'connected_duration': {'readonly': True},
        'routes_received': {'readonly': True},
        'messages_sent': {'readonly': True},
        'messages_received': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'connected_duration': {'key': 'connectedDuration', 'type': 'str'},
        'routes_received': {'key': 'routesReceived', 'type': 'long'},
        'messages_sent': {'key': 'messagesSent', 'type': 'long'},
        'messages_received': {'key': 'messagesReceived', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpPeerStatus, self).__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(msrest.serialization.Model):
    """Response for list BGP peer status API service call.

    :param value: List of BGP peers.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpPeerStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpPeerStatusListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param service_name: The name of the bgp community. e.g. Skype.
    :type service_name: str
    :param bgp_communities: A list of bgp communities.
    :type bgp_communities: list[~azure.mgmt.network.v2020_03_01.models.BGPCommunity]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': '[BGPCommunity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpServiceCommunity, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.bgp_communities = kwargs.get('bgp_communities', None)


class BgpServiceCommunityListResult(msrest.serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :param value: A list of service community resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BgpServiceCommunity]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpServiceCommunity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpServiceCommunityListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BgpSettings(msrest.serialization.Model):
    """BGP settings details.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :type bgp_peering_address: str
    :param peer_weight: The weight added to routes learned from this BGP speaker.
    :type peer_weight: int
    :param bgp_peering_addresses: BGP peering address with IP configuration ID for virtual network
     gateway.
    :type bgp_peering_addresses:
     list[~azure.mgmt.network.v2020_03_01.models.IPConfigurationBgpPeeringAddress]
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
        'bgp_peering_addresses': {'key': 'bgpPeeringAddresses', 'type': '[IPConfigurationBgpPeeringAddress]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = kwargs.get('asn', None)
        self.bgp_peering_address = kwargs.get('bgp_peering_address', None)
        self.peer_weight = kwargs.get('peer_weight', None)
        self.bgp_peering_addresses = kwargs.get('bgp_peering_addresses', None)


class CheckPrivateLinkServiceVisibilityRequest(msrest.serialization.Model):
    """Request body of the CheckPrivateLinkServiceVisibility API service call.

    :param private_link_service_alias: The alias of the private link service.
    :type private_link_service_alias: str
    """

    _attribute_map = {
        'private_link_service_alias': {'key': 'privateLinkServiceAlias', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckPrivateLinkServiceVisibilityRequest, self).__init__(**kwargs)
        self.private_link_service_alias = kwargs.get('private_link_service_alias', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.network.v2020_03_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ConnectionMonitor(msrest.serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    :param location: Connection monitor location.
    :type location: str
    :param tags: A set of tags. Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSource
    :param destination: Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param endpoints: List of connection monitor endpoints.
    :type endpoints: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpoint]
    :param test_configurations: List of connection monitor test configurations.
    :type test_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestConfiguration]
    :param test_groups: List of connection monitor test groups.
    :type test_groups: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestGroup]
    :param outputs: List of connection monitor outputs.
    :type outputs: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorOutput]
    :param notes: Optional notes to be associated with the connection monitor.
    :type notes: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[ConnectionMonitorEndpoint]'},
        'test_configurations': {'key': 'properties.testConfigurations', 'type': '[ConnectionMonitorTestConfiguration]'},
        'test_groups': {'key': 'properties.testGroups', 'type': '[ConnectionMonitorTestGroup]'},
        'outputs': {'key': 'properties.outputs', 'type': '[ConnectionMonitorOutput]'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitor, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.source = kwargs.get('source', None)
        self.destination = kwargs.get('destination', None)
        self.auto_start = kwargs.get('auto_start', True)
        self.monitoring_interval_in_seconds = kwargs.get('monitoring_interval_in_seconds', 60)
        self.endpoints = kwargs.get('endpoints', None)
        self.test_configurations = kwargs.get('test_configurations', None)
        self.test_groups = kwargs.get('test_groups', None)
        self.outputs = kwargs.get('outputs', None)
        self.notes = kwargs.get('notes', None)


class ConnectionMonitorDestination(msrest.serialization.Model):
    """Describes the destination of connection monitor.

    :param resource_id: The ID of the resource used as the destination by connection monitor.
    :type resource_id: str
    :param address: Address of the connection monitor destination (IP or domain name).
    :type address: str
    :param port: The destination port used by connection monitor.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.address = kwargs.get('address', None)
        self.port = kwargs.get('port', None)


class ConnectionMonitorEndpoint(msrest.serialization.Model):
    """Describes the connection monitor endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the connection monitor endpoint.
    :type name: str
    :param resource_id: Resource ID of the connection monitor endpoint.
    :type resource_id: str
    :param address: Address of the connection monitor endpoint (IP or domain name).
    :type address: str
    :param filter: Filter for sub-items within the endpoint.
    :type filter: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpointFilter
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'ConnectionMonitorEndpointFilter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorEndpoint, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.resource_id = kwargs.get('resource_id', None)
        self.address = kwargs.get('address', None)
        self.filter = kwargs.get('filter', None)


class ConnectionMonitorEndpointFilter(msrest.serialization.Model):
    """Describes the connection monitor endpoint filter.

    :param type: The behavior of the endpoint filter. Currently only 'Include' is supported.
     Possible values include: "Include".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpointFilterType
    :param items: List of items in the filter.
    :type items: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpointFilterItem]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'items': {'key': 'items', 'type': '[ConnectionMonitorEndpointFilterItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorEndpointFilter, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.items = kwargs.get('items', None)


class ConnectionMonitorEndpointFilterItem(msrest.serialization.Model):
    """Describes the connection monitor endpoint filter item.

    :param type: The type of item included in the filter. Currently only 'AgentAddress' is
     supported. Possible values include: "AgentAddress".
    :type type: str or
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpointFilterItemType
    :param address: The address of the filter item.
    :type address: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorEndpointFilterItem, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.address = kwargs.get('address', None)


class ConnectionMonitorHttpConfiguration(msrest.serialization.Model):
    """Describes the HTTP configuration.

    :param port: The port to connect to.
    :type port: int
    :param method: The HTTP method to use. Possible values include: "Get", "Post".
    :type method: str or ~azure.mgmt.network.v2020_03_01.models.HTTPConfigurationMethod
    :param path: The path component of the URI. For instance, "/dir1/dir2".
    :type path: str
    :param request_headers: The HTTP headers to transmit with the request.
    :type request_headers: list[~azure.mgmt.network.v2020_03_01.models.HTTPHeader]
    :param valid_status_code_ranges: HTTP status codes to consider successful. For instance,
     "2xx,301-304,418".
    :type valid_status_code_ranges: list[str]
    :param prefer_https: Value indicating whether HTTPS is preferred over HTTP in cases where the
     choice is not explicit.
    :type prefer_https: bool
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
        'method': {'key': 'method', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'request_headers': {'key': 'requestHeaders', 'type': '[HTTPHeader]'},
        'valid_status_code_ranges': {'key': 'validStatusCodeRanges', 'type': '[str]'},
        'prefer_https': {'key': 'preferHTTPS', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorHttpConfiguration, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)
        self.method = kwargs.get('method', None)
        self.path = kwargs.get('path', None)
        self.request_headers = kwargs.get('request_headers', None)
        self.valid_status_code_ranges = kwargs.get('valid_status_code_ranges', None)
        self.prefer_https = kwargs.get('prefer_https', None)


class ConnectionMonitorIcmpConfiguration(msrest.serialization.Model):
    """Describes the ICMP configuration.

    :param disable_trace_route: Value indicating whether path evaluation with trace route should be
     disabled.
    :type disable_trace_route: bool
    """

    _attribute_map = {
        'disable_trace_route': {'key': 'disableTraceRoute', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorIcmpConfiguration, self).__init__(**kwargs)
        self.disable_trace_route = kwargs.get('disable_trace_route', None)


class ConnectionMonitorListResult(msrest.serialization.Model):
    """List of connection monitors.

    :param value: Information about connection monitors.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectionMonitorResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ConnectionMonitorOutput(msrest.serialization.Model):
    """Describes a connection monitor output destination.

    :param type: Connection monitor output destination type. Currently, only "Workspace" is
     supported. Possible values include: "Workspace".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.OutputType
    :param workspace_settings: Describes the settings for producing output into a log analytics
     workspace.
    :type workspace_settings:
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorWorkspaceSettings
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'workspace_settings': {'key': 'workspaceSettings', 'type': 'ConnectionMonitorWorkspaceSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorOutput, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.workspace_settings = kwargs.get('workspace_settings', None)


class ConnectionMonitorParameters(msrest.serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    :param source: Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSource
    :param destination: Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param endpoints: List of connection monitor endpoints.
    :type endpoints: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpoint]
    :param test_configurations: List of connection monitor test configurations.
    :type test_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestConfiguration]
    :param test_groups: List of connection monitor test groups.
    :type test_groups: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestGroup]
    :param outputs: List of connection monitor outputs.
    :type outputs: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorOutput]
    :param notes: Optional notes to be associated with the connection monitor.
    :type notes: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'monitoringIntervalInSeconds', 'type': 'int'},
        'endpoints': {'key': 'endpoints', 'type': '[ConnectionMonitorEndpoint]'},
        'test_configurations': {'key': 'testConfigurations', 'type': '[ConnectionMonitorTestConfiguration]'},
        'test_groups': {'key': 'testGroups', 'type': '[ConnectionMonitorTestGroup]'},
        'outputs': {'key': 'outputs', 'type': '[ConnectionMonitorOutput]'},
        'notes': {'key': 'notes', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorParameters, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.destination = kwargs.get('destination', None)
        self.auto_start = kwargs.get('auto_start', True)
        self.monitoring_interval_in_seconds = kwargs.get('monitoring_interval_in_seconds', 60)
        self.endpoints = kwargs.get('endpoints', None)
        self.test_configurations = kwargs.get('test_configurations', None)
        self.test_groups = kwargs.get('test_groups', None)
        self.outputs = kwargs.get('outputs', None)
        self.notes = kwargs.get('notes', None)


class ConnectionMonitorQueryResult(msrest.serialization.Model):
    """List of connection states snapshots.

    :param source_status: Status of connection monitor source. Possible values include: "Unknown",
     "Active", "Inactive".
    :type source_status: str or
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSourceStatus
    :param states: Information about connection states.
    :type states: list[~azure.mgmt.network.v2020_03_01.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        'source_status': {'key': 'sourceStatus', 'type': 'str'},
        'states': {'key': 'states', 'type': '[ConnectionStateSnapshot]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorQueryResult, self).__init__(**kwargs)
        self.source_status = kwargs.get('source_status', None)
        self.states = kwargs.get('states', None)


class ConnectionMonitorResult(msrest.serialization.Model):
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :param location: Connection monitor location.
    :type location: str
    :param tags: A set of tags. Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSource
    :param destination: Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param endpoints: List of connection monitor endpoints.
    :type endpoints: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpoint]
    :param test_configurations: List of connection monitor test configurations.
    :type test_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestConfiguration]
    :param test_groups: List of connection monitor test groups.
    :type test_groups: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestGroup]
    :param outputs: List of connection monitor outputs.
    :type outputs: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorOutput]
    :param notes: Optional notes to be associated with the connection monitor.
    :type notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Possible values include:
     "MultiEndpoint", "SingleSourceDestination".
    :vartype connection_monitor_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorType
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'monitoring_status': {'readonly': True},
        'connection_monitor_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[ConnectionMonitorEndpoint]'},
        'test_configurations': {'key': 'properties.testConfigurations', 'type': '[ConnectionMonitorTestConfiguration]'},
        'test_groups': {'key': 'properties.testGroups', 'type': '[ConnectionMonitorTestGroup]'},
        'outputs': {'key': 'properties.outputs', 'type': '[ConnectionMonitorOutput]'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
        'connection_monitor_type': {'key': 'properties.connectionMonitorType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.source = kwargs.get('source', None)
        self.destination = kwargs.get('destination', None)
        self.auto_start = kwargs.get('auto_start', True)
        self.monitoring_interval_in_seconds = kwargs.get('monitoring_interval_in_seconds', 60)
        self.endpoints = kwargs.get('endpoints', None)
        self.test_configurations = kwargs.get('test_configurations', None)
        self.test_groups = kwargs.get('test_groups', None)
        self.outputs = kwargs.get('outputs', None)
        self.notes = kwargs.get('notes', None)
        self.provisioning_state = None
        self.start_time = None
        self.monitoring_status = None
        self.connection_monitor_type = None


class ConnectionMonitorResultProperties(ConnectionMonitorParameters):
    """Describes the properties of a connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param source: Describes the source of connection monitor.
    :type source: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSource
    :param destination: Describes the destination of connection monitor.
    :type destination: ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start automatically once created.
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
    :type monitoring_interval_in_seconds: int
    :param endpoints: List of connection monitor endpoints.
    :type endpoints: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorEndpoint]
    :param test_configurations: List of connection monitor test configurations.
    :type test_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestConfiguration]
    :param test_groups: List of connection monitor test groups.
    :type test_groups: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestGroup]
    :param outputs: List of connection monitor outputs.
    :type outputs: list[~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorOutput]
    :param notes: Optional notes to be associated with the connection monitor.
    :type notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Possible values include:
     "MultiEndpoint", "SingleSourceDestination".
    :vartype connection_monitor_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorType
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'monitoring_status': {'readonly': True},
        'connection_monitor_type': {'readonly': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'monitoringIntervalInSeconds', 'type': 'int'},
        'endpoints': {'key': 'endpoints', 'type': '[ConnectionMonitorEndpoint]'},
        'test_configurations': {'key': 'testConfigurations', 'type': '[ConnectionMonitorTestConfiguration]'},
        'test_groups': {'key': 'testGroups', 'type': '[ConnectionMonitorTestGroup]'},
        'outputs': {'key': 'outputs', 'type': '[ConnectionMonitorOutput]'},
        'notes': {'key': 'notes', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'monitoring_status': {'key': 'monitoringStatus', 'type': 'str'},
        'connection_monitor_type': {'key': 'connectionMonitorType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorResultProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.start_time = None
        self.monitoring_status = None
        self.connection_monitor_type = None


class ConnectionMonitorSource(msrest.serialization.Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource used as the source by connection monitor.
    :type resource_id: str
    :param port: The source port used by connection monitor.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorSource, self).__init__(**kwargs)
        self.resource_id = kwargs['resource_id']
        self.port = kwargs.get('port', None)


class ConnectionMonitorSuccessThreshold(msrest.serialization.Model):
    """Describes the threshold for declaring a test successful.

    :param checks_failed_percent: The maximum percentage of failed checks permitted for a test to
     evaluate as successful.
    :type checks_failed_percent: int
    :param round_trip_time_ms: The maximum round-trip time in milliseconds permitted for a test to
     evaluate as successful.
    :type round_trip_time_ms: int
    """

    _attribute_map = {
        'checks_failed_percent': {'key': 'checksFailedPercent', 'type': 'int'},
        'round_trip_time_ms': {'key': 'roundTripTimeMs', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorSuccessThreshold, self).__init__(**kwargs)
        self.checks_failed_percent = kwargs.get('checks_failed_percent', None)
        self.round_trip_time_ms = kwargs.get('round_trip_time_ms', None)


class ConnectionMonitorTcpConfiguration(msrest.serialization.Model):
    """Describes the TCP configuration.

    :param port: The port to connect to.
    :type port: int
    :param disable_trace_route: Value indicating whether path evaluation with trace route should be
     disabled.
    :type disable_trace_route: bool
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
        'disable_trace_route': {'key': 'disableTraceRoute', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorTcpConfiguration, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)
        self.disable_trace_route = kwargs.get('disable_trace_route', None)


class ConnectionMonitorTestConfiguration(msrest.serialization.Model):
    """Describes a connection monitor test configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the connection monitor test configuration.
    :type name: str
    :param test_frequency_sec: The frequency of test evaluation, in seconds.
    :type test_frequency_sec: int
    :param protocol: Required. The protocol to use in test evaluation. Possible values include:
     "Tcp", "Http", "Icmp".
    :type protocol: str or
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTestConfigurationProtocol
    :param preferred_ip_version: The preferred IP version to use in test evaluation. The connection
     monitor may choose to use a different version depending on other parameters. Possible values
     include: "IPv4", "IPv6".
    :type preferred_ip_version: str or ~azure.mgmt.network.v2020_03_01.models.PreferredIPVersion
    :param http_configuration: The parameters used to perform test evaluation over HTTP.
    :type http_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorHttpConfiguration
    :param tcp_configuration: The parameters used to perform test evaluation over TCP.
    :type tcp_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorTcpConfiguration
    :param icmp_configuration: The parameters used to perform test evaluation over ICMP.
    :type icmp_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorIcmpConfiguration
    :param success_threshold: The threshold for declaring a test successful.
    :type success_threshold:
     ~azure.mgmt.network.v2020_03_01.models.ConnectionMonitorSuccessThreshold
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'test_frequency_sec': {'key': 'testFrequencySec', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'preferred_ip_version': {'key': 'preferredIPVersion', 'type': 'str'},
        'http_configuration': {'key': 'httpConfiguration', 'type': 'ConnectionMonitorHttpConfiguration'},
        'tcp_configuration': {'key': 'tcpConfiguration', 'type': 'ConnectionMonitorTcpConfiguration'},
        'icmp_configuration': {'key': 'icmpConfiguration', 'type': 'ConnectionMonitorIcmpConfiguration'},
        'success_threshold': {'key': 'successThreshold', 'type': 'ConnectionMonitorSuccessThreshold'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorTestConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.test_frequency_sec = kwargs.get('test_frequency_sec', None)
        self.protocol = kwargs['protocol']
        self.preferred_ip_version = kwargs.get('preferred_ip_version', None)
        self.http_configuration = kwargs.get('http_configuration', None)
        self.tcp_configuration = kwargs.get('tcp_configuration', None)
        self.icmp_configuration = kwargs.get('icmp_configuration', None)
        self.success_threshold = kwargs.get('success_threshold', None)


class ConnectionMonitorTestGroup(msrest.serialization.Model):
    """Describes the connection monitor test group.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the connection monitor test group.
    :type name: str
    :param disable: Value indicating whether test group is disabled.
    :type disable: bool
    :param test_configurations: Required. List of test configuration names.
    :type test_configurations: list[str]
    :param sources: Required. List of source endpoint names.
    :type sources: list[str]
    :param destinations: Required. List of destination endpoint names.
    :type destinations: list[str]
    """

    _validation = {
        'name': {'required': True},
        'test_configurations': {'required': True},
        'sources': {'required': True},
        'destinations': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disable': {'key': 'disable', 'type': 'bool'},
        'test_configurations': {'key': 'testConfigurations', 'type': '[str]'},
        'sources': {'key': 'sources', 'type': '[str]'},
        'destinations': {'key': 'destinations', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorTestGroup, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.disable = kwargs.get('disable', None)
        self.test_configurations = kwargs['test_configurations']
        self.sources = kwargs['sources']
        self.destinations = kwargs['destinations']


class ConnectionMonitorWorkspaceSettings(msrest.serialization.Model):
    """Describes the settings for producing output into a log analytics workspace.

    :param workspace_resource_id: Log analytics workspace resource ID.
    :type workspace_resource_id: str
    """

    _attribute_map = {
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionMonitorWorkspaceSettings, self).__init__(**kwargs)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)


class ConnectionResetSharedKey(msrest.serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :param key_length: Required. The virtual network connection reset shared key length, should
     between 1 and 128.
    :type key_length: int
    """

    _validation = {
        'key_length': {'required': True, 'maximum': 128, 'minimum': 1},
    }

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = kwargs['key_length']


class ConnectionSharedKey(SubResource):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param value: Required. The virtual network connection shared key value.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionSharedKey, self).__init__(**kwargs)
        self.value = kwargs['value']


class ConnectionStateSnapshot(msrest.serialization.Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param connection_state: The connection state. Possible values include: "Reachable",
     "Unreachable", "Unknown".
    :type connection_state: str or ~azure.mgmt.network.v2020_03_01.models.ConnectionState
    :param start_time: The start time of the connection snapshot.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the connection snapshot.
    :type end_time: ~datetime.datetime
    :param evaluation_state: Connectivity analysis evaluation state. Possible values include:
     "NotStarted", "InProgress", "Completed".
    :type evaluation_state: str or ~azure.mgmt.network.v2020_03_01.models.EvaluationState
    :param avg_latency_in_ms: Average latency in ms.
    :type avg_latency_in_ms: int
    :param min_latency_in_ms: Minimum latency in ms.
    :type min_latency_in_ms: int
    :param max_latency_in_ms: Maximum latency in ms.
    :type max_latency_in_ms: int
    :param probes_sent: The number of sent probes.
    :type probes_sent: int
    :param probes_failed: The number of failed probes.
    :type probes_failed: int
    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2020_03_01.models.ConnectivityHop]
    """

    _validation = {
        'hops': {'readonly': True},
    }

    _attribute_map = {
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'evaluation_state': {'key': 'evaluationState', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionStateSnapshot, self).__init__(**kwargs)
        self.connection_state = kwargs.get('connection_state', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.evaluation_state = kwargs.get('evaluation_state', None)
        self.avg_latency_in_ms = kwargs.get('avg_latency_in_ms', None)
        self.min_latency_in_ms = kwargs.get('min_latency_in_ms', None)
        self.max_latency_in_ms = kwargs.get('max_latency_in_ms', None)
        self.probes_sent = kwargs.get('probes_sent', None)
        self.probes_failed = kwargs.get('probes_failed', None)
        self.hops = None


class ConnectivityDestination(msrest.serialization.Model):
    """Parameters that define destination of connection.

    :param resource_id: The ID of the resource to which a connection attempt will be made.
    :type resource_id: str
    :param address: The IP address or URI the resource to which a connection attempt will be made.
    :type address: str
    :param port: Port on which check connectivity will be performed.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.address = kwargs.get('address', None)
        self.port = kwargs.get('port', None)


class ConnectivityHop(msrest.serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.v2020_03_01.models.ConnectivityIssue]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'address': {'readonly': True},
        'resource_id': {'readonly': True},
        'next_hop_ids': {'readonly': True},
        'issues': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'next_hop_ids': {'key': 'nextHopIds', 'type': '[str]'},
        'issues': {'key': 'issues', 'type': '[ConnectivityIssue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityHop, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(msrest.serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2020_03_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Possible values include: "Unknown",
     "Connected", "Disconnected", "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.v2020_03_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        'hops': {'readonly': True},
        'connection_status': {'readonly': True},
        'avg_latency_in_ms': {'readonly': True},
        'min_latency_in_ms': {'readonly': True},
        'max_latency_in_ms': {'readonly': True},
        'probes_sent': {'readonly': True},
        'probes_failed': {'readonly': True},
    }

    _attribute_map = {
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityInformation, self).__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(msrest.serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Possible values include: "Local", "Inbound", "Outbound".
    :vartype origin: str or ~azure.mgmt.network.v2020_03_01.models.Origin
    :ivar severity: The severity of the issue. Possible values include: "Error", "Warning".
    :vartype severity: str or ~azure.mgmt.network.v2020_03_01.models.Severity
    :ivar type: The type of issue. Possible values include: "Unknown", "AgentStopped",
     "GuestFirewall", "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute",
     "PortThrottled", "Platform".
    :vartype type: str or ~azure.mgmt.network.v2020_03_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        'origin': {'readonly': True},
        'severity': {'readonly': True},
        'type': {'readonly': True},
        'context': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'context': {'key': 'context', 'type': '[{str}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityIssue, self).__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(msrest.serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the connection.
    :type source: ~azure.mgmt.network.v2020_03_01.models.ConnectivitySource
    :param destination: Required. The destination of connection.
    :type destination: ~azure.mgmt.network.v2020_03_01.models.ConnectivityDestination
    :param protocol: Network protocol. Possible values include: "Tcp", "Http", "Https", "Icmp".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.Protocol
    :param protocol_configuration: Configuration of the protocol.
    :type protocol_configuration: ~azure.mgmt.network.v2020_03_01.models.ProtocolConfiguration
    :param preferred_ip_version: Preferred IP version of the connection. Possible values include:
     "IPv4", "IPv6".
    :type preferred_ip_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectivitySource'},
        'destination': {'key': 'destination', 'type': 'ConnectivityDestination'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'protocol_configuration': {'key': 'protocolConfiguration', 'type': 'ProtocolConfiguration'},
        'preferred_ip_version': {'key': 'preferredIPVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityParameters, self).__init__(**kwargs)
        self.source = kwargs['source']
        self.destination = kwargs['destination']
        self.protocol = kwargs.get('protocol', None)
        self.protocol_configuration = kwargs.get('protocol_configuration', None)
        self.preferred_ip_version = kwargs.get('preferred_ip_version', None)


class ConnectivitySource(msrest.serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource from which a connectivity check will be
     initiated.
    :type resource_id: str
    :param port: The source port from which a connectivity check will be performed.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivitySource, self).__init__(**kwargs)
        self.resource_id = kwargs['resource_id']
        self.port = kwargs.get('port', None)


class Container(SubResource):
    """Reference to container resource in remote resource provider.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Container, self).__init__(**kwargs)


class ContainerNetworkInterface(SubResource):
    """Container network interface child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource. This name can be used to access the resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interface_configuration: Container network interface configuration from
     which this container network interface is created.
    :vartype container_network_interface_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ContainerNetworkInterfaceConfiguration
    :param container: Reference to the container to which this container network interface is
     attached.
    :type container: ~azure.mgmt.network.v2020_03_01.models.Container
    :ivar ip_configurations: Reference to the ip configuration on this container nic.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ContainerNetworkInterfaceIpConfiguration]
    :ivar provisioning_state: The provisioning state of the container network interface resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'container_network_interface_configuration': {'readonly': True},
        'ip_configurations': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'container_network_interface_configuration': {'key': 'properties.containerNetworkInterfaceConfiguration', 'type': 'ContainerNetworkInterfaceConfiguration'},
        'container': {'key': 'properties.container', 'type': 'Container'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[ContainerNetworkInterfaceIpConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerNetworkInterface, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.container_network_interface_configuration = None
        self.container = kwargs.get('container', None)
        self.ip_configurations = None
        self.provisioning_state = None


class ContainerNetworkInterfaceConfiguration(SubResource):
    """Container network interface configuration child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource. This name can be used to access the resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param ip_configurations: A list of ip configurations of the container network interface
     configuration.
    :type ip_configurations: list[~azure.mgmt.network.v2020_03_01.models.IPConfigurationProfile]
    :param container_network_interfaces: A list of container network interfaces created from this
     container network interface configuration.
    :type container_network_interfaces: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the container network interface
     configuration resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfigurationProfile]'},
        'container_network_interfaces': {'key': 'properties.containerNetworkInterfaces', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerNetworkInterfaceConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.container_network_interfaces = kwargs.get('container_network_interfaces', None)
        self.provisioning_state = None


class ContainerNetworkInterfaceIpConfiguration(msrest.serialization.Model):
    """The ip configuration for a container network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The name of the resource. This name can be used to access the resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the container network interface IP
     configuration resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerNetworkInterfaceIpConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.provisioning_state = None


class CustomDnsConfigPropertiesFormat(msrest.serialization.Model):
    """Contains custom Dns resolution configuration from customer.

    :param fqdn: Fqdn that resolves to private endpoint ip address.
    :type fqdn: str
    :param ip_addresses: A list of private ip addresses of the private endpoint.
    :type ip_addresses: list[str]
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDnsConfigPropertiesFormat, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)


class DdosCustomPolicy(Resource):
    """A DDoS custom policy in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS custom policy resource. It uniquely
     identifies the resource, even if the user changes its name or migrate the resource across
     subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS custom policy resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar public_ip_addresses: The list of public IPs associated with the DDoS custom policy
     resource. This list is read-only.
    :vartype public_ip_addresses: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param protocol_custom_settings: The protocol-specific DDoS policy customization parameters.
    :type protocol_custom_settings:
     list[~azure.mgmt.network.v2020_03_01.models.ProtocolCustomSettingsFormat]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[SubResource]'},
        'protocol_custom_settings': {'key': 'properties.protocolCustomSettings', 'type': '[ProtocolCustomSettingsFormat]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DdosCustomPolicy, self).__init__(**kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None
        self.public_ip_addresses = None
        self.protocol_custom_settings = kwargs.get('protocol_custom_settings', None)


class DdosProtectionPlan(msrest.serialization.Model):
    """A DDoS protection plan in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS protection plan resource. It
     uniquely identifies the resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS protection plan resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar virtual_networks: The list of virtual networks associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype virtual_networks: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'virtual_networks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DdosProtectionPlan, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None
        self.virtual_networks = None


class DdosProtectionPlanListResult(msrest.serialization.Model):
    """A list of DDoS protection plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of DDoS protection plans.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.DdosProtectionPlan]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DdosProtectionPlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DdosProtectionPlanListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class DdosSettings(msrest.serialization.Model):
    """Contains the DDoS protection settings of the public IP.

    :param ddos_custom_policy: The DDoS custom policy associated with the public IP.
    :type ddos_custom_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param protection_coverage: The DDoS protection policy customizability of the public IP. Only
     standard coverage will have the ability to be customized. Possible values include: "Basic",
     "Standard".
    :type protection_coverage: str or
     ~azure.mgmt.network.v2020_03_01.models.DdosSettingsProtectionCoverage
    :param protected_ip: Enables DDoS protection on the public IP.
    :type protected_ip: bool
    """

    _attribute_map = {
        'ddos_custom_policy': {'key': 'ddosCustomPolicy', 'type': 'SubResource'},
        'protection_coverage': {'key': 'protectionCoverage', 'type': 'str'},
        'protected_ip': {'key': 'protectedIP', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DdosSettings, self).__init__(**kwargs)
        self.ddos_custom_policy = kwargs.get('ddos_custom_policy', None)
        self.protection_coverage = kwargs.get('protection_coverage', None)
        self.protected_ip = kwargs.get('protected_ip', None)


class Delegation(SubResource):
    """Details the service to which the subnet is delegated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a subnet. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param service_name: The name of the service to whom the subnet should be delegated (e.g.
     Microsoft.Sql/servers).
    :type service_name: str
    :ivar actions: The actions permitted to the service upon delegation.
    :vartype actions: list[str]
    :ivar provisioning_state: The provisioning state of the service delegation resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'actions': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Delegation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.service_name = kwargs.get('service_name', None)
        self.actions = None
        self.provisioning_state = None


class DeviceProperties(msrest.serialization.Model):
    """List of properties of the device.

    :param device_vendor: Name of the device Vendor.
    :type device_vendor: str
    :param device_model: Model of the device.
    :type device_model: str
    :param link_speed_in_mbps: Link speed.
    :type link_speed_in_mbps: int
    """

    _attribute_map = {
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_model': {'key': 'deviceModel', 'type': 'str'},
        'link_speed_in_mbps': {'key': 'linkSpeedInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeviceProperties, self).__init__(**kwargs)
        self.device_vendor = kwargs.get('device_vendor', None)
        self.device_model = kwargs.get('device_model', None)
        self.link_speed_in_mbps = kwargs.get('link_speed_in_mbps', None)


class DhcpOptions(msrest.serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)


class Dimension(msrest.serialization.Model):
    """Dimension of the metric.

    :param name: The name of the dimension.
    :type name: str
    :param display_name: The display name of the dimension.
    :type display_name: str
    :param internal_name: The internal name of the dimension.
    :type internal_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.internal_name = kwargs.get('internal_name', None)


class DnsNameAvailabilityResult(msrest.serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)


class EffectiveNetworkSecurityGroup(msrest.serialization.Model):
    """Effective network security group.

    :param network_security_group: The ID of network security group that is applied.
    :type network_security_group: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param association: Associated resources.
    :type association:
     ~azure.mgmt.network.v2020_03_01.models.EffectiveNetworkSecurityGroupAssociation
    :param effective_security_rules: A collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2020_03_01.models.EffectiveNetworkSecurityRule]
    :param tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :type tag_map: str
    """

    _attribute_map = {
        'network_security_group': {'key': 'networkSecurityGroup', 'type': 'SubResource'},
        'association': {'key': 'association', 'type': 'EffectiveNetworkSecurityGroupAssociation'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
        'tag_map': {'key': 'tagMap', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.association = kwargs.get('association', None)
        self.effective_security_rules = kwargs.get('effective_security_rules', None)
        self.tag_map = kwargs.get('tag_map', None)


class EffectiveNetworkSecurityGroupAssociation(msrest.serialization.Model):
    """The effective network security group association.

    :param subnet: The ID of the subnet if assigned.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param network_interface: The ID of the network interface if assigned.
    :type network_interface: ~azure.mgmt.network.v2020_03_01.models.SubResource
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'network_interface': {'key': 'networkInterface', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroupAssociation, self).__init__(**kwargs)
        self.subnet = kwargs.get('subnet', None)
        self.network_interface = kwargs.get('network_interface', None)


class EffectiveNetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of effective network security groups.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveNetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveNetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EffectiveNetworkSecurityRule(msrest.serialization.Model):
    """Effective network security rules.

    :param name: The name of the security rule specified by the user (if created by the user).
    :type name: str
    :param protocol: The network protocol this rule applies to. Possible values include: "Tcp",
     "Udp", "All".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.EffectiveSecurityRuleProtocol
    :param source_port_range: The source port or range.
    :type source_port_range: str
    :param destination_port_range: The destination port or range.
    :type destination_port_range: str
    :param source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :type destination_port_ranges: list[str]
    :param source_address_prefix: The source address prefix.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix.
    :type destination_address_prefix: str
    :param source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :type source_address_prefixes: list[str]
    :param destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :type destination_address_prefixes: list[str]
    :param expanded_source_address_prefix: The expanded source address prefix.
    :type expanded_source_address_prefix: list[str]
    :param expanded_destination_address_prefix: Expanded destination address prefix.
    :type expanded_destination_address_prefix: list[str]
    :param access: Whether network traffic is allowed or denied. Possible values include: "Allow",
     "Deny".
    :type access: str or ~azure.mgmt.network.v2020_03_01.models.SecurityRuleAccess
    :param priority: The priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. Possible values include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2020_03_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'expanded_source_address_prefix': {'key': 'expandedSourceAddressPrefix', 'type': '[str]'},
        'expanded_destination_address_prefix': {'key': 'expandedDestinationAddressPrefix', 'type': '[str]'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveNetworkSecurityRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.source_port_range = kwargs.get('source_port_range', None)
        self.destination_port_range = kwargs.get('destination_port_range', None)
        self.source_port_ranges = kwargs.get('source_port_ranges', None)
        self.destination_port_ranges = kwargs.get('destination_port_ranges', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.destination_address_prefix = kwargs.get('destination_address_prefix', None)
        self.source_address_prefixes = kwargs.get('source_address_prefixes', None)
        self.destination_address_prefixes = kwargs.get('destination_address_prefixes', None)
        self.expanded_source_address_prefix = kwargs.get('expanded_source_address_prefix', None)
        self.expanded_destination_address_prefix = kwargs.get('expanded_destination_address_prefix', None)
        self.access = kwargs.get('access', None)
        self.priority = kwargs.get('priority', None)
        self.direction = kwargs.get('direction', None)


class EffectiveRoute(msrest.serialization.Model):
    """Effective Route.

    :param name: The name of the user defined route. This is optional.
    :type name: str
    :param disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
     network interfaces in the subnet.
    :type disable_bgp_route_propagation: bool
    :param source: Who created the route. Possible values include: "Unknown", "User",
     "VirtualNetworkGateway", "Default".
    :type source: str or ~azure.mgmt.network.v2020_03_01.models.EffectiveRouteSource
    :param state: The value of effective route. Possible values include: "Active", "Invalid".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.EffectiveRouteState
    :param address_prefix: The address prefixes of the effective routes in CIDR notation.
    :type address_prefix: list[str]
    :param next_hop_ip_address: The IP address of the next hop of the effective route.
    :type next_hop_ip_address: list[str]
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values
     include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2020_03_01.models.RouteNextHopType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disable_bgp_route_propagation': {'key': 'disableBgpRoutePropagation', 'type': 'bool'},
        'source': {'key': 'source', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'address_prefix': {'key': 'addressPrefix', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveRoute, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.disable_bgp_route_propagation = kwargs.get('disable_bgp_route_propagation', None)
        self.source = kwargs.get('source', None)
        self.state = kwargs.get('state', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)


class EffectiveRouteListResult(msrest.serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of effective routes.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveRoute]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EffectiveRouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointServiceResult, self).__init__(**kwargs)
        self.name = None
        self.type = None


class EndpointServicesListResult(msrest.serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :param value: List of available endpoint services in a region.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.EndpointServiceResult]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EndpointServiceResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointServicesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Error(msrest.serialization.Model):
    """Common error representation.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param details: Error details.
    :type details: list[~azure.mgmt.network.v2020_03_01.models.ErrorDetails]
    :param inner_error: Inner error message.
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)


class ErrorDetails(msrest.serialization.Model):
    """Common error details representation.

    :param code: Error code.
    :type code: str
    :param target: Error target.
    :type target: str
    :param message: Error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ErrorResponse(msrest.serialization.Model):
    """The error object.

    :param error: The error details object.
    :type error: ~azure.mgmt.network.v2020_03_01.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class EvaluatedNetworkSecurityGroup(msrest.serialization.Model):
    """Results of network security group evaluation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param network_security_group_id: Network security group ID.
    :type network_security_group_id: str
    :param applied_to: Resource ID of nic or subnet to which network security group is applied.
    :type applied_to: str
    :param matched_rule: Matched network security rule.
    :type matched_rule: ~azure.mgmt.network.v2020_03_01.models.MatchedRule
    :ivar rules_evaluation_result: List of network security rules evaluation results.
    :vartype rules_evaluation_result:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkSecurityRulesEvaluationResult]
    """

    _validation = {
        'rules_evaluation_result': {'readonly': True},
    }

    _attribute_map = {
        'network_security_group_id': {'key': 'networkSecurityGroupId', 'type': 'str'},
        'applied_to': {'key': 'appliedTo', 'type': 'str'},
        'matched_rule': {'key': 'matchedRule', 'type': 'MatchedRule'},
        'rules_evaluation_result': {'key': 'rulesEvaluationResult', 'type': '[NetworkSecurityRulesEvaluationResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EvaluatedNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group_id = kwargs.get('network_security_group_id', None)
        self.applied_to = kwargs.get('applied_to', None)
        self.matched_rule = kwargs.get('matched_rule', None)
        self.rules_evaluation_result = None


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param allow_classic_operations: Allow classic operations.
    :type allow_classic_operations: bool
    :param circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :type circuit_provisioning_state: str
    :param service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values include: "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioning".
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2020_03_01.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :param service_key: The ServiceKey.
    :type service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitServiceProviderProperties
    :param express_route_port: The reference to the ExpressRoutePort resource when the circuit is
     provisioned on an ExpressRoutePort resource.
    :type express_route_port: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
     ExpressRoutePort resource.
    :type bandwidth_in_gbps: float
    :ivar stag: The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
    :vartype stag: int
    :ivar provisioning_state: The provisioning state of the express route circuit resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :param global_reach_enabled: Flag denoting global reach status.
    :type global_reach_enabled: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'stag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allow_classic_operations': {'key': 'properties.allowClassicOperations', 'type': 'bool'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'express_route_port': {'key': 'properties.expressRoutePort', 'type': 'SubResource'},
        'bandwidth_in_gbps': {'key': 'properties.bandwidthInGbps', 'type': 'float'},
        'stag': {'key': 'properties.stag', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'global_reach_enabled': {'key': 'properties.globalReachEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuit, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.etag = None
        self.allow_classic_operations = kwargs.get('allow_classic_operations', None)
        self.circuit_provisioning_state = kwargs.get('circuit_provisioning_state', None)
        self.service_provider_provisioning_state = kwargs.get('service_provider_provisioning_state', None)
        self.authorizations = kwargs.get('authorizations', None)
        self.peerings = kwargs.get('peerings', None)
        self.service_key = kwargs.get('service_key', None)
        self.service_provider_notes = kwargs.get('service_provider_notes', None)
        self.service_provider_properties = kwargs.get('service_provider_properties', None)
        self.express_route_port = kwargs.get('express_route_port', None)
        self.bandwidth_in_gbps = kwargs.get('bandwidth_in_gbps', None)
        self.stag = None
        self.provisioning_state = None
        self.gateway_manager_etag = kwargs.get('gateway_manager_etag', None)
        self.global_reach_enabled = kwargs.get('global_reach_enabled', None)


class ExpressRouteCircuitArpTable(msrest.serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param age: Entry age in minutes.
    :type age: int
    :param interface: Interface address.
    :type interface: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'age': {'key': 'age', 'type': 'int'},
        'interface': {'key': 'interface', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.age = kwargs.get('age', None)
        self.interface = kwargs.get('interface', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.mac_address = kwargs.get('mac_address', None)


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param authorization_use_status: The authorization use status. Possible values include:
     "Available", "InUse".
    :type authorization_use_status: str or
     ~azure.mgmt.network.v2020_03_01.models.AuthorizationUseStatus
    :ivar provisioning_state: The provisioning state of the authorization resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitAuthorization, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.authorization_key = kwargs.get('authorization_key', None)
        self.authorization_use_status = kwargs.get('authorization_use_status', None)
        self.provisioning_state = None


class ExpressRouteCircuitConnection(SubResource):
    """Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit initiating connection.
    :type express_route_circuit_peering: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :type peer_express_route_circuit_peering: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :type address_prefix: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route
     circuit connection.
    :type ipv6_circuit_connection_config:
     ~azure.mgmt.network.v2020_03_01.models.Ipv6CircuitConnectionConfig
    :ivar circuit_connection_status: Express Route Circuit connection state. Possible values
     include: "Connected", "Connecting", "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.CircuitConnectionStatus
    :ivar provisioning_state: The provisioning state of the express route circuit connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'circuit_connection_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'SubResource'},
        'peer_express_route_circuit_peering': {'key': 'properties.peerExpressRouteCircuitPeering', 'type': 'SubResource'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'ipv6_circuit_connection_config': {'key': 'properties.ipv6CircuitConnectionConfig', 'type': 'Ipv6CircuitConnectionConfig'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.express_route_circuit_peering = kwargs.get('express_route_circuit_peering', None)
        self.peer_express_route_circuit_peering = kwargs.get('peer_express_route_circuit_peering', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.ipv6_circuit_connection_config = kwargs.get('ipv6_circuit_connection_config', None)
        self.circuit_connection_status = None
        self.provisioning_state = None


class ExpressRouteCircuitConnectionListResult(msrest.serialization.Model):
    """Response for ListConnections API service call retrieves all global reach connections that belongs to a Private Peering for an ExpressRouteCircuit.

    :param value: The global reach connection associated with Private Peering in an ExpressRoute
     Circuit.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitConnection]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitListResult(msrest.serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :param value: A list of ExpressRouteCircuits in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuit]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param peering_type: The peering type. Possible values include: "AzurePublicPeering",
     "AzurePrivatePeering", "MicrosoftPeering".
    :type peering_type: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRoutePeeringType
    :param state: The peering state. Possible values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRoutePeeringState
    :param azure_asn: The Azure ASN.
    :type azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: long
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param primary_azure_port: The primary port.
    :type primary_azure_port: str
    :param secondary_azure_port: The secondary port.
    :type secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringConfig
    :param stats: The peering stats of express route circuit.
    :type stats: ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitStats
    :ivar provisioning_state: The provisioning state of the express route circuit peering resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :param route_filter: The reference to the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2020_03_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    :param express_route_connection: The ExpressRoute connection.
    :type express_route_connection: ~azure.mgmt.network.v2020_03_01.models.ExpressRouteConnectionId
    :param connections: The list of circuit connections associated with Azure Private Peering for
     this circuit.
    :type connections: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitConnection]
    :ivar peered_connections: The list of peered circuit connections associated with Azure Private
     Peering for this circuit.
    :vartype peered_connections:
     list[~azure.mgmt.network.v2020_03_01.models.PeerExpressRouteCircuitConnection]
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'peered_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'long'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'route_filter': {'key': 'properties.routeFilter', 'type': 'SubResource'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
        'express_route_connection': {'key': 'properties.expressRouteConnection', 'type': 'ExpressRouteConnectionId'},
        'connections': {'key': 'properties.connections', 'type': '[ExpressRouteCircuitConnection]'},
        'peered_connections': {'key': 'properties.peeredConnections', 'type': '[PeerExpressRouteCircuitConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeering, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.peering_type = kwargs.get('peering_type', None)
        self.state = kwargs.get('state', None)
        self.azure_asn = kwargs.get('azure_asn', None)
        self.peer_asn = kwargs.get('peer_asn', None)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.primary_azure_port = kwargs.get('primary_azure_port', None)
        self.secondary_azure_port = kwargs.get('secondary_azure_port', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.vlan_id = kwargs.get('vlan_id', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.stats = kwargs.get('stats', None)
        self.provisioning_state = None
        self.gateway_manager_etag = kwargs.get('gateway_manager_etag', None)
        self.last_modified_by = None
        self.route_filter = kwargs.get('route_filter', None)
        self.ipv6_peering_config = kwargs.get('ipv6_peering_config', None)
        self.express_route_connection = kwargs.get('express_route_connection', None)
        self.connections = kwargs.get('connections', None)
        self.peered_connections = None


class ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Specifies the peering configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :type advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: The advertised public prefix state of the Peering
     resource. Possible values include: "NotConfigured", "Configuring", "Configured",
     "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param legacy_mode: The legacy mode of the peering.
    :type legacy_mode: int
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the configuration.
    :type routing_registry_name: str
    """

    _validation = {
        'advertised_public_prefixes_state': {'readonly': True},
    }

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_communities': {'key': 'advertisedCommunities', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'legacy_mode': {'key': 'legacyMode', 'type': 'int'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = kwargs.get('advertised_public_prefixes', None)
        self.advertised_communities = kwargs.get('advertised_communities', None)
        self.advertised_public_prefixes_state = None
        self.legacy_mode = kwargs.get('legacy_mode', None)
        self.customer_asn = kwargs.get('customer_asn', None)
        self.routing_registry_name = kwargs.get('routing_registry_name', None)


class ExpressRouteCircuitPeeringId(msrest.serialization.Model):
    """ExpressRoute circuit peering identifier.

    :param id: The ID of the ExpressRoute circuit peering.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringId, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ExpressRouteCircuitPeeringListResult(msrest.serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :param value: The peerings in an express route circuit.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitReference(msrest.serialization.Model):
    """Reference to an express route circuit.

    :param id: Corresponding Express Route Circuit Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ExpressRouteCircuitRoutesTable(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param network: IP address of a network entity.
    :type network: str
    :param next_hop: NextHop address.
    :type next_hop: str
    :param loc_prf: Local preference value as set with the set local-preference route-map
     configuration command.
    :type loc_prf: str
    :param weight: Route Weight.
    :type weight: int
    :param path: Autonomous system paths to the destination network.
    :type path: str
    """

    _attribute_map = {
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'loc_prf': {'key': 'locPrf', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.network = kwargs.get('network', None)
        self.next_hop = kwargs.get('next_hop', None)
        self.loc_prf = kwargs.get('loc_prf', None)
        self.weight = kwargs.get('weight', None)
        self.path = kwargs.get('path', None)


class ExpressRouteCircuitRoutesTableSummary(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: IP address of the neighbor.
    :type neighbor: str
    :param v: BGP version number spoken to the neighbor.
    :type v: int
    :param as_property: Autonomous system number.
    :type as_property: int
    :param up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :type up_down: str
    :param state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :type state_pfx_rcd: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'v': {'key': 'v', 'type': 'int'},
        'as_property': {'key': 'as', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_pfx_rcd': {'key': 'statePfxRcd', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = kwargs.get('neighbor', None)
        self.v = kwargs.get('v', None)
        self.as_property = kwargs.get('as_property', None)
        self.up_down = kwargs.get('up_down', None)
        self.state_pfx_rcd = kwargs.get('state_pfx_rcd', None)


class ExpressRouteCircuitsArpTableListResult(msrest.serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: A list of the ARP tables.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitServiceProviderProperties(msrest.serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = kwargs.get('service_provider_name', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)


class ExpressRouteCircuitSku(msrest.serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values include: "Standard", "Premium", "Basic",
     "Local".
    :type tier: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values include: "UnlimitedData", "MeteredData".
    :type family: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.family = kwargs.get('family', None)


class ExpressRouteCircuitsRoutesTableListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: The list of routes table.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitsRoutesTableSummaryListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: A list of the routes table.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitRoutesTableSummary]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitStats(msrest.serialization.Model):
    """Contains stats associated with the peering.

    :param primarybytes_in: The Primary BytesIn of the peering.
    :type primarybytes_in: long
    :param primarybytes_out: The primary BytesOut of the peering.
    :type primarybytes_out: long
    :param secondarybytes_in: The secondary BytesIn of the peering.
    :type secondarybytes_in: long
    :param secondarybytes_out: The secondary BytesOut of the peering.
    :type secondarybytes_out: long
    """

    _attribute_map = {
        'primarybytes_in': {'key': 'primarybytesIn', 'type': 'long'},
        'primarybytes_out': {'key': 'primarybytesOut', 'type': 'long'},
        'secondarybytes_in': {'key': 'secondarybytesIn', 'type': 'long'},
        'secondarybytes_out': {'key': 'secondarybytesOut', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.primarybytes_in = kwargs.get('primarybytes_in', None)
        self.primarybytes_out = kwargs.get('primarybytes_out', None)
        self.secondarybytes_in = kwargs.get('secondarybytes_in', None)
        self.secondarybytes_out = kwargs.get('secondarybytes_out', None)


class ExpressRouteConnection(SubResource):
    """ExpressRouteConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :ivar provisioning_state: The provisioning state of the express route connection resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param express_route_circuit_peering: The ExpressRoute circuit peering.
    :type express_route_circuit_peering:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringId
    :param authorization_key: Authorization key to establish the connection.
    :type authorization_key: str
    :param routing_weight: The routing weight associated to the connection.
    :type routing_weight: int
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    """

    _validation = {
        'name': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'ExpressRouteCircuitPeeringId'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteConnection, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.provisioning_state = None
        self.express_route_circuit_peering = kwargs.get('express_route_circuit_peering', None)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.enable_internet_security = kwargs.get('enable_internet_security', None)


class ExpressRouteConnectionId(msrest.serialization.Model):
    """The ID of the ExpressRouteConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the ExpressRouteConnection.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteConnectionId, self).__init__(**kwargs)
        self.id = None


class ExpressRouteConnectionList(msrest.serialization.Model):
    """ExpressRouteConnection list.

    :param value: The list of ExpressRoute connections.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteConnectionList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ExpressRouteCrossConnection(Resource):
    """ExpressRouteCrossConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar s_tag: The identifier of the circuit traffic.
    :vartype s_tag: int
    :param peering_location: The peering location of the ExpressRoute circuit.
    :type peering_location: str
    :param bandwidth_in_mbps: The circuit bandwidth In Mbps.
    :type bandwidth_in_mbps: int
    :param express_route_circuit: The ExpressRouteCircuit.
    :type express_route_circuit:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitReference
    :param service_provider_provisioning_state: The provisioning state of the circuit in the
     connectivity provider system. Possible values include: "NotProvisioned", "Provisioning",
     "Provisioned", "Deprovisioning".
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2020_03_01.models.ServiceProviderProvisioningState
    :param service_provider_notes: Additional read only notes set by the connectivity provider.
    :type service_provider_notes: str
    :ivar provisioning_state: The provisioning state of the express route cross connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param peerings: The list of peerings.
    :type peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCrossConnectionPeering]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'primary_azure_port': {'readonly': True},
        'secondary_azure_port': {'readonly': True},
        's_tag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        's_tag': {'key': 'properties.sTag', 'type': 'int'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'properties.bandwidthInMbps', 'type': 'int'},
        'express_route_circuit': {'key': 'properties.expressRouteCircuit', 'type': 'ExpressRouteCircuitReference'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCrossConnectionPeering]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnection, self).__init__(**kwargs)
        self.etag = None
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.s_tag = None
        self.peering_location = kwargs.get('peering_location', None)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)
        self.express_route_circuit = kwargs.get('express_route_circuit', None)
        self.service_provider_provisioning_state = kwargs.get('service_provider_provisioning_state', None)
        self.service_provider_notes = kwargs.get('service_provider_notes', None)
        self.provisioning_state = None
        self.peerings = kwargs.get('peerings', None)


class ExpressRouteCrossConnectionListResult(msrest.serialization.Model):
    """Response for ListExpressRouteCrossConnection API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of ExpressRouteCrossConnection resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCrossConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCrossConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ExpressRouteCrossConnectionPeering(SubResource):
    """Peering in an ExpressRoute Cross Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param peering_type: The peering type. Possible values include: "AzurePublicPeering",
     "AzurePrivatePeering", "MicrosoftPeering".
    :type peering_type: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRoutePeeringType
    :param state: The peering state. Possible values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: long
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringConfig
    :ivar provisioning_state: The provisioning state of the express route cross connection peering
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2020_03_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        'etag': {'readonly': True},
        'azure_asn': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 1},
        'primary_azure_port': {'readonly': True},
        'secondary_azure_port': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'long'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnectionPeering, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.peering_type = kwargs.get('peering_type', None)
        self.state = kwargs.get('state', None)
        self.azure_asn = None
        self.peer_asn = kwargs.get('peer_asn', None)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.shared_key = kwargs.get('shared_key', None)
        self.vlan_id = kwargs.get('vlan_id', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.provisioning_state = None
        self.gateway_manager_etag = kwargs.get('gateway_manager_etag', None)
        self.last_modified_by = None
        self.ipv6_peering_config = kwargs.get('ipv6_peering_config', None)


class ExpressRouteCrossConnectionPeeringList(msrest.serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCrossConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The peerings in an express route cross connection.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCrossConnectionPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCrossConnectionPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnectionPeeringList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ExpressRouteCrossConnectionRoutesTableSummary(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: IP address of Neighbor router.
    :type neighbor: str
    :param asn: Autonomous system number.
    :type asn: int
    :param up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :type up_down: str
    :param state_or_prefixes_received: Current state of the BGP session, and the number of prefixes
     that have been received from a neighbor or peer group.
    :type state_or_prefixes_received: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_or_prefixes_received': {'key': 'stateOrPrefixesReceived', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnectionRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = kwargs.get('neighbor', None)
        self.asn = kwargs.get('asn', None)
        self.up_down = kwargs.get('up_down', None)
        self.state_or_prefixes_received = kwargs.get('state_or_prefixes_received', None)


class ExpressRouteCrossConnectionsRoutesTableSummaryListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Cross Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of the routes table.
    :type value:
     list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCrossConnectionRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCrossConnectionRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCrossConnectionsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ExpressRouteGateway(Resource):
    """ExpressRoute gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param auto_scale_configuration: Configuration for auto scaling.
    :type auto_scale_configuration:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
    :ivar express_route_connections: List of ExpressRoute connections to the ExpressRoute gateway.
    :vartype express_route_connections:
     list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteConnection]
    :ivar provisioning_state: The provisioning state of the express route gateway resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.VirtualHubId
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'express_route_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'auto_scale_configuration': {'key': 'properties.autoScaleConfiguration', 'type': 'ExpressRouteGatewayPropertiesAutoScaleConfiguration'},
        'express_route_connections': {'key': 'properties.expressRouteConnections', 'type': '[ExpressRouteConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'VirtualHubId'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteGateway, self).__init__(**kwargs)
        self.etag = None
        self.auto_scale_configuration = kwargs.get('auto_scale_configuration', None)
        self.express_route_connections = None
        self.provisioning_state = None
        self.virtual_hub = kwargs.get('virtual_hub', None)


class ExpressRouteGatewayList(msrest.serialization.Model):
    """List of ExpressRoute gateways.

    :param value: List of ExpressRoute gateways.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteGateway]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteGateway]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteGatewayList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ExpressRouteGatewayPropertiesAutoScaleConfiguration(msrest.serialization.Model):
    """Configuration for auto scaling.

    :param bounds: Minimum and maximum number of scale units to deploy.
    :type bounds:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    """

    _attribute_map = {
        'bounds': {'key': 'bounds', 'type': 'ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteGatewayPropertiesAutoScaleConfiguration, self).__init__(**kwargs)
        self.bounds = kwargs.get('bounds', None)


class ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds(msrest.serialization.Model):
    """Minimum and maximum number of scale units to deploy.

    :param min: Minimum number of scale units deployed for ExpressRoute gateway.
    :type min: int
    :param max: Maximum number of scale units deployed for ExpressRoute gateway.
    :type max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds, self).__init__(**kwargs)
        self.min = kwargs.get('min', None)
        self.max = kwargs.get('max', None)


class ExpressRouteLink(SubResource):
    """ExpressRouteLink child resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of child port resource that is unique among child port resources of the
     parent.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar router_name: Name of Azure router associated with physical port.
    :vartype router_name: str
    :ivar interface_name: Name of Azure router interface.
    :vartype interface_name: str
    :ivar patch_panel_id: Mapping between physical port to patch panel port.
    :vartype patch_panel_id: str
    :ivar rack_id: Mapping of physical patch panel to rack.
    :vartype rack_id: str
    :ivar connector_type: Physical fiber port type. Possible values include: "LC", "SC".
    :vartype connector_type: str or
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteLinkConnectorType
    :param admin_state: Administrative state of the physical port. Possible values include:
     "Enabled", "Disabled".
    :type admin_state: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRouteLinkAdminState
    :ivar provisioning_state: The provisioning state of the express route link resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param mac_sec_config: MacSec configuration.
    :type mac_sec_config: ~azure.mgmt.network.v2020_03_01.models.ExpressRouteLinkMacSecConfig
    """

    _validation = {
        'etag': {'readonly': True},
        'router_name': {'readonly': True},
        'interface_name': {'readonly': True},
        'patch_panel_id': {'readonly': True},
        'rack_id': {'readonly': True},
        'connector_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'router_name': {'key': 'properties.routerName', 'type': 'str'},
        'interface_name': {'key': 'properties.interfaceName', 'type': 'str'},
        'patch_panel_id': {'key': 'properties.patchPanelId', 'type': 'str'},
        'rack_id': {'key': 'properties.rackId', 'type': 'str'},
        'connector_type': {'key': 'properties.connectorType', 'type': 'str'},
        'admin_state': {'key': 'properties.adminState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'mac_sec_config': {'key': 'properties.macSecConfig', 'type': 'ExpressRouteLinkMacSecConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteLink, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.router_name = None
        self.interface_name = None
        self.patch_panel_id = None
        self.rack_id = None
        self.connector_type = None
        self.admin_state = kwargs.get('admin_state', None)
        self.provisioning_state = None
        self.mac_sec_config = kwargs.get('mac_sec_config', None)


class ExpressRouteLinkListResult(msrest.serialization.Model):
    """Response for ListExpressRouteLinks API service call.

    :param value: The list of ExpressRouteLink sub-resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteLink]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteLinkListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteLinkMacSecConfig(msrest.serialization.Model):
    """ExpressRouteLink Mac Security Configuration.

    :param ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
    :type ckn_secret_identifier: str
    :param cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
    :type cak_secret_identifier: str
    :param cipher: Mac security cipher. Possible values include: "gcm-aes-128", "gcm-aes-256".
    :type cipher: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRouteLinkMacSecCipher
    """

    _attribute_map = {
        'ckn_secret_identifier': {'key': 'cknSecretIdentifier', 'type': 'str'},
        'cak_secret_identifier': {'key': 'cakSecretIdentifier', 'type': 'str'},
        'cipher': {'key': 'cipher', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteLinkMacSecConfig, self).__init__(**kwargs)
        self.ckn_secret_identifier = kwargs.get('ckn_secret_identifier', None)
        self.cak_secret_identifier = kwargs.get('cak_secret_identifier', None)
        self.cipher = kwargs.get('cipher', None)


class ExpressRoutePort(Resource):
    """ExpressRoutePort resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param identity: The identity of ExpressRoutePort, if configured.
    :type identity: ~azure.mgmt.network.v2020_03_01.models.ManagedServiceIdentity
    :param peering_location: The name of the peering location that the ExpressRoutePort is mapped
     to physically.
    :type peering_location: str
    :param bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
    :type bandwidth_in_gbps: int
    :ivar provisioned_bandwidth_in_gbps: Aggregate Gbps of associated circuit bandwidths.
    :vartype provisioned_bandwidth_in_gbps: float
    :ivar mtu: Maximum transmission unit of the physical port pair(s).
    :vartype mtu: str
    :param encapsulation: Encapsulation method on physical ports. Possible values include: "Dot1Q",
     "QinQ".
    :type encapsulation: str or
     ~azure.mgmt.network.v2020_03_01.models.ExpressRoutePortsEncapsulation
    :ivar ether_type: Ether type of the physical port.
    :vartype ether_type: str
    :ivar allocation_date: Date of the physical port allocation to be used in Letter of
     Authorization.
    :vartype allocation_date: str
    :param links: The set of physical links of the ExpressRoutePort resource.
    :type links: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteLink]
    :ivar circuits: Reference the ExpressRoute circuit(s) that are provisioned on this
     ExpressRoutePort resource.
    :vartype circuits: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the express route port resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the express route port resource.
    :vartype resource_guid: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioned_bandwidth_in_gbps': {'readonly': True},
        'mtu': {'readonly': True},
        'ether_type': {'readonly': True},
        'allocation_date': {'readonly': True},
        'circuits': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'bandwidth_in_gbps': {'key': 'properties.bandwidthInGbps', 'type': 'int'},
        'provisioned_bandwidth_in_gbps': {'key': 'properties.provisionedBandwidthInGbps', 'type': 'float'},
        'mtu': {'key': 'properties.mtu', 'type': 'str'},
        'encapsulation': {'key': 'properties.encapsulation', 'type': 'str'},
        'ether_type': {'key': 'properties.etherType', 'type': 'str'},
        'allocation_date': {'key': 'properties.allocationDate', 'type': 'str'},
        'links': {'key': 'properties.links', 'type': '[ExpressRouteLink]'},
        'circuits': {'key': 'properties.circuits', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRoutePort, self).__init__(**kwargs)
        self.etag = None
        self.identity = kwargs.get('identity', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.bandwidth_in_gbps = kwargs.get('bandwidth_in_gbps', None)
        self.provisioned_bandwidth_in_gbps = None
        self.mtu = None
        self.encapsulation = kwargs.get('encapsulation', None)
        self.ether_type = None
        self.allocation_date = None
        self.links = kwargs.get('links', None)
        self.circuits = None
        self.provisioning_state = None
        self.resource_guid = None


class ExpressRoutePortListResult(msrest.serialization.Model):
    """Response for ListExpressRoutePorts API service call.

    :param value: A list of ExpressRoutePort resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRoutePort]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRoutePort]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRoutePortListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRoutePortsLocation(Resource):
    """Definition of the ExpressRoutePorts peering location resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar address: Address of peering location.
    :vartype address: str
    :ivar contact: Contact details of peering locations.
    :vartype contact: str
    :param available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
    :type available_bandwidths:
     list[~azure.mgmt.network.v2020_03_01.models.ExpressRoutePortsLocationBandwidths]
    :ivar provisioning_state: The provisioning state of the express route port location resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'address': {'readonly': True},
        'contact': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'address': {'key': 'properties.address', 'type': 'str'},
        'contact': {'key': 'properties.contact', 'type': 'str'},
        'available_bandwidths': {'key': 'properties.availableBandwidths', 'type': '[ExpressRoutePortsLocationBandwidths]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRoutePortsLocation, self).__init__(**kwargs)
        self.address = None
        self.contact = None
        self.available_bandwidths = kwargs.get('available_bandwidths', None)
        self.provisioning_state = None


class ExpressRoutePortsLocationBandwidths(msrest.serialization.Model):
    """Real-time inventory of available ExpressRoute port bandwidths.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar offer_name: Bandwidth descriptive name.
    :vartype offer_name: str
    :ivar value_in_gbps: Bandwidth value in Gbps.
    :vartype value_in_gbps: int
    """

    _validation = {
        'offer_name': {'readonly': True},
        'value_in_gbps': {'readonly': True},
    }

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_gbps': {'key': 'valueInGbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRoutePortsLocationBandwidths, self).__init__(**kwargs)
        self.offer_name = None
        self.value_in_gbps = None


class ExpressRoutePortsLocationListResult(msrest.serialization.Model):
    """Response for ListExpressRoutePortsLocations API service call.

    :param value: The list of all ExpressRoutePort peering locations.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRoutePortsLocation]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRoutePortsLocation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRoutePortsLocationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: A list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: A list of bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: The provisioning state of the express route service provider
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProvider, self).__init__(**kwargs)
        self.peering_locations = kwargs.get('peering_locations', None)
        self.bandwidths_offered = kwargs.get('bandwidths_offered', None)
        self.provisioning_state = None


class ExpressRouteServiceProviderBandwidthsOffered(msrest.serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = kwargs.get('offer_name', None)
        self.value_in_mbps = kwargs.get('value_in_mbps', None)


class ExpressRouteServiceProviderListResult(msrest.serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :param value: A list of ExpressRouteResourceProvider resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteServiceProvider]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteServiceProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProviderListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class FirewallPolicy(Resource):
    """FirewallPolicy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rule_groups: List of references to FirewallPolicyRuleGroups.
    :vartype rule_groups: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the firewall policy resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param base_policy: The parent firewall policy from which rules are inherited.
    :type base_policy: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar firewalls: List of references to Azure Firewalls that this Firewall Policy is associated
     with.
    :vartype firewalls: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar child_policies: List of references to Child Firewall Policies.
    :vartype child_policies: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param threat_intel_mode: The operation mode for Threat Intelligence. Possible values include:
     "Alert", "Deny", "Off".
    :type threat_intel_mode: str or
     ~azure.mgmt.network.v2020_03_01.models.AzureFirewallThreatIntelMode
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'rule_groups': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'firewalls': {'readonly': True},
        'child_policies': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'base_policy': {'key': 'properties.basePolicy', 'type': 'SubResource'},
        'firewalls': {'key': 'properties.firewalls', 'type': '[SubResource]'},
        'child_policies': {'key': 'properties.childPolicies', 'type': '[SubResource]'},
        'threat_intel_mode': {'key': 'properties.threatIntelMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicy, self).__init__(**kwargs)
        self.etag = None
        self.rule_groups = None
        self.provisioning_state = None
        self.base_policy = kwargs.get('base_policy', None)
        self.firewalls = None
        self.child_policies = None
        self.threat_intel_mode = kwargs.get('threat_intel_mode', None)


class FirewallPolicyRule(msrest.serialization.Model):
    """Properties of the rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FirewallPolicyFilterRule, FirewallPolicyNatRule.

    All required parameters must be populated in order to send to Azure.

    :param rule_type: Required. The type of the rule.Constant filled by server.  Possible values
     include: "FirewallPolicyNatRule", "FirewallPolicyFilterRule".
    :type rule_type: str or ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleType
    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    """

    _validation = {
        'rule_type': {'required': True},
        'priority': {'maximum': 65000, 'minimum': 100},
    }

    _attribute_map = {
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
    }

    _subtype_map = {
        'rule_type': {'FirewallPolicyFilterRule': 'FirewallPolicyFilterRule', 'FirewallPolicyNatRule': 'FirewallPolicyNatRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyRule, self).__init__(**kwargs)
        self.rule_type = None  # type: Optional[str]
        self.name = kwargs.get('name', None)
        self.priority = kwargs.get('priority', None)


class FirewallPolicyFilterRule(FirewallPolicyRule):
    """Firewall Policy Filter Rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_type: Required. The type of the rule.Constant filled by server.  Possible values
     include: "FirewallPolicyNatRule", "FirewallPolicyFilterRule".
    :type rule_type: str or ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleType
    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    :param action: The action type of a Filter rule.
    :type action: ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyFilterRuleAction
    :param rule_conditions: Collection of rule conditions used by a rule.
    :type rule_conditions: list[~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleCondition]
    """

    _validation = {
        'rule_type': {'required': True},
        'priority': {'maximum': 65000, 'minimum': 100},
    }

    _attribute_map = {
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'action': {'key': 'action', 'type': 'FirewallPolicyFilterRuleAction'},
        'rule_conditions': {'key': 'ruleConditions', 'type': '[FirewallPolicyRuleCondition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyFilterRule, self).__init__(**kwargs)
        self.rule_type = 'FirewallPolicyFilterRule'  # type: str
        self.action = kwargs.get('action', None)
        self.rule_conditions = kwargs.get('rule_conditions', None)


class FirewallPolicyFilterRuleAction(msrest.serialization.Model):
    """Properties of the FirewallPolicyFilterRuleAction.

    :param type: The type of action. Possible values include: "Allow", "Deny".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyFilterRuleActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyFilterRuleAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class FirewallPolicyListResult(msrest.serialization.Model):
    """Response for ListFirewallPolicies API service call.

    :param value: List of Firewall Policies in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.FirewallPolicy]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class FirewallPolicyNatRule(FirewallPolicyRule):
    """Firewall Policy NAT Rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_type: Required. The type of the rule.Constant filled by server.  Possible values
     include: "FirewallPolicyNatRule", "FirewallPolicyFilterRule".
    :type rule_type: str or ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleType
    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    :param action: The action type of a Nat rule.
    :type action: ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyNatRuleAction
    :param translated_address: The translated address for this NAT rule.
    :type translated_address: str
    :param translated_port: The translated port for this NAT rule.
    :type translated_port: str
    :param rule_condition: The match conditions for incoming traffic.
    :type rule_condition: ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleCondition
    """

    _validation = {
        'rule_type': {'required': True},
        'priority': {'maximum': 65000, 'minimum': 100},
    }

    _attribute_map = {
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'action': {'key': 'action', 'type': 'FirewallPolicyNatRuleAction'},
        'translated_address': {'key': 'translatedAddress', 'type': 'str'},
        'translated_port': {'key': 'translatedPort', 'type': 'str'},
        'rule_condition': {'key': 'ruleCondition', 'type': 'FirewallPolicyRuleCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyNatRule, self).__init__(**kwargs)
        self.rule_type = 'FirewallPolicyNatRule'  # type: str
        self.action = kwargs.get('action', None)
        self.translated_address = kwargs.get('translated_address', None)
        self.translated_port = kwargs.get('translated_port', None)
        self.rule_condition = kwargs.get('rule_condition', None)


class FirewallPolicyNatRuleAction(msrest.serialization.Model):
    """Properties of the FirewallPolicyNatRuleAction.

    :param type: The type of action. Possible values include: "DNAT".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyNatRuleActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyNatRuleAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class FirewallPolicyRuleConditionApplicationProtocol(msrest.serialization.Model):
    """Properties of the application rule protocol.

    :param protocol_type: Protocol type. Possible values include: "Http", "Https".
    :type protocol_type: str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionApplicationProtocolType
    :param port: Port number for the protocol, cannot be greater than 64000.
    :type port: int
    """

    _validation = {
        'port': {'maximum': 64000, 'minimum': 0},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyRuleConditionApplicationProtocol, self).__init__(**kwargs)
        self.protocol_type = kwargs.get('protocol_type', None)
        self.port = kwargs.get('port', None)


class FirewallPolicyRuleGroup(SubResource):
    """Rule Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Rule Group type.
    :vartype type: str
    :param priority: Priority of the Firewall Policy Rule Group resource.
    :type priority: int
    :param rules: Group of Firewall Policy rules.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRule]
    :ivar provisioning_state: The provisioning state of the firewall policy rule group resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'rules': {'key': 'properties.rules', 'type': '[FirewallPolicyRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyRuleGroup, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.priority = kwargs.get('priority', None)
        self.rules = kwargs.get('rules', None)
        self.provisioning_state = None


class FirewallPolicyRuleGroupListResult(msrest.serialization.Model):
    """Response for ListFirewallPolicyRuleGroups API service call.

    :param value: List of FirewallPolicyRuleGroups in a FirewallPolicy.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleGroup]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallPolicyRuleGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallPolicyRuleGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class FlowLog(Resource):
    """A flow log resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param target_resource_id: ID of network security group to which flow log will be applied.
    :type target_resource_id: str
    :ivar target_resource_guid: Guid of network security group to which flow log will be applied.
    :vartype target_resource_guid: str
    :param storage_id: ID of the storage account which is used to store the flow log.
    :type storage_id: str
    :param enabled: Flag to enable/disable flow logging.
    :type enabled: bool
    :param retention_policy: Parameters that define the retention policy for flow log.
    :type retention_policy: ~azure.mgmt.network.v2020_03_01.models.RetentionPolicyParameters
    :param format: Parameters that define the flow log format.
    :type format: ~azure.mgmt.network.v2020_03_01.models.FlowLogFormatParameters
    :param flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :type flow_analytics_configuration:
     ~azure.mgmt.network.v2020_03_01.models.TrafficAnalyticsProperties
    :ivar provisioning_state: The provisioning state of the flow log. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'target_resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'target_resource_guid': {'key': 'properties.targetResourceGuid', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicyParameters'},
        'format': {'key': 'properties.format', 'type': 'FlowLogFormatParameters'},
        'flow_analytics_configuration': {'key': 'properties.flowAnalyticsConfiguration', 'type': 'TrafficAnalyticsProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlowLog, self).__init__(**kwargs)
        self.etag = None
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.target_resource_guid = None
        self.storage_id = kwargs.get('storage_id', None)
        self.enabled = kwargs.get('enabled', None)
        self.retention_policy = kwargs.get('retention_policy', None)
        self.format = kwargs.get('format', None)
        self.flow_analytics_configuration = kwargs.get('flow_analytics_configuration', None)
        self.provisioning_state = None


class FlowLogFormatParameters(msrest.serialization.Model):
    """Parameters that define the flow log format.

    :param type: The file type of flow log. Possible values include: "JSON".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.FlowLogFormatType
    :param version: The version (revision) of the flow log.
    :type version: int
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlowLogFormatParameters, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.version = kwargs.get('version', 0)


class FlowLogInformation(msrest.serialization.Model):
    """Information on the configuration of flow log and traffic analytics (optional) .

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the resource to configure for flow log and
     traffic analytics (optional) .
    :type target_resource_id: str
    :param flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :type flow_analytics_configuration:
     ~azure.mgmt.network.v2020_03_01.models.TrafficAnalyticsProperties
    :param storage_id: Required. ID of the storage account which is used to store the flow log.
    :type storage_id: str
    :param enabled: Required. Flag to enable/disable flow logging.
    :type enabled: bool
    :param retention_policy: Parameters that define the retention policy for flow log.
    :type retention_policy: ~azure.mgmt.network.v2020_03_01.models.RetentionPolicyParameters
    :param format: Parameters that define the flow log format.
    :type format: ~azure.mgmt.network.v2020_03_01.models.FlowLogFormatParameters
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'flow_analytics_configuration': {'key': 'flowAnalyticsConfiguration', 'type': 'TrafficAnalyticsProperties'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicyParameters'},
        'format': {'key': 'properties.format', 'type': 'FlowLogFormatParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlowLogInformation, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.flow_analytics_configuration = kwargs.get('flow_analytics_configuration', None)
        self.storage_id = kwargs['storage_id']
        self.enabled = kwargs['enabled']
        self.retention_policy = kwargs.get('retention_policy', None)
        self.format = kwargs.get('format', None)


class FlowLogListResult(msrest.serialization.Model):
    """List of flow logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Information about flow log resource.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.FlowLog]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FlowLog]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlowLogListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class FlowLogStatusParameters(msrest.serialization.Model):
    """Parameters that define a resource to query flow log and traffic analytics (optional) status.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource where getting the flow log and traffic
     analytics (optional) status.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlowLogStatusParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :type zones: list[str]
    :ivar inbound_nat_rules: An array of references to inbound rules that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar inbound_nat_pools: An array of references to inbound pools that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar outbound_rules: An array of references to outbound rules that use this frontend IP.
    :vartype outbound_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method. Possible values include:
     "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6.
     Default is taken as IPv4. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    :param subnet: The reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :param public_ip_address: The reference to the Public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.PublicIPAddress
    :param public_ip_prefix: The reference to the Public IP Prefix resource.
    :type public_ip_prefix: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'inbound_nat_rules': {'readonly': True},
        'inbound_nat_pools': {'readonly': True},
        'outbound_rules': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.zones = kwargs.get('zones', None)
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.public_ip_prefix = kwargs.get('public_ip_prefix', None)
        self.provisioning_state = None


class GatewayRoute(msrest.serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        'local_address': {'readonly': True},
        'network': {'readonly': True},
        'next_hop': {'readonly': True},
        'source_peer': {'readonly': True},
        'origin': {'readonly': True},
        'as_path': {'readonly': True},
        'weight': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'source_peer': {'key': 'sourcePeer', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayRoute, self).__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(msrest.serialization.Model):
    """List of virtual network gateway routes.

    :param value: List of gateway routes.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.GatewayRoute]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayRoute]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayRouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class GetVpnSitesConfigurationRequest(msrest.serialization.Model):
    """List of Vpn-Sites.

    All required parameters must be populated in order to send to Azure.

    :param vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
    :type vpn_sites: list[str]
    :param output_blob_sas_url: Required. The sas-url to download the configurations for vpn-sites.
    :type output_blob_sas_url: str
    """

    _validation = {
        'output_blob_sas_url': {'required': True},
    }

    _attribute_map = {
        'vpn_sites': {'key': 'vpnSites', 'type': '[str]'},
        'output_blob_sas_url': {'key': 'outputBlobSasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetVpnSitesConfigurationRequest, self).__init__(**kwargs)
        self.vpn_sites = kwargs.get('vpn_sites', None)
        self.output_blob_sas_url = kwargs['output_blob_sas_url']


class HTTPConfiguration(msrest.serialization.Model):
    """HTTP configuration of the connectivity check.

    :param method: HTTP method. Possible values include: "Get".
    :type method: str or ~azure.mgmt.network.v2020_03_01.models.HTTPMethod
    :param headers: List of HTTP headers.
    :type headers: list[~azure.mgmt.network.v2020_03_01.models.HTTPHeader]
    :param valid_status_codes: Valid status codes.
    :type valid_status_codes: list[int]
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '[HTTPHeader]'},
        'valid_status_codes': {'key': 'validStatusCodes', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HTTPConfiguration, self).__init__(**kwargs)
        self.method = kwargs.get('method', None)
        self.headers = kwargs.get('headers', None)
        self.valid_status_codes = kwargs.get('valid_status_codes', None)


class HTTPHeader(msrest.serialization.Model):
    """The HTTP header.

    :param name: The name in HTTP header.
    :type name: str
    :param value: The value in HTTP header.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HTTPHeader, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class HubIPAddresses(msrest.serialization.Model):
    """IP addresses associated with azure firewall.

    :param public_ip_addresses: List of Public IP addresses associated with azure firewall.
    :type public_ip_addresses:
     list[~azure.mgmt.network.v2020_03_01.models.AzureFirewallPublicIPAddress]
    :param private_ip_address: Private IP Address associated with azure firewall.
    :type private_ip_address: str
    """

    _attribute_map = {
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[AzureFirewallPublicIPAddress]'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubIPAddresses, self).__init__(**kwargs)
        self.public_ip_addresses = kwargs.get('public_ip_addresses', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)


class HubVirtualNetworkConnection(SubResource):
    """HubVirtualNetworkConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param remote_virtual_network: Reference to the remote virtual network.
    :type remote_virtual_network: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param allow_hub_to_remote_vnet_transit: VirtualHub to RemoteVnet transit to enabled or not.
    :type allow_hub_to_remote_vnet_transit: bool
    :param allow_remote_vnet_to_use_hub_vnet_gateways: Allow RemoteVnet to use Virtual Hub's
     gateways.
    :type allow_remote_vnet_to_use_hub_vnet_gateways: bool
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    :ivar provisioning_state: The provisioning state of the hub virtual network connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'allow_hub_to_remote_vnet_transit': {'key': 'properties.allowHubToRemoteVnetTransit', 'type': 'bool'},
        'allow_remote_vnet_to_use_hub_vnet_gateways': {'key': 'properties.allowRemoteVnetToUseHubVnetGateways', 'type': 'bool'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubVirtualNetworkConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.remote_virtual_network = kwargs.get('remote_virtual_network', None)
        self.allow_hub_to_remote_vnet_transit = kwargs.get('allow_hub_to_remote_vnet_transit', None)
        self.allow_remote_vnet_to_use_hub_vnet_gateways = kwargs.get('allow_remote_vnet_to_use_hub_vnet_gateways', None)
        self.enable_internet_security = kwargs.get('enable_internet_security', None)
        self.provisioning_state = None


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of inbound NAT pools used
     by the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param protocol: The reference to the transport protocol used by the inbound NAT pool. Possible
     values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.TransportProtocol
    :param frontend_port_range_start: The first port number in the range of external ports that
     will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
     range between 1 and 65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: The last port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :type frontend_port_range_end: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT pool resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundNatPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port_range_start = kwargs.get('frontend_port_range_start', None)
        self.frontend_port_range_end = kwargs.get('frontend_port_range_end', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.enable_tcp_reset = kwargs.get('enable_tcp_reset', None)
        self.provisioning_state = None


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of inbound NAT rules used
     by the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration
    :param protocol: The reference to the transport protocol used by the load balancing rule.
     Possible values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT rule resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'backend_ip_configuration': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundNatRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_ip_configuration = None
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.enable_tcp_reset = kwargs.get('enable_tcp_reset', None)
        self.provisioning_state = None


class InboundNatRuleListResult(msrest.serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of inbound nat rules in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundNatRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundNatRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IPAddressAvailabilityResult(msrest.serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :param available: Private IP address availability.
    :type available: bool
    :param available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :type available_ip_addresses: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
        'available_ip_addresses': {'key': 'availableIPAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPAddressAvailabilityResult, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)
        self.available_ip_addresses = kwargs.get('available_ip_addresses', None)


class IpAllocation(Resource):
    """IpAllocation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The Subnet that using the prefix of this IpAllocation resource.
    :vartype subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar virtual_network: The VirtualNetwork that using the prefix of this IpAllocation resource.
    :vartype virtual_network: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param type_properties_type: The type for the IpAllocation. Possible values include:
     "Undefined", "Hypernet".
    :type type_properties_type: str or ~azure.mgmt.network.v2020_03_01.models.IpAllocationType
    :param prefix: The address prefix for the IpAllocation.
    :type prefix: str
    :param prefix_length: The address prefix length for the IpAllocation.
    :type prefix_length: int
    :param prefix_type: The address prefix Type for the IpAllocation. Possible values include:
     "IPv4", "IPv6".
    :type prefix_type: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    :param ipam_allocation_id: The IPAM allocation ID.
    :type ipam_allocation_id: str
    :param allocation_tags: IpAllocation tags.
    :type allocation_tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'subnet': {'readonly': True},
        'virtual_network': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'SubResource'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'prefix_length': {'key': 'properties.prefixLength', 'type': 'int'},
        'prefix_type': {'key': 'properties.prefixType', 'type': 'str'},
        'ipam_allocation_id': {'key': 'properties.ipamAllocationId', 'type': 'str'},
        'allocation_tags': {'key': 'properties.allocationTags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpAllocation, self).__init__(**kwargs)
        self.etag = None
        self.subnet = None
        self.virtual_network = None
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.prefix = kwargs.get('prefix', None)
        self.prefix_length = kwargs.get('prefix_length', 0)
        self.prefix_type = kwargs.get('prefix_type', None)
        self.ipam_allocation_id = kwargs.get('ipam_allocation_id', None)
        self.allocation_tags = kwargs.get('allocation_tags', None)


class IpAllocationListResult(msrest.serialization.Model):
    """Response for the ListIpAllocations API service call.

    :param value: A list of IpAllocation resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.IpAllocation]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IpAllocation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpAllocationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class IPConfiguration(SubResource):
    """IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param subnet: The reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :param public_ip_address: The reference to the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = None


class IPConfigurationBgpPeeringAddress(msrest.serialization.Model):
    """Properties of IPConfigurationBgpPeeringAddress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param ipconfiguration_id: The ID of IP configuration which belongs to gateway.
    :type ipconfiguration_id: str
    :ivar default_bgp_ip_addresses: The list of default BGP peering addresses which belong to IP
     configuration.
    :vartype default_bgp_ip_addresses: list[str]
    :param custom_bgp_ip_addresses: The list of custom BGP peering addresses which belong to IP
     configuration.
    :type custom_bgp_ip_addresses: list[str]
    :ivar tunnel_ip_addresses: The list of tunnel public IP addresses which belong to IP
     configuration.
    :vartype tunnel_ip_addresses: list[str]
    """

    _validation = {
        'default_bgp_ip_addresses': {'readonly': True},
        'tunnel_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'ipconfiguration_id': {'key': 'ipconfigurationId', 'type': 'str'},
        'default_bgp_ip_addresses': {'key': 'defaultBgpIpAddresses', 'type': '[str]'},
        'custom_bgp_ip_addresses': {'key': 'customBgpIpAddresses', 'type': '[str]'},
        'tunnel_ip_addresses': {'key': 'tunnelIpAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPConfigurationBgpPeeringAddress, self).__init__(**kwargs)
        self.ipconfiguration_id = kwargs.get('ipconfiguration_id', None)
        self.default_bgp_ip_addresses = None
        self.custom_bgp_ip_addresses = kwargs.get('custom_bgp_ip_addresses', None)
        self.tunnel_ip_addresses = None


class IPConfigurationProfile(SubResource):
    """IP configuration profile child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource. This name can be used to access the resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param subnet: The reference to the subnet resource to create a container network interface ip
     configuration.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :ivar provisioning_state: The provisioning state of the IP configuration profile resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPConfigurationProfile, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.subnet = kwargs.get('subnet', None)
        self.provisioning_state = None


class IpGroup(Resource):
    """The IpGroups resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the IpGroups resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param ip_addresses: IpAddresses/IpAddressPrefixes in the IpGroups resource.
    :type ip_addresses: list[str]
    :ivar firewalls: List of references to Azure resources that this IpGroups is associated with.
    :vartype firewalls: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'firewalls': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
        'firewalls': {'key': 'properties.firewalls', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpGroup, self).__init__(**kwargs)
        self.etag = None
        self.provisioning_state = None
        self.ip_addresses = kwargs.get('ip_addresses', None)
        self.firewalls = None


class IpGroupListResult(msrest.serialization.Model):
    """Response for the ListIpGroups API service call.

    :param value: The list of IpGroups information resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.IpGroup]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IpGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class IpsecPolicy(msrest.serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE phase 1). Possible
     values include: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192",
     "GCMAES256".
    :type ipsec_encryption: str or ~azure.mgmt.network.v2020_03_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase 1). Possible values
     include: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", "GCMAES256".
    :type ipsec_integrity: str or ~azure.mgmt.network.v2020_03_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase 2). Possible values
     include: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", "GCMAES128".
    :type ike_encryption: str or ~azure.mgmt.network.v2020_03_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2). Possible values
     include: "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", "GCMAES128".
    :type ike_integrity: str or ~azure.mgmt.network.v2020_03_01.models.IkeIntegrity
    :param dh_group: Required. The DH Group used in IKE Phase 1 for initial SA. Possible values
     include: "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384",
     "DHGroup24".
    :type dh_group: str or ~azure.mgmt.network.v2020_03_01.models.DhGroup
    :param pfs_group: Required. The Pfs Group used in IKE Phase 2 for new child SA. Possible values
     include: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", "PFSMM".
    :type pfs_group: str or ~azure.mgmt.network.v2020_03_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpsecPolicy, self).__init__(**kwargs)
        self.sa_life_time_seconds = kwargs['sa_life_time_seconds']
        self.sa_data_size_kilobytes = kwargs['sa_data_size_kilobytes']
        self.ipsec_encryption = kwargs['ipsec_encryption']
        self.ipsec_integrity = kwargs['ipsec_integrity']
        self.ike_encryption = kwargs['ike_encryption']
        self.ike_integrity = kwargs['ike_integrity']
        self.dh_group = kwargs['dh_group']
        self.pfs_group = kwargs['pfs_group']


class IpTag(msrest.serialization.Model):
    """Contains the IpTag associated with the object.

    :param ip_tag_type: The IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: The value of the IP tag associated with the public IP. Example: SQL.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpTag, self).__init__(**kwargs)
        self.ip_tag_type = kwargs.get('ip_tag_type', None)
        self.tag = kwargs.get('tag', None)


class Ipv6CircuitConnectionConfig(msrest.serialization.Model):
    """IPv6 Circuit Connection properties for global reach.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param address_prefix: /125 IP address space to carve out customer addresses for global reach.
    :type address_prefix: str
    :ivar circuit_connection_status: Express Route Circuit connection state. Possible values
     include: "Connected", "Connecting", "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.CircuitConnectionStatus
    """

    _validation = {
        'circuit_connection_status': {'readonly': True},
    }

    _attribute_map = {
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
        'circuit_connection_status': {'key': 'circuitConnectionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Ipv6CircuitConnectionConfig, self).__init__(**kwargs)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.circuit_connection_status = None


class Ipv6ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Contains IPv6 peering config.

    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringConfig
    :param route_filter: The reference to the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param state: The state of peering. Possible values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        'primary_peer_address_prefix': {'key': 'primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'secondaryPeerAddressPrefix', 'type': 'str'},
        'microsoft_peering_config': {'key': 'microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'route_filter': {'key': 'routeFilter', 'type': 'SubResource'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Ipv6ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.route_filter = kwargs.get('route_filter', None)
        self.state = kwargs.get('state', None)


class ListHubVirtualNetworkConnectionsResult(msrest.serialization.Model):
    """List of HubVirtualNetworkConnections and a URL nextLink to get the next set of results.

    :param value: List of HubVirtualNetworkConnections.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.HubVirtualNetworkConnection]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HubVirtualNetworkConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListHubVirtualNetworkConnectionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListP2SVpnGatewaysResult(msrest.serialization.Model):
    """Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL nextLink to get the next set of results.

    :param value: List of P2SVpnGateways.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.P2SVpnGateway]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[P2SVpnGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListP2SVpnGatewaysResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVirtualHubRouteTableV2SResult(msrest.serialization.Model):
    """List of VirtualHubRouteTableV2s and a URL nextLink to get the next set of results.

    :param value: List of VirtualHubRouteTableV2s.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualHubRouteTableV2]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualHubRouteTableV2]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVirtualHubRouteTableV2SResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVirtualHubsResult(msrest.serialization.Model):
    """Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink to get the next set of results.

    :param value: List of VirtualHubs.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualHub]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualHub]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVirtualHubsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVirtualWANsResult(msrest.serialization.Model):
    """Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink to get the next set of results.

    :param value: List of VirtualWANs.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualWAN]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualWAN]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVirtualWANsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnConnectionsResult(msrest.serialization.Model):
    """Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results.

    :param value: List of Vpn Connections.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnConnection]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnConnectionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnGatewaysResult(msrest.serialization.Model):
    """Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink to get the next set of results.

    :param value: List of VpnGateways.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnGateway]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnGatewaysResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnServerConfigurationsResult(msrest.serialization.Model):
    """Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations and a URL nextLink to get the next set of results.

    :param value: List of VpnServerConfigurations.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnServerConfiguration]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnServerConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnServerConfigurationsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnSiteLinkConnectionsResult(msrest.serialization.Model):
    """Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results.

    :param value: List of VpnSiteLinkConnections.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnSiteLinkConnection]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnSiteLinkConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnSiteLinkConnectionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnSiteLinksResult(msrest.serialization.Model):
    """Result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks and a URL nextLink to get the next set of results.

    :param value: List of VpnSitesLinks.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnSiteLink]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnSiteLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnSiteLinksResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ListVpnSitesResult(msrest.serialization.Model):
    """Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to get the next set of results.

    :param value: List of VpnSites.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnSite]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnSite]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListVpnSitesResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The load balancer SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.LoadBalancerSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by a load balancer.
    :type backend_address_pools: list[~azure.mgmt.network.v2020_03_01.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :type load_balancing_rules: list[~azure.mgmt.network.v2020_03_01.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer.
    :type probes: list[~azure.mgmt.network.v2020_03_01.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2020_03_01.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2020_03_01.models.InboundNatPool]
    :param outbound_rules: The outbound rules.
    :type outbound_rules: list[~azure.mgmt.network.v2020_03_01.models.OutboundRule]
    :ivar resource_guid: The resource GUID property of the load balancer resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the load balancer resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'LoadBalancerSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[OutboundRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancer, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.etag = None
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.load_balancing_rules = kwargs.get('load_balancing_rules', None)
        self.probes = kwargs.get('probes', None)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)
        self.outbound_rules = kwargs.get('outbound_rules', None)
        self.resource_guid = None
        self.provisioning_state = None


class LoadBalancerBackendAddressPoolListResult(msrest.serialization.Model):
    """Response for ListBackendAddressPool API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of backend address pools in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.BackendAddressPool]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendAddressPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerBackendAddressPoolListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerFrontendIPConfigurationListResult(msrest.serialization.Model):
    """Response for ListFrontendIPConfiguration API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of frontend IP configurations in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.FrontendIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FrontendIPConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerFrontendIPConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerListResult(msrest.serialization.Model):
    """Response for ListLoadBalancers API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancers in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerLoadBalancingRuleListResult(msrest.serialization.Model):
    """Response for ListLoadBalancingRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancing rules in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.LoadBalancingRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancingRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerLoadBalancingRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerOutboundRuleListResult(msrest.serialization.Model):
    """Response for ListOutboundRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of outbound rules in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.OutboundRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerOutboundRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerProbeListResult(msrest.serialization.Model):
    """Response for ListProbe API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of probes in a load balancer.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.Probe]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Probe]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerProbeListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LoadBalancerSku(msrest.serialization.Model):
    """SKU of a load balancer.

    :param name: Name of a load balancer SKU. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.LoadBalancerSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of load balancing rules
     used by the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param probe: The reference to the load balancer probe used by the load balancing rule.
    :type probe: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param protocol: The reference to the transport protocol used by the load balancing rule.
     Possible values include: "Udp", "Tcp", "All".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule. Possible values include:
     "Default", "SourceIP", "SourceIPProtocol".
    :type load_distribution: str or ~azure.mgmt.network.v2020_03_01.models.LoadDistribution
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
     enables "Any Port".
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 0 and 65535. Note that value 0 enables "Any Port".
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :param disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
     publicIP address specified in the frontend of the load balancing rule.
    :type disable_outbound_snat: bool
    :ivar provisioning_state: The provisioning state of the load balancing rule resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'disable_outbound_snat': {'key': 'properties.disableOutboundSnat', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.probe = kwargs.get('probe', None)
        self.protocol = kwargs.get('protocol', None)
        self.load_distribution = kwargs.get('load_distribution', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.enable_tcp_reset = kwargs.get('enable_tcp_reset', None)
        self.disable_outbound_snat = kwargs.get('disable_outbound_snat', None)
        self.provisioning_state = None


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param fqdn: FQDN of local network gateway.
    :type fqdn: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2020_03_01.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the local network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the local network gateway resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalNetworkGateway, self).__init__(**kwargs)
        self.etag = None
        self.local_network_address_space = kwargs.get('local_network_address_space', None)
        self.gateway_ip_address = kwargs.get('gateway_ip_address', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.resource_guid = None
        self.provisioning_state = None


class LocalNetworkGatewayListResult(msrest.serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of local network gateways that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class LogSpecification(msrest.serialization.Model):
    """Description of logging specification.

    :param name: The name of the specification.
    :type name: str
    :param display_name: The display name of the specification.
    :type display_name: str
    :param blob_duration: Duration of the blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class ManagedRuleGroupOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The managed rule group to override.
    :type rule_group_name: str
    :param rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = kwargs['rule_group_name']
        self.rules = kwargs.get('rules', None)


class ManagedRuleOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param state: The state of the managed rule. Defaults to Disabled if not specified. Possible
     values include: "Disabled".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.ManagedRuleEnabledState
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = kwargs['rule_id']
        self.state = kwargs.get('state', None)


class ManagedRulesDefinition(msrest.serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param exclusions: The Exclusions that are applied on the policy.
    :type exclusions: list[~azure.mgmt.network.v2020_03_01.models.OwaspCrsExclusionEntry]
    :param managed_rule_sets: Required. The managed rule sets that are associated with the policy.
    :type managed_rule_sets: list[~azure.mgmt.network.v2020_03_01.models.ManagedRuleSet]
    """

    _validation = {
        'managed_rule_sets': {'required': True},
    }

    _attribute_map = {
        'exclusions': {'key': 'exclusions', 'type': '[OwaspCrsExclusionEntry]'},
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRulesDefinition, self).__init__(**kwargs)
        self.exclusions = kwargs.get('exclusions', None)
        self.managed_rule_sets = kwargs['managed_rule_sets']


class ManagedRuleSet(msrest.serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to use.
    :type rule_set_version: str
    :param rule_group_overrides: Defines the rule group overrides to apply to the rule set.
    :type rule_group_overrides:
     list[~azure.mgmt.network.v2020_03_01.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = kwargs['rule_set_type']
        self.rule_set_version = kwargs['rule_set_version']
        self.rule_group_overrides = kwargs.get('rule_group_overrides', None)


class ManagedServiceIdentity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This property will only
     be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the resource. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Possible
     values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.network.v2020_03_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with resource. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.network.v2020_03_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class MatchCondition(msrest.serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :param match_variables: Required. List of match variables.
    :type match_variables: list[~azure.mgmt.network.v2020_03_01.models.MatchVariable]
    :param operator: Required. The operator to be matched. Possible values include: "IPMatch",
     "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual",
     "BeginsWith", "EndsWith", "Regex", "GeoMatch".
    :type operator: str or ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallOperator
    :param negation_conditon: Whether this is negate condition or not.
    :type negation_conditon: bool
    :param match_values: Required. Match value.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or
     ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallTransform]
    """

    _validation = {
        'match_variables': {'required': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'match_variables': {'key': 'matchVariables', 'type': '[MatchVariable]'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negation_conditon': {'key': 'negationConditon', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variables = kwargs['match_variables']
        self.operator = kwargs['operator']
        self.negation_conditon = kwargs.get('negation_conditon', None)
        self.match_values = kwargs['match_values']
        self.transforms = kwargs.get('transforms', None)


class MatchedRule(msrest.serialization.Model):
    """Matched rule.

    :param rule_name: Name of the matched network security rule.
    :type rule_name: str
    :param action: The network traffic is allowed or denied. Possible values are 'Allow' and
     'Deny'.
    :type action: str
    """

    _attribute_map = {
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MatchedRule, self).__init__(**kwargs)
        self.rule_name = kwargs.get('rule_name', None)
        self.action = kwargs.get('action', None)


class MatchVariable(msrest.serialization.Model):
    """Define match variables.

    All required parameters must be populated in order to send to Azure.

    :param variable_name: Required. Match Variable. Possible values include: "RemoteAddr",
     "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeaders", "RequestBody",
     "RequestCookies".
    :type variable_name: str or
     ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallMatchVariable
    :param selector: The selector of match variable.
    :type selector: str
    """

    _validation = {
        'variable_name': {'required': True},
    }

    _attribute_map = {
        'variable_name': {'key': 'variableName', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MatchVariable, self).__init__(**kwargs)
        self.variable_name = kwargs['variable_name']
        self.selector = kwargs.get('selector', None)


class MetricSpecification(msrest.serialization.Model):
    """Description of metrics specification.

    :param name: The name of the metric.
    :type name: str
    :param display_name: The display name of the metric.
    :type display_name: str
    :param display_description: The description of the metric.
    :type display_description: str
    :param unit: Units the metric to be displayed in.
    :type unit: str
    :param aggregation_type: The aggregation type.
    :type aggregation_type: str
    :param availabilities: List of availability.
    :type availabilities: list[~azure.mgmt.network.v2020_03_01.models.Availability]
    :param enable_regional_mdm_account: Whether regional MDM account enabled.
    :type enable_regional_mdm_account: bool
    :param fill_gap_with_zero: Whether gaps would be filled with zeros.
    :type fill_gap_with_zero: bool
    :param metric_filter_pattern: Pattern for the filter of the metric.
    :type metric_filter_pattern: str
    :param dimensions: List of dimensions.
    :type dimensions: list[~azure.mgmt.network.v2020_03_01.models.Dimension]
    :param is_internal: Whether the metric is internal.
    :type is_internal: bool
    :param source_mdm_account: The source MDM account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The source MDM namespace.
    :type source_mdm_namespace: str
    :param resource_id_dimension_name_override: The resource Id dimension name override.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[Availability]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.availabilities = kwargs.get('availabilities', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.is_internal = kwargs.get('is_internal', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)


class NatGateway(Resource):
    """Nat Gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The nat gateway SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.NatGatewaySku
    :param zones: A list of availability zones denoting the zone in which Nat Gateway should be
     deployed.
    :type zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param idle_timeout_in_minutes: The idle timeout of the nat gateway.
    :type idle_timeout_in_minutes: int
    :param public_ip_addresses: An array of public ip addresses associated with the nat gateway
     resource.
    :type public_ip_addresses: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param public_ip_prefixes: An array of public ip prefixes associated with the nat gateway
     resource.
    :type public_ip_prefixes: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar subnets: An array of references to the subnets using this nat gateway resource.
    :vartype subnets: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar resource_guid: The resource GUID property of the NAT gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the NAT gateway resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'subnets': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'NatGatewaySku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'etag': {'key': 'etag', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'public_ip_addresses': {'key': 'properties.publicIpAddresses', 'type': '[SubResource]'},
        'public_ip_prefixes': {'key': 'properties.publicIpPrefixes', 'type': '[SubResource]'},
        'subnets': {'key': 'properties.subnets', 'type': '[SubResource]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NatGateway, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.zones = kwargs.get('zones', None)
        self.etag = None
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.public_ip_addresses = kwargs.get('public_ip_addresses', None)
        self.public_ip_prefixes = kwargs.get('public_ip_prefixes', None)
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None


class NatGatewayListResult(msrest.serialization.Model):
    """Response for ListNatGateways API service call.

    :param value: A list of Nat Gateways that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NatGateway]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NatGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NatGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NatGatewaySku(msrest.serialization.Model):
    """SKU of nat gateway.

    :param name: Name of Nat Gateway SKU. Possible values include: "Standard".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.NatGatewaySkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NatGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class NatRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type nat.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Rule Condition Type.Constant filled by server.  Possible
     values include: "ApplicationRuleCondition", "NetworkRuleCondition", "NatRuleCondition".
    :type rule_condition_type: str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionType
    :param ip_protocols: Array of FirewallPolicyRuleConditionNetworkProtocols.
    :type ip_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionNetworkProtocol]
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses or Service Tags.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
        'ip_protocols': {'key': 'ipProtocols', 'type': '[str]'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NatRuleCondition, self).__init__(**kwargs)
        self.rule_condition_type = 'NatRuleCondition'  # type: str
        self.ip_protocols = kwargs.get('ip_protocols', None)
        self.source_addresses = kwargs.get('source_addresses', None)
        self.destination_addresses = kwargs.get('destination_addresses', None)
        self.destination_ports = kwargs.get('destination_ports', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)


class NetworkConfigurationDiagnosticParameters(msrest.serialization.Model):
    """Parameters to get network configuration diagnostic.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to perform network
     configuration diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and
     Application Gateway.
    :type target_resource_id: str
    :param verbosity_level: Verbosity level. Possible values include: "Normal", "Minimum", "Full".
    :type verbosity_level: str or ~azure.mgmt.network.v2020_03_01.models.VerbosityLevel
    :param profiles: Required. List of network configuration diagnostic profiles.
    :type profiles:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkConfigurationDiagnosticProfile]
    """

    _validation = {
        'target_resource_id': {'required': True},
        'profiles': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'verbosity_level': {'key': 'verbosityLevel', 'type': 'str'},
        'profiles': {'key': 'profiles', 'type': '[NetworkConfigurationDiagnosticProfile]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkConfigurationDiagnosticParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.verbosity_level = kwargs.get('verbosity_level', None)
        self.profiles = kwargs['profiles']


class NetworkConfigurationDiagnosticProfile(msrest.serialization.Model):
    """Parameters to compare with network configuration.

    All required parameters must be populated in order to send to Azure.

    :param direction: Required. The direction of the traffic. Possible values include: "Inbound",
     "Outbound".
    :type direction: str or ~azure.mgmt.network.v2020_03_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Accepted values are '*', TCP, UDP.
    :type protocol: str
    :param source: Required. Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
    :type source: str
    :param destination: Required. Traffic destination. Accepted values are: '*', IP Address/CIDR,
     Service Tag.
    :type destination: str
    :param destination_port: Required. Traffic destination port. Accepted values are '*' and a
     single port in the range (0 - 65535).
    :type destination_port: str
    """

    _validation = {
        'direction': {'required': True},
        'protocol': {'required': True},
        'source': {'required': True},
        'destination': {'required': True},
        'destination_port': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkConfigurationDiagnosticProfile, self).__init__(**kwargs)
        self.direction = kwargs['direction']
        self.protocol = kwargs['protocol']
        self.source = kwargs['source']
        self.destination = kwargs['destination']
        self.destination_port = kwargs['destination_port']


class NetworkConfigurationDiagnosticResponse(msrest.serialization.Model):
    """Results of network configuration diagnostic on the target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar results: List of network configuration diagnostic results.
    :vartype results:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkConfigurationDiagnosticResult]
    """

    _validation = {
        'results': {'readonly': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': '[NetworkConfigurationDiagnosticResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkConfigurationDiagnosticResponse, self).__init__(**kwargs)
        self.results = None


class NetworkConfigurationDiagnosticResult(msrest.serialization.Model):
    """Network configuration diagnostic result corresponded to provided traffic query.

    :param profile: Network configuration diagnostic profile.
    :type profile: ~azure.mgmt.network.v2020_03_01.models.NetworkConfigurationDiagnosticProfile
    :param network_security_group_result: Network security group result.
    :type network_security_group_result:
     ~azure.mgmt.network.v2020_03_01.models.NetworkSecurityGroupResult
    """

    _attribute_map = {
        'profile': {'key': 'profile', 'type': 'NetworkConfigurationDiagnosticProfile'},
        'network_security_group_result': {'key': 'networkSecurityGroupResult', 'type': 'NetworkSecurityGroupResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkConfigurationDiagnosticResult, self).__init__(**kwargs)
        self.profile = kwargs.get('profile', None)
        self.network_security_group_result = kwargs.get('network_security_group_result', None)


class NetworkIntentPolicy(Resource):
    """Network Intent Policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkIntentPolicy, self).__init__(**kwargs)
        self.etag = None


class NetworkIntentPolicyConfiguration(msrest.serialization.Model):
    """Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.

    :param network_intent_policy_name: The name of the Network Intent Policy for storing in target
     subscription.
    :type network_intent_policy_name: str
    :param source_network_intent_policy: Source network intent policy.
    :type source_network_intent_policy: ~azure.mgmt.network.v2020_03_01.models.NetworkIntentPolicy
    """

    _attribute_map = {
        'network_intent_policy_name': {'key': 'networkIntentPolicyName', 'type': 'str'},
        'source_network_intent_policy': {'key': 'sourceNetworkIntentPolicy', 'type': 'NetworkIntentPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkIntentPolicyConfiguration, self).__init__(**kwargs)
        self.network_intent_policy_name = kwargs.get('network_intent_policy_name', None)
        self.source_network_intent_policy = kwargs.get('source_network_intent_policy', None)


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_machine: The reference to a virtual machine.
    :vartype virtual_machine: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param network_security_group: The reference to the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2020_03_01.models.NetworkSecurityGroup
    :ivar private_endpoint: A reference to the private endpoint to which the network interface is
     linked.
    :vartype private_endpoint: ~azure.mgmt.network.v2020_03_01.models.PrivateEndpoint
    :param ip_configurations: A list of IPConfigurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration]
    :ivar tap_configurations: A list of TapConfigurations of the network interface.
    :vartype tap_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceTapConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings: ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Whether this is a primary network interface on a virtual machine.
    :vartype primary: bool
    :param enable_accelerated_networking: If the network interface is accelerated networking
     enabled.
    :type enable_accelerated_networking: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :type enable_ip_forwarding: bool
    :ivar hosted_workloads: A list of references to linked BareMetal resources.
    :vartype hosted_workloads: list[str]
    :ivar resource_guid: The resource GUID property of the network interface resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network interface resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_machine': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'tap_configurations': {'readonly': True},
        'mac_address': {'readonly': True},
        'primary': {'readonly': True},
        'hosted_workloads': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'tap_configurations': {'key': 'properties.tapConfigurations', 'type': '[NetworkInterfaceTapConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'hosted_workloads': {'key': 'properties.hostedWorkloads', 'type': '[str]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(**kwargs)
        self.etag = None
        self.virtual_machine = None
        self.network_security_group = kwargs.get('network_security_group', None)
        self.private_endpoint = None
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.tap_configurations = None
        self.dns_settings = kwargs.get('dns_settings', None)
        self.mac_address = None
        self.primary = None
        self.enable_accelerated_networking = kwargs.get('enable_accelerated_networking', None)
        self.enable_ip_forwarding = kwargs.get('enable_ip_forwarding', None)
        self.hosted_workloads = None
        self.resource_guid = None
        self.provisioning_state = None


class NetworkInterfaceAssociation(msrest.serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = kwargs.get('security_rules', None)


class NetworkInterfaceDnsSettings(msrest.serialization.Model):
    """DNS settings of a network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :type dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in
     the same virtual network.
    :vartype internal_fqdn: str
    :ivar internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry
     is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the
     VM name with the value of internalDomainNameSuffix.
    :vartype internal_domain_name_suffix: str
    """

    _validation = {
        'applied_dns_servers': {'readonly': True},
        'internal_fqdn': {'readonly': True},
        'internal_domain_name_suffix': {'readonly': True},
    }

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
        'internal_domain_name_suffix': {'key': 'internalDomainNameSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)
        self.applied_dns_servers = None
        self.internal_dns_name_label = kwargs.get('internal_dns_name_label', None)
        self.internal_fqdn = None
        self.internal_domain_name_suffix = None


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_network_taps: The reference to Virtual Network Taps.
    :type virtual_network_taps: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkTap]
    :param application_gateway_backend_address_pools: The reference to
     ApplicationGatewayBackendAddressPool resource.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationGatewayBackendAddressPool]
    :param load_balancer_backend_address_pools: The reference to LoadBalancerBackendAddressPool
     resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2020_03_01.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2020_03_01.models.InboundNatRule]
    :param private_ip_address: Private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
     Default is IPv4. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    :param subnet: Subnet bound to the IP configuration.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :param primary: Whether this is a primary customer address on the network interface.
    :type primary: bool
    :param public_ip_address: Public IP address bound to the IP configuration.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.PublicIPAddress
    :param application_security_groups: Application security groups in which the IP configuration
     is included.
    :type application_security_groups:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationSecurityGroup]
    :ivar provisioning_state: The provisioning state of the network interface IP configuration.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar private_link_connection_properties: PrivateLinkConnection properties for the network
     interface.
    :vartype private_link_connection_properties:
     ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_link_connection_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_network_taps': {'key': 'properties.virtualNetworkTaps', 'type': '[VirtualNetworkTap]'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_connection_properties': {'key': 'properties.privateLinkConnectionProperties', 'type': 'NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.virtual_network_taps = kwargs.get('virtual_network_taps', None)
        self.application_gateway_backend_address_pools = kwargs.get('application_gateway_backend_address_pools', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_rules = kwargs.get('load_balancer_inbound_nat_rules', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.application_security_groups = kwargs.get('application_security_groups', None)
        self.provisioning_state = None
        self.private_link_connection_properties = None


class NetworkInterfaceIPConfigurationListResult(msrest.serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of ip configurations.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterfaceIPConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceIPConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties(msrest.serialization.Model):
    """PrivateLinkConnection properties for the network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The group ID for current private link connection.
    :vartype group_id: str
    :ivar required_member_name: The required member name for current private link connection.
    :vartype required_member_name: str
    :ivar fqdns: List of FQDNs for current private link connection.
    :vartype fqdns: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_member_name': {'readonly': True},
        'fqdns': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_member_name': {'key': 'requiredMemberName', 'type': 'str'},
        'fqdns': {'key': 'fqdns', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_member_name = None
        self.fqdns = None


class NetworkInterfaceListResult(msrest.serialization.Model):
    """Response for the ListNetworkInterface API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of network interfaces in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterface]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class NetworkInterfaceLoadBalancerListResult(msrest.serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of load balancers.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceLoadBalancerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class NetworkInterfaceTapConfiguration(SubResource):
    """Tap configuration in a Network Interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :param virtual_network_tap: The reference to the Virtual Network Tap resource.
    :type virtual_network_tap: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkTap
    :ivar provisioning_state: The provisioning state of the network interface tap configuration
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_tap': {'key': 'properties.virtualNetworkTap', 'type': 'VirtualNetworkTap'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceTapConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.virtual_network_tap = kwargs.get('virtual_network_tap', None)
        self.provisioning_state = None


class NetworkInterfaceTapConfigurationListResult(msrest.serialization.Model):
    """Response for list tap configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of tap configurations.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceTapConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterfaceTapConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceTapConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class NetworkProfile(Resource):
    """Network profile resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interfaces: List of child container network interfaces.
    :vartype container_network_interfaces:
     list[~azure.mgmt.network.v2020_03_01.models.ContainerNetworkInterface]
    :param container_network_interface_configurations: List of chid container network interface
     configurations.
    :type container_network_interface_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.ContainerNetworkInterfaceConfiguration]
    :ivar resource_guid: The resource GUID property of the network profile resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network profile resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'container_network_interfaces': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'container_network_interfaces': {'key': 'properties.containerNetworkInterfaces', 'type': '[ContainerNetworkInterface]'},
        'container_network_interface_configurations': {'key': 'properties.containerNetworkInterfaceConfigurations', 'type': '[ContainerNetworkInterfaceConfiguration]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.etag = None
        self.container_network_interfaces = None
        self.container_network_interface_configurations = kwargs.get('container_network_interface_configurations', None)
        self.resource_guid = None
        self.provisioning_state = None


class NetworkProfileListResult(msrest.serialization.Model):
    """Response for ListNetworkProfiles API service call.

    :param value: A list of network profiles that exist in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkProfile]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkProfile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfileListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetworkRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type network.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Rule Condition Type.Constant filled by server.  Possible
     values include: "ApplicationRuleCondition", "NetworkRuleCondition", "NatRuleCondition".
    :type rule_condition_type: str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionType
    :param ip_protocols: Array of FirewallPolicyRuleConditionNetworkProtocols.
    :type ip_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.FirewallPolicyRuleConditionNetworkProtocol]
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses or Service Tags.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    :param destination_ip_groups: List of destination IpGroups for this rule.
    :type destination_ip_groups: list[str]
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
        'ip_protocols': {'key': 'ipProtocols', 'type': '[str]'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
        'destination_ip_groups': {'key': 'destinationIpGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleCondition, self).__init__(**kwargs)
        self.rule_condition_type = 'NetworkRuleCondition'  # type: str
        self.ip_protocols = kwargs.get('ip_protocols', None)
        self.source_addresses = kwargs.get('source_addresses', None)
        self.destination_addresses = kwargs.get('destination_addresses', None)
        self.destination_ports = kwargs.get('destination_ports', None)
        self.source_ip_groups = kwargs.get('source_ip_groups', None)
        self.destination_ip_groups = kwargs.get('destination_ip_groups', None)


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param security_rules: A collection of security rules of the network security group.
    :type security_rules: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network security group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2020_03_01.models.Subnet]
    :ivar flow_logs: A collection of references to flow log resources.
    :vartype flow_logs: list[~azure.mgmt.network.v2020_03_01.models.FlowLog]
    :ivar resource_guid: The resource GUID property of the network security group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network security group resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'default_security_rules': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'subnets': {'readonly': True},
        'flow_logs': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'flow_logs': {'key': 'properties.flowLogs', 'type': '[FlowLog]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityGroup, self).__init__(**kwargs)
        self.etag = None
        self.security_rules = kwargs.get('security_rules', None)
        self.default_security_rules = None
        self.network_interfaces = None
        self.subnets = None
        self.flow_logs = None
        self.resource_guid = None
        self.provisioning_state = None


class NetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :param value: A list of NetworkSecurityGroup resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkSecurityGroup]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetworkSecurityGroupResult(msrest.serialization.Model):
    """Network configuration diagnostic result corresponded provided traffic query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param security_rule_access_result: The network traffic is allowed or denied. Possible values
     include: "Allow", "Deny".
    :type security_rule_access_result: str or
     ~azure.mgmt.network.v2020_03_01.models.SecurityRuleAccess
    :ivar evaluated_network_security_groups: List of results network security groups diagnostic.
    :vartype evaluated_network_security_groups:
     list[~azure.mgmt.network.v2020_03_01.models.EvaluatedNetworkSecurityGroup]
    """

    _validation = {
        'evaluated_network_security_groups': {'readonly': True},
    }

    _attribute_map = {
        'security_rule_access_result': {'key': 'securityRuleAccessResult', 'type': 'str'},
        'evaluated_network_security_groups': {'key': 'evaluatedNetworkSecurityGroups', 'type': '[EvaluatedNetworkSecurityGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityGroupResult, self).__init__(**kwargs)
        self.security_rule_access_result = kwargs.get('security_rule_access_result', None)
        self.evaluated_network_security_groups = None


class NetworkSecurityRulesEvaluationResult(msrest.serialization.Model):
    """Network security rules evaluation result.

    :param name: Name of the network security rule.
    :type name: str
    :param protocol_matched: Value indicating whether protocol is matched.
    :type protocol_matched: bool
    :param source_matched: Value indicating whether source is matched.
    :type source_matched: bool
    :param source_port_matched: Value indicating whether source port is matched.
    :type source_port_matched: bool
    :param destination_matched: Value indicating whether destination is matched.
    :type destination_matched: bool
    :param destination_port_matched: Value indicating whether destination port is matched.
    :type destination_port_matched: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol_matched': {'key': 'protocolMatched', 'type': 'bool'},
        'source_matched': {'key': 'sourceMatched', 'type': 'bool'},
        'source_port_matched': {'key': 'sourcePortMatched', 'type': 'bool'},
        'destination_matched': {'key': 'destinationMatched', 'type': 'bool'},
        'destination_port_matched': {'key': 'destinationPortMatched', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityRulesEvaluationResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol_matched = kwargs.get('protocol_matched', None)
        self.source_matched = kwargs.get('source_matched', None)
        self.source_port_matched = kwargs.get('source_port_matched', None)
        self.destination_matched = kwargs.get('destination_matched', None)
        self.destination_port_matched = kwargs.get('destination_port_matched', None)


class NetworkVirtualAppliance(Resource):
    """NetworkVirtualAppliance Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The service principal that has read access to cloud-init and config blob.
    :type identity: ~azure.mgmt.network.v2020_03_01.models.ManagedServiceIdentity
    :param sku: Network Virtual Appliance SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.VirtualApplianceSkuProperties
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param boot_strap_configuration_blob: BootStrapConfigurationBlob storage URLs.
    :type boot_strap_configuration_blob: list[str]
    :param virtual_hub: The Virtual Hub where Network Virtual Appliance is being deployed.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param cloud_init_configuration_blob: CloudInitConfigurationBlob storage URLs.
    :type cloud_init_configuration_blob: list[str]
    :param virtual_appliance_asn: VirtualAppliance ASN.
    :type virtual_appliance_asn: long
    :ivar virtual_appliance_nics: List of Virtual Appliance Network Interfaces.
    :vartype virtual_appliance_nics:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualApplianceNicProperties]
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_appliance_asn': {'maximum': 4294967295, 'minimum': 0},
        'virtual_appliance_nics': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'sku': {'key': 'sku', 'type': 'VirtualApplianceSkuProperties'},
        'etag': {'key': 'etag', 'type': 'str'},
        'boot_strap_configuration_blob': {'key': 'properties.bootStrapConfigurationBlob', 'type': '[str]'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'cloud_init_configuration_blob': {'key': 'properties.cloudInitConfigurationBlob', 'type': '[str]'},
        'virtual_appliance_asn': {'key': 'properties.virtualApplianceAsn', 'type': 'long'},
        'virtual_appliance_nics': {'key': 'properties.virtualApplianceNics', 'type': '[VirtualApplianceNicProperties]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkVirtualAppliance, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.etag = None
        self.boot_strap_configuration_blob = kwargs.get('boot_strap_configuration_blob', None)
        self.virtual_hub = kwargs.get('virtual_hub', None)
        self.cloud_init_configuration_blob = kwargs.get('cloud_init_configuration_blob', None)
        self.virtual_appliance_asn = kwargs.get('virtual_appliance_asn', None)
        self.virtual_appliance_nics = None
        self.provisioning_state = None


class NetworkVirtualApplianceListResult(msrest.serialization.Model):
    """Response for ListNetworkVirtualAppliances API service call.

    :param value: List of Network Virtual Appliances.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkVirtualAppliance]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkVirtualAppliance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkVirtualApplianceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the network watcher resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkWatcher, self).__init__(**kwargs)
        self.etag = None
        self.provisioning_state = None


class NetworkWatcherListResult(msrest.serialization.Model):
    """Response for ListNetworkWatchers API service call.

    :param value: List of network watcher resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.NetworkWatcher]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkWatcher]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkWatcherListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class NextHopParameters(msrest.serialization.Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The resource identifier of the target resource against
     which the action is to be performed.
    :type target_resource_id: str
    :param source_ip_address: Required. The source IP address.
    :type source_ip_address: str
    :param destination_ip_address: Required. The destination IP address.
    :type destination_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
     enabled on any of the nics, then this parameter must be specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'source_ip_address': {'required': True},
        'destination_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'destination_ip_address': {'key': 'destinationIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NextHopParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.source_ip_address = kwargs['source_ip_address']
        self.destination_ip_address = kwargs['destination_ip_address']
        self.target_nic_resource_id = kwargs.get('target_nic_resource_id', None)


class NextHopResult(msrest.serialization.Model):
    """The information about next hop from the specified VM.

    :param next_hop_type: Next hop type. Possible values include: "Internet", "VirtualAppliance",
     "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2020_03_01.models.NextHopType
    :param next_hop_ip_address: Next hop IP Address.
    :type next_hop_ip_address: str
    :param route_table_id: The resource identifier for the route table associated with the route
     being returned. If the route being returned does not correspond to any user created routes then
     this field will be the string 'System Route'.
    :type route_table_id: str
    """

    _attribute_map = {
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
        'route_table_id': {'key': 'routeTableId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NextHopResult, self).__init__(**kwargs)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.route_table_id = kwargs.get('route_table_id', None)


class Operation(msrest.serialization.Model):
    """Network REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.network.v2020_03_01.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param service_specification: Specification of the service.
    :type service_specification:
     ~azure.mgmt.network.v2020_03_01.models.OperationPropertiesFormatServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationPropertiesFormatServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Network.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of the operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Network operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Network operations supported by the Network resource provider.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationPropertiesFormatServiceSpecification(msrest.serialization.Model):
    """Specification of the service.

    :param metric_specifications: Operation service specification.
    :type metric_specifications: list[~azure.mgmt.network.v2020_03_01.models.MetricSpecification]
    :param log_specifications: Operation log specification.
    :type log_specifications: list[~azure.mgmt.network.v2020_03_01.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationPropertiesFormatServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class OutboundRule(SubResource):
    """Outbound rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of outbound rules used by
     the load balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :type frontend_ip_configurations: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the outbound rule resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param protocol: The protocol for the outbound rule in load balancer. Possible values include:
     "Tcp", "Udp", "All".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.LoadBalancerOutboundRuleProtocol
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
    :type idle_timeout_in_minutes: int
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.allocated_outbound_ports = kwargs.get('allocated_outbound_ports', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.provisioning_state = None
        self.protocol = kwargs.get('protocol', None)
        self.enable_tcp_reset = kwargs.get('enable_tcp_reset', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)


class OwaspCrsExclusionEntry(msrest.serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable to be excluded. Possible values include:
     "RequestHeaderNames", "RequestCookieNames", "RequestArgNames".
    :type match_variable: str or
     ~azure.mgmt.network.v2020_03_01.models.OwaspCrsExclusionEntryMatchVariable
    :param selector_match_operator: Required. When matchVariable is a collection, operate on the
     selector to specify which elements in the collection this exclusion applies to. Possible values
     include: "Equals", "Contains", "StartsWith", "EndsWith", "EqualsAny".
    :type selector_match_operator: str or
     ~azure.mgmt.network.v2020_03_01.models.OwaspCrsExclusionEntrySelectorMatchOperator
    :param selector: Required. When matchVariable is a collection, operator used to specify which
     elements in the collection this exclusion applies to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OwaspCrsExclusionEntry, self).__init__(**kwargs)
        self.match_variable = kwargs['match_variable']
        self.selector_match_operator = kwargs['selector_match_operator']
        self.selector = kwargs['selector']


class P2SConnectionConfiguration(SubResource):
    """P2SConnectionConfiguration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param vpn_client_address_pool: The reference to the address space resource which represents
     Address space for P2S VpnClient.
    :type vpn_client_address_pool: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :ivar provisioning_state: The provisioning state of the P2SConnectionConfiguration resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'vpn_client_address_pool': {'key': 'properties.vpnClientAddressPool', 'type': 'AddressSpace'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SConnectionConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.vpn_client_address_pool = kwargs.get('vpn_client_address_pool', None)
        self.provisioning_state = None


class P2SVpnConnectionHealth(msrest.serialization.Model):
    """P2S Vpn connection detailed health written to sas url.

    :param sas_url: Returned sas url of the blob to which the p2s vpn connection detailed health
     will be written.
    :type sas_url: str
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SVpnConnectionHealth, self).__init__(**kwargs)
        self.sas_url = kwargs.get('sas_url', None)


class P2SVpnConnectionHealthRequest(msrest.serialization.Model):
    """List of P2S Vpn connection health request.

    :param vpn_user_names_filter: The list of p2s vpn user names whose p2s vpn connection detailed
     health to retrieve for.
    :type vpn_user_names_filter: list[str]
    :param output_blob_sas_url: The sas-url to download the P2S Vpn connection health detail.
    :type output_blob_sas_url: str
    """

    _attribute_map = {
        'vpn_user_names_filter': {'key': 'vpnUserNamesFilter', 'type': '[str]'},
        'output_blob_sas_url': {'key': 'outputBlobSasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SVpnConnectionHealthRequest, self).__init__(**kwargs)
        self.vpn_user_names_filter = kwargs.get('vpn_user_names_filter', None)
        self.output_blob_sas_url = kwargs.get('output_blob_sas_url', None)


class P2SVpnConnectionRequest(msrest.serialization.Model):
    """List of p2s vpn connections to be disconnected.

    :param vpn_connection_ids: List of p2s vpn connection Ids.
    :type vpn_connection_ids: list[str]
    """

    _attribute_map = {
        'vpn_connection_ids': {'key': 'vpnConnectionIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SVpnConnectionRequest, self).__init__(**kwargs)
        self.vpn_connection_ids = kwargs.get('vpn_connection_ids', None)


class P2SVpnGateway(Resource):
    """P2SVpnGateway Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_hub: The VirtualHub to which the gateway belongs.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param p2_s_connection_configurations: List of all p2s connection configurations of the
     gateway.
    :type p2_s_connection_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.P2SConnectionConfiguration]
    :ivar provisioning_state: The provisioning state of the P2S VPN gateway resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
    :type vpn_gateway_scale_unit: int
    :param vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is
     attached to.
    :type vpn_server_configuration: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar vpn_client_connection_health: All P2S VPN clients' connection health status.
    :vartype vpn_client_connection_health:
     ~azure.mgmt.network.v2020_03_01.models.VpnClientConnectionHealth
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'vpn_client_connection_health': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'p2_s_connection_configurations': {'key': 'properties.p2SConnectionConfigurations', 'type': '[P2SConnectionConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_gateway_scale_unit': {'key': 'properties.vpnGatewayScaleUnit', 'type': 'int'},
        'vpn_server_configuration': {'key': 'properties.vpnServerConfiguration', 'type': 'SubResource'},
        'vpn_client_connection_health': {'key': 'properties.vpnClientConnectionHealth', 'type': 'VpnClientConnectionHealth'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SVpnGateway, self).__init__(**kwargs)
        self.etag = None
        self.virtual_hub = kwargs.get('virtual_hub', None)
        self.p2_s_connection_configurations = kwargs.get('p2_s_connection_configurations', None)
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = kwargs.get('vpn_gateway_scale_unit', None)
        self.vpn_server_configuration = kwargs.get('vpn_server_configuration', None)
        self.vpn_client_connection_health = None


class P2SVpnProfileParameters(msrest.serialization.Model):
    """Vpn Client Parameters for package generation.

    :param authentication_method: VPN client authentication method. Possible values include:
     "EAPTLS", "EAPMSCHAPv2".
    :type authentication_method: str or ~azure.mgmt.network.v2020_03_01.models.AuthenticationMethod
    """

    _attribute_map = {
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(P2SVpnProfileParameters, self).__init__(**kwargs)
        self.authentication_method = kwargs.get('authentication_method', None)


class PacketCapture(msrest.serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. The storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2020_03_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters: list[~azure.mgmt.network.v2020_03_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCapture, self).__init__(**kwargs)
        self.target = kwargs['target']
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs['storage_location']
        self.filters = kwargs.get('filters', None)


class PacketCaptureFilter(msrest.serialization.Model):
    """Filter that is applied to packet capture request. Multiple filters can be applied.

    :param protocol: Protocol to be filtered on. Possible values include: "TCP", "UDP", "Any".
     Default value: "Any".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.PcProtocol
    :param local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :type local_ip_address: str
    :param remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :type remote_ip_address: str
    :param local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :type local_port: str
    :param remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :type remote_port: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureFilter, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', "Any")
        self.local_ip_address = kwargs.get('local_ip_address', None)
        self.remote_ip_address = kwargs.get('remote_ip_address', None)
        self.local_port = kwargs.get('local_port', None)
        self.remote_port = kwargs.get('remote_port', None)


class PacketCaptureListResult(msrest.serialization.Model):
    """List of packet capture sessions.

    :param value: Information about packet capture sessions.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PacketCaptureResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PacketCaptureResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PacketCaptureParameters(msrest.serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. The storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2020_03_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters: list[~azure.mgmt.network.v2020_03_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureParameters, self).__init__(**kwargs)
        self.target = kwargs['target']
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs['storage_location']
        self.filters = kwargs.get('filters', None)


class PacketCaptureQueryStatusResult(msrest.serialization.Model):
    """Status of packet capture session.

    :param name: The name of the packet capture resource.
    :type name: str
    :param id: The ID of the packet capture resource.
    :type id: str
    :param capture_start_time: The start time of the packet capture session.
    :type capture_start_time: ~datetime.datetime
    :param packet_capture_status: The status of the packet capture session. Possible values
     include: "NotStarted", "Running", "Stopped", "Error", "Unknown".
    :type packet_capture_status: str or ~azure.mgmt.network.v2020_03_01.models.PcStatus
    :param stop_reason: The reason the current packet capture session was stopped.
    :type stop_reason: str
    :param packet_capture_error: List of errors of packet capture session.
    :type packet_capture_error: list[str or ~azure.mgmt.network.v2020_03_01.models.PcError]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'capture_start_time': {'key': 'captureStartTime', 'type': 'iso-8601'},
        'packet_capture_status': {'key': 'packetCaptureStatus', 'type': 'str'},
        'stop_reason': {'key': 'stopReason', 'type': 'str'},
        'packet_capture_error': {'key': 'packetCaptureError', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureQueryStatusResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.capture_start_time = kwargs.get('capture_start_time', None)
        self.packet_capture_status = kwargs.get('packet_capture_status', None)
        self.stop_reason = kwargs.get('stop_reason', None)
        self.packet_capture_error = kwargs.get('packet_capture_error', None)


class PacketCaptureResult(msrest.serialization.Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param target: The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: The storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2020_03_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters: list[~azure.mgmt.network.v2020_03_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = None
        self.target = kwargs.get('target', None)
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs.get('storage_location', None)
        self.filters = kwargs.get('filters', None)
        self.provisioning_state = None


class PacketCaptureResultProperties(PacketCaptureParameters):
    """The properties of a packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
     are truncated.
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :type time_limit_in_seconds: int
    :param storage_location: Required. The storage location for a packet capture session.
    :type storage_location: ~azure.mgmt.network.v2020_03_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters: list[~azure.mgmt.network.v2020_03_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureResultProperties, self).__init__(**kwargs)
        self.provisioning_state = None


class PacketCaptureStorageLocation(msrest.serialization.Model):
    """The storage location for a packet capture session.

    :param storage_id: The ID of the storage account to save the packet capture session. Required
     if no local file path is provided.
    :type storage_id: str
    :param storage_path: The URI of the storage path to save the packet capture. Must be a
     well-formed URI describing the location to save the packet capture.
    :type storage_path: str
    :param file_path: A valid local path on the targeting VM. Must include the name of the capture
     file (*.cap). For linux virtual machine it must start with /var/captures. Required if no
     storage ID is provided, otherwise optional.
    :type file_path: str
    """

    _attribute_map = {
        'storage_id': {'key': 'storageId', 'type': 'str'},
        'storage_path': {'key': 'storagePath', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PacketCaptureStorageLocation, self).__init__(**kwargs)
        self.storage_id = kwargs.get('storage_id', None)
        self.storage_path = kwargs.get('storage_path', None)
        self.file_path = kwargs.get('file_path', None)


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param rules: Collection of RouteFilterRules contained within a route filter.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'peerings': {'readonly': True},
        'ipv6_peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'ipv6_peerings': {'key': 'properties.ipv6Peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchRouteFilter, self).__init__(**kwargs)
        self.name = None
        self.etag = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.rules = kwargs.get('rules', None)
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param access: The access type of the rule. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2020_03_01.models.Access
    :param route_filter_rule_type: The rule type of the rule. Possible values include: "Community".
    :type route_filter_rule_type: str or ~azure.mgmt.network.v2020_03_01.models.RouteFilterRuleType
    :param communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchRouteFilterRule, self).__init__(**kwargs)
        self.name = None
        self.etag = None
        self.access = kwargs.get('access', None)
        self.route_filter_rule_type = kwargs.get('route_filter_rule_type', None)
        self.communities = kwargs.get('communities', None)
        self.provisioning_state = None


class PeerExpressRouteCircuitConnection(SubResource):
    """Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit.
    :type express_route_circuit_peering: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :type peer_express_route_circuit_peering: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :type address_prefix: str
    :ivar circuit_connection_status: Express Route Circuit connection state. Possible values
     include: "Connected", "Connecting", "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.CircuitConnectionStatus
    :param connection_name: The name of the express route circuit connection resource.
    :type connection_name: str
    :param auth_resource_guid: The resource guid of the authorization used for the express route
     circuit connection.
    :type auth_resource_guid: str
    :ivar provisioning_state: The provisioning state of the peer express route circuit connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'circuit_connection_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'SubResource'},
        'peer_express_route_circuit_peering': {'key': 'properties.peerExpressRouteCircuitPeering', 'type': 'SubResource'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'connection_name': {'key': 'properties.connectionName', 'type': 'str'},
        'auth_resource_guid': {'key': 'properties.authResourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeerExpressRouteCircuitConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.express_route_circuit_peering = kwargs.get('express_route_circuit_peering', None)
        self.peer_express_route_circuit_peering = kwargs.get('peer_express_route_circuit_peering', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.circuit_connection_status = None
        self.connection_name = kwargs.get('connection_name', None)
        self.auth_resource_guid = kwargs.get('auth_resource_guid', None)
        self.provisioning_state = None


class PeerExpressRouteCircuitConnectionListResult(msrest.serialization.Model):
    """Response for ListPeeredConnections API service call retrieves all global reach peer circuit connections that belongs to a Private Peering for an ExpressRouteCircuit.

    :param value: The global reach peer circuit connection associated with Private Peering in an
     ExpressRoute Circuit.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PeerExpressRouteCircuitConnection]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeerExpressRouteCircuitConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeerExpressRouteCircuitConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PolicySettings(msrest.serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :param state: The state of the policy. Possible values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallEnabledState
    :param mode: The mode of the policy. Possible values include: "Prevention", "Detection".
    :type mode: str or ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallMode
    :param request_body_check: Whether to allow WAF to check request Body.
    :type request_body_check: bool
    :param max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :type max_request_body_size_in_kb: int
    :param file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :type file_upload_limit_in_mb: int
    """

    _validation = {
        'max_request_body_size_in_kb': {'maximum': 128, 'minimum': 8},
        'file_upload_limit_in_mb': {'minimum': 0},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'bool'},
        'max_request_body_size_in_kb': {'key': 'maxRequestBodySizeInKb', 'type': 'int'},
        'file_upload_limit_in_mb': {'key': 'fileUploadLimitInMb', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicySettings, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.mode = kwargs.get('mode', None)
        self.request_body_check = kwargs.get('request_body_check', None)
        self.max_request_body_size_in_kb = kwargs.get('max_request_body_size_in_kb', None)
        self.file_upload_limit_in_mb = kwargs.get('file_upload_limit_in_mb', None)


class PrepareNetworkPoliciesRequest(msrest.serialization.Model):
    """Details of PrepareNetworkPolicies for Subnet.

    :param service_name: The name of the service for which subnet is being prepared for.
    :type service_name: str
    :param network_intent_policy_configurations: A list of NetworkIntentPolicyConfiguration.
    :type network_intent_policy_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkIntentPolicyConfiguration]
    """

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'network_intent_policy_configurations': {'key': 'networkIntentPolicyConfigurations', 'type': '[NetworkIntentPolicyConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrepareNetworkPoliciesRequest, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.network_intent_policy_configurations = kwargs.get('network_intent_policy_configurations', None)


class PrivateDnsZoneConfig(msrest.serialization.Model):
    """PrivateDnsZoneConfig resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param private_dns_zone_id: The resource id of the private dns zone.
    :type private_dns_zone_id: str
    :ivar record_sets: A collection of information regarding a recordSet, holding information to
     identify private resources.
    :vartype record_sets: list[~azure.mgmt.network.v2020_03_01.models.RecordSet]
    """

    _validation = {
        'record_sets': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_dns_zone_id': {'key': 'properties.privateDnsZoneId', 'type': 'str'},
        'record_sets': {'key': 'properties.recordSets', 'type': '[RecordSet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateDnsZoneConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.private_dns_zone_id = kwargs.get('private_dns_zone_id', None)
        self.record_sets = None


class PrivateDnsZoneGroup(SubResource):
    """Private dns zone group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the private dns zone group resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_dns_zone_configs: A collection of private dns zone configurations of the private
     dns zone group.
    :type private_dns_zone_configs:
     list[~azure.mgmt.network.v2020_03_01.models.PrivateDnsZoneConfig]
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_dns_zone_configs': {'key': 'properties.privateDnsZoneConfigs', 'type': '[PrivateDnsZoneConfig]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateDnsZoneGroup, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.provisioning_state = None
        self.private_dns_zone_configs = kwargs.get('private_dns_zone_configs', None)


class PrivateDnsZoneGroupListResult(msrest.serialization.Model):
    """Response for the ListPrivateDnsZoneGroups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of private dns zone group resources in a private endpoint.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PrivateDnsZoneGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateDnsZoneGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateDnsZoneGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PrivateEndpoint(Resource):
    """Private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param subnet: The ID of the subnet from which the private IP will be allocated.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :ivar network_interfaces: An array of references to the network interfaces created for this
     private endpoint.
    :vartype network_interfaces: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private endpoint resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_link_service_connections: A grouping of information about the connection to the
     remote resource.
    :type private_link_service_connections:
     list[~azure.mgmt.network.v2020_03_01.models.PrivateLinkServiceConnection]
    :param manual_private_link_service_connections: A grouping of information about the connection
     to the remote resource. Used when the network admin does not have access to approve connections
     to the remote resource.
    :type manual_private_link_service_connections:
     list[~azure.mgmt.network.v2020_03_01.models.PrivateLinkServiceConnection]
    :param custom_dns_configs: An array of custom dns configurations.
    :type custom_dns_configs:
     list[~azure.mgmt.network.v2020_03_01.models.CustomDnsConfigPropertiesFormat]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_service_connections': {'key': 'properties.privateLinkServiceConnections', 'type': '[PrivateLinkServiceConnection]'},
        'manual_private_link_service_connections': {'key': 'properties.manualPrivateLinkServiceConnections', 'type': '[PrivateLinkServiceConnection]'},
        'custom_dns_configs': {'key': 'properties.customDnsConfigs', 'type': '[CustomDnsConfigPropertiesFormat]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.etag = None
        self.subnet = kwargs.get('subnet', None)
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_link_service_connections = kwargs.get('private_link_service_connections', None)
        self.manual_private_link_service_connections = kwargs.get('manual_private_link_service_connections', None)
        self.custom_dns_configs = kwargs.get('custom_dns_configs', None)


class PrivateEndpointConnection(SubResource):
    """PrivateEndpointConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.network.v2020_03_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.network.v2020_03_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar link_identifier: The consumer link id.
    :vartype link_identifier: str
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'link_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'link_identifier': {'key': 'properties.linkIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.private_endpoint = None
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None
        self.link_identifier = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """Response for the ListPrivateEndpointConnection API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of PrivateEndpointConnection resources for a specific private link
     service.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PrivateEndpointConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PrivateEndpointListResult(msrest.serialization.Model):
    """Response for the ListPrivateEndpoints API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of private endpoint resources in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PrivateEndpoint]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PrivateLinkService(Resource):
    """Private link service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param load_balancer_frontend_ip_configurations: An array of references to the load balancer IP
     configurations.
    :type load_balancer_frontend_ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.FrontendIPConfiguration]
    :param ip_configurations: An array of private link service IP configurations.
    :type ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.PrivateLinkServiceIpConfiguration]
    :ivar network_interfaces: An array of references to the network interfaces created for this
     private link service.
    :vartype network_interfaces: list[~azure.mgmt.network.v2020_03_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private link service resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar private_endpoint_connections: An array of list about connections to the private endpoint.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.network.v2020_03_01.models.PrivateEndpointConnection]
    :param visibility: The visibility list of the private link service.
    :type visibility: ~azure.mgmt.network.v2020_03_01.models.PrivateLinkServicePropertiesVisibility
    :param auto_approval: The auto-approval list of the private link service.
    :type auto_approval:
     ~azure.mgmt.network.v2020_03_01.models.PrivateLinkServicePropertiesAutoApproval
    :param fqdns: The list of Fqdn.
    :type fqdns: list[str]
    :ivar alias: The alias of the private link service.
    :vartype alias: str
    :param enable_proxy_protocol: Whether the private link service is enabled for proxy protocol or
     not.
    :type enable_proxy_protocol: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'alias': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancer_frontend_ip_configurations': {'key': 'properties.loadBalancerFrontendIpConfigurations', 'type': '[FrontendIPConfiguration]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[PrivateLinkServiceIpConfiguration]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'visibility': {'key': 'properties.visibility', 'type': 'PrivateLinkServicePropertiesVisibility'},
        'auto_approval': {'key': 'properties.autoApproval', 'type': 'PrivateLinkServicePropertiesAutoApproval'},
        'fqdns': {'key': 'properties.fqdns', 'type': '[str]'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'enable_proxy_protocol': {'key': 'properties.enableProxyProtocol', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkService, self).__init__(**kwargs)
        self.etag = None
        self.load_balancer_frontend_ip_configurations = kwargs.get('load_balancer_frontend_ip_configurations', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_endpoint_connections = None
        self.visibility = kwargs.get('visibility', None)
        self.auto_approval = kwargs.get('auto_approval', None)
        self.fqdns = kwargs.get('fqdns', None)
        self.alias = None
        self.enable_proxy_protocol = kwargs.get('enable_proxy_protocol', None)


class PrivateLinkServiceConnection(SubResource):
    """PrivateLinkServiceConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the private link service connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_link_service_id: The resource id of private link service.
    :type private_link_service_id: str
    :param group_ids: The ID(s) of the group(s) obtained from the remote resource that this private
     endpoint should connect to.
    :type group_ids: list[str]
    :param request_message: A message passed to the owner of the remote resource with this
     connection request. Restricted to 140 chars.
    :type request_message: str
    :param private_link_service_connection_state: A collection of read-only information about the
     state of the connection to the remote resource.
    :type private_link_service_connection_state:
     ~azure.mgmt.network.v2020_03_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_service_id': {'key': 'properties.privateLinkServiceId', 'type': 'str'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.etag = None
        self.provisioning_state = None
        self.private_link_service_id = kwargs.get('private_link_service_id', None)
        self.group_ids = kwargs.get('group_ids', None)
        self.request_message = kwargs.get('request_message', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service.
    :type status: str
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class PrivateLinkServiceIpConfiguration(SubResource):
    """The private link service ip configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of private link service ip configuration.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param subnet: The reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.Subnet
    :param primary: Whether the ip configuration is primary or not.
    :type primary: bool
    :ivar provisioning_state: The provisioning state of the private link service IP configuration
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
     Default is IPv4. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceIpConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.provisioning_state = None
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)


class PrivateLinkServiceListResult(msrest.serialization.Model):
    """Response for the ListPrivateLinkService API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of PrivateLinkService resources in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PrivateLinkService]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ResourceSet(msrest.serialization.Model):
    """The base resource set for visibility and auto-approval.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSet, self).__init__(**kwargs)
        self.subscriptions = kwargs.get('subscriptions', None)


class PrivateLinkServicePropertiesAutoApproval(ResourceSet):
    """The auto-approval list of the private link service.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServicePropertiesAutoApproval, self).__init__(**kwargs)


class PrivateLinkServicePropertiesVisibility(ResourceSet):
    """The visibility list of the private link service.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServicePropertiesVisibility, self).__init__(**kwargs)


class PrivateLinkServiceVisibility(msrest.serialization.Model):
    """Response for the CheckPrivateLinkServiceVisibility API service call.

    :param visible: Private Link Service Visibility (True/False).
    :type visible: bool
    """

    _attribute_map = {
        'visible': {'key': 'visible', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceVisibility, self).__init__(**kwargs)
        self.visible = kwargs.get('visible', None)


class Probe(SubResource):
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within the set of probes used by the load
     balancer. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is
     required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response
     from the specifies URI is required for the probe to be successful. Possible values include:
     "Http", "Tcp", "Https".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.ProbeProtocol
    :param port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :type request_path: str
    :ivar provisioning_state: The provisioning state of the probe resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Probe, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.load_balancing_rules = None
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.number_of_probes = kwargs.get('number_of_probes', None)
        self.request_path = kwargs.get('request_path', None)
        self.provisioning_state = None


class ProtocolConfiguration(msrest.serialization.Model):
    """Configuration of the protocol.

    :param http_configuration: HTTP configuration of the connectivity check.
    :type http_configuration: ~azure.mgmt.network.v2020_03_01.models.HTTPConfiguration
    """

    _attribute_map = {
        'http_configuration': {'key': 'HTTPConfiguration', 'type': 'HTTPConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtocolConfiguration, self).__init__(**kwargs)
        self.http_configuration = kwargs.get('http_configuration', None)


class ProtocolCustomSettingsFormat(msrest.serialization.Model):
    """DDoS custom policy properties.

    :param protocol: The protocol for which the DDoS protection policy is being customized.
     Possible values include: "Tcp", "Udp", "Syn".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.DdosCustomPolicyProtocol
    :param trigger_rate_override: The customized DDoS protection trigger rate.
    :type trigger_rate_override: str
    :param source_rate_override: The customized DDoS protection source rate.
    :type source_rate_override: str
    :param trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity
     degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger
     rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
     sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t.
     normal traffic. Possible values include: "Relaxed", "Low", "Default", "High".
    :type trigger_sensitivity_override: str or
     ~azure.mgmt.network.v2020_03_01.models.DdosCustomPolicyTriggerSensitivityOverride
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'trigger_rate_override': {'key': 'triggerRateOverride', 'type': 'str'},
        'source_rate_override': {'key': 'sourceRateOverride', 'type': 'str'},
        'trigger_sensitivity_override': {'key': 'triggerSensitivityOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtocolCustomSettingsFormat, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.trigger_rate_override = kwargs.get('trigger_rate_override', None)
        self.source_rate_override = kwargs.get('source_rate_override', None)
        self.trigger_sensitivity_override = kwargs.get('trigger_sensitivity_override', None)


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The public IP address SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.PublicIPAddressSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :type zones: list[str]
    :param public_ip_allocation_method: The public IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param public_ip_address_version: The public IP address version. Possible values include:
     "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP address.
    :vartype ip_configuration: ~azure.mgmt.network.v2020_03_01.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public IP address.
    :type dns_settings: ~azure.mgmt.network.v2020_03_01.models.PublicIPAddressDnsSettings
    :param ddos_settings: The DDoS protection custom policy associated with the public IP address.
    :type ddos_settings: ~azure.mgmt.network.v2020_03_01.models.DdosSettings
    :param ip_tags: The list of tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.network.v2020_03_01.models.IpTag]
    :param ip_address: The IP address associated with the public IP address resource.
    :type ip_address: str
    :param public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
    :type public_ip_prefix: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP address resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP address resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'ip_configuration': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PublicIPAddressSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ddos_settings': {'key': 'properties.ddosSettings', 'type': 'DdosSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IpTag]'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddress, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.etag = None
        self.zones = kwargs.get('zones', None)
        self.public_ip_allocation_method = kwargs.get('public_ip_allocation_method', None)
        self.public_ip_address_version = kwargs.get('public_ip_address_version', None)
        self.ip_configuration = None
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ddos_settings = kwargs.get('ddos_settings', None)
        self.ip_tags = kwargs.get('ip_tags', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.public_ip_prefix = kwargs.get('public_ip_prefix', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.resource_guid = None
        self.provisioning_state = None


class PublicIPAddressDnsSettings(msrest.serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: The domain name label. The concatenation of the domain name label and
     the regionalized DNS zone make up the fully qualified domain name associated with the public IP
     address. If a domain name label is specified, an A DNS record is created for the public IP in
     the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public IP.
     This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that
     resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is
     created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = kwargs.get('domain_name_label', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.reverse_fqdn = kwargs.get('reverse_fqdn', None)


class PublicIPAddressListResult(msrest.serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :param value: A list of public IP addresses that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PublicIPAddress]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicIPAddress]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddressListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PublicIPAddressSku(msrest.serialization.Model):
    """SKU of a public IP address.

    :param name: Name of a public IP address SKU. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.PublicIPAddressSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddressSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class PublicIPPrefix(Resource):
    """Public IP prefix resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The public IP prefix SKU.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.PublicIPPrefixSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :type zones: list[str]
    :param public_ip_address_version: The public IP address version. Possible values include:
     "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.network.v2020_03_01.models.IPVersion
    :param ip_tags: The list of tags associated with the public IP prefix.
    :type ip_tags: list[~azure.mgmt.network.v2020_03_01.models.IpTag]
    :param prefix_length: The Length of the Public IP Prefix.
    :type prefix_length: int
    :ivar ip_prefix: The allocated Prefix.
    :vartype ip_prefix: str
    :ivar public_ip_addresses: The list of all referenced PublicIPAddresses.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.v2020_03_01.models.ReferencedPublicIpAddress]
    :ivar load_balancer_frontend_ip_configuration: The reference to load balancer frontend IP
     configuration associated with the public IP prefix.
    :vartype load_balancer_frontend_ip_configuration:
     ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar resource_guid: The resource GUID property of the public IP prefix resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP prefix resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'ip_prefix': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'load_balancer_frontend_ip_configuration': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PublicIPPrefixSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IpTag]'},
        'prefix_length': {'key': 'properties.prefixLength', 'type': 'int'},
        'ip_prefix': {'key': 'properties.ipPrefix', 'type': 'str'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[ReferencedPublicIpAddress]'},
        'load_balancer_frontend_ip_configuration': {'key': 'properties.loadBalancerFrontendIpConfiguration', 'type': 'SubResource'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPPrefix, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.etag = None
        self.zones = kwargs.get('zones', None)
        self.public_ip_address_version = kwargs.get('public_ip_address_version', None)
        self.ip_tags = kwargs.get('ip_tags', None)
        self.prefix_length = kwargs.get('prefix_length', None)
        self.ip_prefix = None
        self.public_ip_addresses = None
        self.load_balancer_frontend_ip_configuration = None
        self.resource_guid = None
        self.provisioning_state = None


class PublicIPPrefixListResult(msrest.serialization.Model):
    """Response for ListPublicIpPrefixes API service call.

    :param value: A list of public IP prefixes that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.PublicIPPrefix]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicIPPrefix]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPPrefixListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PublicIPPrefixSku(msrest.serialization.Model):
    """SKU of a public IP prefix.

    :param name: Name of a public IP prefix SKU. Possible values include: "Standard".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.PublicIPPrefixSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPPrefixSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class QueryTroubleshootingParameters(msrest.serialization.Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource ID to query the troubleshooting
     result.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryTroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']


class RadiusServer(msrest.serialization.Model):
    """Radius Server Settings.

    All required parameters must be populated in order to send to Azure.

    :param radius_server_address: Required. The address of this radius server.
    :type radius_server_address: str
    :param radius_server_score: The initial score assigned to this radius server.
    :type radius_server_score: long
    :param radius_server_secret: The secret used for this radius server.
    :type radius_server_secret: str
    """

    _validation = {
        'radius_server_address': {'required': True},
    }

    _attribute_map = {
        'radius_server_address': {'key': 'radiusServerAddress', 'type': 'str'},
        'radius_server_score': {'key': 'radiusServerScore', 'type': 'long'},
        'radius_server_secret': {'key': 'radiusServerSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RadiusServer, self).__init__(**kwargs)
        self.radius_server_address = kwargs['radius_server_address']
        self.radius_server_score = kwargs.get('radius_server_score', None)
        self.radius_server_secret = kwargs.get('radius_server_secret', None)


class RecordSet(msrest.serialization.Model):
    """A collective group of information about the record set information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param record_type: Resource record type.
    :type record_type: str
    :param record_set_name: Recordset name.
    :type record_set_name: str
    :param fqdn: Fqdn that resolves to private endpoint ip address.
    :type fqdn: str
    :ivar provisioning_state: The provisioning state of the recordset. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param ttl: Recordset time to live.
    :type ttl: int
    :param ip_addresses: The private ip address of the private endpoint.
    :type ip_addresses: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'record_type': {'key': 'recordType', 'type': 'str'},
        'record_set_name': {'key': 'recordSetName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'ttl': {'key': 'ttl', 'type': 'int'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecordSet, self).__init__(**kwargs)
        self.record_type = kwargs.get('record_type', None)
        self.record_set_name = kwargs.get('record_set_name', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.provisioning_state = None
        self.ttl = kwargs.get('ttl', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)


class ReferencedPublicIpAddress(msrest.serialization.Model):
    """Reference to a public IP address.

    :param id: The PublicIPAddress Reference.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReferencedPublicIpAddress, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource.
    :type link: str
    :ivar provisioning_state: The provisioning state of the resource navigation link resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNavigationLink, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.linked_resource_type = kwargs.get('linked_resource_type', None)
        self.link = kwargs.get('link', None)
        self.provisioning_state = None


class ResourceNavigationLinksListResult(msrest.serialization.Model):
    """Response for ResourceNavigationLinks_List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The resource navigation links in a subnet.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ResourceNavigationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceNavigationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNavigationLinksListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RetentionPolicyParameters(msrest.serialization.Model):
    """Parameters that define the retention policy for flow log.

    :param days: Number of days to retain flow log records.
    :type days: int
    :param enabled: Flag to enable/disable retention.
    :type enabled: bool
    """

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicyParameters, self).__init__(**kwargs)
        self.days = kwargs.get('days', 0)
        self.enabled = kwargs.get('enabled', False)


class Route(SubResource):
    """Route resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values
     include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2020_03_01.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :type next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the route resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Route, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.provisioning_state = None


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param rules: Collection of RouteFilterRules contained within a route filter.
    :type rules: list[~azure.mgmt.network.v2020_03_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.v2020_03_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'peerings': {'readonly': True},
        'ipv6_peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'ipv6_peerings': {'key': 'properties.ipv6Peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteFilter, self).__init__(**kwargs)
        self.etag = None
        self.rules = kwargs.get('rules', None)
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None


class RouteFilterListResult(msrest.serialization.Model):
    """Response for the ListRouteFilters API service call.

    :param value: A list of route filters in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.RouteFilter]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteFilter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteFilterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param location: Resource location.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param access: The access type of the rule. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2020_03_01.models.Access
    :param route_filter_rule_type: The rule type of the rule. Possible values include: "Community".
    :type route_filter_rule_type: str or ~azure.mgmt.network.v2020_03_01.models.RouteFilterRuleType
    :param communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteFilterRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.etag = None
        self.access = kwargs.get('access', None)
        self.route_filter_rule_type = kwargs.get('route_filter_rule_type', None)
        self.communities = kwargs.get('communities', None)
        self.provisioning_state = None


class RouteFilterRuleListResult(msrest.serialization.Model):
    """Response for the ListRouteFilterRules API service call.

    :param value: A list of RouteFilterRules in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.RouteFilterRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteFilterRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteFilterRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RouteListResult(msrest.serialization.Model):
    """Response for the ListRoute API service call.

    :param value: A list of routes in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.Route]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2020_03_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2020_03_01.models.Subnet]
    :param disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that
     route table. True means disable.
    :type disable_bgp_route_propagation: bool
    :ivar provisioning_state: The provisioning state of the route table resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'subnets': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'disable_bgp_route_propagation': {'key': 'properties.disableBgpRoutePropagation', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteTable, self).__init__(**kwargs)
        self.etag = None
        self.routes = kwargs.get('routes', None)
        self.subnets = None
        self.disable_bgp_route_propagation = kwargs.get('disable_bgp_route_propagation', None)
        self.provisioning_state = None


class RouteTableListResult(msrest.serialization.Model):
    """Response for the ListRouteTable API service call.

    :param value: A list of route tables in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.RouteTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SecurityGroupNetworkInterface(msrest.serialization.Model):
    """Network interface and all its associated security rules.

    :param id: ID of the network interface.
    :type id: str
    :param security_rule_associations: All security rules associated with the network interface.
    :type security_rule_associations:
     ~azure.mgmt.network.v2020_03_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rule_associations': {'key': 'securityRuleAssociations', 'type': 'SecurityRuleAssociations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityGroupNetworkInterface, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.security_rule_associations = kwargs.get('security_rule_associations', None)


class SecurityGroupViewParameters(msrest.serialization.Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ID of the target VM.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityGroupViewParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']


class SecurityGroupViewResult(msrest.serialization.Model):
    """The information about security rules applied to the specified VM.

    :param network_interfaces: List of network interfaces on the specified VM.
    :type network_interfaces:
     list[~azure.mgmt.network.v2020_03_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[SecurityGroupNetworkInterface]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityGroupViewResult, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class SecurityPartnerProvider(Resource):
    """Security Partner Provider resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the Security Partner Provider resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param security_provider_name: The security provider name. Possible values include: "ZScaler",
     "IBoss", "Checkpoint".
    :type security_provider_name: str or
     ~azure.mgmt.network.v2020_03_01.models.SecurityProviderName
    :ivar connection_status: The connection status with the Security Partner Provider. Possible
     values include: "Unknown", "PartiallyConnected", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.SecurityPartnerProviderConnectionStatus
    :param virtual_hub: The virtualHub to which the Security Partner Provider belongs.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.SubResource
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'connection_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'security_provider_name': {'key': 'properties.securityProviderName', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityPartnerProvider, self).__init__(**kwargs)
        self.etag = None
        self.provisioning_state = None
        self.security_provider_name = kwargs.get('security_provider_name', None)
        self.connection_status = None
        self.virtual_hub = kwargs.get('virtual_hub', None)


class SecurityPartnerProviderListResult(msrest.serialization.Model):
    """Response for ListSecurityPartnerProviders API service call.

    :param value: List of Security Partner Providers in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.SecurityPartnerProvider]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityPartnerProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityPartnerProviderListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SecurityRule(SubResource):
    """Network security rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values include: "Tcp", "Udp",
     "Icmp", "Esp", "*", "Ah".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param source_address_prefixes: The CIDR or source IP ranges.
    :type source_address_prefixes: list[str]
    :param source_application_security_groups: The application security group specified as source.
    :type source_application_security_groups:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationSecurityGroup]
    :param destination_address_prefix: The destination address prefix. CIDR or destination IP
     range. Asterisk '*' can also be used to match all source IPs. Default tags such as
     'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
    :type destination_address_prefix: str
    :param destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :type destination_address_prefixes: list[str]
    :param destination_application_security_groups: The application security group specified as
     destination.
    :type destination_application_security_groups:
     list[~azure.mgmt.network.v2020_03_01.models.ApplicationSecurityGroup]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: The network traffic is allowed or denied. Possible values include: "Allow",
     "Deny".
    :type access: str or ~azure.mgmt.network.v2020_03_01.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2020_03_01.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the security rule resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'properties.sourceAddressPrefixes', 'type': '[str]'},
        'source_application_security_groups': {'key': 'properties.sourceApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'destination_address_prefixes': {'key': 'properties.destinationAddressPrefixes', 'type': '[str]'},
        'destination_application_security_groups': {'key': 'properties.destinationApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.description = kwargs.get('description', None)
        self.protocol = kwargs.get('protocol', None)
        self.source_port_range = kwargs.get('source_port_range', None)
        self.destination_port_range = kwargs.get('destination_port_range', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.source_address_prefixes = kwargs.get('source_address_prefixes', None)
        self.source_application_security_groups = kwargs.get('source_application_security_groups', None)
        self.destination_address_prefix = kwargs.get('destination_address_prefix', None)
        self.destination_address_prefixes = kwargs.get('destination_address_prefixes', None)
        self.destination_application_security_groups = kwargs.get('destination_application_security_groups', None)
        self.source_port_ranges = kwargs.get('source_port_ranges', None)
        self.destination_port_ranges = kwargs.get('destination_port_ranges', None)
        self.access = kwargs.get('access', None)
        self.priority = kwargs.get('priority', None)
        self.direction = kwargs.get('direction', None)
        self.provisioning_state = None


class SecurityRuleAssociations(msrest.serialization.Model):
    """All security rules associated with the network interface.

    :param network_interface_association: Network interface and it's custom security rules.
    :type network_interface_association:
     ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceAssociation
    :param subnet_association: Subnet and it's custom security rules.
    :type subnet_association: ~azure.mgmt.network.v2020_03_01.models.SubnetAssociation
    :param default_security_rules: Collection of default security rules of the network security
     group.
    :type default_security_rules: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    :param effective_security_rules: Collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2020_03_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        'network_interface_association': {'key': 'networkInterfaceAssociation', 'type': 'NetworkInterfaceAssociation'},
        'subnet_association': {'key': 'subnetAssociation', 'type': 'SubnetAssociation'},
        'default_security_rules': {'key': 'defaultSecurityRules', 'type': '[SecurityRule]'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityRuleAssociations, self).__init__(**kwargs)
        self.network_interface_association = kwargs.get('network_interface_association', None)
        self.subnet_association = kwargs.get('subnet_association', None)
        self.default_security_rules = kwargs.get('default_security_rules', None)
        self.effective_security_rules = kwargs.get('effective_security_rules', None)


class SecurityRuleListResult(msrest.serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :param value: The security rules in a network security group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServiceAssociationLink(SubResource):
    """ServiceAssociationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource.
    :type link: str
    :ivar provisioning_state: The provisioning state of the service association link resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param allow_delete: If true, the resource can be deleted.
    :type allow_delete: bool
    :param locations: A list of locations.
    :type locations: list[str]
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'allow_delete': {'key': 'properties.allowDelete', 'type': 'bool'},
        'locations': {'key': 'properties.locations', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceAssociationLink, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.linked_resource_type = kwargs.get('linked_resource_type', None)
        self.link = kwargs.get('link', None)
        self.provisioning_state = None
        self.allow_delete = kwargs.get('allow_delete', None)
        self.locations = kwargs.get('locations', None)


class ServiceAssociationLinksListResult(msrest.serialization.Model):
    """Response for ServiceAssociationLinks_List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The service association links in a subnet.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ServiceAssociationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceAssociationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceAssociationLinksListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ServiceEndpointPolicy(Resource):
    """Service End point policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param service_endpoint_policy_definitions: A collection of service endpoint policy definitions
     of the service endpoint policy.
    :type service_endpoint_policy_definitions:
     list[~azure.mgmt.network.v2020_03_01.models.ServiceEndpointPolicyDefinition]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2020_03_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the service endpoint policy resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the service endpoint policy resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'subnets': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'service_endpoint_policy_definitions': {'key': 'properties.serviceEndpointPolicyDefinitions', 'type': '[ServiceEndpointPolicyDefinition]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceEndpointPolicy, self).__init__(**kwargs)
        self.etag = None
        self.service_endpoint_policy_definitions = kwargs.get('service_endpoint_policy_definitions', None)
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None


class ServiceEndpointPolicyDefinition(SubResource):
    """Service Endpoint policy definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param service: Service endpoint name.
    :type service: str
    :param service_resources: A list of service resources.
    :type service_resources: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint policy definition
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'service': {'key': 'properties.service', 'type': 'str'},
        'service_resources': {'key': 'properties.serviceResources', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceEndpointPolicyDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.description = kwargs.get('description', None)
        self.service = kwargs.get('service', None)
        self.service_resources = kwargs.get('service_resources', None)
        self.provisioning_state = None


class ServiceEndpointPolicyDefinitionListResult(msrest.serialization.Model):
    """Response for ListServiceEndpointPolicyDefinition API service call. Retrieves all service endpoint policy definition that belongs to a service endpoint policy.

    :param value: The service endpoint policy definition in a service endpoint policy.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ServiceEndpointPolicyDefinition]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceEndpointPolicyDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceEndpointPolicyDefinitionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServiceEndpointPolicyListResult(msrest.serialization.Model):
    """Response for ListServiceEndpointPolicies API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of ServiceEndpointPolicy resources.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.ServiceEndpointPolicy]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceEndpointPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceEndpointPolicyListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ServiceEndpointPropertiesFormat(msrest.serialization.Model):
    """The service endpoint properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param service: The type of the endpoint service.
    :type service: str
    :param locations: A list of locations.
    :type locations: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceEndpointPropertiesFormat, self).__init__(**kwargs)
        self.service = kwargs.get('service', None)
        self.locations = kwargs.get('locations', None)
        self.provisioning_state = None


class ServiceTagInformation(msrest.serialization.Model):
    """The service tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Properties of the service tag information.
    :vartype properties:
     ~azure.mgmt.network.v2020_03_01.models.ServiceTagInformationPropertiesFormat
    :ivar name: The name of service tag.
    :vartype name: str
    :ivar id: The ID of service tag.
    :vartype id: str
    """

    _validation = {
        'properties': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ServiceTagInformationPropertiesFormat'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTagInformation, self).__init__(**kwargs)
        self.properties = None
        self.name = None
        self.id = None


class ServiceTagInformationPropertiesFormat(msrest.serialization.Model):
    """Properties of the service tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar change_number: The iteration number of service tag.
    :vartype change_number: str
    :ivar region: The region of service tag.
    :vartype region: str
    :ivar system_service: The name of system service.
    :vartype system_service: str
    :ivar address_prefixes: The list of IP address prefixes.
    :vartype address_prefixes: list[str]
    """

    _validation = {
        'change_number': {'readonly': True},
        'region': {'readonly': True},
        'system_service': {'readonly': True},
        'address_prefixes': {'readonly': True},
    }

    _attribute_map = {
        'change_number': {'key': 'changeNumber', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'system_service': {'key': 'systemService', 'type': 'str'},
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTagInformationPropertiesFormat, self).__init__(**kwargs)
        self.change_number = None
        self.region = None
        self.system_service = None
        self.address_prefixes = None


class ServiceTagsListResult(msrest.serialization.Model):
    """Response for the ListServiceTags API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the cloud.
    :vartype name: str
    :ivar id: The ID of the cloud.
    :vartype id: str
    :ivar type: The azure resource type.
    :vartype type: str
    :ivar change_number: The iteration number.
    :vartype change_number: str
    :ivar cloud: The name of the cloud.
    :vartype cloud: str
    :ivar values: The list of service tag information resources.
    :vartype values: list[~azure.mgmt.network.v2020_03_01.models.ServiceTagInformation]
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'change_number': {'readonly': True},
        'cloud': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'change_number': {'key': 'changeNumber', 'type': 'str'},
        'cloud': {'key': 'cloud', 'type': 'str'},
        'values': {'key': 'values', 'type': '[ServiceTagInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTagsListResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.change_number = None
        self.cloud = None
        self.values = None


class SessionIds(msrest.serialization.Model):
    """List of session IDs.

    :param session_ids: List of session IDs.
    :type session_ids: list[str]
    """

    _attribute_map = {
        'session_ids': {'key': 'sessionIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionIds, self).__init__(**kwargs)
        self.session_ids = kwargs.get('session_ids', None)


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param address_prefixes: List of address prefixes for the subnet.
    :type address_prefixes: list[str]
    :param network_security_group: The reference to the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2020_03_01.models.NetworkSecurityGroup
    :param route_table: The reference to the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2020_03_01.models.RouteTable
    :param nat_gateway: Nat gateway associated with this subnet.
    :type nat_gateway: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param service_endpoints: An array of service endpoints.
    :type service_endpoints:
     list[~azure.mgmt.network.v2020_03_01.models.ServiceEndpointPropertiesFormat]
    :param service_endpoint_policies: An array of service endpoint policies.
    :type service_endpoint_policies:
     list[~azure.mgmt.network.v2020_03_01.models.ServiceEndpointPolicy]
    :ivar private_endpoints: An array of references to private endpoints.
    :vartype private_endpoints: list[~azure.mgmt.network.v2020_03_01.models.PrivateEndpoint]
    :ivar ip_configurations: An array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.v2020_03_01.models.IPConfiguration]
    :ivar ip_configuration_profiles: Array of IP configuration profiles which reference this
     subnet.
    :vartype ip_configuration_profiles:
     list[~azure.mgmt.network.v2020_03_01.models.IPConfigurationProfile]
    :param ip_allocations: Array of IpAllocation which reference this subnet.
    :type ip_allocations: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar resource_navigation_links: An array of references to the external resources using subnet.
    :vartype resource_navigation_links:
     list[~azure.mgmt.network.v2020_03_01.models.ResourceNavigationLink]
    :ivar service_association_links: An array of references to services injecting into this subnet.
    :vartype service_association_links:
     list[~azure.mgmt.network.v2020_03_01.models.ServiceAssociationLink]
    :param delegations: An array of references to the delegations on the subnet.
    :type delegations: list[~azure.mgmt.network.v2020_03_01.models.Delegation]
    :ivar purpose: A read-only string identifying the intention of use for this subnet based on
     delegations and other user-defined properties.
    :vartype purpose: str
    :ivar provisioning_state: The provisioning state of the subnet resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param private_endpoint_network_policies: Enable or Disable apply network policies on private
     end point in the subnet.
    :type private_endpoint_network_policies: str
    :param private_link_service_network_policies: Enable or Disable apply network policies on
     private link service in the subnet.
    :type private_link_service_network_policies: str
    """

    _validation = {
        'etag': {'readonly': True},
        'private_endpoints': {'readonly': True},
        'ip_configurations': {'readonly': True},
        'ip_configuration_profiles': {'readonly': True},
        'resource_navigation_links': {'readonly': True},
        'service_association_links': {'readonly': True},
        'purpose': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'address_prefixes': {'key': 'properties.addressPrefixes', 'type': '[str]'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'nat_gateway': {'key': 'properties.natGateway', 'type': 'SubResource'},
        'service_endpoints': {'key': 'properties.serviceEndpoints', 'type': '[ServiceEndpointPropertiesFormat]'},
        'service_endpoint_policies': {'key': 'properties.serviceEndpointPolicies', 'type': '[ServiceEndpointPolicy]'},
        'private_endpoints': {'key': 'properties.privateEndpoints', 'type': '[PrivateEndpoint]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'ip_configuration_profiles': {'key': 'properties.ipConfigurationProfiles', 'type': '[IPConfigurationProfile]'},
        'ip_allocations': {'key': 'properties.ipAllocations', 'type': '[SubResource]'},
        'resource_navigation_links': {'key': 'properties.resourceNavigationLinks', 'type': '[ResourceNavigationLink]'},
        'service_association_links': {'key': 'properties.serviceAssociationLinks', 'type': '[ServiceAssociationLink]'},
        'delegations': {'key': 'properties.delegations', 'type': '[Delegation]'},
        'purpose': {'key': 'properties.purpose', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_network_policies': {'key': 'properties.privateEndpointNetworkPolicies', 'type': 'str'},
        'private_link_service_network_policies': {'key': 'properties.privateLinkServiceNetworkPolicies', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.address_prefix = kwargs.get('address_prefix', None)
        self.address_prefixes = kwargs.get('address_prefixes', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.route_table = kwargs.get('route_table', None)
        self.nat_gateway = kwargs.get('nat_gateway', None)
        self.service_endpoints = kwargs.get('service_endpoints', None)
        self.service_endpoint_policies = kwargs.get('service_endpoint_policies', None)
        self.private_endpoints = None
        self.ip_configurations = None
        self.ip_configuration_profiles = None
        self.ip_allocations = kwargs.get('ip_allocations', None)
        self.resource_navigation_links = None
        self.service_association_links = None
        self.delegations = kwargs.get('delegations', None)
        self.purpose = None
        self.provisioning_state = None
        self.private_endpoint_network_policies = kwargs.get('private_endpoint_network_policies', None)
        self.private_link_service_network_policies = kwargs.get('private_link_service_network_policies', None)


class SubnetAssociation(msrest.serialization.Model):
    """Subnet and it's custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules: list[~azure.mgmt.network.v2020_03_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubnetAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = kwargs.get('security_rules', None)


class SubnetListResult(msrest.serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :param value: The subnets in a virtual network.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.Subnet]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Subnet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubnetListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Topology(msrest.serialization.Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially created for the resource
     group.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: ~datetime.datetime
    :param resources: A list of topology resources.
    :type resources: list[~azure.mgmt.network.v2020_03_01.models.TopologyResource]
    """

    _validation = {
        'id': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'resources': {'key': 'resources', 'type': '[TopologyResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Topology, self).__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = kwargs.get('resources', None)


class TopologyAssociation(msrest.serialization.Model):
    """Resources that have an association with the parent resource.

    :param name: The name of the resource that is associated with the parent resource.
    :type name: str
    :param resource_id: The ID of the resource that is associated with the parent resource.
    :type resource_id: str
    :param association_type: The association type of the child resource to the parent resource.
     Possible values include: "Associated", "Contains".
    :type association_type: str or ~azure.mgmt.network.v2020_03_01.models.AssociationType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'association_type': {'key': 'associationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopologyAssociation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.association_type = kwargs.get('association_type', None)


class TopologyParameters(msrest.serialization.Model):
    """Parameters that define the representation of topology.

    :param target_resource_group_name: The name of the target resource group to perform topology
     on.
    :type target_resource_group_name: str
    :param target_virtual_network: The reference to the Virtual Network resource.
    :type target_virtual_network: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param target_subnet: The reference to the Subnet resource.
    :type target_subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    """

    _attribute_map = {
        'target_resource_group_name': {'key': 'targetResourceGroupName', 'type': 'str'},
        'target_virtual_network': {'key': 'targetVirtualNetwork', 'type': 'SubResource'},
        'target_subnet': {'key': 'targetSubnet', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopologyParameters, self).__init__(**kwargs)
        self.target_resource_group_name = kwargs.get('target_resource_group_name', None)
        self.target_virtual_network = kwargs.get('target_virtual_network', None)
        self.target_subnet = kwargs.get('target_subnet', None)


class TopologyResource(msrest.serialization.Model):
    """The network resource topology information for the given resource group.

    :param name: Name of the resource.
    :type name: str
    :param id: ID of the resource.
    :type id: str
    :param location: Resource location.
    :type location: str
    :param associations: Holds the associations the resource has with other resources in the
     resource group.
    :type associations: list[~azure.mgmt.network.v2020_03_01.models.TopologyAssociation]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'associations': {'key': 'associations', 'type': '[TopologyAssociation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopologyResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.location = kwargs.get('location', None)
        self.associations = kwargs.get('associations', None)


class TrafficAnalyticsConfigurationProperties(msrest.serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    :param enabled: Flag to enable/disable traffic analytics.
    :type enabled: bool
    :param workspace_id: The resource guid of the attached workspace.
    :type workspace_id: str
    :param workspace_region: The location of the attached workspace.
    :type workspace_region: str
    :param workspace_resource_id: Resource Id of the attached workspace.
    :type workspace_resource_id: str
    :param traffic_analytics_interval: The interval in minutes which would decide how frequently TA
     service should do flow analytics.
    :type traffic_analytics_interval: int
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_region': {'key': 'workspaceRegion', 'type': 'str'},
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
        'traffic_analytics_interval': {'key': 'trafficAnalyticsInterval', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficAnalyticsConfigurationProperties, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.workspace_region = kwargs.get('workspace_region', None)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)
        self.traffic_analytics_interval = kwargs.get('traffic_analytics_interval', None)


class TrafficAnalyticsProperties(msrest.serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    :param network_watcher_flow_analytics_configuration: Parameters that define the configuration
     of traffic analytics.
    :type network_watcher_flow_analytics_configuration:
     ~azure.mgmt.network.v2020_03_01.models.TrafficAnalyticsConfigurationProperties
    """

    _attribute_map = {
        'network_watcher_flow_analytics_configuration': {'key': 'networkWatcherFlowAnalyticsConfiguration', 'type': 'TrafficAnalyticsConfigurationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficAnalyticsProperties, self).__init__(**kwargs)
        self.network_watcher_flow_analytics_configuration = kwargs.get('network_watcher_flow_analytics_configuration', None)


class TrafficSelectorPolicy(msrest.serialization.Model):
    """An traffic selector policy for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param local_address_ranges: Required. A collection of local address spaces in CIDR format.
    :type local_address_ranges: list[str]
    :param remote_address_ranges: Required. A collection of remote address spaces in CIDR format.
    :type remote_address_ranges: list[str]
    """

    _validation = {
        'local_address_ranges': {'required': True},
        'remote_address_ranges': {'required': True},
    }

    _attribute_map = {
        'local_address_ranges': {'key': 'localAddressRanges', 'type': '[str]'},
        'remote_address_ranges': {'key': 'remoteAddressRanges', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficSelectorPolicy, self).__init__(**kwargs)
        self.local_address_ranges = kwargs['local_address_ranges']
        self.remote_address_ranges = kwargs['remote_address_ranges']


class TroubleshootingDetails(msrest.serialization.Model):
    """Information gained from troubleshooting of specified resource.

    :param id: The id of the get troubleshoot operation.
    :type id: str
    :param reason_type: Reason type of failure.
    :type reason_type: str
    :param summary: A summary of troubleshooting.
    :type summary: str
    :param detail: Details on troubleshooting results.
    :type detail: str
    :param recommended_actions: List of recommended actions.
    :type recommended_actions:
     list[~azure.mgmt.network.v2020_03_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'str'},
        'recommended_actions': {'key': 'recommendedActions', 'type': '[TroubleshootingRecommendedActions]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TroubleshootingDetails, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.reason_type = kwargs.get('reason_type', None)
        self.summary = kwargs.get('summary', None)
        self.detail = kwargs.get('detail', None)
        self.recommended_actions = kwargs.get('recommended_actions', None)


class TroubleshootingParameters(msrest.serialization.Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource to troubleshoot.
    :type target_resource_id: str
    :param storage_id: Required. The ID for the storage account to save the troubleshoot result.
    :type storage_id: str
    :param storage_path: Required. The path to the blob to save the troubleshoot result in.
    :type storage_path: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'storage_path': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'storage_path': {'key': 'properties.storagePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.storage_id = kwargs['storage_id']
        self.storage_path = kwargs['storage_path']


class TroubleshootingRecommendedActions(msrest.serialization.Model):
    """Recommended actions based on discovered issues.

    :param action_id: ID of the recommended action.
    :type action_id: str
    :param action_text: Description of recommended actions.
    :type action_text: str
    :param action_uri: The uri linking to a documentation for the recommended troubleshooting
     actions.
    :type action_uri: str
    :param action_uri_text: The information from the URI for the recommended troubleshooting
     actions.
    :type action_uri_text: str
    """

    _attribute_map = {
        'action_id': {'key': 'actionId', 'type': 'str'},
        'action_text': {'key': 'actionText', 'type': 'str'},
        'action_uri': {'key': 'actionUri', 'type': 'str'},
        'action_uri_text': {'key': 'actionUriText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TroubleshootingRecommendedActions, self).__init__(**kwargs)
        self.action_id = kwargs.get('action_id', None)
        self.action_text = kwargs.get('action_text', None)
        self.action_uri = kwargs.get('action_uri', None)
        self.action_uri_text = kwargs.get('action_uri_text', None)


class TroubleshootingResult(msrest.serialization.Model):
    """Troubleshooting information gained from specified resource.

    :param start_time: The start time of the troubleshooting.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the troubleshooting.
    :type end_time: ~datetime.datetime
    :param code: The result code of the troubleshooting.
    :type code: str
    :param results: Information from troubleshooting.
    :type results: list[~azure.mgmt.network.v2020_03_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'results': {'key': 'results', 'type': '[TroubleshootingDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TroubleshootingResult, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.code = kwargs.get('code', None)
        self.results = kwargs.get('results', None)


class TunnelConnectionHealth(msrest.serialization.Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual Network Gateway connection status. Possible values include:
     "Unknown", "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar last_connection_established_utc_time: The time at which connection was established in Utc
     format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        'tunnel': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'last_connection_established_utc_time': {'readonly': True},
    }

    _attribute_map = {
        'tunnel': {'key': 'tunnel', 'type': 'str'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'last_connection_established_utc_time': {'key': 'lastConnectionEstablishedUtcTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TunnelConnectionHealth, self).__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class UnprepareNetworkPoliciesRequest(msrest.serialization.Model):
    """Details of UnprepareNetworkPolicies for Subnet.

    :param service_name: The name of the service for which subnet is being unprepared for.
    :type service_name: str
    """

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnprepareNetworkPoliciesRequest, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)


class Usage(msrest.serialization.Model):
    """The network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :param unit: Required. An enum describing the unit of measurement. Possible values include:
     "Count".
    :type unit: str or ~azure.mgmt.network.v2020_03_01.models.UsageUnit
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2020_03_01.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'unit': {'required': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.unit = kwargs['unit']
        self.current_value = kwargs['current_value']
        self.limit = kwargs['limit']
        self.name = kwargs['name']


class UsageName(msrest.serialization.Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :param value: The list network resource usages.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.Usage]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VerificationIPFlowParameters(msrest.serialization.Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to perform next-hop on.
    :type target_resource_id: str
    :param direction: Required. The direction of the packet represented as a 5-tuple. Possible
     values include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2020_03_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Possible values include: "TCP", "UDP".
    :type protocol: str or ~azure.mgmt.network.v2020_03_01.models.IpFlowProtocol
    :param local_port: Required. The local port. Acceptable values are a single integer in the
     range (0-65535). Support for * for the source port, which depends on the direction.
    :type local_port: str
    :param remote_port: Required. The remote port. Acceptable values are a single integer in the
     range (0-65535). Support for * for the source port, which depends on the direction.
    :type remote_port: str
    :param local_ip_address: Required. The local IP address. Acceptable values are valid IPv4
     addresses.
    :type local_ip_address: str
    :param remote_ip_address: Required. The remote IP address. Acceptable values are valid IPv4
     addresses.
    :type remote_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
     enabled on any of them, then this parameter must be specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'direction': {'required': True},
        'protocol': {'required': True},
        'local_port': {'required': True},
        'remote_port': {'required': True},
        'local_ip_address': {'required': True},
        'remote_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VerificationIPFlowParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.direction = kwargs['direction']
        self.protocol = kwargs['protocol']
        self.local_port = kwargs['local_port']
        self.remote_port = kwargs['remote_port']
        self.local_ip_address = kwargs['local_ip_address']
        self.remote_ip_address = kwargs['remote_ip_address']
        self.target_nic_resource_id = kwargs.get('target_nic_resource_id', None)


class VerificationIPFlowResult(msrest.serialization.Model):
    """Results of IP flow verification on the target resource.

    :param access: Indicates whether the traffic is allowed or denied. Possible values include:
     "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2020_03_01.models.Access
    :param rule_name: Name of the rule. If input is not matched against any security rule, it is
     not displayed.
    :type rule_name: str
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VerificationIPFlowResult, self).__init__(**kwargs)
        self.access = kwargs.get('access', None)
        self.rule_name = kwargs.get('rule_name', None)


class VirtualApplianceNicProperties(msrest.serialization.Model):
    """Network Virtual Appliance NIC properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: NIC name.
    :vartype name: str
    :ivar public_ip_address: Public IP address.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP address.
    :vartype private_ip_address: str
    """

    _validation = {
        'name': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualApplianceNicProperties, self).__init__(**kwargs)
        self.name = None
        self.public_ip_address = None
        self.private_ip_address = None


class VirtualApplianceSkuProperties(msrest.serialization.Model):
    """Network Virtual Appliance Sku Properties.

    :param vendor: Virtual Appliance Vendor.
    :type vendor: str
    :param bundled_scale_unit: Virtual Appliance Scale Unit.
    :type bundled_scale_unit: str
    :param market_place_version: Virtual Appliance Version.
    :type market_place_version: str
    """

    _attribute_map = {
        'vendor': {'key': 'vendor', 'type': 'str'},
        'bundled_scale_unit': {'key': 'bundledScaleUnit', 'type': 'str'},
        'market_place_version': {'key': 'marketPlaceVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualApplianceSkuProperties, self).__init__(**kwargs)
        self.vendor = kwargs.get('vendor', None)
        self.bundled_scale_unit = kwargs.get('bundled_scale_unit', None)
        self.market_place_version = kwargs.get('market_place_version', None)


class VirtualHub(Resource):
    """VirtualHub Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_wan: The VirtualWAN to which the VirtualHub belongs.
    :type virtual_wan: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param vpn_gateway: The VpnGateway associated with this VirtualHub.
    :type vpn_gateway: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param p2_s_vpn_gateway: The P2SVpnGateway associated with this VirtualHub.
    :type p2_s_vpn_gateway: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param express_route_gateway: The expressRouteGateway associated with this VirtualHub.
    :type express_route_gateway: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param azure_firewall: The azureFirewall associated with this VirtualHub.
    :type azure_firewall: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param security_partner_provider: The securityPartnerProvider associated with this VirtualHub.
    :type security_partner_provider: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param virtual_network_connections: List of all vnet connections with this VirtualHub.
    :type virtual_network_connections:
     list[~azure.mgmt.network.v2020_03_01.models.HubVirtualNetworkConnection]
    :param address_prefix: Address-prefix for this VirtualHub.
    :type address_prefix: str
    :param route_table: The routeTable associated with this virtual hub.
    :type route_table: ~azure.mgmt.network.v2020_03_01.models.VirtualHubRouteTable
    :ivar provisioning_state: The provisioning state of the virtual hub resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param security_provider_name: The Security Provider name.
    :type security_provider_name: str
    :param virtual_hub_route_table_v2_s: List of all virtual hub route table v2s associated with
     this VirtualHub.
    :type virtual_hub_route_table_v2_s:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualHubRouteTableV2]
    :param sku: The sku of this VirtualHub.
    :type sku: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_wan': {'key': 'properties.virtualWan', 'type': 'SubResource'},
        'vpn_gateway': {'key': 'properties.vpnGateway', 'type': 'SubResource'},
        'p2_s_vpn_gateway': {'key': 'properties.p2SVpnGateway', 'type': 'SubResource'},
        'express_route_gateway': {'key': 'properties.expressRouteGateway', 'type': 'SubResource'},
        'azure_firewall': {'key': 'properties.azureFirewall', 'type': 'SubResource'},
        'security_partner_provider': {'key': 'properties.securityPartnerProvider', 'type': 'SubResource'},
        'virtual_network_connections': {'key': 'properties.virtualNetworkConnections', 'type': '[HubVirtualNetworkConnection]'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'route_table': {'key': 'properties.routeTable', 'type': 'VirtualHubRouteTable'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'security_provider_name': {'key': 'properties.securityProviderName', 'type': 'str'},
        'virtual_hub_route_table_v2_s': {'key': 'properties.virtualHubRouteTableV2s', 'type': '[VirtualHubRouteTableV2]'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHub, self).__init__(**kwargs)
        self.etag = None
        self.virtual_wan = kwargs.get('virtual_wan', None)
        self.vpn_gateway = kwargs.get('vpn_gateway', None)
        self.p2_s_vpn_gateway = kwargs.get('p2_s_vpn_gateway', None)
        self.express_route_gateway = kwargs.get('express_route_gateway', None)
        self.azure_firewall = kwargs.get('azure_firewall', None)
        self.security_partner_provider = kwargs.get('security_partner_provider', None)
        self.virtual_network_connections = kwargs.get('virtual_network_connections', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.route_table = kwargs.get('route_table', None)
        self.provisioning_state = None
        self.security_provider_name = kwargs.get('security_provider_name', None)
        self.virtual_hub_route_table_v2_s = kwargs.get('virtual_hub_route_table_v2_s', None)
        self.sku = kwargs.get('sku', None)


class VirtualHubId(msrest.serialization.Model):
    """Virtual Hub identifier.

    :param id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be
     deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same
     subscription.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHubId, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class VirtualHubRoute(msrest.serialization.Model):
    """VirtualHub route.

    :param address_prefixes: List of all addressPrefixes.
    :type address_prefixes: list[str]
    :param next_hop_ip_address: NextHop ip address.
    :type next_hop_ip_address: str
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHubRoute, self).__init__(**kwargs)
        self.address_prefixes = kwargs.get('address_prefixes', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)


class VirtualHubRouteTable(msrest.serialization.Model):
    """VirtualHub route table.

    :param routes: List of all routes.
    :type routes: list[~azure.mgmt.network.v2020_03_01.models.VirtualHubRoute]
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': '[VirtualHubRoute]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHubRouteTable, self).__init__(**kwargs)
        self.routes = kwargs.get('routes', None)


class VirtualHubRouteTableV2(SubResource):
    """VirtualHubRouteTableV2 Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param routes: List of all routes.
    :type routes: list[~azure.mgmt.network.v2020_03_01.models.VirtualHubRouteV2]
    :param attached_connections: List of all connections attached to this route table v2.
    :type attached_connections: list[str]
    :ivar provisioning_state: The provisioning state of the virtual hub route table v2 resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[VirtualHubRouteV2]'},
        'attached_connections': {'key': 'properties.attachedConnections', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHubRouteTableV2, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.routes = kwargs.get('routes', None)
        self.attached_connections = kwargs.get('attached_connections', None)
        self.provisioning_state = None


class VirtualHubRouteV2(msrest.serialization.Model):
    """VirtualHubRouteTableV2 route.

    :param destination_type: The type of destinations.
    :type destination_type: str
    :param destinations: List of all destinations.
    :type destinations: list[str]
    :param next_hop_type: The type of next hops.
    :type next_hop_type: str
    :param next_hops: NextHops ip address.
    :type next_hops: list[str]
    """

    _attribute_map = {
        'destination_type': {'key': 'destinationType', 'type': 'str'},
        'destinations': {'key': 'destinations', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hops': {'key': 'nextHops', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHubRouteV2, self).__init__(**kwargs)
        self.destination_type = kwargs.get('destination_type', None)
        self.destinations = kwargs.get('destinations', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hops = kwargs.get('next_hops', None)


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :type address_space: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2020_03_01.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2020_03_01.models.Subnet]
    :param virtual_network_peerings: A list of peerings in a Virtual Network.
    :type virtual_network_peerings:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkPeering]
    :ivar resource_guid: The resourceGuid property of the Virtual Network resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
     resources in the virtual network. It requires a DDoS protection plan associated with the
     resource.
    :type enable_ddos_protection: bool
    :param enable_vm_protection: Indicates if VM protection is enabled for all the subnets in the
     virtual network.
    :type enable_vm_protection: bool
    :param ddos_protection_plan: The DDoS protection plan associated with the virtual network.
    :type ddos_protection_plan: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param bgp_communities: Bgp Communities sent over ExpressRoute with each route corresponding to
     a prefix in this VNET.
    :type bgp_communities: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkBgpCommunities
    :param ip_allocations: Array of IpAllocation which reference this VNET.
    :type ip_allocations: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'virtual_network_peerings': {'key': 'properties.virtualNetworkPeerings', 'type': '[VirtualNetworkPeering]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_ddos_protection': {'key': 'properties.enableDdosProtection', 'type': 'bool'},
        'enable_vm_protection': {'key': 'properties.enableVmProtection', 'type': 'bool'},
        'ddos_protection_plan': {'key': 'properties.ddosProtectionPlan', 'type': 'SubResource'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': 'VirtualNetworkBgpCommunities'},
        'ip_allocations': {'key': 'properties.ipAllocations', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(**kwargs)
        self.etag = None
        self.address_space = kwargs.get('address_space', None)
        self.dhcp_options = kwargs.get('dhcp_options', None)
        self.subnets = kwargs.get('subnets', None)
        self.virtual_network_peerings = kwargs.get('virtual_network_peerings', None)
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_ddos_protection = kwargs.get('enable_ddos_protection', False)
        self.enable_vm_protection = kwargs.get('enable_vm_protection', False)
        self.ddos_protection_plan = kwargs.get('ddos_protection_plan', None)
        self.bgp_communities = kwargs.get('bgp_communities', None)
        self.ip_allocations = kwargs.get('ip_allocations', None)


class VirtualNetworkBgpCommunities(msrest.serialization.Model):
    """Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param virtual_network_community: Required. The BGP community associated with the virtual
     network.
    :type virtual_network_community: str
    :ivar regional_community: The BGP community associated with the region of the virtual network.
    :vartype regional_community: str
    """

    _validation = {
        'virtual_network_community': {'required': True},
        'regional_community': {'readonly': True},
    }

    _attribute_map = {
        'virtual_network_community': {'key': 'virtualNetworkCommunity', 'type': 'str'},
        'regional_community': {'key': 'regionalCommunity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkBgpCommunities, self).__init__(**kwargs)
        self.virtual_network_community = kwargs['virtual_network_community']
        self.regional_community = None


class VirtualNetworkConnectionGatewayReference(msrest.serialization.Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkConnectionGatewayReference, self).__init__(**kwargs)
        self.id = kwargs['id']


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible values include: "Vpn",
     "ExpressRoute".
    :type gateway_type: str or ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values include:
     "PolicyBased", "RouteBased".
    :type vpn_type: str or ~azure.mgmt.network.v2020_03_01.models.VpnType
    :param vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if
     gatewayType is not VPN. Possible values include: "None", "Generation1", "Generation2".
    :type vpn_gateway_generation: str or
     ~azure.mgmt.network.v2020_03_01.models.VpnGatewayGeneration
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :type enable_bgp: bool
    :param enable_private_ip_address: Whether private IP needs to be enabled on this gateway for
     connections or not.
    :type enable_private_ip_address: bool
    :param active: ActiveActive flag.
    :type active: bool
    :param gateway_default_site: The reference to the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :type gateway_default_site: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param sku: The reference to the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference to the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :type vpn_client_configuration: ~azure.mgmt.network.v2020_03_01.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2020_03_01.models.BgpSettings
    :param custom_routes: The reference to the address space resource which represents the custom
     routes address space specified by the customer for virtual network gateway and VpnClient.
    :type custom_routes: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :ivar resource_guid: The resource GUID property of the virtual network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param enable_dns_forwarding: Whether dns forwarding is enabled or not.
    :type enable_dns_forwarding: bool
    :ivar inbound_dns_forwarding_endpoint: The IP address allocated by the gateway to which dns
     requests can be sent.
    :vartype inbound_dns_forwarding_endpoint: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'inbound_dns_forwarding_endpoint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'vpn_gateway_generation': {'key': 'properties.vpnGatewayGeneration', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'enable_private_ip_address': {'key': 'properties.enablePrivateIpAddress', 'type': 'bool'},
        'active': {'key': 'properties.activeActive', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'custom_routes': {'key': 'properties.customRoutes', 'type': 'AddressSpace'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_dns_forwarding': {'key': 'properties.enableDnsForwarding', 'type': 'bool'},
        'inbound_dns_forwarding_endpoint': {'key': 'properties.inboundDnsForwardingEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGateway, self).__init__(**kwargs)
        self.etag = None
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.gateway_type = kwargs.get('gateway_type', None)
        self.vpn_type = kwargs.get('vpn_type', None)
        self.vpn_gateway_generation = kwargs.get('vpn_gateway_generation', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.enable_private_ip_address = kwargs.get('enable_private_ip_address', None)
        self.active = kwargs.get('active', None)
        self.gateway_default_site = kwargs.get('gateway_default_site', None)
        self.sku = kwargs.get('sku', None)
        self.vpn_client_configuration = kwargs.get('vpn_client_configuration', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.custom_routes = kwargs.get('custom_routes', None)
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_dns_forwarding = kwargs.get('enable_dns_forwarding', None)
        self.inbound_dns_forwarding_endpoint = None


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual network gateway resource.
    :type virtual_network_gateway1: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGateway
    :param virtual_network_gateway2: The reference to virtual network gateway resource.
    :type virtual_network_gateway2: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGateway
    :param local_network_gateway2: The reference to local network gateway resource.
    :type local_network_gateway2: ~azure.mgmt.network.v2020_03_01.models.LocalNetworkGateway
    :param connection_type: Required. Gateway connection type. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionType
    :param connection_protocol: Connection protocol used for this connection. Possible values
     include: "IKEv2", "IKEv1".
    :type connection_protocol: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionProtocol
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds.
    :type dpd_timeout_seconds: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Possible values include:
     "Unknown", "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2020_03_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_local_azure_ip_address: Use private local Azure IP for the connection.
    :type use_local_azure_ip_address: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :type traffic_selector_policies:
     list[~azure.mgmt.network.v2020_03_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :type express_route_gateway_bypass: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'connection_protocol': {'key': 'properties.connectionProtocol', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'dpd_timeout_seconds': {'key': 'properties.dpdTimeoutSeconds', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_local_azure_ip_address': {'key': 'properties.useLocalAzureIpAddress', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'traffic_selector_policies': {'key': 'properties.trafficSelectorPolicies', 'type': '[TrafficSelectorPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_gateway_bypass': {'key': 'properties.expressRouteGatewayBypass', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnection, self).__init__(**kwargs)
        self.etag = None
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs['virtual_network_gateway1']
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs['connection_type']
        self.connection_protocol = kwargs.get('connection_protocol', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.dpd_timeout_seconds = kwargs.get('dpd_timeout_seconds', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_local_azure_ip_address = kwargs.get('use_local_azure_ip_address', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.traffic_selector_policies = kwargs.get('traffic_selector_policies', None)
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = kwargs.get('express_route_gateway_bypass', None)


class VirtualNetworkGatewayConnectionListEntity(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkConnectionGatewayReference
    :param virtual_network_gateway2: The reference to virtual network gateway resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkConnectionGatewayReference
    :param local_network_gateway2: The reference to local network gateway resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkConnectionGatewayReference
    :param connection_type: Required. Gateway connection type. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionType
    :param connection_protocol: Connection protocol used for this connection. Possible values
     include: "IKEv2", "IKEv1".
    :type connection_protocol: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionProtocol
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Possible values include:
     "Unknown", "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2020_03_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :type traffic_selector_policies:
     list[~azure.mgmt.network.v2020_03_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :type express_route_gateway_bypass: bool
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'connection_protocol': {'key': 'properties.connectionProtocol', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'traffic_selector_policies': {'key': 'properties.trafficSelectorPolicies', 'type': '[TrafficSelectorPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_gateway_bypass': {'key': 'properties.expressRouteGatewayBypass', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListEntity, self).__init__(**kwargs)
        self.etag = None
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs['virtual_network_gateway1']
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs['connection_type']
        self.connection_protocol = kwargs.get('connection_protocol', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.traffic_selector_policies = kwargs.get('traffic_selector_policies', None)
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = kwargs.get('express_route_gateway_bypass', None)


class VirtualNetworkGatewayConnectionListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param private_ip_allocation_method: The private IP address allocation method. Possible values
     include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2020_03_01.models.IPAllocationMethod
    :param subnet: The reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param public_ip_address: The reference to the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar private_ip_address: Private IP Address for this gateway.
    :vartype private_ip_address: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway IP
     configuration resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.private_ip_address = None
        self.provisioning_state = None


class VirtualNetworkGatewayListConnectionsResult(msrest.serialization.Model):
    """Response for the VirtualNetworkGatewayListConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :type value:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionListEntity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnectionListEntity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayListConnectionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class VirtualNetworkGatewayListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of VirtualNetworkGateway resources that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class VirtualNetworkGatewaySku(msrest.serialization.Model):
    """VirtualNetworkGatewaySku details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Gateway SKU name. Possible values include: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ".
    :type name: str or ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway SKU tier. Possible values include: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ".
    :type tier: str or ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _validation = {
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = None


class VirtualNetworkListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :param value: A list of VirtualNetwork resources in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetwork]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkListUsageResult(msrest.serialization.Model):
    """Response for the virtual networks GetUsage API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: VirtualNetwork usage stats.
    :vartype value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkUsage]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkListUsageResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkPeering(SubResource):
    """Peerings in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param allow_virtual_network_access: Whether the VMs in the local virtual network space would
     be able to access the VMs in remote virtual network space.
    :type allow_virtual_network_access: bool
    :param allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual
     network will be allowed/disallowed in remote virtual network.
    :type allow_forwarded_traffic: bool
    :param allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :type allow_gateway_transit: bool
    :param use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :type use_remote_gateways: bool
    :param remote_virtual_network: The reference to the remote virtual network. The remote virtual
     network can be in the same or different region (preview). See here to register for the preview
     and learn more
     (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
    :type remote_virtual_network: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param remote_address_space: The reference to the remote virtual network address space.
    :type remote_address_space: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :param peering_state: The status of the virtual network peering. Possible values include:
     "Initiated", "Connected", "Disconnected".
    :type peering_state: str or ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkPeeringState
    :ivar provisioning_state: The provisioning state of the virtual network peering resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allow_virtual_network_access': {'key': 'properties.allowVirtualNetworkAccess', 'type': 'bool'},
        'allow_forwarded_traffic': {'key': 'properties.allowForwardedTraffic', 'type': 'bool'},
        'allow_gateway_transit': {'key': 'properties.allowGatewayTransit', 'type': 'bool'},
        'use_remote_gateways': {'key': 'properties.useRemoteGateways', 'type': 'bool'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'remote_address_space': {'key': 'properties.remoteAddressSpace', 'type': 'AddressSpace'},
        'peering_state': {'key': 'properties.peeringState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkPeering, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.allow_virtual_network_access = kwargs.get('allow_virtual_network_access', None)
        self.allow_forwarded_traffic = kwargs.get('allow_forwarded_traffic', None)
        self.allow_gateway_transit = kwargs.get('allow_gateway_transit', None)
        self.use_remote_gateways = kwargs.get('use_remote_gateways', None)
        self.remote_virtual_network = kwargs.get('remote_virtual_network', None)
        self.remote_address_space = kwargs.get('remote_address_space', None)
        self.peering_state = kwargs.get('peering_state', None)
        self.provisioning_state = None


class VirtualNetworkPeeringListResult(msrest.serialization.Model):
    """Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network.

    :param value: The peerings in a virtual network.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkPeeringListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkTap(Resource):
    """Virtual Network Tap resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar network_interface_tap_configurations: Specifies the list of resource IDs for the network
     interface IP configuration that needs to be tapped.
    :vartype network_interface_tap_configurations:
     list[~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceTapConfiguration]
    :ivar resource_guid: The resource GUID property of the virtual network tap resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network tap resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param destination_network_interface_ip_configuration: The reference to the private IP Address
     of the collector nic that will receive the tap.
    :type destination_network_interface_ip_configuration:
     ~azure.mgmt.network.v2020_03_01.models.NetworkInterfaceIPConfiguration
    :param destination_load_balancer_front_end_ip_configuration: The reference to the private IP
     address on the internal Load Balancer that will receive the tap.
    :type destination_load_balancer_front_end_ip_configuration:
     ~azure.mgmt.network.v2020_03_01.models.FrontendIPConfiguration
    :param destination_port: The VXLAN destination port that will receive the tapped traffic.
    :type destination_port: int
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'network_interface_tap_configurations': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'network_interface_tap_configurations': {'key': 'properties.networkInterfaceTapConfigurations', 'type': '[NetworkInterfaceTapConfiguration]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination_network_interface_ip_configuration': {'key': 'properties.destinationNetworkInterfaceIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'destination_load_balancer_front_end_ip_configuration': {'key': 'properties.destinationLoadBalancerFrontEndIPConfiguration', 'type': 'FrontendIPConfiguration'},
        'destination_port': {'key': 'properties.destinationPort', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkTap, self).__init__(**kwargs)
        self.etag = None
        self.network_interface_tap_configurations = None
        self.resource_guid = None
        self.provisioning_state = None
        self.destination_network_interface_ip_configuration = kwargs.get('destination_network_interface_ip_configuration', None)
        self.destination_load_balancer_front_end_ip_configuration = kwargs.get('destination_load_balancer_front_end_ip_configuration', None)
        self.destination_port = kwargs.get('destination_port', None)


class VirtualNetworkTapListResult(msrest.serialization.Model):
    """Response for ListVirtualNetworkTap API service call.

    :param value: A list of VirtualNetworkTaps in a resource group.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualNetworkTap]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkTap]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkTapListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkUsage(msrest.serialization.Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name: ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        'current_value': {'readonly': True},
        'id': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'id': {'key': 'id', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'float'},
        'name': {'key': 'name', 'type': 'VirtualNetworkUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkUsage, self).__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(msrest.serialization.Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkUsageName, self).__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VirtualRouter(Resource):
    """VirtualRouter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_router_asn: VirtualRouter ASN.
    :type virtual_router_asn: long
    :param virtual_router_ips: VirtualRouter IPs.
    :type virtual_router_ips: list[str]
    :param hosted_subnet: The Subnet on which VirtualRouter is hosted.
    :type hosted_subnet: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param hosted_gateway: The Gateway on which VirtualRouter is hosted.
    :type hosted_gateway: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :ivar peerings: List of references to VirtualRouterPeerings.
    :vartype peerings: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_router_asn': {'maximum': 4294967295, 'minimum': 0},
        'peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_router_asn': {'key': 'properties.virtualRouterAsn', 'type': 'long'},
        'virtual_router_ips': {'key': 'properties.virtualRouterIps', 'type': '[str]'},
        'hosted_subnet': {'key': 'properties.hostedSubnet', 'type': 'SubResource'},
        'hosted_gateway': {'key': 'properties.hostedGateway', 'type': 'SubResource'},
        'peerings': {'key': 'properties.peerings', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualRouter, self).__init__(**kwargs)
        self.etag = None
        self.virtual_router_asn = kwargs.get('virtual_router_asn', None)
        self.virtual_router_ips = kwargs.get('virtual_router_ips', None)
        self.hosted_subnet = kwargs.get('hosted_subnet', None)
        self.hosted_gateway = kwargs.get('hosted_gateway', None)
        self.peerings = None
        self.provisioning_state = None


class VirtualRouterListResult(msrest.serialization.Model):
    """Response for ListVirtualRouters API service call.

    :param value: List of Virtual Routers.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualRouter]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualRouter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualRouterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualRouterPeering(SubResource):
    """Virtual Router Peering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the virtual router peering that is unique within a virtual router.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Peering type.
    :vartype type: str
    :param peer_asn: Peer ASN.
    :type peer_asn: long
    :param peer_ip: Peer IP.
    :type peer_ip: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 0},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'peer_asn': {'key': 'properties.peerAsn', 'type': 'long'},
        'peer_ip': {'key': 'properties.peerIp', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualRouterPeering, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.peer_asn = kwargs.get('peer_asn', None)
        self.peer_ip = kwargs.get('peer_ip', None)
        self.provisioning_state = None


class VirtualRouterPeeringListResult(msrest.serialization.Model):
    """Response for ListVirtualRouterPeerings API service call.

    :param value: List of VirtualRouterPeerings in a VirtualRouter.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VirtualRouterPeering]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualRouterPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualRouterPeeringListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualWAN(Resource):
    """VirtualWAN Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param disable_vpn_encryption: Vpn encryption to be disabled or not.
    :type disable_vpn_encryption: bool
    :ivar virtual_hubs: List of VirtualHubs in the VirtualWAN.
    :vartype virtual_hubs: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar vpn_sites: List of VpnSites in the VirtualWAN.
    :vartype vpn_sites: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :param allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
    :type allow_branch_to_branch_traffic: bool
    :param allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
    :type allow_vnet_to_vnet_traffic: bool
    :ivar office365_local_breakout_category: The office local breakout category. Possible values
     include: "Optimize", "OptimizeAndAllow", "All", "None".
    :vartype office365_local_breakout_category: str or
     ~azure.mgmt.network.v2020_03_01.models.OfficeTrafficCategory
    :ivar provisioning_state: The provisioning state of the virtual WAN resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param type_properties_type: The type of the VirtualWAN.
    :type type_properties_type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'virtual_hubs': {'readonly': True},
        'vpn_sites': {'readonly': True},
        'office365_local_breakout_category': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'disable_vpn_encryption': {'key': 'properties.disableVpnEncryption', 'type': 'bool'},
        'virtual_hubs': {'key': 'properties.virtualHubs', 'type': '[SubResource]'},
        'vpn_sites': {'key': 'properties.vpnSites', 'type': '[SubResource]'},
        'allow_branch_to_branch_traffic': {'key': 'properties.allowBranchToBranchTraffic', 'type': 'bool'},
        'allow_vnet_to_vnet_traffic': {'key': 'properties.allowVnetToVnetTraffic', 'type': 'bool'},
        'office365_local_breakout_category': {'key': 'properties.office365LocalBreakoutCategory', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualWAN, self).__init__(**kwargs)
        self.etag = None
        self.disable_vpn_encryption = kwargs.get('disable_vpn_encryption', None)
        self.virtual_hubs = None
        self.vpn_sites = None
        self.allow_branch_to_branch_traffic = kwargs.get('allow_branch_to_branch_traffic', None)
        self.allow_vnet_to_vnet_traffic = kwargs.get('allow_vnet_to_vnet_traffic', None)
        self.office365_local_breakout_category = None
        self.provisioning_state = None
        self.type_properties_type = kwargs.get('type_properties_type', None)


class VirtualWanSecurityProvider(msrest.serialization.Model):
    """Collection of SecurityProviders.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of the security provider.
    :type name: str
    :param url: Url of the security provider.
    :type url: str
    :ivar type: Name of the security provider. Possible values include: "External", "Native".
    :vartype type: str or ~azure.mgmt.network.v2020_03_01.models.VirtualWanSecurityProviderType
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualWanSecurityProvider, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.url = kwargs.get('url', None)
        self.type = None


class VirtualWanSecurityProviders(msrest.serialization.Model):
    """Collection of SecurityProviders.

    :param supported_providers: List of VirtualWAN security providers.
    :type supported_providers:
     list[~azure.mgmt.network.v2020_03_01.models.VirtualWanSecurityProvider]
    """

    _attribute_map = {
        'supported_providers': {'key': 'supportedProviders', 'type': '[VirtualWanSecurityProvider]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualWanSecurityProviders, self).__init__(**kwargs)
        self.supported_providers = kwargs.get('supported_providers', None)


class VirtualWanVpnProfileParameters(msrest.serialization.Model):
    """Virtual Wan Vpn profile parameters Vpn profile generation.

    :param vpn_server_configuration_resource_id: VpnServerConfiguration partial resource uri with
     which VirtualWan is associated to.
    :type vpn_server_configuration_resource_id: str
    :param authentication_method: VPN client authentication method. Possible values include:
     "EAPTLS", "EAPMSCHAPv2".
    :type authentication_method: str or ~azure.mgmt.network.v2020_03_01.models.AuthenticationMethod
    """

    _attribute_map = {
        'vpn_server_configuration_resource_id': {'key': 'vpnServerConfigurationResourceId', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualWanVpnProfileParameters, self).__init__(**kwargs)
        self.vpn_server_configuration_resource_id = kwargs.get('vpn_server_configuration_resource_id', None)
        self.authentication_method = kwargs.get('authentication_method', None)


class VM(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VM, self).__init__(**kwargs)


class VpnClientConfiguration(msrest.serialization.Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: The reference to the address space resource which represents
     Address space for P2S VpnClient.
    :type vpn_client_address_pool: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
     gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnClientRevokedCertificate]
    :param vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
    :type vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.VpnClientProtocol]
    :param vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S
     client.
    :type vpn_client_ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param radius_server_address: The radius server address property of the VirtualNetworkGateway
     resource for vpn client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
     for vpn client connection.
    :type radius_server_secret: str
    :param radius_servers: The radiusServers property for multiple radius server configuration.
    :type radius_servers: list[~azure.mgmt.network.v2020_03_01.models.RadiusServer]
    :param aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :type aad_tenant: str
    :param aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn
     client connection used for AAD authentication.
    :type aad_audience: str
    :param aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :type aad_issuer: str
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
        'vpn_client_protocols': {'key': 'vpnClientProtocols', 'type': '[str]'},
        'vpn_client_ipsec_policies': {'key': 'vpnClientIpsecPolicies', 'type': '[IpsecPolicy]'},
        'radius_server_address': {'key': 'radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'radiusServerSecret', 'type': 'str'},
        'radius_servers': {'key': 'radiusServers', 'type': '[RadiusServer]'},
        'aad_tenant': {'key': 'aadTenant', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
        'aad_issuer': {'key': 'aadIssuer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = kwargs.get('vpn_client_address_pool', None)
        self.vpn_client_root_certificates = kwargs.get('vpn_client_root_certificates', None)
        self.vpn_client_revoked_certificates = kwargs.get('vpn_client_revoked_certificates', None)
        self.vpn_client_protocols = kwargs.get('vpn_client_protocols', None)
        self.vpn_client_ipsec_policies = kwargs.get('vpn_client_ipsec_policies', None)
        self.radius_server_address = kwargs.get('radius_server_address', None)
        self.radius_server_secret = kwargs.get('radius_server_secret', None)
        self.radius_servers = kwargs.get('radius_servers', None)
        self.aad_tenant = kwargs.get('aad_tenant', None)
        self.aad_audience = kwargs.get('aad_audience', None)
        self.aad_issuer = kwargs.get('aad_issuer', None)


class VpnClientConnectionHealth(msrest.serialization.Model):
    """VpnClientConnectionHealth properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_ingress_bytes_transferred: Total of the Ingress Bytes Transferred in this P2S Vpn
     connection.
    :vartype total_ingress_bytes_transferred: long
    :ivar total_egress_bytes_transferred: Total of the Egress Bytes Transferred in this connection.
    :vartype total_egress_bytes_transferred: long
    :param vpn_client_connections_count: The total of p2s vpn clients connected at this time to
     this P2SVpnGateway.
    :type vpn_client_connections_count: int
    :param allocated_ip_addresses: List of allocated ip addresses to the connected p2s vpn clients.
    :type allocated_ip_addresses: list[str]
    """

    _validation = {
        'total_ingress_bytes_transferred': {'readonly': True},
        'total_egress_bytes_transferred': {'readonly': True},
    }

    _attribute_map = {
        'total_ingress_bytes_transferred': {'key': 'totalIngressBytesTransferred', 'type': 'long'},
        'total_egress_bytes_transferred': {'key': 'totalEgressBytesTransferred', 'type': 'long'},
        'vpn_client_connections_count': {'key': 'vpnClientConnectionsCount', 'type': 'int'},
        'allocated_ip_addresses': {'key': 'allocatedIpAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientConnectionHealth, self).__init__(**kwargs)
        self.total_ingress_bytes_transferred = None
        self.total_egress_bytes_transferred = None
        self.vpn_client_connections_count = kwargs.get('vpn_client_connections_count', None)
        self.allocated_ip_addresses = kwargs.get('allocated_ip_addresses', None)


class VpnClientConnectionHealthDetail(msrest.serialization.Model):
    """VPN client connection health detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vpn_connection_id: The vpn client Id.
    :vartype vpn_connection_id: str
    :ivar vpn_connection_duration: The duration time of a connected vpn client.
    :vartype vpn_connection_duration: long
    :ivar vpn_connection_time: The start time of a connected vpn client.
    :vartype vpn_connection_time: str
    :ivar public_ip_address: The public Ip of a connected vpn client.
    :vartype public_ip_address: str
    :ivar private_ip_address: The assigned private Ip of a connected vpn client.
    :vartype private_ip_address: str
    :ivar vpn_user_name: The user name of a connected vpn client.
    :vartype vpn_user_name: str
    :ivar max_bandwidth: The max band width.
    :vartype max_bandwidth: long
    :ivar egress_packets_transferred: The egress packets per second.
    :vartype egress_packets_transferred: long
    :ivar egress_bytes_transferred: The egress bytes per second.
    :vartype egress_bytes_transferred: long
    :ivar ingress_packets_transferred: The ingress packets per second.
    :vartype ingress_packets_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes per second.
    :vartype ingress_bytes_transferred: long
    :ivar max_packets_per_second: The max packets transferred per second.
    :vartype max_packets_per_second: long
    """

    _validation = {
        'vpn_connection_id': {'readonly': True},
        'vpn_connection_duration': {'readonly': True},
        'vpn_connection_time': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'vpn_user_name': {'readonly': True},
        'max_bandwidth': {'readonly': True},
        'egress_packets_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_packets_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'max_packets_per_second': {'readonly': True},
    }

    _attribute_map = {
        'vpn_connection_id': {'key': 'vpnConnectionId', 'type': 'str'},
        'vpn_connection_duration': {'key': 'vpnConnectionDuration', 'type': 'long'},
        'vpn_connection_time': {'key': 'vpnConnectionTime', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'vpn_user_name': {'key': 'vpnUserName', 'type': 'str'},
        'max_bandwidth': {'key': 'maxBandwidth', 'type': 'long'},
        'egress_packets_transferred': {'key': 'egressPacketsTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'ingress_packets_transferred': {'key': 'ingressPacketsTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'max_packets_per_second': {'key': 'maxPacketsPerSecond', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientConnectionHealthDetail, self).__init__(**kwargs)
        self.vpn_connection_id = None
        self.vpn_connection_duration = None
        self.vpn_connection_time = None
        self.public_ip_address = None
        self.private_ip_address = None
        self.vpn_user_name = None
        self.max_bandwidth = None
        self.egress_packets_transferred = None
        self.egress_bytes_transferred = None
        self.ingress_packets_transferred = None
        self.ingress_bytes_transferred = None
        self.max_packets_per_second = None


class VpnClientConnectionHealthDetailListResult(msrest.serialization.Model):
    """List of virtual network gateway vpn client connection health.

    :param value: List of vpn client connection health.
    :type value: list[~azure.mgmt.network.v2020_03_01.models.VpnClientConnectionHealthDetail]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnClientConnectionHealthDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientConnectionHealthDetailListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VpnClientIPsecParameters(msrest.serialization.Model):
    """An IPSec parameters for a virtual network gateway P2S connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) lifetime in seconds for P2S client.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association (also called Quick Mode
     or Phase 2 SA) payload size in KB for P2S client..
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE phase 1). Possible
     values include: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192",
     "GCMAES256".
    :type ipsec_encryption: str or ~azure.mgmt.network.v2020_03_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase 1). Possible values
     include: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", "GCMAES256".
    :type ipsec_integrity: str or ~azure.mgmt.network.v2020_03_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase 2). Possible values
     include: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", "GCMAES128".
    :type ike_encryption: str or ~azure.mgmt.network.v2020_03_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2). Possible values
     include: "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", "GCMAES128".
    :type ike_integrity: str or ~azure.mgmt.network.v2020_03_01.models.IkeIntegrity
    :param dh_group: Required. The DH Group used in IKE Phase 1 for initial SA. Possible values
     include: "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384",
     "DHGroup24".
    :type dh_group: str or ~azure.mgmt.network.v2020_03_01.models.DhGroup
    :param pfs_group: Required. The Pfs Group used in IKE Phase 2 for new child SA. Possible values
     include: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", "PFSMM".
    :type pfs_group: str or ~azure.mgmt.network.v2020_03_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientIPsecParameters, self).__init__(**kwargs)
        self.sa_life_time_seconds = kwargs['sa_life_time_seconds']
        self.sa_data_size_kilobytes = kwargs['sa_data_size_kilobytes']
        self.ipsec_encryption = kwargs['ipsec_encryption']
        self.ipsec_integrity = kwargs['ipsec_integrity']
        self.ike_encryption = kwargs['ike_encryption']
        self.ike_integrity = kwargs['ike_integrity']
        self.dh_group = kwargs['dh_group']
        self.pfs_group = kwargs['pfs_group']


class VpnClientParameters(msrest.serialization.Model):
    """Vpn Client Parameters for package generation.

    :param processor_architecture: VPN client Processor Architecture. Possible values include:
     "Amd64", "X86".
    :type processor_architecture: str or
     ~azure.mgmt.network.v2020_03_01.models.ProcessorArchitecture
    :param authentication_method: VPN client authentication method. Possible values include:
     "EAPTLS", "EAPMSCHAPv2".
    :type authentication_method: str or ~azure.mgmt.network.v2020_03_01.models.AuthenticationMethod
    :param radius_server_auth_certificate: The public certificate data for the radius server
     authentication certificate as a Base-64 encoded string. Required only if external radius
     authentication has been configured with EAPTLS authentication.
    :type radius_server_auth_certificate: str
    :param client_root_certificates: A list of client root certificates public certificate data
     encoded as Base-64 strings. Optional parameter for external radius based authentication with
     EAPTLS.
    :type client_root_certificates: list[str]
    """

    _attribute_map = {
        'processor_architecture': {'key': 'processorArchitecture', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
        'radius_server_auth_certificate': {'key': 'radiusServerAuthCertificate', 'type': 'str'},
        'client_root_certificates': {'key': 'clientRootCertificates', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = kwargs.get('processor_architecture', None)
        self.authentication_method = kwargs.get('authentication_method', None)
        self.radius_server_auth_certificate = kwargs.get('radius_server_auth_certificate', None)
        self.client_root_certificates = kwargs.get('client_root_certificates', None)


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientRevokedCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.thumbprint = kwargs.get('thumbprint', None)
        self.provisioning_state = None


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param public_cert_data: Required. The certificate public data.
    :type public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'public_cert_data': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.public_cert_data = kwargs['public_cert_data']
        self.provisioning_state = None


class VpnConnection(SubResource):
    """VpnConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param remote_vpn_site: Id of the connected vpn site.
    :type remote_vpn_site: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param routing_weight: Routing weight for vpn connection.
    :type routing_weight: int
    :param dpd_timeout_seconds: The dead peer detection timeout for a vpn connection in seconds.
    :type dpd_timeout_seconds: int
    :ivar connection_status: The connection status. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or ~azure.mgmt.network.v2020_03_01.models.VpnConnectionStatus
    :param vpn_connection_protocol_type: Connection protocol used for this connection. Possible
     values include: "IKEv2", "IKEv1".
    :type vpn_connection_protocol_type: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar ingress_bytes_transferred: Ingress bytes transferred.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: Egress bytes transferred.
    :vartype egress_bytes_transferred: long
    :param connection_bandwidth: Expected bandwidth in MBPS.
    :type connection_bandwidth: int
    :param shared_key: SharedKey for the vpn connection.
    :type shared_key: str
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param enable_rate_limiting: EnableBgp flag.
    :type enable_rate_limiting: bool
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    :param use_local_azure_ip_address: Use local azure ip to initiate connection.
    :type use_local_azure_ip_address: bool
    :ivar provisioning_state: The provisioning state of the VPN connection resource. Possible
     values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param vpn_link_connections: List of all vpn site link connections to the gateway.
    :type vpn_link_connections: list[~azure.mgmt.network.v2020_03_01.models.VpnSiteLinkConnection]
    """

    _validation = {
        'etag': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'remote_vpn_site': {'key': 'properties.remoteVpnSite', 'type': 'SubResource'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'dpd_timeout_seconds': {'key': 'properties.dpdTimeoutSeconds', 'type': 'int'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'vpn_connection_protocol_type': {'key': 'properties.vpnConnectionProtocolType', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'connection_bandwidth': {'key': 'properties.connectionBandwidth', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'enable_rate_limiting': {'key': 'properties.enableRateLimiting', 'type': 'bool'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
        'use_local_azure_ip_address': {'key': 'properties.useLocalAzureIpAddress', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_link_connections': {'key': 'properties.vpnLinkConnections', 'type': '[VpnSiteLinkConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.remote_vpn_site = kwargs.get('remote_vpn_site', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.dpd_timeout_seconds = kwargs.get('dpd_timeout_seconds', None)
        self.connection_status = None
        self.vpn_connection_protocol_type = kwargs.get('vpn_connection_protocol_type', None)
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.connection_bandwidth = kwargs.get('connection_bandwidth', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.enable_rate_limiting = kwargs.get('enable_rate_limiting', None)
        self.enable_internet_security = kwargs.get('enable_internet_security', None)
        self.use_local_azure_ip_address = kwargs.get('use_local_azure_ip_address', None)
        self.provisioning_state = None
        self.vpn_link_connections = kwargs.get('vpn_link_connections', None)


class VpnDeviceScriptParameters(msrest.serialization.Model):
    """Vpn device configuration script generation parameters.

    :param vendor: The vendor for the vpn device.
    :type vendor: str
    :param device_family: The device family for the vpn device.
    :type device_family: str
    :param firmware_version: The firmware version for the vpn device.
    :type firmware_version: str
    """

    _attribute_map = {
        'vendor': {'key': 'vendor', 'type': 'str'},
        'device_family': {'key': 'deviceFamily', 'type': 'str'},
        'firmware_version': {'key': 'firmwareVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnDeviceScriptParameters, self).__init__(**kwargs)
        self.vendor = kwargs.get('vendor', None)
        self.device_family = kwargs.get('device_family', None)
        self.firmware_version = kwargs.get('firmware_version', None)


class VpnGateway(Resource):
    """VpnGateway Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_hub: The VirtualHub to which the gateway belongs.
    :type virtual_hub: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param connections: List of all vpn connections to the gateway.
    :type connections: list[~azure.mgmt.network.v2020_03_01.models.VpnConnection]
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2020_03_01.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN gateway resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param vpn_gateway_scale_unit: The scale unit for this vpn gateway.
    :type vpn_gateway_scale_unit: int
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'connections': {'key': 'properties.connections', 'type': '[VpnConnection]'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_gateway_scale_unit': {'key': 'properties.vpnGatewayScaleUnit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnGateway, self).__init__(**kwargs)
        self.etag = None
        self.virtual_hub = kwargs.get('virtual_hub', None)
        self.connections = kwargs.get('connections', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = kwargs.get('vpn_gateway_scale_unit', None)


class VpnLinkBgpSettings(msrest.serialization.Model):
    """BGP settings details for a link.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :type bgp_peering_address: str
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnLinkBgpSettings, self).__init__(**kwargs)
        self.asn = kwargs.get('asn', None)
        self.bgp_peering_address = kwargs.get('bgp_peering_address', None)


class VpnLinkProviderProperties(msrest.serialization.Model):
    """List of properties of a link provider.

    :param link_provider_name: Name of the link provider.
    :type link_provider_name: str
    :param link_speed_in_mbps: Link speed.
    :type link_speed_in_mbps: int
    """

    _attribute_map = {
        'link_provider_name': {'key': 'linkProviderName', 'type': 'str'},
        'link_speed_in_mbps': {'key': 'linkSpeedInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnLinkProviderProperties, self).__init__(**kwargs)
        self.link_provider_name = kwargs.get('link_provider_name', None)
        self.link_speed_in_mbps = kwargs.get('link_speed_in_mbps', None)


class VpnPacketCaptureStartParameters(msrest.serialization.Model):
    """Start packet capture parameters on virtual network gateway.

    :param filter_data: Start Packet capture parameters.
    :type filter_data: str
    """

    _attribute_map = {
        'filter_data': {'key': 'filterData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnPacketCaptureStartParameters, self).__init__(**kwargs)
        self.filter_data = kwargs.get('filter_data', None)


class VpnPacketCaptureStopParameters(msrest.serialization.Model):
    """Stop packet capture parameters.

    :param sas_url: SAS url for packet capture on virtual network gateway.
    :type sas_url: str
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnPacketCaptureStopParameters, self).__init__(**kwargs)
        self.sas_url = kwargs.get('sas_url', None)


class VpnProfileResponse(msrest.serialization.Model):
    """Vpn Profile Response for package generation.

    :param profile_url: URL to the VPN profile.
    :type profile_url: str
    """

    _attribute_map = {
        'profile_url': {'key': 'profileUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnProfileResponse, self).__init__(**kwargs)
        self.profile_url = kwargs.get('profile_url', None)


class VpnServerConfigRadiusClientRootCertificate(msrest.serialization.Model):
    """Properties of the Radius client root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param thumbprint: The Radius client root certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfigRadiusClientRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.thumbprint = kwargs.get('thumbprint', None)


class VpnServerConfigRadiusServerRootCertificate(msrest.serialization.Model):
    """Properties of Radius Server root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param public_cert_data: The certificate public data.
    :type public_cert_data: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'public_cert_data': {'key': 'publicCertData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfigRadiusServerRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.public_cert_data = kwargs.get('public_cert_data', None)


class VpnServerConfiguration(Resource):
    """VpnServerConfiguration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param name_properties_name: The name of the VpnServerConfiguration that is unique within a
     resource group.
    :type name_properties_name: str
    :param vpn_protocols: VPN protocols for the VpnServerConfiguration.
    :type vpn_protocols: list[str or
     ~azure.mgmt.network.v2020_03_01.models.VpnGatewayTunnelingProtocol]
    :param vpn_authentication_types: VPN authentication types for the VpnServerConfiguration.
    :type vpn_authentication_types: list[str or
     ~azure.mgmt.network.v2020_03_01.models.VpnAuthenticationType]
    :param vpn_client_root_certificates: VPN client root certificate of VpnServerConfiguration.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnServerConfigVpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VPN client revoked certificate of
     VpnServerConfiguration.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnServerConfigVpnClientRevokedCertificate]
    :param radius_server_root_certificates: Radius Server root certificate of
     VpnServerConfiguration.
    :type radius_server_root_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnServerConfigRadiusServerRootCertificate]
    :param radius_client_root_certificates: Radius client root certificate of
     VpnServerConfiguration.
    :type radius_client_root_certificates:
     list[~azure.mgmt.network.v2020_03_01.models.VpnServerConfigRadiusClientRootCertificate]
    :param vpn_client_ipsec_policies: VpnClientIpsecPolicies for VpnServerConfiguration.
    :type vpn_client_ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param radius_server_address: The radius server address property of the VpnServerConfiguration
     resource for point to site client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the VpnServerConfiguration resource
     for point to site client connection.
    :type radius_server_secret: str
    :param radius_servers: Multiple Radius Server configuration for VpnServerConfiguration.
    :type radius_servers: list[~azure.mgmt.network.v2020_03_01.models.RadiusServer]
    :param aad_authentication_parameters: The set of aad vpn authentication parameters.
    :type aad_authentication_parameters:
     ~azure.mgmt.network.v2020_03_01.models.AadAuthenticationParameters
    :ivar provisioning_state: The provisioning state of the VpnServerConfiguration resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :ivar p2_s_vpn_gateways: List of references to P2SVpnGateways.
    :vartype p2_s_vpn_gateways: list[~azure.mgmt.network.v2020_03_01.models.P2SVpnGateway]
    :ivar etag_properties_etag: A unique read-only string that changes whenever the resource is
     updated.
    :vartype etag_properties_etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'p2_s_vpn_gateways': {'readonly': True},
        'etag_properties_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'vpn_protocols': {'key': 'properties.vpnProtocols', 'type': '[str]'},
        'vpn_authentication_types': {'key': 'properties.vpnAuthenticationTypes', 'type': '[str]'},
        'vpn_client_root_certificates': {'key': 'properties.vpnClientRootCertificates', 'type': '[VpnServerConfigVpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'properties.vpnClientRevokedCertificates', 'type': '[VpnServerConfigVpnClientRevokedCertificate]'},
        'radius_server_root_certificates': {'key': 'properties.radiusServerRootCertificates', 'type': '[VpnServerConfigRadiusServerRootCertificate]'},
        'radius_client_root_certificates': {'key': 'properties.radiusClientRootCertificates', 'type': '[VpnServerConfigRadiusClientRootCertificate]'},
        'vpn_client_ipsec_policies': {'key': 'properties.vpnClientIpsecPolicies', 'type': '[IpsecPolicy]'},
        'radius_server_address': {'key': 'properties.radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'properties.radiusServerSecret', 'type': 'str'},
        'radius_servers': {'key': 'properties.radiusServers', 'type': '[RadiusServer]'},
        'aad_authentication_parameters': {'key': 'properties.aadAuthenticationParameters', 'type': 'AadAuthenticationParameters'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'p2_s_vpn_gateways': {'key': 'properties.p2SVpnGateways', 'type': '[P2SVpnGateway]'},
        'etag_properties_etag': {'key': 'properties.etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfiguration, self).__init__(**kwargs)
        self.etag = None
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.vpn_protocols = kwargs.get('vpn_protocols', None)
        self.vpn_authentication_types = kwargs.get('vpn_authentication_types', None)
        self.vpn_client_root_certificates = kwargs.get('vpn_client_root_certificates', None)
        self.vpn_client_revoked_certificates = kwargs.get('vpn_client_revoked_certificates', None)
        self.radius_server_root_certificates = kwargs.get('radius_server_root_certificates', None)
        self.radius_client_root_certificates = kwargs.get('radius_client_root_certificates', None)
        self.vpn_client_ipsec_policies = kwargs.get('vpn_client_ipsec_policies', None)
        self.radius_server_address = kwargs.get('radius_server_address', None)
        self.radius_server_secret = kwargs.get('radius_server_secret', None)
        self.radius_servers = kwargs.get('radius_servers', None)
        self.aad_authentication_parameters = kwargs.get('aad_authentication_parameters', None)
        self.provisioning_state = None
        self.p2_s_vpn_gateways = None
        self.etag_properties_etag = None


class VpnServerConfigurationsResponse(msrest.serialization.Model):
    """VpnServerConfigurations list associated with VirtualWan Response.

    :param vpn_server_configuration_resource_ids: List of VpnServerConfigurations associated with
     VirtualWan.
    :type vpn_server_configuration_resource_ids: list[str]
    """

    _attribute_map = {
        'vpn_server_configuration_resource_ids': {'key': 'vpnServerConfigurationResourceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfigurationsResponse, self).__init__(**kwargs)
        self.vpn_server_configuration_resource_ids = kwargs.get('vpn_server_configuration_resource_ids', None)


class VpnServerConfigVpnClientRevokedCertificate(msrest.serialization.Model):
    """Properties of the revoked VPN client certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfigVpnClientRevokedCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.thumbprint = kwargs.get('thumbprint', None)


class VpnServerConfigVpnClientRootCertificate(msrest.serialization.Model):
    """Properties of VPN client root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param public_cert_data: The certificate public data.
    :type public_cert_data: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'public_cert_data': {'key': 'publicCertData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnServerConfigVpnClientRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.public_cert_data = kwargs.get('public_cert_data', None)


class VpnSite(Resource):
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param virtual_wan: The VirtualWAN to which the vpnSite belongs.
    :type virtual_wan: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param device_properties: The device properties.
    :type device_properties: ~azure.mgmt.network.v2020_03_01.models.DeviceProperties
    :param ip_address: The ip-address for the vpn-site.
    :type ip_address: str
    :param site_key: The key for vpn-site that can be used for connections.
    :type site_key: str
    :param address_space: The AddressSpace that contains an array of IP address ranges.
    :type address_space: ~azure.mgmt.network.v2020_03_01.models.AddressSpace
    :param bgp_properties: The set of bgp properties.
    :type bgp_properties: ~azure.mgmt.network.v2020_03_01.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN site resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :param is_security_site: IsSecuritySite flag.
    :type is_security_site: bool
    :param vpn_site_links: List of all vpn site links.
    :type vpn_site_links: list[~azure.mgmt.network.v2020_03_01.models.VpnSiteLink]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_wan': {'key': 'properties.virtualWan', 'type': 'SubResource'},
        'device_properties': {'key': 'properties.deviceProperties', 'type': 'DeviceProperties'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'site_key': {'key': 'properties.siteKey', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'bgp_properties': {'key': 'properties.bgpProperties', 'type': 'BgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_security_site': {'key': 'properties.isSecuritySite', 'type': 'bool'},
        'vpn_site_links': {'key': 'properties.vpnSiteLinks', 'type': '[VpnSiteLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnSite, self).__init__(**kwargs)
        self.etag = None
        self.virtual_wan = kwargs.get('virtual_wan', None)
        self.device_properties = kwargs.get('device_properties', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.site_key = kwargs.get('site_key', None)
        self.address_space = kwargs.get('address_space', None)
        self.bgp_properties = kwargs.get('bgp_properties', None)
        self.provisioning_state = None
        self.is_security_site = kwargs.get('is_security_site', None)
        self.vpn_site_links = kwargs.get('vpn_site_links', None)


class VpnSiteId(msrest.serialization.Model):
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vpn_site: The resource-uri of the vpn-site for which config is to be fetched.
    :vartype vpn_site: str
    """

    _validation = {
        'vpn_site': {'readonly': True},
    }

    _attribute_map = {
        'vpn_site': {'key': 'vpnSite', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnSiteId, self).__init__(**kwargs)
        self.vpn_site = None


class VpnSiteLink(SubResource):
    """VpnSiteLink Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param link_properties: The link provider properties.
    :type link_properties: ~azure.mgmt.network.v2020_03_01.models.VpnLinkProviderProperties
    :param ip_address: The ip-address for the vpn-site-link.
    :type ip_address: str
    :param fqdn: FQDN of vpn-site-link.
    :type fqdn: str
    :param bgp_properties: The set of bgp properties.
    :type bgp_properties: ~azure.mgmt.network.v2020_03_01.models.VpnLinkBgpSettings
    :ivar provisioning_state: The provisioning state of the VPN site link resource. Possible values
     include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'link_properties': {'key': 'properties.linkProperties', 'type': 'VpnLinkProviderProperties'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'bgp_properties': {'key': 'properties.bgpProperties', 'type': 'VpnLinkBgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnSiteLink, self).__init__(**kwargs)
        self.etag = None
        self.name = kwargs.get('name', None)
        self.type = None
        self.link_properties = kwargs.get('link_properties', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.bgp_properties = kwargs.get('bgp_properties', None)
        self.provisioning_state = None


class VpnSiteLinkConnection(SubResource):
    """VpnSiteLinkConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param vpn_site_link: Id of the connected vpn site link.
    :type vpn_site_link: ~azure.mgmt.network.v2020_03_01.models.SubResource
    :param routing_weight: Routing weight for vpn connection.
    :type routing_weight: int
    :ivar connection_status: The connection status. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :vartype connection_status: str or ~azure.mgmt.network.v2020_03_01.models.VpnConnectionStatus
    :param vpn_connection_protocol_type: Connection protocol used for this connection. Possible
     values include: "IKEv2", "IKEv1".
    :type vpn_connection_protocol_type: str or
     ~azure.mgmt.network.v2020_03_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar ingress_bytes_transferred: Ingress bytes transferred.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: Egress bytes transferred.
    :vartype egress_bytes_transferred: long
    :param connection_bandwidth: Expected bandwidth in MBPS.
    :type connection_bandwidth: int
    :param shared_key: SharedKey for the vpn connection.
    :type shared_key: str
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this connection.
    :type ipsec_policies: list[~azure.mgmt.network.v2020_03_01.models.IpsecPolicy]
    :param enable_rate_limiting: EnableBgp flag.
    :type enable_rate_limiting: bool
    :param use_local_azure_ip_address: Use local azure ip to initiate connection.
    :type use_local_azure_ip_address: bool
    :ivar provisioning_state: The provisioning state of the VPN site link connection resource.
     Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vpn_site_link': {'key': 'properties.vpnSiteLink', 'type': 'SubResource'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'vpn_connection_protocol_type': {'key': 'properties.vpnConnectionProtocolType', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'connection_bandwidth': {'key': 'properties.connectionBandwidth', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'enable_rate_limiting': {'key': 'properties.enableRateLimiting', 'type': 'bool'},
        'use_local_azure_ip_address': {'key': 'properties.useLocalAzureIpAddress', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnSiteLinkConnection, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.type = None
        self.vpn_site_link = kwargs.get('vpn_site_link', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.connection_status = None
        self.vpn_connection_protocol_type = kwargs.get('vpn_connection_protocol_type', None)
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.connection_bandwidth = kwargs.get('connection_bandwidth', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.enable_rate_limiting = kwargs.get('enable_rate_limiting', None)
        self.use_local_azure_ip_address = kwargs.get('use_local_azure_ip_address', None)
        self.provisioning_state = None


class WebApplicationFirewallCustomRule(msrest.serialization.Model):
    """Defines contents of a web application rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the resource that is unique within a policy. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param priority: Required. Priority of the rule. Rules with a lower value will be evaluated
     before rules with a higher value.
    :type priority: int
    :param rule_type: Required. The rule type. Possible values include: "MatchRule", "Invalid".
    :type rule_type: str or ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallRuleType
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.network.v2020_03_01.models.MatchCondition]
    :param action: Required. Type of Actions. Possible values include: "Allow", "Block", "Log".
    :type action: str or ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallAction
    """

    _validation = {
        'name': {'max_length': 128, 'min_length': 0},
        'etag': {'readonly': True},
        'priority': {'required': True},
        'rule_type': {'required': True},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebApplicationFirewallCustomRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = None
        self.priority = kwargs['priority']
        self.rule_type = kwargs['rule_type']
        self.match_conditions = kwargs['match_conditions']
        self.action = kwargs['action']


class WebApplicationFirewallPolicy(Resource):
    """Defines web application firewall policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param policy_settings: The PolicySettings for policy.
    :type policy_settings: ~azure.mgmt.network.v2020_03_01.models.PolicySettings
    :param custom_rules: The custom rules inside the policy.
    :type custom_rules:
     list[~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallCustomRule]
    :ivar application_gateways: A collection of references to application gateways.
    :vartype application_gateways: list[~azure.mgmt.network.v2020_03_01.models.ApplicationGateway]
    :ivar provisioning_state: The provisioning state of the web application firewall policy
     resource. Possible values include: "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2020_03_01.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or
     ~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallPolicyResourceState
    :param managed_rules: Describes the managedRules structure.
    :type managed_rules: ~azure.mgmt.network.v2020_03_01.models.ManagedRulesDefinition
    :ivar http_listeners: A collection of references to application gateway http listeners.
    :vartype http_listeners: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    :ivar path_based_rules: A collection of references to application gateway path rules.
    :vartype path_based_rules: list[~azure.mgmt.network.v2020_03_01.models.SubResource]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'application_gateways': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'http_listeners': {'readonly': True},
        'path_based_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'custom_rules': {'key': 'properties.customRules', 'type': '[WebApplicationFirewallCustomRule]'},
        'application_gateways': {'key': 'properties.applicationGateways', 'type': '[ApplicationGateway]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRulesDefinition'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[SubResource]'},
        'path_based_rules': {'key': 'properties.pathBasedRules', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebApplicationFirewallPolicy, self).__init__(**kwargs)
        self.etag = None
        self.policy_settings = kwargs.get('policy_settings', None)
        self.custom_rules = kwargs.get('custom_rules', None)
        self.application_gateways = None
        self.provisioning_state = None
        self.resource_state = None
        self.managed_rules = kwargs.get('managed_rules', None)
        self.http_listeners = None
        self.path_based_rules = None


class WebApplicationFirewallPolicyListResult(msrest.serialization.Model):
    """Result of the request to list WebApplicationFirewallPolicies. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.network.v2020_03_01.models.WebApplicationFirewallPolicy]
    :ivar next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebApplicationFirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebApplicationFirewallPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
