# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class NetworkSecurityGroup(Resource):
    """
    NetworkSecurityGroup resource

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param str etag: Gets a unique read-only string that changes whenever the
     resource is updated
    :param list security_rules: Gets or sets Security rules of network
     security group
    :param list default_security_rules: Gets or sets Default security rules
     of network security group
    :param list network_interfaces: Gets collection of references to Network
     Interfaces
    :param list subnets: Gets collection of references to subnets
    :param str resource_guid: Gets or sets resource guid property of the
     network security group resource
    :param str provisioning_state: Gets or sets Provisioning state of the
     PublicIP resource Updating/Deleting/Failed
    """

    _required = []

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]', 'flatten': True},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]', 'flatten': True},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]', 'flatten': True},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]', 'flatten': True},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, etag=None, security_rules=None, default_security_rules=None, network_interfaces=None, subnets=None, resource_guid=None, provisioning_state=None):
        super(NetworkSecurityGroup, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = network_interfaces
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
