# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class NetworkInterfaceIPConfiguration(SubResource):
    """
    IPConfiguration in a NetworkInterface

    :param str id: Resource Id
    :param str name: Gets name of the resource that is unique within a
     resource group. This name can be used to access the resource
    :param str etag: A unique read-only string that changes whenever the
     resource is updated
    :param list load_balancer_backend_address_pools: Gets or sets the
     reference of LoadBalancerBackendAddressPool resource
    :param list load_balancer_inbound_nat_rules: Gets or sets list of
     references of LoadBalancerInboundNatRules
    :param str private_ip_address:
    :param str private_ip_allocation_method: Gets or sets PrivateIP
     allocation method (Static/Dynamic). Possible values include: 'Static',
     'Dynamic'
    :param Subnet subnet:  Default value: {} .
    :param PublicIPAddress public_ip_address:
    :param str provisioning_state:
    """

    _required = []

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]', 'flatten': True},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]', 'flatten': True},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str', 'flatten': True},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'IPAllocationMethod', 'flatten': True},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet', 'flatten': True},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, etag=None, load_balancer_backend_address_pools=None, load_balancer_inbound_nat_rules=None, private_ip_address=None, private_ip_allocation_method=None, subnet=None, public_ip_address=None, provisioning_state=None):
        super(NetworkInterfaceIPConfiguration, self).__init__(id=id)
        self.name = name
        self.etag = etag
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state
