# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class LoadBalancer(Resource):
    """
    LoadBalancer resource

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param str etag: Gets a unique read-only string that changes whenever the
     resource is updated
    :param list frontend_ip_configurations: Gets or sets frontend IP
     addresses of the load balancer
    :param list backend_address_pools: Gets or sets Pools of backend IP
     addresseses
    :param list load_balancing_rules: Gets or sets loadbalancing rules
    :param list probes: Gets or sets list of Load balancer probes
    :param list inbound_nat_rules: Gets or sets list of inbound rules
    :param list inbound_nat_pools: Gets or sets inbound NAT pools
    :param list outbound_nat_rules: Gets or sets outbound NAT rules
    :param str resource_guid: Gets or sets resource guid property of the Load
     balancer resource
    :param str provisioning_state: Gets or sets Provisioning state of the
     PublicIP resource Updating/Deleting/Failed
    """

    _required = []

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]', 'flatten': True},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]', 'flatten': True},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]', 'flatten': True},
        'probes': {'key': 'properties.probes', 'type': '[Probe]', 'flatten': True},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]', 'flatten': True},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]', 'flatten': True},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]', 'flatten': True},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, etag=None, frontend_ip_configurations=None, backend_address_pools=None, load_balancing_rules=None, probes=None, inbound_nat_rules=None, inbound_nat_pools=None, outbound_nat_rules=None, resource_guid=None, provisioning_state=None):
        super(LoadBalancer, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
