# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExpressRouteCircuitRoutesTable(Model):
    """
    The routes table associated with the ExpressRouteCircuit

    :param str address_prefix: Gets AddressPrefix.
    :param str next_hop_type: Gets NextHopType. Possible values include:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance',
     'None'
    :param str next_hop_ip: Gets NextHopIP.
    :param str as_path: Gets AsPath.
    """

    _required = ['next_hop_type']

    _attribute_map = {
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'RouteNextHopType'},
        'next_hop_ip': {'key': 'nextHopIP', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
    }

    def __init__(self, next_hop_type, address_prefix=None, next_hop_ip=None, as_path=None):
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip = next_hop_ip
        self.as_path = as_path
