# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class ApplicationGatewayRequestRoutingRule(SubResource):
    """
    Request routing rule of application gateway

    :param str id: Resource Id
    :param str name: Gets name of the resource that is unique within a
     resource group. This name can be used to access the resource
    :param str etag: A unique read-only string that changes whenever the
     resource is updated
    :param str rule_type: Gets or sets the rule type. Possible values
     include: 'Basic', 'PathBasedRouting'
    :param SubResource backend_address_pool: Gets or sets backend address
     pool resource of application gateway
    :param SubResource backend_http_settings: Gets or sets frontend port
     resource of application gateway
    :param SubResource http_listener: Gets or sets http listener resource of
     application gateway
    :param SubResource url_path_map: Gets or sets url path map resource of
     application gateway
    :param str provisioning_state: Gets or sets Provisioning state of the
     request routing rule resource Updating/Deleting/Failed
    """

    _required = []

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'ApplicationGatewayRequestRoutingRuleType', 'flatten': True},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource', 'flatten': True},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource', 'flatten': True},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource', 'flatten': True},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, etag=None, rule_type=None, backend_address_pool=None, backend_http_settings=None, http_listener=None, url_path_map=None, provisioning_state=None):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(id=id)
        self.name = name
        self.etag = etag
        self.rule_type = rule_type
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.provisioning_state = provisioning_state
