# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class ApplicationGatewayHttpListener(SubResource):
    """
    Http listener of application gateway

    :param str id: Resource Id
    :param str name: Gets name of the resource that is unique within a
     resource group. This name can be used to access the resource
    :param str etag: A unique read-only string that changes whenever the
     resource is updated
    :param SubResource frontend_ip_configuration: Gets or sets frontend IP
     configuration resource of application gateway
    :param SubResource frontend_port: Gets or sets frontend port resource of
     application gateway
    :param str protocol: Gets or sets the protocol. Possible values include:
     'Http', 'Https'
    :param str host_name: Gets or sets the host name of http listener
    :param SubResource ssl_certificate: Gets or sets ssl certificate resource
     of application gateway
    :param bool require_server_name_indication: Gets or sets the
     requireServerNameIndication of http listener
    :param str provisioning_state: Gets or sets Provisioning state of the
     http listener resource Updating/Deleting/Failed
    """

    _required = []

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource', 'flatten': True},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource', 'flatten': True},
        'protocol': {'key': 'properties.protocol', 'type': 'ApplicationGatewayProtocol', 'flatten': True},
        'host_name': {'key': 'properties.hostName', 'type': 'str', 'flatten': True},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource', 'flatten': True},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, etag=None, frontend_ip_configuration=None, frontend_port=None, protocol=None, host_name=None, ssl_certificate=None, require_server_name_indication=None, provisioning_state=None):
        super(ApplicationGatewayHttpListener, self).__init__(id=id)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = provisioning_state
