# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ApplicationGateway(Resource):
    """
    ApplicationGateways resource

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param str etag: Gets a unique read-only string that changes whenever the
     resource is updated
    :param ApplicationGatewaySku sku: Gets or sets sku of application gateway
     resource
    :param str operational_state: Gets operational state of application
     gateway resource. Possible values include: 'Stopped', 'Starting',
     'Running', 'Stopping'
    :param list gateway_ip_configurations: Gets or sets subnets of
     application gateway resource
    :param list ssl_certificates: Gets or sets ssl certificates of
     application gateway resource
    :param list frontend_ip_configurations: Gets or sets frontend IP
     addresses of application gateway resource
    :param list frontend_ports: Gets or sets frontend ports of application
     gateway resource
    :param list probes: Gets or sets probes of application gateway resource
    :param list backend_address_pools: Gets or sets backend address pool of
     application gateway resource
    :param list backend_http_settings_collection: Gets or sets backend http
     settings of application gateway resource
    :param list http_listeners: Gets or sets HTTP listeners of application
     gateway resource
    :param list url_path_maps: Gets or sets URL path map of application
     gateway resource
    :param list request_routing_rules: Gets or sets request routing rules of
     application gateway resource
    :param str resource_guid: Gets or sets resource guid property of the
     ApplicationGateway resource
    :param str provisioning_state: Gets or sets Provisioning state of the
     ApplicationGateway resource Updating/Deleting/Failed
    """

    _required = []

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku', 'flatten': True},
        'operational_state': {'key': 'properties.operationalState', 'type': 'ApplicationGatewayOperationalState', 'flatten': True},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]', 'flatten': True},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]', 'flatten': True},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]', 'flatten': True},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]', 'flatten': True},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]', 'flatten': True},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]', 'flatten': True},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]', 'flatten': True},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]', 'flatten': True},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]', 'flatten': True},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]', 'flatten': True},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, etag=None, sku=None, operational_state=None, gateway_ip_configurations=None, ssl_certificates=None, frontend_ip_configurations=None, frontend_ports=None, probes=None, backend_address_pools=None, backend_http_settings_collection=None, http_listeners=None, url_path_maps=None, request_routing_rules=None, resource_guid=None, provisioning_state=None):
        super(ApplicationGateway, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.etag = etag
        self.sku = sku
        self.operational_state = operational_state
        self.gateway_ip_configurations = gateway_ip_configurations
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
