# coding: latin-1
from .utils import *
from . import exceptions
from . import utils

default = 'eng'

langs = ['eng', 'por', 'spa']

class Eng:  # English

    ot_books = ['Genesis', 'Exodus', 'Leviticus', 'Numbers', 'Deuteronomy', 'Joshua', 'Judges', 'Ruth', '1 Samuel', '2 Samuel', '1 Kings', '2 Kings',
                '1 Chronicles', '2 Chronicles', 'Ezra', 'Nehemiah', 'Esther', 'Job', 'Psalms', 'Proverbs', 'Ecclesiastes', 'Song of Solomon', 'Isaiah',
                'Jeremiah', 'Lamentations', 'Ezekiel', 'Daniel', 'Hosea', 'Joel', 'Amos', 'Obadiah', 'Jonah', 'Micah', 'Nahum', 'Habakkuk', 'Zephaniah',
                'Haggai', 'Zechariah', 'Malachi']

    nt_books = ['Matthew', 'Mark', 'Luke', 'John', 'Acts', 'Romans', '1 Corinthians', '2 Corinthians', 'Galatians', 'Ephesians', 'Philippians',
                'Colossians', '1 Thessalonians', '2 Thessalonians', '1 Timothy', '2 Timothy', 'Titus', 'Philemon', 'Hebrews', 'James', '1 Peter',
                '2 Peter', '1 John', '2 John', '3 John', 'Jude', 'Revelation']

    bofm_books = ['1 Nephi', '2 Nephi', 'Jacob', 'Enos', 'Jarom', 'Omni', 'Words of Mormon', 'Mosiah', 'Alma', 'Helaman', '3 Nephi', '4 Nephi',
                  'Mormon', 'Ether', 'Moroni']

    pgp_books = ['Moses', 'Abraham', 'Joseph Smith-Matthew', 'Joseph Smith-History', 'Articles of Faith']
    
    dc_testament = ['Doctrine and Covenants']

class Spa:  # Spanish
 
    ot_books = ['Gnesis', 'xodo', 'Levtico', 'Nmeros', 'Deuteronomio', 'Josu', 'Jueces', 'Rut', '1 Samuel', '2 Samuel', '1 Reyes', '2 Reyes',
                '1 Crnicas', '2 Crnicas', 'Esdras', 'Nehemas', 'Ester', 'Job', 'Salmos', 'Proverbios', 'Eclesiasts', 'Cantares', 'Isaas',
                'Jeremas', 'Lamentaciones', 'Ezequiel', 'Daniel', 'Oseas', 'Joel', 'Ams', 'Abdas', 'Jons', 'Miqueas', 'Nahm', 'Habacuc',
                'Sofonas', 'Hageo', 'Zacaras', 'Malaquas']
    
    nt_books = ['Mateo', 'Marcos', 'Lucas', 'Juan', 'Hechos', 'Romanos', '1 Corintios', '2 Corintios', 'Glatas', 'Efesios', 'Filipenses',
                'Colosenses', '1 Tesalonicenses', '2 Tesalonicenses', '1 Timoteo', '2 Timoteo', 'Tito', 'Filemn', 'Hebreos', 'Santiago', '1 Pedro',
                '2 Pedro', '1 Juan', '2 Juan', '3 Juan', 'Judas', 'Apocalipsis']
    
    bofm_books = ['1 Nefi', '2 Nefi', 'Jacob', 'Ens', 'Jarom', 'Omni', 'Palabras de Mormn', 'Mosah', 'Alma', 'Helamn', '3 Nefi', '4 Nefi',
                  'Mormn', 'ter', 'Moroni']
    
    pgp_books = ['Moiss', 'Abraham', 'Jos Smith-Mateo', 'Jos Smith-Historia', 'Artculos de Fe']
    
    dc_testament = ['Doctrina y Convenios']

class Por:  # Portuguese

    ot_books = ['Gnesis', 'xodo', 'Levtico', 'Nmeros', 'Deuteronmio', 'Josu', 'Juzes', 'Rute', '1 Samuel', '2 Samuel', '1 Reis', '2 Reis',
                '1 Crnicas', '2 Crnicas', 'Esdras', 'Neemias', 'Ester', 'J', 'Salmos', 'Provrbios', 'Eclesiastes', 'Cantares de Salomo',
                'Isaas', 'Jeremias', 'Lamentaes', 'Ezequiel', 'Daniel', 'Oseias', 'Joel', 'Ams', 'Obadias', 'Jonas', 'Miqueias', 'Naum',
                'Habacuque', 'Sofonias', 'Ageu', 'Zacarias', 'Malaquias']
    
    nt_books = ['Mateus', 'Marcos', 'Lucas', 'Joo', 'Atos', 'Romanos', '1 Corntios', '2 Corntios', 'Glatas', 'Efsios', 'Filipenses',
                'Colossenses', '1 Tessalonicenses', '2 Tessalonicenses', '1 Timteo', '2 Timteo', 'Tito', 'Filemom', 'Hebreus', 'Tiago', '1 Pedro',
                '2 Pedro', '1 Joo', '2 Joo', '3 Joo', 'Judas', 'Apocalipse']
    
    bofm_books = ['1 Nfi', '2 Nfi', 'Jac', 'Enos', 'Jarom', 'mni', 'Palavras de Mrmon', 'Mosias', 'Alma', 'Helam', '3 Nfi', '4 Nfi',
                  'Mrmon', 'ter', 'Morni']
    
    pgp_books = ['Moiss', 'Abrao', 'Joseph Smith-Mateus', 'Joseph Smith-Histria', 'Regras de F']
    
    dc_testament = ['Doutrina e Convnios']


eng = Eng
spa = Spa
por = Por


def lang_verify(language):
    if language in langs:
        return eval(language)
    else:
        raise exceptions.InvalidLang('The language "{}" is not a valid language. Try one: {}.'.format(str(language), str(langs)))


def match_scripture(book_name, language):
    language = lang_verify(language)
    book_name = book_name.lower()
    scripture = ''
    
    if book_name in utils.lower_list(language.ot_books):
        scripture = 'ot'
    elif book_name in utils.lower_list(language.nt_books):
        scripture = 'nt'
    elif book_name in utils.lower_list(language.bofm_books):
        scripture = 'bofm'
    elif book_name in utils.lower_list(language.pgp_books):
        scripture = 'pgp'
    elif book_name in utils.lower_list(language.dc_testament):
        scripture = 'dc-testament'
    else:
        raise exceptions.InvalidBook('The book \'{}\' does not exist.'.format(str(book_name)))
    
    return scripture


def get_book_code(book, language):
    language = lang_verify(language)
    book = book.lower()
    
    codes = None
    
    if book in lower_list(language.ot_books):
        scripture = language.ot_books
        codes = utils.ot_data['codes']
    elif book in lower_list(language.nt_books):
        scripture = language.nt_books
        codes = utils.nt_data['codes']
    elif book in lower_list(language.bofm_books):
        scripture = language.bofm_books
        codes = utils.bofm_data['codes']
    elif book in lower_list(language.pgp_books):
        codes = utils.pgp_data['codes']
        scripture = language.pgp_books
    elif book in lower_list(language.dc_testament):
        codes = ['dc']
        scripture = language.dc_testament
    else:
        raise exceptions.InvalidBook('The book \'{}\' does not exist.'.format(str(book)))
    
    return codes[item_position(book, scripture)]


def translate_book_name(from_lang, to_lang, book_name):
    from_lang = lang_verify(from_lang)
    to_lang = lang_verify(to_lang)
    
    scripture = match_scripture(book_name, from_lang)
    
    if scripture == 'ot':
        position = item_position(book_name, from_lang.ot_books)
        if position != -1:
            return to_lang.ot_books[position]
            
    if scripture == 'nt':
        position = item_position(book_name, from_lang.nt_books)
        if position != -1:
            return to_lang.nt_books[position]
    
    if scripture == 'bofm':
        position = item_position(book_name, from_lang.bofm_books)
        if position != -1:
            return to_lang.bofm_books[position]
    
    if scripture == 'pgp':
        position = item_position(book_name, from_lang.pgp_books)
        if position != -1:
            return to_lang.pgp_books[position]
