/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Rule;
import be.re.css.Util;
import be.re.util.DigitalTree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public class Compiled {
    static final String ANY_ELEMENT = "*|*".intern();
    private static final int END_STATE = 1;
    private static final String EPSILON = "EPSILON".intern();
    private static final int ERROR_STATE = -1;
    static final String SIBLING = "SIBLING".intern();
    private static final int START_STATE = 0;
    private int dfaStateCounter = 0;
    private int nfaStateCounter = 0;
    private NFAState[] nfa = new NFAState[]{new NFAState(), new NFAState()};
    DFAState startState = null;
    private static final boolean trace = System.getProperty("be.re.css.trace") != null;

    void addRule(Rule rule) {
        NFAState[] states = this.constructNFA(rule.getSelector());
        if (rule.getPseudoElementName() == null) {
            states[1].rules.add(rule);
        } else {
            states[1].pseudoRules.add(rule);
        }
        this.nfa[0].next.add(new Next(EPSILON, states[0]));
        states[1].next.add(new Next(EPSILON, this.nfa[1]));
    }

    private static Map collectNextSets(SortedSet set) {
        HashMap<Object, TreeSet<NFAState>> result = new HashMap<Object, TreeSet<NFAState>>();
        Iterator<Object> i = set.iterator();
        while (i.hasNext()) {
            Iterator j = ((NFAState)i.next()).next.iterator();
            while (j.hasNext()) {
                Next next = (Next)j.next();
                if (next.event == EPSILON) continue;
                TreeSet<NFAState> nextSet = (TreeSet<NFAState>)result.get(next.event);
                if (nextSet == null) {
                    nextSet = new TreeSet<NFAState>(set.comparator());
                    result.put(next.event, nextSet);
                }
                nextSet.add(next.state);
            }
        }
        i = result.values().iterator();
        while (i.hasNext()) {
            TreeSet nextSet = (TreeSet)i.next();
            SortedSet copy = (SortedSet)nextSet.clone();
            Iterator j = copy.iterator();
            while (j.hasNext()) {
                Compiled.epsilonMove(nextSet, (NFAState)j.next());
            }
        }
        return result;
    }

    private static NFAState[] constructAnd(NFAState[] first, NFAState[] second) {
        first[1].next.add(new Next(EPSILON, second[0]));
        return new NFAState[]{first[0], second[1]};
    }

    private NFAState[] constructChild(DescendantSelector selector) {
        return selector.getSimpleSelector().getSelectorType() == 9 ? this.constructNFA(selector.getAncestorSelector()) : Compiled.constructAnd(this.constructNFA(selector.getAncestorSelector()), this.constructNFA(selector.getSimpleSelector()));
    }

    private NFAState[] constructConditional(ConditionalSelector selector) {
        NFAState[] first = this.constructNFA(selector.getSimpleSelector());
        NFAState end = new NFAState();
        first[1].condition = selector.getCondition();
        first[1].next.add(new Next(selector.getCondition(), end));
        return new NFAState[]{first[0], end};
    }

    private NFAState[] constructDescendant(DescendantSelector selector) {
        return Compiled.constructAnd(Compiled.constructAnd(this.constructNFA(selector.getAncestorSelector()), this.constructKleeneClosure(ANY_ELEMENT)), this.constructNFA(selector.getSimpleSelector()));
    }

    private NFAState[] constructElement(ElementSelector selector) {
        NFAState start = new NFAState();
        NFAState end = new NFAState();
        start.next.add(new Next(((selector.getNamespaceURI() != null ? selector.getNamespaceURI() : "*") + "|" + (selector.getLocalName() != null ? selector.getLocalName().intern() : "*")).intern(), end));
        return new NFAState[]{start, end};
    }

    private NFAState[] constructKleeneClosure(Object event) {
        NFAState start = new NFAState();
        NFAState end = new NFAState();
        NFAState from = new NFAState();
        NFAState to = new NFAState();
        from.next.add(new Next(event, to));
        start.next.add(new Next(EPSILON, from));
        start.next.add(new Next(EPSILON, end));
        to.next.add(new Next(EPSILON, end));
        end.next.add(new Next(EPSILON, from));
        return new NFAState[]{start, end};
    }

    private NFAState[] constructNFA(Selector selector) {
        switch (selector.getSelectorType()) {
            case 0: {
                return this.constructConditional((ConditionalSelector)selector);
            }
            case 11: {
                return this.constructChild((DescendantSelector)selector);
            }
            case 10: {
                return this.constructDescendant((DescendantSelector)selector);
            }
            case 12: {
                return this.constructSibling((SiblingSelector)selector);
            }
            case 4: {
                return this.constructElement((ElementSelector)selector);
            }
        }
        return null;
    }

    private NFAState[] constructSibling(SiblingSelector selector) {
        return Compiled.constructAnd(Compiled.constructAnd(this.constructNFA(selector.getSelector()), this.constructSiblingTransition()), this.constructNFA(selector.getSiblingSelector()));
    }

    private NFAState[] constructSiblingTransition() {
        NFAState start = new NFAState();
        NFAState end = new NFAState();
        start.next.add(new Next(SIBLING, end));
        return new NFAState[]{start, end};
    }

    void dumpDFA(PrintWriter out) {
        if (trace) {
            out.println();
            out.println("DFA START");
            out.println();
            Compiled.dumpDFA(this.startState, new HashSet(), out);
            out.println("DFA END");
            out.println();
            out.flush();
        }
    }

    private static void dumpDFA(DFAState state, Set seen, PrintWriter out) {
        DFAState nextState;
        Object event;
        if (seen.contains(new Integer(state.state))) {
            return;
        }
        out.println(String.valueOf(state.state) + ":");
        ArrayList<DFAState> values = new ArrayList<DFAState>();
        Iterator<Object> i = state.events.keySet().iterator();
        while (i.hasNext()) {
            event = (String)i.next();
            nextState = (DFAState)state.events.get((String)event);
            out.println("  " + (String)event + " -> " + String.valueOf(nextState.state));
            values.add(nextState);
        }
        i = state.candidateConditions.keySet().iterator();
        while (i.hasNext()) {
            event = (Condition)i.next();
            nextState = (DFAState)state.candidateConditions.get(event);
            out.println("  " + Util.conditionText((Condition)event) + " -> " + String.valueOf(nextState.state));
            values.add(nextState);
        }
        Compiled.dumpRules(state.rules, out);
        Compiled.dumpRules(state.pseudoRules, out);
        out.println();
        seen.add(new Integer(state.state));
        i = values.iterator();
        while (i.hasNext()) {
            Compiled.dumpDFA((DFAState)i.next(), seen, out);
        }
    }

    void dumpNFA(PrintWriter out) {
        if (trace) {
            out.println();
            out.println("NFA START");
            out.println();
            Compiled.dumpNFA(this.nfa[0], new HashSet(), out);
            out.println("NFA END");
            out.println();
            out.flush();
        }
    }

    private static void dumpNFA(NFAState state, Set seen, PrintWriter out) {
        if (seen.contains(new Integer(state.state))) {
            return;
        }
        out.println(String.valueOf(state.state) + ":");
        Iterator i = state.next.iterator();
        while (i.hasNext()) {
            Next next = (Next)i.next();
            out.println("  " + (next.event instanceof Condition ? Util.conditionText((Condition)next.event) : next.event.toString()) + " -> " + String.valueOf(next.state.state));
        }
        Compiled.dumpRules(state.rules, out);
        Compiled.dumpRules(state.pseudoRules, out);
        out.println();
        seen.add(new Integer(state.state));
        i = state.next.iterator();
        while (i.hasNext()) {
            Compiled.dumpNFA(((Next)i.next()).state, seen, out);
        }
    }

    private static void dumpRules(List rules, PrintWriter out) {
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            out.println("  " + (rule.getElementName() != null ? rule.getElementName() : "") + (rule.getPseudoElementName() != null ? rule.getPseudoElementName() : "") + ": " + rule.getProperty().getName() + ": " + rule.getProperty().getValue());
        }
    }

    private static void epsilonMove(Set set, NFAState state) {
        Iterator i = state.next.iterator();
        while (i.hasNext()) {
            Next next = (Next)i.next();
            if (next.event != EPSILON || !set.add(next.state)) continue;
            Compiled.epsilonMove(set, next.state);
        }
    }

    void generateDFA() {
        this.dumpNFA(new PrintWriter(System.out));
        this.startState = this.generateDFA(this.nfa);
        this.dumpDFA(new PrintWriter(System.out));
    }

    private DFAState generateDFA(NFAState[] nfa) {
        TreeSet<NFAState> set = new TreeSet<NFAState>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((NFAState)o1).state - ((NFAState)o2).state;
            }
        });
        HashMap<String, DFAState> states = new HashMap<String, DFAState>();
        set.add(nfa[0]);
        Compiled.epsilonMove(set, nfa[0]);
        DFAState result = new DFAState();
        states.put(Compiled.label(set), result);
        this.generateTransitions(result, set, states);
        return result;
    }

    private void generateTransitions(DFAState from, SortedSet set, Map states) {
        Map nextSets = Compiled.collectNextSets(set);
        Iterator i = nextSets.keySet().iterator();
        while (i.hasNext()) {
            DFAState nextState;
            Object event = i.next();
            SortedSet nextSet = (SortedSet)nextSets.get(event);
            if (nextSet.size() <= 0) continue;
            String s = Compiled.label(nextSet);
            DFAState state = (DFAState)states.get(s);
            if (state == null) {
                nextState = new DFAState();
                states.put(s, nextState);
            } else {
                nextState = state;
            }
            if (event instanceof Condition) {
                from.candidateConditions.put(event, nextState);
            } else {
                from.events.put((String)event, nextState);
            }
            Iterator j = nextSet.iterator();
            while (j.hasNext()) {
                NFAState next = (NFAState)j.next();
                nextState.rules.addAll(next.rules);
                nextState.pseudoRules.addAll(next.pseudoRules);
            }
            if (state != null) continue;
            this.generateTransitions(nextState, nextSet, states);
        }
    }

    private static String label(SortedSet set) {
        String result = "";
        Iterator i = set.iterator();
        while (i.hasNext()) {
            result = result + "#" + String.valueOf(((NFAState)i.next()).state);
        }
        return result;
    }

    static /* synthetic */ boolean access$1000() {
        return trace;
    }

    private class NFAState {
        private Condition condition;
        private List next = new ArrayList();
        private List pseudoRules = new ArrayList();
        private List rules = new ArrayList();
        private int state;

        private NFAState() {
            this.state = Compiled.this.nfaStateCounter++;
        }
    }

    private static class Next {
        private Object event;
        private NFAState state;

        private Next(Object event, NFAState state) {
            this.event = event;
            this.state = state;
        }
    }

    class DFAState {
        Map candidateConditions = new HashMap();
        DigitalTree events = new DigitalTree(Compiled.access$1000());
        List pseudoRules = new ArrayList();
        List rules = new ArrayList();
        int state;

        private DFAState() {
            this.state = Compiled.this.dfaStateCounter++;
        }
    }
}

