# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Avatar(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, type=None, url=None, token=None, display_name=None, id=None, content_type=None, filename=None, size=None):
        """
        Avatar - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'url': 'str',
            'token': 'str',
            'display_name': 'str',
            'id': 'int',
            'content_type': 'str',
            'filename': 'str',
            'size': 'int'
        }

        self.attribute_map = {
            'type': 'type',
            'url': 'url',
            'token': 'token',
            'display_name': 'display_name',
            'id': 'id',
            'content_type': 'content-type',
            'filename': 'filename',
            'size': 'size'
        }

        self._type = type
        self._url = url
        self._token = token
        self._display_name = display_name
        self._id = id
        self._content_type = content_type
        self._filename = filename
        self._size = size

    @property
    def type(self):
        """
        Gets the type of this Avatar.
        ['gravatar'|'attachment'|'no_pic'] The type of avatar record, for categorization purposes.

        :return: The type of this Avatar.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Avatar.
        ['gravatar'|'attachment'|'no_pic'] The type of avatar record, for categorization purposes.

        :param type: The type of this Avatar.
        :type: str
        """

        self._type = type

    @property
    def url(self):
        """
        Gets the url of this Avatar.
        The url of the avatar

        :return: The url of this Avatar.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Avatar.
        The url of the avatar

        :param url: The url of this Avatar.
        :type: str
        """

        self._url = url

    @property
    def token(self):
        """
        Gets the token of this Avatar.
        A unique representation of the avatar record which can be used to set the avatar with the user update endpoint. Note: this is an internal representation and is subject to change without notice. It should be consumed with this api endpoint and used in the user update endpoint, and should not be constructed by the client.

        :return: The token of this Avatar.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this Avatar.
        A unique representation of the avatar record which can be used to set the avatar with the user update endpoint. Note: this is an internal representation and is subject to change without notice. It should be consumed with this api endpoint and used in the user update endpoint, and should not be constructed by the client.

        :param token: The token of this Avatar.
        :type: str
        """

        self._token = token

    @property
    def display_name(self):
        """
        Gets the display_name of this Avatar.
        A textual description of the avatar record.

        :return: The display_name of this Avatar.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Avatar.
        A textual description of the avatar record.

        :param display_name: The display_name of this Avatar.
        :type: str
        """

        self._display_name = display_name

    @property
    def id(self):
        """
        Gets the id of this Avatar.
        ['attachment' type only] the internal id of the attachment

        :return: The id of this Avatar.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Avatar.
        ['attachment' type only] the internal id of the attachment

        :param id: The id of this Avatar.
        :type: int
        """

        self._id = id

    @property
    def content_type(self):
        """
        Gets the content_type of this Avatar.
        ['attachment' type only] the content-type of the attachment.

        :return: The content_type of this Avatar.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this Avatar.
        ['attachment' type only] the content-type of the attachment.

        :param content_type: The content_type of this Avatar.
        :type: str
        """

        self._content_type = content_type

    @property
    def filename(self):
        """
        Gets the filename of this Avatar.
        ['attachment' type only] the filename of the attachment

        :return: The filename of this Avatar.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """
        Sets the filename of this Avatar.
        ['attachment' type only] the filename of the attachment

        :param filename: The filename of this Avatar.
        :type: str
        """

        self._filename = filename

    @property
    def size(self):
        """
        Gets the size of this Avatar.
        ['attachment' type only] the size of the attachment

        :return: The size of this Avatar.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this Avatar.
        ['attachment' type only] the size of the attachment

        :param size: The size of this Avatar.
        :type: int
        """

        self._size = size

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
