# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class UsersApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: activity_stream_summary
    def activity_stream_summary(self, **kwargs):
        """
        Activity stream summary
        Returns a summary of the current user's global activity stream.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.activity_stream_summary_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activity_stream_summary" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/self/activity_stream/summary'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_user
    def create_user(self, account_id, pseudonym_unique_id, **kwargs):
        """
        Create a user
        Create and return a new user and pseudonym for an account.  If you don't have the \"Modify login details for users\" permission, but self-registration is enabled on the account, you can still use this endpoint to register new users. Certain fields will be required, and others will be ignored (see below).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_user_with_http_info(account_id, pseudonym_unique_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str pseudonym_unique_id: User's login ID. If this is a self-registration, it must be a valid email address. (required)
        :param str user_name: The full name of the user. This name will be used by teacher for grading. Required if this is a self-registration.
        :param str user_short_name: User's name as it will be displayed in discussions, messages, and comments.
        :param str user_sortable_name: User's name as used to sort alphabetically in lists.
        :param str user_time_zone: The time zone for the user. Allowed time zones are {http://www.iana.org/time-zones IANA time zones} or friendlier {http://api.rubyonrails.org/classes/ActiveSupport/TimeZone.html Ruby on Rails time zones}.
        :param str user_locale: The user's preferred language as a two-letter ISO 639-1 code.
        :param Object user_birthdate: The user's birth date.
        :param bool user_terms_of_use: Whether the user accepts the terms of use. Required if this is a self-registration and this canvas instance requires users to accept the terms (on by default).
        :param str pseudonym_password: User's password. Cannot be set during self-registration.
        :param str pseudonym_sis_user_id: SIS ID for the user's account. To set this parameter, the caller must be able to manage SIS permissions.
        :param bool pseudonym_send_confirmation: Send user notification of account creation if true. Automatically set to true during self-registration.
        :param str communication_channel_type: The communication channel type, e.g. 'email' or 'sms'.
        :param str communication_channel_address: The communication channel address, e.g. the user's email address.
        :param bool communication_channel_confirmation_url: Only valid for account admins. If true, returns the new user account confirmation URL in the response.
        :param bool communication_channel_skip_confirmation: Only valid for site admins and account admins making requests; If true, the channel is automatically validated and no confirmation email or SMS is sent. Otherwise, the user must respond to a confirmation message to confirm the channel.
        :param bool force_validations: If true, validations are performed on the newly created user (and their associated pseudonym) even if the request is made by a privileged user like an admin. When set to false, or not included in the request parameters, any newly created users are subject to validations unless the request is made by a user with a 'manage_user_logins' right. In which case, certain validations such as 'require_acceptance_of_terms' and 'require_presence_of_name' are not enforced. Use this parameter to return helpful json errors while building users with an admin request.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'pseudonym_unique_id', 'user_name', 'user_short_name', 'user_sortable_name', 'user_time_zone', 'user_locale', 'user_birthdate', 'user_terms_of_use', 'pseudonym_password', 'pseudonym_sis_user_id', 'pseudonym_send_confirmation', 'communication_channel_type', 'communication_channel_address', 'communication_channel_confirmation_url', 'communication_channel_skip_confirmation', 'force_validations']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_user`")
        # verify the required parameter 'pseudonym_unique_id' is set
        if ('pseudonym_unique_id' not in params) or (params['pseudonym_unique_id'] is None):
            raise ValueError("Missing the required parameter `pseudonym_unique_id` when calling `create_user`")

        resource_path = '/v1/accounts/{account_id}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'user_name' in params:
            form_params.append(('user[name]', params['user_name']))
        if 'user_short_name' in params:
            form_params.append(('user[short_name]', params['user_short_name']))
        if 'user_sortable_name' in params:
            form_params.append(('user[sortable_name]', params['user_sortable_name']))
        if 'user_time_zone' in params:
            form_params.append(('user[time_zone]', params['user_time_zone']))
        if 'user_locale' in params:
            form_params.append(('user[locale]', params['user_locale']))
        if 'user_birthdate' in params:
            form_params.append(('user[birthdate]', params['user_birthdate']))
        if 'user_terms_of_use' in params:
            form_params.append(('user[terms_of_use]', params['user_terms_of_use']))
        if 'pseudonym_unique_id' in params:
            form_params.append(('pseudonym[unique_id]', params['pseudonym_unique_id']))
        if 'pseudonym_password' in params:
            form_params.append(('pseudonym[password]', params['pseudonym_password']))
        if 'pseudonym_sis_user_id' in params:
            form_params.append(('pseudonym[sis_user_id]', params['pseudonym_sis_user_id']))
        if 'pseudonym_send_confirmation' in params:
            form_params.append(('pseudonym[send_confirmation]', params['pseudonym_send_confirmation']))
        if 'communication_channel_type' in params:
            form_params.append(('communication_channel[type]', params['communication_channel_type']))
        if 'communication_channel_address' in params:
            form_params.append(('communication_channel[address]', params['communication_channel_address']))
        if 'communication_channel_confirmation_url' in params:
            form_params.append(('communication_channel[confirmation_url]', params['communication_channel_confirmation_url']))
        if 'communication_channel_skip_confirmation' in params:
            form_params.append(('communication_channel[skip_confirmation]', params['communication_channel_skip_confirmation']))
        if 'force_validations' in params:
            form_params.append(('force_validations', params['force_validations']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_custom_data
    def delete_custom_data(self, user_id, ns, **kwargs):
        """
        Delete custom data
        Delete custom user data.  Arbitrary JSON data can be stored for a User.  This API call deletes that data for a given scope.  Without a scope, all custom_data is deleted. See {api:UsersController#set_custom_data Store Custom Data} for details and examples of storage and retrieval.  As an example, we'll store some data, then delete a subset of it.  Example {api:UsersController#set_custom_data PUT} with valid JSON data:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data' \\     -X PUT \\     -F 'ns=com.my-organization.canvas-app' \\     -F 'data[fruit][apple]=so tasty' \\     -F 'data[fruit][kiwi]=a bit sour' \\     -F 'data[veggies][root][onion]=tear-jerking' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": {       \"fruit\": {         \"apple\": \"so tasty\",         \"kiwi\": \"a bit sour\"       },       \"veggies\": {         \"root\": {           \"onion\": \"tear-jerking\"         }       }     }   }  Example DELETE:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/fruit/kiwi' \\     -X DELETE \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": \"a bit sour\"   }  Example {api:UsersController#get_custom_data GET} following the above DELETE:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data' \\     -X GET \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": {       \"fruit\": {         \"apple\": \"so tasty\"       },       \"veggies\": {         \"root\": {           \"onion\": \"tear-jerking\"         }       }     }   }  Note that hashes left empty after a DELETE will get removed from the custom_data store. For example, following the previous commands, if we delete /custom_data/veggies/root/onion, then the entire /custom_data/veggies scope will be removed.  Example DELETE that empties a parent scope:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/veggies/root/onion' \\     -X DELETE \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": \"tear-jerking\"   }  Example {api:UsersController#get_custom_data GET} following the above DELETE:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data' \\     -X GET \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": {       \"fruit\": {         \"apple\": \"so tasty\"       }     }   }  On success, this endpoint returns an object containing the data that was deleted.  Responds with status code 400 if the namespace parameter, +ns+, is missing or invalid, or if the specified scope does not contain any data.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_data_with_http_info(user_id, ns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str ns: The namespace from which to delete the data. This should be something other Canvas API apps aren't likely to use, such as a reverse DNS for your organization. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'ns']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_custom_data`")
        # verify the required parameter 'ns' is set
        if ('ns' not in params) or (params['ns'] is None):
            raise ValueError("Missing the required parameter `ns` when calling `delete_custom_data`")

        resource_path = '/v1/users/{user_id}/custom_data'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'ns' in params:
            query_params['ns'] = params['ns']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: edit_user
    def edit_user(self, id, **kwargs):
        """
        Edit a user
        Modify an existing user. To modify a user's login, see the documentation for logins.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_user_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str user_name: The full name of the user. This name will be used by teacher for grading.
        :param str user_short_name: User's name as it will be displayed in discussions, messages, and comments.
        :param str user_sortable_name: User's name as used to sort alphabetically in lists.
        :param str user_time_zone: The time zone for the user. Allowed time zones are {http://www.iana.org/time-zones IANA time zones} or friendlier {http://api.rubyonrails.org/classes/ActiveSupport/TimeZone.html Ruby on Rails time zones}.
        :param str user_locale: The user's preferred language as a two-letter ISO 639-1 code.
        :param str user_avatar_token: A unique representation of the avatar record to assign as the user's current avatar. This token can be obtained from the user avatars endpoint. This supersedes the user [avatar] [url] argument, and if both are included the url will be ignored. Note: this is an internal representation and is subject to change without notice. It should be consumed with this api endpoint and used in the user update endpoint, and should not be constructed by the client.
        :param str user_avatar_url: To set the user's avatar to point to an external url, do not include a token and instead pass the url here. Warning: For maximum compatibility, please use 128 px square images.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'user_name', 'user_short_name', 'user_sortable_name', 'user_time_zone', 'user_locale', 'user_avatar_token', 'user_avatar_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `edit_user`")

        resource_path = '/v1/users/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'user_name' in params:
            form_params.append(('user[name]', params['user_name']))
        if 'user_short_name' in params:
            form_params.append(('user[short_name]', params['user_short_name']))
        if 'user_sortable_name' in params:
            form_params.append(('user[sortable_name]', params['user_sortable_name']))
        if 'user_time_zone' in params:
            form_params.append(('user[time_zone]', params['user_time_zone']))
        if 'user_locale' in params:
            form_params.append(('user[locale]', params['user_locale']))
        if 'user_avatar_token' in params:
            form_params.append(('user[avatar][token]', params['user_avatar_token']))
        if 'user_avatar_url' in params:
            form_params.append(('user[avatar][url]', params['user_avatar_url']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_user_profile
    def get_user_profile(self, user_id, **kwargs):
        """
        Get user profile
        Returns user profile data, including user id, name, and profile pic.  When requesting the profile for the user accessing the API, the user's calendar feed URL will be returned as well.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_profile_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :return: Profile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_profile`")

        resource_path = '/v1/users/{user_id}/profile'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Profile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: hide_all_stream_items
    def hide_all_stream_items(self, **kwargs):
        """
        Hide all stream items
        Hide all stream items for the user

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hide_all_stream_items_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hide_all_stream_items" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/self/activity_stream'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: hide_stream_item
    def hide_stream_item(self, id, **kwargs):
        """
        Hide a stream item
        Hide the given stream item.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hide_stream_item_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hide_stream_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `hide_stream_item`")

        resource_path = '/v1/users/self/activity_stream/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_activity_stream_activity_stream
    def list_activity_stream_activity_stream(self, **kwargs):
        """
        List the activity stream
        Returns the current user's global activity stream, paginated.  There are many types of objects that can be returned in the activity stream. All object types have the same basic set of shared attributes:   !!!javascript   {     'created_at': '2011-07-13T09:12:00Z',     'updated_at': '2011-07-25T08:52:41Z',     'id': 1234,     'title': 'Stream Item Subject',     'message': 'This is the body text of the activity stream item. It is plain-text, and can be multiple paragraphs.',     'type': 'DiscussionTopic|Conversation|Message|Submission|Conference|Collaboration|AssessmentRequest...',     'read_state': false,     'context_type': 'course', // course|group     'course_id': 1,     'group_id': null,     'html_url': \"http://...\" // URL to the Canvas web UI for this stream item   }  In addition, each item type has its own set of attributes available.  DiscussionTopic:    !!!javascript   {     'type': 'DiscussionTopic',     'discussion_topic_id': 1234,     'total_root_discussion_entries': 5,     'require_initial_post': true,     'user_has_posted': true,     'root_discussion_entries': {       ...     }   }  For DiscussionTopic, the message is truncated at 4kb.  Announcement:    !!!javascript   {     'type': 'Announcement',     'announcement_id': 1234,     'total_root_discussion_entries': 5,     'require_initial_post': true,     'user_has_posted': null,     'root_discussion_entries': {       ...     }   }  For Announcement, the message is truncated at 4kb.  Conversation:    !!!javascript   {     'type': 'Conversation',     'conversation_id': 1234,     'private': false,     'participant_count': 3,   }  Message:    !!!javascript   {     'type': 'Message',     'message_id': 1234,     'notification_category': 'Assignment Graded'   }  Submission:  Returns an {api:Submissions:Submission Submission} with its Course and Assignment data.  Conference:    !!!javascript   {     'type': 'Conference',     'web_conference_id': 1234   }  Collaboration:    !!!javascript   {     'type': 'Collaboration',     'collaboration_id': 1234   }  AssessmentRequest:    !!!javascript   {     'type': 'AssessmentRequest',     'assessment_request_id': 1234   }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_activity_stream_activity_stream_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_activity_stream_activity_stream" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/activity_stream'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_activity_stream_self
    def list_activity_stream_self(self, **kwargs):
        """
        List the activity stream
        Returns the current user's global activity stream, paginated.  There are many types of objects that can be returned in the activity stream. All object types have the same basic set of shared attributes:   !!!javascript   {     'created_at': '2011-07-13T09:12:00Z',     'updated_at': '2011-07-25T08:52:41Z',     'id': 1234,     'title': 'Stream Item Subject',     'message': 'This is the body text of the activity stream item. It is plain-text, and can be multiple paragraphs.',     'type': 'DiscussionTopic|Conversation|Message|Submission|Conference|Collaboration|AssessmentRequest...',     'read_state': false,     'context_type': 'course', // course|group     'course_id': 1,     'group_id': null,     'html_url': \"http://...\" // URL to the Canvas web UI for this stream item   }  In addition, each item type has its own set of attributes available.  DiscussionTopic:    !!!javascript   {     'type': 'DiscussionTopic',     'discussion_topic_id': 1234,     'total_root_discussion_entries': 5,     'require_initial_post': true,     'user_has_posted': true,     'root_discussion_entries': {       ...     }   }  For DiscussionTopic, the message is truncated at 4kb.  Announcement:    !!!javascript   {     'type': 'Announcement',     'announcement_id': 1234,     'total_root_discussion_entries': 5,     'require_initial_post': true,     'user_has_posted': null,     'root_discussion_entries': {       ...     }   }  For Announcement, the message is truncated at 4kb.  Conversation:    !!!javascript   {     'type': 'Conversation',     'conversation_id': 1234,     'private': false,     'participant_count': 3,   }  Message:    !!!javascript   {     'type': 'Message',     'message_id': 1234,     'notification_category': 'Assignment Graded'   }  Submission:  Returns an {api:Submissions:Submission Submission} with its Course and Assignment data.  Conference:    !!!javascript   {     'type': 'Conference',     'web_conference_id': 1234   }  Collaboration:    !!!javascript   {     'type': 'Collaboration',     'collaboration_id': 1234   }  AssessmentRequest:    !!!javascript   {     'type': 'AssessmentRequest',     'assessment_request_id': 1234   }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_activity_stream_self_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_activity_stream_self" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/self/activity_stream'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_avatar_options
    def list_avatar_options(self, user_id, **kwargs):
        """
        List avatar options
        Retrieve the possible user avatar options that can be set with the user update endpoint. The response will be an array of avatar records. If the 'type' field is 'attachment', the record will include all the normal attachment json fields; otherwise it will include only the 'url' and 'display_name' fields. Additionally, all records will include a 'type' field and a 'token' field. The following explains each field in more detail type:: [\"gravatar\"|\"attachment\"|\"no_pic\"] The type of avatar record, for categorization purposes. url:: The url of the avatar token:: A unique representation of the avatar record which can be used to set the avatar with the user update endpoint. Note: this is an internal representation and is subject to change without notice. It should be consumed with this api endpoint and used in the user update endpoint, and should not be constructed by the client. display_name:: A textual description of the avatar record id:: ['attachment' type only] the internal id of the attachment content-type:: ['attachment' type only] the content-type of the attachment filename:: ['attachment' type only] the filename of the attachment size:: ['attachment' type only] the size of the attachment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_avatar_options_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :return: list[Avatar]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_avatar_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_avatar_options`")

        resource_path = '/v1/users/{user_id}/avatars'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Avatar]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_todo_items
    def list_todo_items(self, **kwargs):
        """
        List the TODO items
        Returns the current user's list of todo items, as seen on the user dashboard.  There is a limit to the number of items returned.  The `ignore` and `ignore_permanently` URLs can be used to update the user's preferences on what items will be displayed. Performing a DELETE request against the `ignore` URL will hide that item from future todo item requests, until the item changes. Performing a DELETE request against the `ignore_permanently` URL will hide that item forever.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_todo_items_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_todo_items" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/self/todo'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_upcoming_assignments_calendar_events
    def list_upcoming_assignments_calendar_events(self, **kwargs):
        """
        List upcoming assignments, calendar events
        Returns the current user's upcoming events, i.e. the same things shown in the dashboard 'Coming Up' sidebar.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_upcoming_assignments_calendar_events_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_upcoming_assignments_calendar_events" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/users/self/upcoming_events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_user_page_views
    def list_user_page_views(self, user_id, **kwargs):
        """
        List user page views
        Return the user's page view history in json format, similar to the available CSV download. Pagination is used as described in API basics section. Page views are returned in descending order, newest to oldest.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_user_page_views_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param Object start_time: The beginning of the time range from which you want page views.
        :param Object end_time: The end of the time range from which you want page views.
        :return: list[PageView]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'start_time', 'end_time']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_user_page_views" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_user_page_views`")

        resource_path = '/v1/users/{user_id}/page_views'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'start_time' in params:
            query_params['start_time'] = params['start_time']
        if 'end_time' in params:
            query_params['end_time'] = params['end_time']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[PageView]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_users_in_account
    def list_users_in_account(self, account_id, **kwargs):
        """
        List users in account
        Retrieve the list of users associated with this account.   @example_request    curl https://<canvas>/api/v1/accounts/self/users?search_term=<sis_user_id> \\       -X GET \\       -H 'Authorization: Bearer <token>'

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_users_in_account_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str search_term: The partial name or full ID of the users to match and return in the results list. Must be at least 3 characters.
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'search_term']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_in_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_users_in_account`")

        resource_path = '/v1/accounts/{account_id}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: load_custom_data
    def load_custom_data(self, user_id, ns, **kwargs):
        """
        Load custom data
        Load custom user data.  Arbitrary JSON data can be stored for a User.  This API call retrieves that data for a (optional) given scope. See {api:UsersController#set_custom_data Store Custom Data} for details and examples.  On success, this endpoint returns an object containing the data that was requested.  Responds with status code 400 if the namespace parameter, +ns+, is missing or invalid, or if the specified scope does not contain any data.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.load_custom_data_with_http_info(user_id, ns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str ns: The namespace from which to retrieve the data. This should be something other Canvas API apps aren't likely to use, such as a reverse DNS for your organization. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'ns']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method load_custom_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `load_custom_data`")
        # verify the required parameter 'ns' is set
        if ('ns' not in params) or (params['ns'] is None):
            raise ValueError("Missing the required parameter `ns` when calling `load_custom_data`")

        resource_path = '/v1/users/{user_id}/custom_data'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'ns' in params:
            query_params['ns'] = params['ns']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: merge_user_into_another_user_accounts
    def merge_user_into_another_user_accounts(self, id, destination_account_id, destination_user_id, **kwargs):
        """
        Merge user into another user
        Merge a user into another user. To merge users, the caller must have permissions to manage both users.  When finding users by SIS ids in different accounts the destination_account_id is required.  The account can also be identified by passing the domain in destination_account_id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.merge_user_into_another_user_accounts_with_http_info(id, destination_account_id, destination_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str destination_account_id: ID (required)
        :param str destination_user_id: ID (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'destination_account_id', 'destination_user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_user_into_another_user_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `merge_user_into_another_user_accounts`")
        # verify the required parameter 'destination_account_id' is set
        if ('destination_account_id' not in params) or (params['destination_account_id'] is None):
            raise ValueError("Missing the required parameter `destination_account_id` when calling `merge_user_into_another_user_accounts`")
        # verify the required parameter 'destination_user_id' is set
        if ('destination_user_id' not in params) or (params['destination_user_id'] is None):
            raise ValueError("Missing the required parameter `destination_user_id` when calling `merge_user_into_another_user_accounts`")

        resource_path = '/v1/users/{id}/merge_into/accounts/{destination_account_id}/users/{destination_user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'destination_account_id' in params:
            path_params['destination_account_id'] = params['destination_account_id']
        if 'destination_user_id' in params:
            path_params['destination_user_id'] = params['destination_user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: merge_user_into_another_user_destination_user_id
    def merge_user_into_another_user_destination_user_id(self, id, destination_user_id, **kwargs):
        """
        Merge user into another user
        Merge a user into another user. To merge users, the caller must have permissions to manage both users.  When finding users by SIS ids in different accounts the destination_account_id is required.  The account can also be identified by passing the domain in destination_account_id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.merge_user_into_another_user_destination_user_id_with_http_info(id, destination_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str destination_user_id: ID (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'destination_user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_user_into_another_user_destination_user_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `merge_user_into_another_user_destination_user_id`")
        # verify the required parameter 'destination_user_id' is set
        if ('destination_user_id' not in params) or (params['destination_user_id'] is None):
            raise ValueError("Missing the required parameter `destination_user_id` when calling `merge_user_into_another_user_destination_user_id`")

        resource_path = '/v1/users/{id}/merge_into/{destination_user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'destination_user_id' in params:
            path_params['destination_user_id'] = params['destination_user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_user_details
    def show_user_details(self, id, **kwargs):
        """
        Show user details
        Shows details for user.  Also includes an attribute \"permissions\", a non-comprehensive list of permissions for the user. Example:   !!!javascript   \"permissions\": {    \"can_update_name\": true, // Whether the user can update their name.    \"can_update_avatar\": false // Whether the user can update their avatar.   }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_user_details_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_user_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_user_details`")

        resource_path = '/v1/users/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: store_custom_data
    def store_custom_data(self, user_id, ns, data, **kwargs):
        """
        Store custom data
        Store arbitrary user data as JSON.  Arbitrary JSON data can be stored for a User. A typical scenario would be an external site/service that registers users in Canvas and wants to capture additional info about them.  The part of the URL that follows +/custom_data/+ defines the scope of the request, and it reflects the structure of the JSON data to be stored or retrieved.  A namespace parameter, +ns+, is used to prevent custom_data collisions between different apps.  This parameter is required for all custom_data requests.  A request with Content-Type multipart/form-data or Content-Type application/x-www-form-urlencoded can only be used to store strings.  Example PUT with multipart/form-data data:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/telephone' \\     -X PUT \\     -F 'ns=com.my-organization.canvas-app' \\     -F 'data=555-1234' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": \"555-1234\"   }  Subscopes (or, generated scopes) can also be specified by passing values to data[<subscope>].  Example PUT specifying subscopes:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/body/measurements' \\     -X PUT \\     -F 'ns=com.my-organization.canvas-app' \\     -F 'data[waist]=32in' \\     -F 'data[inseam]=34in' \\     -F 'data[chest]=40in' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": {       \"chest\": \"40in\",       \"waist\": \"32in\",       \"inseam\": \"34in\"     }   }  Following such a request, subsets of the stored data to be retrieved directly from a subscope.  Example {api:UsersController#get_custom_data GET} from a generated scope   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/body/measurements/chest' \\     -X GET \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": \"40in\"   }  If you want to store more than just strings (i.e. numbers, arrays, hashes, true, false, and/or null), you must make a request with Content-Type application/json as in the following example.  Example PUT with JSON data:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data' \\     -H 'Content-Type: application/json' \\     -X PUT \\     -d '{           \"ns\": \"com.my-organization.canvas-app\",           \"data\": {             \"a-number\": 6.02e23,             \"a-bool\": true,             \"a-string\": \"true\",             \"a-hash\": {\"a\": {\"b\": \"ohai\"}},             \"an-array\": [1, \"two\", null, false]           }         }' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": {       \"a-number\": 6.02e+23,       \"a-bool\": true,       \"a-string\": \"true\",       \"a-hash\": {         \"a\": {           \"b\": \"ohai\"         }       },       \"an-array\": [1, \"two\", null, false]     }   }  If the data is an Object (as it is in the above example), then subsets of the data can be accessed by including the object's (possibly nested) keys in the scope of a GET request.  Example {api:UsersController#get_custom_data GET} with a generated scope:   curl 'https://<canvas>/api/v1/users/<user_id>/custom_data/a-hash/a/b' \\     -X GET \\     -F 'ns=com.my-organization.canvas-app' \\     -H 'Authorization: Bearer <token>'  Response:   !!!javascript   {     \"data\": \"ohai\"   }   On success, this endpoint returns an object containing the data that was stored.  Responds with status code 200 if the scope already contained data, and it was overwritten by the data specified in the request.  Responds with status code 201 if the scope was previously empty, and the data specified in the request was successfully stored there.  Responds with status code 400 if the namespace parameter, +ns+, is missing or invalid, or if the +data+ parameter is missing.  Responds with status code 409 if the requested scope caused a conflict and data was not stored. This happens when storing data at the requested scope would cause data at an outer scope to be lost.  e.g., if +/custom_data+ was +{\"fashion_app\": {\"hair\": \"blonde\"}}+, but you tried to +`PUT /custom_data/fashion_app/hair/style -F data=buzz`+, then for the request to succeed,the value of +/custom_data/fashion_app/hair+ would have to become a hash, and its old string value would be lost.  In this situation, an error object is returned with the following format:    !!!javascript   {     \"message\": \"write conflict for custom_data hash\",     \"conflict_scope\": \"fashion_app/hair\",     \"type_at_conflict\": \"String\",     \"value_at_conflict\": \"blonde\"   }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.store_custom_data_with_http_info(user_id, ns, data, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str ns: The namespace under which to store the data. This should be something other Canvas API apps aren't likely to use, such as a reverse DNS for your organization. (required)
        :param Object data: The data you want to store for the user, at the specified scope. If the data is composed of (possibly nested) JSON objects, scopes will be generated for the (nested) keys (see examples). (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'ns', 'data']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method store_custom_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `store_custom_data`")
        # verify the required parameter 'ns' is set
        if ('ns' not in params) or (params['ns'] is None):
            raise ValueError("Missing the required parameter `ns` when calling `store_custom_data`")
        # verify the required parameter 'data' is set
        if ('data' not in params) or (params['data'] is None):
            raise ValueError("Missing the required parameter `data` when calling `store_custom_data`")

        resource_path = '/v1/users/{user_id}/custom_data'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'ns' in params:
            form_params.append(('ns', params['ns']))
        if 'data' in params:
            form_params.append(('data', params['data']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_user_settings
    def update_user_settings(self, id, **kwargs):
        """
        Update user settings.
        Update an existing user's settings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_settings_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param bool manual_mark_as_read: If true, require user to manually mark discussion posts as read (don't auto-mark as read).
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'manual_mark_as_read']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_user_settings`")

        resource_path = '/v1/users/{id}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'manual_mark_as_read' in params:
            query_params['manual_mark_as_read'] = params['manual_mark_as_read']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: upload_file
    def upload_file(self, user_id, **kwargs):
        """
        Upload a file
        Upload a file to the user's personal files section.  This API endpoint is the first step in uploading a file to a user's files. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.  Note that typically users will only be able to upload files to their own files section. Passing a user_id of +self+ is an easy shortcut to specify the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `upload_file`")

        resource_path = '/v1/users/{user_id}/files'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
