# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class SubmissionsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: get_single_submission_courses
    def get_single_submission_courses(self, course_id, assignment_id, user_id, **kwargs):
        """
        Get a single submission
        Get a single submission, based on user id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_submission_courses_with_http_info(course_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :param list[str] include: Associations to include with the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_submission_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_submission_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_single_submission_courses`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_single_submission_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_submission_sections
    def get_single_submission_sections(self, section_id, assignment_id, user_id, **kwargs):
        """
        Get a single submission
        Get a single submission, based on user id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_submission_sections_with_http_info(section_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :param list[str] include: Associations to include with the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'user_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_submission_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `get_single_submission_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_single_submission_sections`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_single_submission_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/{user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_multiple_submissions_courses_assignments
    def grade_or_comment_on_multiple_submissions_courses_assignments(self, course_id, assignment_id, **kwargs):
        """
        Grade or comment on multiple submissions
        Update the grading and comments on multiple student's assignment submissions in an asynchronous job.  The user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_multiple_submissions_courses_assignments_with_http_info(course_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str grade_data_student_id_posted_grade: See documentation for the posted_grade argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param Object grade_data_student_id_rubric_assessment: See documentation for the rubric_assessment argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param str grade_data_student_id_text_comment: no description
        :param bool grade_data_student_id_group_comment: no description
        :param str grade_data_student_id_media_comment_id: no description
        :param str grade_data_student_id_media_comment_type: no description
        :param list[int] grade_data_student_id_file_ids: See documentation for the comment[] arguments in the {api:SubmissionsApiController#update Submissions Update} documentation
        :return: Progress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'grade_data_student_id_posted_grade', 'grade_data_student_id_rubric_assessment', 'grade_data_student_id_text_comment', 'grade_data_student_id_group_comment', 'grade_data_student_id_media_comment_id', 'grade_data_student_id_media_comment_type', 'grade_data_student_id_file_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_multiple_submissions_courses_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `grade_or_comment_on_multiple_submissions_courses_assignments`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `grade_or_comment_on_multiple_submissions_courses_assignments`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/update_grades'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'grade_data_student_id_posted_grade' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][posted_grade]', params['grade_data_student_id_posted_grade']))
        if 'grade_data_student_id_rubric_assessment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][rubric_assessment]', params['grade_data_student_id_rubric_assessment']))
        if 'grade_data_student_id_text_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][text_comment]', params['grade_data_student_id_text_comment']))
        if 'grade_data_student_id_group_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][group_comment]', params['grade_data_student_id_group_comment']))
        if 'grade_data_student_id_media_comment_id' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_id]', params['grade_data_student_id_media_comment_id']))
        if 'grade_data_student_id_media_comment_type' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_type]', params['grade_data_student_id_media_comment_type']))
        if 'grade_data_student_id_file_ids' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][file_ids]', params['grade_data_student_id_file_ids']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Progress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_multiple_submissions_courses_submissions
    def grade_or_comment_on_multiple_submissions_courses_submissions(self, course_id, **kwargs):
        """
        Grade or comment on multiple submissions
        Update the grading and comments on multiple student's assignment submissions in an asynchronous job.  The user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_multiple_submissions_courses_submissions_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str grade_data_student_id_posted_grade: See documentation for the posted_grade argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param Object grade_data_student_id_rubric_assessment: See documentation for the rubric_assessment argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param str grade_data_student_id_text_comment: no description
        :param bool grade_data_student_id_group_comment: no description
        :param str grade_data_student_id_media_comment_id: no description
        :param str grade_data_student_id_media_comment_type: no description
        :param list[int] grade_data_student_id_file_ids: See documentation for the comment[] arguments in the {api:SubmissionsApiController#update Submissions Update} documentation
        :return: Progress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'grade_data_student_id_posted_grade', 'grade_data_student_id_rubric_assessment', 'grade_data_student_id_text_comment', 'grade_data_student_id_group_comment', 'grade_data_student_id_media_comment_id', 'grade_data_student_id_media_comment_type', 'grade_data_student_id_file_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_multiple_submissions_courses_submissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `grade_or_comment_on_multiple_submissions_courses_submissions`")

        resource_path = '/v1/courses/{course_id}/submissions/update_grades'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'grade_data_student_id_posted_grade' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][posted_grade]', params['grade_data_student_id_posted_grade']))
        if 'grade_data_student_id_rubric_assessment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][rubric_assessment]', params['grade_data_student_id_rubric_assessment']))
        if 'grade_data_student_id_text_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][text_comment]', params['grade_data_student_id_text_comment']))
        if 'grade_data_student_id_group_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][group_comment]', params['grade_data_student_id_group_comment']))
        if 'grade_data_student_id_media_comment_id' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_id]', params['grade_data_student_id_media_comment_id']))
        if 'grade_data_student_id_media_comment_type' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_type]', params['grade_data_student_id_media_comment_type']))
        if 'grade_data_student_id_file_ids' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][file_ids]', params['grade_data_student_id_file_ids']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Progress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_multiple_submissions_sections_assignments
    def grade_or_comment_on_multiple_submissions_sections_assignments(self, section_id, assignment_id, **kwargs):
        """
        Grade or comment on multiple submissions
        Update the grading and comments on multiple student's assignment submissions in an asynchronous job.  The user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_multiple_submissions_sections_assignments_with_http_info(section_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str grade_data_student_id_posted_grade: See documentation for the posted_grade argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param Object grade_data_student_id_rubric_assessment: See documentation for the rubric_assessment argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param str grade_data_student_id_text_comment: no description
        :param bool grade_data_student_id_group_comment: no description
        :param str grade_data_student_id_media_comment_id: no description
        :param str grade_data_student_id_media_comment_type: no description
        :param list[int] grade_data_student_id_file_ids: See documentation for the comment[] arguments in the {api:SubmissionsApiController#update Submissions Update} documentation
        :return: Progress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'grade_data_student_id_posted_grade', 'grade_data_student_id_rubric_assessment', 'grade_data_student_id_text_comment', 'grade_data_student_id_group_comment', 'grade_data_student_id_media_comment_id', 'grade_data_student_id_media_comment_type', 'grade_data_student_id_file_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_multiple_submissions_sections_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `grade_or_comment_on_multiple_submissions_sections_assignments`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `grade_or_comment_on_multiple_submissions_sections_assignments`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/update_grades'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'grade_data_student_id_posted_grade' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][posted_grade]', params['grade_data_student_id_posted_grade']))
        if 'grade_data_student_id_rubric_assessment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][rubric_assessment]', params['grade_data_student_id_rubric_assessment']))
        if 'grade_data_student_id_text_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][text_comment]', params['grade_data_student_id_text_comment']))
        if 'grade_data_student_id_group_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][group_comment]', params['grade_data_student_id_group_comment']))
        if 'grade_data_student_id_media_comment_id' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_id]', params['grade_data_student_id_media_comment_id']))
        if 'grade_data_student_id_media_comment_type' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_type]', params['grade_data_student_id_media_comment_type']))
        if 'grade_data_student_id_file_ids' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][file_ids]', params['grade_data_student_id_file_ids']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Progress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_multiple_submissions_sections_submissions
    def grade_or_comment_on_multiple_submissions_sections_submissions(self, section_id, **kwargs):
        """
        Grade or comment on multiple submissions
        Update the grading and comments on multiple student's assignment submissions in an asynchronous job.  The user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_multiple_submissions_sections_submissions_with_http_info(section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str grade_data_student_id_posted_grade: See documentation for the posted_grade argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param Object grade_data_student_id_rubric_assessment: See documentation for the rubric_assessment argument in the {api:SubmissionsApiController#update Submissions Update} documentation
        :param str grade_data_student_id_text_comment: no description
        :param bool grade_data_student_id_group_comment: no description
        :param str grade_data_student_id_media_comment_id: no description
        :param str grade_data_student_id_media_comment_type: no description
        :param list[int] grade_data_student_id_file_ids: See documentation for the comment[] arguments in the {api:SubmissionsApiController#update Submissions Update} documentation
        :return: Progress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'grade_data_student_id_posted_grade', 'grade_data_student_id_rubric_assessment', 'grade_data_student_id_text_comment', 'grade_data_student_id_group_comment', 'grade_data_student_id_media_comment_id', 'grade_data_student_id_media_comment_type', 'grade_data_student_id_file_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_multiple_submissions_sections_submissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `grade_or_comment_on_multiple_submissions_sections_submissions`")

        resource_path = '/v1/sections/{section_id}/submissions/update_grades'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'grade_data_student_id_posted_grade' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][posted_grade]', params['grade_data_student_id_posted_grade']))
        if 'grade_data_student_id_rubric_assessment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][rubric_assessment]', params['grade_data_student_id_rubric_assessment']))
        if 'grade_data_student_id_text_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][text_comment]', params['grade_data_student_id_text_comment']))
        if 'grade_data_student_id_group_comment' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][group_comment]', params['grade_data_student_id_group_comment']))
        if 'grade_data_student_id_media_comment_id' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_id]', params['grade_data_student_id_media_comment_id']))
        if 'grade_data_student_id_media_comment_type' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][media_comment_type]', params['grade_data_student_id_media_comment_type']))
        if 'grade_data_student_id_file_ids' in params:
            form_params.append(('grade_data[&lt;student_id&gt;][file_ids]', params['grade_data_student_id_file_ids']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Progress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_submission_courses
    def grade_or_comment_on_submission_courses(self, course_id, assignment_id, user_id, **kwargs):
        """
        Grade or comment on a submission
        Comment on and/or update the grading for a student's assignment submission. If any submission or rubric_assessment arguments are provided, the user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_submission_courses_with_http_info(course_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :param str comment_text_comment: Add a textual comment to the submission.
        :param bool comment_group_comment: Whether or not this comment should be sent to the entire group (defaults to false). Ignored if this is not a group assignment or if no text_comment is provided.
        :param str comment_media_comment_id: Add an audio/video comment to the submission. Media comments can be added via this API, however, note that there is not yet an API to generate or list existing media comments, so this functionality is currently of limited use.
        :param str comment_media_comment_type: The type of media comment being added.
        :param list[int] comment_file_ids: Attach files to this comment that were previously uploaded using the Submission Comment API's files action
        :param str include_visibility: Whether this assignment is visible to the owner of the submission
        :param str submission_posted_grade: Assign a score to the submission, updating both the \"score\" and \"grade\" fields on the submission record. This parameter can be passed in a few different formats:  points:: A floating point or integral value, such as \"13.5\". The grade   will be interpreted directly as the score of the assignment.   Values above assignment.points_possible are allowed, for awarding   extra credit. percentage:: A floating point value appended with a percent sign, such as    \"40%\". The grade will be interpreted as a percentage score on the    assignment, where 100% == assignment.points_possible. Values above 100%    are allowed, for awarding extra credit. letter grade:: A letter grade, following the assignment's defined letter    grading scheme. For example, \"A-\". The resulting score will be the high    end of the defined range for the letter grade. For instance, if \"B\" is    defined as 86% to 84%, a letter grade of \"B\" will be worth 86%. The    letter grade will be rejected if the assignment does not have a defined    letter grading scheme. For more fine-grained control of scores, pass in    points or percentage rather than the letter grade. \"pass/complete/fail/incomplete\":: A string value of \"pass\" or \"complete\"    will give a score of 100%. \"fail\" or \"incomplete\" will give a score of    0.  Note that assignments with grading_type of \"pass_fail\" can only be assigned a score of 0 or assignment.points_possible, nothing inbetween. If a posted_grade in the \"points\" or \"percentage\" format is sent, the grade will only be accepted if the grade equals one of those two values.
        :param bool submission_excuse: Sets the \"excused\" status of an assignment.
        :param Object rubric_assessment: Assign a rubric assessment to this assignment submission. The sub-parameters here depend on the rubric for the assignment. The general format is, for each row in the rubric:  The points awarded for this row.   rubric_assessment[criterion_id][points]  Comments to add for this row.   rubric_assessment[criterion_id][comments]  For example, if the assignment rubric is (in JSON format):   !!!javascript   [     {       'id': 'crit1',       'points': 10,       'description': 'Criterion 1',       'ratings':       [         { 'description': 'Good', 'points': 10 },         { 'description': 'Poor', 'points': 3 }       ]     },     {       'id': 'crit2',       'points': 5,       'description': 'Criterion 2',       'ratings':       [         { 'description': 'Complete', 'points': 5 },         { 'description': 'Incomplete', 'points': 0 }       ]     }   ]  Then a possible set of values for rubric_assessment would be:     rubric_assessment[crit1][points]=3&rubric_assessment[crit2][points]=5&rubric_assessment[crit2][comments]=Well%20Done.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id', 'comment_text_comment', 'comment_group_comment', 'comment_media_comment_id', 'comment_media_comment_type', 'comment_file_ids', 'include_visibility', 'submission_posted_grade', 'submission_excuse', 'rubric_assessment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_submission_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `grade_or_comment_on_submission_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `grade_or_comment_on_submission_courses`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `grade_or_comment_on_submission_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'comment_text_comment' in params:
            form_params.append(('comment[text_comment]', params['comment_text_comment']))
        if 'comment_group_comment' in params:
            form_params.append(('comment[group_comment]', params['comment_group_comment']))
        if 'comment_media_comment_id' in params:
            form_params.append(('comment[media_comment_id]', params['comment_media_comment_id']))
        if 'comment_media_comment_type' in params:
            form_params.append(('comment[media_comment_type]', params['comment_media_comment_type']))
        if 'comment_file_ids' in params:
            form_params.append(('comment[file_ids]', params['comment_file_ids']))
        if 'include_visibility' in params:
            form_params.append(('include[visibility]', params['include_visibility']))
        if 'submission_posted_grade' in params:
            form_params.append(('submission[posted_grade]', params['submission_posted_grade']))
        if 'submission_excuse' in params:
            form_params.append(('submission[excuse]', params['submission_excuse']))
        if 'rubric_assessment' in params:
            form_params.append(('rubric_assessment', params['rubric_assessment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: grade_or_comment_on_submission_sections
    def grade_or_comment_on_submission_sections(self, section_id, assignment_id, user_id, **kwargs):
        """
        Grade or comment on a submission
        Comment on and/or update the grading for a student's assignment submission. If any submission or rubric_assessment arguments are provided, the user must have permission to manage grades in the appropriate context (course or section).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.grade_or_comment_on_submission_sections_with_http_info(section_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :param str comment_text_comment: Add a textual comment to the submission.
        :param bool comment_group_comment: Whether or not this comment should be sent to the entire group (defaults to false). Ignored if this is not a group assignment or if no text_comment is provided.
        :param str comment_media_comment_id: Add an audio/video comment to the submission. Media comments can be added via this API, however, note that there is not yet an API to generate or list existing media comments, so this functionality is currently of limited use.
        :param str comment_media_comment_type: The type of media comment being added.
        :param list[int] comment_file_ids: Attach files to this comment that were previously uploaded using the Submission Comment API's files action
        :param str include_visibility: Whether this assignment is visible to the owner of the submission
        :param str submission_posted_grade: Assign a score to the submission, updating both the \"score\" and \"grade\" fields on the submission record. This parameter can be passed in a few different formats:  points:: A floating point or integral value, such as \"13.5\". The grade   will be interpreted directly as the score of the assignment.   Values above assignment.points_possible are allowed, for awarding   extra credit. percentage:: A floating point value appended with a percent sign, such as    \"40%\". The grade will be interpreted as a percentage score on the    assignment, where 100% == assignment.points_possible. Values above 100%    are allowed, for awarding extra credit. letter grade:: A letter grade, following the assignment's defined letter    grading scheme. For example, \"A-\". The resulting score will be the high    end of the defined range for the letter grade. For instance, if \"B\" is    defined as 86% to 84%, a letter grade of \"B\" will be worth 86%. The    letter grade will be rejected if the assignment does not have a defined    letter grading scheme. For more fine-grained control of scores, pass in    points or percentage rather than the letter grade. \"pass/complete/fail/incomplete\":: A string value of \"pass\" or \"complete\"    will give a score of 100%. \"fail\" or \"incomplete\" will give a score of    0.  Note that assignments with grading_type of \"pass_fail\" can only be assigned a score of 0 or assignment.points_possible, nothing inbetween. If a posted_grade in the \"points\" or \"percentage\" format is sent, the grade will only be accepted if the grade equals one of those two values.
        :param bool submission_excuse: Sets the \"excused\" status of an assignment.
        :param Object rubric_assessment: Assign a rubric assessment to this assignment submission. The sub-parameters here depend on the rubric for the assignment. The general format is, for each row in the rubric:  The points awarded for this row.   rubric_assessment[criterion_id][points]  Comments to add for this row.   rubric_assessment[criterion_id][comments]  For example, if the assignment rubric is (in JSON format):   !!!javascript   [     {       'id': 'crit1',       'points': 10,       'description': 'Criterion 1',       'ratings':       [         { 'description': 'Good', 'points': 10 },         { 'description': 'Poor', 'points': 3 }       ]     },     {       'id': 'crit2',       'points': 5,       'description': 'Criterion 2',       'ratings':       [         { 'description': 'Complete', 'points': 5 },         { 'description': 'Incomplete', 'points': 0 }       ]     }   ]  Then a possible set of values for rubric_assessment would be:     rubric_assessment[crit1][points]=3&rubric_assessment[crit2][points]=5&rubric_assessment[crit2][comments]=Well%20Done.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'user_id', 'comment_text_comment', 'comment_group_comment', 'comment_media_comment_id', 'comment_media_comment_type', 'comment_file_ids', 'include_visibility', 'submission_posted_grade', 'submission_excuse', 'rubric_assessment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grade_or_comment_on_submission_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `grade_or_comment_on_submission_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `grade_or_comment_on_submission_sections`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `grade_or_comment_on_submission_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/{user_id}'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'comment_text_comment' in params:
            form_params.append(('comment[text_comment]', params['comment_text_comment']))
        if 'comment_group_comment' in params:
            form_params.append(('comment[group_comment]', params['comment_group_comment']))
        if 'comment_media_comment_id' in params:
            form_params.append(('comment[media_comment_id]', params['comment_media_comment_id']))
        if 'comment_media_comment_type' in params:
            form_params.append(('comment[media_comment_type]', params['comment_media_comment_type']))
        if 'comment_file_ids' in params:
            form_params.append(('comment[file_ids]', params['comment_file_ids']))
        if 'include_visibility' in params:
            form_params.append(('include[visibility]', params['include_visibility']))
        if 'submission_posted_grade' in params:
            form_params.append(('submission[posted_grade]', params['submission_posted_grade']))
        if 'submission_excuse' in params:
            form_params.append(('submission[excuse]', params['submission_excuse']))
        if 'rubric_assessment' in params:
            form_params.append(('rubric_assessment', params['rubric_assessment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_assignment_submissions_courses
    def list_assignment_submissions_courses(self, course_id, assignment_id, **kwargs):
        """
        List assignment submissions
        Get all existing submissions for an assignment.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignment_submissions_courses_with_http_info(course_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param list[str] include: Associations to include with the group.  \"group\" will add group_id and group_name.
        :param bool grouped: If this argument is true, the response will be grouped by student groups.
        :return: list[Submission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'include', 'grouped']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignment_submissions_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_assignment_submissions_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `list_assignment_submissions_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'grouped' in params:
            query_params['grouped'] = params['grouped']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Submission]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_assignment_submissions_sections
    def list_assignment_submissions_sections(self, section_id, assignment_id, **kwargs):
        """
        List assignment submissions
        Get all existing submissions for an assignment.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignment_submissions_sections_with_http_info(section_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param list[str] include: Associations to include with the group.  \"group\" will add group_id and group_name.
        :param bool grouped: If this argument is true, the response will be grouped by student groups.
        :return: list[Submission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'include', 'grouped']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignment_submissions_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `list_assignment_submissions_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `list_assignment_submissions_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'grouped' in params:
            query_params['grouped'] = params['grouped']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Submission]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_gradeable_students
    def list_gradeable_students(self, course_id, assignment_id, **kwargs):
        """
        List gradeable students
        List students eligible to submit the assignment. The caller must have permission to view grades.  Section-limited instructors will only see students in their own sections.  returns [UserDisplay]

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_gradeable_students_with_http_info(course_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_gradeable_students" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_gradeable_students`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `list_gradeable_students`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/gradeable_students'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_submissions_for_multiple_assignments_courses
    def list_submissions_for_multiple_assignments_courses(self, course_id, **kwargs):
        """
        List submissions for multiple assignments
        Get all existing submissions for a given set of students and assignments.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_submissions_for_multiple_assignments_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param list[str] student_ids: List of student ids to return submissions for. If this argument is omitted, return submissions for the calling user. Students may only list their own submissions. Observers may only list those of associated students. The special id \"all\" will return submissions for all students in the course/section as appropriate.
        :param list[str] assignment_ids: List of assignments to return submissions for. If none are given, submissions for all assignments are returned.
        :param bool grouped: If this argument is present, the response will be grouped by student, rather than a flat array of submissions.
        :param int grading_period_id: The id of the grading period in which submissions are being requested (Requires the Multiple Grading Periods account feature turned on)
        :param list[str] include: Associations to include with the group. `total_scores` requires the `grouped` argument.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'student_ids', 'assignment_ids', 'grouped', 'grading_period_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_submissions_for_multiple_assignments_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_submissions_for_multiple_assignments_courses`")

        resource_path = '/v1/courses/{course_id}/students/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'student_ids' in params:
            query_params['student_ids'] = params['student_ids']
        if 'assignment_ids' in params:
            query_params['assignment_ids'] = params['assignment_ids']
        if 'grouped' in params:
            query_params['grouped'] = params['grouped']
        if 'grading_period_id' in params:
            query_params['grading_period_id'] = params['grading_period_id']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_submissions_for_multiple_assignments_sections
    def list_submissions_for_multiple_assignments_sections(self, section_id, **kwargs):
        """
        List submissions for multiple assignments
        Get all existing submissions for a given set of students and assignments.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_submissions_for_multiple_assignments_sections_with_http_info(section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param list[str] student_ids: List of student ids to return submissions for. If this argument is omitted, return submissions for the calling user. Students may only list their own submissions. Observers may only list those of associated students. The special id \"all\" will return submissions for all students in the course/section as appropriate.
        :param list[str] assignment_ids: List of assignments to return submissions for. If none are given, submissions for all assignments are returned.
        :param bool grouped: If this argument is present, the response will be grouped by student, rather than a flat array of submissions.
        :param int grading_period_id: The id of the grading period in which submissions are being requested (Requires the Multiple Grading Periods account feature turned on)
        :param list[str] include: Associations to include with the group. `total_scores` requires the `grouped` argument.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'student_ids', 'assignment_ids', 'grouped', 'grading_period_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_submissions_for_multiple_assignments_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `list_submissions_for_multiple_assignments_sections`")

        resource_path = '/v1/sections/{section_id}/students/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']

        query_params = {}
        if 'student_ids' in params:
            query_params['student_ids'] = params['student_ids']
        if 'assignment_ids' in params:
            query_params['assignment_ids'] = params['assignment_ids']
        if 'grouped' in params:
            query_params['grouped'] = params['grouped']
        if 'grading_period_id' in params:
            query_params['grading_period_id'] = params['grading_period_id']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_submission_as_read_courses
    def mark_submission_as_read_courses(self, course_id, assignment_id, user_id, **kwargs):
        """
        Mark submission as read
        No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_submission_as_read_courses_with_http_info(course_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_submission_as_read_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_submission_as_read_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `mark_submission_as_read_courses`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `mark_submission_as_read_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_submission_as_read_sections
    def mark_submission_as_read_sections(self, section_id, assignment_id, user_id, **kwargs):
        """
        Mark submission as read
        No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_submission_as_read_sections_with_http_info(section_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_submission_as_read_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `mark_submission_as_read_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `mark_submission_as_read_sections`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `mark_submission_as_read_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/{user_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_submission_as_unread_courses
    def mark_submission_as_unread_courses(self, course_id, assignment_id, user_id, **kwargs):
        """
        Mark submission as unread
        No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_submission_as_unread_courses_with_http_info(course_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_submission_as_unread_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_submission_as_unread_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `mark_submission_as_unread_courses`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `mark_submission_as_unread_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_submission_as_unread_sections
    def mark_submission_as_unread_sections(self, section_id, assignment_id, user_id, **kwargs):
        """
        Mark submission as unread
        No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_submission_as_unread_sections_with_http_info(section_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_submission_as_unread_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `mark_submission_as_unread_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `mark_submission_as_unread_sections`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `mark_submission_as_unread_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/{user_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: submit_assignment_courses
    def submit_assignment_courses(self, course_id, assignment_id, submission_submission_type, **kwargs):
        """
        Submit an assignment
        Make a submission for an assignment. You must be enrolled as a student in the course/section to do this.  All online turn-in submission types are supported in this API. However, there are a few things that are not yet supported:  * Files can be submitted based on a file ID of a user or group file. However, there is no API yet for listing the user and group files, or uploading new files via the API. A file upload API is coming soon. * Media comments can be submitted, however, there is no API yet for creating a media comment to submit. * Integration with Google Docs is not yet supported.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_assignment_courses_with_http_info(course_id, assignment_id, submission_submission_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str submission_submission_type: The type of submission being made. The assignment submission_types must include this submission type as an allowed option, or the submission will be rejected with a 400 error.  The submission_type given determines which of the following parameters is used. For instance, to submit a URL, submission [submission_type] must be set to \"online_url\", otherwise the submission [url] parameter will be ignored. (required)
        :param str comment_text_comment: Include a textual comment with the submission.
        :param str submission_body: Submit the assignment as an HTML document snippet. Note this HTML snippet will be sanitized using the same ruleset as a submission made from the Canvas web UI. The sanitized HTML will be returned in the response as the submission body. Requires a submission_type of \"online_text_entry\".
        :param str submission_url: Submit the assignment as a URL. The URL scheme must be \"http\" or \"https\", no \"ftp\" or other URL schemes are allowed. If no scheme is given (e.g. \"www.example.com\") then \"http\" will be assumed. Requires a submission_type of \"online_url\".
        :param list[int] submission_file_ids: Submit the assignment as a set of one or more previously uploaded files residing in the submitting user's files section (or the group's files section, for group assignments).  To upload a new file to submit, see the submissions {api:SubmissionsApiController#create_file Upload a file API}.  Requires a submission_type of \"online_upload\".
        :param str submission_media_comment_id: The media comment id to submit. Media comment ids can be submitted via this API, however, note that there is not yet an API to generate or list existing media comments, so this functionality is currently of limited use.  Requires a submission_type of \"media_recording\".
        :param str submission_media_comment_type: The type of media comment being submitted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'submission_submission_type', 'comment_text_comment', 'submission_body', 'submission_url', 'submission_file_ids', 'submission_media_comment_id', 'submission_media_comment_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_assignment_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `submit_assignment_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `submit_assignment_courses`")
        # verify the required parameter 'submission_submission_type' is set
        if ('submission_submission_type' not in params) or (params['submission_submission_type'] is None):
            raise ValueError("Missing the required parameter `submission_submission_type` when calling `submit_assignment_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'comment_text_comment' in params:
            form_params.append(('comment[text_comment]', params['comment_text_comment']))
        if 'submission_submission_type' in params:
            form_params.append(('submission[submission_type]', params['submission_submission_type']))
        if 'submission_body' in params:
            form_params.append(('submission[body]', params['submission_body']))
        if 'submission_url' in params:
            form_params.append(('submission[url]', params['submission_url']))
        if 'submission_file_ids' in params:
            form_params.append(('submission[file_ids]', params['submission_file_ids']))
        if 'submission_media_comment_id' in params:
            form_params.append(('submission[media_comment_id]', params['submission_media_comment_id']))
        if 'submission_media_comment_type' in params:
            form_params.append(('submission[media_comment_type]', params['submission_media_comment_type']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: submit_assignment_sections
    def submit_assignment_sections(self, section_id, assignment_id, submission_submission_type, **kwargs):
        """
        Submit an assignment
        Make a submission for an assignment. You must be enrolled as a student in the course/section to do this.  All online turn-in submission types are supported in this API. However, there are a few things that are not yet supported:  * Files can be submitted based on a file ID of a user or group file. However, there is no API yet for listing the user and group files, or uploading new files via the API. A file upload API is coming soon. * Media comments can be submitted, however, there is no API yet for creating a media comment to submit. * Integration with Google Docs is not yet supported.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_assignment_sections_with_http_info(section_id, assignment_id, submission_submission_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str submission_submission_type: The type of submission being made. The assignment submission_types must include this submission type as an allowed option, or the submission will be rejected with a 400 error.  The submission_type given determines which of the following parameters is used. For instance, to submit a URL, submission [submission_type] must be set to \"online_url\", otherwise the submission [url] parameter will be ignored. (required)
        :param str comment_text_comment: Include a textual comment with the submission.
        :param str submission_body: Submit the assignment as an HTML document snippet. Note this HTML snippet will be sanitized using the same ruleset as a submission made from the Canvas web UI. The sanitized HTML will be returned in the response as the submission body. Requires a submission_type of \"online_text_entry\".
        :param str submission_url: Submit the assignment as a URL. The URL scheme must be \"http\" or \"https\", no \"ftp\" or other URL schemes are allowed. If no scheme is given (e.g. \"www.example.com\") then \"http\" will be assumed. Requires a submission_type of \"online_url\".
        :param list[int] submission_file_ids: Submit the assignment as a set of one or more previously uploaded files residing in the submitting user's files section (or the group's files section, for group assignments).  To upload a new file to submit, see the submissions {api:SubmissionsApiController#create_file Upload a file API}.  Requires a submission_type of \"online_upload\".
        :param str submission_media_comment_id: The media comment id to submit. Media comment ids can be submitted via this API, however, note that there is not yet an API to generate or list existing media comments, so this functionality is currently of limited use.  Requires a submission_type of \"media_recording\".
        :param str submission_media_comment_type: The type of media comment being submitted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'submission_submission_type', 'comment_text_comment', 'submission_body', 'submission_url', 'submission_file_ids', 'submission_media_comment_id', 'submission_media_comment_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_assignment_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `submit_assignment_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `submit_assignment_sections`")
        # verify the required parameter 'submission_submission_type' is set
        if ('submission_submission_type' not in params) or (params['submission_submission_type'] is None):
            raise ValueError("Missing the required parameter `submission_submission_type` when calling `submit_assignment_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'comment_text_comment' in params:
            form_params.append(('comment[text_comment]', params['comment_text_comment']))
        if 'submission_submission_type' in params:
            form_params.append(('submission[submission_type]', params['submission_submission_type']))
        if 'submission_body' in params:
            form_params.append(('submission[body]', params['submission_body']))
        if 'submission_url' in params:
            form_params.append(('submission[url]', params['submission_url']))
        if 'submission_file_ids' in params:
            form_params.append(('submission[file_ids]', params['submission_file_ids']))
        if 'submission_media_comment_id' in params:
            form_params.append(('submission[media_comment_id]', params['submission_media_comment_id']))
        if 'submission_media_comment_type' in params:
            form_params.append(('submission[media_comment_type]', params['submission_media_comment_type']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: upload_file_courses
    def upload_file_courses(self, course_id, assignment_id, user_id, **kwargs):
        """
        Upload a file
        Upload a file to a submission.  This API endpoint is the first step in uploading a file to a submission as a student. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.  The final step of the file upload workflow will return the attachment data, including the new file id. The caller can then POST to submit the +online_upload+ assignment with these file ids.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_courses_with_http_info(course_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `upload_file_courses`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `upload_file_courses`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `upload_file_courses`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}/files'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: upload_file_sections
    def upload_file_sections(self, section_id, assignment_id, user_id, **kwargs):
        """
        Upload a file
        Upload a file to a submission.  This API endpoint is the first step in uploading a file to a submission as a student. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.  The final step of the file upload workflow will return the attachment data, including the new file id. The caller can then POST to submit the +online_upload+ assignment with these file ids.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_sections_with_http_info(section_id, assignment_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str assignment_id: ID (required)
        :param str user_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'assignment_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `upload_file_sections`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `upload_file_sections`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `upload_file_sections`")

        resource_path = '/v1/sections/{section_id}/assignments/{assignment_id}/submissions/{user_id}/files'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
