# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class SisimportsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: get_sis_import_list
    def get_sis_import_list(self, account_id, **kwargs):
        """
        Get SIS import list
        Returns the list of SIS imports for an account  Example:   curl 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports' \\     -H \"Authorization: Bearer <token>\"

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sis_import_list_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param Object created_since: If set, only shows imports created after the specified date (use ISO8601 format)
        :return: list[SisImport]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'created_since']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sis_import_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_sis_import_list`")

        resource_path = '/v1/accounts/{account_id}/sis_imports'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'created_since' in params:
            query_params['created_since'] = params['created_since']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SisImport]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_sis_import_status
    def get_sis_import_status(self, account_id, id, **kwargs):
        """
        Get SIS import status
        Get the status of an already created SIS import.    Examples:     curl 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports/<sis_import_id>' \\         -H \"Authorization: Bearer <token>\"

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sis_import_status_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: SisImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sis_import_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_sis_import_status`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sis_import_status`")

        resource_path = '/v1/accounts/{account_id}/sis_imports/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SisImport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: import_sis_data
    def import_sis_data(self, account_id, **kwargs):
        """
        Import SIS data
        Import SIS data into Canvas. Must be on a root account with SIS imports enabled.  For more information on the format that's expected here, please see the \"SIS CSV\" section in the API docs.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_sis_data_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str import_type: Choose the data format for reading SIS data. With a standard Canvas install, this option can only be 'instructure_csv', and if unprovided, will be assumed to be so. Can be part of the query string.
        :param str attachment: There are two ways to post SIS import data - either via a multipart/form-data form-field-style attachment, or via a non-multipart raw post request. 'attachment' is required for multipart/form-data style posts. Assumed to be SIS data from a file upload form field named 'attachment'. Examples: curl -F attachment=@<filename> -H \"Authorization: Bearer <token>\" \\ 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports.json?import_type=instructure_csv' If you decide to do a raw post, you can skip the 'attachment' argument, but you will then be required to provide a suitable Content-Type header. You are encouraged to also provide the 'extension' argument. Examples: curl -H 'Content-Type: application/octet-stream' --data-binary @<filename>.zip \\ -H \"Authorization: Bearer <token>\" \\ 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports.json?import_type=instructure_csv&extension=zip' curl -H 'Content-Type: application/zip' --data-binary @<filename>.zip \\ -H \"Authorization: Bearer <token>\" \\ 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports.json?import_type=instructure_csv' curl -H 'Content-Type: text/csv' --data-binary @<filename>.csv \\ -H \"Authorization: Bearer <token>\" \\ 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports.json?import_type=instructure_csv' curl -H 'Content-Type: text/csv' --data-binary @<filename>.csv \\ -H \"Authorization: Bearer <token>\" \\ 'https://<canvas>/api/v1/accounts/<account_id>/sis_imports.json?import_type=instructure_csv&batch_mode=1&batch_mode_term_id=15'
        :param str extension: Recommended for raw post request style imports. This field will be used to distinguish between zip, xml, csv, and other file format extensions that would usually be provided with the filename in the multipart post request scenario. If not provided, this value will be inferred from the Content-Type, falling back to zip-file format if all else fails.
        :param bool batch_mode: If set, this SIS import will be run in batch mode, deleting any data previously imported via SIS that is not present in this latest import. See the SIS CSV Format page for details.
        :param str batch_mode_term_id: Limit deletions to only this term. Required if batch mode is enabled.
        :param bool override_sis_stickiness: Many fields on records in Canvas can be marked \"sticky,\" which means that when something changes in the UI apart from the SIS, that field gets \"stuck.\" In this way, by default, SIS imports do not override UI changes. If this field is present, however, it will tell the SIS import to ignore \"stickiness\" and override all fields.
        :param bool add_sis_stickiness: This option, if present, will process all changes as if they were UI changes. This means that \"stickiness\" will be added to changed fields. This option is only processed if 'override_sis_stickiness' is also provided.
        :param bool clear_sis_stickiness: This option, if present, will clear \"stickiness\" from all fields touched by this import. Requires that 'override_sis_stickiness' is also provided. If 'add_sis_stickiness' is also provided, 'clear_sis_stickiness' will overrule the behavior of 'add_sis_stickiness'
        :param str diffing_data_set_identifier: If set on a CSV import, Canvas will attempt to optimize the SIS import by comparing this set of CSVs to the previous set that has the same data set identifier, and only appliying the difference between the two. See the SIS CSV Format documentation for more details.
        :param bool diffing_remaster_data_set: If true, and diffing_data_set_identifier is sent, this SIS import will be part of the data set, but diffing will not be performed. See the SIS CSV Format documentation for details.
        :return: SisImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'import_type', 'attachment', 'extension', 'batch_mode', 'batch_mode_term_id', 'override_sis_stickiness', 'add_sis_stickiness', 'clear_sis_stickiness', 'diffing_data_set_identifier', 'diffing_remaster_data_set']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_sis_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `import_sis_data`")

        resource_path = '/v1/accounts/{account_id}/sis_imports'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'import_type' in params:
            form_params.append(('import_type', params['import_type']))
        if 'attachment' in params:
            form_params.append(('attachment', params['attachment']))
        if 'extension' in params:
            form_params.append(('extension', params['extension']))
        if 'batch_mode' in params:
            form_params.append(('batch_mode', params['batch_mode']))
        if 'batch_mode_term_id' in params:
            form_params.append(('batch_mode_term_id', params['batch_mode_term_id']))
        if 'override_sis_stickiness' in params:
            form_params.append(('override_sis_stickiness', params['override_sis_stickiness']))
        if 'add_sis_stickiness' in params:
            form_params.append(('add_sis_stickiness', params['add_sis_stickiness']))
        if 'clear_sis_stickiness' in params:
            form_params.append(('clear_sis_stickiness', params['clear_sis_stickiness']))
        if 'diffing_data_set_identifier' in params:
            form_params.append(('diffing_data_set_identifier', params['diffing_data_set_identifier']))
        if 'diffing_remaster_data_set' in params:
            form_params.append(('diffing_remaster_data_set', params['diffing_remaster_data_set']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SisImport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
