# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Section(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, sis_section_id=None, integration_id=None, sis_import_id=None, course_id=None, sis_course_id=None, start_at=None, end_at=None, nonxlist_course_id=None, total_students=None):
        """
        Section - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'sis_section_id': 'str',
            'integration_id': 'str',
            'sis_import_id': 'int',
            'course_id': 'int',
            'sis_course_id': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'nonxlist_course_id': 'int',
            'total_students': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'sis_section_id': 'sis_section_id',
            'integration_id': 'integration_id',
            'sis_import_id': 'sis_import_id',
            'course_id': 'course_id',
            'sis_course_id': 'sis_course_id',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'nonxlist_course_id': 'nonxlist_course_id',
            'total_students': 'total_students'
        }

        self._id = id
        self._name = name
        self._sis_section_id = sis_section_id
        self._integration_id = integration_id
        self._sis_import_id = sis_import_id
        self._course_id = course_id
        self._sis_course_id = sis_course_id
        self._start_at = start_at
        self._end_at = end_at
        self._nonxlist_course_id = nonxlist_course_id
        self._total_students = total_students

    @property
    def id(self):
        """
        Gets the id of this Section.
        The unique identifier for the section.

        :return: The id of this Section.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Section.
        The unique identifier for the section.

        :param id: The id of this Section.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Section.
        The name of the section.

        :return: The name of this Section.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Section.
        The name of the section.

        :param name: The name of this Section.
        :type: str
        """

        self._name = name

    @property
    def sis_section_id(self):
        """
        Gets the sis_section_id of this Section.
        The sis id of the section. This field is only included if the user has permission to view SIS information.

        :return: The sis_section_id of this Section.
        :rtype: str
        """
        return self._sis_section_id

    @sis_section_id.setter
    def sis_section_id(self, sis_section_id):
        """
        Sets the sis_section_id of this Section.
        The sis id of the section. This field is only included if the user has permission to view SIS information.

        :param sis_section_id: The sis_section_id of this Section.
        :type: str
        """

        self._sis_section_id = sis_section_id

    @property
    def integration_id(self):
        """
        Gets the integration_id of this Section.
        Optional: The integration ID of the section. This field is only included if the user has permission to view SIS information.

        :return: The integration_id of this Section.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """
        Sets the integration_id of this Section.
        Optional: The integration ID of the section. This field is only included if the user has permission to view SIS information.

        :param integration_id: The integration_id of this Section.
        :type: str
        """

        self._integration_id = integration_id

    @property
    def sis_import_id(self):
        """
        Gets the sis_import_id of this Section.
        The unique identifier for the SIS import if created through SIS. This field is only included if the user has permission to manage SIS information.

        :return: The sis_import_id of this Section.
        :rtype: int
        """
        return self._sis_import_id

    @sis_import_id.setter
    def sis_import_id(self, sis_import_id):
        """
        Sets the sis_import_id of this Section.
        The unique identifier for the SIS import if created through SIS. This field is only included if the user has permission to manage SIS information.

        :param sis_import_id: The sis_import_id of this Section.
        :type: int
        """

        self._sis_import_id = sis_import_id

    @property
    def course_id(self):
        """
        Gets the course_id of this Section.
        The unique Canvas identifier for the course in which the section belongs

        :return: The course_id of this Section.
        :rtype: int
        """
        return self._course_id

    @course_id.setter
    def course_id(self, course_id):
        """
        Sets the course_id of this Section.
        The unique Canvas identifier for the course in which the section belongs

        :param course_id: The course_id of this Section.
        :type: int
        """

        self._course_id = course_id

    @property
    def sis_course_id(self):
        """
        Gets the sis_course_id of this Section.
        The unique SIS identifier for the course in which the section belongs. This field is only included if the user has permission to view SIS information.

        :return: The sis_course_id of this Section.
        :rtype: str
        """
        return self._sis_course_id

    @sis_course_id.setter
    def sis_course_id(self, sis_course_id):
        """
        Sets the sis_course_id of this Section.
        The unique SIS identifier for the course in which the section belongs. This field is only included if the user has permission to view SIS information.

        :param sis_course_id: The sis_course_id of this Section.
        :type: str
        """

        self._sis_course_id = sis_course_id

    @property
    def start_at(self):
        """
        Gets the start_at of this Section.
        the start date for the section, if applicable

        :return: The start_at of this Section.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this Section.
        the start date for the section, if applicable

        :param start_at: The start_at of this Section.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this Section.
        the end date for the section, if applicable

        :return: The end_at of this Section.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this Section.
        the end date for the section, if applicable

        :param end_at: The end_at of this Section.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def nonxlist_course_id(self):
        """
        Gets the nonxlist_course_id of this Section.
        The unique identifier of the original course of a cross-listed section

        :return: The nonxlist_course_id of this Section.
        :rtype: int
        """
        return self._nonxlist_course_id

    @nonxlist_course_id.setter
    def nonxlist_course_id(self, nonxlist_course_id):
        """
        Sets the nonxlist_course_id of this Section.
        The unique identifier of the original course of a cross-listed section

        :param nonxlist_course_id: The nonxlist_course_id of this Section.
        :type: int
        """

        self._nonxlist_course_id = nonxlist_course_id

    @property
    def total_students(self):
        """
        Gets the total_students of this Section.
        optional: the total number of active and invited students in the section

        :return: The total_students of this Section.
        :rtype: int
        """
        return self._total_students

    @total_students.setter
    def total_students(self, total_students):
        """
        Sets the total_students of this Section.
        optional: the total number of active and invited students in the section

        :param total_students: The total_students of this Section.
        :type: int
        """

        self._total_students = total_students

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
