# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class RolePermissions(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, enabled=None, locked=None, readonly=None, explicit=None, prior_default=None):
        """
        RolePermissions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'locked': 'bool',
            'readonly': 'bool',
            'explicit': 'bool',
            'prior_default': 'bool'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'locked': 'locked',
            'readonly': 'readonly',
            'explicit': 'explicit',
            'prior_default': 'prior_default'
        }

        self._enabled = enabled
        self._locked = locked
        self._readonly = readonly
        self._explicit = explicit
        self._prior_default = prior_default

    @property
    def enabled(self):
        """
        Gets the enabled of this RolePermissions.
        Whether the role has the permission

        :return: The enabled of this RolePermissions.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this RolePermissions.
        Whether the role has the permission

        :param enabled: The enabled of this RolePermissions.
        :type: bool
        """

        self._enabled = enabled

    @property
    def locked(self):
        """
        Gets the locked of this RolePermissions.
        Whether the permission is locked by this role

        :return: The locked of this RolePermissions.
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """
        Sets the locked of this RolePermissions.
        Whether the permission is locked by this role

        :param locked: The locked of this RolePermissions.
        :type: bool
        """

        self._locked = locked

    @property
    def readonly(self):
        """
        Gets the readonly of this RolePermissions.
        Whether the permission can be modified in this role (i.e. whether the permission is locked by an upstream role).

        :return: The readonly of this RolePermissions.
        :rtype: bool
        """
        return self._readonly

    @readonly.setter
    def readonly(self, readonly):
        """
        Sets the readonly of this RolePermissions.
        Whether the permission can be modified in this role (i.e. whether the permission is locked by an upstream role).

        :param readonly: The readonly of this RolePermissions.
        :type: bool
        """

        self._readonly = readonly

    @property
    def explicit(self):
        """
        Gets the explicit of this RolePermissions.
        Whether the value of enabled is specified explicitly by this role, or inherited from an upstream role.

        :return: The explicit of this RolePermissions.
        :rtype: bool
        """
        return self._explicit

    @explicit.setter
    def explicit(self, explicit):
        """
        Sets the explicit of this RolePermissions.
        Whether the value of enabled is specified explicitly by this role, or inherited from an upstream role.

        :param explicit: The explicit of this RolePermissions.
        :type: bool
        """

        self._explicit = explicit

    @property
    def prior_default(self):
        """
        Gets the prior_default of this RolePermissions.
        The value that would have been inherited from upstream if the role had not explicitly set a value. Only present if explicit is true.

        :return: The prior_default of this RolePermissions.
        :rtype: bool
        """
        return self._prior_default

    @prior_default.setter
    def prior_default(self, prior_default):
        """
        Sets the prior_default of this RolePermissions.
        The value that would have been inherited from upstream if the role had not explicitly set a value. Only present if explicit is true.

        :param prior_default: The prior_default of this RolePermissions.
        :type: bool
        """

        self._prior_default = prior_default

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
