# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class QuizzesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_quiz
    def create_quiz(self, course_id, quiz_title, **kwargs):
        """
        Create a quiz
        Create a new quiz for this course.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_quiz_with_http_info(course_id, quiz_title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_title: The quiz title. (required)
        :param str quiz_description: A description of the quiz.
        :param str quiz_quiz_type: The type of quiz.
        :param int quiz_assignment_group_id: The assignment group id to put the assignment in. Defaults to the top assignment group in the course. Only valid if the quiz is graded, i.e. if quiz_type is \"assignment\" or \"graded_survey\".
        :param int quiz_time_limit: Time limit to take this quiz, in minutes. Set to null for no time limit. Defaults to null.
        :param bool quiz_shuffle_answers: If true, quiz answers for multiple choice questions will be randomized for each student. Defaults to false.
        :param str quiz_hide_results: Dictates whether or not quiz results are hidden from students. If null, students can see their results after any attempt. If \"always\", students can never see their results. If \"until_after_last_attempt\", students can only see results after their last attempt. (Only valid if allowed_attempts > 1). Defaults to null.
        :param bool quiz_show_correct_answers: Only valid if hide_results=null If false, hides correct answers from students when quiz results are viewed. Defaults to true.
        :param bool quiz_show_correct_answers_last_attempt: Only valid if show_correct_answers=true and allowed_attempts > 1 If true, hides correct answers from students when quiz results are viewed until they submit the last attempt for the quiz. Defaults to false.
        :param Object quiz_show_correct_answers_at: Only valid if show_correct_answers=true If set, the correct answers will be visible by students only after this date, otherwise the correct answers are visible once the student hands in their quiz submission.
        :param Object quiz_hide_correct_answers_at: Only valid if show_correct_answers=true If set, the correct answers will stop being visible once this date has passed. Otherwise, the correct answers will be visible indefinitely.
        :param int quiz_allowed_attempts: Number of times a student is allowed to take a quiz. Set to -1 for unlimited attempts. Defaults to 1.
        :param str quiz_scoring_policy: Required and only valid if allowed_attempts > 1. Scoring policy for a quiz that students can take multiple times. Defaults to \"keep_highest\".
        :param bool quiz_one_question_at_a_time: If true, shows quiz to student one question at a time. Defaults to false.
        :param bool quiz_cant_go_back: Only valid if one_question_at_a_time=true If true, questions are locked after answering. Defaults to false.
        :param str quiz_access_code: Restricts access to the quiz with a password. For no access code restriction, set to null. Defaults to null.
        :param str quiz_ip_filter: Restricts access to the quiz to computers in a specified IP range. Filters can be a comma-separated list of addresses, or an address followed by a mask Examples: \"192.168.217.1\" \"192.168.217.1/24\" \"192.168.217.1/255.255.255.0\" For no IP filter restriction, set to null. Defaults to null.
        :param Object quiz_due_at: The day/time the quiz is due. Accepts times in ISO 8601 format, e.g. 2011-10-21T18:48Z.
        :param Object quiz_lock_at: The day/time the quiz is locked for students. Accepts times in ISO 8601 format, e.g. 2011-10-21T18:48Z.
        :param Object quiz_unlock_at: The day/time the quiz is unlocked for students. Accepts times in ISO 8601 format, e.g. 2011-10-21T18:48Z.
        :param bool quiz_published: Whether the quiz should have a draft state of published or unpublished. NOTE: If students have started taking the quiz, or there are any submissions for the quiz, you may not unpublish a quiz and will recieve an error.
        :param bool quiz_one_time_results: Whether students should be prevented from viewing their quiz results past the first time (right after they turn the quiz in.) Only valid if \"hide_results\" is not set to \"always\". Defaults to false.
        :return: Quiz
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_title', 'quiz_description', 'quiz_quiz_type', 'quiz_assignment_group_id', 'quiz_time_limit', 'quiz_shuffle_answers', 'quiz_hide_results', 'quiz_show_correct_answers', 'quiz_show_correct_answers_last_attempt', 'quiz_show_correct_answers_at', 'quiz_hide_correct_answers_at', 'quiz_allowed_attempts', 'quiz_scoring_policy', 'quiz_one_question_at_a_time', 'quiz_cant_go_back', 'quiz_access_code', 'quiz_ip_filter', 'quiz_due_at', 'quiz_lock_at', 'quiz_unlock_at', 'quiz_published', 'quiz_one_time_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quiz" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_quiz`")
        # verify the required parameter 'quiz_title' is set
        if ('quiz_title' not in params) or (params['quiz_title'] is None):
            raise ValueError("Missing the required parameter `quiz_title` when calling `create_quiz`")

        resource_path = '/v1/courses/{course_id}/quizzes'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'quiz_title' in params:
            form_params.append(('quiz[title]', params['quiz_title']))
        if 'quiz_description' in params:
            form_params.append(('quiz[description]', params['quiz_description']))
        if 'quiz_quiz_type' in params:
            form_params.append(('quiz[quiz_type]', params['quiz_quiz_type']))
        if 'quiz_assignment_group_id' in params:
            form_params.append(('quiz[assignment_group_id]', params['quiz_assignment_group_id']))
        if 'quiz_time_limit' in params:
            form_params.append(('quiz[time_limit]', params['quiz_time_limit']))
        if 'quiz_shuffle_answers' in params:
            form_params.append(('quiz[shuffle_answers]', params['quiz_shuffle_answers']))
        if 'quiz_hide_results' in params:
            form_params.append(('quiz[hide_results]', params['quiz_hide_results']))
        if 'quiz_show_correct_answers' in params:
            form_params.append(('quiz[show_correct_answers]', params['quiz_show_correct_answers']))
        if 'quiz_show_correct_answers_last_attempt' in params:
            form_params.append(('quiz[show_correct_answers_last_attempt]', params['quiz_show_correct_answers_last_attempt']))
        if 'quiz_show_correct_answers_at' in params:
            form_params.append(('quiz[show_correct_answers_at]', params['quiz_show_correct_answers_at']))
        if 'quiz_hide_correct_answers_at' in params:
            form_params.append(('quiz[hide_correct_answers_at]', params['quiz_hide_correct_answers_at']))
        if 'quiz_allowed_attempts' in params:
            form_params.append(('quiz[allowed_attempts]', params['quiz_allowed_attempts']))
        if 'quiz_scoring_policy' in params:
            form_params.append(('quiz[scoring_policy]', params['quiz_scoring_policy']))
        if 'quiz_one_question_at_a_time' in params:
            form_params.append(('quiz[one_question_at_a_time]', params['quiz_one_question_at_a_time']))
        if 'quiz_cant_go_back' in params:
            form_params.append(('quiz[cant_go_back]', params['quiz_cant_go_back']))
        if 'quiz_access_code' in params:
            form_params.append(('quiz[access_code]', params['quiz_access_code']))
        if 'quiz_ip_filter' in params:
            form_params.append(('quiz[ip_filter]', params['quiz_ip_filter']))
        if 'quiz_due_at' in params:
            form_params.append(('quiz[due_at]', params['quiz_due_at']))
        if 'quiz_lock_at' in params:
            form_params.append(('quiz[lock_at]', params['quiz_lock_at']))
        if 'quiz_unlock_at' in params:
            form_params.append(('quiz[unlock_at]', params['quiz_unlock_at']))
        if 'quiz_published' in params:
            form_params.append(('quiz[published]', params['quiz_published']))
        if 'quiz_one_time_results' in params:
            form_params.append(('quiz[one_time_results]', params['quiz_one_time_results']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Quiz',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_quiz
    def delete_quiz(self, course_id, id, **kwargs):
        """
        Delete a quiz
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quiz_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: Quiz
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quiz" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_quiz`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_quiz`")

        resource_path = '/v1/courses/{course_id}/quizzes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Quiz',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: edit_quiz
    def edit_quiz(self, course_id, id, **kwargs):
        """
        Edit a quiz
        Modify an existing quiz. See the documentation for quiz creation.  Additional arguments:

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_quiz_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param bool quiz_notify_of_update: If true, notifies users that the quiz has changed. Defaults to true
        :return: Quiz
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'quiz_notify_of_update']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_quiz" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `edit_quiz`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `edit_quiz`")

        resource_path = '/v1/courses/{course_id}/quizzes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'quiz_notify_of_update' in params:
            form_params.append(('quiz[notify_of_update]', params['quiz_notify_of_update']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Quiz',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_quiz
    def get_single_quiz(self, course_id, id, **kwargs):
        """
        Get a single quiz
        Returns the quiz with the given id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_quiz_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: Quiz
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_quiz" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_quiz`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_quiz`")

        resource_path = '/v1/courses/{course_id}/quizzes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Quiz',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_quizzes_in_course
    def list_quizzes_in_course(self, course_id, **kwargs):
        """
        List quizzes in a course
        Returns the list of Quizzes in this course.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_quizzes_in_course_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str search_term: The partial title of the quizzes to match and return.
        :return: list[Quiz]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'search_term']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quizzes_in_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_quizzes_in_course`")

        resource_path = '/v1/courses/{course_id}/quizzes'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Quiz]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reorder_quiz_items
    def reorder_quiz_items(self, course_id, id, order_id, **kwargs):
        """
        Reorder quiz items
        Change order of the quiz questions or groups within the quiz  <b>204 No Content</b> response code is returned if the reorder was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reorder_quiz_items_with_http_info(course_id, id, order_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param list[int] order_id: The associated item's unique identifier (required)
        :param list[str] order_type: The type of item is either 'question' or 'group'
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'order_id', 'order_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reorder_quiz_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `reorder_quiz_items`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `reorder_quiz_items`")
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params) or (params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `reorder_quiz_items`")

        resource_path = '/v1/courses/{course_id}/quizzes/{id}/reorder'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'order_id' in params:
            form_params.append(('order[id]', params['order_id']))
        if 'order_type' in params:
            form_params.append(('order[type]', params['order_type']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
