# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizIPFilter(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, account=None, filter=None):
        """
        QuizIPFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'account': 'str',
            'filter': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'account': 'account',
            'filter': 'filter'
        }

        self._name = name
        self._account = account
        self._filter = filter

    @property
    def name(self):
        """
        Gets the name of this QuizIPFilter.
        A unique name for the filter.

        :return: The name of this QuizIPFilter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QuizIPFilter.
        A unique name for the filter.

        :param name: The name of this QuizIPFilter.
        :type: str
        """

        self._name = name

    @property
    def account(self):
        """
        Gets the account of this QuizIPFilter.
        Name of the Account (or Quiz) the IP filter is defined in.

        :return: The account of this QuizIPFilter.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this QuizIPFilter.
        Name of the Account (or Quiz) the IP filter is defined in.

        :param account: The account of this QuizIPFilter.
        :type: str
        """

        self._account = account

    @property
    def filter(self):
        """
        Gets the filter of this QuizIPFilter.
        An IP address (or range mask) this filter embodies.

        :return: The filter of this QuizIPFilter.
        :rtype: str
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """
        Sets the filter of this QuizIPFilter.
        An IP address (or range mask) this filter embodies.

        :param filter: The filter of this QuizIPFilter.
        :type: str
        """

        self._filter = filter

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
