# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizExtension(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, quiz_id=None, user_id=None, extra_attempts=None, extra_time=None, manually_unlocked=None, end_at=None):
        """
        QuizExtension - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'quiz_id': 'int',
            'user_id': 'int',
            'extra_attempts': 'int',
            'extra_time': 'int',
            'manually_unlocked': 'bool',
            'end_at': 'datetime'
        }

        self.attribute_map = {
            'quiz_id': 'quiz_id',
            'user_id': 'user_id',
            'extra_attempts': 'extra_attempts',
            'extra_time': 'extra_time',
            'manually_unlocked': 'manually_unlocked',
            'end_at': 'end_at'
        }

        self._quiz_id = quiz_id
        self._user_id = user_id
        self._extra_attempts = extra_attempts
        self._extra_time = extra_time
        self._manually_unlocked = manually_unlocked
        self._end_at = end_at

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizExtension.
        The ID of the Quiz the quiz extension belongs to.

        :return: The quiz_id of this QuizExtension.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizExtension.
        The ID of the Quiz the quiz extension belongs to.

        :param quiz_id: The quiz_id of this QuizExtension.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def user_id(self):
        """
        Gets the user_id of this QuizExtension.
        The ID of the Student that needs the quiz extension.

        :return: The user_id of this QuizExtension.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this QuizExtension.
        The ID of the Student that needs the quiz extension.

        :param user_id: The user_id of this QuizExtension.
        :type: int
        """

        self._user_id = user_id

    @property
    def extra_attempts(self):
        """
        Gets the extra_attempts of this QuizExtension.
        Number of times the student is allowed to re-take the quiz over the multiple-attempt limit.

        :return: The extra_attempts of this QuizExtension.
        :rtype: int
        """
        return self._extra_attempts

    @extra_attempts.setter
    def extra_attempts(self, extra_attempts):
        """
        Sets the extra_attempts of this QuizExtension.
        Number of times the student is allowed to re-take the quiz over the multiple-attempt limit.

        :param extra_attempts: The extra_attempts of this QuizExtension.
        :type: int
        """

        self._extra_attempts = extra_attempts

    @property
    def extra_time(self):
        """
        Gets the extra_time of this QuizExtension.
        Amount of extra time allowed for the quiz submission, in minutes.

        :return: The extra_time of this QuizExtension.
        :rtype: int
        """
        return self._extra_time

    @extra_time.setter
    def extra_time(self, extra_time):
        """
        Sets the extra_time of this QuizExtension.
        Amount of extra time allowed for the quiz submission, in minutes.

        :param extra_time: The extra_time of this QuizExtension.
        :type: int
        """

        self._extra_time = extra_time

    @property
    def manually_unlocked(self):
        """
        Gets the manually_unlocked of this QuizExtension.
        The student can take the quiz even if it's locked for everyone else

        :return: The manually_unlocked of this QuizExtension.
        :rtype: bool
        """
        return self._manually_unlocked

    @manually_unlocked.setter
    def manually_unlocked(self, manually_unlocked):
        """
        Sets the manually_unlocked of this QuizExtension.
        The student can take the quiz even if it's locked for everyone else

        :param manually_unlocked: The manually_unlocked of this QuizExtension.
        :type: bool
        """

        self._manually_unlocked = manually_unlocked

    @property
    def end_at(self):
        """
        Gets the end_at of this QuizExtension.
        The time at which the quiz submission will be overdue, and be flagged as a late submission.

        :return: The end_at of this QuizExtension.
        :rtype: datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this QuizExtension.
        The time at which the quiz submission will be overdue, and be flagged as a late submission.

        :param end_at: The end_at of this QuizExtension.
        :type: datetime
        """

        self._end_at = end_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
