# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class PollSubmission(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, poll_choice_id=None, user_id=None, created_at=None):
        """
        PollSubmission - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'poll_choice_id': 'int',
            'user_id': 'int',
            'created_at': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'poll_choice_id': 'poll_choice_id',
            'user_id': 'user_id',
            'created_at': 'created_at'
        }

        self._id = id
        self._poll_choice_id = poll_choice_id
        self._user_id = user_id
        self._created_at = created_at

    @property
    def id(self):
        """
        Gets the id of this PollSubmission.
        The unique identifier for the poll submission.

        :return: The id of this PollSubmission.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PollSubmission.
        The unique identifier for the poll submission.

        :param id: The id of this PollSubmission.
        :type: int
        """

        self._id = id

    @property
    def poll_choice_id(self):
        """
        Gets the poll_choice_id of this PollSubmission.
        The unique identifier of the poll choice chosen for this submission.

        :return: The poll_choice_id of this PollSubmission.
        :rtype: int
        """
        return self._poll_choice_id

    @poll_choice_id.setter
    def poll_choice_id(self, poll_choice_id):
        """
        Sets the poll_choice_id of this PollSubmission.
        The unique identifier of the poll choice chosen for this submission.

        :param poll_choice_id: The poll_choice_id of this PollSubmission.
        :type: int
        """

        self._poll_choice_id = poll_choice_id

    @property
    def user_id(self):
        """
        Gets the user_id of this PollSubmission.
        the unique identifier of the user who submitted this poll submission.

        :return: The user_id of this PollSubmission.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this PollSubmission.
        the unique identifier of the user who submitted this poll submission.

        :param user_id: The user_id of this PollSubmission.
        :type: int
        """

        self._user_id = user_id

    @property
    def created_at(self):
        """
        Gets the created_at of this PollSubmission.
        The date and time the poll submission was submitted.

        :return: The created_at of this PollSubmission.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this PollSubmission.
        The date and time the poll submission was submitted.

        :param created_at: The created_at of this PollSubmission.
        :type: datetime
        """

        self._created_at = created_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
